// Copyright (C) 2007 - Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// disable it for now as tx_pma model has problem with it
`ifdef MODEL_TECH
`mti_v2k_int_delays_on
`endif

///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// Containing Verilog Model for the Atoms:                                   //
//                                                                           //
//                         arriaii_hssi_pll                                      //
//                         arriaii_hssi_clock_divider                            //
//                         arriaii_hssi_rx_pma                                   //
//                         arriaii_hssi_tx_pma                                   //
//                         arriaii_hssi_tx_pcs                                   //
//                         arriaii_hssi_rx_pcs                                   //
//                         arriaii_hssi_cmu                                      //
//                         arriaii_hssi_calibration_block                        //
//                         arriaii_hssi_refclk_divider                           //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////



`timescale 1 ps / 1 ps
module arriaii_hssi_aux_clock_div (
    clk,     // input clock
    reset,   // reset
    enable_d, // enable DPRIO
    d,        // division factor for DPRIO support
    clkout   // divided clock
);
input clk,reset;
input enable_d;
input [7:0] d;
output clkout;


parameter clk_divide_by  = 1;
parameter extra_latency  = 0;

integer clk_edges,m;
reg [2*extra_latency:0] div_n_register;
reg [7:0] d_factor_dly;
reg [31:0] clk_divide_value;

wire [7:0] d_factor;
wire int_reset;

initial
begin
    div_n_register = 'b0;
    clk_edges = -1;
    m = 0;
    d_factor_dly =  'b0;
    clk_divide_value = clk_divide_by;
end

assign d_factor = (enable_d === 1'b1) ? d : clk_divide_value[7:0];

always @(d_factor)
begin
    d_factor_dly <= d_factor;
end


// create a reset pulse when there is a change in the d_factor value
assign int_reset = (d_factor !== d_factor_dly) ? 1'b1 : 1'b0;

always @(posedge clk or negedge clk or posedge reset or posedge int_reset)
begin
    div_n_register <= {div_n_register, div_n_register[0]};

    if ((reset === 1'b1) || (int_reset === 1'b1)) 
    begin
        clk_edges = -1;
        div_n_register <= 'b0;
    end
    else
    begin
        if (clk_edges == -1) 
        begin
            div_n_register[0] <= clk;
            if (clk == 1'b1) clk_edges = 0;
        end
        else if (clk_edges % d_factor == 0) 
                div_n_register[0] <= ~div_n_register[0];
        if (clk_edges >= 0 || clk == 1'b1)
            clk_edges = (clk_edges + 1) % (2*d_factor) ;
    end
end

assign clkout = div_n_register[2*extra_latency];

endmodule


`timescale 1 ps / 1 ps

module arriaii_hssi_aux_clock_mult (
    clk,     // input clock
    fbclk,     // feedback clock
    adjust,  // adjust frequency
    adjust_without_lol,
    reset,   // reset
    enable_m, // enable DPRIO
    m,        // multiplication factor for DPRIO support
    clkout,  // multiplied clock
    busy     // state
);

input clk,fbclk,adjust,reset;
input adjust_without_lol;
input enable_m;
input [7:0] m; 

output[3:0] clkout;
output [1:0] busy;

parameter clk_multiply_by  = 1;
parameter pfd_fb_select = "internal";

`define HSSI_CLOCK_MULT_INITIAL 2'b01
`define HSSI_CLOCK_MULT_ACTIVE  2'b11
`define HSSI_CLOCK_MULT_INACTIVE  2'b00

integer clk_adjust;
integer clk_adjust_interval;
integer clk_adjust_running;
integer clk_fast_period;
integer clk_sync_period;
integer n;
integer phasedelay;
integer phase_adjust;

real last_rising_edge,clk_period;
real last_fb_rising_edge;

reg [1:0] busy;
reg  clk_adjust_settled;
reg  mult_n;
reg [3:0] clkout_reg;
reg [31:0] clk_multiply_value;
reg fb_select;

wire [7:0] m_factor;

initial
begin
    clk_multiply_value = clk_multiply_by;
end

assign m_factor = (enable_m === 1'b1) ? m : clk_multiply_value[7:0];

// At start of reconfiguration, set multiplier to reset state

always @(m_factor)
begin
    busy = `HSSI_CLOCK_MULT_INITIAL;
    last_rising_edge = 0;
    last_fb_rising_edge = 0;
    mult_n = 'b0;
    n = 0;
end

initial
begin
    busy = `HSSI_CLOCK_MULT_INITIAL;
    last_rising_edge = 0;
    last_fb_rising_edge = 0;
    mult_n = 'b0;
    n = 0;
    fb_select = alpha_tolower(pfd_fb_select) == "iqtxrxclk" ? 1'b1 : 1'b0;
end


always @(posedge fbclk) last_fb_rising_edge <= $realtime;

always @(posedge adjust) busy = `HSSI_CLOCK_MULT_INITIAL;

always @(posedge clk or posedge reset)
begin
    if (reset === 1'b1) 
    begin
        mult_n = 1'b0;
        busy = `HSSI_CLOCK_MULT_INITIAL;
    end
    else
    begin
        if (fb_select == 1'b0)
        begin
            if (busy == `HSSI_CLOCK_MULT_INITIAL && adjust_without_lol == 1'b0)             // first rising edge
            begin 
                mult_n = 1'b0;
                last_rising_edge = $realtime;
                busy = `HSSI_CLOCK_MULT_ACTIVE;
            end
            else 
            begin
                last_rising_edge <= $realtime;
                if (busy == `HSSI_CLOCK_MULT_INITIAL && adjust_without_lol == 1'b1)
                begin
                    mult_n = 1'b0;
                    busy = `HSSI_CLOCK_MULT_ACTIVE;
                end
                if (busy == `HSSI_CLOCK_MULT_ACTIVE)    // second rising edge
                begin
                    clk_period = $realtime - last_rising_edge;
                    clk_fast_period = clk_period/m_factor - 0.5;
                    clk_adjust = clk_period - clk_fast_period * m_factor;
                    busy = `HSSI_CLOCK_MULT_INACTIVE;
                end
                mult_n = ~mult_n;
                if (clk_adjust > 0) clk_adjust_running = clk_adjust + 1;
                clk_adjust_settled = (clk_adjust == 0);                    // if no adjustment necessary
                for (n = m_factor; n >= 1 ; n=n-1)
                begin
                    if (clk_adjust_settled == 1'b0) 
                    begin
                        clk_adjust_running = clk_adjust_running - 1;
                        clk_adjust_interval = n/clk_adjust_running;
                        if (n % clk_adjust_running == 0) 
                            clk_adjust_settled = 1'b1;
                        clk_sync_period = clk_fast_period + 1;       
                    end
                    else
                    begin
                        if (clk_adjust == 0)
                            clk_sync_period = clk_fast_period;
                        else
                        begin
                            if (n % clk_adjust_interval == 0) 
                                clk_sync_period = clk_fast_period + 1;     
                            else
                                clk_sync_period = clk_fast_period;
                        end
                    end
                    if (reset == 1'b1) mult_n = 1'b0;
                    else
                    begin
                        #(clk_sync_period/2) mult_n = ~mult_n; 
                        if (n > 1) #(clk_sync_period - clk_sync_period/2) mult_n = ~mult_n; 
                    end
                end
            end
        end
    else
        begin
            if (busy == `HSSI_CLOCK_MULT_INITIAL && adjust_without_lol == 1'b0)             // first rising edge
            begin 
                mult_n = 1'b0;
                last_rising_edge = $realtime;
                busy = `HSSI_CLOCK_MULT_ACTIVE;
            end
            else 
            begin
                last_rising_edge <= $realtime;
                if (busy == `HSSI_CLOCK_MULT_INITIAL && adjust_without_lol == 1'b1)
                begin
                    mult_n = 1'b0;
                    busy = `HSSI_CLOCK_MULT_ACTIVE;
                end
                if (busy == `HSSI_CLOCK_MULT_ACTIVE)    // second rising edge
                begin
                    clk_period = $realtime - last_rising_edge;
                    phase_adjust = $realtime - last_fb_rising_edge;
                    if (phase_adjust >= clk_period)
                        phase_adjust = 0;

                    clk_fast_period = clk_period/m_factor - 0.5;
                    clk_adjust = clk_period - clk_fast_period * m_factor;
                    if ((phase_adjust == 0) && (last_fb_rising_edge == last_rising_edge))
                        busy = `HSSI_CLOCK_MULT_INACTIVE;
                end
                mult_n = ~mult_n;
                if (clk_adjust > 0) 
                    clk_adjust_running = clk_adjust + 1;
                // if no adjustment necessary
                clk_adjust_settled = (clk_adjust == 0); 
                for (n = m_factor; n >= 1 ; n=n-1)
                begin
                    if (clk_adjust_settled == 1'b0) 
                    begin
                        clk_adjust_running = clk_adjust_running - 1;
                        clk_adjust_interval = n/clk_adjust_running;
                        if (n % clk_adjust_running == 0) 
                            clk_adjust_settled = 1'b1;
                        clk_sync_period = clk_fast_period + 1;       
                    end
                    else
                    begin
                        if (clk_adjust == 0)
                            clk_sync_period = clk_fast_period;
                        else
                        begin
                            if (n % clk_adjust_interval == 0) 
                                clk_sync_period = clk_fast_period + 1;     
                            else
                                clk_sync_period = clk_fast_period;
                        end
                    end
                    if (reset == 1'b1) mult_n = 1'b0;
                    else
                    begin
                        #(clk_sync_period/2) mult_n = ~mult_n; 
                        if (n > 1) #(clk_sync_period - clk_sync_period/2) mult_n = ~mult_n; 
                    end
                end
            end
        end
    end
end

//Generate four clkout with equally distributed phase

always @(mult_n)
begin
    if (fb_select == 1'b1)
        clkout_reg[0] <= #(phase_adjust) mult_n;
    else
        clkout_reg[0] <= mult_n;
end

always @(posedge clkout[0])
begin
    phasedelay = clk_fast_period/4;
end

always @(clkout[0])
begin
    clkout_reg[1] <= #(phasedelay) clkout[0];
    clkout_reg[2] <= ~clkout[0];
    clkout_reg[3] <= #(phasedelay) ~clkout[0];
end

assign clkout[0] = clkout_reg[0];
assign clkout[1] = clkout_reg[1];
assign clkout[2] = clkout_reg[2];
assign clkout[3] = clkout_reg[3];

endmodule

`timescale 1 ps / 1 ps

//------------------------------------------------------------------------------
//                  COPYRIGHT (c) 2007 ALTERA CORPORATION
//                            ALL RIGHTS RESERVED
//------------------------------------------------------------------------------

//====Revision Log================
//Rev: 1.9   Mon Mar 24 17:38:35 PDT 2008   cgaillar
//Needed to enhance implementation for correct behavior if first clock edge after reset is a falling edge
//====End Log======================

module arriaii_hssi_pma_c_divby2q (
   clk, clk0, clk90, clk180, clk270, clkb, rst_n, vcce_la, vssexqyx );

   input   clk;
   input   clkb;
   input   rst_n;
   input   vcce_la;
   input   vssexqyx;

   output  clk0;
   output  clk90;
   output  clk180;
   output  clk270;

   reg     clk0, clk90, clk180, clk270, clk0_init;

   initial begin
     clk0_init = 1'b0;
     clk0      = 1'b1;
     clk90     = 1'b1;
     clk180    = 1'b1;
     clk270    = 1'b1;
   end

   always @ ( posedge clk or negedge rst_n )
     if ( rst_n == 1'b0 ) begin
        clk0_init <= 1'b0;
        clk0      <= 1'b1;
        clk180    <= 1'b1;
     end
     else begin 
       clk0_init <= 1'b1;
       clk0      <= ~clk0;
       clk180    <=  clk0;
     end

   always @ ( posedge clkb or negedge rst_n )
     if ( rst_n == 1'b0 ) begin
       clk90  <= 1'b1;
       clk270 <= 1'b1;
     end
     else begin
       if ( clk0_init == 1'b1 ) begin
         clk90  <= ~clk90;
         clk270 <=  clk90;
       end
     end

endmodule // arriaii_hssi_pma_c_divby2q

//====Revision Log================
//Rev: 1.1   Tue Sep  2 10:24:11 PDT 2008   cgaillar
//Initial C5 version
//
//Rev: 1.3   Fri Oct 26 14:16:46 PDT 2007   cgaillar
//Commented-out/removed timescale
//====End Log======================

module arriaii_hssi_pma_c_controller_4t16 (
   atben, ct0, ct1, ct2, ct3, tmsb1, tmsb2, tmsb3, tmsb4, tmsb5, tmsb6, tmsb7, tmsb8,
   tmsb9, tmsb10, tmsb11, tmsb12, tmsb13, tmsb14, tmsb15, vcce_la, vssex );

   input   ct0;
   input   ct1;
   input   ct2;
   input   ct3;
   input   vcce_la;
   input   vssex;

   output  atben;
   output  tmsb1;
   output  tmsb2;
   output  tmsb3;
   output  tmsb4;
   output  tmsb5;
   output  tmsb6;
   output  tmsb7;
   output  tmsb8;
   output  tmsb9;
   output  tmsb10;
   output  tmsb11;
   output  tmsb12;
   output  tmsb13;
   output  tmsb14;
   output  tmsb15;

   wire tmsb0;
   reg [15:0] tmsb_bus;
   
   assign tmsb0 = tmsb_bus[0];
   assign tmsb1 = tmsb_bus[1];
   assign tmsb2 = tmsb_bus[2];
   assign tmsb3 = tmsb_bus[3];
   assign tmsb4 = tmsb_bus[4];
   assign tmsb5 = tmsb_bus[5];
   assign tmsb6 = tmsb_bus[6];
   assign tmsb7 = tmsb_bus[7];
   assign tmsb8 = tmsb_bus[8];
   assign tmsb9 = tmsb_bus[9];
   assign tmsb10 = tmsb_bus[10];
   assign tmsb11 = tmsb_bus[11];
   assign tmsb12 = tmsb_bus[12];
   assign tmsb13 = tmsb_bus[13];
   assign tmsb14 = tmsb_bus[14];
   assign tmsb15 = tmsb_bus[15];

   assign atben = |{ct3,ct2,ct1,ct0};
   always @ ( ct3, ct2, ct1, ct0 )
    case ( {ct3,ct2,ct1,ct0} )
      4'b0000 : tmsb_bus = 16'b0000000000000001;
      4'b0001 : tmsb_bus = 16'b0000000000000010;
      4'b0010 : tmsb_bus = 16'b0000000000000100;
      4'b0011 : tmsb_bus = 16'b0000000000001000;
      4'b0100 : tmsb_bus = 16'b0000000000010000;
      4'b0101 : tmsb_bus = 16'b0000000000100000;
      4'b0110 : tmsb_bus = 16'b0000000001000000;
      4'b0111 : tmsb_bus = 16'b0000000010000000;
      4'b1000 : tmsb_bus = 16'b0000000100000000;
      4'b1001 : tmsb_bus = 16'b0000001000000000;
      4'b1010 : tmsb_bus = 16'b0000010000000000;
      4'b1011 : tmsb_bus = 16'b0000100000000000;
      4'b1100 : tmsb_bus = 16'b0001000000000000;
      4'b1101 : tmsb_bus = 16'b0010000000000000;
      4'b1110 : tmsb_bus = 16'b0100000000000000;
      4'b1111 : tmsb_bus = 16'b1000000000000000;
      default : tmsb_bus = 16'b0000000000000000;
    endcase

endmodule // arriaii_hssi_pma_c_controller_4t16

//====Revision Log================
//Rev: 1.1   Tue Sep  2 10:24:10 PDT 2008   cgaillar
//Initial C5 version
//
//Rev: 1.7   Fri Jun  6 11:55:49 PDT 2008   cgaillar
//Refined reset & powerdown conditions for behavior closer to schematics
//====End Log======================

module arriaii_hssi_pma_c_clkgendrv (
   clk0, clk90, clk180, clk270, cpulse, cpulseb, cpulseo, div5, hfclk_n, hfclk_p, lfclk_n, lfclk_p,
   rst_n, vccelxqyx, vssexqyx );

   input   clk0;
   input   clk90;
   input   clk180;
   input   clk270;
   input   div5;
   input   rst_n;
   input   vccelxqyx;
   input   vssexqyx;

   output  cpulse;
   output  cpulseb;
   output  cpulseo;
   output  hfclk_n;
   output  hfclk_p;
   output  lfclk_n;
   output  lfclk_p;

   integer lfclkp_counter;
   reg     lfclkp_div5, lfclkp_div4, lfclkn_div5, lfclkn_div4, cpulse_div4, cpulse_div5;
   reg     init_done;
   reg      hfclk_p_prev;
   wire hfclk_p_wire;
   
   assign hfclk_p = hfclk_p_wire;
   assign hfclk_p_wire   = ~rst_n ? 1'b0 : ~clk180;
   assign hfclk_n  = ~rst_n ? 1'b1 : ~clk0;
   assign lfclk_p  = ~rst_n ? 1'b0 : 
                       div5 ? lfclkp_div5 : lfclkp_div4;
   assign lfclk_n  = ~rst_n ? 1'b1 : 
                       div5 ? lfclkn_div5 : lfclkn_div4;
   assign cpulse   = ~rst_n ? 1'b0 : 
                       div5 ? cpulse_div5 : cpulse_div4;
   assign cpulseo =  cpulse;
   assign cpulseb = ~cpulse;

   initial begin
     lfclkp_counter = 0;           // change to blocking : manju
     lfclkp_div4    = 1'b0;
     lfclkp_div5    = 1'b0;
     lfclkn_div4    = 1'b1;
     lfclkn_div5    = 1'b1;
     cpulse_div4    = 1'b0;
     cpulse_div5    = 1'b0;
     init_done      = 1'b0;          // added : manju
   end

   // Edge counter used for lfclkp/n_div4/div5 and cpulse_div4/5 generation
   always @ ( hfclk_p_wire or negedge rst_n ) begin
     if ( rst_n == 1'b0 ) begin
       lfclkp_counter <= 0;
       lfclkp_div4    <= 1'b0;
       lfclkp_div5    <= 1'b0;
       lfclkn_div4    <= 1'b1;
       lfclkn_div5    <= 1'b1;
       cpulse_div4    <= 1'b0;
       cpulse_div5    <= 1'b0;
       init_done      <= 1'b0;
     end
     else if (hfclk_p_wire != hfclk_p_prev) begin
       // after one cycle of hfclkp, if set, reset cpulse_div4/5
       if ( hfclk_p_wire == 1'b1 & cpulse_div5 == 1'b1 ) cpulse_div5 <= 1'b0;
       if ( hfclk_p_wire == 1'b1 & cpulse_div4 == 1'b1 ) cpulse_div4 <= 1'b0;
       // generation of lfclkp/n_div5 & pulse_div5 ** posedge of lfclkp_div5 occurs at posedge of hfclkp **
       if ( ( lfclkp_counter % 5 == 1 ) & ( hfclk_p_wire == 1'b1 ) ) begin
         lfclkp_div5 <= 1'b1;
         lfclkn_div5 <= 1'b0;
         if ( lfclkp_div5 == 1'b0 ) cpulse_div5 <= 1'b1;
       end
       else if ( ( lfclkp_counter % 5 == 1 ) & ( hfclk_p_wire == 1'b0 ) ) begin
         lfclkp_div5 <= 1'b0;
         lfclkn_div5 <= 1'b1;
       end
       // generation of lfclkp/n_div4 & pulse_div4 ** posedge of lfclkp_div5 occurs at posedge of hfclkp **
       if ( ( hfclk_p_wire == 1'b1 ) & ( ( lfclkp_counter % 4 == 0 ) | ( lfclkp_counter % 4 == 1 ) ) ) begin
         if ( init_done == 1'b0 ) begin
           lfclkp_div4 <= 1'b1;
           lfclkn_div4 <= 1'b0;
           init_done <= 1'b1;
         end
         else begin
           lfclkp_div4 <= ~lfclkp_div4;
           lfclkn_div4 <= ~lfclkn_div4;
         end
         if ( lfclkp_div4 == 1'b0 ) cpulse_div4 <= 1'b1;
       end
       lfclkp_counter <= lfclkp_counter + 1;
     end
          hfclk_p_prev = hfclk_p_wire;
   end

endmodule // arriaii_hssi_pma_c_clkgendrv

//====Revision Log================
//Rev: 1.1   Tue Sep  2 10:24:10 PDT 2008   cgaillar
//Initial C5 version
//
//Rev: 1.23   Wed Jun 18 11:42:18 PDT 2008   cgaillar
//Removed all 1'b1 & 1'b0 from instances. Added ifdef COSIM flag to change delay parameter from 1 to 0.05 and 2 to 0.1
//====End Log======================

module arriaii_hssi_pma_c_clkgenbuf (
   cgb_x_en, clk0_0, clk0_1, clk0_out, clk90_0, clk90_1, clk90_out, clk180_0, clk180_1,
   clk180_out, clk270_0, clk270_1, clk270_out, cmu_sel, cpulse, div5, dynamic_sw, gen2ngen1,
   hclk, hfclk_n, hfclk_p, lfclk_n, lfclk_p, m_sel, pcie_sw, pcie_sw_cdr, pclk, pdb, rst_n, 
   rst_n1, vccelxqyx, vssexqyx );

   input  [1:0] cgb_x_en;
   input        clk0_0;
   input        clk0_1;
   input        clk90_0;
   input        clk90_1;
   input        clk180_0;
   input        clk180_1;
   input        clk270_0;
   input        clk270_1;
   input        cmu_sel;
   input        div5;
   input        dynamic_sw;
   input  [1:0] m_sel;
   input        pcie_sw;
   input        pdb;
   input        rst_n;
   input        vccelxqyx;
   input        vssexqyx;

   output       clk0_out;
   output       clk90_out;
   output       clk180_out;
   output       clk270_out;
   output       cpulse;
   output       gen2ngen1;
   output       hclk;
   output       hfclk_n;
   output       hfclk_p;
   output       lfclk_n;
   output       lfclk_p;
   output       pcie_sw_cdr;
   output       pclk;
   output       rst_n1;

   parameter    PARAM_DELAY = 0;
   
   wire         pdb_buf, rst_n1;
   wire  [3:0]  clk_in;
   wire  [3:0]  clk_div2, clk_div4; 
   reg   [3:0]  clk_out;

   wire         clk270_out, clk180_out, clk90_out, clk0_out;
   wire         rst_n1_clkgenbuf_div, rst_n2_clkgenbuf_div;
   wire         cpulse_i, cpulseb_i, cpulseo;
   wire         gen2ngen1; 
   wire         hfclkn_i, hfclkp_i, lfclkn_i, lfclkp_i;

   assign pdb_buf = pdb & ~(|cgb_x_en);
   assign rst_n1  = rst_n & pdb_buf;

   // * * b_mux4_2t1 - xcmux instance * *
   assign clk_in = (~rst_n1|~pdb_buf) ? 4'b0000 : ( cmu_sel ? {clk270_1,clk180_1,clk90_1,clk0_1} : {clk270_0,clk180_0,clk90_0,clk0_0} );

   // * * arriaii_hssi_pma_c_clkgenbuf_div - xdiv instance * *
   assign rst_n1_clkgenbuf_div = rst_n1 & ( m_sel[1] | m_sel[0]);
   assign rst_n2_clkgenbuf_div = rst_n1 & m_sel[1];
   assign clk270_out = clk_out[3];
   assign clk180_out = clk_out[2];
   assign clk90_out = clk_out[1];
   assign clk0_out = clk_out[0];

   arriaii_hssi_pma_c_divby2q xdiv2_2 (
      .clk(~clk_in[2]), .clk0(clk_div2[0]), .clk90(clk_div2[1]), .clk180(clk_div2[2]), .clk270(clk_div2[3]),
      .vcce_la(vccelxqyx), .vssexqyx(vssexqyx),
      .clkb(~clk_in[0]), .rst_n(rst_n1_clkgenbuf_div) );

   arriaii_hssi_pma_c_divby2q xdiv2_4 (
      .clk(~clk_div2[2]), .clk0(clk_div4[0]), .clk90(clk_div4[1]), .clk180(clk_div4[2]), .clk270(clk_div4[3]), 
      .vcce_la(vccelxqyx), .vssexqyx(vssexqyx),
      .clkb(~clk_div2[0]), .rst_n(rst_n2_clkgenbuf_div) );

   always @ ( m_sel or clk_in or clk_div2 or clk_div4 ) 
     case ( m_sel )
       2'b00   : clk_out = clk_in;
       2'b01   : clk_out = clk_div2;
       2'b10   : clk_out = clk_div4;
       2'b11   : clk_out = clk_in;
       default : clk_out = 4'bxxxx;
     endcase

   // * * arriaii_hssi_pma_c_clkgendrv - xdrv instance - div by 4 or 5 * *
   arriaii_hssi_pma_c_clkgendrv xdrv (
      .clk0(clk0_out), .clk90(clk90_out), .clk180(clk180_out), .clk270(clk270_out),
      .cpulse(cpulse_i), .cpulseb(cpulseb_i), .cpulseo(cpulseo), .div5(div5), .hfclk_n(hfclkn_i), .hfclk_p(hfclkp_i),
      .lfclk_n(lfclkn_i), .lfclk_p(lfclkp_i), .rst_n(rst_n1), .vccelxqyx(vccelxqyx), .vssexqyx(vssexqyx) );

       // * * c_pcie_sw - xpcie_sw instance * *
   arriaii_hssi_pma_c_pcie_sw #(.PARAM_DELAY (PARAM_DELAY)) xpcie_sw (
      .cpulse(cpulse_i), .cpulse_out(cpulse), .cpulseb(cpulseb_i), .cpulsei(cpulse_i),
      .dynamic_sw(dynamic_sw), .gen2ngen1(gen2ngen1), .hclk(hclk), .hfclkn(hfclkn_i),
      .hfclkn_out(hfclk_n), .hfclkp(hfclkp_i), .hfclkp_out(hfclk_p), .lfclkn(lfclkn_i),
      .lfclkn_out(lfclk_n), .lfclkp(lfclkp_i), .lfclkp_out(lfclk_p), .pcie_sw(pcie_sw),
      .pcie_sw_cdr(pcie_sw_cdr), .pclk(pclk), .pdb(pdb_buf), .rst_n(rst_n1), .vccelxqyx(vccelxqyx),
      .vssexqyx(vssexqyx), .div5(div5) );

endmodule // arriaii_hssi_pma_c_clkgenbuf


//====Revision Log================
//Rev: 1.1   Tue Sep  2 10:24:14 PDT 2008   cgaillar
//Initial C5 version
//
//Rev: 1.8   Thu Feb 21 11:30:42 PST 2008   cgaillar
//Updates to match g_gx_ww7_clean tag
//====End Log======================

module arriaii_hssi_pma_c_clkgenbuf_cmu (
   cgb_vccelxqyx, cgb_vssexqyx, cgb_x_en, clk0_0, clk0_1, clk90_0, clk90_1, clk180_0, clk180_1, clk270_0,
   clk270_1, cmu_sel, cpulse_ht, cpulse_x1, div5, dynamic_sw, gen2ngen1,
   hclk, hfclkn_ht, hfclkn_x1, hfclkp_ht, hfclkp_x1, ht_sel, lfclkn_ht, 
   lfclkn_x1, lfclkp_ht, lfclkp_x1, m_sel, pcie_sw, pcie_sw_cdr, pclk, pdb, rst_n, 
   vccelxqyx, vssexqyx );

   input  [1:0] cgb_x_en;
   input        clk0_0;
   input        clk0_1;
   input        clk90_0;
   input        clk90_1;
   input        clk180_0;
   input        clk180_1;
   input        clk270_0;
   input        clk270_1;
   input        cmu_sel;
   input        div5;
   input        dynamic_sw;
   input        ht_sel;
   input  [1:0] m_sel;
   input        pcie_sw;
   input        pdb;
   input        rst_n;
   input        vccelxqyx;
   input        vssexqyx;

   output       cgb_vccelxqyx;
   output       cgb_vssexqyx;
   output       cpulse_ht;
   output       cpulse_x1;
   output       gen2ngen1;
   output       hclk;
   output       hfclkn_ht;
   output       hfclkn_x1;
   output       hfclkp_ht;
   output       hfclkp_x1;
   output       lfclkn_ht;
   output       lfclkn_x1;
   output       lfclkp_ht;
   output       lfclkp_x1;
   output       pcie_sw_cdr;
   output       pclk;

   supply1 vccelxqyx;
   supply0 vssexqyx;

   wire rst_n1;
   wire rst_n1b;
   wire ht_en;
   wire clk0_out, clk90_out, clk180_out, clk270_out;
   wire cpulseo;
   wire cpulseb_ht;


   nand x5b ( rst_n1b, rst_n1, ht_sel );
   not x6b ( ht_en, rst_n1b );

   arriaii_hssi_pma_c_clkgenbuf xclkgen (
      .cgb_x_en(cgb_x_en), .clk0_0(clk0_0), .clk0_1(clk0_1), .clk0_out(clk0_out), .clk90_0(clk90_0),
      .clk90_1(clk90_1), .clk90_out(clk90_out), .clk180_0(clk180_0), .clk180_1(clk180_1),
      .clk180_out(clk180_out), .clk270_0(clk270_0), .clk270_1(clk270_1), .clk270_out(clk270_out),
      .cmu_sel(cmu_sel), .cpulse(cpulse_x1), .div5(div5), .dynamic_sw(dynamic_sw), .gen2ngen1(gen2ngen1),
      .hclk(hclk), .hfclk_n(hfclkn_x1), .hfclk_p(hfclkp_x1), .lfclk_n(lfclkn_x1), .lfclk_p(lfclkp_x1),
      .m_sel(m_sel), .pcie_sw(pcie_sw), .pcie_sw_cdr(pcie_sw_cdr), .pclk(pclk), .pdb(pdb),
      .rst_n(rst_n), .rst_n1(rst_n1), .vccelxqyx(vccelxqyx), .vssexqyx(vssexqyx) );

   arriaii_hssi_pma_c_clkgendrv xdrv (
      .clk0(clk270_out), .clk90(clk0_out), .clk180(clk90_out), .clk270(clk180_out),
      .cpulse(cpulse_ht), .cpulseb(cpulseb_ht), .cpulseo(cpulseo), .div5(div5),
      .hfclk_n(hfclkn_ht), .hfclk_p(hfclkp_ht), .lfclk_n(lfclkn_ht), .lfclk_p(lfclkp_ht),
      .rst_n(ht_en), .vccelxqyx(vccelxqyx), .vssexqyx(vssexqyx) );

   pmos xmatb1 ( cgb_vccelxqyx, vccelxqyx, vssexqyx );
   nmos xmatb3 ( cgb_vssexqyx, vssexqyx, vccelxqyx );

endmodule // arriaii_hssi_pma_c_clkgenbuf_cmu

module arriaii_hssi_pma_c_d2a_mbpass (
   bypass, d2a_in, d2a_out, radce_adapt, radce_pdb, vccehx, vssex );

   input  [7:5] bypass;
   input        d2a_in;
   input        radce_adapt;
   input        radce_pdb;
   input        vccehx;
   input        vssex;

   output       d2a_out;

   wire [7:1] level;
   wire [7:5] nbypass;
   wire [7:0] sel;

assign d2a_out = (radce_adapt || (~radce_adapt && ~radce_pdb)) ? d2a_in : 1'bz;
assign d2a_out = ((~radce_adapt && radce_pdb) && (bypass[7] || bypass[6] || bypass[5])) ? vccehx : 1'bz;

endmodule // arriaii_hssi_pma_c_d2a_mbpass


//====Revision Log================
//Rev: 1.4   Wed Dec  5 13:59:34 PST 2007   cgaillar
//Updates to match g_gx_ww45_clean schematic tag
//====End Log======================

module arriaii_hssi_pma_c_tx_clkmux_cmu (
   cpulse, cpulse_ht, cpulse_x1, cpulse_x4, cpulse_xn_b, cpulse_xn_t, delay_sel, hfclk_n, 
   hfclk_p, hfclkn_ht, hfclkn_x1, hfclkn_x4, hfclkn_xn_b, hfclkn_xn_t, hfclkp_ht, hfclkp_x1, 
   hfclkp_x4, hfclkp_xn_b, hfclkp_xn_t, ht_sel, lfclk_n, lfclk_p, lfclkn_ht, lfclkn_x1, 
   lfclkn_x4, lfclkn_xn_b, lfclkn_xn_t, lfclkp_ht, lfclkp_x1, lfclkp_x4, lfclkp_xn_b, lfclkp_xn_t, 
   pdb, sel, vccelxqyx, vssexqyx );

   input        cpulse_ht;
   input        cpulse_x1;
   input        cpulse_x4;
   input        cpulse_xn_b;
   input        cpulse_xn_t;
   input        delay_sel;
   input        hfclkn_ht;
   input        hfclkn_x1;
   input        hfclkn_x4;
   input        hfclkn_xn_b;
   input        hfclkn_xn_t;
   input        hfclkp_ht;
   input        hfclkp_x1;
   input        hfclkp_x4;
   input        hfclkp_xn_b;
   input        hfclkp_xn_t;
   input        ht_sel;
   input        lfclkn_ht;
   input        lfclkn_x1;
   input        lfclkn_x4;
   input        lfclkn_xn_b;
   input        lfclkn_xn_t;
   input        lfclkp_ht;
   input        lfclkp_x1;
   input        lfclkp_x4;
   input        lfclkp_xn_b;
   input        lfclkp_xn_t;
   input        pdb;
   input  [1:0] sel;
   input        vccelxqyx;
   input        vssexqyx;

   output  cpulse;
   output  hfclk_n;
   output  hfclk_p;
   output  lfclk_n;
   output  lfclk_p;

   parameter DELAY = 1;

   wire    n10_sel_0, n11_sel_1;
   wire    nx1_sel_xn,n01_sel_x4,n00_sel_x1;
   wire    hfclkp_x1_0,  hfclkn_x1_0, cpulse_x1_0, lfclkp_x1_0, lfclkn_x1_0, sel_x4_d;
   reg     hfclkp_x4_0,hfclkn_x4_0,cpulse_x4_0,lfclkp_x4_0,lfclkn_x4_0;
   reg     hfclkp_xn,hfclkn_xn,cpulse_xn,lfclkp_xn,lfclkn_xn;
   reg     hfclk_p,hfclk_n,cpulse,lfclk_p,lfclk_n;
   reg     hfclkp_ht_d,hfclkn_ht_d,cpulse_ht_d,lfclkp_ht_d,lfclkn_ht_d;
   reg     hfclkp_x4_d,hfclkn_x4_d,cpulse_x4_d,lfclkp_x4_d,lfclkn_x4_d;

   // * * c_tx_clkmux_2t1 x0 * *

   // xhtdelay
   always @ ( hfclkp_ht,hfclkn_ht,cpulse_ht,lfclkp_ht,lfclkn_ht )
   begin
     {hfclkp_ht_d,hfclkn_ht_d,cpulse_ht_d,lfclkp_ht_d,lfclkn_ht_d} <= #DELAY {hfclkp_ht,hfclkn_ht,cpulse_ht,lfclkp_ht,lfclkn_ht};
    end

   assign hfclkp_x1_0 = ( pdb == 1'b0  ) ? 1'b0 :( (ht_sel == 1'b1) & (sel == 2'b00) ) ? hfclkp_ht_d : hfclkp_x1;
   assign hfclkn_x1_0 = ( pdb == 1'b0  ) ? 1'b0 :( (ht_sel == 1'b1) & (sel == 2'b00) ) ? hfclkn_ht_d : hfclkn_x1;
   assign cpulse_x1_0 = ( pdb == 1'b0  ) ? 1'b0 :( (ht_sel == 1'b1) & (sel == 2'b00) ) ? cpulse_ht_d : cpulse_x1;
   assign lfclkp_x1_0 = ( pdb == 1'b0  ) ? 1'b0 :( (ht_sel == 1'b1) & (sel == 2'b00) ) ? lfclkp_ht_d : lfclkp_x1;
   assign lfclkn_x1_0 = ( pdb == 1'b0  ) ? 1'b0 :( (ht_sel == 1'b1) & (sel == 2'b00) ) ? lfclkn_ht_d : lfclkn_x1;


   // * * c_tx_clkmux_2t1 x2 * *

   // xdelay
   always @ ( hfclkp_x4,hfclkn_x4,cpulse_x4,lfclkp_x4,lfclkn_x4 )
   begin
     {hfclkp_x4_d,hfclkn_x4_d,cpulse_x4_d,lfclkp_x4_d,lfclkn_x4_d} <= #DELAY {hfclkp_x4,hfclkn_x4,cpulse_x4,lfclkp_x4,lfclkn_x4};
    end
    
   assign sel_x4_d = delay_sel & ~sel[1] & sel[0];

   always @ ( sel_x4_d or hfclkp_x4_d or hfclkn_x4_d or cpulse_x4_d or lfclkp_x4_d or lfclkn_x4_d or hfclkp_x4 or hfclkn_x4 or cpulse_x4 or lfclkp_x4 or lfclkn_x4 or pdb ) begin
    if ( pdb == 1'b1 )
     case ( sel_x4_d )
       1'b0    : begin
       {hfclkp_x4_0,hfclkn_x4_0,cpulse_x4_0,lfclkp_x4_0,lfclkn_x4_0} = {hfclkp_x4,hfclkn_x4,cpulse_x4,lfclkp_x4,lfclkn_x4};
       end
       1'b1    : begin
       {hfclkp_x4_0,hfclkn_x4_0,cpulse_x4_0,lfclkp_x4_0,lfclkn_x4_0} = {hfclkp_x4_d,hfclkn_x4_d,cpulse_x4_d,lfclkp_x4_d,lfclkn_x4_d};
       end
       default : begin
       {hfclkp_x4_0,hfclkn_x4_0,cpulse_x4_0,lfclkp_x4_0,lfclkn_x4_0} = 5'bxxxxx;
       end
     endcase
   else
   begin
     {hfclkp_x4_0,hfclkn_x4_0,cpulse_x4_0,lfclkp_x4_0,lfclkn_x4_0} = 5'b00000;
   end
   end


   // * * c_tx_clkmux_2t1 x0 * *
   assign n10_sel_0 =  sel[1] & ~sel[0] & pdb;
   assign n11_sel_1 =  sel[1] &  sel[0] & pdb;

   always @ ( n11_sel_1 or n10_sel_0 or hfclkp_xn_t or hfclkn_xn_t or cpulse_xn_t or lfclkp_xn_t or lfclkn_xn_t or hfclkp_xn_b or hfclkn_xn_b or cpulse_xn_b or  lfclkp_xn_b or lfclkn_xn_b or pdb ) begin
    if ( pdb == 1'b1 )
     case ( {n11_sel_1,n10_sel_0} )
       2'b00   :begin 
       {hfclkp_xn,hfclkn_xn,cpulse_xn,lfclkp_xn,lfclkn_xn} = 5'bzzzzz;
               end
       2'b01   :begin
        {hfclkp_xn,hfclkn_xn,cpulse_xn,lfclkp_xn,lfclkn_xn} = {hfclkp_xn_t,hfclkn_xn_t,cpulse_xn_t,lfclkp_xn_t,lfclkn_xn_t};
                end
       2'b10   :begin
        {hfclkp_xn,hfclkn_xn,cpulse_xn,lfclkp_xn,lfclkn_xn} = {hfclkp_xn_b,hfclkn_xn_b,cpulse_xn_b,lfclkp_xn_b,lfclkn_xn_b};
                end
       default :begin
        {hfclkp_xn,hfclkn_xn,cpulse_xn,lfclkp_xn,lfclkn_xn} = 5'bxxxxx;
               end
     endcase
   else
     begin
     {hfclkp_xn,hfclkn_xn,cpulse_xn,lfclkp_xn,lfclkn_xn} = 5'b00000;
     end
   end

   // * * c_tx_clkmux x1 * *
   assign nx1_sel_xn =  sel[1];
   assign n01_sel_x4 = ~sel[1] &  sel[0] & pdb;
   assign n00_sel_x1 = ~sel[1] & ~sel[0] & pdb;

   always @ ( nx1_sel_xn or n01_sel_x4 or n00_sel_x1 or hfclkp_x1_0 or hfclkn_x1_0 or cpulse_x1_0 or lfclkp_x1_0 or lfclkn_x1_0 or hfclkp_x4_0 or hfclkn_x4_0 or cpulse_x4_0 or lfclkp_x4_0  or lfclkn_x4_0 or hfclkp_xn or hfclkn_xn or cpulse_xn or lfclkp_xn or lfclkn_xn or pdb ) begin
    if ( pdb == 1'b1 )
     case ( {nx1_sel_xn,n01_sel_x4,n00_sel_x1} )
       3'b000  : begin 
       {hfclk_p,hfclk_n,cpulse,lfclk_p,lfclk_n} = 5'bzzzzz;
                 end
       3'b001  : begin 
       {hfclk_p,hfclk_n,cpulse,lfclk_p,lfclk_n} = {hfclkp_x1_0,hfclkn_x1_0,cpulse_x1_0,lfclkp_x1_0,lfclkn_x1_0};
                 end
       3'b010  : begin 
       {hfclk_p,hfclk_n,cpulse,lfclk_p,lfclk_n} = {hfclkp_x4_0,hfclkn_x4_0,cpulse_x4_0,lfclkp_x4_0,lfclkn_x4_0};
                 end
       3'b100  : begin 
       {hfclk_p,hfclk_n,cpulse,lfclk_p,lfclk_n} = {hfclkp_xn,hfclkn_xn,cpulse_xn,lfclkp_xn,lfclkn_xn};
                end
       default : begin 
       {hfclk_p,hfclk_n,cpulse,lfclk_p,lfclk_n} = 5'bxxxxx;
                 end
     endcase
   else
     begin
     {hfclk_p,hfclk_n,cpulse,lfclk_p,lfclk_n} = 5'b00000;
     end
   end

endmodule // arriaii_hssi_pma_c_tx_clkmux_cmu


//====Revision Log================
//Rev: 1.1   Tue Sep  2 10:24:15 PDT 2008   cgaillar
//Initial C5 version
//
//Rev: 1.1   Wed May 14 13:18:59 PDT 2008   cgaillar
//Updates to match g_gx_ww19_clean schematic tag
//
//====End Log======================

module arriaii_hssi_pma_c_deser_pcie (
   ck_div, en, pcie, pcieo, rpcie, rst_n, vcce_la, vssexqyx );

   input   ck_div;
   input   pcie;
   input   rpcie;
   input   rst_n;
   input   vcce_la;
   input   vssexqyx;

   output  en;
   output  pcieo;

   parameter     PARAM_DELAY = 0;

   reg        n1, n0, pcie2, n4, n3, n2, n6;
   wire       exor, pcie_clk_div;

   initial
   begin
       n0 = 0;
       n1 = 0;
       n2 = 0;
       n3 = 0;
       n4 = 0;
       n6 = 0;
       pcie2 = 0;
   end

   assign pcie_clk_div = ck_div & rpcie;
   assign exor         = (~n1 & n0 ) | (n1 & ~n0);
   assign en           = ~(n2 | n3 | n4 );
   assign pcieo        = ~rpcie | n6;

   always @ ( posedge pcie_clk_div or negedge rst_n )
     if ( rst_n == 1'b0 ) begin
       {n1,n0,pcie2} <= #(PARAM_DELAY) 3'b000;
       {n4,n3,n2}    <= #(PARAM_DELAY) 3'b000;
        n6           <= #(PARAM_DELAY) 1'b0;
     end
     else begin
       {n1,n0,pcie2} <= #(PARAM_DELAY) {n0,pcie2,pcie};
       {n4,n3,n2}    <= #(PARAM_DELAY) {n3,n2,exor};
        n6           <= #(PARAM_DELAY) n1;
     end

endmodule // arriaii_hssi_pma_c_deser_pcie



//====Revision Log================
//Rev: 1.1   Tue Sep  2 10:24:14 PDT 2008   cgaillar
//Initial C5 version
//
//Rev: 1.2   Wed Jun 18 11:42:17 PDT 2008   cgaillar
//Removed all 1'b1 & 1'b0 from instances. Added ifdef COSIM flag to change delay parameter from 1 to 0.05 and 2 to 0.1
//
//Rev: 1.1   Wed May 14 13:18:58 PDT 2008   cgaillar
//Updates to match g_gx_ww19_clean schematic tag
//
//====End Log======================

module arriaii_hssi_pma_c_deser_10to20 (
   ck_div, ckb_2div, clk_div, div2, douta, doutb, doutn, doutp, en, nck_div, nclk_div,
   rst_n, vcce_la, vssexqyx );

   input        ck_div;
   input        div2;
   input  [9:0] doutn;
   input  [9:0] doutp;
   input        en;
   input        nck_div;
   input        rst_n;
   input        vcce_la;
   input        vssexqyx;

   output       ckb_2div;
   output       clk_div;
   output [9:0] douta;
   output [9:0] doutb;
   output       nclk_div;

   wire       nc0, nc1, nc2, ck_2div, ckb_2div, ck_div2;
   wire       rst_n_div2;
   reg  [9:0] d10a, douta, doutb;

   parameter     PARAM_DELAY = 0;

   assign rst_n_div2 = rst_n & div2;
   assign clk_div    = en & (~ck_2div);

   arriaii_hssi_pma_c_divby2q xdiv2_2 (
      .clk(~ck_div), .clkb(ck_div), .clk0(nc0), .clk90(nc1),
      .vcce_la(vcce_la), .vssexqyx(vssexqyx),
      .clk180(ck_div2), .clk270(nc2), .rst_n(rst_n) );

   assign ck_2div  = div2 ? ~ck_div2 : ~ck_div;
   assign ckb_2div = div2 ?  ck_div2 :  ck_div;

   always @ ( negedge rst_n or posedge ck_2div )
     if ( ~rst_n )
       d10a[9:0] <= #(PARAM_DELAY) 10'b0000000000;
     else
       d10a[9:0] <= #(PARAM_DELAY) doutp[9:0];

   always @ ( negedge rst_n or posedge ckb_2div ) 
     if ( ~rst_n ) 
       douta[9:0] <= #(PARAM_DELAY) 10'b0000000000;
     else 
       douta[9:0] <= #(PARAM_DELAY) d10a[9:0];

   always @ ( negedge rst_n_div2 or posedge ckb_2div ) 
     if ( ~rst_n_div2 ) 
       doutb[9:0] <= #(PARAM_DELAY) 10'b0000000000;
     else 
       doutb[9:0] <= #(PARAM_DELAY) doutp[9:0];

endmodule // arriaii_hssi_pma_c_deser_10to20


//====Revision Log================
//Rev: 1.1   Tue Sep  2 10:24:14 PDT 2008   cgaillar
//Initial C5 version
//
//Rev: 1.2   Fri Jul 25 10:36:38 PDT 2008   cgaillar
//Fixed iTrack 49370
//
//Rev: 1.1   Wed May 14 13:18:59 PDT 2008   cgaillar
//Updates to match g_gx_ww19_clean schematic tag
//
//====End Log======================

module arriaii_hssi_pma_c_deser_ff_chain (
   clka, clkb, dout, rsd, rst_n, rtest_fsd, rxinn, rxinp, vcce_la, vssexqyx );

   input        clka;
   input        clkb;
   input  [2:0] rsd;
   input        rst_n;
   input        rtest_fsd;
   input        rxinn;
   input        rxinp;
   input        vcce_la;
   input        vssexqyx;

   output       dout;

   reg  [3:0] drp, dfp;
   reg        dout_1, dout;

   wire       rxp_clk, rxn_clk, muxout_ff_chain;

   parameter     PARAM_DELAY = 0;

   assign rxp_clk = rxinp & ~(rsd[2] & rtest_fsd);
   assign rxn_clk = rxinn & ~(rsd[2] & rtest_fsd);
   assign muxout_ff_chain = ( rsd[1] == 1'b0 & rsd[0] == 1'b0 ) ? |{drp[0],dfp[0]} :
                            ( rsd[1] == 1'b0 & rsd[0] == 1'b1 ) ? |{drp[1],dfp[1]} :
                            ( rsd[1] == 1'b1 & rsd[0] == 1'b0 ) ? |{drp[2],dfp[2]} :
                            ( rsd[1] == 1'b1 & rsd[0] == 1'b1 ) ? |{drp[3],dfp[3]} : 1'bx;

   always @ ( posedge rxp_clk or negedge rst_n )
     if ( rst_n == 1'b0 )
       drp[3:0] <= #(PARAM_DELAY) 4'b0000;
     else
       drp[3:0] <= #(PARAM_DELAY) {drp[2:0],vcce_la};

   always @ ( posedge rxn_clk or negedge rst_n )
     if ( rst_n == 1'b0 )
       dfp[3:0] <= #(PARAM_DELAY) 4'b0000;
     else
       dfp[3:0] <= #(PARAM_DELAY) {dfp[2:0],vcce_la};

   always @ ( posedge clka ) // posedge ph[3] )
     dout_1 <= #(PARAM_DELAY) muxout_ff_chain;

   always @ ( posedge clkb ) // negedge ph[3] )
     dout <= #(PARAM_DELAY) dout_1;

endmodule // arriaii_hssi_pma_c_deser_ff_chain


//====Revision Log================
//Rev: 1.1   Tue Sep  2 10:24:14 PDT 2008   cgaillar
//Initial C5 version
//
//Rev: 1.2   Mon Aug  4 11:26:00 PDT 2008   cgaillar
//Updated shiftout polarity in noswitch logic, and clk edge from posedge to negedge for fsd edge detection logic - iTrack 49743
//
//Rev: 1.1   Wed May 14 13:18:59 PDT 2008   cgaillar
//Updates to match g_gx_ww19_clean schematic tag
//
//====End Log======================

module arriaii_hssi_pma_c_deser_fsd_rst (
   in, rst, vcce_la, vssexqyx );

   input   in;
   input   vcce_la;
   input   vssexqyx;

   output  rst;

   reg        rst;

   parameter   RST_SD_PULSE_WIDTH = 1;

   initial 
     rst <= 1'b1;

   // rst pulse generator
   always @ ( negedge in ) begin
     rst <= 1'b0;
     rst <= # (RST_SD_PULSE_WIDTH) 1'b1;
   end

endmodule // arriaii_hssi_pma_c_deser_fsd_rst


//====Revision Log================
//Rev: 1.17   Fri Apr 25 17:28:55 PDT 2008   cgaillar
//Replaced 1'b1 & 1'b0 with vcc* & vss* in instances derived from schematics
//
//Rev: 1.16   Wed Mar  5 14:25:52 PST 2008   cgaillar
//Initialized register in Fast Signal Detect logic
//====End Log======================


module arriaii_hssi_pma_c_deser (
   clk90b, clk_divrx, deser_div2, deser_div5, deser_pdb, deven,
   devenb, dodd, doddb, dout, fsd, pcie_sw, pcieo, rdynamic_sw, rfast_sd, rst_n, rtest_fastsd, 
   rxinn, rxinp, vcce_la, vssexqyx );

   input         clk90b;
   input         deser_div2;
   input         deser_div5;
   input         deser_pdb;
   input         deven;
   input         devenb;
   input         dodd;
   input         doddb;
   input         pcie_sw;
   input         rdynamic_sw;
   input   [3:0] rfast_sd;
   input         rst_n;
   input         rtest_fastsd;
   input         rxinn;
   input         rxinp;
   input         vcce_la;
   input         vssexqyx;

   output        clk_divrx;
   output [19:0] dout;
   output        fsd;
   output        pcieo;

   reg  [9:0] dp;
   reg  [3:0] dsync;
   reg  [3:0] drp, dfp;
   reg  [9:0] outp, outn;
   reg  [4:0] ph;
   reg        deven_ok, devenb_ok, data_even;
   reg        dodd_ok, doddb_ok, data_odd;
   reg        ck_div;
   reg        clk90_div5, clk90_div4, clk270_div5, clk270_div4, clk90_div_init_done, clk270_div_init_done;
   reg        even_all0q, even_all1q, odd_all0q, odd_all1q;
   reg        sd, sd1, shiftout_1, shiftoutq;
   reg        n1, n0, pcie2, n4, n3, n2, n6;
   reg        got_first_clk270_rising_edge;

   wire       clk90, clk270;
   wire       b1, cout, muxout_ff_chain;
   wire       rst_ni, rst_n_div2;   
   wire       ck_div2, ck_2div;
   wire       even_all0, even_all1, odd_all0, odd_all1;
   wire       ckb_2div, rxp_clk, rxn_clk, noswitch;
   wire       nc0;
   wire       pcie_clk_div, activity;
   wire       exor;
   wire       shiftout;
   wire       rst_sd;
   wire       en;

   parameter     PARAM_DELAY = 0;

   integer    clk90_counter, clk270_counter;

   initial 
   begin
     clk90_div_init_done  <= 1'b0;
     clk270_div_init_done <= 1'b0;
     clk90_counter  <= 0;
     clk270_counter <= 0;
     clk90_div4 <= 1'b0;
     clk90_div5 <= 1'b0;
     clk270_div4 <= 1'b0;
     clk270_div5 <= 1'b0;
     pcie2 = 0;
     drp <= 4'b0000;
     dfp <= 4'b0000;
     even_all1q <= 1'b0;
     even_all0q <= 1'b0;
     odd_all1q  <= 1'b0;
     odd_all0q  <= 1'b0;
     shiftoutq  <= 1'b0;
     shiftout_1 <= 1'b0;
     n0 = 0;
     n1 = 0;
     n2 = 0;
     n3 = 0;
     n4 = 0;
     n6 = 0;
     got_first_clk270_rising_edge = 0;
   end

   assign rst_ni     = deser_pdb & rst_n;
   assign rst_n_div2 = rst_ni & deser_div2;
   assign clk90      = ~clk90b;
   assign clk270     =  clk90b;

   // * * c_deser_ph_clk * * 
   // b1   synch w/ clk90  ; 60-40 duty-cycle in div5 mode ; 50-50 in div4 mode
   // cout synch w/ clk270 ; 50-50 duty-cycle in div5 and div4 modes
   assign b1   = deser_div5 ? clk90_div5 : clk90_div4;
   assign cout = deser_div5 ? clk270_div5 : clk270_div4; 
   always @ ( posedge clk90 or negedge rst_ni ) begin
     if ( rst_ni == 1'b0 ) begin
       clk90_counter       <= 0;
       clk90_div_init_done <= 1'b0;
       clk90_div5          <= 1'b0;
       clk90_div4          <= 1'b0;
     end
     else begin
       // generation of clk90_div5 
       if ( clk90_div_init_done == 1'b0 ) begin
         clk90_div5          <= 1'b1;
         clk90_div4          <= 1'b1;
         clk90_div_init_done <= 1'b1;
         end
       else begin
         if ( clk90_counter % 5 == 0 )
           clk90_div5 <= 1'b1;
         else if ( clk90_counter % 5 == 3 )
           clk90_div5 <= 1'b0;
         // generation of clk90_div4 
         if ( clk90_counter % 2 == 0 ) 
           clk90_div4 <= ~clk90_div4;
       end
       clk90_counter <= clk90_counter + 1;
     end
   end

   // clk270_div4/5 should not start toggling before clk90_div4/5 
   always @ ( clk270 or negedge rst_ni ) begin
     if ( rst_ni == 1'b0 ) begin
       clk270_counter       <= 0;
       clk270_div_init_done <= 1'b0;
       clk270_div5          <= 1'b0;
       clk270_div4          <= 1'b0;
       got_first_clk270_rising_edge = 1'b0;
     end
     else if ( clk90_div_init_done == 1'b1 ) begin
       // generation of clk270_div5
       if ( ( clk270_counter % 5 == 0 ) & ( clk270 == 1'b1 ) ) begin
         got_first_clk270_rising_edge = 1'b1;
         clk270_div5 <= 1'b1;
       end
       else if ( ( clk270_counter % 5 == 0 ) & ( clk270 == 1'b0 ) ) 
         clk270_div5 <= 1'b0;
       // generation of clk270_div4
       if ( ( clk270 == 1'b1 ) & ( clk270_counter % 4 == 0 ) ) begin
         if ( clk270_div_init_done == 1'b0 ) begin
           clk270_div4          <= 1'b1;
           clk270_div_init_done <= 1'b1;
         end
         else
           clk270_div4 <= ~clk270_div4;
       end
       if (got_first_clk270_rising_edge == 1'b1)
       clk270_counter <= clk270_counter + 1;
     end
   end 
   
   // like b1, ph duty-cycle is 60-40 in dvi5 mode, and 50-50 in div4 mode
   always @ ( negedge rst_ni or posedge clk270 ) 
     if ( ~rst_ni ) 
       ph[3:0] <= #(PARAM_DELAY) 4'b0000;
     else 
       ph[3:0] <= #(PARAM_DELAY) {ph[2:0],b1};

   always @ ( negedge deser_div5 or posedge clk270 )
     if ( ~deser_div5 )
       ph[4] <= #(PARAM_DELAY) 1'b0;
     else
       ph[4] <= #(PARAM_DELAY) ph[3];

   // Shift register
   always @ ( negedge rst_ni or posedge ph[0] )
     if ( ~rst_ni ) 
       dp[1:0] <= #(PARAM_DELAY) 2'b00;
     else 
       dp[1:0] <= #(PARAM_DELAY)  {dodd,deven}; // used to be {data_odd,data_even}
 
   always @ ( negedge rst_ni or posedge ph[1] )
     if ( ~rst_ni )
       dp[3:2] <= #(PARAM_DELAY) 2'b00;
     else
       dp[3:2] <= #(PARAM_DELAY) {dodd,deven};
 
   always @ ( negedge rst_ni or posedge ph[2] )
     if ( ~rst_ni )
       dp[5:4] <= #(PARAM_DELAY) 2'b00;
     else
       dp[5:4] <= #(PARAM_DELAY) {dodd,deven};
 
   always @ ( negedge rst_ni or posedge ph[3] )
     if ( ~rst_ni )
       dp[7:6] <= #(PARAM_DELAY) 2'b00;
     else
       dp[7:6] <= #(PARAM_DELAY) {dodd,deven};
 
   always @ ( negedge rst_ni or posedge ph[4] )
     if ( ~rst_ni )
       dp[9:8] <= #(PARAM_DELAY) 2'b00;
     else
       dp[9:8] <= #(PARAM_DELAY) {dodd,deven};

   // dp[0,1,2,3] synchronization
   always @ ( negedge rst_ni or posedge ph[3] ) 
     if ( ~rst_ni ) 
       dsync[3:0] <= #(PARAM_DELAY) 4'b0000;
     else 
       dsync[3:0] <= #(PARAM_DELAY) dp[3:0];

   always @ ( negedge rst_ni or posedge ph[0] )
     if ( ~rst_ni ) begin
       outp[9:0] <= #(PARAM_DELAY) 10'b0000000000;
       outn[9:0] <= #(PARAM_DELAY) 10'b0000000000;
     end
     else begin
       outp[9:0] <= #(PARAM_DELAY)  {dp[9:4],dsync[3:0]};
       outn[9:0] <= #(PARAM_DELAY) ~{dp[9:4],dsync[3:0]};
     end

   // * * c_deser_10to20 * *
   arriaii_hssi_pma_c_deser_10to20 x10to20 (
      .ck_div(cout), .ckb_2div(ckb_2div), .clk_div(clk_divrx), .div2(deser_div2),
      .douta(dout[9:0]), .doutb(dout[19:10]), .doutn(outn), .doutp(outp), .en(en),
      .nck_div(~cout), .nclk_div(nc0), .rst_n(rst_ni), .vcce_la(vcce_la),
      .vssexqyx(vssexqyx) );

   // * * c_deser_fsd_rst * *
   arriaii_hssi_pma_c_deser_fsd_rst xrst (
      .in(~ph[3]), .rst(rst_sd), .vcce_la(vcce_la), .vssexqyx(vssexqyx) );

   // c_deser_ff_chain
   arriaii_hssi_pma_c_deser_ff_chain xff_chain (
      .clka(ph[3]/*clk_ff*/), .clkb(ph[0]/*ck_divbuf*/), .dout(shiftout), .rsd(rfast_sd[2:0]), .rst_n(rst_sd),
      .rtest_fsd(rtest_fastsd), .rxinn(rxinn), .rxinp(rxinp), .vcce_la(vcce_la), .vssexqyx(vssexqyx) );

   // c_deser_pcie
   arriaii_hssi_pma_c_deser_pcie xpcie (
      .ck_div(ckb_2div), .en(en), .pcie(pcie_sw), .pcieo(pcieo), .rpcie(rdynamic_sw),
      .rst_n(rst_ni), .vcce_la(vcce_la), .vssexqyx(vssexqyx) );

   // ** c_deser_data_comp blocks * *
   assign even_all1 = &{outp[6],outp[4],outp[2],outp[0]} & ( ~deser_div5 | outp[8] );
   assign even_all0 = &{outn[6],outn[4],outn[2],outn[0]} & ( ~deser_div5 | outn[8] );
   assign odd_all1  = &{outp[7],outp[5],outp[3],outp[1]} & ( ~deser_div5 | outp[9] );
   assign odd_all0  = &{outn[7],outn[5],outn[3],outn[1]} & ( ~deser_div5 | outn[9] );

   assign noswitch = (~((shiftout & rfast_sd[3]) | shiftoutq ) | ( ~rfast_sd[2] &  rtest_fastsd ) ) & 
                     ( ~activity | ( ~rfast_sd[2] & ~rtest_fastsd ) );

   assign activity = ~(((( even_all0 | ~rfast_sd[3] ) & even_all0q )  | 
                        (( even_all1 | ~rfast_sd[3] ) & even_all1q )) & 
                       ((( odd_all0  | ~rfast_sd[3] ) &  odd_all0q )  | 
                        (( odd_all1  | ~rfast_sd[3] ) &  odd_all1q )));

   always @ ( negedge rst_ni or negedge clk_divrx )
     if ( rst_ni == 1'b0 ) begin
       even_all1q <= #(PARAM_DELAY) 1'b0;
       even_all0q <= #(PARAM_DELAY) 1'b0;
       odd_all1q  <= #(PARAM_DELAY) 1'b0;
       odd_all0q  <= #(PARAM_DELAY) 1'b0;
       shiftoutq  <= #(PARAM_DELAY) 1'b0;
     end
     else begin
       even_all1q <= #(PARAM_DELAY) even_all1;
       even_all0q <= #(PARAM_DELAY) even_all0;
       odd_all1q  <= #(PARAM_DELAY) odd_all1;
       odd_all0q  <= #(PARAM_DELAY) odd_all0;
       shiftoutq  <= #(PARAM_DELAY) shiftout;
     end

   always @ ( negedge rst_ni or posedge clk_divrx )
     if ( rst_ni == 1'b0 ) 
       {sd1,sd} <= #(PARAM_DELAY) 1'b0;
     else
       {sd1,sd} <= #(PARAM_DELAY) {sd,~noswitch};

   assign fsd = sd1 | sd;

endmodule  // arriaii_hssi_pma_c_deser


module arriaii_hssi_pma_c_div4or5_mcnt (clk, clkb, d5, fout, foutn, rst_n, vccerx, vssex);
  output fout, foutn;
  input vccerx, vssex;
  input clk, clkb, d5, rst_n;

  reg clk_by2, clk_by4;
  reg a, b, c;  
  wire clk_by5;

assign foutn = ~fout;
assign fout = (d5) ? clk_by5 : clk_by4;

// Divide-by-4 clock
always @ (rst_n or posedge clk)
  if (!rst_n)
    clk_by2 <= 1'b0;
  else
    clk_by2 <= ~clk_by2;

always @ (negedge rst_n or posedge clk_by2)
  if (!rst_n)
    clk_by4 <= 1'b0;
  else
    clk_by4 <= ~clk_by4;
    
// Divide-by-5 clock
assign clk_by5 = (clk | ~b) & (a | clk_by5);
always @ (negedge rst_n or posedge clk)
  if (!rst_n)
    begin
      a <= 1'b0;
      b <= 1'b0;
      c <= 1'b0;
    end
  else
    begin
      a <= (~a & ~b & c);
      b <= (~a & ~c);
      c <= (b);
    end

endmodule  // arriaii_hssi_pma_c_div4or5_mcnt


module arriaii_hssi_pma_c_lockdet_tx18 (
   disableb, dn, dnb, ib50, lock, lockb, pd, up, upb, vccerx, vssex );

   input   disableb;
   input   dn;
   input   dnb;
   input   pd;
   input   up;
   input   upb;
   input   vccerx;
   input   vssex;

   inout   ib50;

   output  lock;
   output  lockb;

  reg [4:0] cnt;

  assign lock = (cnt === 5'd3);
  assign lockb = ~lock;

  always @ (pd or posedge up)
    if (pd)
      cnt <= 5'd0;
    else if (cnt !== 5'd3)
      cnt <= cnt + 1;

endmodule // arriaii_hssi_pma_c_lockdet_tx18

module arriaii_hssi_pma_c_pfd (dn, dnb, fbclk, refclk, up, upb, vccerx, vssex);
  output dn, dnb, up, upb;
  input vccerx, vssex;
  input fbclk, refclk;

assign up  = refclk;
assign upb = ~refclk;
assign dn  = fbclk;
assign dnb = ~fbclk;

endmodule  // arriaii_hssi_pma_c_pfd

module arriaii_hssi_pma_c_rlpbk_ctrl (
   cru_rlbk, rrevlb_sw, rrx_s_rdlpbk, tx_rlpbk, vccerx, vssex );

   input   cru_rlbk;
   input   rrevlb_sw;
   input   rrx_s_rdlpbk;
   input   vccerx;
   input   vssex;

   output  tx_rlpbk;

assign tx_rlpbk = (rrevlb_sw) ? cru_rlbk : rrx_s_rdlpbk;

endmodule // arriaii_hssi_pma_c_rlpbk_ctrl

//====Revision Log================
//Rev: 1.1   Fri Oct  5 16:32:34 PDT 2007   cgaillar
//Added timescale
//====End Log======================

`ifdef POF
`timescale 1ps/1fs
`endif

module arriaii_hssi_pma_c_rlpbk_mux (
   doddn, doddp, dodn, dodp, don, don_pre, dop, dop_pre, drxn, drxp, sel, vcce_la,
   voddn, voddp, vodn, vodp, von, von_pre, vop, vop_pre, vssex );

   input   doddn;
   input   doddp;
   input   dodn;
   input   dodp;
   input   don;
   input   don_pre;
   input   dop;
   input   dop_pre;
   input   drxn;
   input   drxp;
   input   sel;
   input   vcce_la;
   input   vssex;

   output  voddn;
   output  voddp;
   output  vodn;
   output  vodp;
   output  von;
   output  von_pre;
   output  vop;
   output  vop_pre;

   assign  von     = sel ? don : drxn;
   assign  vop     = sel ? dop : drxp;
   assign  voddn   = doddn;
   assign  voddp   = doddp;
   assign  vodn    = dodn;
   assign  vodp    = dodp;
   assign  von_pre = don_pre;
   assign  vop_pre = dop_pre;

endmodule // arriaii_hssi_pma_c_rlpbk_mux

//====Revision Log================
//Rev: 1.19   Wed Jun 18 11:42:15 PDT 2008   cgaillar
//Removed all 1'b1 & 1'b0 from instances. Added ifdef COSIM flag to change delay parameter from 1 to 0.05 and 2 to 0.1
//====End Log======================

module arriaii_hssi_pma_c_rx (
   ac_mode, analog_sd, atb0_rx, atb1_rx, atbsel, bsmode, bsrxn_in, bsrxn_out, bsrxp_in,
   bsrxp_out, ck0_sigdet, eqa_ctrl, eqb_ctrl, eqc_ctrl, eqd_ctrl, eqv_ctrl, ibc50u,
   ibp50u, ibp150u, inn, inn3, inp, inp3, lpbkn, lpbkp, mem_init, oc_calpd, oc_en,
   pd2, pd2_term, pd_rxclk_term, pdb, pdb_clk, pdbh_rx, pdbh_rxclk_term, pdbh_term,
   pdshft_clk, rbit_dc, rdlpbkn, rdlpbkn_far, rdlpbkp, rdlpbkp_far, refclk, rstn, rx_b50,
   rx_oc, rx_test, rx_testclk, rxbuf_ibias, rxn, rxp, s_lpbk, s_rdlpbk, sd_cdr, sd_cpon,
   sd_cpop, sd_force, sd_off, sd_on, sdlv, slew, term, vcce_la, vcce_oa, vccehtxqyx,
   vssexqyx, vtt );

   input        ac_mode;
   input  [5:0] atbsel;
   input        bsmode;
   input        bsrxn_in;
   input        bsrxp_in;
   input        ck0_sigdet;
   input        eqa_ctrl;
   input        eqb_ctrl;
   input        eqc_ctrl;
   input        eqd_ctrl;
   input        lpbkn;
   input        lpbkp;
   input        mem_init;
   input        oc_calpd;
   input        oc_en;
   input        pd2_term;
   input        pdb;
   input        pdb_clk;
   input        pdbh_term;
   input        pdshft_clk;
   input  [3:0] rbit_dc;
   input        refclk;
   input        rstn;
   input  [3:0] rx_b50;
   input  [7:0] rx_oc;
   input        rx_test;
   input        rx_testclk;
   input        s_lpbk;
   input        s_rdlpbk;
   input        sd_force;
   input  [4:0] sd_off;
   input  [3:0] sd_on;
   input  [3:0] sdlv;
   input  [1:0] slew;
   input  [2:0] term;
   input        vcce_la;
   input        vcce_oa;
   input        vccehtxqyx;
   input        vssexqyx;
   input  [2:0] vtt;

   inout        atb0_rx;
   inout        atb1_rx;
   inout        eqv_ctrl;
   inout  [1:0] ibc50u;
   inout  [3:0] ibp50u;
   inout  [1:0] ibp150u;
   inout        inn;
   inout        inp;

   output       analog_sd;
   output       bsrxn_out;
   output       bsrxp_out;
   output       inn3;
   output       inp3;
   output       pd2;
   output       pd_rxclk_term;
   output       pdbh_rx;
   output       pdbh_rxclk_term;
   output       rdlpbkn;
   output       rdlpbkn_far;
   output       rdlpbkp;
   output       rdlpbkp_far;
   output       rxbuf_ibias;
   output       rxn;
   output       rxp;
   output       sd_cdr;
   output       sd_cpon;
   output       sd_cpop;

   parameter    PARAM_DELAY = 0;
   parameter    SD_PULSE_DELAY = 1;
   parameter    INVALID_SD_ON_OFF = 500;

   wire   [2:0] ib50uc2;
  
   wire        vccbn1g, d_vm, vbn_lb, vbn_dlb, vbn2_dlb, rxbuf_vcc, rxbuf_vsg;
   wire        dlbpd, lbpd, lpmuxp, lpmuxn, rx_testclkpd, rx_testpd, slbpd;
   wire        linepd, pdh_rx;

   reg         rst_sdn, rst_sdp, sdp, sdn, sd_on_chg, sd_off_chg;
   integer     sd_1_compout_pulse, sd_0_ck0_pulse, sdp_count, sdn_count; 
   integer     ck0_sigdet_count_cpop, ck0_sigdet_count_cpon;

// pd2_term, pdb_clk, pdbh_term and pdsht_clk - added in ww1
   assign pd2             = ~pdb;
   assign pd_rxclk_term   = ~(pdb_clk | pdb);
   assign pdbh_rx         = pdb;
   assign pdh_rx          = pd2;
   assign pdbh_rxclk_term = ~(pdshft_clk & pdh_rx);

// txgate instances
   assign atb0_rx = atbsel[0] ? vccbn1g     : 1'bz; // rxbuf_vcc, rxbuf_vsg, vbn2_dlb,
   assign atb1_rx = atbsel[0] ? d_vm        : 1'bz; // vbn_dlb, vbn_lb, d_vm, vccbn1g are 'z'
   assign atb0_rx = atbsel[1] ? rxbuf_ibias : 1'bz;
   assign atb1_rx = atbsel[1] ? vbn_lb      : 1'bz; //
   assign atb0_rx = atbsel[2] ? vbn_dlb     : 1'bz; //
   assign atb1_rx = atbsel[2] ? vbn2_dlb    : 1'bz; //
   assign atb0_rx = atbsel[3] ? rxbuf_vcc   : 1'bz; //
   assign atb1_rx = atbsel[3] ? rxbuf_vsg   : 1'bz; //
   assign atb0_rx = atbsel[4] ? vssexqyx    : 1'bz;
   assign atb1_rx = atbsel[4] ? vssexqyx    : 1'bz;

// c_rx_dlb - buffer w/ power-down (loopback to TX)
   assign dlbpd   = ~(s_rdlpbk & pdb);
   assign rdlpbkp = (dlbpd) ? 1'b1 : rxp; 
   assign rdlpbkn = (dlbpd) ? 1'b0 : rxn;

   assign rdlpbkp_far = rdlpbkp;
   assign rdlpbkn_far = rdlpbkn;

// rx test mux
   assign   rx_testclkpd  = ~(rx_testclk & pdb);
   assign      rx_testpd  = ~(   rx_test & pdb);
   assign          slbpd  = ~(    s_lpbk & pdb);
   assign {lpmuxp,lpmuxn} = ( {~rx_testclkpd,~rx_testpd,~slbpd} == 3'b001 ) ? { lpbkp,  lpbkn} :
                            ( {~rx_testclkpd,~rx_testpd,~slbpd} == 3'b010 ) ? { lpbkp,  lpbkn} :
                            ( {~rx_testclkpd,~rx_testpd,~slbpd} == 3'b100 ) ? {refclk,~refclk} : 
                            ( {~rx_testclkpd,~rx_testpd,~slbpd} == 3'b000 ) ?  2'bzz : 2'bxx;

// c_rx_lb - buffer w/ power-down (loopback from serializer)
   assign lbpd = ~( (s_lpbk | rx_testclk | rx_test ) & pdb );
   assign inp3 = pdb ? ((lbpd) ? inp : lpmuxp) : 1'b1;
   assign inn3 = pdb ? ((lbpd) ? inn : lpmuxn) : 1'b1;

// c_rx_term_vtt black-box

// c_rx_buffer instance
   assign linepd = ~lbpd;

   assign rxp      = pdb ? inp3 : 1'b1;
   assign rxn	   = pdb ? inn3 : 1'b1;

// c_sd - signal detect 
   assign analog_sd    = sdp | sdn;
   assign sd_cdr       = sd_force | s_lpbk | analog_sd;
   assign sd_cpop      = (inp !== 1'bz) ? (inp & pdb) : 1'b0; // for digital simulation, assuming inp and inn are comparator's outputs
   assign sd_cpon      = (inn !== 1'bz) ? (inn & pdb) : 1'b0;

   initial begin
     rst_sdn <= 1'b0;
     rst_sdp <= 1'b0;
     sdp_count   <= 0;
     sdn_count   <= 0;
     ck0_sigdet_count_cpop <= 0;
     ck0_sigdet_count_cpon <= 0;
     sdp         <= 1'b0;
     sdn         <= 1'b0;
   end

   always @ ( sd_on ) begin
     if ( (sd_on == 4'b0000) | (sd_on == 4'b1111) ) begin
       sd_1_compout_pulse <= INVALID_SD_ON_OFF;
//       $display ("Instance %m, Time %t: ERROR [Illegal usage]: The SD_ON value is illegal - sd_on=%b", $time, sd_on);
     end
     else
       case ( sd_on )
         4'b0001 : sd_1_compout_pulse <= 4;
         4'b0010 : sd_1_compout_pulse <= 6;
         4'b0011 : sd_1_compout_pulse <= 8;
         4'b0100 : sd_1_compout_pulse <= 10;
         4'b0101 : sd_1_compout_pulse <= 12;
         4'b0110 : sd_1_compout_pulse <= 14;
         4'b0111 : sd_1_compout_pulse <= 16;
         4'b1000 : sd_1_compout_pulse <= 18;
         4'b1001 : sd_1_compout_pulse <= 20;
         4'b1010 : sd_1_compout_pulse <= 22;
         4'b1011 : sd_1_compout_pulse <= 24;
         4'b1100 : sd_1_compout_pulse <= 26;
         4'b1101 : sd_1_compout_pulse <= 28;
         4'b1110 : sd_1_compout_pulse <= 30;
         default : sd_1_compout_pulse <= 4;
       endcase
       sd_1_compout_pulse = sd_on;
     sd_on_chg <= 1'b1;
     sd_on_chg <= #(SD_PULSE_DELAY) 1'b0;
   end 
  
   always @ ( sd_off ) begin
     if (sd_off == 4'b1111) begin
       sd_0_ck0_pulse <= INVALID_SD_ON_OFF;
//       $display ("Instance %m, Time %t: ERROR [Illegal usage]: The SD_OFF value is illegal - sd_off=%b", $time, sd_off);
     end
     else
       case ( sd_off[3:0] )
         4'b0001 : sd_0_ck0_pulse <= 4;
         4'b0010 : sd_0_ck0_pulse <= 6;
         4'b0011 : sd_0_ck0_pulse <= 8;
         4'b0100 : sd_0_ck0_pulse <= 10;
         4'b0101 : sd_0_ck0_pulse <= 12;
         4'b0110 : sd_0_ck0_pulse <= 14;
         4'b0111 : sd_0_ck0_pulse <= 16;
         4'b1000 : sd_0_ck0_pulse <= 18;
         4'b1001 : sd_0_ck0_pulse <= 20; 
         4'b1010 : sd_0_ck0_pulse <= 22;
         4'b1011 : sd_0_ck0_pulse <= 24;
         4'b1100 : sd_0_ck0_pulse <= 26;
         4'b1101 : sd_0_ck0_pulse <= 28;
         4'b1110 : sd_0_ck0_pulse <= 30;
         default : sd_0_ck0_pulse <= 4;
       endcase
     sd_off_chg <= 1'b1;
     sd_off_chg <= #(SD_PULSE_DELAY) 1'b0;
   end

   // Set sdp
   always @ ( negedge sd_cpop or posedge rst_sdp or negedge rstn or posedge sd_on_chg )
     if ( (rst_sdp == 1'b1) | (sd_on_chg == 1'b1) | (rstn == 1'b0) ) begin
       sdp       <= #(PARAM_DELAY) 1'b0; 
       sdp_count <= 0;
     end  
     else begin
       sdp_count = sdp_count + 1;
       if ( sdp_count >= sd_1_compout_pulse )
         sdp <= #(PARAM_DELAY) 1'b1;
     end

   // Set sdn
   always @ ( negedge sd_cpon or negedge rstn or posedge rst_sdn or posedge sd_on_chg )
     if ( (rst_sdn == 1'b1) | (sd_on_chg == 1'b1) | (rstn == 1'b0) ) begin
       sdn       <= #(PARAM_DELAY) 1'b0;
       sdn_count <= 0;
     end
     else begin
       sdn_count = sdn_count + 1;
       if ( sdn_count >= sd_1_compout_pulse )
         sdn <= #(PARAM_DELAY) 1'b1;
     end

   // Clear sdp -- generate rst_sdp
   always @ ( ck0_sigdet or posedge sd_cpop ) begin
     if ( (ck0_sigdet == 1'b0) & (sd_cpop == 1'b0) ) begin
       ck0_sigdet_count_cpop = ck0_sigdet_count_cpop + 1;
       if ( ck0_sigdet_count_cpop == sd_0_ck0_pulse ) 
         rst_sdp          <= 1'b1;
     end       
     else if ( ck0_sigdet == 1'b1 )
       rst_sdp <= 1'b0;
     if ( sd_cpop == 1'b1 )
       ck0_sigdet_count_cpop = 0;
   end

   // Clear sdn -- generate rst_sdn
   always @ ( ck0_sigdet or posedge sd_cpon ) begin
     if ( (ck0_sigdet == 1'b0) & (sd_cpon == 1'b0) ) begin
       ck0_sigdet_count_cpon = ck0_sigdet_count_cpon + 1;
      if ( ck0_sigdet_count_cpon == sd_0_ck0_pulse ) 
         rst_sdn          <= 1'b1;
     end
     else if ( ck0_sigdet == 1'b1 )
       rst_sdn <= 1'b0;
     if ( sd_cpon == 1'b1 )
       ck0_sigdet_count_cpon = 0;
   end

endmodule // c_rx

//====Revision Log================
//Rev: 1.8   Wed Jun 18 11:42:15 PDT 2008   cgaillar
//Removed all 1'b1 & 1'b0 from instances. Added ifdef COSIM flag to change delay parameter from 1 to 0.05 and 2 to 0.1
//====End Log======================

module arriaii_hssi_pma_c_ser_20to10 (
   clk_divtx, data, data_a, data_b, div2, lfclk_n, lfclk_p, pclk_in, pclksel, rst_n,
   vccetxqyx, vssexqyx );

   input  [9:0] data_a;
   input  [9:0] data_b;
   input        div2;
   input        lfclk_n;
   input        lfclk_p;
   input        pclk_in;
   input        pclksel;
   input        rst_n;
   input        vccetxqyx;
   input        vssexqyx;

   output       clk_divtx;
   output [9:0] data;

   parameter     PARAM_DELAY = 0;
`ifdef COSIM
   parameter     PARAM_DELAY_1 = 0.05; 
`else
   parameter     PARAM_DELAY_1 = 1;
`endif

   wire         rst_pdb, sel, nc0, nc1, nc2;
   wire   lfclk_div2;

   reg    [9:0] d10m;
   reg    [9:0] data, d10a, d10b;//, lfclk_p_del;

   assign sel     = ~clk_divtx & div2;
   assign rst_pdb = rst_n & div2;

   initial begin
     data <= 10'b0000000000; // To avoid propagation of 'X' first clock cycles
     d10a <= 10'b0000000000;
     d10b <= 10'b0000000000;
   end

   // xdivby2
   arriaii_hssi_pma_c_divby2q xdiv2_2 (
      .clk(lfclk_p), .clkb(lfclk_n), .clk0(nc0), .clk90(nc1),
      .vcce_la(vccetxqyx), .vssexqyx(vssexqyx),
     .clk180(lfclk_div2), .clk270(nc2), .rst_n(rst_n) );

   // c_mux2to1_4xd - xi37 // clk_divtx is same as halfclk_p
   assign clk_divtx = ( {pclksel,div2} == 2'b00 ) ? lfclk_p    :
                      ( {pclksel,div2} == 2'b01 ) ? lfclk_div2 :
                      ( {pclksel,div2} == 2'b10 ) ? pclk_in    : 
                      ( {pclksel,div2} == 2'b11 ) ? pclk_in    : 1'bx ;

   // Pipe A
   always @ ( posedge clk_divtx or negedge rst_n )
     if ( rst_n == 1'b0 )
       d10a <= #(PARAM_DELAY) 10'b0000000000;
     else
       d10a <= #(PARAM_DELAY) data_a;

   // Pipe B
   always @ ( posedge clk_divtx or negedge rst_pdb )
     if ( rst_pdb == 1'b0 )
       d10b <= #(PARAM_DELAY) 10'b0000000000;
     else
       d10b <= #(PARAM_DELAY) data_b;

 
   always @ ( sel, d10b, d10a )
     if ( sel )
       d10m <= #(PARAM_DELAY_1) d10b;
     else
       d10m <= #(PARAM_DELAY_1) d10a;

   // Pipe #2
   always @ ( posedge lfclk_p or negedge rst_n )
     if ( rst_n == 1'b0 ) 
       data <= #(PARAM_DELAY) 10'b0000000000;
     else 
       data <= #(PARAM_DELAY) d10m;

endmodule // arriaii_hssi_pma_c_ser_20to10

//====Revision Log================
//Rev: 1.23   Wed Jun 18 11:42:15 PDT 2008   cgaillar
//Removed all 1'b1 & 1'b0 from instances. Added ifdef COSIM flag to change delay parameter from 1 to 0.05 and 2 to 0.1
//====End Log======================

module arriaii_hssi_pma_c_ser (
   clk_divtx, cpulse, data, div2, div5, hfclkn, hfclkp, lbvon, lbvop, lfclkn, lfclkp,
   pclk_in, pclksel, pdb, pre_em, pre_em_2t, pre_em_pretap, pre_en_out, rst_n, s_lpbk,
   vccelxqyx, vccetxqyx, von, von_op1, von_op2, von_pre, vop, vop_op1, vop_op2, vop_pre,
   vssexqyx );

   input         cpulse;
   input  [19:0] data;
   input         div2;
   input         div5;
   input         hfclkn;
   input         hfclkp;
   input         lfclkn;
   input         lfclkp;
   input         pclk_in;
   input         pclksel;
   input         pdb;
   input   [4:0] pre_em;
   input   [3:0] pre_em_2t;
   input   [3:0] pre_em_pretap;
   input         rst_n;
   input         s_lpbk;
   input         vccelxqyx;
   input         vccetxqyx;
   input         vssexqyx;

   output        clk_divtx;
   output        lbvon;
   output        lbvop;
   output        pre_en_out;
   output        von;
   output        von_op1;
   output        von_op2;
   output        von_pre;
   output        vop;
   output        vop_op1;
   output        vop_op2;
   output        vop_pre;

   parameter     PARAM_DELAY = 0;

   wire       pre_en, pre_en_pretap, pre_en_2t, s_lpbkbuf, div5buf, rst_nbuf, rst_pdb;
   wire       pe_pre, pe, pe_2t, lben, lben_rst; 
   wire [9:0] d10, d10m;
   wire       lfclk_div2;
   wire       nc0, nc1, nc3;

   reg  [9:0] data_mux5t1_sync1;
   reg  [4:0] do_mux5t1_sync2, de_mux5t1_sync2;
   reg        cp_even, c0_even, c1_even, c2_even, c3_even, c4_even;
   reg        cp_odd, c0_odd, c1_odd, c2_odd, c3_odd, c4_odd;
   reg        out_o, out_e, vop_pre_reg, von_pre_reg, vop_reg, von_reg, vop_op1_reg, von_op1_reg;
   reg        oo1, oo2, oo3, oe1, oe2, oe3, vop_op2_reg, von_op2_reg, out_lb_reg, outb_lb_reg;
   wire clk_divtx_wire;

   assign pre_en_out    = |pre_em;
   assign pre_en_pretap = |pre_em_pretap;
   assign pre_en_2t     = |pre_em_2t;
   assign s_lpbkbuf     = pdb & s_lpbk;
   assign div5buf       = pdb & div5;
   assign rst_nbuf      = pdb & rst_n;
assign clk_divtx = clk_divtx_wire;

   // * * c_ser_20to10 -- x20to10 instance * *
   assign rst_pdb = rst_n & div2; 

   initial begin
     data_mux5t1_sync1 <= 10'b0000000000;
     de_mux5t1_sync2[4:0] <= 5'b00000;
     do_mux5t1_sync2[4:0] <= 5'b00000;
     vop_op1_reg <= 1'b0;
     von_op1_reg <= 1'b1;
     vop_op2_reg <= 1'b0;
     von_op2_reg <= 1'b1;
     vop_reg <= 1'b0;
     von_reg <= 1'b1;
     vop_pre_reg <= 1'b0;
     von_pre_reg <= 1'b1;
     out_lb_reg <= 1'b0;
     outb_lb_reg <= 1'b1;
     {out_o, out_e} <= 2'b00;
     {oo1, oe1} <= 2'b00;
     {oo2, oe2} <= 2'b00;
     {oo3, oe3} <= 2'b00;
     {cp_even,c0_even,c1_even,c2_even,c3_even,c4_even} <= 6'b000000;
     {cp_odd,c0_odd,c1_odd,c2_odd,c3_odd,c4_odd} <= 6'b000000;
   end

   // * * c_ser_20to10 * *
   arriaii_hssi_pma_c_ser_20to10 x20to10 (
      .clk_divtx(clk_divtx), .data(d10), .data_a(data[9:0]), .data_b(data[19:10]), .div2(div2),
      .lfclk_n(lfclkn), .lfclk_p(lfclkp), .pclk_in(pclk_in), .pclksel(pclksel), .rst_n(rst_nbuf),
      .vccetxqyx(vccetxqyx), .vssexqyx(vssexqyx) );

   // * * c_ser_mux5to1 -- xmux5to1_even & odd instances * *  
   // Pipe #1 - synchronize data to lfclkp negedge
   always @ ( posedge lfclkn or negedge rst_nbuf )
     if ( ~rst_nbuf ) 
     data_mux5t1_sync1 <= #(PARAM_DELAY) 10'b0000000000;
     else 
       data_mux5t1_sync1 <= #(PARAM_DELAY) d10;

   // Pipe #2 - Synchronize 0,2,4 and 1,3 to CLK and CLKB ; 6,8 and 5,7,9 to CLK and CLKB
   always @ ( posedge lfclkp or negedge rst_nbuf ) 
     if ( ~rst_nbuf ) begin
       de_mux5t1_sync2[2:0] <= #(PARAM_DELAY) 3'b000;
       do_mux5t1_sync2[1:0] <= #(PARAM_DELAY) 2'b00;
     end
     else begin
       de_mux5t1_sync2[2:0] <= #(PARAM_DELAY) {data_mux5t1_sync1[4],data_mux5t1_sync1[2],data_mux5t1_sync1[0]};
       do_mux5t1_sync2[1:0] <= #(PARAM_DELAY) {data_mux5t1_sync1[3],data_mux5t1_sync1[1]};
     end

   always @ ( posedge lfclkn or negedge rst_nbuf )
     if ( ~rst_nbuf ) begin
       de_mux5t1_sync2[4:3] <= #(PARAM_DELAY) 2'b00;
       do_mux5t1_sync2[4:2] <= #(PARAM_DELAY) 3'b000;
     end
     else begin
       de_mux5t1_sync2[4:3] <= #(PARAM_DELAY) {data_mux5t1_sync1[8],data_mux5t1_sync1[6]};
       do_mux5t1_sync2[4:2] <= #(PARAM_DELAY) {data_mux5t1_sync1[9],data_mux5t1_sync1[7],data_mux5t1_sync1[5]};
     end

   // Pulse generation for odd and even - CPULSE, CP, C0, ..., C4
   always @ ( posedge hfclkn or negedge rst_nbuf ) 
     if ( ~rst_nbuf )
       {c4_even,c3_even,c2_even,c1_even,c0_even} <= #(PARAM_DELAY) 5'b00000;
     else begin
       c0_even <= #(PARAM_DELAY) cpulse;
       c1_even <= #(PARAM_DELAY) c0_even;
       c2_even <= #(PARAM_DELAY) c1_even;
       c3_even <= #(PARAM_DELAY) c2_even;
       if ( div5buf == 1'b1 ) c4_even <= #(PARAM_DELAY) c3_even;
     end

   always @ ( posedge hfclkn or negedge rst_nbuf ) // Mux Odd
     if ( ~rst_nbuf)
       cp_odd <= #(PARAM_DELAY) 1'b0;
     else
       cp_odd <= #(PARAM_DELAY) cpulse;

   always @ ( posedge hfclkp or negedge rst_nbuf )
     if ( ~rst_nbuf)
       {c4_odd,c3_odd,c2_odd,c1_odd,c0_odd} <= #(PARAM_DELAY) 5'b00000;
     else begin
       c0_odd <= #(PARAM_DELAY) cp_odd;
       c1_odd <= #(PARAM_DELAY) c0_odd;
       c2_odd <= #(PARAM_DELAY) c1_odd;
       c3_odd <= #(PARAM_DELAY) c2_odd;
       if ( div5buf == 1'b1 ) c4_odd <= #(PARAM_DELAY) c3_odd;
     end

   // Mux2to1 Even outputs
   always @ ( posedge c0_even ) if ( c0_even == 1'b1 ) begin
     out_e <= #(PARAM_DELAY) de_mux5t1_sync2[0];
   end

   always @ ( posedge c1_even ) if ( c1_even == 1'b1 ) begin
     out_e <= #(PARAM_DELAY) de_mux5t1_sync2[1];
   end

   always @ ( posedge c2_even ) if ( c2_even == 1'b1 ) begin
     out_e <= #(PARAM_DELAY) de_mux5t1_sync2[2];
   end

   always @ ( posedge c3_even ) if ( c3_even == 1'b1 ) begin
     out_e <= #(PARAM_DELAY) de_mux5t1_sync2[3];
   end

   always @ ( posedge c4_even ) if ( c4_even == 1'b1 ) begin
     out_e <= #(PARAM_DELAY) de_mux5t1_sync2[4];
   end

   // Mux2to1 Odd outputs
   always @ ( posedge c0_odd ) if ( c0_odd == 1'b1 ) begin
     out_o <= #(PARAM_DELAY) do_mux5t1_sync2[0];
   end

   always @ ( posedge c1_odd ) if ( c1_odd == 1'b1 ) begin
     out_o <= #(PARAM_DELAY) do_mux5t1_sync2[1];
   end

   always @ ( posedge c2_odd ) if ( c2_odd == 1'b1 ) begin
     out_o <= #(PARAM_DELAY) do_mux5t1_sync2[2];
   end

   always @ ( posedge c3_odd ) if ( c3_odd == 1'b1 ) begin
     out_o <= #(PARAM_DELAY) do_mux5t1_sync2[3];
   end

   always @ ( posedge c4_odd ) if ( c4_odd == 1'b1 ) begin
     out_o <= #(PARAM_DELAY) do_mux5t1_sync2[4];
   end

   // * * c_ser_mux2to1 -- xmux2to1 instance * *
   assign pe_pre  = pre_en_pretap & rst_nbuf & pdb;
   assign pe      = pre_en_out    & rst_nbuf & pdb; 
   assign pe_2t   = pre_en_2t     & rst_nbuf & pdb;

   assign vop_pre = pe_pre ? vop_pre_reg : 1'b1;
   assign von_pre = pe_pre ? von_pre_reg : 1'b1;
   assign vop     = pdb    ? vop_reg     : 1'b1;
   assign von     = pdb    ? von_reg     : 1'b1;
   assign vop_op1 = pe     ? vop_op1_reg : 1'b1;
   assign von_op1 = pe     ? von_op1_reg : 1'b1;
   assign vop_op2 = pe_2t  ? vop_op2_reg : 1'b1;
   assign von_op2 = pe_2t  ? von_op2_reg : 1'b1;

   // FFs for OO & OE 1, 2 and 3 Generation
   always @ ( posedge hfclkn or negedge rst_nbuf ) 
     if ( ~rst_nbuf)
       {oe3,oo2,oe1} <= #(PARAM_DELAY) 3'b000;
     else begin
       oe1 <= #(PARAM_DELAY) out_e;
       oo2 <= #(PARAM_DELAY) oo1;
       oe3 <= #(PARAM_DELAY) oe2;
     end

   always @ ( posedge hfclkp or negedge rst_nbuf ) 
     if ( ~rst_nbuf) 
       {oo3,oe2,oo1} <= #(PARAM_DELAY) 3'b000;
     else begin
       oo1 <= #(PARAM_DELAY) out_o;
       oe2 <= #(PARAM_DELAY) oe1;
       oo3 <= #(PARAM_DELAY) oo2;
     end

   // FFs for VOP/N_PRE, VOP/N, VOP/N_OP1 and VOP/N_OP2 Outputs Generation 
   always @ ( posedge hfclkp or negedge pe_pre ) 
     if ( ~pe_pre ) begin
       vop_pre_reg <= #(PARAM_DELAY) 1'b0;
       von_pre_reg <= #(PARAM_DELAY) 1'b1;
     end
     else begin 
       vop_pre_reg <= #(PARAM_DELAY)  out_o;
       von_pre_reg <= #(PARAM_DELAY) ~out_o;
     end

   always @ ( posedge hfclkn or negedge pe_pre )
     if ( ~pe_pre ) begin
       vop_pre_reg <= #(PARAM_DELAY) 1'b0;
       von_pre_reg <= #(PARAM_DELAY) 1'b1;
     end
     else begin 
       vop_pre_reg <= #(PARAM_DELAY)  out_e;
       von_pre_reg <= #(PARAM_DELAY) ~out_e;
     end

   always @ ( posedge hfclkp or negedge pdb )  
     if ( ~pdb ) begin
       vop_reg <= #(PARAM_DELAY) 1'b0;
       von_reg <= #(PARAM_DELAY) 1'b1;
     end
     else begin
       vop_reg <= #(PARAM_DELAY)  oe1;
       von_reg <= #(PARAM_DELAY) ~oe1;
     end

   always @ ( posedge hfclkn or negedge pdb ) 
     if ( ~pdb ) begin
       vop_reg <= #(PARAM_DELAY) 1'b0;
       von_reg <= #(PARAM_DELAY) 1'b1;
     end
     else begin
       vop_reg <= #(PARAM_DELAY)  oo1;
       von_reg <= #(PARAM_DELAY) ~oo1;
     end

   always @ ( posedge hfclkp or negedge pe )
     if ( ~pe ) begin
       vop_op1_reg <= #(PARAM_DELAY) 1'b0;
       von_op1_reg <= #(PARAM_DELAY) 1'b1;
     end
     else begin
       vop_op1_reg <= #(PARAM_DELAY)  oo2;
       von_op1_reg <= #(PARAM_DELAY) ~oo2;
     end

   always @ ( posedge hfclkn or negedge pe )
     if ( ~pe ) begin
       vop_op1_reg <= #(PARAM_DELAY) 1'b0;
       von_op1_reg <= #(PARAM_DELAY) 1'b1;
     end
     else begin
       vop_op1_reg <= #(PARAM_DELAY)  oe2;
       von_op1_reg <= #(PARAM_DELAY) ~oe2;
     end

   always @ ( posedge hfclkp or negedge pe_2t )
     if ( ~pe_2t ) begin
       vop_op2_reg <= #(PARAM_DELAY) 1'b0;
       von_op2_reg <= #(PARAM_DELAY) 1'b1;
     end
     else begin
       vop_op2_reg <= #(PARAM_DELAY)  oe3;
       von_op2_reg <= #(PARAM_DELAY) ~oe3;
     end

   always @ ( posedge hfclkn or negedge pe_2t )
     if ( ~pe_2t ) begin
       vop_op2_reg <= #(PARAM_DELAY) 1'b0;
       von_op2_reg <= #(PARAM_DELAY) 1'b1;
     end
     else begin
       vop_op2_reg <= #(PARAM_DELAY)  oo3;
       von_op2_reg <= #(PARAM_DELAY) ~oo3;
     end

   // * * c_ser_mux2to1_lb -- xmux2to1_lb instance * *
   assign lben     = pdb & s_lpbkbuf;
   assign lben_rst = pdb & s_lpbkbuf & rst_n;
   assign lbvop = lben ? out_lb_reg  : 1'b1;
   assign lbvon = lben ? outb_lb_reg : 1'b1;

   always @ ( posedge hfclkn or negedge lben_rst )
     if ( ~lben_rst ) begin
       out_lb_reg  <= #(PARAM_DELAY) 1'b0;
       outb_lb_reg <= #(PARAM_DELAY) 1'b1;
     end
     else begin
       out_lb_reg  <= #(PARAM_DELAY)  out_e; 
       outb_lb_reg <= #(PARAM_DELAY) ~out_e;
     end

   always @ ( posedge hfclkp or negedge lben_rst )
     if ( ~lben_rst ) begin
       out_lb_reg  <= #(PARAM_DELAY) 1'b0;
       outb_lb_reg <= #(PARAM_DELAY) 1'b1;
     end
     else begin
       out_lb_reg  <= #(PARAM_DELAY)  out_o; 
       outb_lb_reg <= #(PARAM_DELAY) ~out_o;
     end

endmodule // arriaii_hssi_pma_c_ser

// Modified from c_sdffrr_1x.v

module arriaii_hssi_pma_c_sdl_en_2x (
   clk, d, db, en, out, outb, vcce_la, vssex );

   input   clk;
   input   d;
   input   db;
   input   en;
   input   vcce_la;
   input   vssex;
   
   output out, outb;

   reg    out, outb;

always @ (en or posedge clk)
begin
 if (~en)
   begin
     out  <= 1'b0;
     outb <= 1'b1;
   end
 else
   begin
     out  <= d;
     outb <= db;
   end
end
endmodule // arriaii_hssi_pma_c_sdl_en_2x

//====Revision Log================
//Rev: 1.5   Tue Jul  1 15:25:03 PDT 2008   cgaillar
//Updated c_tx port and rcv_detect logic to be on for differential data, in addition to '0,0' or '1,1'
//====End Log======================

module arriaii_hssi_pma_c_rcv_detect_div_by_2 (CLK, RESET_N, CLKOUT); // synthesis syn_black_box

   input         CLK, RESET_N;
   output        CLKOUT;
   reg           CLKOUT;
   wire 	 NEXT_VAL;
  
   initial CLKOUT = 1'b0;
 
   // state definition
   always @ (posedge CLK or negedge RESET_N)
     if (!RESET_N)
	  CLKOUT <= 1'b0;
     else
          CLKOUT <= NEXT_VAL;
   
    assign   NEXT_VAL = ~CLKOUT;

endmodule // div_by_2
// synchronizer to synchronize the receiver

module arriaii_hssi_pma_c_rcv_detect_clk_gen (CLK, RESET_N, CLKOUT);

   input         CLK, RESET_N;
   output	 CLKOUT;
   wire 	 CLKOUT;

   wire 	 CLK8M, CLK4M, CLK2M;
 	 
   arriaii_hssi_pma_c_rcv_detect_div_by_2         DIV_1(.CLK(CLK), .RESET_N(RESET_N), .CLKOUT(CLK8M));
   arriaii_hssi_pma_c_rcv_detect_div_by_2         DIV_2(.CLK(CLK8M), .RESET_N(RESET_N), .CLKOUT(CLK4M));
   arriaii_hssi_pma_c_rcv_detect_div_by_2         DIV_3(.CLK(CLK4M), .RESET_N(RESET_N), .CLKOUT(CLK2M));
   arriaii_hssi_pma_c_rcv_detect_div_by_2         DIV_4(.CLK(CLK2M), .RESET_N(RESET_N), .CLKOUT(CLKOUT));

endmodule // clk_gen


module arriaii_hssi_pma_c_rcv_detect_sync (CLK, RESET_N, RCV_DET, RCV_DET_OUT); // synthesis syn_black_box

   input         CLK, RESET_N, RCV_DET;
   output        RCV_DET_OUT;
   reg           RCV_DET_OUT;
   reg 		 RCV_DET_MID; 	 

   always @ (posedge CLK or negedge RESET_N)
     if (!RESET_N)
       begin
	  RCV_DET_OUT <= 1'b0;
	  RCV_DET_MID <= 1'b0;
       end
     else
       begin
          RCV_DET_OUT <= RCV_DET_MID;
	  RCV_DET_MID <= RCV_DET;
       end

endmodule // rcv_det_sync


// receiver detect finite state machine
module arriaii_hssi_pma_c_rcv_detect_fsm (CLK, RESET_N, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND, TX_DET_RX, RX_P, RX_N ); // synthesis syn_black_box

   input         CLK, RESET_N, COM_PASS, PROBE_PASS, TX_DET_RX, RX_P, RX_N;
   
   output 	 RCV_FOUND, DET_ON, DETECT_VALID;
   reg [2:0] 	 STATE;
   reg [2:0] 	 NEXTSTATE;
   reg 		 RCV_FOUND, DET_ON, NEXT_RCV_FOUND, DETECT_VALID;
   
   reg		FAKE_RCV_PRESENT;

   wire         RXPN_NOT_Z;
   
 // state definition
   parameter RESET   = 3'b000;
   parameter WAKE    = 3'b001;
   parameter STATE_1 = 3'b011;
   parameter STATE_2 = 3'b101;
   parameter HOLD    = 3'b100;
   
// manju : FAKE_RCV_PRESENT will always be '1' as no Denali models.
//   assign    RXPN_NOT_Z = ( (RX_P == 1'b1) && (RX_N == 1'b1) || (RX_P == 1'b0) && (RX_N == 1'b0) ||
//                              (RX_P == 1'b0) && (RX_N == 1'b1) || (RX_P == 1'b1) && (RX_N == 1'b0) ) ? 1'b1 : 1'b0; 
 
   initial
   begin
   	FAKE_RCV_PRESENT = 1'b1;
        NEXTSTATE = 3'b001;
   end

// State logic and FSM
   always @ (posedge CLK or negedge RESET_N)
     if(!RESET_N)
       STATE <= RESET;
     else
       STATE <= NEXTSTATE;

   always @ (STATE or COM_PASS)
     begin
	case (STATE)
	  RESET: NEXTSTATE = WAKE;
	  WAKE: begin
	     if (COM_PASS) 
	     	NEXTSTATE = STATE_1;
	     else NEXTSTATE = WAKE;
	  end
	  STATE_1: NEXTSTATE = STATE_2;
	  STATE_2: NEXTSTATE = HOLD;
	  HOLD: NEXTSTATE = HOLD;
	  default: NEXTSTATE = RESET;
	endcase // case(state)
     end // always @ (state or com_pass)

// Output logic
   always @ (posedge CLK or negedge RESET_N)
     if(!RESET_N)
	  RCV_FOUND <= 1'b0;
     else
          RCV_FOUND <= NEXT_RCV_FOUND;

    always @ (NEXTSTATE or PROBE_PASS or FAKE_RCV_PRESENT)
      begin
	 if ((NEXTSTATE == STATE_2) && (!PROBE_PASS) && FAKE_RCV_PRESENT)  // probe pass goes up slow -> there is rx 
	   NEXT_RCV_FOUND = 1'b1;
	 else if ((NEXTSTATE == HOLD) && FAKE_RCV_PRESENT)
	   NEXT_RCV_FOUND = RCV_FOUND;
	 else    // probe pass goes up fast -> no rx
	   NEXT_RCV_FOUND = 1'b0;
      end
      
// there is no rcv_det_syn
   always @ (STATE)
     if (STATE == RESET)
       DET_ON = 1'b0;
     else
       DET_ON = 1'b1;
   	
   always @ (STATE)
     if (STATE == HOLD)
       DETECT_VALID = 1'b1;
     else
       DETECT_VALID = 1'b0;
   
endmodule // rcv_det_fsm


module arriaii_hssi_pma_c_rcv_detect_control (CLK, RCV_DET_EN, RCV_DET_PDB, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND, RX_P, RX_N);
   input         CLK, RCV_DET_EN, RCV_DET_PDB, COM_PASS, PROBE_PASS, RX_P, RX_N;
   output 	 DET_ON, DETECT_VALID, RCV_FOUND;
   wire 	 RCV_DET_SYN;
   
   arriaii_hssi_pma_c_rcv_detect_sync  XRCV_DET_SYNC (CLK, RCV_DET_PDB, RCV_DET_EN, RCV_DET_SYN);
   arriaii_hssi_pma_c_rcv_detect_fsm   XRCV_DET_FSM (CLK, RCV_DET_SYN, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND, RCV_DET_EN, RX_P, RX_N);
endmodule // rcv_det_control


// Digital part of the receiver detection
module arriaii_hssi_pma_c_rcv_det_digital (OSCCLK, RCV_DET_PDB, RCV_DET_EN, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND, RX_P, RX_N);

   input  OSCCLK, RCV_DET_PDB, RCV_DET_EN, COM_PASS, PROBE_PASS, RX_P, RX_N;
   output DET_ON, RCV_FOUND, DETECT_VALID;
   wire   CLK;

   arriaii_hssi_pma_c_rcv_detect_clk_gen         XCLK_GEN (OSCCLK, RCV_DET_PDB, CLK);
   arriaii_hssi_pma_c_rcv_detect_control XRCV_DET_CTRL(CLK, RCV_DET_EN, RCV_DET_PDB, COM_PASS, PROBE_PASS, DET_ON, DETECT_VALID, RCV_FOUND, RX_P, RX_N);
   
endmodule // rcv_det_digital


//====Revision Log================
//Rev: 1.5   Wed Apr 23 10:44:50 PDT 2008   cgaillar
//Reverted to probe_pass 1.3 version logic
//====End Log======================

`timescale 1ps / 1ps

module arriaii_hssi_pma_c_rcv_detect (
   com_pass, detect_on, fixed_clk_out, probe_pass, rcv_det_pdb, rdet,
   rx_det_clk, rx_det_valid, rx_found, sel_150r, tx_det_rx, rx_n, rx_p );

   input        rcv_det_pdb;
   input  [1:0] rdet;
   input        rx_det_clk;
   input        tx_det_rx;
   input        rx_p;
   input        rx_n;

   output       com_pass;
   output       detect_on;
   output       fixed_clk_out;
   output       probe_pass;
   output       rx_det_valid;
   output       rx_found;
   output       sel_150r;

   wire         com_pass, probe_pass;

   assign       fixed_clk_out = rx_det_clk;
   assign       sel_150r      = 1'b0;

   assign #100000       com_pass   = detect_on;
   assign #100000       probe_pass = 1'b0;

   // * * Analog portion not modeled * *

   arriaii_hssi_pma_c_rcv_det_digital XRCV_DET_DIGITAL (
      .OSCCLK (rx_det_clk), .RCV_DET_PDB (rcv_det_pdb), .RCV_DET_EN (tx_det_rx), 
      .COM_PASS (com_pass), .PROBE_PASS (probe_pass), .DET_ON (detect_on), 
      .DETECT_VALID (rx_det_valid), .RCV_FOUND (rx_found), .RX_N(rx_n), .RX_P(rx_p) );

endmodule // arriaii_hssi_pma_c_rcv_detect

//====Revision Log================
//Rev: 1.2   Tue Sep 23 17:46:02 PDT 2008   cgaillar
//Updated tx_det_rx and tx_elec_idl priority
//====End Log======================


module arriaii_hssi_pma_c_tx (
   atb0, atb1, bsmode, bsoeb, bstxn_in, bstxp_in, cgb_vccelxqyx, cgb_vssexqyx, com_pass, detect_on,
   fixed_clk_out, ib50uc_rcvdt, ib50uc_vcm, ib50ut_vcm, ib100uc, lst, pdb, probe_pass,
   r_dft_sel, r_dis_idlegate, r_highv, r_lowv, r_rx_det, r_slew, rlpbkn, rlpbkn_em,
   rlpbkp, rlpbkp_em, rpre_em_1t, rpre_em_2t, rpre_em_pt, rsig_inv_2t, rsig_inv_ptap,
   rterm_sel, rtx_rlpbk, rtx_vtt, rvod_sel, rx_det_clk, rx_det_pdb, rx_detect_valid,
   rx_found, sel_150r, tx50, tx_det_rx, tx_dftout, tx_elec_idl, vccehtxqyx, vccehxqyx,
   vccesdh_la, vccesdp_la, vccetxqyx, vin, vin_po1, vin_po2, vin_pre, vip, vip_po1,
   vip_po2, vip_pre, von, vop, vssexqyx, rx_p, rx_n );

   input        bsmode;
   input        bsoeb;
   input        bstxn_in;
   input        bstxp_in;
   input        cgb_vccelxqyx;
   input        cgb_vssexqyx;
   input  [3:0] lst;
   input        pdb;
   input  [2:0] r_dft_sel;
   input        r_dis_idlegate;
   input        r_highv;
   input        r_lowv;
   input  [1:0] r_rx_det;
   input  [1:0] r_slew;
   input        rlpbkn;
   input        rlpbkn_em;
   input        rlpbkp;
   input        rlpbkp_em;
   input  [4:0] rpre_em_1t;
   input  [3:0] rpre_em_2t;
   input  [3:0] rpre_em_pt;
   input        rsig_inv_2t;
   input        rsig_inv_ptap;
   input  [2:0] rterm_sel;
   input        rtx_rlpbk;
   input  [1:0] rtx_vtt;
   input  [2:0] rvod_sel;
   input        rx_det_clk;
   input        rx_det_pdb;
   input  [3:0] tx50;
   input        tx_det_rx;
   input        tx_elec_idl;
   input        vccehtxqyx;
   input        vccehxqyx;
   input        vccesdh_la;
   input        vccesdp_la;
   input        vccetxqyx;
   input        vin;
   input        vin_po1;
   input        vin_po2;
   input        vin_pre;
   input        vip;
   input        vip_po1;
   input        vip_po2;
   input        vip_pre;
   input        vssexqyx;
   input        rx_p;
   input        rx_n;

   inout        atb0;
   inout        atb1;
   inout        ib50uc_rcvdt;
   inout        ib50uc_vcm;
   inout        ib50ut_vcm;
   inout        ib100uc;

   output       com_pass;
   output       detect_on;
   output       fixed_clk_out;
   output       probe_pass;
   output       rx_detect_valid;
   output       rx_found;
   output       sel_150r;
   output [6:1] tx_dftout;
   output       von;
   output       vop;

   wire [14:0] atbsel;
   wire        atbi_0, atbi_1;
   wire        vtp_1po, vtn_1po, vbiasp_cs, vbiasn_cs, vbiasp, vbiasn, vtp, vtn; // not driven for now
   wire  [6:1] vodselb, vodsel_pdrv;
   wire        atben;
   reg   [5:1] pre_em_2po, pre_em_pre;
   reg   [6:1] pre_em_1po;
   wire        po1_en_pdrvb, pre_en_pos, pre_en_neg, po2_en_pos, po2_en_neg;
   wire        outpos_p, outpos_n, outneg_p, outneg_n;
   wire  [5:0] vopos_pd, vopos_nd, voneg_pd, voneg_nd;
   wire        txden, rlpbk_en, po1_rlpbk_en, po1_en, po2_en, pre_en;
   wire        prepb_em_pre, pd_idl, vccbn1g, threshold;

   reg         prep, pren, po1p, po1n, po2p, po2n, mainp, mainn;
   reg   [3:0] dec2t4_en;
   reg   [6:1] vodsel;
  
// ibias_ref & c_tx_vcm not modeled

// txgate_por
   assign atb0 = atben ? atbi_0 : 1'bz;
   assign atb1 = atben ? atbi_1 : 1'bz;

   arriaii_hssi_pma_c_controller_4t16 xatb (
      .atben(atben), .ct0(lst[0]), .ct1(lst[1]), .ct2(lst[2]), .ct3(lst[3]), .tmsb1(atbsel[0]),
      .tmsb2(atbsel[1]), .tmsb3(atbsel[2]), .tmsb4(atbsel[3]), .tmsb5(atbsel[4]), .tmsb6(atbsel[5]),
      .tmsb7(atbsel[6]), .tmsb8(atbsel[7]), .tmsb9(atbsel[8]), .tmsb10(atbsel[9]),
      .tmsb11(atbsel[10]), .tmsb12(atbsel[11]), .tmsb13(atbsel[12]), .tmsb14(atbsel[13]),
      .tmsb15(atbsel[14]), .vcce_la(vccesdp_la), .vssex(vssexqyx) );

// * * C_TX_DRIVER * *

// txgate_por 
   assign atbi_0 = atbsel[1] ? vtp_1po   : 1'bz;
   assign atbi_0 = atbsel[0] ? vbiasp    : 1'bz;
   assign atbi_0 = atbsel[2] ? vbiasp_cs : 1'bz;
   assign atbi_0 = atbsel[3] ? vtp       : 1'bz;
   assign atbi_1 = atbsel[1] ? vtn_1po   : 1'bz;
   assign atbi_1 = atbsel[0] ? vbiasn    : 1'bz;
   assign atbi_1 = atbsel[2] ? vbiasn_cs : 1'bz;
   assign atbi_1 = atbsel[3] ? vtn       : 1'bz;

// -- c_tx_dec xtxdec --
   assign txden        =  pdb & ~tx_elec_idl & ~rtx_rlpbk; 
   assign rlpbk_en     =  pdb & ~tx_elec_idl &  rtx_rlpbk;
   assign po1_rlpbk_en = rlpbk_en ? |rpre_em_1t : 1'b0;

   // c_dec3t7 - xmp_decode
   assign vodselb = ~vodsel;
   always @ ( rvod_sel or pdb ) begin
    if ( pdb == 1'b1 ) 
     case ( rvod_sel )
       3'b000  : vodsel <= 6'b000000;
       3'b001  : vodsel <= 6'b000001;
       3'b010  : vodsel <= 6'b000011;
       3'b011  : vodsel <= 6'b000111;
       3'b100  : vodsel <= 6'b001111;
       3'b101  : vodsel <= 6'b011111;
       3'b110  : vodsel <= 6'b100011;
       3'b111  : vodsel <= 6'b100111;
       default : vodsel <= 6'b000000;
     endcase 
   else
     vodsel = 6'b000000;
   end

   // c_dec5t5 - x1t_decode
   always @ ( rpre_em_1t or pdb ) begin
    if ( pdb == 1'b1 ) begin
     case ( rpre_em_1t )
       5'b00000 : pre_em_1po <= 6'b000000;
       5'b00001 : pre_em_1po <= 6'b000100;
       5'b00010 : pre_em_1po <= 6'b000101;
       5'b00011 : pre_em_1po <= 6'b000110;
       5'b00100 : pre_em_1po <= 6'b000111;
       5'b00101 : pre_em_1po <= 6'b001000;
       5'b00110 : pre_em_1po <= 6'b001001;
       5'b00111 : pre_em_1po <= 6'b001010;

       5'b01000 : pre_em_1po <= 6'b001011;
       5'b01001 : pre_em_1po <= 6'b001100;
       5'b01010 : pre_em_1po <= 6'b001101;
       5'b01011 : pre_em_1po <= 6'b001110;
       5'b01100 : pre_em_1po <= 6'b001111;
       5'b01101 : pre_em_1po <= 6'b010000;
       5'b01110 : pre_em_1po <= 6'b010001;
       5'b01111 : pre_em_1po <= 6'b010010;

       5'b10000 : pre_em_1po <= 6'b010011;
       5'b10001 : pre_em_1po <= 6'b010100;
       5'b10010 : pre_em_1po <= 6'b010101;
       5'b10011 : pre_em_1po <= 6'b010110;
       5'b10100 : pre_em_1po <= 6'b010111;
       5'b10101 : pre_em_1po <= 6'b011000;
       5'b10110 : pre_em_1po <= 6'b011010;
       5'b10111 : pre_em_1po <= 6'b011100;

       5'b11000 : pre_em_1po <= 6'b011110;
       5'b11001 : pre_em_1po <= 6'b110000;
       5'b11010 : pre_em_1po <= 6'b110010;
       5'b11011 : pre_em_1po <= 6'b110100;
       5'b11100 : pre_em_1po <= 6'b110110;
       5'b11101 : pre_em_1po <= 6'b111000;
       5'b11110 : pre_em_1po <= 6'b111100;
       5'b11111 : pre_em_1po <= 6'b111111;

       default  : pre_em_1po <= 6'b000000;
     endcase
    end
    else
      pre_em_1po <= 6'b000000;
   end

   // x2t_decode 
   always @ ( rpre_em_2t or pdb ) begin
    if ( pdb == 1'b1 ) begin
      if ( rpre_em_2t == 4'b0000 )
        pre_em_2po[5:1] <= 5'b00000;
      else
        pre_em_2po[5:1] <= {1'b1,rpre_em_2t};
    end
    else
      pre_em_2po <= 5'b00000;
   end

   // xpr_decode
   always @ ( rpre_em_pt or pdb ) begin
    if ( pdb == 1'b1 ) begin
      if ( rpre_em_pt == 4'b0000 )
        pre_em_pre[5:1] <= 5'b00000;
      else
        pre_em_pre[5:1] <= {1'b1,rpre_em_pt};
    end
    else
      pre_em_pre <= 5'b00000;
   end

// -- c_tx_testmux_dec --
   always @ ( r_dft_sel )
     case ( r_dft_sel )
       3'b0??  : dec2t4_en <= 4'b0000;
       3'b100  : dec2t4_en <= 4'b0001;
       3'b101  : dec2t4_en <= 4'b0010;
       3'b110  : dec2t4_en <= 4'b0100;
       3'b111  : dec2t4_en <= 4'b1000;
       default : dec2t4_en <= 4'b0000;
     endcase

   assign tx_dftout[6:1] = ( dec2t4_en[3] == 1'b1 ) ? {1'b0,pre_em_pre[5:1]} :
                           ( dec2t4_en[2] == 1'b1 ) ? {1'b0,pre_em_2po[5:1]} :
                           ( dec2t4_en[1] == 1'b1 ) ? pre_em_1po[6:1] :
                           ( dec2t4_en[0] == 1'b1 ) ? vodsel[6:1] : 6'b000000; // used to be 6'bxxxxxx -- too pessimistic

// -- c_tx_drv_buf xdrvbuf --
   assign vodsel_pdrv  =  vodsel & {6{~tx_elec_idl}};

// -- c_tx_predrv xpredrv --
   assign pd_idl       =  ~pdb | tx_elec_idl;

   // xmain_tap_mux
   always @ ( txden, rlpbk_en, vip, vin, rlpbkp, rlpbkn )
     case ( {rlpbk_en,txden} )
       2'b00   : begin
       {mainp,mainn} <= 2'b01; 
                  end
       2'b01   : begin
       {mainp,mainn} <= {vip,vin};
             end
       2'b10   : begin 
       {mainp,mainn} <= {rlpbkp,rlpbkn};
        end
       2'b11   : begin
       {mainp,mainn} <= 2'bxx;
          end
       default : begin
       {mainp,mainn} <= 2'bxx;
         end
     endcase

   // xdrv0

   assign vopos_pd[0] = (pd_idl === 1'b0) ? mainp : 1'b1; // slew fct is not implemented
   assign vopos_nd[0] = (pd_idl === 1'b0) ? mainp : 1'b0;
   assign voneg_pd[0] = (pd_idl === 1'b0) ? mainn : 1'b1;
   assign voneg_nd[0] = (pd_idl === 1'b0) ? mainn : 1'b0;

   // xdv_x6 - for driving strength
   assign vopos_pd[1] = vodsel_pdrv[1] ? mainp : 1'b1; // slew fct is not implemelted
   assign vopos_nd[1] = vodsel_pdrv[1] ? mainp : 1'b0;
   assign voneg_pd[1] = vodsel_pdrv[1] ? mainn : 1'b1;
   assign voneg_nd[1] = vodsel_pdrv[1] ? mainn : 1'b0;

   assign vopos_pd[2] = vodsel_pdrv[2] ? mainp : 1'b1; 
   assign vopos_nd[2] = vodsel_pdrv[2] ? mainp : 1'b0;
   assign voneg_pd[2] = vodsel_pdrv[2] ? mainn : 1'b1;
   assign voneg_nd[2] = vodsel_pdrv[2] ? mainn : 1'b0;

   assign vopos_pd[3] = vodsel_pdrv[3] ? mainp : 1'b1; 
   assign vopos_nd[3] = vodsel_pdrv[3] ? mainp : 1'b0;
   assign voneg_pd[3] = vodsel_pdrv[3] ? mainn : 1'b1;
   assign voneg_nd[3] = vodsel_pdrv[3] ? mainn : 1'b0;

   assign vopos_pd[4] = vodsel_pdrv[4] ? mainp : 1'b1; 
   assign vopos_nd[4] = vodsel_pdrv[4] ? mainp : 1'b0;
   assign voneg_pd[4] = vodsel_pdrv[4] ? mainn : 1'b1;
   assign voneg_nd[4] = vodsel_pdrv[4] ? mainn : 1'b0;

   assign vopos_pd[5] = vodsel_pdrv[5] ? mainp : 1'b1; 
   assign vopos_nd[5] = vodsel_pdrv[5] ? mainp : 1'b0;
   assign voneg_pd[5] = vodsel_pdrv[5] ? mainn : 1'b1;
   assign voneg_nd[5] = vodsel_pdrv[5] ? mainn : 1'b0;

   // * * x1post_drv, x2post_drv and xpre_drv not implemented * *

// -- c_tx_drv xctxdrv --
   assign vop = ( ~(&voneg_pd) & ~(&voneg_nd) ) ? 1'b1 : 
                (  (|voneg_pd) &  (|voneg_nd) ) ? 1'b0 : 
                (  (|voneg_pd) & ~(&voneg_nd) ) ? 1'bz :
                ( tx_det_rx === 1'b1 ) ? 1'b0 : 1'bx; // 7 bits for driving strength - fct not implemented
   assign von = ( ~(&vopos_pd) & ~(&vopos_nd) ) ? 1'b1 : 
                (  (|vopos_pd) &  (|vopos_nd) ) ? 1'b0 : 
                (  (|vopos_pd) & ~(&vopos_nd) ) ? 1'bz :
                ( tx_det_rx === 1'b1 ) ? 1'b0 : 1'bx; 

// * * C_RCV_DETECT * *

   arriaii_hssi_pma_c_rcv_detect xi_rcv_det (
      .com_pass(com_pass), .detect_on(detect_on), .fixed_clk_out(fixed_clk_out),
      .probe_pass(probe_pass), .rcv_det_pdb(rx_det_pdb), .rdet(r_rx_det),
      .rx_det_clk(rx_det_clk), .rx_det_valid(rx_detect_valid), .rx_found(rx_found),
      .sel_150r(sel_150r), .tx_det_rx(tx_det_rx), .rx_n(rx_n), .rx_p(rx_p) );

endmodule // arriaii_hssi_pma_c_tx


`timescale 1 ns / 1 ps

module arriaii_hssi_pma_ppmdetect (scan_mode, ppmsel, fref, fvcobyn, pd, hard_reset, rforcehigh, rforcelow, freq_lock, ppm_cnt_latch, ppm_cnt_reset); 	// MZ
input        scan_mode;	// MZ
input [5:0]  ppmsel;     // ppmsel setting      ppmsel=6'b100000 <=> +/- 1000 PPM
                         //                     ppmsel=6'b010000 <=> +/- 500 PPM
                         //                     ppmsel=6'b001000 <=> +/- 300 PPM
                         //                     ppmsel=6'b000100 <=> +/- 200 PPM
                         //                     ppmsel=6'b000010 <=> +/- 125 PPM
                         //                     ppmsel=6'b000001 <=> +/- 100 PPM

input        fref;       // Reference clock
input        fvcobyn;    // VCO divided clock
input        pd;         // Power down
input        rforcehigh; // CRAM: force freq_lock high
input        rforcelow;  // CRAM: force freq_lock low
input        hard_reset; // initialize all registers to one
input	     ppm_cnt_reset; // reset ppm_cnt_latch register

output       freq_lock;  // fref and fvcobyn are in range, set by ppmsel
output [6:0] ppm_cnt_latch;    // PPM difference, can be sent off-chip via testmux

reg   [15:0] ref_cnt;    // 16-bit counter using fref clock
reg   [15:0] vco_cnt;    // 16-bit counter using fvcobyn clock
reg   [3:0]  eight_cnt;  // counter used to delay the 16-bit counters reset by 8-cycles
reg   [6:0]  ppm_cnt;    // 6-bit counter used to count number of fref in open windows
reg          stable2, stable1, stable0;
reg          overflow_vco, overflow_vco1, overflow_vco2;
reg          freq_lock_pre; 
reg          v65536v, v65536r;
reg 	     window0, window1;
reg 	     rst_div2, rst_div1, rst_div0;
reg          stay;
reg	     rst_div_fref;//exists to delay the release of ref_cnt by one cycle. This will reduce the 
 			  // the time difference between the start of ref_cnt and vco_cnt after the
			  // release of rst_div. The time difference is due to rst_div being synchronized
			  // to fvcobyn from fref domain. ref_cnt start up immediately and vco_cnt starts
			  // 2 fvcobyn clock edges later. rst_div_fref will help reduce that 2 edge gap to
			  // 1 edge.

wire         eight_cnt_0;
wire         eight_cnt_4;
wire         eight_cnt_8;
wire         window;
wire         freq_lock;
wire         ppm_cnt_reset;
wire         pd_sync_fref, pd_sync_fvcobyn;
wire	     hard_reset_inv;

reg [6:0]   ppm_cnt_latch;

assign  eight_cnt_0	= ~|eight_cnt;
assign  eight_cnt_4	= ~eight_cnt[3] & eight_cnt[2] & ~eight_cnt[1] & ~eight_cnt[0];
assign  eight_cnt_8	= eight_cnt[3] & ~eight_cnt[2] & ~eight_cnt[1] & ~eight_cnt[0];
assign  window		= v65536r ^ v65536v;

// Inverting hard_reset because rxpma_rstb is active low
assign hard_reset_inv = ~hard_reset;

reg pd_sync_fref_pre, pd_sync_fref_b4scanmux, pd_sync_fvcobyn_pre, pd_sync_fvcobyn_b4scanmux; // MZ
//Synchronize pd to fref
always @(posedge hard_reset_inv or posedge fref)
  if (hard_reset_inv)
  begin
	pd_sync_fref_pre	<= 1'b1;
	pd_sync_fref_b4scanmux		<= 1'b1;	// MZ
  end
  else
  begin
	pd_sync_fref_pre	<= pd;
	pd_sync_fref_b4scanmux		<= pd_sync_fref_pre;	// MZ
  end

assign pd_sync_fref = scan_mode ? 1'b0 : pd_sync_fref_b4scanmux; // MZ
//Synchronize pd to fvcobyn
always @(posedge hard_reset_inv or posedge fvcobyn)
  if (hard_reset_inv)
  begin
	pd_sync_fvcobyn_pre	<= 1'b1;
	pd_sync_fvcobyn_b4scanmux		<= 1'b1;	// MZ
  end
  else
  begin
	pd_sync_fvcobyn_pre	<= pd;
	pd_sync_fvcobyn_b4scanmux		<= pd_sync_fvcobyn_pre;	// MZ
  end

assign pd_sync_fvcobyn = scan_mode ? 1'b0 : pd_sync_fvcobyn_b4scanmux; // MZ

// This piece of code creates flags that reset the 16-bit counters, when they BOTH go 
// beyond 32768 (plus about 20 cycles) cycles. Before that they have to synchronized to
// relevant clock domains. This resetting has to happen because when the PPM difference
// is so low that the window signal is less than a fref clock period, it will be missed
// and the counters will continue counting until it reaches all ONES. This is not desirable.
reg overflow_ref;
always @(posedge pd_sync_fref or posedge fref)
  if (pd_sync_fref)
	overflow_ref	<= 1'b0;
  else
	 overflow_ref <= (ref_cnt > 16'h8010) ? 1'b1 : 1'b0;
always @(posedge pd_sync_fvcobyn or posedge fvcobyn)
  if (pd_sync_fvcobyn)
	overflow_vco	<= 1'b0;
  else
	overflow_vco <= (vco_cnt > 16'h8010) ? 1'b1 : 1'b0;

// After power down is released, the counters start counting. One counter may start several
// thousand cycles after the other. So, after 128 cycles of fvcobyn, a signal called "stable"
// is released. This will guarantee that fvcobyn was stable, before module operation started.
always @(posedge pd_sync_fvcobyn or posedge fvcobyn)
  if (pd_sync_fvcobyn)
	stable0 <= 1'b0;
  else if (vco_cnt[15:0] == 16'b0000000011111111)
        stable0 <= 1'b1;
	
//synchronize stable and overflow_vco to fref domain. "overflow_vco" will be used as one of the
//cases when rst_div = 1
always @(posedge pd_sync_fref or posedge fref)
  if (pd_sync_fref)
  begin
	stable1	<= 1'b0;
	stable2	<= 1'b0;
	overflow_vco1	<= 1'b0;
	overflow_vco2	<= 1'b0;
  end
  else
  begin
	stable1	<= stable0;
	stable2	<= stable1;
	overflow_vco1	<= overflow_vco;
	overflow_vco2	<= overflow_vco1;
  end

//synchronize rst_div to fvcobyn domain
always @(posedge pd_sync_fvcobyn or posedge fvcobyn)
  if (pd_sync_fvcobyn)
  begin
	rst_div1	<= 1'b0;
	rst_div2	<= 1'b0;
  end
  else
  begin
	rst_div1	<= rst_div0;
	rst_div2	<= rst_div1;
  end

//window1 is set to HIGH if clocks  are stable ("stable2" = 1) and 
//window1 can be HIGH only when the 8 counter is not counting down.
always @(posedge pd_sync_fref or posedge fref)
begin
  if (pd_sync_fref)
  begin
	window0	<= 1'b0;
	window1	<= 1'b0;
  end
  else if (~stable2)
  begin
	window0	<= 1'b0;
	window1	<= 1'b0;
  end
  else
  begin
	window1 <= window0;
	if (eight_cnt_8 == 1)
		window0 <= window;
	else
		window0 <= 1'b0;
  end
end

// fref and fvcobyn counter reset
always @(posedge pd_sync_fref or posedge fref)
  if (pd_sync_fref)
  begin
    rst_div0 <= 1'b0;
    rst_div_fref <= 1'b0;
  end
  else if (((eight_cnt > 0) && (eight_cnt < 8)) | (overflow_ref & overflow_vco2))
  begin  
    rst_div0 <= 1'b1;
    rst_div_fref <= rst_div0;      
  end
  else 
  begin
    rst_div0 <= 1'b0;
    rst_div_fref <= rst_div0;      
  end

//reset counters during PD_SYNC and during the clocking down of the 8 counter
// fref counter
always @(posedge pd_sync_fref or posedge fref)
  if (pd_sync_fref)
   begin
    ref_cnt <= 16'h0000;
    v65536r <= 1'b1;
   end
  else
  if (rst_div_fref)
   begin
    ref_cnt <= 16'h0000;
    v65536r <= 1'b1;
   end
  else
   begin
    ref_cnt <= ref_cnt + 1;
    v65536r <= ~(ref_cnt[15]); //ref_cnt[15] = 1 means 32,768 cycles have passed
   end

// fvcobyn counter
always @(posedge pd_sync_fvcobyn or posedge fvcobyn)
  if (pd_sync_fvcobyn)
   begin
    vco_cnt <= 16'h0000;
    v65536v <= 1'b1;
   end
  else if (rst_div2)
   begin
    vco_cnt <= 16'h0000;
    v65536v <= 1'b1;
   end
  else
   begin
    vco_cnt <= vco_cnt + 1;
    v65536v <= ~(vco_cnt[15]); //vco_cnt[15] = 1 means 32,768 cycles have passed
   end

// count only after window ends. Then stop at 0 and reset to 8.
// "stay" there until window goes high and low again. STAY is HIGH from 
// when WINDOW1 is HIGH to when EIGHT_CNT is 0. 
always @(posedge pd_sync_fref or posedge fref)
  if (pd_sync_fref)
  begin
    eight_cnt <= 4'h8;
    stay <= 1'b0;
  end
  else if(eight_cnt_0 == 1)
  begin
    eight_cnt <= 4'h8;
    stay <= 1'b0;
  end
  else if((window1 == 1) || (overflow_ref & overflow_vco2))
    stay <= 1'b1;
  else if((window1 == 0) && (stay == 1))
  begin
    eight_cnt <= eight_cnt - 1;
  end
      
// PPM counter
// using 6-bit counter to acount for setting of more than 1000PPM
// starts counting when window starts, which is "upd_synctctr"
// stops counting when window ends, which is when 
always @(posedge pd_sync_fref or posedge fref)
begin
 if (pd_sync_fref)
   ppm_cnt <= 7'b0000000;  	// Avoiding the comparison after pd_sync
 else if (eight_cnt_0)
   ppm_cnt <= 7'b0000000;  	// If 
 else if (ppm_cnt == 7'b1111111)
   ppm_cnt <= 7'b1111111; 	//Hold all Ones until eight_count_0
 else if (window1 == 1'b1) 	//If window has been opened by FREF or FVCOBYN
   ppm_cnt <= ppm_cnt + 1; 
end

// freq_lock_pre detection
// Perfom the comparison 4 clock cycles before reseting the 16-bit counters
always @(posedge pd_sync_fref or posedge fref)
begin
 if (pd_sync_fref)
   begin
     freq_lock_pre     <= 1'b0;
   end
 else if (eight_cnt_4)
   begin
			 // ppmsel setting      ppmsel=6'b100000 <=> +/- 1000 PPM
                         //                     ppmsel=6'b010000 <=> +/- 500 PPM
                         //                     ppmsel=6'b001000 <=> +/- 300 PPM
                         //                     ppmsel=6'b001001 <=> +/- 250 PPM
                         //                     ppmsel=6'b000100 <=> +/- 200 PPM
                         //                     ppmsel=6'b000010 <=> +/- 125 PPM
                         //                     ppmsel=6'b000001 <=> +/- 100 PPM
                         //                     ppmsel=6'b000011 <=> +/- 62.5 PPM
	freq_lock_pre <=(((eight_cnt_4 == 1) && (ppmsel == 6'b100000) && (ppm_cnt <= 7'd67)) ||   //  +/- 1000 PPM
 			 ((eight_cnt_4 == 1) && (ppmsel == 6'b010000) && (ppm_cnt <= 7'd34)) ||   //  +/- 500 PPM
			 ((eight_cnt_4 == 1) && (ppmsel == 6'b001000) && (ppm_cnt <= 7'd21)) ||   //  +/- 300 PPM
			 ((eight_cnt_4 == 1) && (ppmsel == 6'b001001) && (ppm_cnt <= 7'd18)) ||   //  +/- 250 PPM
			 ((eight_cnt_4 == 1) && (ppmsel == 6'b000100) && (ppm_cnt <= 7'd15)) ||   //  +/- 200 PPM
			 ((eight_cnt_4 == 1) && (ppmsel == 6'b000010) && (ppm_cnt <= 7'd10)) ||   //  +/- 125 PPM
			 ((eight_cnt_4 == 1) && (ppmsel == 6'b000001) && (ppm_cnt <= 7'd8))  ||   //  +/- 100 PPM
			 ((eight_cnt_4 == 1) && (ppmsel == 6'b000011) && (ppm_cnt <= 7'd6)) ||    //  +/- 62.5 PPM
			 ((eight_cnt_4 == 1) && (ppmsel == 6'b111111) )) ? 1'b1 : 1'b0;
   end
end

always @(posedge pd_sync_fref or posedge fref)
begin
	if (pd_sync_fref)
		ppm_cnt_latch <= 7'b0000000;
	else if (ppm_cnt_reset)
		ppm_cnt_latch <= 7'b0000000;
	else if (eight_cnt_4)
		ppm_cnt_latch <= ppm_cnt;
end

//CRAM bits force HIGH or LOW on to freq_lock. This serves as module bypass.
assign freq_lock = rforcehigh ? 1'b1 : (rforcelow ? 1'b0 : freq_lock_pre);

endmodule    
//====Revision Log================
//Rev: 1.2   Thu May 22 18:17:56 PDT 2008   cgaillar
//Updated after Allen's cosim feeback
//====End Log======================

module arriaii_hssi_pma_c_ser_10g (
   clk_divtx, clk_skew, cpulse, cpulseb, data_in, hfclkn, hfclkp, lbvon, lbvop, lfclkn,
   lfclkp, pdb, pre_em, rst_n, s_lpbk, vccelxqyx, vccetxqyx, von, von_op1, vop, vop_op1,
   vssexqyx );

   input   [2:0] clk_skew;
   input         cpulse;
   input         cpulseb;
   input  [63:0] data_in;
   input         hfclkn;
   input         hfclkp;
   input         lfclkn;
   input         lfclkp;
   input         pdb;
   input   [4:0] pre_em;
   input         rst_n;
   input         s_lpbk;
   input         vccelxqyx;
   input         vccetxqyx;
   input         vssexqyx;

   output        clk_divtx;
   output        lbvon;
   output        lbvop;
   output        von;
   output        von_op1;
   output        vop;
   output        vop_op1;

   parameter     PARAM_DELAY = 0;

   reg     [7:0] do8;
   reg           core_clk, lfclkp_div_init_done, out_lb_reg, outb_lb_reg, out_e, out_o;
   reg     [7:0] data_mux4t1_sync1, cpulse_x8_bus;
   reg     [3:0] do_mux4t1_sync2, de_mux4t1_sync2;
   reg           c0_even, c1_even, c2_even, c3_even, cp;
   reg           cp_odd, c0_odd, c1_odd, c2_odd, c3_odd, cpulse_x8;
   reg           oo1, oe1, vop_reg, von_reg, vop_op1_reg, von_op1_reg;
   reg    [63:0] data_sync, do64;

   wire          lben;
   wire          pre_en, s_lpbkbuf;
   wire          rst_nbuf;
   wire          pe;

   integer       lfclkp_counter;

   assign pre_en    = |pre_em;
   assign s_lpbkbuf = pdb & s_lpbk;
   assign rst_nbuf  = pdb & rst_n;
   assign clk_divtx = core_clk;

   initial begin
     data_mux4t1_sync1 <= 8'b0000_0000;
     de_mux4t1_sync2[3:0] <= 4'b0000;
     do_mux4t1_sync2[3:0] <= 4'b0000;
     vop_op1_reg <= 1'b0;
     von_op1_reg <= 1'b1;
     vop_reg <= 1'b0;
     von_reg <= 1'b1;
     out_lb_reg <= 1'b0;
     outb_lb_reg <= 1'b1;
     {out_o, out_e} <= 2'b00;
     {oo1, oe1} <= 2'b00;
     {c0_even,c1_even,c2_even,c3_even} <= 4'b0000;
     {c0_odd,c1_odd,c2_odd,c3_odd}     <= 4'b0000;
     do8 <= 8'b0000_0000;
     {cpulse_x8_bus[6:0],cp,cpulse_x8}    <= 9'b0_0000_0000;
     data_sync <= 64'b0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000;
     do64 <= 64'b0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000;
     do8 <= 8'b0000_0000;

     lfclkp_counter = 0;
     lfclkp_div_init_done = 1'b0;
   end

   // * * c_div8_10g * *
   always @ ( posedge lfclkp or negedge rst_nbuf ) begin
     if ( rst_nbuf == 1'b0 ) begin
       lfclkp_counter       <= 0;
       lfclkp_div_init_done <= 1'b0;
       core_clk             <= 1'b0;
     end
     else begin
      // after one cycle of lfclkp, if set, reset cpulse_x8
       if ( lfclkp == 1'b1 & cpulse_x8 == 1'b1 ) cpulse_x8 <= 1'b0;
       if ( lfclkp_div_init_done == 1'b0 ) begin
         core_clk             <= 1'b1;
         lfclkp_div_init_done <= 1'b1;
         end
       else begin
         // generation of core_clk
         if ( lfclkp_counter % 4 == 0 ) begin
           core_clk <= ~core_clk;
           if ( core_clk == 1'b0 ) cpulse_x8 <= 1'b1;
         end
       end
       lfclkp_counter <= lfclkp_counter + 1;
     end
   end

   // * * c_mux64to8_10g * *
   // - cpulse_8x8_gen -
   always @ ( posedge lfclkp or negedge rst_nbuf ) begin
     if ( rst_nbuf == 1'b0 )
       {cpulse_x8_bus[7:0],cp} <= #(PARAM_DELAY) 9'b0_0000_0000;
     else 
       {cpulse_x8_bus[7:0],cp} <= #(PARAM_DELAY) {cpulse_x8_bus[6:0],cp,cpulse_x8};
   end

   // - c_64bit_reg_10g -
   always @ ( posedge core_clk ) 
     data_sync <= #(PARAM_DELAY) data_in;

   // - c_32bit_reg_10g bits[63:32] -
   always @ ( posedge core_clk )
     do64[63:32] <= #(PARAM_DELAY) data_sync[63:32];

   // - c_32bit_reg_10g bits[31:0] -
   always @ ( negedge core_clk )
     do64[31:0] <= #(PARAM_DELAY) data_sync[31:0];

   // - a_8bit_tri_reg - 
   always @ ( posedge cpulse_x8_bus[4] or negedge rst_nbuf ) 
     if ( ~rst_nbuf ) 
       do8 <= #(PARAM_DELAY) 8'b0000_0000;
     else
       do8 <= #(PARAM_DELAY) do64[7:0];

   always @ ( posedge cpulse_x8_bus[5] or negedge rst_nbuf )
     if ( ~rst_nbuf )
       do8 <= #(PARAM_DELAY) 8'b0000_0000;
     else
       do8 <= #(PARAM_DELAY) do64[15:8];

   always @ ( posedge cpulse_x8_bus[6] or negedge rst_nbuf )
     if ( ~rst_nbuf )
       do8 <= #(PARAM_DELAY) 8'b0000_0000;
     else
       do8 <= #(PARAM_DELAY) do64[23:16];

   always @ ( posedge cpulse_x8_bus[7] or negedge rst_nbuf )
     if ( ~rst_nbuf )
       do8 <= #(PARAM_DELAY) 8'b0000_0000;
     else
       do8 <= #(PARAM_DELAY) do64[31:24];

   always @ ( posedge cpulse_x8_bus[0] or negedge rst_nbuf )
     if ( ~rst_nbuf )
       do8 <= #(PARAM_DELAY) 8'b0000_0000;
     else
       do8 <= #(PARAM_DELAY) do64[39:32];
  
   always @ ( posedge cpulse_x8_bus[1] or negedge rst_nbuf )
     if ( ~rst_nbuf )
       do8 <= #(PARAM_DELAY) 8'b0000_0000;
     else
       do8 <= #(PARAM_DELAY) do64[47:40];

   always @ ( posedge cpulse_x8_bus[2] or negedge rst_nbuf )
     if ( ~rst_nbuf )
       do8 <= #(PARAM_DELAY) 8'b0000_0000;
     else
       do8 <= #(PARAM_DELAY) do64[55:48];

   always @ ( posedge cpulse_x8_bus[3] or negedge rst_nbuf )
     if ( ~rst_nbuf )
       do8 <= #(PARAM_DELAY) 8'b0000_0000;
     else
       do8 <= #(PARAM_DELAY) do64[63:56];

   // * * arriaii_hssi_pma_c_ser_mux4to1 -- xmux4to1_even & odd instances * *
   // Pipe #1 - synchronize data to lfclkp negedge
   always @ ( posedge lfclkn or negedge rst_nbuf )
     if ( lfclkn == 1'b1 ) data_mux4t1_sync1 <= #(PARAM_DELAY) do8;
     else data_mux4t1_sync1 <= #(PARAM_DELAY) 8'b0000_0000;

   // Pipe #2 - Synchronize 0,2 and 1,3 to CLK and CLKB ; 6,8 and 5,7 to CLK and CLKB
   always @ ( posedge lfclkp or negedge rst_nbuf )
     if ( lfclkp == 1'b1 ) begin
       de_mux4t1_sync2[1:0] <= #(PARAM_DELAY) {data_mux4t1_sync1[2],data_mux4t1_sync1[0]};
       do_mux4t1_sync2[1:0] <= #(PARAM_DELAY) {data_mux4t1_sync1[3],data_mux4t1_sync1[1]};
     end
     else begin
       de_mux4t1_sync2[1:0] <= #(PARAM_DELAY) 2'b00;
       do_mux4t1_sync2[1:0] <= #(PARAM_DELAY) 2'b00;
     end

   always @ ( posedge lfclkn or negedge rst_nbuf )
     if ( lfclkn == 1'b1 ) begin
       de_mux4t1_sync2[3:2] <= #(PARAM_DELAY) {data_mux4t1_sync1[6],data_mux4t1_sync1[4]};
       do_mux4t1_sync2[3:2] <= #(PARAM_DELAY) {data_mux4t1_sync1[7],data_mux4t1_sync1[5]};
     end
     else begin
       de_mux4t1_sync2[3:2] <= #(PARAM_DELAY) 2'b00;
       do_mux4t1_sync2[3:2] <= #(PARAM_DELAY) 2'b00;
     end

   // Pulse generation for odd and even - CPULSE, CP, C0, ..., C3
   always @ ( posedge hfclkn or negedge rst_nbuf )
     if ( hfclkn == 1'b1 ) begin
       c0_even <= #(PARAM_DELAY) cpulse;
       c1_even <= #(PARAM_DELAY) c0_even;
       c2_even <= #(PARAM_DELAY) c1_even;
       c3_even <= #(PARAM_DELAY) c2_even;
     end
     else {c3_even,c2_even,c1_even,c0_even} <= #(PARAM_DELAY) 4'b0000;

   always @ ( posedge hfclkn or negedge rst_nbuf ) // Mux Odd
     if ( ~rst_nbuf )
       cp_odd <= #(PARAM_DELAY) 1'b0;
     else
       cp_odd <= #(PARAM_DELAY) cpulse;

   always @ ( posedge hfclkp or negedge rst_nbuf )
     if ( hfclkp == 1'b1 ) begin
       c0_odd <= #(PARAM_DELAY) cp_odd;
       c1_odd <= #(PARAM_DELAY) c0_odd;
       c2_odd <= #(PARAM_DELAY) c1_odd;
       c3_odd <= #(PARAM_DELAY) c2_odd;
     end
     else {c3_odd,c2_odd,c1_odd,c0_odd} <= #(PARAM_DELAY) 4'b0000;

   // Mux2to1 Even outputs
   always @ ( posedge c0_even ) if ( c0_even == 1'b1 ) begin
     out_e <= #(PARAM_DELAY) de_mux4t1_sync2[0];
   end

   always @ ( posedge c1_even ) if ( c1_even == 1'b1 ) begin
     out_e <= #(PARAM_DELAY) de_mux4t1_sync2[1];
   end

   always @ ( posedge c2_even ) if ( c2_even == 1'b1 ) begin
     out_e <= #(PARAM_DELAY) de_mux4t1_sync2[2];
   end

   always @ ( posedge c3_even ) if ( c3_even == 1'b1 ) begin
     out_e <= #(PARAM_DELAY) de_mux4t1_sync2[3];
   end

   // Mux2to1 Odd outputs
   always @ ( posedge c0_odd ) if ( c0_odd == 1'b1 ) begin
     out_o <= #(PARAM_DELAY) do_mux4t1_sync2[0];
   end

   always @ ( posedge c1_odd ) if ( c1_odd == 1'b1 ) begin
     out_o <= #(PARAM_DELAY) do_mux4t1_sync2[1];
   end

   always @ ( posedge c2_odd ) if ( c2_odd == 1'b1 ) begin
     out_o <= #(PARAM_DELAY) do_mux4t1_sync2[2];
   end

   always @ ( posedge c3_odd ) if ( c3_odd == 1'b1 ) begin
     out_o <= #(PARAM_DELAY) do_mux4t1_sync2[3];
   end

   // * * arriaii_hssi_pma_c_ser_mux2to1 -- xmux2to1 instance * *
   assign pe      = pre_en & rst_nbuf & pdb;
   assign vop     = pdb    ? vop_reg     : 1'b1;
   assign von     = pdb    ? von_reg     : 1'b1;
   assign vop_op1 = pe     ? vop_op1_reg : 1'b1;
   assign von_op1 = pe     ? von_op1_reg : 1'b1;

   always @ ( posedge hfclkn or negedge rst_nbuf )
     if ( rst_nbuf == 1'b0 ) 
       oe1 <= #(PARAM_DELAY) 1'b0;
     else 
       oe1 <= #(PARAM_DELAY) out_e;

   always @ ( posedge hfclkp or negedge rst_nbuf )
     if ( rst_nbuf == 1'b0 )
       oo1 <= #(PARAM_DELAY) 1'b0;
     else
       oo1 <= #(PARAM_DELAY) out_o;

   always @ ( posedge hfclkp )
     if ( hfclkp == 1'b1 & pdb == 1'b1) begin
       vop_reg <= #(PARAM_DELAY)  out_o;
       von_reg <= #(PARAM_DELAY) ~out_o;
     end

   always @ ( posedge hfclkn )
     if ( hfclkn == 1'b1 & pdb == 1'b1 ) begin
       vop_reg <= #(PARAM_DELAY)  out_e;
       von_reg <= #(PARAM_DELAY) ~out_e;
     end

   always @ ( posedge hfclkp )
     if ( hfclkp == 1'b1 & pe == 1'b1) begin
       vop_op1_reg <= #(PARAM_DELAY)  oe1;
       von_op1_reg <= #(PARAM_DELAY) ~oe1;
     end

   always @ ( posedge hfclkn )
     if ( hfclkn == 1'b1 & pe == 1'b1 ) begin
       vop_op1_reg <= #(PARAM_DELAY)  oo1;
       von_op1_reg <= #(PARAM_DELAY) ~oo1;
     end

   // * * arriaii_hssi_pma_c_ser_mux2to1_lb -- xmux2to1_lb instance * *
   assign lben  = pdb & s_lpbkbuf;
   assign lbvop = lben ? out_lb_reg  : 1'b1;
   assign lbvon = lben ? outb_lb_reg : 1'b1;

   always @ ( posedge hfclkn )
     if ( hfclkn == 1'b1 & lben == 1'b1 ) begin
       out_lb_reg  <= #(PARAM_DELAY)  out_e;
       outb_lb_reg <= #(PARAM_DELAY) ~out_e;
     end

   always @ ( posedge hfclkp )
     if ( hfclkp == 1'b1 & lben == 1'b1 ) begin
       out_lb_reg  <= #(PARAM_DELAY)  out_o;
       outb_lb_reg <= #(PARAM_DELAY) ~out_o;
     end

endmodule // arriaii_hssi_pma_c_ser_10g

//====Revision Log================
//Rev: 1.3   Fri Apr 25 17:08:38 PDT 2008   cgaillar
//Removed clk270 input port
//
//Rev: 1.2   Fri Feb 29 09:57:15 PST 2008   cgaillar
//Updated mapping on 64 to 8 mux
//====End Log======================

module arriaii_hssi_pma_c_deser_10g (
   clk90b, clk_divrx, deser_pdb, deven, devenb, dodd, doddb, dout, rst_n,
   vcce_la, vssexqyx );

   input         clk90b;
   input         deser_pdb;
   input         deven;
   input         devenb;
   input         dodd;
   input         doddb;
   input         rst_n;
   input         vcce_la;
   input         vssexqyx;

   output        clk_divrx;
   output [63:0] dout;

   parameter     PARAM_DELAY = 0;

   integer       clk90_counter, clk270_counter, ph2_counter;
   reg           clk90_div_init_done, clk90_div4, clk270_div_init_done, clk270_div4, ph2_div_init_done, ph2_div8;
   reg     [3:0] ph, dsync;
   reg     [7:0] dp, doutp, doutn, ph8;
   reg    [63:0] dout, dout_int, dsync8;

   wire          clk90, clk270;

   assign        clk90  = ~clk90b;
   assign        clk270 =  clk90b;

   initial begin
     clk90_div_init_done  <= 1'b0;
     clk270_div_init_done <= 1'b0;
     ph2_div_init_done    <= 1'b0;
     clk90_counter  <= 0;
     clk270_counter <= 0;
     ph2_counter    <= 0;
     clk90_div4  <= 1'b0;
     clk270_div4 <= 1'b0;
     ph2_div8    <= 1'b0;
   end

   // * * c_deser_2to8_10g * * 

   // - c_deser_divby4_10g -
   always @ ( posedge clk90 or negedge rst_n ) begin
     if ( rst_n == 1'b0 ) begin
       clk90_counter       <= 0;
       clk90_div_init_done <= 1'b0;
       clk90_div4          <= 1'b0;
     end
     else begin
       if ( clk90_div_init_done == 1'b0 ) begin
         clk90_div4          <= 1'b1;
         clk90_div_init_done <= 1'b1;
         end
       else begin
         // generation of clk90_div4
         if ( clk90_counter % 2 == 0 )
           clk90_div4 <= ~clk90_div4;
       end
       clk90_counter <= clk90_counter + 1;
     end
   end

   // clk270_div4 should not start toggling before clk90_div4
   always @ ( clk270 or negedge rst_n ) begin
     if ( rst_n == 1'b0 ) begin
       clk270_counter       <= 0;
       clk270_div_init_done <= 1'b0;
       clk270_div4          <= 1'b0;
     end
     else if ( clk90_div_init_done == 1'b1 ) begin
       // generation of clk270_div4
       if ( ( clk270 == 1'b1 ) & ( clk270_counter % 4 == 0 ) ) begin
         if ( clk270_div_init_done == 1'b0 ) begin
           clk270_div4          <= 1'b1;
           clk270_div_init_done <= 1'b1;
         end
         else
           clk270_div4 <= ~clk270_div4;
       end
       clk270_counter <= clk270_counter + 1;
     end
   end

   always @ ( negedge rst_n or posedge clk270 ) 
     if ( ~rst_n ) 
       ph[3:0] <= #(PARAM_DELAY) 4'b0000;
     else 
       ph[3:0] <= #(PARAM_DELAY) {ph[2:0],clk270_div4};

   // - 1 to 4 demux -
   // Shift register
   always @ ( negedge rst_n or posedge ph[0] )
     if ( ~rst_n )
       dp[1:0] <= #(PARAM_DELAY) 2'b00;
     else
       dp[1:0] <= #(PARAM_DELAY)  {dodd,deven}; 

   always @ ( negedge rst_n or posedge ph[1] )
     if ( ~rst_n )
       dp[3:2] <= #(PARAM_DELAY) 2'b00;
     else
       dp[3:2] <= #(PARAM_DELAY) {dodd,deven};

   always @ ( negedge rst_n or posedge ph[2] )
     if ( ~rst_n )
       dp[5:4] <= #(PARAM_DELAY) 2'b00;
     else
       dp[5:4] <= #(PARAM_DELAY) {dodd,deven};

   always @ ( negedge rst_n or posedge ph[3] )
     if ( ~rst_n )
       dp[7:6] <= #(PARAM_DELAY) 2'b00;
     else
       dp[7:6] <= #(PARAM_DELAY) {dodd,deven};

   // dp[0,1,2,3] synchronization
   always @ ( negedge rst_n or negedge ph[0] )
     if ( ~rst_n )
       dsync[3:0] <= #(PARAM_DELAY) 4'b0000;
     else
       dsync[3:0] <= #(PARAM_DELAY) dp[3:0];

   always @ ( negedge rst_n or posedge ph[0] ) 
     if ( ~rst_n ) begin
       doutp[7:0] <= #(PARAM_DELAY) 8'b0000_0000;
       doutn[7:0] <= #(PARAM_DELAY) 8'b0000_0000;
     end
     else begin
       doutp[7:0] <= #(PARAM_DELAY)  {dp[7:4],dsync[3:0]};
       doutn[7:0] <= #(PARAM_DELAY) ~{dp[7:4],dsync[3:0]};
     end

   // * * c_deser_8to64_10g * *

   // - c_deser_divby8_10g - 
   always @ ( posedge ph[2] or negedge rst_n ) begin
     if ( rst_n == 1'b0 ) begin
       ph2_counter       <= 0;
       ph2_div_init_done <= 1'b0;
       ph2_div8          <= 1'b0;
     end
     else begin
       if ( ph2_div_init_done == 1'b0 ) begin
         ph2_div8          <= 1'b1;
         ph2_div_init_done <= 1'b1;
         end
       else begin
         // generation of ph2_div8
         if ( ph2_counter % 4 == 0 )
           ph2_div8 <= ~ph2_div8;
       end
       ph2_counter <= ph2_counter + 1;
     end
   end
   
   always @ ( negedge rst_n or posedge ph[2] )
     if ( ~rst_n )
       ph8[7:0] <= #(PARAM_DELAY) 8'b0000_0000;
     else
       ph8[7:0] <= #(PARAM_DELAY) {ph8[6:0],ph2_div8};

   // - c_deser_by8_8_10g -
   assign clk_divrx = ph8[0];

   always @ ( negedge rst_n or posedge ph8[0] )
     if ( ~rst_n )
       dout_int[7:0] <= #(PARAM_DELAY) 8'b0000_0000;
     else
       dout_int[7:0] <= #(PARAM_DELAY) doutp[7:0];

   always @ ( negedge rst_n or posedge ph8[1] )
     if ( ~rst_n )
       dout_int[15:8] <= #(PARAM_DELAY) 8'b0000_0000;
     else
       dout_int[15:8] <= #(PARAM_DELAY) doutp[7:0];

   always @ ( negedge rst_n or posedge ph8[2] )
     if ( ~rst_n )
       dout_int[23:16] <= #(PARAM_DELAY) 8'b0000_0000;
     else
       dout_int[23:16] <= #(PARAM_DELAY) doutp[7:0];

   always @ ( negedge rst_n or posedge ph8[3] )
     if ( ~rst_n )
       dout_int[31:24] <= #(PARAM_DELAY) 8'b0000_0000;
     else
       dout_int[31:24] <= #(PARAM_DELAY) doutp[7:0];

   always @ ( negedge rst_n or posedge ph8[4] )
     if ( ~rst_n )
       dout_int[39:32] <= #(PARAM_DELAY) 8'b0000_0000;
     else
       dout_int[39:32] <= #(PARAM_DELAY) doutp[7:0];

   always @ ( negedge rst_n or posedge ph8[5] )
     if ( ~rst_n )
       dout_int[47:40] <= #(PARAM_DELAY) 8'b0000_0000;
     else
       dout_int[47:40] <= #(PARAM_DELAY) doutp[7:0];

   always @ ( negedge rst_n or posedge ph8[6] )
     if ( ~rst_n )
       dout_int[55:48] <= #(PARAM_DELAY) 8'b0000_0000;
     else
       dout_int[55:48] <= #(PARAM_DELAY) doutp[7:0];

   always @ ( negedge rst_n or posedge ph8[7] )
     if ( ~rst_n )
       dout_int[63:56] <= #(PARAM_DELAY) 8'b0000_0000;
     else
       dout_int[63:56] <= #(PARAM_DELAY) doutp[7:0];

   always @ ( negedge rst_n or posedge ph8[7] )
     if ( ~rst_n ) begin
       dsync8[ 7: 0] <= #(PARAM_DELAY) 8'b0000_0000;
       dsync8[15: 8] <= #(PARAM_DELAY) 8'b0000_0000;
       dsync8[23:16] <= #(PARAM_DELAY) 8'b0000_0000;
       dsync8[31:24] <= #(PARAM_DELAY) 8'b0000_0000;
     end
     else begin
       dsync8[ 7: 0] <= #(PARAM_DELAY) dout_int[ 7: 0];
       dsync8[15: 8] <= #(PARAM_DELAY) dout_int[15: 8];
       dsync8[23:16] <= #(PARAM_DELAY) dout_int[23:16];
       dsync8[31:24] <= #(PARAM_DELAY) dout_int[31:24];
     end

   always @ ( negedge rst_n or posedge clk_divrx )
     if ( ~rst_n ) 
       dout[63:0] <= #(PARAM_DELAY) 64'b0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000_0000;
     else 
       dout[63:0] <= #(PARAM_DELAY) {dout_int[63:32],dsync8[31:0]};

endmodule // arriaii_hssi_pma_c_deser_10g

//====Revision Log================
//Rev: 1.13   Wed Jun 18 11:42:18 PDT 2008   cgaillar
//Removed all 1'b1 & 1'b0 from instances. Added ifdef COSIM flag to change delay parameter from 1 to 0.05 and 2 to 0.1
//====End Log======================

module arriaii_hssi_pma_c_pcie_sw (
   cpulse, cpulse_out, cpulseb, cpulsei, dynamic_sw, gen2ngen1, hclk, hfclkn, hfclkn_out,
   hfclkp, hfclkp_out, lfclkn, lfclkn_out, lfclkp, lfclkp_out, pcie_sw, pcie_sw_cdr,
   pclk, pdb, rst_n, vccelxqyx, vssexqyx, div5 );

   input   cpulse;
   input   cpulseb;
   input   cpulsei;
   input   dynamic_sw;
   input   hfclkn;
   input   hfclkp;
   input   lfclkn;
   input   lfclkp;
   input   pcie_sw;
   input   pdb;
   input   rst_n;
   input   vccelxqyx;
   input   vssexqyx;
   input   div5;

   output  cpulse_out;
   output  gen2ngen1;
   output  hclk;
   output  hfclkn_out;
   output  hfclkp_out;
   output  lfclkn_out;
   output  lfclkp_out;
   output  pcie_sw_cdr;
   output  pclk;

   parameter    PARAM_DELAY = 0;

   wire         nclri, clk_selectb, div2_enlf;
   wire         lfclk0_div2, lfclk90_div2, lfclk180_div2, lfclk270_div2;
   wire         lfclk0_div2_int, lfclk90_div2_int, lfclk180_div2_int, lfclk270_div2_int;
   wire         hfclk0_div2, hfclk90_div2, hfclk180_div2, hfclk270_div2;
   wire         cpulse_div2, cpulse_div2_int; 
   reg          div2_enhf, div2_enhf_reg;
   integer      counter_hfclk0_div2;

//   integer cpulse_div2_counter;

   initial begin
     div2_enhf      = 1'b0;
     div2_enhf_reg  = 1'b0;
//       cpulse_div2_counter = 0;
     counter_hfclk0_div2 = 0;
   end

   always @ ( negedge hfclkp or negedge rst_n ) 
     if ( rst_n == 1'b0)
       div2_enhf_reg <= 1'b0;
     else
       div2_enhf_reg <= div2_enhf;

   arriaii_hssi_pma_c_divby2q xhf (
      .clk(hfclkp), .clk0(hfclk0_div2), .clk90(hfclk90_div2), .clk180(hfclk180_div2),
      .vcce_la(vccelxqyx), .vssexqyx(vssexqyx),
      .clk270(hfclk270_div2), .clkb(hfclkn), .rst_n(div2_enhf_reg) );

   arriaii_hssi_pma_c_divby2q xlf (
      .clk(lfclkp), .clk0(lfclk0_div2_int), .clk90(lfclk90_div2_int), .clk180(lfclk180_div2_int),
      .vcce_la(vccelxqyx), .vssexqyx(vssexqyx),
      .clk270(lfclk270_div2_int), .clkb(lfclkn), .rst_n(vccelxqyx) );

   assign hclk        = ~(~lfclkp & rst_n);
   assign pclk        =  lfclkp_out;

   assign clk_selectb =  div2_enhf_reg;
   assign gen2ngen1   =  nclri ? ~div2_enhf_reg : 1'b0;
   assign nclri       =  dynamic_sw & rst_n;
   assign pcie_sw_cdr = ~pcie_sw & dynamic_sw & rst_n;
   assign {lfclk0_div2,lfclk90_div2,lfclk180_div2,lfclk270_div2} = div2_enhf_reg ? {lfclk0_div2_int,lfclk90_div2_int,lfclk180_div2_int,lfclk270_div2_int} : 4'b0000;
   assign {hfclkp_out,hfclkn_out,cpulse_out,lfclkp_out,lfclkn_out} = ~pdb ? 5'b01_0_01 :
                                                                     ~clk_selectb ? {hfclkp,hfclkn,cpulse,lfclkp,lfclkn} : 
                                                                                    {hfclk0_div2,hfclk180_div2,cpulse_div2&lfclk0_div2,lfclk0_div2,lfclk180_div2};

   // cpulse_div2 generation
   assign cpulse_div2_int  = ( ~div5 && (counter_hfclk0_div2 % 4 == 1) || 
                                div5 && (counter_hfclk0_div2 % 5 == 1) ) ? 1'b1 : 1'b0;
   assign cpulse_div2      = cpulse_div2_int & lfclk0_div2;
 
   always @ ( posedge hfclk0_div2 or negedge div2_enhf_reg )
     if (div2_enhf_reg == 1'b0)
       counter_hfclk0_div2  <= 0;
     else if (div2_enhf_reg == 1'b1)
       counter_hfclk0_div2  <= counter_hfclk0_div2 + 1;

   // - arriaii_hssi_pma_c_deglitch -
   // Synchronization with lclk270 _div2
      always @ ( posedge lfclk270_div2_int or negedge rst_n )
     if ( rst_n == 1'b0)
       div2_enhf  <= 1'b0; 
     else 
       div2_enhf  <= pcie_sw_cdr;

endmodule // arriaii_hssi_pma_c_pcie_sw

//====Revision Log================
//Rev: 1.1   Tue Sep  2 10:28:39 PDT 2008   cgaillar
//Initial C5 version
//
//Rev: 1.2   Fri Apr 25 17:28:54 PDT 2008   cgaillar
//Replaced 1'b1 & 1'b0 with vcc* & vss* in instances derived from schematics
//====End Log======================

module arriaii_hssi_pma_c_clkgendrv_tx10g (
   clk0, clk180, cpulse, cpulseb, hfclk_n, hfclk_p, lfclk_n, lfclk_p, rst_n, vccelxqyx,
   vssexqyx );

   input   clk0;
   input   clk180;
   input   rst_n;
   input   vccelxqyx;
   input   vssexqyx;

   output  cpulse;
   output  cpulseb;
   output  hfclk_n;
   output  hfclk_p;
   output  lfclk_n;
   output  lfclk_p;

   wire    nc2;

   arriaii_hssi_pma_c_clkgendrv xdrv (
      .clk0(clk0), .clk90(1'b0), .clk180(clk180), .clk270(1'b1),
      .cpulse(cpulse), .cpulseb(cpulseb), .cpulseo(nc2), .div5(1'b0), .hfclk_n(hfclk_n), .hfclk_p(hfclk_p),
      .lfclk_n(lfclk_n), .lfclk_p(lfclk_p), .rst_n(rst_n), .vccelxqyx(vccelxqyx), .vssexqyx(vssexqyx) );

endmodule // arriaii_hssi_pma_c_clkgendrv_tx10g

//====Revision Log================
//Rev: 1.1   Tue Sep  2 10:28:40 PDT 2008   cgaillar
//Initial C5 version
//
//Rev: 1.1   Fri Apr 25 12:04:06 PDT 2008   cgaillar
//Updates to match g_gx_clean_ww16 PMA / g_hssi_ww17 HSSI tags
//
//====End Log======================

module arriaii_hssi_pma_c_clkgenbuf_tx10g (
   clk0_in, clk180_in, cpulse, cpulseb, hfclk_n, hfclk_p, lfclk_n, lfclk_p, rst_n,
   vccelxqyx, vssexqyx );

   input   clk0_in;
   input   clk180_in;
   input   rst_n;
   input   vccelxqyx;
   input   vssexqyx;

   output  cpulse;
   output  cpulseb;
   output  hfclk_n;
   output  hfclk_p;
   output  lfclk_n;
   output  lfclk_p;

   wire    clk0_out, clk180_out;

   assign  clk0_out   = clk0_in;
   assign  clk180_out = clk180_in;

   arriaii_hssi_pma_c_clkgendrv_tx10g xdrv (
      .clk0(clk0_out), .clk180(clk180_out), .cpulse(cpulse), .cpulseb(cpulseb), .hfclk_n(hfclk_n),
      .hfclk_p(hfclk_p), .lfclk_n(lfclk_n), .lfclk_p(lfclk_p), .rst_n(rst_n), .vccelxqyx(vccelxqyx),
      .vssexqyx(vssexqyx) );

endmodule // arriaii_hssi_pma_c_clkgenbuf_tx10g

// ***********************************************************
// This WYSIWYG atom header was automatically generated by the
// Atmgen build tool. To change it, alter data stored in the 
// corresponding WYS file(s) in the tools/atmgen subdirectory.
// ***********************************************************

// *** Section 1 -- Header ***

// -----------------------------------------------------------
//
// Module Name : arriaii_hssi_clock_divider
//
// Description : DEV_FAMILY_ARRIAII arriaii_hssi_clock_divider Verilog simulation model
//
// -----------------------------------------------------------

`timescale 1 ps/1 ps

// *** End of Section 1 ***

// *** Section 3 -- Module declaration ***

module arriaii_hssi_clock_divider(
			clk0in,
			clk1in,
			dpriodisable,
			dprioin,
			powerdn,
			quadreset,
			rateswitch,
			rateswitchbaseclkin,
			rateswitchdonein,
			refclkdig,
			refclkin,
			vcobypassin,

			analogfastrefclkout,
			analogfastrefclkoutshifted,
			analogrefclkout,
			analogrefclkoutshifted,
			analogrefclkpulse,
			analogrefclkpulseshifted,
			coreclkout,
			dprioout,
			rateswitchbaseclock,
			rateswitchdone,
			rateswitchout,
			refclkout 
		);

// *** End of Section 3 ***

// *** Section 4 -- Port size declarations ***

// Note: Variable port sizes dictated by parameters are not currently defined in
// the WYS file data. Busses are marked with the VARIABLE notation as a reminder.

`define  ANALOGFASTREFCLKOUT_PORTSIZE_CONST_arriaii_hssi_clock_divider  2		// * VARIABLE
`define  ANALOGFASTREFCLKOUTSHIFTED_PORTSIZE_CONST_arriaii_hssi_clock_divider  2		// * VARIABLE
`define  ANALOGREFCLKOUT_PORTSIZE_CONST_arriaii_hssi_clock_divider  2		// * VARIABLE
`define  ANALOGREFCLKOUTSHIFTED_PORTSIZE_CONST_arriaii_hssi_clock_divider  2		// * VARIABLE
`define  ANALOGREFCLKPULSE_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  ANALOGREFCLKPULSESHIFTED_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  CLK0IN_PORTSIZE_CONST_arriaii_hssi_clock_divider  4		// * VARIABLE
`define  CLK1IN_PORTSIZE_CONST_arriaii_hssi_clock_divider  4		// * VARIABLE
`define  CORECLKOUT_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  DPRIODISABLE_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  DPRIOIN_PORTSIZE_CONST_arriaii_hssi_clock_divider  100		
`define  DPRIOOUT_PORTSIZE_CONST_arriaii_hssi_clock_divider  100		
`define  POWERDN_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  QUADRESET_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  RATESWITCH_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  RATESWITCHBASECLKIN_PORTSIZE_CONST_arriaii_hssi_clock_divider  2		// * VARIABLE
`define  RATESWITCHBASECLOCK_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  RATESWITCHDONE_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  RATESWITCHDONEIN_PORTSIZE_CONST_arriaii_hssi_clock_divider  2		// * VARIABLE
`define  RATESWITCHOUT_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  REFCLKDIG_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  REFCLKIN_PORTSIZE_CONST_arriaii_hssi_clock_divider  2		// * VARIABLE
`define  REFCLKOUT_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		
`define  VCOBYPASSIN_PORTSIZE_CONST_arriaii_hssi_clock_divider  1		

// *** End of Section 4 ***

// *** Section 5 -- Port declarations ***

input  [`CLK0IN_PORTSIZE_CONST_arriaii_hssi_clock_divider - 1 : 0] clk0in;
input  [`CLK1IN_PORTSIZE_CONST_arriaii_hssi_clock_divider - 1 : 0] clk1in;
input  dpriodisable;
input  [`DPRIOIN_PORTSIZE_CONST_arriaii_hssi_clock_divider - 1 : 0] dprioin;
input  powerdn;
input  quadreset;
input  rateswitch;
input  [`RATESWITCHBASECLKIN_PORTSIZE_CONST_arriaii_hssi_clock_divider - 1 : 0] rateswitchbaseclkin;
input  [`RATESWITCHDONEIN_PORTSIZE_CONST_arriaii_hssi_clock_divider - 1 : 0] rateswitchdonein;
input  refclkdig;
input  [`REFCLKIN_PORTSIZE_CONST_arriaii_hssi_clock_divider - 1 : 0] refclkin;
input  vcobypassin;
output [`ANALOGFASTREFCLKOUT_PORTSIZE_CONST_arriaii_hssi_clock_divider - 1 : 0] analogfastrefclkout;
output [`ANALOGFASTREFCLKOUTSHIFTED_PORTSIZE_CONST_arriaii_hssi_clock_divider - 1 : 0] analogfastrefclkoutshifted;
output [`ANALOGREFCLKOUT_PORTSIZE_CONST_arriaii_hssi_clock_divider - 1 : 0] analogrefclkout;
output [`ANALOGREFCLKOUTSHIFTED_PORTSIZE_CONST_arriaii_hssi_clock_divider - 1 : 0] analogrefclkoutshifted;
output analogrefclkpulse;
output analogrefclkpulseshifted;
output coreclkout;
output [`DPRIOOUT_PORTSIZE_CONST_arriaii_hssi_clock_divider - 1 : 0] dprioout;
output rateswitchbaseclock;
output rateswitchdone;
output rateswitchout;
output refclkout;

// *** End of Section 5 ***

// *** Section 6 -- Parameter declarations and default values ***

parameter lpm_type = "arriaii_hssi_clock_divider";
parameter channel_num =  0 ;
parameter coreclk_out_gated_by_quad_reset = "false";
parameter data_rate =  0 ;
parameter divide_by =  4 ;
parameter divider_type = "CHANNEL_REGULAR";
parameter dprio_config_mode = 6'h00;
parameter effective_data_rate = "unused";
parameter enable_dynamic_divider = "false";
parameter enable_refclk_out = "false";
parameter inclk_select =  0 ;
parameter logical_channel_address =  0 ;
parameter pre_divide_by =  1 ;
parameter rate_switch_base_clk_in_select =  0 ;
parameter rate_switch_done_in_select =  0 ;
parameter refclk_divide_by =  0 ;
parameter refclk_multiply_by =  0 ;
parameter refclkin_select =  0 ;
parameter select_local_rate_switch_base_clock = "false";
parameter select_local_rate_switch_done = "true";    // shawn
parameter select_local_refclk = "false";
parameter select_refclk_dig = "false";
parameter sim_analogfastrefclkout_phase_shift =  0 ;
parameter sim_analogrefclkout_phase_shift =  0 ;
parameter sim_coreclkout_phase_shift =  0 ;
parameter sim_refclkout_phase_shift =  0 ;
parameter use_coreclk_out_post_divider = "false";
parameter use_refclk_post_divider = "false";
parameter use_vco_bypass = "false";

// *** End of Section 6 ***

// *** Section 7 -- Port declarations with defaults, if any ***

// This section will always be empty for WYSIWYG atoms
// tri1 devclrn;		//sample

// *** End of Section 7 ***

// --------------------------------------------------------------------------
// Model Implementation Begin
// --------------------------------------------------------------------------

`define ARRIAII_HSSI_CD_WORD_LENGTH 18

// ---------------------------------------------------------------------------
//  New DPRIO Begin                                                          
// ---------------------------------------------------------------------------
`define INCLK_SELECT_CLOCK_DIV_IDX              0   // logic index
`define ht_sel_CLOCK_DIV_IDX		           	1	// existing - only in cmu
`define rdynamic_sw_CLOCK_DIV_IDX_0 			86  // matching tx_pma index
`define rpmadwidth_tx_CLOCK_DIV_IDX_0 			89	// rcgb_div5
`define rpma_doublewidth_tx_CLOCK_DIV_IDX_0 	90	// rcgb_div2
`define rcgb_m_sel_CLOCK_DIV_IDX_0 				91	
`define rcgb_m_sel_CLOCK_DIV_IDX_1 				92
`define rcgb_cmu_sel_CLOCK_DIV_IDX_0 			93

// central clock divider section
`define rfreerun_centrl_CLOCK_DIV_IDX    10
`define rcentrl_clk_sel_CLOCK_DIV_IDX    11
`define rrefclk_out_div2_CLOCK_DIV_IDX   12

// ---------------------------------------------------------------------------
// DPRIO input CRAM  
// ---------------------------------------------------------------------------
// CRAM value from DPRIO
wire		dprioin_ht_sel;
wire        dprioin_rcgb_cmu_sel;
wire [1:0]  dprioin_rcgb_m_sel;
wire        dprioin_rpmadwidth_tx;				// rcgb_div5
wire        dprioin_rcgb_rpma_doublewidth_tx;	// rcgb_div2
wire        dprioin_rcgb_dynamic_sw;

// SW logical index
wire   dprioin_inclk_select;

// central clock divider section
wire  dprioin_rfreerun_centrl;
wire  dprioin_rcentrl_clk_sel;
wire  dprioin_rrefclk_out_div2;

// ---------------------------------------------------------------------------
// Initial CRAM  
// ---------------------------------------------------------------------------
reg		   init_ht_sel;
reg        init_rcgb_cmu_sel;
reg [1:0]  init_rcgb_m_sel;
reg        init_rpmadwidth_tx;				// rcgb_div5
reg        init_rcgb_rpma_doublewidth_tx;	// rcgb_div2
reg        init_rcgb_dynamic_sw;

// SW logical index
reg    init_inclk_select;

// central clock divider section
reg  init_rfreerun_centrl;
reg  init_rcentrl_clk_sel;
reg  init_rrefclk_out_div2;

reg is_high_speed_regular;
reg is_enable_refclk_out;
reg is_select_local_refclk;
reg is_select_local_rate_switch_done;
reg is_select_local_rate_switch_base_clock;
reg is_use_vco_bypass;
wire is_using_refclk_post_divider;
wire is_using_coreclk_out_post_divider;
wire is_select_refclk_dig;
// ---------------------------------------------------------------------------
// CRAM  
// ---------------------------------------------------------------------------
wire		cram_ht_sel;
wire        cram_rcgb_cmu_sel;
wire [1:0]  cram_rcgb_m_sel;
wire        cram_rpmadwidth_tx;				// rcgb_div5
wire        cram_rcgb_rpma_doublewidth_tx;	// rcgb_div2
wire        cram_rcgb_dynamic_sw;

// SW logical index
wire   cram_inclk_select;

// central clock divider section
wire  cram_rfreerun_centrl;
wire  cram_rcentrl_clk_sel;
wire  cram_rrefclk_out_div2;

// ---------------------------------------------------------------------------
// Set DPRIO CRAM input from dprioin  
// ---------------------------------------------------------------------------
assign dprioin_ht_sel 					= dprioin[`ht_sel_CLOCK_DIV_IDX];
assign dprioin_rcgb_cmu_sel 			= dprioin[`rcgb_cmu_sel_CLOCK_DIV_IDX_0];
assign dprioin_rcgb_m_sel 				= dprioin[`rcgb_m_sel_CLOCK_DIV_IDX_1 : `rcgb_m_sel_CLOCK_DIV_IDX_0];
assign dprioin_rpmadwidth_tx 			= dprioin[`rpmadwidth_tx_CLOCK_DIV_IDX_0];
assign dprioin_rcgb_rpma_doublewidth_tx = dprioin[`rpma_doublewidth_tx_CLOCK_DIV_IDX_0];
assign dprioin_rcgb_dynamic_sw 			= dprioin[`rdynamic_sw_CLOCK_DIV_IDX_0];

// SW logical index
assign dprioin_inclk_select = dprioin[`INCLK_SELECT_CLOCK_DIV_IDX];

// central clock divider section
assign dprioin_rfreerun_centrl  = dprioin[`rfreerun_centrl_CLOCK_DIV_IDX];
assign dprioin_rcentrl_clk_sel  = dprioin[`rcentrl_clk_sel_CLOCK_DIV_IDX];
assign dprioin_rrefclk_out_div2 = dprioin[`rrefclk_out_div2_CLOCK_DIV_IDX];

// ---------------------------------------------------------------------------
// Set DPRIO output from initial CRAM
// ---------------------------------------------------------------------------
//assign dprioout[`rcru_pdbwctrl_PLL_IDX_1 : `rcru_pdbwctrl_PLL_IDX_0] = init_rcru_pdbwctrl;
assign dprioout[`ht_sel_CLOCK_DIV_IDX] 										= init_ht_sel;
assign dprioout[`rcgb_cmu_sel_CLOCK_DIV_IDX_0] 								= init_rcgb_cmu_sel;
assign dprioout[`rcgb_m_sel_CLOCK_DIV_IDX_1 : `rcgb_m_sel_CLOCK_DIV_IDX_0] 	= init_rcgb_m_sel;
assign dprioout[`rpmadwidth_tx_CLOCK_DIV_IDX_0] 							= init_rpmadwidth_tx;
assign dprioout[`rpma_doublewidth_tx_CLOCK_DIV_IDX_0] 						= init_rcgb_rpma_doublewidth_tx;
assign dprioout[`rdynamic_sw_CLOCK_DIV_IDX_0] 								= init_rcgb_dynamic_sw;

// SW logical index
assign dprioout[`INCLK_SELECT_CLOCK_DIV_IDX] = init_inclk_select;

// central clock divider section
assign dprioout[`rfreerun_centrl_CLOCK_DIV_IDX]  = init_rfreerun_centrl;
assign dprioout[`rcentrl_clk_sel_CLOCK_DIV_IDX]  = init_rcentrl_clk_sel ;
assign dprioout[`rrefclk_out_div2_CLOCK_DIV_IDX] = init_rrefclk_out_div2;

// ---------------------------------------------------------------------------
// Set DPRIO CRAM
// ---------------------------------------------------------------------------
//assign cram_ht_sel 					= (dpriodisable_in !== 1'b0) ? init_ht_sel : dprioin_ht_sel;
assign cram_ht_sel 					= init_ht_sel;
assign cram_rcgb_cmu_sel 				= (dpriodisable !== 1'b0) ? init_rcgb_cmu_sel : dprioin_rcgb_cmu_sel;
assign cram_rcgb_m_sel 					= (dpriodisable !== 1'b0) ? init_rcgb_m_sel : dprioin_rcgb_m_sel;
assign cram_rpmadwidth_tx 				= (dpriodisable !== 1'b0) ? init_rpmadwidth_tx : dprioin_rpmadwidth_tx;
assign cram_rcgb_rpma_doublewidth_tx 	= (dpriodisable !== 1'b0) ? init_rcgb_rpma_doublewidth_tx : dprioin_rcgb_rpma_doublewidth_tx;
assign cram_rcgb_dynamic_sw 			= (dpriodisable !== 1'b0) ? init_rcgb_dynamic_sw : dprioin_rcgb_dynamic_sw;

// SW logical index
assign cram_inclk_select    = (dpriodisable !== 1'b0) ? init_inclk_select : dprioin_inclk_select;

// central clock divider section
assign cram_rfreerun_centrl    = (dpriodisable !== 1'b0) ? init_rfreerun_centrl : dprioin_rfreerun_centrl;
assign cram_rcentrl_clk_sel    = (dpriodisable !== 1'b0) ? init_rcentrl_clk_sel : dprioin_rcentrl_clk_sel;
assign cram_rrefclk_out_div2   = (dpriodisable !== 1'b0) ? init_rrefclk_out_div2 : dprioin_rrefclk_out_div2;

// wires for other inputs and outputs
// inputs
wire [1:0] clkgen_cgb_x_en;
wire clkgen_clk0_0;
wire clkgen_clk90_0;
wire clkgen_clk180_0;
wire clkgen_clk270_0;
wire clkgen_clk0_1;
wire clkgen_clk90_1;
wire clkgen_clk180_1;
wire clkgen_clk270_1;
wire clkgen_pcie_sw;
wire clkgen_pdb;
wire clkgen_rst_n;

// outputs
wire clkgen_cgb_vccelxqyx;
wire clkgen_cgb_vssexqyx;
wire clkgen_cpulse_ht;
wire clkgen_cpulse_x1;
wire clkgen_hclk;
wire clkgen_hfclkn_ht;
wire clkgen_hfclkn_x1;
wire clkgen_hfclkp_ht;
wire clkgen_hfclkp_x1;
wire clkgen_lfclkn_ht;
wire clkgen_lfclkn_x1;
wire clkgen_lfclkp_ht;
wire clkgen_lfclkp_x1;
wire clkgen_pclk;
wire clkgen_pcie_sw_cdr;
wire clkgen_gen2ngen1;
wire vccelx;
wire vssex;
wire wire_reset;

// 10g outputs
wire clkgen_10g_cpulse;
wire clkgen_10g_cpulseb;
wire clkgen_10g_hfclk_n;
wire clkgen_10g_hfclk_p;
wire clkgen_10g_lfclk_n;
wire clkgen_10g_lfclk_p;

// intermediate wires
wire coreclkout_mux;
wire coreclk_divide_out;
wire vcobypassmux_out;
wire refclk_divide_out;
wire refclkdividemux_out;

// function declarations
    // convert uppercase parameter values to lowercase
    // assumes that the maximum character length of a parameter is 18
    function [8*`ARRIAII_HSSI_CD_WORD_LENGTH:1] alpha_tolower;
    input [8*`ARRIAII_HSSI_CD_WORD_LENGTH:1] given_string;

    reg [8*`ARRIAII_HSSI_CD_WORD_LENGTH:1] return_string;
    reg [8*`ARRIAII_HSSI_CD_WORD_LENGTH:1] reg_string;
    reg [8:1] tmp;
    reg [8:1] conv_char;
    integer byte_count;
    begin
        return_string = "                    "; // initialise strings to spaces
        conv_char = "        ";
        reg_string = given_string;
        for (byte_count = `ARRIAII_HSSI_CD_WORD_LENGTH; byte_count >= 1; byte_count = byte_count - 1)
        begin
            tmp = reg_string[8*`ARRIAII_HSSI_CD_WORD_LENGTH:(8*(`ARRIAII_HSSI_CD_WORD_LENGTH-1)+1)];
            reg_string = reg_string << 8;
            if ((tmp >= 65) && (tmp <= 90)) // ASCII number of 'A' is 65, 'Z' is 90
            begin
                conv_char = tmp + 32; // 32 is the difference in the position of 'A' and 'a' in the ASCII char set
                return_string = {return_string, conv_char};
            end
            else
                return_string = {return_string, tmp};
        end

        alpha_tolower = return_string;
    end
    endfunction


initial
begin
    // Convert Parameters to initial CRAMs
    init_ht_sel 					= (alpha_tolower(divider_type) == "central_enhanced" || alpha_tolower(divider_type) == "central_regular") ? 1'b1 : 1'b0;
    init_rcgb_cmu_sel 				= (inclk_select == 0) ? 1'b0 : 1'b1;
    init_rcgb_m_sel 				= (pre_divide_by == 2) ? 2'b01 : (pre_divide_by == 4) ? 2'b10 : 2'b00;
    init_rpmadwidth_tx 				= (divide_by == 4) ? 1'b0 : 1'b1;
    init_rcgb_rpma_doublewidth_tx 	= (use_refclk_post_divider == "true") ? 1'b1 : 1'b0;
    init_rcgb_dynamic_sw			= (enable_dynamic_divider == "true") ? 1'b1 : 1'b0;

    // sw logic index
    init_inclk_select               = (inclk_select == 0) ? 1'b0 : 1'b1;
    
    // central clock divider section
    init_rfreerun_centrl            = 1'b1;  // missing parameter
    init_rcentrl_clk_sel            = (select_refclk_dig == "true") ? 1'b1 : 1'b0;
    init_rrefclk_out_div2           = (use_coreclk_out_post_divider == "true") ? 1'b1 : 1'b0;
    
    is_high_speed_regular = (alpha_tolower(divider_type) == "high_speed_regular") ? 1'b1 : 1'b0;
    is_enable_refclk_out = (enable_refclk_out == "true") ? 1'b1 : 1'b0;
    is_select_local_refclk = (select_local_refclk == "true") ? 1'b1 : 1'b0;
    is_select_local_rate_switch_done = (select_local_rate_switch_done == "true") ? 1'b1 : 1'b0;
    is_select_local_rate_switch_base_clock = (select_local_rate_switch_base_clock == "true") ? 1'b1 : 1'b0;
    is_use_vco_bypass = (use_vco_bypass == "true") ? 1'b1 : 1'b0;
end

assign is_using_refclk_post_divider      = (cram_rcgb_rpma_doublewidth_tx === 1'b1) ? 1'b1 : 1'b0;
assign is_using_coreclk_out_post_divider = (cram_rrefclk_out_div2 === 1'b1) ? 1'b1 : 1'b0;
assign is_select_refclk_dig              = (cram_rcentrl_clk_sel === 1'b1) ? 1'b1 : 1'b0;

// connect inputs from top-level
//assign cgb_pclksel = (refclkin_select;
assign clkgen_cgb_x_en = 2'b00;             // enable for pdb
assign clkgen_clk0_0 = (is_high_speed_regular == 1'b1) ? 1'b0 : clk0in[0];          // Phase 0
assign clkgen_clk0_1 = (is_high_speed_regular == 1'b1) ? 1'b0 : clk1in[0];          // Phase 0
assign clkgen_clk90_0 = (is_high_speed_regular == 1'b1) ? 1'b0 : clk0in[1];
assign clkgen_clk90_1 = (is_high_speed_regular == 1'b1) ? 1'b0 : clk1in[1];
assign clkgen_clk180_0 = (is_high_speed_regular == 1'b1) ? 1'b0 : clk0in[2];
assign clkgen_clk180_1 = (is_high_speed_regular == 1'b1) ? 1'b0 : clk1in[2];
assign clkgen_clk270_0 = (is_high_speed_regular == 1'b1) ? 1'b0 : clk0in[3];
assign clkgen_clk270_1 = (is_high_speed_regular == 1'b1) ? 1'b0 : clk1in[3];
assign clkgen_pdb = (powerdn === 1'b1) ? 1'b0 : 1'b1;    // pdb is active low
assign clkgen_pcie_sw = (rateswitch === 1'b1) ? 1'b1 : 1'b0;
assign clkgen_rst_n = (quadreset === 1'b1) ? 1'b0 : 1'b1;

// ICD's clkgenbuf_cmu instantiation 

   arriaii_hssi_pma_c_clkgenbuf_cmu clkgen (  .cgb_x_en(clkgen_cgb_x_en),
                                          .clk0_0(clkgen_clk0_0),
                                          .clk0_1(clkgen_clk0_1),
                                          .clk90_0(clkgen_clk90_0),
                                          .clk90_1(clkgen_clk90_1),
                                          .clk180_0(clkgen_clk180_0),
                                          .clk180_1(clkgen_clk180_1),
                                          .clk270_0(clkgen_clk270_0),
                                          .clk270_1(clkgen_clk270_1),
                                          .cmu_sel(cram_inclk_select),
                                          .div5(cram_rpmadwidth_tx),
                                          .dynamic_sw(cram_rcgb_dynamic_sw),
                                          .ht_sel(cram_ht_sel),
                                          .m_sel(cram_rcgb_m_sel),
                                          .pcie_sw(clkgen_pcie_sw),
                                          .pdb(clkgen_pdb),
                                          .rst_n(clkgen_rst_n),
                                          .vccelxqyx(vccelx),
                                          .vssexqyx(vssex),

                                          .cgb_vccelxqyx(clkgen_cgb_vccelxqyx),
                                          .cgb_vssexqyx(clkgen_cgb_vssexqyx),
                                          .cpulse_ht(clkgen_cpulse_ht),
                                          .cpulse_x1(clkgen_cpulse_x1),
                                          .gen2ngen1(clkgen_gen2ngen1),
                                          .hclk(clkgen_hclk),
                                          .hfclkn_ht(clkgen_hfclkn_ht),
                                          .hfclkn_x1(clkgen_hfclkn_x1),
                                          .hfclkp_ht(clkgen_hfclkp_ht),
                                          .hfclkp_x1(clkgen_hfclkp_x1),
                                          .lfclkn_ht(clkgen_lfclkn_ht),
                                          .lfclkn_x1(clkgen_lfclkn_x1),
                                          .lfclkp_ht(clkgen_lfclkp_ht),
                                          .lfclkp_x1(clkgen_lfclkp_x1),
                                          .pcie_sw_cdr(clkgen_pcie_sw_cdr),
                                          .pclk(clkgen_pclk)
                                        );

        arriaii_hssi_pma_c_clkgenbuf_tx10g clkgen_10g ( .clk0_in(clk0in[0]),
                                                    .clk180_in(clk0in[2]),
                                                    .rst_n(clkgen_rst_n),
                                                    .vccelxqyx(vccelx),
                                                    .vssexqyx(vssex),
    
                                                    .cpulse(clkgen_10g_cpulse),
                                                    .cpulseb(clkgen_10g_cpulseb),
                                                    .hfclk_n(clkgen_10g_hfclk_n),
                                                    .hfclk_p(clkgen_10g_hfclk_p),
                                                    .lfclk_n(clkgen_10g_lfclk_n),
                                                    .lfclk_p(clkgen_10g_lfclk_p)
                                                  );    

    assign analogrefclkout = (is_high_speed_regular == 1'b1) ? ({clkgen_10g_lfclk_n, clkgen_10g_lfclk_p}) : ({clkgen_lfclkn_x1, clkgen_lfclkp_x1});

    assign analogfastrefclkout = (is_high_speed_regular == 1'b1) ? ({clkgen_10g_hfclk_n, clkgen_10g_hfclk_p}) : ({clkgen_hfclkn_x1, clkgen_hfclkp_x1});

    assign analogrefclkpulse = (is_high_speed_regular == 1'b1) ? clkgen_10g_cpulse : clkgen_cpulse_x1;

    assign rateswitchdone = (is_select_local_rate_switch_done == 1'b1) ? clkgen_gen2ngen1 : rateswitchdonein[rate_switch_done_in_select];
    assign rateswitchbaseclock = (is_select_local_rate_switch_base_clock == 1'b1) ? clkgen_hclk : rateswitchbaseclkin[rate_switch_base_clk_in_select];
    assign rateswitchout = rateswitch;
    assign analogrefclkoutshifted = ({clkgen_lfclkn_ht, clkgen_lfclkp_ht});
    assign analogfastrefclkoutshifted = ({clkgen_hfclkn_ht, clkgen_hfclkp_ht});
    assign analogrefclkpulseshifted = clkgen_cpulse_ht;

    assign vcobypassmux_out = (is_use_vco_bypass == 1'b1 ? ~vcobypassin : clkgen_pclk);
    arriaii_hssi_aux_clock_div refclk_divider ( .clk(vcobypassmux_out),
                                            .enable_d(1'b0),
                                            .d(8'b0),
                                            .reset(wire_reset),
                                            .clkout(refclk_divide_out)
                                          );
    defparam refclk_divider.clk_divide_by = 2;
    defparam refclk_divider.extra_latency = 0;

    assign refclkdividemux_out = (is_using_refclk_post_divider == 1'b1 ? refclk_divide_out : vcobypassmux_out);

    assign refclkout = (is_enable_refclk_out == 1'b1 ? (is_select_refclk_dig == 1'b1) ? refclkdig : (is_select_local_refclk == 1'b1 ? refclkdividemux_out : refclkin[refclkin_select]) : 1'bz);

    arriaii_hssi_aux_clock_div coreclk_divider ( .clk(refclkout),
                                             .enable_d(1'b0),
                                             .d(8'b0),
                                             .reset(wire_reset),
                                             .clkout(coreclk_divide_out)
                                           );
    defparam coreclk_divider.clk_divide_by = 2;
    defparam coreclk_divider.extra_latency = 0;

    assign coreclkout = (is_using_coreclk_out_post_divider == 1'b1) ? coreclk_divide_out : refclkout;

endmodule

// ***********************************************************
// This WYSIWYG atom header was automatically generated by the
// Atmgen build tool. To change it, alter data stored in the 
// corresponding WYS file(s) in the tools/atmgen subdirectory.
// ***********************************************************

// *** Section 1 -- Header ***

// -----------------------------------------------------------
//
// Module Name : arriaii_hssi_pll
//
// Description : DEV_FAMILY_ARRIAII arriaii_hssi_pll Verilog simulation model
//
// -----------------------------------------------------------

`timescale 1 ps/1 ps

// *** End of Section 1 ***

// *** Section 3 -- Module declaration ***

module arriaii_hssi_pll(
			areset,
			datain,
                        dpriodisable,
			dprioin,
                        earlyeios,
                        extra10gin,
			inclk,
			locktorefclk,
			pfdfbclk,
			powerdown,
			rateswitch,

			clk,
			dataout,
                        dprioout,
			freqlocked,
			locked,
			pfdfbclkout,
			pfdrefclkout,
			vcobypassout 
		);

// *** End of Section 3 ***

// *** Section 4 -- Port size declarations ***

// Note: Variable port sizes dictated by parameters are not currently defined in
// the WYS file data. Busses are marked with the VARIABLE notation as a reminder.

`define  ARESET_PORTSIZE_CONST_arriaii_hssi_pll  1		
`define  CLK_PORTSIZE_CONST_arriaii_hssi_pll  4		// * VARIABLE
`define  DATAIN_PORTSIZE_CONST_arriaii_hssi_pll  1		
`define  DATAOUT_PORTSIZE_CONST_arriaii_hssi_pll  2		// * VARIABLE
`define  DPRIODISABLE_PORTSIZE_CONST_arriaii_hssi_pll  1		
`define  DPRIOIN_PORTSIZE_CONST_arriaii_hssi_pll  300		// * VARIABLE
`define  DPRIOOUT_PORTSIZE_CONST_arriaii_hssi_pll  300		// * VARIABLE
`define  EARLYEIOS_PORTSIZE_CONST_arriaii_hssi_pll  1
`define  EXTRA10GIN_PORTSIZE_CONST_arriaii_hssi_pll  6		// * VARIABLE
`define  FREQLOCKED_PORTSIZE_CONST_arriaii_hssi_pll  1		
`define  INCLK_PORTSIZE_CONST_arriaii_hssi_pll  10		// * VARIABLE
`define  LOCKED_PORTSIZE_CONST_arriaii_hssi_pll  1		
`define  LOCKTOREFCLK_PORTSIZE_CONST_arriaii_hssi_pll  1
`define  PFDFBCLK_PORTSIZE_CONST_arriaii_hssi_pll  1		
`define  PFDFBCLKOUT_PORTSIZE_CONST_arriaii_hssi_pll  1		
`define  PFDREFCLKOUT_PORTSIZE_CONST_arriaii_hssi_pll  1		
`define  POWERDOWN_PORTSIZE_CONST_arriaii_hssi_pll  1		
`define  RATESWITCH_PORTSIZE_CONST_arriaii_hssi_pll  1		
`define  VCOBYPASSOUT_PORTSIZE_CONST_arriaii_hssi_pll  1		

// *** End of Section 4 ***
`define ALPHA_TOLOWER_WORD_LENGTH 25
// *** Section 5 -- Port declarations ***

input  areset;
input  datain;
input  dpriodisable;
input  [`DPRIOIN_PORTSIZE_CONST_arriaii_hssi_pll - 1 : 0] dprioin;
input  earlyeios;
input  [`EXTRA10GIN_PORTSIZE_CONST_arriaii_hssi_pll - 1 : 0] extra10gin;
input  [`INCLK_PORTSIZE_CONST_arriaii_hssi_pll - 1 : 0] inclk;
input  locktorefclk;
input  pfdfbclk;
input  powerdown;
input  rateswitch;
output [`CLK_PORTSIZE_CONST_arriaii_hssi_pll - 1 : 0] clk;
output [`DATAOUT_PORTSIZE_CONST_arriaii_hssi_pll - 1 : 0] dataout;
output [`DPRIOOUT_PORTSIZE_CONST_arriaii_hssi_pll - 1 : 0] dprioout;
output freqlocked;
output locked;
output pfdfbclkout;
output pfdrefclkout;
output vcobypassout;

// *** End of Section 5 ***

// *** Section 6 -- Parameter declarations and default values ***

parameter lpm_type = "arriaii_hssi_pll";
parameter auto_settings = "true";
parameter bandwidth_type = "Auto";
parameter base_data_rate = "unused";
parameter channel_num =  0 ;
parameter charge_pump_current_bits =  0 ;
parameter charge_pump_mode_bits =  0 ;
parameter charge_pump_test_enable = "false";
parameter dprio_config_mode = "000000";
parameter effective_data_rate = "unused";
parameter enable_dynamic_divider = "false";
parameter fast_lock_control = "false";
parameter inclk0_input_period =  0 ;
parameter inclk1_input_period =  0 ;
parameter inclk2_input_period =  0 ;
parameter inclk3_input_period =  0 ;
parameter inclk4_input_period =  0 ;
parameter inclk5_input_period =  0 ;
parameter inclk6_input_period =  0 ;
parameter inclk7_input_period =  0 ;
parameter inclk8_input_period =  0 ;
parameter inclk9_input_period =  0 ;
parameter input_clock_frequency = "unused";
parameter logical_channel_address =  0 ;
parameter logical_tx_pll_number =  0 ;
parameter loop_filter_c_bits =  0 ;
parameter loop_filter_r_bits =  0 ;
parameter m =  0 ;
parameter n =  0 ;
parameter pd_charge_pump_current_bits =  0 ;
parameter pd_loop_filter_r_bits =  0 ;
parameter pfd_clk_select =  0 ;
parameter pfd_fb_select = "internal";
parameter pll_type = "Auto";
parameter protocol_hint = "basic";
parameter refclk_divide_by =  0 ;
parameter refclk_multiply_by =  0 ;
parameter sim_is_negative_ppm_drift = "false";
parameter sim_net_ppm_variation =  0 ;
parameter test_charge_pump_current_down = "false";
parameter test_charge_pump_current_up = "false";
parameter use_refclk_pin = "false";
parameter vco_data_rate =  0 ;
parameter vco_divide_by =  0 ;
parameter vco_multiply_by =  0 ;
parameter vco_post_scale =  0 ;
parameter vco_range = "low";
parameter vco_tuning_bits =  0 ;
parameter volt_reg_control_bits =  0 ;
parameter volt_reg_output_bits =  0 ;

// *** End of Section 6 ***

// SIMULATION_ONLY_PARAMETERS_BEGIN

parameter sim_clkout_phase_shift = 0;
parameter sim_clkout_latency = 0;
parameter PARAM_DELAY = 0;

// SIMULATION_ONLY_PARAMETERS_END

// *** Section 7 -- Port declarations with defaults, if any ***

// This section will always be empty for WYSIWYG atoms
// tri1 devclrn;		//sample

// *** End of Section 7 ***

// ---------------------------------------------------------------------------
//  Model Implementation Begin                                               -
// ---------------------------------------------------------------------------
tri1 dpriodisable;

// ---------------------------------------------------------------------------
//  New DPRIO Begin                                                          
// ---------------------------------------------------------------------------

// Table39: PMA Per Channel RX Control Register 4 for Channel 0
`define rcru_pdbwctrl_PLL_IDX_0 		0
`define rcru_pdbwctrl_PLL_IDX_1 		1
`define rcru_pfdbwctrl_PLL_IDX_0 		2
`define rcru_pfdbwctrl_PLL_IDX_1 		3
`define rcru_crplctrl_PLL_IDX_0 		4
`define rcru_crplctrl_PLL_IDX_1 		5
`define rcru_ctl0_PLL_IDX_0 		6
`define rcru_l_PLL_IDX_0 		7
`define rcru_l_PLL_IDX_1 		8
`define rcru_m_PLL_IDX_0 		9
`define rcru_m_PLL_IDX_1 		10
`define rcru_m_PLL_IDX_2 		11
`define rcru_m_PLL_IDX_3 		12
`define rcru_m_sel_PLL_IDX_0 		13
`define rcru_m_sel_PLL_IDX_1 		14
`define rcru_div2_PLL_IDX_0 		15

// Table40: PMA Per Channel RX Control Register 5 for Channel 0
`define reserved_0_TB40_PLL_IDX_0 		16
`define reserved_0_TB40_PLL_IDX_1 		17
`define rcru_iselpd_PLL_IDX_0 		18
`define rcru_iselpd_PLL_IDX_1 		19
`define rcru_iselpd_PLL_IDX_2 		20
`define rcru_isel_PLL_IDX_0 		21
`define rcru_isel_PLL_IDX_1 		22
`define rcru_isel_PLL_IDX_2 		23
`define rcru_testdnen_PLL_IDX_0 		24
`define rcru_testupen_PLL_IDX_0 		25
`define rcru_testen_PLL_IDX_0 		26
`define rcru_lst_PLL_IDX_0 		27
`define rcru_lst_PLL_IDX_1 		28
`define rcru_lst_PLL_IDX_2 		29
`define rcru_lst_PLL_IDX_3 		30
`define rcru_rlbk_PLL_IDX_0 		31

// Table41: PMA Per Channel RX Control Register 6 for Channel 0
`define rcru_rgla_isel_PLL_IDX_0 		32
`define rcru_rgla_isel_PLL_IDX_1 		33
`define rcru_rgla_isel_PLL_IDX_2 		34
`define rcru_pdof_test_PLL_IDX_0 		35
`define rcru_pdof_test_PLL_IDX_1 		36
`define rcru_pdof_test_PLL_IDX_2 		37
`define rcru_pdfl_PLL_IDX_0 		38
`define rcru_sd_sel_PLL_IDX_0 		39
`define reserved_0_TB41_PLL_IDX_0 		40
`define rcru_ignore_phslck_PLL_IDX_0 		41
`define rcru_cmu_mode_PLL_IDX_0 		42
`define rrx_cru_rst_PLL_IDX_0 		43
`define rrx_cru_pdb_PLL_IDX_0 		44
`define rltr_PLL_IDX_0 		45
`define rltd_PLL_IDX_0 		46
`define rcp_mode_PLL_IDX_0 		47

// Table42: PMA Per Channel RX Control Register 7 for Channel 0
`define rcru_pdof_270i_PLL_IDX_0 		48
`define rcru_pdof_270i_PLL_IDX_1 		49
`define rcru_pdof_270i_PLL_IDX_2 		50
`define rcru_pdof_270i_PLL_IDX_3 		51
`define rcru_pdof_180i_PLL_IDX_0 		52
`define rcru_pdof_180i_PLL_IDX_1 		53
`define rcru_pdof_180i_PLL_IDX_2 		54
`define rcru_pdof_180i_PLL_IDX_3 		55
`define rcru_pdof_90i_PLL_IDX_0 		56
`define rcru_pdof_90i_PLL_IDX_1 		57
`define rcru_pdof_90i_PLL_IDX_2 		58
`define rcru_pdof_90i_PLL_IDX_3 		59
`define rcru_pdof_0i_PLL_IDX_0 		60
`define rcru_pdof_0i_PLL_IDX_1 		61
`define rcru_pdof_0i_PLL_IDX_2 		62
`define rcru_pdof_0i_PLL_IDX_3 		63

// Manual: PLL (only rx_cdr_pll uses it: table 33 & 59) --------------
`define rdynamic_sw_PLL_IDX_0 		70

// SW logical index ----------------------------------------------------------
`define PFD_CLK_SEL_PLL_IDX_0    100
`define PFD_CLK_SEL_PLL_IDX_1    101
`define PFD_CLK_SEL_PLL_IDX_2    102
`define PFD_CLK_SEL_PLL_IDX_3    103

// ---------------------------------------------------------------------------
// DPRIO input CRAM  
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 4 for Channel 0
wire [1:0] dprioin_rcru_pdbwctrl;
wire [1:0] dprioin_rcru_pfdbwctrl;
wire [1:0] dprioin_rcru_crplctrl;
wire dprioin_rcru_ctl0;
wire [1:0] dprioin_rcru_l;
wire [3:0] dprioin_rcru_m;
wire [1:0] dprioin_rcru_m_sel;
wire dprioin_rcru_div2;

// PMA Per Channel RX Control Register 5 for Channel 0
wire [1:0] dprioin_reserved_0_TB40;
wire [2:0] dprioin_rcru_iselpd;
wire [2:0] dprioin_rcru_isel;
wire dprioin_rcru_testdnen;
wire dprioin_rcru_testupen;
wire dprioin_rcru_testen;
wire [3:0] dprioin_rcru_lst;
wire dprioin_rcru_rlbk;

// PMA Per Channel RX Control Register 6 for Channel 0
wire [2:0] dprioin_rcru_rgla_isel;
wire [2:0] dprioin_rcru_pdof_test;
wire dprioin_rcru_pdfl;
wire dprioin_rcru_sd_sel;
wire dprioin_reserved_0_TB41;
wire dprioin_rcru_ignore_phslck;
wire dprioin_rcru_cmu_mode;
wire dprioin_rrx_cru_rst;
wire dprioin_rrx_cru_pdb;
wire dprioin_rltr;
wire dprioin_rltd;
wire dprioin_rcp_mode;

// PMA Per Channel RX Control Register 7 for Channel 0
wire [3:0] dprioin_rcru_pdof_270i;
wire [3:0] dprioin_rcru_pdof_180i;
wire [3:0] dprioin_rcru_pdof_90i;
wire [3:0] dprioin_rcru_pdof_0i;

// Manual section 
wire [3:0] dprioin_pfd_clk_sel;
wire [7:0] dprioin_vco_post_scale;
wire [1:0] dprioin_pfd_fb_select;
wire [7:0] m_dprioin_modulus;
wire [7:0] n_dprioin_modulus;

wire       dprioin_rdynamic_sw;

// ---------------------------------------------------------------------------
// Initial CRAM  
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 4 for Channel 0
reg [1:0] init_rcru_pdbwctrl;
reg [1:0] init_rcru_pfdbwctrl;
reg [1:0] init_rcru_crplctrl;
reg init_rcru_ctl0;
reg [1:0] init_rcru_l;
reg [3:0] init_rcru_m;
reg [1:0] init_rcru_m_sel;
reg init_rcru_div2;

// PMA Per Channel RX Control Register 5 for Channel 0
reg [1:0] init_reserved_0_TB40;
reg [2:0] init_rcru_iselpd;
reg [2:0] init_rcru_isel;
reg init_rcru_testdnen;
reg init_rcru_testupen;
reg init_rcru_testen;
reg [3:0] init_rcru_lst;
reg init_rcru_rlbk;

// PMA Per Channel RX Control Register 6 for Channel 0
reg [2:0] init_rcru_rgla_isel;
reg [2:0] init_rcru_pdof_test;
reg init_rcru_pdfl;
reg init_rcru_sd_sel;
reg init_reserved_0_TB41;
reg init_rcru_ignore_phslck;
reg init_rcru_cmu_mode;
reg init_rrx_cru_rst;
reg init_rrx_cru_pdb;
reg init_rltr;
reg init_rltd;
reg init_rcp_mode;

// PMA Per Channel RX Control Register 7 for Channel 0
reg [3:0] init_rcru_pdof_270i;
reg [3:0] init_rcru_pdof_180i;
reg [3:0] init_rcru_pdof_90i;
reg [3:0] init_rcru_pdof_0i;

// Manual section 
reg [3:0]  init_pfd_clk_sel;
reg [1:0]  init_vco_post_scale;
reg [1:0]  init_pfd_fb_select;

// ---------------------------------------------------------------------------
// CRAM  
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 4 for Channel 0
wire [1:0] cram_rcru_pdbwctrl;
wire [1:0] cram_rcru_pfdbwctrl;
wire [1:0] cram_rcru_crplctrl;
wire cram_rcru_ctl0;
wire [1:0] cram_rcru_l;
wire [3:0] cram_rcru_m;
wire [1:0] cram_rcru_m_sel;
wire cram_rcru_div2;

// PMA Per Channel RX Control Register 5 for Channel 0
wire [1:0] cram_reserved_0_TB40;
wire [2:0] cram_rcru_iselpd;
wire [2:0] cram_rcru_isel;
wire cram_rcru_testdnen;
wire cram_rcru_testupen;
wire cram_rcru_testen;
wire [3:0] cram_rcru_lst;
wire cram_rcru_rlbk;

// PMA Per Channel RX Control Register 6 for Channel 0
wire [2:0] cram_rcru_rgla_isel;
wire [2:0] cram_rcru_pdof_test;
wire cram_rcru_pdfl;
wire cram_rcru_sd_sel;
wire cram_reserved_0_TB41;
wire cram_rcru_ignore_phslck;
wire cram_rcru_cmu_mode;
wire cram_rrx_cru_rst;
wire cram_rrx_cru_pdb;
wire cram_rltr;
wire cram_rltd;
wire cram_rcp_mode;

// PMA Per Channel RX Control Register 7 for Channel 0
wire [3:0] cram_rcru_pdof_270i;
wire [3:0] cram_rcru_pdof_180i;
wire [3:0] cram_rcru_pdof_90i;
wire [3:0] cram_rcru_pdof_0i;

// Manual section
wire [3:0] cram_pfd_clk_sel;
wire [1:0] cram_vco_post_scale;
wire [1:0] cram_pfd_fb_select;

wire       cram_rdynamic_sw;

// end of DPRIO declaration ---------------------------------

reg pll_type_is_cdr_or_cmu;
reg use_pcie_clk;
reg pll_type_is_rx_cdr;

initial
begin
    pll_type_is_cdr_or_cmu = (alpha_tolower(pll_type) == "rx cdr" || alpha_tolower(pll_type) == "high speed rx cdr" || alpha_tolower(pll_type) == "cmu" || alpha_tolower(pll_type) == "high speed cmu");
    pll_type_is_rx_cdr     = (alpha_tolower(pll_type) == "rx cdr");
    use_pcie_clk =(alpha_tolower(pll_type) == "rx cdr") && (alpha_tolower(protocol_hint) == "pcie2" || enable_dynamic_divider == "true");
end

// ---------------------------------------------------------------------------
// Set DPRIO CRAM input from dprioin  
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 4 for Channel 0
assign dprioin_rcru_pdbwctrl	= dprioin[`rcru_pdbwctrl_PLL_IDX_1 : `rcru_pdbwctrl_PLL_IDX_0];
assign dprioin_rcru_pfdbwctrl	= dprioin[`rcru_pfdbwctrl_PLL_IDX_1 : `rcru_pfdbwctrl_PLL_IDX_0];
assign dprioin_rcru_crplctrl	= dprioin[`rcru_crplctrl_PLL_IDX_1 : `rcru_crplctrl_PLL_IDX_0];
assign dprioin_rcru_ctl0	= dprioin[`rcru_ctl0_PLL_IDX_0];
assign dprioin_rcru_l	= dprioin[`rcru_l_PLL_IDX_1 : `rcru_l_PLL_IDX_0];
assign dprioin_rcru_m	= dprioin[`rcru_m_PLL_IDX_3 : `rcru_m_PLL_IDX_0];
assign dprioin_rcru_m_sel	= dprioin[`rcru_m_sel_PLL_IDX_1 : `rcru_m_sel_PLL_IDX_0];
assign dprioin_rcru_div2	= dprioin[`rcru_div2_PLL_IDX_0];

// PMA Per Channel RX Control Register 5 for Channel 0
assign dprioin_reserved_0_TB40	= dprioin[`reserved_0_TB40_PLL_IDX_1 : `reserved_0_TB40_PLL_IDX_0];
assign dprioin_rcru_iselpd	= dprioin[`rcru_iselpd_PLL_IDX_2 : `rcru_iselpd_PLL_IDX_0];
assign dprioin_rcru_isel	= dprioin[`rcru_isel_PLL_IDX_2 : `rcru_isel_PLL_IDX_0];
assign dprioin_rcru_testdnen	= dprioin[`rcru_testdnen_PLL_IDX_0];
assign dprioin_rcru_testupen	= dprioin[`rcru_testupen_PLL_IDX_0];
assign dprioin_rcru_testen	= dprioin[`rcru_testen_PLL_IDX_0];
assign dprioin_rcru_lst	= dprioin[`rcru_lst_PLL_IDX_3 : `rcru_lst_PLL_IDX_0];
assign dprioin_rcru_rlbk	= dprioin[`rcru_rlbk_PLL_IDX_0];

// PMA Per Channel RX Control Register 6 for Channel 0
assign dprioin_rcru_rgla_isel	= dprioin[`rcru_rgla_isel_PLL_IDX_2 : `rcru_rgla_isel_PLL_IDX_0];
assign dprioin_rcru_pdof_test	= dprioin[`rcru_pdof_test_PLL_IDX_2 : `rcru_pdof_test_PLL_IDX_0];
assign dprioin_rcru_pdfl	= dprioin[`rcru_pdfl_PLL_IDX_0];
assign dprioin_rcru_sd_sel	= dprioin[`rcru_sd_sel_PLL_IDX_0];
assign dprioin_reserved_0_TB41	= dprioin[`reserved_0_TB41_PLL_IDX_0];
assign dprioin_rcru_ignore_phslck	= dprioin[`rcru_ignore_phslck_PLL_IDX_0];
assign dprioin_rcru_cmu_mode	= dprioin[`rcru_cmu_mode_PLL_IDX_0];
assign dprioin_rrx_cru_rst	= dprioin[`rrx_cru_rst_PLL_IDX_0];
assign dprioin_rrx_cru_pdb	= dprioin[`rrx_cru_pdb_PLL_IDX_0];
assign dprioin_rltr	= dprioin[`rltr_PLL_IDX_0];
assign dprioin_rltd	= dprioin[`rltd_PLL_IDX_0];
assign dprioin_rcp_mode	= dprioin[`rcp_mode_PLL_IDX_0];

// PMA Per Channel RX Control Register 7 for Channel 0
assign dprioin_rcru_pdof_270i	= dprioin[`rcru_pdof_270i_PLL_IDX_3 : `rcru_pdof_270i_PLL_IDX_0];
assign dprioin_rcru_pdof_180i	= dprioin[`rcru_pdof_180i_PLL_IDX_3 : `rcru_pdof_180i_PLL_IDX_0];
assign dprioin_rcru_pdof_90i	= dprioin[`rcru_pdof_90i_PLL_IDX_3 : `rcru_pdof_90i_PLL_IDX_0];
assign dprioin_rcru_pdof_0i	= dprioin[`rcru_pdof_0i_PLL_IDX_3 : `rcru_pdof_0i_PLL_IDX_0];

// Manual section
assign dprioin_pfd_clk_sel = dprioin[`PFD_CLK_SEL_PLL_IDX_3 : `PFD_CLK_SEL_PLL_IDX_0];
assign dprioin_rdynamic_sw = dprioin[`rdynamic_sw_PLL_IDX_0];

// ---------------------------------------------------------------------------
// Set DPRIO output from initial CRAM
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 4 for Channel 0
assign dprioout[`rcru_pdbwctrl_PLL_IDX_1 : `rcru_pdbwctrl_PLL_IDX_0] = init_rcru_pdbwctrl;
assign dprioout[`rcru_pfdbwctrl_PLL_IDX_1 : `rcru_pfdbwctrl_PLL_IDX_0] = init_rcru_pfdbwctrl;
assign dprioout[`rcru_crplctrl_PLL_IDX_1 : `rcru_crplctrl_PLL_IDX_0] = init_rcru_crplctrl;
assign dprioout[`rcru_ctl0_PLL_IDX_0] = init_rcru_ctl0;
assign dprioout[`rcru_l_PLL_IDX_1 : `rcru_l_PLL_IDX_0] = init_rcru_l;
assign dprioout[`rcru_m_PLL_IDX_3 : `rcru_m_PLL_IDX_0] = init_rcru_m;
assign dprioout[`rcru_m_sel_PLL_IDX_1 : `rcru_m_sel_PLL_IDX_0] = init_rcru_m_sel;
assign dprioout[`rcru_div2_PLL_IDX_0] = init_rcru_div2;

// PMA Per Channel RX Control Register 5 for Channel 0
assign dprioout[`reserved_0_TB40_PLL_IDX_1 : `reserved_0_TB40_PLL_IDX_0] = init_reserved_0_TB40;
assign dprioout[`rcru_iselpd_PLL_IDX_2 : `rcru_iselpd_PLL_IDX_0] = init_rcru_iselpd;
assign dprioout[`rcru_isel_PLL_IDX_2 : `rcru_isel_PLL_IDX_0] = init_rcru_isel;
assign dprioout[`rcru_testdnen_PLL_IDX_0] = init_rcru_testdnen;
assign dprioout[`rcru_testupen_PLL_IDX_0] = init_rcru_testupen;
assign dprioout[`rcru_testen_PLL_IDX_0] = init_rcru_testen;
assign dprioout[`rcru_lst_PLL_IDX_3 : `rcru_lst_PLL_IDX_0] = init_rcru_lst;
assign dprioout[`rcru_rlbk_PLL_IDX_0] = init_rcru_rlbk;

// PMA Per Channel RX Control Register 6 for Channel 0
assign dprioout[`rcru_rgla_isel_PLL_IDX_2 : `rcru_rgla_isel_PLL_IDX_0] = init_rcru_rgla_isel;
assign dprioout[`rcru_pdof_test_PLL_IDX_2 : `rcru_pdof_test_PLL_IDX_0] = init_rcru_pdof_test;
assign dprioout[`rcru_pdfl_PLL_IDX_0] = init_rcru_pdfl;
assign dprioout[`rcru_sd_sel_PLL_IDX_0] = init_rcru_sd_sel;
assign dprioout[`reserved_0_TB41_PLL_IDX_0] = init_reserved_0_TB41;
assign dprioout[`rcru_ignore_phslck_PLL_IDX_0] = init_rcru_ignore_phslck;
assign dprioout[`rcru_cmu_mode_PLL_IDX_0] = init_rcru_cmu_mode;
assign dprioout[`rrx_cru_rst_PLL_IDX_0] = init_rrx_cru_rst;
assign dprioout[`rrx_cru_pdb_PLL_IDX_0] = init_rrx_cru_pdb;
assign dprioout[`rltr_PLL_IDX_0] = init_rltr;
assign dprioout[`rltd_PLL_IDX_0] = init_rltd;
assign dprioout[`rcp_mode_PLL_IDX_0] = init_rcp_mode;

// PMA Per Channel RX Control Register 7 for Channel 0
assign dprioout[`rcru_pdof_270i_PLL_IDX_3 : `rcru_pdof_270i_PLL_IDX_0] = init_rcru_pdof_270i;
assign dprioout[`rcru_pdof_180i_PLL_IDX_3 : `rcru_pdof_180i_PLL_IDX_0] = init_rcru_pdof_180i;
assign dprioout[`rcru_pdof_90i_PLL_IDX_3 : `rcru_pdof_90i_PLL_IDX_0] = init_rcru_pdof_90i;
assign dprioout[`rcru_pdof_0i_PLL_IDX_3 : `rcru_pdof_0i_PLL_IDX_0] = init_rcru_pdof_0i;

// Manual section
assign dprioout[`PFD_CLK_SEL_PLL_IDX_3 : `PFD_CLK_SEL_PLL_IDX_0] = init_pfd_clk_sel;

// ---------------------------------------------------------------------------
// Set DPRIO CRAM
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 4 for Channel 0
assign cram_rcru_pdbwctrl = (dpriodisable !== 1'b0) ? init_rcru_pdbwctrl : dprioin_rcru_pdbwctrl;
assign cram_rcru_pfdbwctrl = (dpriodisable !== 1'b0) ? init_rcru_pfdbwctrl : dprioin_rcru_pfdbwctrl;
assign cram_rcru_crplctrl = (dpriodisable !== 1'b0) ? init_rcru_crplctrl : dprioin_rcru_crplctrl;
assign cram_rcru_ctl0 = (dpriodisable !== 1'b0) ? init_rcru_ctl0 : dprioin_rcru_ctl0;
assign cram_rcru_l = (dpriodisable !== 1'b0) ? init_rcru_l : dprioin_rcru_l;
assign cram_rcru_m = (dpriodisable === 1'b0 && (pll_type_is_cdr_or_cmu)) ?  dprioin_rcru_m : init_rcru_m;
assign cram_rcru_m_sel = (dpriodisable === 1'b0 && (pll_type_is_cdr_or_cmu)) ?  dprioin_rcru_m_sel : init_rcru_m_sel;
assign cram_rcru_div2 = (dpriodisable !== 1'b0) ? init_rcru_div2 : dprioin_rcru_div2;

// PMA Per Channel RX Control Register 5 for Channel 0
assign cram_reserved_0_TB40 = (dpriodisable !== 1'b0) ? init_reserved_0_TB40 : dprioin_reserved_0_TB40;
assign cram_rcru_iselpd = (dpriodisable !== 1'b0) ? init_rcru_iselpd : dprioin_rcru_iselpd;
assign cram_rcru_isel = (dpriodisable !== 1'b0) ? init_rcru_isel : dprioin_rcru_isel;
assign cram_rcru_testdnen = (dpriodisable !== 1'b0) ? init_rcru_testdnen : dprioin_rcru_testdnen;
assign cram_rcru_testupen = (dpriodisable !== 1'b0) ? init_rcru_testupen : dprioin_rcru_testupen;
assign cram_rcru_testen = (dpriodisable !== 1'b0) ? init_rcru_testen : dprioin_rcru_testen;
assign cram_rcru_lst = (dpriodisable !== 1'b0) ? init_rcru_lst : dprioin_rcru_lst;
assign cram_rcru_rlbk = (dpriodisable !== 1'b0) ? init_rcru_rlbk : dprioin_rcru_rlbk;

// PMA Per Channel RX Control Register 6 for Channel 0
assign cram_rcru_rgla_isel = (dpriodisable !== 1'b0) ? init_rcru_rgla_isel : dprioin_rcru_rgla_isel;
assign cram_rcru_pdof_test = (dpriodisable !== 1'b0) ? init_rcru_pdof_test : dprioin_rcru_pdof_test;
assign cram_rcru_pdfl = (dpriodisable !== 1'b0) ? init_rcru_pdfl : dprioin_rcru_pdfl;
assign cram_rcru_sd_sel = (dpriodisable !== 1'b0) ? init_rcru_sd_sel : dprioin_rcru_sd_sel;
assign cram_reserved_0_TB41 = (dpriodisable !== 1'b0) ? init_reserved_0_TB41 : dprioin_reserved_0_TB41;
assign cram_rcru_ignore_phslck = (dpriodisable !== 1'b0) ? init_rcru_ignore_phslck : dprioin_rcru_ignore_phslck;
assign cram_rcru_cmu_mode = (dpriodisable !== 1'b0) ? init_rcru_cmu_mode : dprioin_rcru_cmu_mode;
assign cram_rrx_cru_rst = (dpriodisable !== 1'b0) ? init_rrx_cru_rst : dprioin_rrx_cru_rst;
assign cram_rrx_cru_pdb = (dpriodisable !== 1'b0) ? init_rrx_cru_pdb : dprioin_rrx_cru_pdb;
assign cram_rltr = (dpriodisable !== 1'b0) ? init_rltr : dprioin_rltr;
assign cram_rltd = (dpriodisable !== 1'b0) ? init_rltd : dprioin_rltd;
assign cram_rcp_mode = (dpriodisable !== 1'b0) ? init_rcp_mode : dprioin_rcp_mode;

// PMA Per Channel RX Control Register 7 for Channel 0
assign cram_rcru_pdof_270i = (dpriodisable !== 1'b0) ? init_rcru_pdof_270i : dprioin_rcru_pdof_270i;
assign cram_rcru_pdof_180i = (dpriodisable !== 1'b0) ? init_rcru_pdof_180i : dprioin_rcru_pdof_180i;
assign cram_rcru_pdof_90i = (dpriodisable !== 1'b0) ? init_rcru_pdof_90i : dprioin_rcru_pdof_90i;
assign cram_rcru_pdof_0i = (dpriodisable !== 1'b0) ? init_rcru_pdof_0i : dprioin_rcru_pdof_0i;

// manual section
assign cram_pfd_clk_sel = (dpriodisable === 1'b0 && (pll_type_is_cdr_or_cmu)) ? dprioin_pfd_clk_sel : init_pfd_clk_sel;
assign cram_vco_post_scale = init_vco_post_scale;

                                                                    // to prevent centrl_clk_div.rdymaic_sw propagated into tx_pll
assign cram_rdynamic_sw = (dpriodisable !== 1'b0) ? use_pcie_clk  : (pll_type_is_rx_cdr & dprioin_rdynamic_sw);

// convert from Paramters into initial CRAMs from parameter ------------------
initial begin
	// RX PMA control register 7
	init_rcru_pdof_270i	= 4'b0000;
	init_rcru_pdof_180i	= 4'b0000;
	init_rcru_pdof_90i	= 4'b0000;
	init_rcru_pdof_0i	= 4'b0000;
	
	init_rcru_m = (m == 1 ? 4'b0000 : m == 2 ? 4'b0001 : m == 4 ? 4'b0010 : m == 5 ? 4'b0011 : m == 8 ? 4'b0100 : m == 10 ? 4'b0101 : m == 16 ? 4'b0110 : m == 20 ? 4'b0111 : m == 25 ? 4'b1000 : m == 32 ? 4'b1001 : m == 40 ? 4'b1010 : m == 50 ? 4'b1011 : 4'bx); //init_rcru_m  = m_init
    init_rcru_m_sel = (n == 1 ? 2'b00 : n == 2 ? 2'b01 : n == 4 ? 2'b10 : n == 8 ? 2'b11 : 2'b00); //init_rcru_m_sel  = n_init
    init_pfd_clk_sel = (pfd_clk_select >= 0) && (pfd_clk_select <= 9) ? pfd_clk_select : 4'b0000;  //init_pfd_clk_sel = pfd_clk_sel_init

    init_vco_post_scale = (vco_post_scale == 0 ? 1 : vco_post_scale);
    init_pfd_fb_select  = (alpha_tolower(pfd_fb_select) == "pldclk" ? 2'b10 : alpha_tolower(pfd_fb_select) == "iqtxrxclk" ? 2'b11 : 2'b00);
end

// ---------------------------------------------------------------------------
//  New DPRIO End                                                          
// ---------------------------------------------------------------------------

// Read in Dynamic CRAMs -----------------------------------------------------
assign m_dprioin_modulus = (cram_rcru_m === 4'b0000) ? 8'b00000001 :
                           (cram_rcru_m === 4'b0001) ? 8'b00000010 :
                           (cram_rcru_m === 4'b0010) ? 8'b00000100 :
                           (cram_rcru_m === 4'b0011) ? 8'b00000101 :
                           (cram_rcru_m === 4'b0100) ? 8'b00001000 :
                           (cram_rcru_m === 4'b0101) ? 8'b00001010 :
                           (cram_rcru_m === 4'b0110) ? 8'b00010000 :
                           (cram_rcru_m === 4'b0111) ? 8'b00010100 :
                           (cram_rcru_m === 4'b1000) ? 8'b00011001 :
                           (cram_rcru_m === 4'b1001) ? 8'b00100000 :
                           (cram_rcru_m === 4'b1010) ? 8'b00101000 :
                           (cram_rcru_m === 4'b1011) ? 8'b00110010 : 8'b00000001;

assign n_dprioin_modulus  = (cram_rcru_m_sel === 2'b00) ? 8'b00000001 :
                            (cram_rcru_m_sel === 2'b01) ? 8'b00000010 :
                            (cram_rcru_m_sel === 2'b10) ? 8'b00000100 : 8'b00000001;

// ---------------------------------------------------------------------------
//  Model / Submodule Instantiations                                         -
// ---------------------------------------------------------------------------

`define S4_HSSI_PLL_INITIAL 2'b01
`define S4_HSSI_PLL_ACTIVE  2'b11
`define S4_HSSI_PLL_INACTIVE  2'b00

wire areset_ipd;
wire ck0_pd;
wire ck90_pd;
wire ck180_pd;
wire ck270_pd;

wire datain_ipd;
wire dpriodisable_ipd;
wire [299:0] dprioin_ipd;
wire [9:0] inclk_ipd;
wire locktorefclk_ipd;
wire pfdfbclk_ipd;
wire powerdown_ipd;
wire rateswitch_ipd;

// DPRIO
wire dprioenable;
reg  dprioen_reg;
wire [7:0] cru_l_chn;

assign areset_ipd = (areset === 1'b1) ? 1'b1 : 1'b0;
assign datain_ipd = (datain === 1'b1) ? 1'b1 : 1'b0;
assign dpriodisable_ipd = (dpriodisable === 1'b0) ? 1'b0 : 1'b1; // making 1b1 default value when port has x or z value.
assign locktorefclk_ipd = (locktorefclk === 1'b1) ? 1'b1 : 1'b0;
assign powerdown_ipd = (powerdown === 1'b1) ? 1'b1 : 1'b0;
assign pfdfbclk_ipd = (pfdfbclk === 1'b1) ? 1'b1 : 1'b0;
assign rateswitch_ipd = (rateswitch === 1'b1) ? 1'b1 : 1'b0;
assign dprioin_ipd = dprioin;
assign inclk_ipd = inclk;

specify
    (inclk *> clk) = (0,0);
endspecify

// intermediate wires
wire  [1:0] busy;  // VCO state
wire  charge_pump_delayed;
wire  check_phase;
wire  clk_div;
wire  clk_div_delayed;
wire  [3:0] clk_post_scale;
wire  [3:0] clk_vco;
wire  datain_dly;
wire  divide_by_M_clkout;
wire  fbclk;
wire  [3:0] pcie_clk;
wire  pcie_div2_clk0;
wire  pcie_div2_clk1;
wire  pfd_refclk;
wire  pll_clkin;
wire  pll_clkin_pre_latency;
wire  reset;

reg deven, devenb;
reg dodd, doddb;
reg deven_int1;
reg deven_int2;
reg dodd_int1;
reg dodd_int2;
reg d90_int1;
reg d90_int2;
reg d270_int1;
reg d270_int2;
reg pcie_div2_clk2;
reg pcie_div2_clk3;

wire pdb;

reg  charge_pump; // re-adjust VCO frequency
reg  adjust_without_lol;

real  last_fb_clk_edge;
real  expected_clk_period;
real  clk_tolerance;
real  real_clk_period;
real  last_pfd_refclk_edge;
real  last_pll_clkin_edge;
real  last_real_clk_period;

reg  first_pll_clkin_edge_detect;
reg  display_msgs;
reg  freq_viol_msg_sem;
reg  locked_real;

wire         dprio_reset; // reset through DPRIO CRAM in 7.1
wire [7:0] d_wire;

genvar j;


function real select_clock_period;
input clk_select;
integer clk_select;
real period;
begin
    case (clk_select)
        0 : period = inclk0_input_period;
        1 : period = inclk1_input_period;
        2 : period = inclk2_input_period;
        3 : period = inclk3_input_period;
        4 : period = inclk4_input_period;
        5 : period = inclk5_input_period;
        6 : period = inclk6_input_period;
        7 : period = inclk7_input_period;
        8 : period = inclk8_input_period;
        9 : period = inclk9_input_period;

        default : begin
        			$display("Invalid logical clock select");
        			$display("Time: %0t  Instance: %m", $time);
        		  end
    endcase
    select_clock_period = period;
end
endfunction

    // get the absolute value
    function integer abs;
    input value;
    integer value;
    begin
        if (value < 0)
            abs = value * -1;
        else abs = value;
    end
    endfunction

// alpha_tolower function
function [8*`ALPHA_TOLOWER_WORD_LENGTH:1] alpha_tolower;
input [8*`ALPHA_TOLOWER_WORD_LENGTH:1] input_string;

reg [8*`ALPHA_TOLOWER_WORD_LENGTH:1] return_string;
reg [8*`ALPHA_TOLOWER_WORD_LENGTH:1] reg_string;
reg [8:1] tmp;
reg [8:1] conv_char;
integer byte_count;
begin
reg_string = input_string;
for (byte_count = `ALPHA_TOLOWER_WORD_LENGTH; byte_count >= 1; byte_count = byte_count - 1)
begin
    tmp = reg_string[8*`ALPHA_TOLOWER_WORD_LENGTH:(8*(`ALPHA_TOLOWER_WORD_LENGTH-1)+1)];
    reg_string = reg_string << 8;
    if ((tmp >= 65) && (tmp <= 90)) // ASCII number of 'A' is 65, 'Z' is 90
    begin
	conv_char = tmp + 32; // 32 is the difference in the position of 'A' and 'a' in the ASCII char set
	return_string = {return_string, conv_char};
    end
    else
	return_string = {return_string, tmp};
end

alpha_tolower = return_string;
end
endfunction 
    
initial
begin
    charge_pump = 1'b1;
    first_pll_clkin_edge_detect = 1'b0;
    expected_clk_period = (select_clock_period(pfd_clk_select));
    clk_tolerance = 0.1 * expected_clk_period; // same as Stratix
    display_msgs = 1'b1;
    freq_viol_msg_sem = 1'b1;
    locked_real = 1'b0;
    adjust_without_lol = 1'b0;
end

assign pll_clkin_pre_latency = (cram_pfd_clk_sel == 0) ? inclk_ipd[0] : 
                               (cram_pfd_clk_sel == 1) ? inclk_ipd[1] :
                               (cram_pfd_clk_sel == 2) ? inclk_ipd[2] :
                               (cram_pfd_clk_sel == 3) ? inclk_ipd[3] :
                               (cram_pfd_clk_sel == 4) ? inclk_ipd[4] :
                               (cram_pfd_clk_sel == 5) ? inclk_ipd[5] :
                               (cram_pfd_clk_sel == 6) ? inclk_ipd[6] :
                               (cram_pfd_clk_sel == 7) ? inclk_ipd[7] :
                               (cram_pfd_clk_sel == 8) ? inclk_ipd[8] :
                               (cram_pfd_clk_sel == 9) ? inclk_ipd[9] :
                               inclk_ipd[0];

assign reset = areset_ipd | powerdown_ipd | dprio_reset;

assign pdb = !powerdown_ipd;

// DPRIO
assign dprioenable = ~dpriodisable_ipd;
assign cru_l_chn = dprioin_ipd[15:8];
assign dprio_reset = ((dprioenable === 1'b1) &&
                     (dprioin_ipd[16] === 1'b1 || dprioin_ipd[17] === 1'b1)) ? 1'b1 : 1'b0;

// Clock latency
reg [sim_clkout_latency:0] clkin_pre_latency;

initial
begin
    clkin_pre_latency = 'b0;
end

always@(posedge pll_clkin_pre_latency or negedge pll_clkin_pre_latency or posedge reset)
begin
    if (reset)
    begin
        clkin_pre_latency = 'b0;
    end
    else
    begin
        clkin_pre_latency <= {clkin_pre_latency, clkin_pre_latency[0]};
        clkin_pre_latency[0] <= pll_clkin_pre_latency;
    end
end

assign pll_clkin = clkin_pre_latency[sim_clkout_latency];

// DPRIO : Register the dprioenable signal to avoid asynchronous reconfiguration
always @(posedge pll_clkin)
begin
    dprioen_reg <= dprioenable;
end

// N counter
arriaii_hssi_aux_clock_div n_cntr (.clk(pll_clkin),
                               .enable_d(dprioenable),
                               .d(n_dprioin_modulus),
                               .reset(reset),
                               .clkout(pfd_refclk)
                              );
defparam n_cntr.clk_divide_by = n;
defparam n_cntr.extra_latency = 0;

// Input frequency checks

always @(posedge pll_clkin or posedge reset)
begin
    if (reset)
    begin
        first_pll_clkin_edge_detect = 1'b0;
    end
    else
    begin
        if (first_pll_clkin_edge_detect == 1'b0)
            first_pll_clkin_edge_detect = 1'b1; 
        else 
        begin
            real_clk_period = $realtime - last_pll_clkin_edge;
            if ((real_clk_period < expected_clk_period - clk_tolerance) ||
                (real_clk_period > expected_clk_period + clk_tolerance))
            begin
                if (freq_viol_msg_sem == 1'b1)
                begin
                    $display("Warning : CMU PLL input frequency mismatch between parameter-specified period and real clock period");
                    $display("Time: %0t  Instance: %m", $time);
                    $display("Clock period specified in parameter is %0t but real clock period is %0t",expected_clk_period,real_clk_period);
                    freq_viol_msg_sem = 1'b0;
                end
            end
            if ((real_clk_period != last_real_clk_period) && (last_real_clk_period > 0)) 
            begin
                charge_pump = 1'b1;
                if (abs(real_clk_period - last_real_clk_period) <= 2)
                    adjust_without_lol = 1'b1;
            end
            last_real_clk_period = real_clk_period;
        end
        last_pll_clkin_edge = $realtime;
    end
end

// PFD

always @(posedge pfd_refclk)   last_pfd_refclk_edge = $realtime;
always @(posedge fbclk)   last_fb_clk_edge = $realtime;

always @(negedge pfd_refclk) 
begin
    if (($realtime > 0) && (busy != `S4_HSSI_PLL_ACTIVE) && (busy != `S4_HSSI_PLL_INITIAL))
    begin
//        charge_pump = (last_pfd_refclk_edge != last_fb_clk_edge);
        if (last_pfd_refclk_edge != last_fb_clk_edge)
        begin
            charge_pump = 1'b1;
            if (locked == 1'b1)
                adjust_without_lol = 1'b1;
        end
        else charge_pump = 1'b0;
    end
end

always @(negedge reset)
begin
    charge_pump = 1'b1;
    adjust_without_lol = 1'b0;
    display_msgs = 1'b1;
end

always @(posedge reset)
begin
    if (reset == 1'b1) 
    begin
        $display ("Note : CMU PLL is reset");
        $display ("Time: %0t  Instance: %m", $time);
    end
end
always @(charge_pump)
begin
    if (charge_pump == 1'b1 && adjust_without_lol == 1'b0) 
    begin
        if (display_msgs == 1'b0)
        begin
            $display ("Note : CMU PLL lost lock due to reset or change in frequency of input clock");
            $display ("Time: %0t  Instance: %m", $time);
            display_msgs = 1'b1;
        end
    end
    else
    begin
        if (display_msgs == 1'b1)
        begin
            $display ("Note : CMU PLL locked to incoming clock");
            $display ("Time: %0t  Instance: %m", $time);
            display_msgs = 1'b0;
        end
    end
end

always @(busy)
begin
    if (busy == `S4_HSSI_PLL_INACTIVE)
    begin
        charge_pump = 1'b0;
        adjust_without_lol = 1'b0;
    end
end

// VCO
arriaii_hssi_aux_clock_mult vco (
    .clk(pfd_refclk),
    .fbclk(fbclk),
    .adjust(charge_pump),
    .adjust_without_lol(adjust_without_lol),
    .reset(reset),
    .enable_m(dprioenable),
    .m(m_dprioin_modulus),
    .clkout(clk_vco), // VCO output
    .busy(busy)
);
defparam vco.clk_multiply_by = m;
defparam vco.pfd_fb_select = pfd_fb_select; 

reg [3:0] clk_post_scale_tmp;

initial
begin
    clk_post_scale_tmp = 'b0;
end

generate
    for (j = 0; j < 4; j = j + 1) begin : post_scale
        always@(posedge clk_vco[j] or negedge clk_vco[j] or posedge reset)
        begin
            if (reset)
            begin
                clk_post_scale_tmp[j] = 1'b0;
            end
            else
            begin
                clk_post_scale_tmp[j] = clk_vco[j];
            end
        end
    end
endgenerate

assign clk_post_scale = clk_post_scale_tmp;

// Feedback

arriaii_hssi_aux_clock_div divide_by_M (
    .clk(clk_post_scale[0]),
    .reset(reset),
    .enable_d(dprioen_reg),
    .d(m_dprioin_modulus),
//    .clkout(fbclk)
    .clkout(divide_by_M_clkout)
);
defparam divide_by_M.clk_divide_by = m;
defparam divide_by_M.extra_latency = 0;

assign fbclk = (init_pfd_fb_select == 2'b00) ? divide_by_M_clkout : pfdfbclk_ipd;

// PCIE divide-by-2

arriaii_hssi_aux_clock_div pcie_sw_0 (.clk(clk_post_scale[0]),
                                .enable_d(1'b0),
                                .d(d_wire),
                                .reset(reset),
                                .clkout(pcie_div2_clk0)
                               );
defparam pcie_sw_0.clk_divide_by = 2;
defparam pcie_sw_0.extra_latency = 0;

always @(posedge reset or pcie_div2_clk0)
begin
    if (reset == 1'b1)
        pcie_div2_clk2 <= 1'b0;
    else
        pcie_div2_clk2 <= ~pcie_div2_clk0;
end

arriaii_hssi_aux_clock_div pcie_sw_1 (.clk(!clk_post_scale[0]),
                                .enable_d(1'b0),
                                .d(d_wire),
                                .reset(reset),
                                .clkout(pcie_div2_clk1)
                               );
defparam pcie_sw_1.clk_divide_by = 2;
defparam pcie_sw_1.extra_latency = 0;

always @(posedge reset or pcie_div2_clk1)
begin
    if (reset == 1'b1)
        pcie_div2_clk3 <= 1'b0;
    else
    pcie_div2_clk3 <= ~pcie_div2_clk1;
end

always @(busy or reset)
begin
    if (reset  ===  1'b1)
        locked_real <= 1'b0;
    else if (busy == `S4_HSSI_PLL_INACTIVE || adjust_without_lol == 1'b1) 
        locked_real <= 1'b1;
    else
        locked_real <= 1'b0;
end

assign pcie_clk[0] = (rateswitch_ipd === 1'b0) ? pcie_div2_clk0 : clk_post_scale[0]; 
assign pcie_clk[1] = (rateswitch_ipd === 1'b0) ? pcie_div2_clk1 : clk_post_scale[1]; 
assign pcie_clk[2] = (rateswitch_ipd === 1'b0) ? pcie_div2_clk2 : clk_post_scale[2]; 
assign pcie_clk[3] = (rateswitch_ipd === 1'b0) ? pcie_div2_clk3 : clk_post_scale[3]; 

initial begin
   deven_int2 <= 1'b0;
   dodd_int2  <= 1'b0;
end

assign ck0_pd = (cram_rdynamic_sw === 1'b1) ? pcie_clk[0] : clk_post_scale[0]; 
assign ck90_pd = (cram_rdynamic_sw === 1'b1) ? pcie_clk[1] : clk_post_scale[1]; 
assign ck180_pd = (cram_rdynamic_sw === 1'b1) ? pcie_clk[2] : clk_post_scale[2]; 
assign ck270_pd = (cram_rdynamic_sw === 1'b1) ? pcie_clk[3] : clk_post_scale[3]; 

assign #5 datain_dly = datain_ipd;

// PD : from ICD RTL c_cdr.v WW5

   always @ ( ck0_pd or negedge pdb )
     if ( pdb == 1'b0 )
       deven_int1 <= #(PARAM_DELAY) 1'b0;
     else begin
       if ( ( ck0_pd == 1'b1 ) )
         deven_int1 <= #(PARAM_DELAY) datain_dly;
       else if ( ck0_pd == 1'b0 )
         deven_int2 <= #(PARAM_DELAY) deven_int1;
     end

   always @ ( ck180_pd or negedge pdb )
     if ( pdb == 1'b0 )
       dodd_int1 <= #(PARAM_DELAY) 1'b0;
     else begin
       if ( ( ck180_pd == 1'b1 ) )
         dodd_int1 <= #(PARAM_DELAY) datain_dly;
       else if ( ck180_pd == 1'b0 )
         dodd_int2 <= #(PARAM_DELAY) dodd_int1;
     end

   always @ ( posedge ck90_pd or negedge pdb )
     if ( pdb == 1'b0 ) begin
       {deven ,dodd } <= #(PARAM_DELAY) 2'b00;
     end
     else begin
       {deven ,dodd } <= #(PARAM_DELAY)  {deven_int2,dodd_int2};
     end

assign clk[0] = ck0_pd && (locked || (init_pfd_fb_select == 2'b11));
assign clk[1] = ck90_pd && (locked || (init_pfd_fb_select == 2'b11));
assign clk[2] = ck180_pd && (locked || (init_pfd_fb_select == 2'b11));
assign clk[3] = ck270_pd && (locked || (init_pfd_fb_select == 2'b11));

assign dataout[0] = deven;
assign dataout[1] = dodd;

assign locked = locked_real;
assign pfdfbclkout = fbclk;
assign pfdrefclkout = pfd_refclk;
assign vcobypassout = pll_clkin;
assign freqlocked = ~locktorefclk_ipd;

endmodule

// ***********************************************************
// This WYSIWYG atom header was automatically generated by the
// Atmgen build tool. To change it, alter data stored in the 
// corresponding WYS file(s) in the tools/atmgen subdirectory.
// ***********************************************************

// *** Section 1 -- Header ***

// -----------------------------------------------------------
//
// Module Name : arriaii_hssi_tx_pma
//
// Description : DEV_FAMILY_ARRIAII arriaii_hssi_tx_pma Verilog simulation model
//
// -----------------------------------------------------------

`timescale 1 ps/1 ps

// *** End of Section 1 ***

// *** Section 3 -- Module declaration ***

module arriaii_hssi_tx_pma(
			datain,
			datainfull,
			detectrxpowerdown,
			dpriodisable,
			dprioin,
            extra10gin,
            fastrefclk0in,
			fastrefclk1in,
			fastrefclk2in,
			fastrefclk3in,
			fastrefclk4in,
            forceelecidle,
			pclk,
			powerdn,
			refclk0in,
			refclk0inpulse,
			refclk1in,
			refclk1inpulse,
			refclk2in,
			refclk2inpulse,
			refclk3in,
			refclk3inpulse,
			refclk4in,
			refclk4inpulse,
			revserialfdbk,
            rxdetectclk,
			rxdetecten,
            txpmareset,

            clockout,
			dataout,
            dftout,
			dprioout,
            rxdetectvalidout,
			rxfoundout,
			seriallpbkout 
		);

// *** End of Section 3 ***

// *** Section 4 -- Port size declarations ***

// Note: Variable port sizes dictated by parameters are not currently defined in
// the WYS file data. Busses are marked with the VARIABLE notation as a reminder.

`define  CLOCKOUT_PORTSIZE_CONST_arriaii_hssi_tx_pma  1
`define  DATAIN_PORTSIZE_CONST_arriaii_hssi_tx_pma  64		// * VARIABLE
`define  DATAINFULL_PORTSIZE_CONST_arriaii_hssi_tx_pma  20		// * VARIABLE
`define  DATAOUT_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  DETECTRXPOWERDOWN_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  DFTOUT_PORTSIZE_CONST_arriaii_hssi_tx_pma  6		// * VARIABLE
`define  DPRIODISABLE_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  DPRIOIN_PORTSIZE_CONST_arriaii_hssi_tx_pma  300		// * VARIABLE
`define  DPRIOOUT_PORTSIZE_CONST_arriaii_hssi_tx_pma  300           // * VARIABLE
`define  EXTRA10GIN_PORTSIZE_CONST_arriaii_hssi_tx_pma  11		// * VARIABLE
`define  FASTREFCLK0IN_PORTSIZE_CONST_arriaii_hssi_tx_pma  2		// * VARIABLE
`define  FASTREFCLK1IN_PORTSIZE_CONST_arriaii_hssi_tx_pma  2		// * VARIABLE
`define  FASTREFCLK2IN_PORTSIZE_CONST_arriaii_hssi_tx_pma  2		// * VARIABLE
`define  FASTREFCLK3IN_PORTSIZE_CONST_arriaii_hssi_tx_pma  2		// * VARIABLE
`define  FASTREFCLK4IN_PORTSIZE_CONST_arriaii_hssi_tx_pma  2
`define  FORCEELECIDLE_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  PCLK_PORTSIZE_CONST_arriaii_hssi_tx_pma  5		
`define  POWERDN_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  REFCLK0IN_PORTSIZE_CONST_arriaii_hssi_tx_pma  2		// * VARIABLE
`define  REFCLK0INPULSE_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  REFCLK1IN_PORTSIZE_CONST_arriaii_hssi_tx_pma  2		// * VARIABLE
`define  REFCLK1INPULSE_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  REFCLK2IN_PORTSIZE_CONST_arriaii_hssi_tx_pma  2		// * VARIABLE
`define  REFCLK2INPULSE_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  REFCLK3IN_PORTSIZE_CONST_arriaii_hssi_tx_pma  2		// * VARIABLE
`define  REFCLK3INPULSE_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  REFCLK4IN_PORTSIZE_CONST_arriaii_hssi_tx_pma  2		
`define  REFCLK4INPULSE_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  REVSERIALFDBK_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  RXDETECTCLK_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  RXDETECTEN_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  RXDETECTVALIDOUT_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  RXFOUNDOUT_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  SERIALLPBKOUT_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		
`define  TXPMARESET_PORTSIZE_CONST_arriaii_hssi_tx_pma  1		

// *** End of Section 4 ***

// *** Section 5 -- Port declarations ***

input  [`DATAIN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] datain;
input  [`DATAINFULL_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] datainfull;
input  detectrxpowerdown;
input  dpriodisable;
input  [`DPRIOIN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] dprioin;
input  [`EXTRA10GIN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] extra10gin;
input  [`FASTREFCLK0IN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] fastrefclk0in;
input  [`FASTREFCLK1IN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] fastrefclk1in;
input  [`FASTREFCLK2IN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] fastrefclk2in;
input  [`FASTREFCLK3IN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] fastrefclk3in;
input  [`FASTREFCLK4IN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] fastrefclk4in;
input  forceelecidle;
input  [`PCLK_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] pclk;
input  powerdn;
input  [`REFCLK0IN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] refclk0in;
input  refclk0inpulse;
input  [`REFCLK1IN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] refclk1in;
input  refclk1inpulse;
input  [`REFCLK2IN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] refclk2in;
input  refclk2inpulse;
input  [`REFCLK3IN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] refclk3in;
input  refclk3inpulse;
input  [`REFCLK4IN_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] refclk4in;
input  refclk4inpulse;
input  revserialfdbk;
input  rxdetectclk;
input  rxdetecten;
input  txpmareset;
output clockout;
output dataout;
output [`DFTOUT_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] dftout;
output [`DPRIOOUT_PORTSIZE_CONST_arriaii_hssi_tx_pma - 1 : 0] dprioout;
output rxdetectvalidout;
output rxfoundout;
output seriallpbkout;

// *** End of Section 5 ***

// *** Section 6 -- Parameter declarations and default values ***

parameter lpm_type = "arriaii_hssi_tx_pma";
parameter analog_power = "1.5V";
parameter channel_number =  0 ;
parameter channel_type = "auto";
parameter clkin_select =  0 ;
parameter clkmux_delay = "false";
parameter common_mode = "0.6v";
parameter dprio_config_mode = 6'h00;
parameter enable_reverse_serial_loopback = "false";
parameter logical_channel_address =  0 ;
parameter logical_protocol_hint_0 = "basic";
parameter logical_protocol_hint_1 = "basic";
parameter logical_protocol_hint_2 = "basic";
parameter logical_protocol_hint_3 = "basic";
parameter low_speed_test_select =  0 ;
parameter physical_clkin0_mapping = "x1";
parameter physical_clkin1_mapping = "x4";
parameter physical_clkin2_mapping = "xn_top";
parameter physical_clkin3_mapping = "xn_bottom";
parameter physical_clkin4_mapping = "hypertransport";
parameter preemp_pretap =  0 ;
parameter preemp_pretap_inv = "false";
parameter preemp_tap_1 =  0 ;
parameter preemp_tap_1_a =  0 ;
parameter preemp_tap_1_b =  0 ;
parameter preemp_tap_1_c =  0 ;
parameter preemp_tap_2 =  0 ;
parameter preemp_tap_2_inv = "false";
parameter protocol_hint = "basic";
parameter rx_detect =  0 ;
parameter serialization_factor =  8 ;
parameter slew_rate = "low";
parameter termination = "oct 100 ohms";
parameter use_external_termination = "false";
parameter use_pclk = "false";
parameter use_pma_direct = "false";
parameter use_rx_detect = "false";
parameter use_ser_double_data_mode = "false";
parameter vod_selection =  0 ;
parameter vod_selection_a =  0 ;
parameter vod_selection_b =  0 ;
parameter vod_selection_c =  0 ;
parameter vod_selection_d =  0 ;

// *** End of Section 6 ***

// *** Section 7 -- Port declarations with defaults, if any ***

// This section will always be empty for WYSIWYG atoms
// tri1 devclrn;		//sample

// *** End of Section 7 ***

// LOCAL_PARAMETERS_BEGIN

parameter DPRIO_CHANNEL_INTERFACE_BIT = 4;

// LOCAL_PARAMETERS_END
`define ARRIAII_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH 25

// ---------------------------------------------------------------------------
//  New DPRIO Begin 
// ---------------------------------------------------------------------------

// Table28: PMA Per Channel TX Control Register 1 for Channel 0
`define rpowdnt_TXPMA_IDX_0 		0
`define rvod_seld_TXPMA_IDX_0 		1
`define rvod_seld_TXPMA_IDX_1 		2
`define rvod_seld_TXPMA_IDX_2 		3
`define rvod_selc_TXPMA_IDX_0 		4
`define rvod_selc_TXPMA_IDX_1 		5
`define rvod_selc_TXPMA_IDX_2 		6
`define rvod_selb_TXPMA_IDX_0 		7
`define rvod_selb_TXPMA_IDX_1 		8
`define rvod_selb_TXPMA_IDX_2 		9
`define rvod_sela_TXPMA_IDX_0 		10
`define rvod_sela_TXPMA_IDX_1 		11
`define rvod_sela_TXPMA_IDX_2 		12
`define rvod_sel_non_pcie_TXPMA_IDX_0 		13
`define rvod_sel_non_pcie_TXPMA_IDX_1 		14
`define rvod_sel_non_pcie_TXPMA_IDX_2 		15

// Table29: PMA Per Channel TX Control Register 2 for Channel 0
`define reserved_0_TB29_TXPMA_IDX_0 		16
`define rpre_em_1t_b_TXPMA_IDX_0 		17
`define rpre_em_1t_b_TXPMA_IDX_1 		18
`define rpre_em_1t_b_TXPMA_IDX_2 		19
`define rpre_em_1t_b_TXPMA_IDX_3 		20
`define rpre_em_1t_b_TXPMA_IDX_4 		21
`define rpre_em_1t_a_TXPMA_IDX_0 		22
`define rpre_em_1t_a_TXPMA_IDX_1 		23
`define rpre_em_1t_a_TXPMA_IDX_2 		24
`define rpre_em_1t_a_TXPMA_IDX_3 		25
`define rpre_em_1t_a_TXPMA_IDX_4 		26
`define rpre_em_1t_no_pcie_TXPMA_IDX_0 		27
`define rpre_em_1t_no_pcie_TXPMA_IDX_1 		28
`define rpre_em_1t_no_pcie_TXPMA_IDX_2 		29
`define rpre_em_1t_no_pcie_TXPMA_IDX_3 		30
`define rpre_em_1t_no_pcie_TXPMA_IDX_4 		31

// Table30: PMA Per Channel TX Control Register 3 for Channel 0
`define rpre_em_pt_TXPMA_IDX_0 		32
`define rpre_em_pt_TXPMA_IDX_1 		33
`define rpre_em_pt_TXPMA_IDX_2 		34
`define rpre_em_pt_TXPMA_IDX_3 		35
`define rpre_em_2t_TXPMA_IDX_0 		36
`define rpre_em_2t_TXPMA_IDX_1 		37
`define rpre_em_2t_TXPMA_IDX_2 		38
`define rpre_em_2t_TXPMA_IDX_3 		39
`define rpre_em_1t_c_TXPMA_IDX_0 		40
`define rpre_em_1t_c_TXPMA_IDX_1 		41
`define rpre_em_1t_c_TXPMA_IDX_2 		42
`define rpre_em_1t_c_TXPMA_IDX_3 		43
`define rpre_em_1t_c_TXPMA_IDX_4 		44
`define reserved_0_TB30_TXPMA_IDX_0 		45
`define reserved_0_TB30_TXPMA_IDX_1 		46
`define reserved_0_TB30_TXPMA_IDX_2 		47

// Table31: PMA Per Channel TX Control Register 4 for Channel 0
`define rlowv_TXPMA_IDX_0 		48
`define rrx_det_TXPMA_IDX_0 		49
`define rrx_det_TXPMA_IDX_1 		50
`define rsig_inv_2t_TXPMA_IDX_0 		51
`define rsig_inv_ptap_TXPMA_IDX_0 		52
`define rslew_TXPMA_IDX_0 		53
`define rslew_TXPMA_IDX_1 		54
`define rtx_lst_TXPMA_IDX_0 		55
`define rtx_lst_TXPMA_IDX_1 		56
`define rtx_lst_TXPMA_IDX_2 		57
`define rtx_lst_TXPMA_IDX_3 		58
`define rtx_vtt_TXPMA_IDX_0 		59
`define rtx_vtt_TXPMA_IDX_1 		60
`define rtx_term_sel_TXPMA_IDX_0 		61
`define rtx_term_sel_TXPMA_IDX_1 		62
`define rtx_term_sel_TXPMA_IDX_2 		63

// Table32: PMA Per Channel TX Control Register 5 for Channel 0
`define reserved_1_TB32_TXPMA_IDX_0 		64
`define reserved_1_TB32_TXPMA_IDX_1 		65
`define reserved_1_TB32_TXPMA_IDX_2 		66
`define reserved_1_TB32_TXPMA_IDX_3 		67
`define reserved_1_TB32_TXPMA_IDX_4 		68
`define reserved_1_TB32_TXPMA_IDX_5 		69
`define reserved_1_TB32_TXPMA_IDX_6 		70
`define reserved_1_TB32_TXPMA_IDX_7 		71
`define reserved_1_TB32_TXPMA_IDX_8 		72
`define reserved_1_TB32_TXPMA_IDX_9 		73
`define reserved_1_TB32_TXPMA_IDX_10 		74
`define rtx_ob_pdb_TXPMA_IDX_0 		75
`define reserved_0_TB32_TXPMA_IDX_0 		76
`define r_dft_sel_TXPMA_IDX_0 		77
`define r_dft_sel_TXPMA_IDX_1 		78
`define r_dft_sel_TXPMA_IDX_2 		79

// Table33: PMA Per Channel TX Control Register 6 for Channel 0
`define reserved_0_TB33_TXPMA_IDX_0 		80
`define reserved_0_TB33_TXPMA_IDX_1 		81
`define reserved_0_TB33_TXPMA_IDX_2 		82
`define reserved_0_TB33_TXPMA_IDX_3 		83
`define rtx_cgb_pdb_TXPMA_IDX_0 		84
`define rpclksel_TXPMA_IDX_0 		85
`define rdynamic_sw_TXPMA_IDX_0 		86
`define rs_lpbk_TXPMA_IDX_0 		87
`define rcgb_delay_sel_TXPMA_IDX_0 		88
`define rpmadwidth_tx_TXPMA_IDX_0 		89
`define rpma_doublewidth_tx_TXPMA_IDX_0 		90
`define rcgb_m_sel_TXPMA_IDX_0 		91
`define rcgb_m_sel_TXPMA_IDX_1 		92
`define rcgb_cmu_sel_TXPMA_IDX_0 		93
`define rcgb_x_en_TXPMA_IDX_0 		94
`define rcgb_x_en_TXPMA_IDX_1 		95

// Table34: PMA Per Channel TX Control Register 7 for Channel 0
`define reserved_1_TB34_TXPMA_IDX_0 		96
`define reserved_1_TB34_TXPMA_IDX_1 		97
`define reserved_1_TB34_TXPMA_IDX_2 		98
`define rpcs_sd_sel_TXPMA_IDX_0 		99
`define rrx_refclk_TXPMA_IDX_0 		100
`define rimpctrl_TXPMA_IDX_0 		101
`define reserved_0_TB34_TXPMA_IDX_0 		102
`define reserved_0_TB34_TXPMA_IDX_1 		103
`define reserved_0_TB34_TXPMA_IDX_2 		104
`define reserved_0_TB34_TXPMA_IDX_3 		105
`define rrevlb_sw_TXPMA_IDX_0 		106
`define rvcobypass_TXPMA_IDX_0 		107
`define rrefclk_sel_TXPMA_IDX_0 		108
`define rrefclk_sel_TXPMA_IDX_1 		109
`define riqclk_sel_TXPMA_IDX_0 		110
`define riqclk_sel_TXPMA_IDX_1 		111

// Table35: PMA Per Channel TX Control Register 8 for Channel 0
`define rpma_reserved_0_TB35_TXPMA_IDX_0 		112
`define rpma_reserved_0_TB35_TXPMA_IDX_1 		113
`define rpma_reserved_0_TB35_TXPMA_IDX_2 		114
`define rpma_reserved_0_TB35_TXPMA_IDX_3 		115
`define rpma_reserved_0_TB35_TXPMA_IDX_4 		116
`define rpma_reserved_0_TB35_TXPMA_IDX_5 		117
`define rpma_reserved_0_TB35_TXPMA_IDX_6 		118
`define rpma_reserved_0_TB35_TXPMA_IDX_7 		119
`define rpma_reserved_0_TB35_TXPMA_IDX_8 		120
`define rpma_reserved_0_TB35_TXPMA_IDX_9 		121
`define rpma_reserved_0_TB35_TXPMA_IDX_10 		122
`define rpma_reserved_0_TB35_TXPMA_IDX_11 		123
`define rpma_reserved_0_TB35_TXPMA_IDX_12 		124
`define rpma_reserved_0_TB35_TXPMA_IDX_13 		125
`define rpma_reserved_0_TB35_TXPMA_IDX_14 		126
`define rpma_reserved_0_TB35_TXPMA_IDX_15 		127

// Extra
`define ht_sel_TX_PMA_IDX                       128

// SW logical index ----------------------------------------------------------
`define CLKIN_SELECT_TXPMA_IDX_0    200
`define CLKIN_SELECT_TXPMA_IDX_1    201
`define CLKIN_SELECT_TXPMA_IDX_2    202

// ---------------------------------------------------------------------------
// DPRIO input CRAM  
// ---------------------------------------------------------------------------

// PMA Per Channel TX Control Register 1 for Channel 0
wire dprioin_rpowdnt;
wire [2:0] dprioin_rvod_seld;
wire [2:0] dprioin_rvod_selc;
wire [2:0] dprioin_rvod_selb;
wire [2:0] dprioin_rvod_sela;
wire [2:0] dprioin_rvod_sel_non_pcie;

// PMA Per Channel TX Control Register 2 for Channel 0
wire dprioin_reserved_0_TB29;
wire [4:0] dprioin_rpre_em_1t_b;
wire [4:0] dprioin_rpre_em_1t_a;
wire [4:0] dprioin_rpre_em_1t_no_pcie;

// PMA Per Channel TX Control Register 3 for Channel 0
wire [3:0] dprioin_rpre_em_pt;
wire [3:0] dprioin_rpre_em_2t;
wire [4:0] dprioin_rpre_em_1t_c;
wire [2:0] dprioin_reserved_0_TB30;

// PMA Per Channel TX Control Register 4 for Channel 0
wire dprioin_rlowv;
wire [1:0] dprioin_rrx_det;
wire dprioin_rsig_inv_2t;
wire dprioin_rsig_inv_ptap;
wire [1:0] dprioin_rslew;
wire [3:0] dprioin_rtx_lst;
wire [1:0] dprioin_rtx_vtt;
wire [2:0] dprioin_rtx_term_sel;

// PMA Per Channel TX Control Register 5 for Channel 0
wire [10:0] dprioin_reserved_1_TB32;
wire dprioin_rtx_ob_pdb;
wire dprioin_reserved_0_TB32;
wire [2:0] dprioin_r_dft_sel;

// PMA Per Channel TX Control Register 6 for Channel 0
wire [3:0] dprioin_reserved_0_TB33;
wire dprioin_rtx_cgb_pdb;
wire dprioin_rpclksel;
wire dprioin_rdynamic_sw;
wire dprioin_rs_lpbk;
wire dprioin_rcgb_delay_sel;
wire dprioin_rpmadwidth_tx;
wire dprioin_rpma_doublewidth_tx;
wire [1:0] dprioin_rcgb_m_sel;
wire dprioin_rcgb_cmu_sel;
wire [1:0] dprioin_rcgb_x_en;

// PMA Per Channel TX Control Register 7 for Channel 0
wire [2:0] dprioin_reserved_1_TB34;
wire dprioin_rpcs_sd_sel;
wire dprioin_rrx_refclk;
wire dprioin_rimpctrl;
wire [3:0] dprioin_reserved_0_TB34;
wire dprioin_rrevlb_sw;
wire dprioin_rvcobypass;
wire [1:0] dprioin_rrefclk_sel;
wire [1:0] dprioin_riqclk_sel;

// PMA Per Channel TX Control Register 8 for Channel 0
wire [15:0] dprioin_rpma_reserved_0_TB35;

// Extra
wire dprioin_ht_sel;
wire [2:0]  dprioin_clkin_sel;

// ---------------------------------------------------------------------------
// Initial CRAM  
// ---------------------------------------------------------------------------

// PMA Per Channel TX Control Register 1 for Channel 0
reg init_rpowdnt;
reg [2:0] init_rvod_seld;
reg [2:0] init_rvod_selc;
reg [2:0] init_rvod_selb;
reg [2:0] init_rvod_sela;
reg [2:0] init_rvod_sel_non_pcie;

// PMA Per Channel TX Control Register 2 for Channel 0
reg init_reserved_0_TB29;
reg [4:0] init_rpre_em_1t_b;
reg [4:0] init_rpre_em_1t_a;
reg [4:0] init_rpre_em_1t_no_pcie;

// PMA Per Channel TX Control Register 3 for Channel 0
reg [3:0] init_rpre_em_pt;
reg [3:0] init_rpre_em_2t;
reg [4:0] init_rpre_em_1t_c;
reg [2:0] init_reserved_0_TB30;

// PMA Per Channel TX Control Register 4 for Channel 0
reg init_rlowv;
reg [1:0] init_rrx_det;
reg init_rsig_inv_2t;
reg init_rsig_inv_ptap;
reg [1:0] init_rslew;
reg [3:0] init_rtx_lst;
reg [1:0] init_rtx_vtt;
reg [2:0] init_rtx_term_sel;

// PMA Per Channel TX Control Register 5 for Channel 0
reg [10:0] init_reserved_1_TB32;
reg init_rtx_ob_pdb;
reg init_reserved_0_TB32;
reg [2:0] init_r_dft_sel;

// PMA Per Channel TX Control Register 6 for Channel 0
reg [3:0] init_reserved_0_TB33;
reg init_rtx_cgb_pdb;
reg init_rpclksel;
reg init_rdynamic_sw;
reg init_rs_lpbk;
reg init_rcgb_delay_sel;
reg init_rpmadwidth_tx;
reg init_rpma_doublewidth_tx;
reg [1:0] init_rcgb_m_sel;
reg init_rcgb_cmu_sel;
reg [1:0] init_rcgb_x_en;

// PMA Per Channel TX Control Register 7 for Channel 0
reg [2:0] init_reserved_1_TB34;
reg init_rpcs_sd_sel;
reg init_rrx_refclk;
reg init_rimpctrl;
reg [3:0] init_reserved_0_TB34;
reg init_rrevlb_sw;
reg init_rvcobypass;
reg [1:0] init_rrefclk_sel;
reg [1:0] init_riqclk_sel;

// PMA Per Channel TX Control Register 8 for Channel 0
reg [15:0] init_rpma_reserved_0_TB35;

// Extra
reg init_ht_sel;
reg  [2:0]  init_clkin_sel;

// ---------------------------------------------------------------------------
// CRAM  
// ---------------------------------------------------------------------------

// PMA Per Channel TX Control Register 1 for Channel 0
wire cram_rpowdnt;
wire [2:0] cram_rvod_seld;
wire [2:0] cram_rvod_selc;
wire [2:0] cram_rvod_selb;
wire [2:0] cram_rvod_sela;
wire [2:0] cram_rvod_sel_non_pcie;

// PMA Per Channel TX Control Register 2 for Channel 0
wire cram_reserved_0_TB29;
wire [4:0] cram_rpre_em_1t_b;
wire [4:0] cram_rpre_em_1t_a;
wire [4:0] cram_rpre_em_1t_no_pcie;

// PMA Per Channel TX Control Register 3 for Channel 0
wire [3:0] cram_rpre_em_pt;
wire [3:0] cram_rpre_em_2t;
wire [4:0] cram_rpre_em_1t_c;
wire [2:0] cram_reserved_0_TB30;

// PMA Per Channel TX Control Register 4 for Channel 0
wire cram_rlowv;
wire [1:0] cram_rrx_det;
wire cram_rsig_inv_2t;
wire cram_rsig_inv_ptap;
wire [1:0] cram_rslew;
wire [3:0] cram_rtx_lst;
wire [1:0] cram_rtx_vtt;
wire [2:0] cram_rtx_term_sel;

// PMA Per Channel TX Control Register 5 for Channel 0
wire [10:0] cram_reserved_1_TB32;
wire cram_rtx_ob_pdb;
wire cram_reserved_0_TB32;
wire [2:0] cram_r_dft_sel;

// PMA Per Channel TX Control Register 6 for Channel 0
wire [3:0] cram_reserved_0_TB33;
wire cram_rtx_cgb_pdb;
wire cram_rpclksel;
wire cram_rdynamic_sw;
wire cram_rs_lpbk;
wire cram_rcgb_delay_sel;
wire cram_rpmadwidth_tx;
wire cram_rpma_doublewidth_tx;
wire [1:0] cram_rcgb_m_sel;
wire cram_rcgb_cmu_sel;
wire [1:0] cram_rcgb_x_en;

// PMA Per Channel TX Control Register 7 for Channel 0
wire [2:0] cram_reserved_1_TB34;
wire cram_rpcs_sd_sel;
wire cram_rrx_refclk;
wire cram_rimpctrl;
wire [3:0] cram_reserved_0_TB34;
wire cram_rrevlb_sw;
wire cram_rvcobypass;
wire [1:0] cram_rrefclk_sel;
wire [1:0] cram_riqclk_sel;

// PMA Per Channel TX Control Register 8 for Channel 0
wire [15:0] cram_rpma_reserved_0_TB35;

// Extra
wire cram_ht_sel;
wire [2:0]  cram_clkin_sel;

// ---------------------------------------------------------------------------
// INPUT FILTERING  ----------------------------------------------------------
// ---------------------------------------------------------------------------

wire detectrxpowerdown_in;
wire forceelecidle_in;
wire powerdn_in;
wire txpmareset_in;
wire xtx_rx_found;

assign detectrxpowerdown_in = (detectrxpowerdown === 1'b1) ? 1'b0 : 1'b1;
// assign dpriodisable	= (dpriodisable === 1'b0) ? 1'b0 : 1'b1;
assign forceelecidle_in = (forceelecidle === 1'b1) ? 1'b1 : 1'b0;
assign powerdn_in = (powerdn === 1'b1) ? 1'b0 : 1'b1;
assign txpmareset_in = (txpmareset === 1'b1) ? 1'b0 : 1'b1; // active low

// ---------------------------------------------------------------------------
// TIMING -- Tco/Tsu/Thold
// ---------------------------------------------------------------------------

specify

    // setup/hold check on datain done at tx_pcs level
    (posedge rxdetecten => (rxfoundout +: xtx_rx_found)) = (0, 0);

endspecify

// ---------------------------------------------------------------------------
// Set DPRIO CRAM input from dprioin  
// ---------------------------------------------------------------------------

// PMA Per Channel TX Control Register 1 for Channel 0
assign dprioin_rpowdnt	= dprioin[`rpowdnt_TXPMA_IDX_0];
assign dprioin_rvod_seld	= dprioin[`rvod_seld_TXPMA_IDX_2 : `rvod_seld_TXPMA_IDX_0];
assign dprioin_rvod_selc	= dprioin[`rvod_selc_TXPMA_IDX_2 : `rvod_selc_TXPMA_IDX_0];
assign dprioin_rvod_selb	= dprioin[`rvod_selb_TXPMA_IDX_2 : `rvod_selb_TXPMA_IDX_0];
assign dprioin_rvod_sela	= dprioin[`rvod_sela_TXPMA_IDX_2 : `rvod_sela_TXPMA_IDX_0];
assign dprioin_rvod_sel_non_pcie	= dprioin[`rvod_sel_non_pcie_TXPMA_IDX_2 : `rvod_sel_non_pcie_TXPMA_IDX_0];

// PMA Per Channel TX Control Register 2 for Channel 0
assign dprioin_reserved_0_TB29	= dprioin[`reserved_0_TB29_TXPMA_IDX_0];
assign dprioin_rpre_em_1t_b	= dprioin[`rpre_em_1t_b_TXPMA_IDX_4 : `rpre_em_1t_b_TXPMA_IDX_0];
assign dprioin_rpre_em_1t_a	= dprioin[`rpre_em_1t_a_TXPMA_IDX_4 : `rpre_em_1t_a_TXPMA_IDX_0];
assign dprioin_rpre_em_1t_no_pcie	= dprioin[`rpre_em_1t_no_pcie_TXPMA_IDX_4 : `rpre_em_1t_no_pcie_TXPMA_IDX_0];

// PMA Per Channel TX Control Register 3 for Channel 0
assign dprioin_rpre_em_pt	= dprioin[`rpre_em_pt_TXPMA_IDX_3 : `rpre_em_pt_TXPMA_IDX_0];
assign dprioin_rpre_em_2t	= dprioin[`rpre_em_2t_TXPMA_IDX_3 : `rpre_em_2t_TXPMA_IDX_0];
assign dprioin_rpre_em_1t_c	= dprioin[`rpre_em_1t_c_TXPMA_IDX_4 : `rpre_em_1t_c_TXPMA_IDX_0];
assign dprioin_reserved_0_TB30	= dprioin[`reserved_0_TB30_TXPMA_IDX_2 : `reserved_0_TB30_TXPMA_IDX_0];

// PMA Per Channel TX Control Register 4 for Channel 0
assign dprioin_rlowv	= dprioin[`rlowv_TXPMA_IDX_0];
assign dprioin_rrx_det	= dprioin[`rrx_det_TXPMA_IDX_1 : `rrx_det_TXPMA_IDX_0];
assign dprioin_rsig_inv_2t	= dprioin[`rsig_inv_2t_TXPMA_IDX_0];
assign dprioin_rsig_inv_ptap	= dprioin[`rsig_inv_ptap_TXPMA_IDX_0];
assign dprioin_rslew	= dprioin[`rslew_TXPMA_IDX_1 : `rslew_TXPMA_IDX_0];
assign dprioin_rtx_lst	= dprioin[`rtx_lst_TXPMA_IDX_3 : `rtx_lst_TXPMA_IDX_0];
assign dprioin_rtx_vtt	= dprioin[`rtx_vtt_TXPMA_IDX_1 : `rtx_vtt_TXPMA_IDX_0];
assign dprioin_rtx_term_sel	= dprioin[`rtx_term_sel_TXPMA_IDX_2 : `rtx_term_sel_TXPMA_IDX_0];

// PMA Per Channel TX Control Register 5 for Channel 0
assign dprioin_reserved_1_TB32	= dprioin[`reserved_1_TB32_TXPMA_IDX_10 : `reserved_1_TB32_TXPMA_IDX_0];
assign dprioin_rtx_ob_pdb	= dprioin[`rtx_ob_pdb_TXPMA_IDX_0];
assign dprioin_reserved_0_TB32	= dprioin[`reserved_0_TB32_TXPMA_IDX_0];
assign dprioin_r_dft_sel	= dprioin[`r_dft_sel_TXPMA_IDX_2 : `r_dft_sel_TXPMA_IDX_0];

// PMA Per Channel TX Control Register 6 for Channel 0
assign dprioin_reserved_0_TB33	= dprioin[`reserved_0_TB33_TXPMA_IDX_3 : `reserved_0_TB33_TXPMA_IDX_0];
assign dprioin_rtx_cgb_pdb	= dprioin[`rtx_cgb_pdb_TXPMA_IDX_0];
assign dprioin_rpclksel	= dprioin[`rpclksel_TXPMA_IDX_0];
assign dprioin_rdynamic_sw	= dprioin[`rdynamic_sw_TXPMA_IDX_0];
assign dprioin_rs_lpbk	= dprioin[`rs_lpbk_TXPMA_IDX_0];
assign dprioin_rcgb_delay_sel	= dprioin[`rcgb_delay_sel_TXPMA_IDX_0];
assign dprioin_rpmadwidth_tx	= dprioin[`rpmadwidth_tx_TXPMA_IDX_0];
assign dprioin_rpma_doublewidth_tx	= dprioin[`rpma_doublewidth_tx_TXPMA_IDX_0];
assign dprioin_rcgb_m_sel	= dprioin[`rcgb_m_sel_TXPMA_IDX_1 : `rcgb_m_sel_TXPMA_IDX_0];
assign dprioin_rcgb_cmu_sel	= dprioin[`rcgb_cmu_sel_TXPMA_IDX_0];
assign dprioin_rcgb_x_en	= dprioin[`rcgb_x_en_TXPMA_IDX_1 : `rcgb_x_en_TXPMA_IDX_0];

// PMA Per Channel TX Control Register 7 for Channel 0
assign dprioin_reserved_1_TB34	= dprioin[`reserved_1_TB34_TXPMA_IDX_2 : `reserved_1_TB34_TXPMA_IDX_0];
assign dprioin_rpcs_sd_sel	= dprioin[`rpcs_sd_sel_TXPMA_IDX_0];
assign dprioin_rrx_refclk	= dprioin[`rrx_refclk_TXPMA_IDX_0];
assign dprioin_rimpctrl	= dprioin[`rimpctrl_TXPMA_IDX_0];
assign dprioin_reserved_0_TB34	= dprioin[`reserved_0_TB34_TXPMA_IDX_3 : `reserved_0_TB34_TXPMA_IDX_0];
assign dprioin_rrevlb_sw	= dprioin[`rrevlb_sw_TXPMA_IDX_0];
assign dprioin_rvcobypass	= dprioin[`rvcobypass_TXPMA_IDX_0];
assign dprioin_rrefclk_sel	= dprioin[`rrefclk_sel_TXPMA_IDX_1 : `rrefclk_sel_TXPMA_IDX_0];
assign dprioin_riqclk_sel	= dprioin[`riqclk_sel_TXPMA_IDX_1 : `riqclk_sel_TXPMA_IDX_0];

// PMA Per Channel TX Control Register 8 for Channel 0
assign dprioin_rpma_reserved_0_TB35	= dprioin[`rpma_reserved_0_TB35_TXPMA_IDX_15 : `rpma_reserved_0_TB35_TXPMA_IDX_0];

// Extra
assign dprioin_ht_sel	= dprioin[`ht_sel_TX_PMA_IDX];
assign dprioin_clkin_sel = dprioin[`CLKIN_SELECT_TXPMA_IDX_2 : `CLKIN_SELECT_TXPMA_IDX_0];

// ---------------------------------------------------------------------------
// Set DPRIO output from initial CRAM
// ---------------------------------------------------------------------------

// PMA Per Channel TX Control Register 1 for Channel 0
assign dprioout[`rpowdnt_TXPMA_IDX_0] = init_rpowdnt;
assign dprioout[`rvod_seld_TXPMA_IDX_2 : `rvod_seld_TXPMA_IDX_0] = init_rvod_seld;
assign dprioout[`rvod_selc_TXPMA_IDX_2 : `rvod_selc_TXPMA_IDX_0] = init_rvod_selc;
assign dprioout[`rvod_selb_TXPMA_IDX_2 : `rvod_selb_TXPMA_IDX_0] = init_rvod_selb;
assign dprioout[`rvod_sela_TXPMA_IDX_2 : `rvod_sela_TXPMA_IDX_0] = init_rvod_sela;
assign dprioout[`rvod_sel_non_pcie_TXPMA_IDX_2 : `rvod_sel_non_pcie_TXPMA_IDX_0] = init_rvod_sel_non_pcie;

// PMA Per Channel TX Control Register 2 for Channel 0
assign dprioout[`reserved_0_TB29_TXPMA_IDX_0] = init_reserved_0_TB29;
assign dprioout[`rpre_em_1t_b_TXPMA_IDX_4 : `rpre_em_1t_b_TXPMA_IDX_0] = init_rpre_em_1t_b;
assign dprioout[`rpre_em_1t_a_TXPMA_IDX_4 : `rpre_em_1t_a_TXPMA_IDX_0] = init_rpre_em_1t_a;
assign dprioout[`rpre_em_1t_no_pcie_TXPMA_IDX_4 : `rpre_em_1t_no_pcie_TXPMA_IDX_0] = init_rpre_em_1t_no_pcie;

// PMA Per Channel TX Control Register 3 for Channel 0
assign dprioout[`rpre_em_pt_TXPMA_IDX_3 : `rpre_em_pt_TXPMA_IDX_0] = init_rpre_em_pt;
assign dprioout[`rpre_em_2t_TXPMA_IDX_3 : `rpre_em_2t_TXPMA_IDX_0] = init_rpre_em_2t;
assign dprioout[`rpre_em_1t_c_TXPMA_IDX_4 : `rpre_em_1t_c_TXPMA_IDX_0] = init_rpre_em_1t_c;
assign dprioout[`reserved_0_TB30_TXPMA_IDX_2 : `reserved_0_TB30_TXPMA_IDX_0] = init_reserved_0_TB30;

// PMA Per Channel TX Control Register 4 for Channel 0
assign dprioout[`rlowv_TXPMA_IDX_0] = init_rlowv;
assign dprioout[`rrx_det_TXPMA_IDX_1 : `rrx_det_TXPMA_IDX_0] = init_rrx_det;
assign dprioout[`rsig_inv_2t_TXPMA_IDX_0] = init_rsig_inv_2t;
assign dprioout[`rsig_inv_ptap_TXPMA_IDX_0] = init_rsig_inv_ptap;
assign dprioout[`rslew_TXPMA_IDX_1 : `rslew_TXPMA_IDX_0] = init_rslew;
assign dprioout[`rtx_lst_TXPMA_IDX_3 : `rtx_lst_TXPMA_IDX_0] = init_rtx_lst;
assign dprioout[`rtx_vtt_TXPMA_IDX_1 : `rtx_vtt_TXPMA_IDX_0] = init_rtx_vtt;
assign dprioout[`rtx_term_sel_TXPMA_IDX_2 : `rtx_term_sel_TXPMA_IDX_0] = init_rtx_term_sel;

// PMA Per Channel TX Control Register 5 for Channel 0
assign dprioout[`reserved_1_TB32_TXPMA_IDX_10 : `reserved_1_TB32_TXPMA_IDX_0] = init_reserved_1_TB32;
assign dprioout[`rtx_ob_pdb_TXPMA_IDX_0] = init_rtx_ob_pdb;
assign dprioout[`reserved_0_TB32_TXPMA_IDX_0] = init_reserved_0_TB32;
assign dprioout[`r_dft_sel_TXPMA_IDX_2 : `r_dft_sel_TXPMA_IDX_0] = init_r_dft_sel;

// PMA Per Channel TX Control Register 6 for Channel 0
assign dprioout[`reserved_0_TB33_TXPMA_IDX_3 : `reserved_0_TB33_TXPMA_IDX_0] = init_reserved_0_TB33;
assign dprioout[`rtx_cgb_pdb_TXPMA_IDX_0] = init_rtx_cgb_pdb;
assign dprioout[`rpclksel_TXPMA_IDX_0] = init_rpclksel;
assign dprioout[`rdynamic_sw_TXPMA_IDX_0] = init_rdynamic_sw;
assign dprioout[`rs_lpbk_TXPMA_IDX_0] = init_rs_lpbk;
assign dprioout[`rcgb_delay_sel_TXPMA_IDX_0] = init_rcgb_delay_sel;
assign dprioout[`rpmadwidth_tx_TXPMA_IDX_0] = init_rpmadwidth_tx;
assign dprioout[`rpma_doublewidth_tx_TXPMA_IDX_0] = init_rpma_doublewidth_tx;
assign dprioout[`rcgb_m_sel_TXPMA_IDX_1 : `rcgb_m_sel_TXPMA_IDX_0] = init_rcgb_m_sel;
assign dprioout[`rcgb_cmu_sel_TXPMA_IDX_0] = init_rcgb_cmu_sel;
assign dprioout[`rcgb_x_en_TXPMA_IDX_1 : `rcgb_x_en_TXPMA_IDX_0] = init_rcgb_x_en;

// PMA Per Channel TX Control Register 7 for Channel 0
assign dprioout[`reserved_1_TB34_TXPMA_IDX_2 : `reserved_1_TB34_TXPMA_IDX_0] = init_reserved_1_TB34;
assign dprioout[`rpcs_sd_sel_TXPMA_IDX_0] = init_rpcs_sd_sel;
assign dprioout[`rrx_refclk_TXPMA_IDX_0] = init_rrx_refclk;
assign dprioout[`rimpctrl_TXPMA_IDX_0] = init_rimpctrl;
assign dprioout[`reserved_0_TB34_TXPMA_IDX_3 : `reserved_0_TB34_TXPMA_IDX_0] = init_reserved_0_TB34;
assign dprioout[`rrevlb_sw_TXPMA_IDX_0] = init_rrevlb_sw;
assign dprioout[`rvcobypass_TXPMA_IDX_0] = init_rvcobypass;
assign dprioout[`rrefclk_sel_TXPMA_IDX_1 : `rrefclk_sel_TXPMA_IDX_0] = init_rrefclk_sel;
assign dprioout[`riqclk_sel_TXPMA_IDX_1 : `riqclk_sel_TXPMA_IDX_0] = init_riqclk_sel;

// PMA Per Channel TX Control Register 8 for Channel 0
assign dprioout[`rpma_reserved_0_TB35_TXPMA_IDX_15 : `rpma_reserved_0_TB35_TXPMA_IDX_0] = init_rpma_reserved_0_TB35;

// Extra
assign dprioout[`ht_sel_TX_PMA_IDX]  = init_ht_sel;
assign dprioout[`CLKIN_SELECT_TXPMA_IDX_2 : `CLKIN_SELECT_TXPMA_IDX_0] = init_clkin_sel;

// ---------------------------------------------------------------------------
// Set DPRIO CRAM
// ---------------------------------------------------------------------------

// PMA Per Channel TX Control Register 1 for Channel 0
assign cram_rpowdnt = (dpriodisable !== 1'b0) ? init_rpowdnt : dprioin_rpowdnt;
assign cram_rvod_seld = (dpriodisable !== 1'b0) ? init_rvod_seld : dprioin_rvod_seld;
assign cram_rvod_selc = (dpriodisable !== 1'b0) ? init_rvod_selc : dprioin_rvod_selc;
assign cram_rvod_selb = (dpriodisable !== 1'b0) ? init_rvod_selb : dprioin_rvod_selb;
assign cram_rvod_sela = (dpriodisable !== 1'b0) ? init_rvod_sela : dprioin_rvod_sela;
assign cram_rvod_sel_non_pcie = (dpriodisable !== 1'b0) ? init_rvod_sel_non_pcie : dprioin_rvod_sel_non_pcie;

// PMA Per Channel TX Control Register 2 for Channel 0
assign cram_reserved_0_TB29 = (dpriodisable !== 1'b0) ? init_reserved_0_TB29 : dprioin_reserved_0_TB29;
assign cram_rpre_em_1t_b = (dpriodisable !== 1'b0) ? init_rpre_em_1t_b : dprioin_rpre_em_1t_b;
assign cram_rpre_em_1t_a = (dpriodisable !== 1'b0) ? init_rpre_em_1t_a : dprioin_rpre_em_1t_a;
assign cram_rpre_em_1t_no_pcie = (dpriodisable !== 1'b0) ? init_rpre_em_1t_no_pcie : dprioin_rpre_em_1t_no_pcie;

// PMA Per Channel TX Control Register 3 for Channel 0
assign cram_rpre_em_pt = (dpriodisable !== 1'b0) ? init_rpre_em_pt : dprioin_rpre_em_pt;
assign cram_rpre_em_2t = (dpriodisable !== 1'b0) ? init_rpre_em_2t : dprioin_rpre_em_2t;
assign cram_rpre_em_1t_c = (dpriodisable !== 1'b0) ? init_rpre_em_1t_c : dprioin_rpre_em_1t_c;
assign cram_reserved_0_TB30 = (dpriodisable !== 1'b0) ? init_reserved_0_TB30 : dprioin_reserved_0_TB30;

// PMA Per Channel TX Control Register 4 for Channel 0
assign cram_rlowv = (dpriodisable !== 1'b0) ? init_rlowv : dprioin_rlowv;
assign cram_rrx_det = (dpriodisable !== 1'b0) ? init_rrx_det : dprioin_rrx_det;
assign cram_rsig_inv_2t = (dpriodisable !== 1'b0) ? init_rsig_inv_2t : dprioin_rsig_inv_2t;
assign cram_rsig_inv_ptap = (dpriodisable !== 1'b0) ? init_rsig_inv_ptap : dprioin_rsig_inv_ptap;
assign cram_rslew = (dpriodisable !== 1'b0) ? init_rslew : dprioin_rslew;
assign cram_rtx_lst = (dpriodisable !== 1'b0) ? init_rtx_lst : dprioin_rtx_lst;
assign cram_rtx_vtt = (dpriodisable !== 1'b0) ? init_rtx_vtt : dprioin_rtx_vtt;
assign cram_rtx_term_sel = (dpriodisable !== 1'b0) ? init_rtx_term_sel : dprioin_rtx_term_sel;

// PMA Per Channel TX Control Register 5 for Channel 0
assign cram_reserved_1_TB32 = (dpriodisable !== 1'b0) ? init_reserved_1_TB32 : dprioin_reserved_1_TB32;
assign cram_rtx_ob_pdb = (dpriodisable !== 1'b0) ? init_rtx_ob_pdb : dprioin_rtx_ob_pdb;
assign cram_reserved_0_TB32 = (dpriodisable !== 1'b0) ? init_reserved_0_TB32 : dprioin_reserved_0_TB32;
assign cram_r_dft_sel = (dpriodisable !== 1'b0) ? init_r_dft_sel : dprioin_r_dft_sel;

// PMA Per Channel TX Control Register 6 for Channel 0
assign cram_reserved_0_TB33 = (dpriodisable !== 1'b0) ? init_reserved_0_TB33 : dprioin_reserved_0_TB33;
assign cram_rtx_cgb_pdb = (dpriodisable !== 1'b0) ? init_rtx_cgb_pdb : dprioin_rtx_cgb_pdb;
assign cram_rpclksel = (dpriodisable !== 1'b0) ? init_rpclksel : dprioin_rpclksel;
assign cram_rdynamic_sw = (dpriodisable !== 1'b0) ? init_rdynamic_sw : dprioin_rdynamic_sw;
assign cram_rs_lpbk = (dpriodisable !== 1'b0) ? init_rs_lpbk : dprioin_rs_lpbk;
assign cram_rcgb_delay_sel = 1'b0;      // delay chains not modeled here
assign cram_rpmadwidth_tx = (dpriodisable !== 1'b0) ? init_rpmadwidth_tx : dprioin_rpmadwidth_tx;
assign cram_rpma_doublewidth_tx = (dpriodisable !== 1'b0) ? init_rpma_doublewidth_tx : dprioin_rpma_doublewidth_tx;
assign cram_rcgb_m_sel = (dpriodisable !== 1'b0) ? init_rcgb_m_sel : dprioin_rcgb_m_sel;
assign cram_rcgb_cmu_sel = (dpriodisable !== 1'b0) ? init_rcgb_cmu_sel : dprioin_rcgb_cmu_sel;
assign cram_rcgb_x_en = (dpriodisable !== 1'b0) ? init_rcgb_x_en : dprioin_rcgb_x_en;

// PMA Per Channel TX Control Register 7 for Channel 0
assign cram_reserved_1_TB34 = (dpriodisable !== 1'b0) ? init_reserved_1_TB34 : dprioin_reserved_1_TB34;
assign cram_rpcs_sd_sel = (dpriodisable !== 1'b0) ? init_rpcs_sd_sel : dprioin_rpcs_sd_sel;
assign cram_rrx_refclk = (dpriodisable !== 1'b0) ? init_rrx_refclk : dprioin_rrx_refclk;
assign cram_rimpctrl = (dpriodisable !== 1'b0) ? init_rimpctrl : dprioin_rimpctrl;
assign cram_reserved_0_TB34 = (dpriodisable !== 1'b0) ? init_reserved_0_TB34 : dprioin_reserved_0_TB34;
assign cram_rrevlb_sw = (dpriodisable !== 1'b0) ? init_rrevlb_sw : dprioin_rrevlb_sw;
assign cram_rvcobypass = (dpriodisable !== 1'b0) ? init_rvcobypass : dprioin_rvcobypass;
assign cram_rrefclk_sel = (dpriodisable !== 1'b0) ? init_rrefclk_sel : dprioin_rrefclk_sel;
assign cram_riqclk_sel = (dpriodisable !== 1'b0) ? init_riqclk_sel : dprioin_riqclk_sel;

// PMA Per Channel TX Control Register 8 for Channel 0
assign cram_rpma_reserved_0_TB35 = (dpriodisable !== 1'b0) ? init_rpma_reserved_0_TB35 : dprioin_rpma_reserved_0_TB35;

// Extra
assign cram_ht_sel = init_ht_sel;	// SPR 288513
assign cram_clkin_sel    = (dpriodisable !== 1'b0) ? init_clkin_sel : dprioin_clkin_sel;

// Function
function [8*`ARRIAII_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] alpha_tolower;
input [8*`ARRIAII_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] input_string;

reg [8*`ARRIAII_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] return_string;
reg [8*`ARRIAII_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] reg_string;
reg [8:1] tmp;
reg [8:1] conv_char;
integer byte_count;
begin
reg_string = input_string;
for (byte_count = `ARRIAII_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH; byte_count >= 1; byte_count = byte_count - 1)
begin
    tmp = reg_string[8*`ARRIAII_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH:(8*(`ARRIAII_HSSI_TX_PMA_ALPHA_TOLOWER_WORD_LENGTH-1)+1)];
    reg_string = reg_string << 8;
    if ((tmp >= 65) && (tmp <= 90)) // ASCII number of 'A' is 65, 'Z' is 90
    begin
	conv_char = tmp + 32; // 32 is the difference in the position of 'A' and 'a' in the ASCII char set
	return_string = {return_string, conv_char};
    end
    else
	return_string = {return_string, tmp};
end

alpha_tolower = return_string;
end
endfunction

function [31:0] int2bin;
    input input_value;
    integer input_value;
    integer i;     
    begin
    for (i = 0; i <= 31; i = i + 1)
    begin
        if (input_value % 2 == 0) 
    	    int2bin[i] = 1'b0;	
        else
    	   int2bin[i] = 1'b1;	
    	    		
    	input_value = input_value / 2;
    end
    end
endfunction 
// end function

initial begin
    // TX PMA control register 1
    init_rpowdnt           = 1'b0;
    init_rvod_sel_non_pcie = (vod_selection == 0) ? 3'b000 : (vod_selection == 1) ? 3'b001 : (vod_selection == 2) ? 3'b010 : (vod_selection == 3) ? 3'b110 : (vod_selection == 4) ? 3'b011 : (vod_selection == 5) ? 3'b111 : (vod_selection == 6) ? 3'b100 : (vod_selection == 7) ? 3'b101 : 3'b000;
    init_rvod_seld         = vod_selection_d;
    init_rvod_selc         = vod_selection_c;
    init_rvod_selb         = vod_selection_b;
    init_rvod_sela         = vod_selection_a;
    
    // TX PMA control register 2
    init_rpre_em_1t_b		= preemp_tap_1_b;
    init_rpre_em_1t_a		= preemp_tap_1_a;
    init_rpre_em_1t_no_pcie	= preemp_tap_1;
    
    // TX PMA control register 3
    init_rpre_em_pt	= preemp_pretap;
    init_rpre_em_2t	= preemp_tap_2;
    init_rpre_em_1t_c	= preemp_tap_1_c;
    
    // TX PMA control register 4
    init_rlowv			= 1'b0;
    init_rrx_det		= rx_detect;
    init_rsig_inv_2t	= (preemp_tap_2_inv == "true") ? 1'b1 : 1'b0;
    init_rsig_inv_ptap 	= (preemp_pretap_inv == "true") ? 1'b1 : 1'b0;
    init_rslew 			= (slew_rate == "low" ? 2'b01 : slew_rate == "medium" ? 2'b10 : slew_rate == "high" ? 2'b11 : 2'b00);
    init_rtx_lst		= low_speed_test_select;
    init_rtx_vtt		= (alpha_tolower(common_mode) == "tristate") ? 2'b00 : (alpha_tolower(common_mode) == "0.6v") ? 2'b01 : (alpha_tolower(common_mode) == "0.7v") ? 2'b10 : 2'b11;
    init_rtx_term_sel	= (alpha_tolower(termination) == "off" ? 3'b000 : (alpha_tolower(termination) == "oct 85 ohms" || alpha_tolower(termination) == "85_ohms") ? 3'b111 : (alpha_tolower(termination) == "oct 100 ohms" || alpha_tolower(termination) == "100_ohms") ? 3'b110 : (alpha_tolower(termination) == "oct 120 ohms" || alpha_tolower(termination) == "120_ohms") ? 3'b101 : 3'b100); 
    
    // TX PMA Control Register 6
    init_rpma_doublewidth_tx 	= (serialization_factor == 16 || serialization_factor == 20 ? 1'b1 : 1'b0);    	//init_rpma_doublewidth_tx 	= rser_div2_init;
    init_rpmadwidth_tx 			= (serialization_factor == 10 || serialization_factor == 20 ? 1'b1 : 1'b0);		//init_rpmadwidth_tx 		= rser_div5_init;
    init_rcgb_delay_sel			= (clkmux_delay == "true") ? 1'b1 : 1'b0;
    init_rcgb_x_en 				= clkin_select;
    init_rpclksel 				= (use_pclk == "true") ? 1'b1 : 1'b0;     
    init_rs_lpbk 				= (enable_reverse_serial_loopback == "true") ? 1'b1 : 1'b0;    

    // Extra
    init_ht_sel = (clkin_select > 3) ? 1'b1 : 1'b0;
    
    // logic select
    init_clkin_sel = clkin_select;
end

// ---------------------------------------------------------------------------
//  New DPRIO End                                                          
// ---------------------------------------------------------------------------
// ---------------------------------------------------------------------------
//  Model / Submodule Instantiations                                         -
// ---------------------------------------------------------------------------

//  common supply wires
wire vccelxqyx;
wire vsse;

assign vccelxqyx = 1'b1;
assign vsse = 1'b0;

// for the tx_clkmux instance
// input wires

wire xtxclkmux_ht_sel;

// output wires
wire xtxclkmux_cpulse;
wire xtxclkmux_hfclkn;
wire xtxclkmux_hfclkp;
wire xtxclkmux_lfclkn;
wire xtxclkmux_lfclkp;

assign xtxclkmux_ht_sel = serialization_factor <= 20 ? cram_ht_sel : 1'b0;

// the actual instance
   arriaii_hssi_pma_c_tx_clkmux_cmu xtxclkmux ( .cpulse_ht(refclk4inpulse),
                                            .cpulse_x1(refclk0inpulse),
                                            .cpulse_x4(refclk1inpulse),
                                            .cpulse_xn_b(refclk3inpulse),
                                            .cpulse_xn_t(refclk2inpulse),
                                            .delay_sel(cram_rcgb_delay_sel),
                                            .hfclkn_ht(fastrefclk4in[1]),
                                            .hfclkn_x1(fastrefclk0in[1]),
                                            .hfclkn_x4(fastrefclk1in[1]),
                                            .hfclkn_xn_b(fastrefclk3in[1]),
                                            .hfclkn_xn_t(fastrefclk2in[1]),
                                            .hfclkp_ht(fastrefclk4in[0]),
                                            .hfclkp_x1(fastrefclk0in[0]),
                                            .hfclkp_x4(fastrefclk1in[0]),
                                            .hfclkp_xn_b(fastrefclk3in[0]),
                                            .hfclkp_xn_t(fastrefclk2in[0]),
                                            .ht_sel(xtxclkmux_ht_sel),
                                            .lfclkn_ht(refclk4in[1]),
                                            .lfclkn_x1(refclk0in[1]),
                                            .lfclkn_x4(refclk1in[1]),
                                            .lfclkn_xn_b(refclk3in[1]),
                                            .lfclkn_xn_t(refclk2in[1]),
                                            .lfclkp_ht(refclk4in[0]),
                                            .lfclkp_x1(refclk0in[0]),
                                            .lfclkp_x4(refclk1in[0]),
                                            .lfclkp_xn_b(refclk3in[0]),
                                            .lfclkp_xn_t(refclk2in[0]),
                                            .pdb(powerdn_in),
                                            .sel(cram_clkin_sel[1:0]),
                                            .vccelxqyx(vccelxqyx),
                                            .vssexqyx(vsse),

                                            .cpulse(xtxclkmux_cpulse),
                                            .hfclk_n(xtxclkmux_hfclkn),
                                            .hfclk_p(xtxclkmux_hfclkp),
                                            .lfclk_n(xtxclkmux_lfclkn),
                                            .lfclk_p(xtxclkmux_lfclkp)
                                          );

// for the serializer instance
// input wires
wire xser_cpulse;
wire [19:0] xser_data;
wire [19:0] xser_data_dprio;
wire xser_hfclkn;
wire xser_hfclkp;
wire xser_lfclkn;
wire xser_lfclkp;
wire xser_pclk;
wire xser_rs_lpbk;
wire vccetx;

// output wires
wire xser_clk_divtx;
wire xser_lbvop;
wire xser_lbvon;
wire xser_pre_en_out;
wire xser_von;
wire xser_von_op1;
wire xser_von_op2;
wire xser_von_pre;
wire xser_vop;
wire xser_vop_op1;
wire xser_vop_op2;
wire xser_vop_pre;

reg use_pma_direct_param;

initial
begin
    use_pma_direct_param = (use_pma_direct == "true" ) ? 1'b1 : 1'b0;
end

// get the inputs
assign xser_data = (use_pma_direct_param == 1'b1 && serialization_factor == 16) ? ({{2{1'b0}}, datain[15:8], {2{1'b0}}, datain[7:0]}) : datain[19:0];

assign xser_data_dprio = (use_pma_direct_param == 1'b1 && (dprio_config_mode & DPRIO_CHANNEL_INTERFACE_BIT) != 0) ? datainfull : xser_data;

assign xser_pclk = (cram_clkin_sel == 0) ? pclk[0] :
                   (cram_clkin_sel == 1) ? pclk[1] :
                   (cram_clkin_sel == 2) ? pclk[2] :
                   (cram_clkin_sel == 3) ? pclk[3] :
                   (cram_clkin_sel == 4) ? pclk[4] :
                   pclk[0];  // shawn: clkin_select
                   
assign xser_rs_lpbk = 1'b1;               // always enabled - allow serial_loop_back

assign {xser_cpulse, xser_hfclkn, xser_hfclkp, xser_lfclkn, xser_lfclkp} = serialization_factor > 20 ? 5'b00000 : {xtxclkmux_cpulse, xtxclkmux_hfclkn, xtxclkmux_hfclkp, xtxclkmux_lfclkn, xtxclkmux_lfclkp};

// the actual instance
   arriaii_hssi_pma_c_ser xser ( .cpulse(xser_cpulse),        
                             .data(xser_data_dprio),   
                             .div2(cram_rpma_doublewidth_tx),
                             .div5(cram_rpmadwidth_tx),
                             .hfclkn(xser_hfclkn),   
                             .hfclkp(xser_hfclkp),  
                             .lfclkn(xser_lfclkn),   
                             .lfclkp(xser_lfclkp),  
                             .pclk_in(xser_pclk),
                             .pclksel(cram_rpclksel),
                             .pdb(powerdn_in),   
                             .pre_em(cram_rpre_em_1t_no_pcie),   
                             .pre_em_2t(cram_rpre_em_2t), 
                             .pre_em_pretap(cram_rpre_em_pt),  
                             .rst_n(txpmareset_in),
                             .s_lpbk(xser_rs_lpbk),    
                             .vccelxqyx(vccelxqyx),    
                             .vccetxqyx(vsse),   
                             .vssexqyx(vsse),

                             .clk_divtx(xser_clk_divtx),           
                             .lbvon(xser_lbvon),  
                             .lbvop(xser_lbvop), 
                             .pre_en_out(xser_pre_en_out),
                             .von(xser_von),
                             .von_op1(xser_von_op1),
                             .von_op2(xser_von_op2),
                             .von_pre(xser_von_pre),
                             .vop(xser_vop),
                             .vop_op1(xser_vop_op1),
                             .vop_op2(xser_vop_op2),
                             .vop_pre(xser_vop_pre)
                            );   
    // 10g output wires
    wire xser_10g_clk_divtx;
    wire xser_10g_lbvon;
    wire xser_10g_von;
    wire xser_10g_von_op1;
    wire xser_10g_lbvop;
    wire xser_10g_vop;
    wire xser_10g_vop_op1;

    generate
    if (serialization_factor > 20)
    begin        
        arriaii_hssi_pma_c_ser_10g xser_10g ( .clk_skew(),
                                          .cpulse(xtxclkmux_cpulse),
                                          .cpulseb(~xtxclkmux_cpulse),
                                          .data_in(datain[63:0]),
                                          .hfclkn(xtxclkmux_hfclkn),
                                          .hfclkp(xtxclkmux_hfclkp),
                                          .lfclkn(xtxclkmux_lfclkn),
                                          .lfclkp(xtxclkmux_lfclkp),
                                          .pdb(powerdn_in),
                                          .pre_em(cram_rpre_em_1t_no_pcie),
                                          .rst_n(txpmareset_in),
                                          .s_lpbk(1'b1), // always enabled, for now
                                          .vccelxqyx(vccelxqyx),
                                          .vccetxqyx(vsse),
                                          .vssexqyx(vsse),
    
                                          .clk_divtx(xser_10g_clk_divtx),
                                          .lbvon(xser_10g_lbvon),
                                          .lbvop(xser_10g_lbvop),
                                          .von(xser_10g_von),
                                          .von_op1(xser_10g_von_op1),
                                          .vop(xser_10g_vop),
                                          .vop_op1(xser_10g_vop_op1)
                                         );    
    end
    endgenerate 
                              
    // serializer outputs
    assign clockout = serialization_factor > 20 ? xser_10g_clk_divtx : xser_clk_divtx;
    assign seriallpbkout = serialization_factor > 20 ? xser_10g_lbvop : xser_lbvop;

    // for the TX driver instance
    // input wires
    wire       xtx_bsmode;
    wire       xtx_bsoeb;
    wire       xtx_bstxn_in;
    wire       xtx_bstxp_in;
    wire       xtx_rlpbkn_em;
    wire       xtx_rlpbkp_em;
    wire [2:0] xtx_r_dft_sel;
    wire       xtx_r_dis_idlegate;
    wire       xtx_r_highv;
    wire       xtx_r_lowv;
    wire [3:0] xtx_rpre_em_2t;
    wire [3:0] xtx_rpre_em_pt;
    wire       xtx_rx_det_clk;
    wire       xtx_rx_n;
    wire       xtx_rx_p;
    wire [3:0] xtx_tx50;
    wire       xtx_vin;
    wire       xtx_vin_op1;
    wire       xtx_vip;
    wire       xtx_vip_op1;

    // inout wires
    wire       xtx_atb0;
    wire       xtx_atb1;
    wire       xtx_ib50uc_vcm;
    wire       xtx_ib50ut_vcm;
    wire       xtx_ib100uc;
    wire       xtx_ib50uc_rcvdt;
    wire       xtx_von;
    wire       xtx_vop;

    // output wires
    wire xtx_com_pass;
    wire xtx_detect_on;
    wire xtx_fixed_clk;
    wire xtx_probe_pass;
    wire xtx_rx_detect_valid;
    wire xtx_sel_150r;
    wire [6:1] xtx_tx_dftout;
    
    wire [31:0] vod_selection_bin; //use for int2bin function

    //temporarily generate rxdetectclk - fixed clock of 125 Mhz
    reg       rx_det_clk_reg; 
    initial 
    begin
        rx_det_clk_reg = 1'b0;
        forever
        begin
            #4000 rx_det_clk_reg = ~rx_det_clk_reg;
        end
    end
    assign xtx_rx_det_clk = rx_det_clk_reg;
    // end
    
    // get the inputs    
    assign xtx_rpre_em_2t = serialization_factor <= 20 ? cram_rpre_em_2t : 4'b0000;
    assign xtx_rpre_em_pt = serialization_factor <= 20 ? cram_rpre_em_pt : 4'b0000;
    assign vod_selection_bin = int2bin(vod_selection);

    assign xtx_vin = serialization_factor <= 20 ? xser_von : xser_10g_von;
    assign xtx_vin_op1 = serialization_factor <= 20 ? xser_von_op1 : xser_10g_von_op1;
    assign xtx_vip = serialization_factor <= 20 ? xser_vop : xser_10g_vop;
    assign xtx_vip_op1 = serialization_factor <= 20 ? xser_vop_op1 : xser_10g_vop_op1;

// the actual instance

   arriaii_hssi_pma_c_tx xtx ( .bsmode(xtx_bsmode),
                           .bsoeb(xtx_bsoeb),
                           .bstxn_in(xtx_bstxn_in),
                           .bstxp_in(xtx_bstxp_in),
                           .cgb_vccelxqyx(1'b1),
                           .cgb_vssexqyx(vsse),
                           .lst(cram_rtx_lst),
                           .pdb(powerdn_in),
                           .r_dft_sel(xtx_r_dft_sel),
                           .r_dis_idlegate(xtx_r_dis_idlegate),
                           .r_highv(xtx_r_highv),
                           .r_lowv(xtx_r_lowv),
                           .r_rx_det(cram_rrx_det),
                           .r_slew(cram_rslew),
                           .rlpbkn(~revserialfdbk),
                           .rlpbkn_em(xtx_rlpbkn_em),
                           .rlpbkp(revserialfdbk),
                           .rlpbkp_em(xtx_rlpbkp_em),
                           .rpre_em_1t(cram_rpre_em_1t_no_pcie),
                           .rpre_em_2t(xtx_rpre_em_2t),
                           .rpre_em_pt(xtx_rpre_em_pt),
                           .rsig_inv_2t(cram_rsig_inv_2t),
                           .rsig_inv_ptap(cram_rsig_inv_ptap),
                           .rterm_sel(cram_rtx_term_sel),
                           .rtx_rlpbk(cram_rs_lpbk), 
                           .rtx_vtt(cram_rtx_vtt),
                           .rvod_sel(vod_selection_bin[2:0]),
                           .rx_det_clk(xtx_rx_det_clk),
                           .rx_det_pdb(detectrxpowerdown_in),
                           .rx_n(xtx_rx_n),
                           .rx_p(xtx_rx_p),
                           .tx50(xtx_tx50),
                           .tx_det_rx(rxdetecten),
                           .tx_elec_idl(forceelecidle_in),
                           .vccehtxqyx(vsse),
                           .vccehxqyx(vsse),
                           .vccesdh_la(vsse),
                           .vccesdp_la(vsse),
                           .vccetxqyx(vsse),
                           .vin(xtx_vin),
                           .vin_po1(xtx_vin_op1),
                           .vin_po2(xser_von_op2),
                           .vin_pre(xser_von_pre),
                           .vip(xtx_vip),
                           .vip_po1(xtx_vip_op1),
                           .vip_po2(xser_vop_op2),
                           .vip_pre(xser_vop_pre),
                           .vssexqyx(vsse),

                           .atb0(xtx_atb0),
                           .atb1(xtx_atb1),
                           .ib50uc_rcvdt(xtx_ib50uc_rcvdt),
                           .ib50uc_vcm(xtx_ib50uc_vcm),
                           .ib50ut_vcm(xtx_ib50ut_vcm),
                           .ib100uc(xtx_ib100uc),
                           .von(xtx_von),
                           .vop(xtx_vop),

                           .com_pass(xtx_com_pass),
                           .detect_on(xtx_detect_on),
                           .fixed_clk_out(xtx_fixed_clk),
                           .probe_pass(xtx_probe_pass),
                           .rx_detect_valid(xtx_rx_detect_valid),
                           .rx_found(xtx_rx_found),
                           .sel_150r(xtx_sel_150r),
                           .tx_dftout(xtx_tx_dftout)
                         );

    // driver outputs
    assign dataout = xtx_vop;
    assign dftout = xtx_tx_dftout;
    assign rxdetectvalidout = xtx_rx_detect_valid;
    assign rxfoundout = xtx_rx_found;

// ---------------------------------------------------------------------------
//  Model Implementation End                                                 -
// ---------------------------------------------------------------------------


endmodule

// ***********************************************************
// This WYSIWYG atom header was automatically generated by the
// Atmgen build tool. To change it, alter data stored in the 
// corresponding WYS file(s) in the tools/atmgen subdirectory.
// ***********************************************************

// *** Section 1 -- Header ***

// -----------------------------------------------------------
//
// Module Name : arriaii_hssi_rx_pma
//
// Description : DEV_FAMILY_ARRIAII arriaii_hssi_rx_pma Verilog simulation model
//
// -----------------------------------------------------------

`timescale 1 ps/1 ps

// *** End of Section 1 ***

// *** Section 3 -- Module declaration ***

module arriaii_hssi_rx_pma(
            adaptcapture,
			adcepowerdn,
			adcereset,
			adcestandby,
			datain,
			deserclock,
			dpriodisable,
			dprioin,
			extra10gin,
			freqlock,
			ignorephslck,
			locktodata,
			locktoref,
			offsetcancellationen,
			plllocked,
			powerdn,
			ppmdetectdividedclk,
			ppmdetectrefclk,
			recoverdatain,
			rxpmareset,
			seriallpbken,
			seriallpbkin,
			testbussel,

			adaptdone,
			analogtestbus,
			clockout,
			dataout,
			dataoutfull,
			dprioout,
			locktorefout,
			ppmdetectclkrel,
			recoverdataout,
			reverselpbkout,
			revserialfdbkout,
			signaldetect 
		);

// *** End of Section 3 ***

// *** Section 4 -- Port size declarations ***

// Note: Variable port sizes dictated by parameters are not currently defined in
// the WYS file data. Busses are marked with the VARIABLE notation as a reminder.

`define  ADAPTCAPTURE_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  ADAPTDONE_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  ADCEPOWERDN_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  ADCERESET_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  ADCESTANDBY_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  ANALOGTESTBUS_PORTSIZE_CONST_arriaii_hssi_rx_pma  8		// * VARIABLE
`define  CLOCKOUT_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  DATAIN_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  DATAOUT_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  DATAOUTFULL_PORTSIZE_CONST_arriaii_hssi_rx_pma  20		// * VARIABLE
`define  DESERCLOCK_PORTSIZE_CONST_arriaii_hssi_rx_pma  4		// * VARIABLE
`define  DPRIODISABLE_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  DPRIOIN_PORTSIZE_CONST_arriaii_hssi_rx_pma  300		// * VARIABLE
`define  DPRIOOUT_PORTSIZE_CONST_arriaii_hssi_rx_pma  300		// * VARIABLE
`define  EXTRA10GIN_PORTSIZE_CONST_arriaii_hssi_rx_pma  38		// * VARIABLE
`define  FREQLOCK_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  IGNOREPHSLCK_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  LOCKTODATA_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  LOCKTOREF_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  LOCKTOREFOUT_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  OFFSETCANCELLATIONEN_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  PLLLOCKED_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  POWERDN_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  PPMDETECTCLKREL_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  PPMDETECTDIVIDEDCLK_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  PPMDETECTREFCLK_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  RECOVERDATAIN_PORTSIZE_CONST_arriaii_hssi_rx_pma  2		// * VARIABLE
`define  RECOVERDATAOUT_PORTSIZE_CONST_arriaii_hssi_rx_pma  64		// * VARIABLE
`define  REVERSELPBKOUT_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  REVSERIALFDBKOUT_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  RXPMARESET_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  SERIALLPBKEN_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  SERIALLPBKIN_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  SIGNALDETECT_PORTSIZE_CONST_arriaii_hssi_rx_pma  1		
`define  TESTBUSSEL_PORTSIZE_CONST_arriaii_hssi_rx_pma  4		// * VARIABLE

// *** End of Section 4 ***

// *** Section 5 -- Port declarations ***

input  adaptcapture;
input  adcepowerdn;
input  adcereset;
input  adcestandby;
input  datain;
input  [`DESERCLOCK_PORTSIZE_CONST_arriaii_hssi_rx_pma - 1 : 0] deserclock;
input  dpriodisable;
input  [`DPRIOIN_PORTSIZE_CONST_arriaii_hssi_rx_pma - 1 : 0] dprioin;
input  [`EXTRA10GIN_PORTSIZE_CONST_arriaii_hssi_rx_pma - 1 : 0] extra10gin;
input  freqlock;
input  ignorephslck;
input  locktodata;
input  locktoref;
input  offsetcancellationen;
input  plllocked;
input  powerdn;
input  ppmdetectdividedclk;
input  ppmdetectrefclk;
input  [`RECOVERDATAIN_PORTSIZE_CONST_arriaii_hssi_rx_pma - 1 : 0] recoverdatain;
input  rxpmareset;
input  seriallpbken;
input  seriallpbkin;
input  [`TESTBUSSEL_PORTSIZE_CONST_arriaii_hssi_rx_pma - 1 : 0] testbussel;
output adaptdone;
output [`ANALOGTESTBUS_PORTSIZE_CONST_arriaii_hssi_rx_pma - 1 : 0] analogtestbus;
output clockout;
output dataout;
output [`DATAOUTFULL_PORTSIZE_CONST_arriaii_hssi_rx_pma - 1 : 0] dataoutfull;
output [`DPRIOOUT_PORTSIZE_CONST_arriaii_hssi_rx_pma - 1 : 0] dprioout;
output locktorefout;
output ppmdetectclkrel;
output [`RECOVERDATAOUT_PORTSIZE_CONST_arriaii_hssi_rx_pma - 1 : 0] recoverdataout;
output reverselpbkout;
output revserialfdbkout;
output signaldetect;

// *** End of Section 5 ***

// *** Section 6 -- Parameter declarations and default values ***

parameter lpm_type = "arriaii_hssi_rx_pma";
parameter adaptive_equalization_mode = "none";
parameter allow_serial_loopback = "false";
parameter allow_vco_bypass =  0 ;
parameter analog_power = "1.4V";
parameter channel_number =  0 ;
parameter channel_type = "auto";
parameter common_mode = "0.82V";
parameter deserialization_factor =  8 ;
parameter dfe_piclk_bandwidth =  0 ;
parameter dfe_piclk_phase =  0 ;
parameter dfe_piclk_sel =  0 ;
parameter dprio_config_mode =  06'b000000 ;
parameter enable_ltd = "false";
parameter enable_ltr = "false";
parameter eq_adapt_seq_control =  0 ;
parameter eq_dc_gain =  0 ;
parameter eq_max_gradient_control =  0 ;
parameter eqa_ctrl =  0 ;
parameter eqb_ctrl =  0 ;
parameter eqc_ctrl =  0 ;
parameter eqd_ctrl =  0 ;
parameter eqv_ctrl =  0 ;
parameter eyemon_bandwidth =  0 ;
parameter force_signal_detect = "true";
parameter ignore_lock_detect = "false";
parameter logical_channel_address =  0 ;
parameter low_speed_test_select =  0 ;
parameter offset_cancellation =  0 ;
parameter ppm_gen1_2_xcnt_en =  0 ;
parameter ppm_post_eidle =  0 ;
parameter ppmselect =  0 ;
parameter protocol_hint = "basic";
parameter send_direct_reverse_serial_loopback = "None";
parameter signal_detect_hysteresis =  4 ;
parameter signal_detect_hysteresis_valid_threshold =  2 ;
parameter signal_detect_loss_threshold =  3 ;
parameter termination = "OCT 100 Ohms";
parameter use_deser_double_data_width = "false";
parameter use_external_termination = "false";
parameter use_pma_direct = "false";

// *** End of Section 6 ***

// *** Section 7 -- Port declarations with defaults, if any ***

// This section will always be empty for WYSIWYG atoms
// tri1 devclrn;		//sample

// *** End of Section 7 ***
`define ARRIAII_HSSI_RX_PMA_ALPHA_TOLOWER_WORD_LENGTH 25

// ---------------------------------------------------------------------------
//  New DPRIO Begin 
// ---------------------------------------------------------------------------

// Table36: PMA Per Channel RX Control Register 1 for Channel 0
`define rrx_term_sel_RXPMA_IDX_0 		0
`define rrx_term_sel_RXPMA_IDX_1 		1
`define rrx_term_sel_RXPMA_IDX_2 		2
`define rrx_vtt_RXPMA_IDX_0 		3
`define rrx_vtt_RXPMA_IDX_1 		4
`define rrx_vtt_RXPMA_IDX_2 		5
`define rrx_s_rdlpbk_RXPMA_IDX_0 		6
`define rrx_bit_dc_RXPMA_IDX_0 		7
`define rrx_bit_dc_RXPMA_IDX_1 		8
`define rrx_bit_dc_RXPMA_IDX_2 		9
`define rrx_bit_dc_RXPMA_IDX_3 		10
`define rrx_lst_RXPMA_IDX_0 		11
`define rrx_lst_RXPMA_IDX_1 		12
`define rrx_lst_RXPMA_IDX_2 		13
`define rrx_lst_RXPMA_IDX_3 		14
`define rrx_lst_RXPMA_IDX_4 		15

// Table37: PMA Per Channel RX Control Register 2 for Channel 0
`define rrxurstpma_RXPMA_IDX_0 		16
`define rrx_test_RXPMA_IDX_0 		17
`define rrx_sd_force_RXPMA_IDX_0 		18
`define rrx_oc_RXPMA_IDX_0 		19
`define rrx_oc_RXPMA_IDX_1 		20
`define rrx_oc_RXPMA_IDX_2 		21
`define rrx_oc_RXPMA_IDX_3 		22
`define rrx_oc_RXPMA_IDX_4 		23
`define rrx_oc_RXPMA_IDX_5 		24
`define rrx_oc_RXPMA_IDX_6 		25
`define rrx_oc_RXPMA_IDX_7 		26
`define rrx_oc_en_RXPMA_IDX_0 		27
`define rrx_sdlv_RXPMA_IDX_0 		28
`define rrx_sdlv_RXPMA_IDX_1 		29
`define rrx_sdlv_RXPMA_IDX_2 		30
`define rrx_sdlv_RXPMA_IDX_3 		31

// Table38: PMA Per Channel RX Control Register 3 for Channel 0
`define reserved_0_TB38_RXPMA_IDX_0 		32
`define reserved_0_TB38_RXPMA_IDX_1 		33
`define reserved_0_TB38_RXPMA_IDX_2 		34
`define rpowdnr_RXPMA_IDX_0 		35
`define rrx_ib_pdb_RXPMA_IDX_0 		36
`define rurx_pdb_RXPMA_IDX_0 		37
`define rrx_oc_calpd_RXPMA_IDX_0 		38
`define rrx_sd_off_RXPMA_IDX_0 		39
`define rrx_sd_off_RXPMA_IDX_1 		40
`define rrx_sd_off_RXPMA_IDX_2 		41
`define rrx_sd_off_RXPMA_IDX_3 		42
`define rrx_sd_off_RXPMA_IDX_4 		43
`define rrx_sd_on_RXPMA_IDX_0 		44
`define rrx_sd_on_RXPMA_IDX_1 		45
`define rrx_sd_on_RXPMA_IDX_2 		46
`define rrx_sd_on_RXPMA_IDX_3 		47

// Table43: PMA Per Channel RX Control Register 8 for Channel 0
`define reye_monitor_RXPMA_IDX_0 		112
`define reye_monitor_RXPMA_IDX_1 		113
`define reye_monitor_RXPMA_IDX_2 		114
`define reye_monitor_RXPMA_IDX_3 		115
`define reye_monitor_RXPMA_IDX_4 		116
`define reye_monitor_RXPMA_IDX_5 		117
`define reye_monitor_RXPMA_IDX_6 		118
`define reye_monitor_RXPMA_IDX_7 		119
`define reserved_0_TB43_RXPMA_IDX_0 		120
`define reserved_0_TB43_RXPMA_IDX_1 		121
`define reserved_0_TB43_RXPMA_IDX_2 		122
`define reserved_0_TB43_RXPMA_IDX_3 		123
`define reserved_0_TB43_RXPMA_IDX_4 		124
`define reserved_0_TB43_RXPMA_IDX_5 		125
`define reserved_0_TB43_RXPMA_IDX_6 		126
`define reserved_0_TB43_RXPMA_IDX_7 		127

// Table44: PMA Per Channel RX Control Register 9 for Channel 0
`define rpma_reserved_0_TB44_RXPMA_IDX_0 		128
`define rpma_reserved_0_TB44_RXPMA_IDX_1 		129
`define rpma_reserved_0_TB44_RXPMA_IDX_2 		130
`define rpma_reserved_0_TB44_RXPMA_IDX_3 		131
`define rpma_reserved_0_TB44_RXPMA_IDX_4 		132
`define rpma_reserved_0_TB44_RXPMA_IDX_5 		133
`define rpma_reserved_0_TB44_RXPMA_IDX_6 		134
`define rpma_reserved_0_TB44_RXPMA_IDX_7 		135
`define rpma_reserved_0_TB44_RXPMA_IDX_8 		136
`define rpma_reserved_0_TB44_RXPMA_IDX_9 		137
`define rpma_reserved_0_TB44_RXPMA_IDX_10 		138
`define rpma_reserved_0_TB44_RXPMA_IDX_11 		139
`define rpma_reserved_0_TB44_RXPMA_IDX_12 		140
`define rpma_reserved_0_TB44_RXPMA_IDX_13 		141
`define rpma_reserved_0_TB44_RXPMA_IDX_14 		142
`define rpma_reserved_0_TB44_RXPMA_IDX_15 		143

// Table45: PMA Per Channel RX Control Register 10 for Channel 0
`define rppm_cnt_reset_RXPMA_IDX_0 		144
`define rforce1_freqdet_RXPMA_IDX_0 		145
`define rforce0_freqdet_RXPMA_IDX_0 		146
`define rppmsel_RXPMA_IDX_0 		147
`define rppmsel_RXPMA_IDX_1 		148
`define rppmsel_RXPMA_IDX_2 		149
`define rppmsel_RXPMA_IDX_3 		150
`define rppmsel_RXPMA_IDX_4 		151
`define rppmsel_RXPMA_IDX_5 		152
`define rfastsd_RXPMA_IDX_0 		153
`define rfastsd_RXPMA_IDX_1 		154
`define rfastsd_RXPMA_IDX_2 		155
`define rfastsd_RXPMA_IDX_3 		156
`define rtest_fastsd_RXPMA_IDX_0 		157
`define rpmadwidth_rx_RXPMA_IDX_0 		158
`define rpma_doublewidth_rx_RXPMA_IDX_0 		159

// Table46: PMA Per Channel RX Control Register 11 for Channel 0
`define reserved_0_TB46_RXPMA_IDX_0 		160
`define reserved_0_TB46_RXPMA_IDX_1 		161
`define reserved_0_TB46_RXPMA_IDX_2 		162
`define reserved_0_TB46_RXPMA_IDX_3 		163
`define reserved_0_TB46_RXPMA_IDX_4 		164
`define reserved_0_TB46_RXPMA_IDX_5 		165
`define reserved_0_TB46_RXPMA_IDX_6 		166
`define reserved_0_TB46_RXPMA_IDX_7 		167
`define rppm_gen1_2xcnt_en_RXPMA_IDX_0 		168
`define rppm_post_eidle_del_RXPMA_IDX_0 		169
`define r_dfe_2t_RXPMA_IDX_0 		170
`define r_dfe_2t_RXPMA_IDX_1 		171
`define r_dfe_2t_RXPMA_IDX_2 		172
`define r_dfe_1t_RXPMA_IDX_0 		173
`define r_dfe_1t_RXPMA_IDX_1 		174
`define r_dfe_1t_RXPMA_IDX_2 		175

// Table47: PMA Per Channel RX Control Register 12 for Channel 0
`define reqv_set_RXPMA_IDX_0 		176
`define reqv_set_RXPMA_IDX_1 		177
`define reqv_set_RXPMA_IDX_2 		178
`define reqd_set_RXPMA_IDX_0 		179
`define reqd_set_RXPMA_IDX_1 		180
`define reqd_set_RXPMA_IDX_2 		181
`define reqc_set_RXPMA_IDX_0 		182
`define reqc_set_RXPMA_IDX_1 		183
`define reqc_set_RXPMA_IDX_2 		184
`define reqb_set_RXPMA_IDX_0 		185
`define reqb_set_RXPMA_IDX_1 		186
`define reqb_set_RXPMA_IDX_2 		187
`define reqa_set_RXPMA_IDX_0 		188
`define reqa_set_RXPMA_IDX_1 		189
`define reqa_set_RXPMA_IDX_2 		190
`define reserved_0_TB47_RXPMA_IDX_0 		191

// Table48: PMA Per Channel RX Control Register 13 for Channel 0
`define rdc_freq_RXPMA_IDX_0 		192
`define rdc_freq_RXPMA_IDX_1 		193
`define rhyst_lf_RXPMA_IDX_0 		194
`define rhyst_lf_RXPMA_IDX_1 		195
`define rhyst_lf_RXPMA_IDX_2 		196
`define rclkdiv_RXPMA_IDX_0 		197
`define rclkdiv_RXPMA_IDX_1 		198
`define rclkdiv_RXPMA_IDX_2 		199
`define rclkdiv_RXPMA_IDX_3 		200
`define rrgen_set_RXPMA_IDX_0 		201
`define rrgen_set_RXPMA_IDX_1 		202
`define rrgen_set_RXPMA_IDX_2 		203
`define radce_adapt_RXPMA_IDX_0 		204
`define rseq_sel_RXPMA_IDX_0 		205
`define rseq_sel_RXPMA_IDX_1 		206
`define rlock_lf_ovd_RXPMA_IDX_0 		207

// Table49: PMA Per Channel RX Control Register 14 for Channel 0
`define rrgen_vod_RXPMA_IDX_0 		208
`define rrgen_vod_RXPMA_IDX_1 		209
`define rrgen_vod_RXPMA_IDX_2 		210
`define rf_hpf_RXPMA_IDX_0 		211
`define rf_hpf_RXPMA_IDX_1 		212
`define rf_lpf_RXPMA_IDX_0 		213
`define rf_lpf_RXPMA_IDX_1 		214
`define reserved_1_TB49_RXPMA_IDX_0 		215
`define reserved_1_TB49_RXPMA_IDX_1 		216
`define reserved_1_TB49_RXPMA_IDX_2 		217
`define reserved_0_TB49_RXPMA_IDX_0 		218
`define reserved_0_TB49_RXPMA_IDX_1 		219
`define reserved_0_TB49_RXPMA_IDX_2 		220
`define rhyst_hf_RXPMA_IDX_0 		221
`define rhyst_hf_RXPMA_IDX_1 		222
`define rhyst_hf_RXPMA_IDX_2 		223

// Table50: PMA Per Channel RX Control Register 15 for Channel 0
`define radce_pdb_RXPMA_IDX_0 		224
`define radce_rst_RXPMA_IDX_0 		225
`define rhf_os_RXPMA_IDX_0 		226
`define rhf_os_RXPMA_IDX_1 		227
`define rhf_os_RXPMA_IDX_2 		228
`define rhf_os_RXPMA_IDX_3 		229
`define rlf_os_RXPMA_IDX_0 		230
`define rlf_os_RXPMA_IDX_1 		231
`define rlf_os_RXPMA_IDX_2 		232
`define rlf_os_RXPMA_IDX_3 		233
`define rd2a_res_RXPMA_IDX_0 		234
`define rd2a_res_RXPMA_IDX_1 		235
`define rrect_adj_RXPMA_IDX_0 		236
`define rrect_adj_RXPMA_IDX_1 		237
`define rrgen_bw_RXPMA_IDX_0 		238
`define rrgen_bw_RXPMA_IDX_1 		239

// Table51: PMA Per Channel RX Control Register 16 for Channel 0
`define radce_hflck_RXPMA_IDX_0 		240
`define radce_hflck_RXPMA_IDX_1 		241
`define radce_hflck_RXPMA_IDX_2 		242
`define radce_hflck_RXPMA_IDX_3 		243
`define radce_hflck_RXPMA_IDX_4 		244
`define radce_hflck_RXPMA_IDX_5 		245
`define radce_hflck_RXPMA_IDX_6 		246
`define radce_hflck_RXPMA_IDX_7 		247
`define radce_hflck_RXPMA_IDX_8 		248
`define radce_hflck_RXPMA_IDX_9 		249
`define radce_hflck_RXPMA_IDX_10 		250
`define radce_hflck_RXPMA_IDX_11 		251
`define radce_hflck_RXPMA_IDX_12 		252
`define radce_hflck_RXPMA_IDX_13 		253
`define radce_hflck_RXPMA_IDX_14 		254
`define reserved_0_TB51_RXPMA_IDX_0 		255

// Table52: PMA Per Channel RX Control Register 17 for Channel 0
`define radce_lflck_RXPMA_IDX_0 		256
`define radce_lflck_RXPMA_IDX_1 		257
`define radce_lflck_RXPMA_IDX_2 		258
`define radce_lflck_RXPMA_IDX_3 		259
`define radce_lflck_RXPMA_IDX_4 		260
`define radce_lflck_RXPMA_IDX_5 		261
`define radce_lflck_RXPMA_IDX_6 		262
`define radce_lflck_RXPMA_IDX_7 		263
`define radce_lflck_RXPMA_IDX_8 		264
`define radce_lflck_RXPMA_IDX_9 		265
`define radce_lflck_RXPMA_IDX_10 		266
`define radce_lflck_RXPMA_IDX_11 		267
`define radce_lflck_RXPMA_IDX_12 		268
`define radce_lflck_RXPMA_IDX_13 		269
`define radce_lflck_RXPMA_IDX_14 		270
`define reserved_0_TB52_RXPMA_IDX_0 		271

// Table53: PMA Per Channel RX Control Register 18 for Channel 0
`define radce_digital_RXPMA_IDX_0 		272
`define radce_digital_RXPMA_IDX_1 		273
`define radce_digital_RXPMA_IDX_2 		274
`define radce_digital_RXPMA_IDX_3 		275
`define radce_digital_RXPMA_IDX_4 		276
`define radce_digital_RXPMA_IDX_5 		277
`define radce_digital_RXPMA_IDX_6 		278
`define radce_digital_RXPMA_IDX_7 		279
`define radce_digital_RXPMA_IDX_8 		280
`define radce_digital_RXPMA_IDX_9 		281
`define reserved_0_TB53_RXPMA_IDX_0 		282
`define reserved_0_TB53_RXPMA_IDX_1 		283
`define reserved_0_TB53_RXPMA_IDX_2 		284
`define reserved_0_TB53_RXPMA_IDX_3 		285
`define reserved_0_TB53_RXPMA_IDX_4 		286
`define reserved_0_TB53_RXPMA_IDX_5 		287

// Extra
`define RLPBK_RXPMA_IDX                    290
`define RREVLB_SW_RXPMA_IDX                291
`define RRX_S_LPBK_RXPMA_IDX               292

// ---------------------------------------------------------------------------
// DPRIO input CRAM  
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 1 for Channel 0
wire [2:0] dprioin_rrx_term_sel;
wire [2:0] dprioin_rrx_vtt;
wire dprioin_rrx_s_rdlpbk;
wire [3:0] dprioin_rrx_bit_dc;
wire [4:0] dprioin_rrx_lst;

// PMA Per Channel RX Control Register 2 for Channel 0
wire dprioin_rrxurstpma;
wire dprioin_rrx_test;
wire dprioin_rrx_sd_force;
wire [7:0] dprioin_rrx_oc;
wire dprioin_rrx_oc_en;
wire [3:0] dprioin_rrx_sdlv;

// PMA Per Channel RX Control Register 3 for Channel 0
wire [2:0] dprioin_reserved_0_TB38;
wire dprioin_rpowdnr;
wire dprioin_rrx_ib_pdb;
wire dprioin_rurx_pdb;
wire dprioin_rrx_oc_calpd;
wire [4:0] dprioin_rrx_sd_off;
wire [3:0] dprioin_rrx_sd_on;

// PMA Per Channel RX Control Register 8 for Channel 0
wire [7:0] dprioin_reye_monitor;
wire [7:0] dprioin_reserved_0_TB43;

// PMA Per Channel RX Control Register 9 for Channel 0
wire [15:0] dprioin_rpma_reserved_0_TB44;

// PMA Per Channel RX Control Register 10 for Channel 0
wire dprioin_rppm_cnt_reset;
wire dprioin_rforce1_freqdet;
wire dprioin_rforce0_freqdet;
wire [5:0] dprioin_rppmsel;
wire [3:0] dprioin_rfastsd;
wire dprioin_rtest_fastsd;
wire dprioin_rpmadwidth_rx;
wire dprioin_rpma_doublewidth_rx;

// PMA Per Channel RX Control Register 11 for Channel 0
wire [7:0] dprioin_reserved_0_TB46;
wire dprioin_rppm_gen1_2xcnt_en;
wire dprioin_rppm_post_eidle_del;
wire [2:0] dprioin_r_dfe_2t;
wire [2:0] dprioin_r_dfe_1t;

// PMA Per Channel RX Control Register 12 for Channel 0
wire [2:0] dprioin_reqv_set;
wire [2:0] dprioin_reqd_set;
wire [2:0] dprioin_reqc_set;
wire [2:0] dprioin_reqb_set;
wire [2:0] dprioin_reqa_set;
wire dprioin_reserved_0_TB47;

// PMA Per Channel RX Control Register 13 for Channel 0
wire [1:0] dprioin_rdc_freq;
wire [2:0] dprioin_rhyst_lf;
wire [3:0] dprioin_rclkdiv;
wire [2:0] dprioin_rrgen_set;
wire dprioin_radce_adapt;
wire [1:0] dprioin_rseq_sel;
wire dprioin_rlock_lf_ovd;

// PMA Per Channel RX Control Register 14 for Channel 0
wire [2:0] dprioin_rrgen_vod;
wire [1:0] dprioin_rf_hpf;
wire [1:0] dprioin_rf_lpf;
wire [2:0] dprioin_reserved_1_TB49;
wire [2:0] dprioin_reserved_0_TB49;
wire [2:0] dprioin_rhyst_hf;

// PMA Per Channel RX Control Register 15 for Channel 0
wire dprioin_radce_pdb;
wire dprioin_radce_rst;
wire [3:0] dprioin_rhf_os;
wire [3:0] dprioin_rlf_os;
wire [1:0] dprioin_rd2a_res;
wire [1:0] dprioin_rrect_adj;
wire [1:0] dprioin_rrgen_bw;

// PMA Per Channel RX Control Register 16 for Channel 0
wire [14:0] dprioin_radce_hflck;
wire dprioin_reserved_0_TB51;

// PMA Per Channel RX Control Register 17 for Channel 0
wire [14:0] dprioin_radce_lflck;
wire dprioin_reserved_0_TB52;

// PMA Per Channel RX Control Register 18 for Channel 0
wire [9:0] dprioin_radce_digital;
wire [5:0] dprioin_reserved_0_TB53;

// Extra
wire dprioin_rlpbk;
wire dprioin_rrevlb_sw;
wire dprioin_rrx_s_lpbk;

// ---------------------------------------------------------------------------
// Initial CRAM  
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 1 for Channel 0
reg [2:0] init_rrx_term_sel;
reg [2:0] init_rrx_vtt;
reg init_rrx_s_rdlpbk;
reg [3:0] init_rrx_bit_dc;
reg [4:0] init_rrx_lst;

// PMA Per Channel RX Control Register 2 for Channel 0
reg init_rrxurstpma;
reg init_rrx_test;
reg init_rrx_sd_force;
reg [7:0] init_rrx_oc;
reg init_rrx_oc_en;
reg [3:0] init_rrx_sdlv;

// PMA Per Channel RX Control Register 3 for Channel 0
reg [2:0] init_reserved_0_TB38;
reg init_rpowdnr;
reg init_rrx_ib_pdb;
reg init_rurx_pdb;
reg init_rrx_oc_calpd;
reg [4:0] init_rrx_sd_off;
reg [3:0] init_rrx_sd_on;

// PMA Per Channel RX Control Register 8 for Channel 0
reg [7:0] init_reye_monitor;
reg [7:0] init_reserved_0_TB43;

// PMA Per Channel RX Control Register 9 for Channel 0
reg [15:0] init_rpma_reserved_0_TB44;

// PMA Per Channel RX Control Register 10 for Channel 0
reg init_rppm_cnt_reset;
reg init_rforce1_freqdet;
reg init_rforce0_freqdet;
reg [5:0] init_rppmsel;
reg [3:0] init_rfastsd;
reg init_rtest_fastsd;
reg init_rpmadwidth_rx;
reg init_rpma_doublewidth_rx;

// PMA Per Channel RX Control Register 11 for Channel 0
reg [7:0] init_reserved_0_TB46;
reg init_rppm_gen1_2xcnt_en;
reg init_rppm_post_eidle_del;
reg [2:0] init_r_dfe_2t;
reg [2:0] init_r_dfe_1t;

// PMA Per Channel RX Control Register 12 for Channel 0
reg [2:0] init_reqv_set;
reg [2:0] init_reqd_set;
reg [2:0] init_reqc_set;
reg [2:0] init_reqb_set;
reg [2:0] init_reqa_set;
reg init_reserved_0_TB47;

// PMA Per Channel RX Control Register 13 for Channel 0
reg [1:0] init_rdc_freq;
reg [2:0] init_rhyst_lf;
reg [3:0] init_rclkdiv;
reg [2:0] init_rrgen_set;
reg init_radce_adapt;
reg [1:0] init_rseq_sel;
reg init_rlock_lf_ovd;

// PMA Per Channel RX Control Register 14 for Channel 0
reg [2:0] init_rrgen_vod;
reg [1:0] init_rf_hpf;
reg [1:0] init_rf_lpf;
reg [2:0] init_reserved_1_TB49;
reg [2:0] init_reserved_0_TB49;
reg [2:0] init_rhyst_hf;

// PMA Per Channel RX Control Register 15 for Channel 0
reg init_radce_pdb;
reg init_radce_rst;
reg [3:0] init_rhf_os;
reg [3:0] init_rlf_os;
reg [1:0] init_rd2a_res;
reg [1:0] init_rrect_adj;
reg [1:0] init_rrgen_bw;

// PMA Per Channel RX Control Register 16 for Channel 0
reg [14:0] init_radce_hflck;
reg init_reserved_0_TB51;

// PMA Per Channel RX Control Register 17 for Channel 0
reg [14:0] init_radce_lflck;
reg init_reserved_0_TB52;

// PMA Per Channel RX Control Register 18 for Channel 0
reg [9:0] init_radce_digital;
reg [5:0] init_reserved_0_TB53;

// Extra
reg init_rlpbk;
reg init_rrevlb_sw;
reg init_rrx_s_lpbk;

// ---------------------------------------------------------------------------
// CRAM  
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 1 for Channel 0
wire [2:0] cram_rrx_term_sel;
wire [2:0] cram_rrx_vtt;
wire cram_rrx_s_rdlpbk;
wire [3:0] cram_rrx_bit_dc;
wire [4:0] cram_rrx_lst;

// PMA Per Channel RX Control Register 2 for Channel 0
wire cram_rrxurstpma;
wire cram_rrx_test;
wire cram_rrx_sd_force;
wire [7:0] cram_rrx_oc;
wire cram_rrx_oc_en;
wire [3:0] cram_rrx_sdlv;

// PMA Per Channel RX Control Register 3 for Channel 0
wire [2:0] cram_reserved_0_TB38;
wire cram_rpowdnr;
wire cram_rrx_ib_pdb;
wire cram_rurx_pdb;
wire cram_rrx_oc_calpd;
wire [4:0] cram_rrx_sd_off;
wire [3:0] cram_rrx_sd_on;

// PMA Per Channel RX Control Register 8 for Channel 0
wire [7:0] cram_reye_monitor;
wire [7:0] cram_reserved_0_TB43;

// PMA Per Channel RX Control Register 9 for Channel 0
wire [15:0] cram_rpma_reserved_0_TB44;

// PMA Per Channel RX Control Register 10 for Channel 0
wire cram_rppm_cnt_reset;
wire cram_rforce1_freqdet;
wire cram_rforce0_freqdet;
wire [5:0] cram_rppmsel;
wire [3:0] cram_rfastsd;
wire cram_rtest_fastsd;
wire cram_rpmadwidth_rx;
wire cram_rpma_doublewidth_rx;

// PMA Per Channel RX Control Register 11 for Channel 0
wire [7:0] cram_reserved_0_TB46;
wire cram_rppm_gen1_2xcnt_en;
wire cram_rppm_post_eidle_del;
wire [2:0] cram_r_dfe_2t;
wire [2:0] cram_r_dfe_1t;

// PMA Per Channel RX Control Register 12 for Channel 0
wire [2:0] cram_reqv_set;
wire [2:0] cram_reqd_set;
wire [2:0] cram_reqc_set;
wire [2:0] cram_reqb_set;
wire [2:0] cram_reqa_set;
wire cram_reserved_0_TB47;

// PMA Per Channel RX Control Register 13 for Channel 0
wire [1:0] cram_rdc_freq;
wire [2:0] cram_rhyst_lf;
wire [3:0] cram_rclkdiv;
wire [2:0] cram_rrgen_set;
wire cram_radce_adapt;
wire [1:0] cram_rseq_sel;
wire cram_rlock_lf_ovd;

// PMA Per Channel RX Control Register 14 for Channel 0
wire [2:0] cram_rrgen_vod;
wire [1:0] cram_rf_hpf;
wire [1:0] cram_rf_lpf;
wire [2:0] cram_reserved_1_TB49;
wire [2:0] cram_reserved_0_TB49;
wire [2:0] cram_rhyst_hf;

// PMA Per Channel RX Control Register 15 for Channel 0
wire cram_radce_pdb;
wire cram_radce_rst;
wire [3:0] cram_rhf_os;
wire [3:0] cram_rlf_os;
wire [1:0] cram_rd2a_res;
wire [1:0] cram_rrect_adj;
wire [1:0] cram_rrgen_bw;

// PMA Per Channel RX Control Register 16 for Channel 0
wire [14:0] cram_radce_hflck;
wire cram_reserved_0_TB51;

// PMA Per Channel RX Control Register 17 for Channel 0
wire [14:0] cram_radce_lflck;
wire cram_reserved_0_TB52;

// PMA Per Channel RX Control Register 18 for Channel 0
wire [9:0] cram_radce_digital;
wire [5:0] cram_reserved_0_TB53;

// Extra
wire cram_rlpbk;
wire cram_rrevlb_sw;
wire cram_rrx_s_lpbk;

// ---------------------------------------------------------------------------
// Set DPRIO CRAM input from dprioin  
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 1 for Channel 0
assign dprioin_rrx_term_sel	= dprioin[`rrx_term_sel_RXPMA_IDX_2 : `rrx_term_sel_RXPMA_IDX_0];
assign dprioin_rrx_vtt	= dprioin[`rrx_vtt_RXPMA_IDX_2 : `rrx_vtt_RXPMA_IDX_0];
assign dprioin_rrx_s_rdlpbk	= dprioin[`rrx_s_rdlpbk_RXPMA_IDX_0];
assign dprioin_rrx_bit_dc	= dprioin[`rrx_bit_dc_RXPMA_IDX_3 : `rrx_bit_dc_RXPMA_IDX_0];
assign dprioin_rrx_lst	= dprioin[`rrx_lst_RXPMA_IDX_4 : `rrx_lst_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 2 for Channel 0
assign dprioin_rrxurstpma	= dprioin[`rrxurstpma_RXPMA_IDX_0];
assign dprioin_rrx_test	= dprioin[`rrx_test_RXPMA_IDX_0];
assign dprioin_rrx_sd_force	= dprioin[`rrx_sd_force_RXPMA_IDX_0];
assign dprioin_rrx_oc	= dprioin[`rrx_oc_RXPMA_IDX_7 : `rrx_oc_RXPMA_IDX_0];
assign dprioin_rrx_oc_en	= dprioin[`rrx_oc_en_RXPMA_IDX_0];
assign dprioin_rrx_sdlv	= dprioin[`rrx_sdlv_RXPMA_IDX_3 : `rrx_sdlv_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 3 for Channel 0
assign dprioin_reserved_0_TB38	= dprioin[`reserved_0_TB38_RXPMA_IDX_2 : `reserved_0_TB38_RXPMA_IDX_0];
assign dprioin_rpowdnr	= dprioin[`rpowdnr_RXPMA_IDX_0];
assign dprioin_rrx_ib_pdb	= dprioin[`rrx_ib_pdb_RXPMA_IDX_0];
assign dprioin_rurx_pdb	= dprioin[`rurx_pdb_RXPMA_IDX_0];
assign dprioin_rrx_oc_calpd	= dprioin[`rrx_oc_calpd_RXPMA_IDX_0];
assign dprioin_rrx_sd_off	= dprioin[`rrx_sd_off_RXPMA_IDX_4 : `rrx_sd_off_RXPMA_IDX_0];
assign dprioin_rrx_sd_on	= dprioin[`rrx_sd_on_RXPMA_IDX_3 : `rrx_sd_on_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 8 for Channel 0
assign dprioin_reye_monitor	= dprioin[`reye_monitor_RXPMA_IDX_7 : `reye_monitor_RXPMA_IDX_0];
assign dprioin_reserved_0_TB43	= dprioin[`reserved_0_TB43_RXPMA_IDX_7 : `reserved_0_TB43_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 9 for Channel 0
assign dprioin_rpma_reserved_0_TB44	= dprioin[`rpma_reserved_0_TB44_RXPMA_IDX_15 : `rpma_reserved_0_TB44_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 10 for Channel 0
assign dprioin_rppm_cnt_reset	= dprioin[`rppm_cnt_reset_RXPMA_IDX_0];
assign dprioin_rforce1_freqdet	= dprioin[`rforce1_freqdet_RXPMA_IDX_0];
assign dprioin_rforce0_freqdet	= dprioin[`rforce0_freqdet_RXPMA_IDX_0];
assign dprioin_rppmsel	= dprioin[`rppmsel_RXPMA_IDX_5 : `rppmsel_RXPMA_IDX_0];
assign dprioin_rfastsd	= dprioin[`rfastsd_RXPMA_IDX_3 : `rfastsd_RXPMA_IDX_0];
assign dprioin_rtest_fastsd	= dprioin[`rtest_fastsd_RXPMA_IDX_0];
assign dprioin_rpmadwidth_rx	= dprioin[`rpmadwidth_rx_RXPMA_IDX_0];
assign dprioin_rpma_doublewidth_rx	= dprioin[`rpma_doublewidth_rx_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 11 for Channel 0
assign dprioin_reserved_0_TB46	= dprioin[`reserved_0_TB46_RXPMA_IDX_7 : `reserved_0_TB46_RXPMA_IDX_0];
assign dprioin_rppm_gen1_2xcnt_en	= dprioin[`rppm_gen1_2xcnt_en_RXPMA_IDX_0];
assign dprioin_rppm_post_eidle_del	= dprioin[`rppm_post_eidle_del_RXPMA_IDX_0];
assign dprioin_r_dfe_2t	= dprioin[`r_dfe_2t_RXPMA_IDX_2 : `r_dfe_2t_RXPMA_IDX_0];
assign dprioin_r_dfe_1t	= dprioin[`r_dfe_1t_RXPMA_IDX_2 : `r_dfe_1t_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 12 for Channel 0
assign dprioin_reqv_set	= dprioin[`reqv_set_RXPMA_IDX_2 : `reqv_set_RXPMA_IDX_0];
assign dprioin_reqd_set	= dprioin[`reqd_set_RXPMA_IDX_2 : `reqd_set_RXPMA_IDX_0];
assign dprioin_reqc_set	= dprioin[`reqc_set_RXPMA_IDX_2 : `reqc_set_RXPMA_IDX_0];
assign dprioin_reqb_set	= dprioin[`reqb_set_RXPMA_IDX_2 : `reqb_set_RXPMA_IDX_0];
assign dprioin_reqa_set	= dprioin[`reqa_set_RXPMA_IDX_2 : `reqa_set_RXPMA_IDX_0];
assign dprioin_reserved_0_TB47	= dprioin[`reserved_0_TB47_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 13 for Channel 0
assign dprioin_rdc_freq	= dprioin[`rdc_freq_RXPMA_IDX_1 : `rdc_freq_RXPMA_IDX_0];
assign dprioin_rhyst_lf	= dprioin[`rhyst_lf_RXPMA_IDX_2 : `rhyst_lf_RXPMA_IDX_0];
assign dprioin_rclkdiv	= dprioin[`rclkdiv_RXPMA_IDX_3 : `rclkdiv_RXPMA_IDX_0];
assign dprioin_rrgen_set	= dprioin[`rrgen_set_RXPMA_IDX_2 : `rrgen_set_RXPMA_IDX_0];
assign dprioin_radce_adapt	= dprioin[`radce_adapt_RXPMA_IDX_0];
assign dprioin_rseq_sel	= dprioin[`rseq_sel_RXPMA_IDX_1 : `rseq_sel_RXPMA_IDX_0];
assign dprioin_rlock_lf_ovd	= dprioin[`rlock_lf_ovd_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 14 for Channel 0
assign dprioin_rrgen_vod	= dprioin[`rrgen_vod_RXPMA_IDX_2 : `rrgen_vod_RXPMA_IDX_0];
assign dprioin_rf_hpf	= dprioin[`rf_hpf_RXPMA_IDX_1 : `rf_hpf_RXPMA_IDX_0];
assign dprioin_rf_lpf	= dprioin[`rf_lpf_RXPMA_IDX_1 : `rf_lpf_RXPMA_IDX_0];
assign dprioin_reserved_1_TB49	= dprioin[`reserved_1_TB49_RXPMA_IDX_2 : `reserved_1_TB49_RXPMA_IDX_0];
assign dprioin_reserved_0_TB49	= dprioin[`reserved_0_TB49_RXPMA_IDX_2 : `reserved_0_TB49_RXPMA_IDX_0];
assign dprioin_rhyst_hf	= dprioin[`rhyst_hf_RXPMA_IDX_2 : `rhyst_hf_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 15 for Channel 0
assign dprioin_radce_pdb	= dprioin[`radce_pdb_RXPMA_IDX_0];
assign dprioin_radce_rst	= dprioin[`radce_rst_RXPMA_IDX_0];
assign dprioin_rhf_os	= dprioin[`rhf_os_RXPMA_IDX_3 : `rhf_os_RXPMA_IDX_0];
assign dprioin_rlf_os	= dprioin[`rlf_os_RXPMA_IDX_3 : `rlf_os_RXPMA_IDX_0];
assign dprioin_rd2a_res	= dprioin[`rd2a_res_RXPMA_IDX_1 : `rd2a_res_RXPMA_IDX_0];
assign dprioin_rrect_adj	= dprioin[`rrect_adj_RXPMA_IDX_1 : `rrect_adj_RXPMA_IDX_0];
assign dprioin_rrgen_bw	= dprioin[`rrgen_bw_RXPMA_IDX_1 : `rrgen_bw_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 16 for Channel 0
assign dprioin_radce_hflck	= dprioin[`radce_hflck_RXPMA_IDX_14 : `radce_hflck_RXPMA_IDX_0];
assign dprioin_reserved_0_TB51	= dprioin[`reserved_0_TB51_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 17 for Channel 0
assign dprioin_radce_lflck	= dprioin[`radce_lflck_RXPMA_IDX_14 : `radce_lflck_RXPMA_IDX_0];
assign dprioin_reserved_0_TB52	= dprioin[`reserved_0_TB52_RXPMA_IDX_0];

// PMA Per Channel RX Control Register 18 for Channel 0
assign dprioin_radce_digital	= dprioin[`radce_digital_RXPMA_IDX_9 : `radce_digital_RXPMA_IDX_0];
assign dprioin_reserved_0_TB53	= dprioin[`reserved_0_TB53_RXPMA_IDX_5 : `reserved_0_TB53_RXPMA_IDX_0];

// Extra
assign dprioin_rlpbk = dprioin[`RLPBK_RXPMA_IDX];
assign dprioin_rrevlb_sw  = dprioin[`RREVLB_SW_RXPMA_IDX];
assign dprioin_rrx_s_lpbk = dprioin[`RRX_S_LPBK_RXPMA_IDX];

// ---------------------------------------------------------------------------
// Set DPRIO output from initial CRAM
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 1 for Channel 0
assign dprioout[`rrx_term_sel_RXPMA_IDX_2 : `rrx_term_sel_RXPMA_IDX_0] = init_rrx_term_sel;
assign dprioout[`rrx_vtt_RXPMA_IDX_2 : `rrx_vtt_RXPMA_IDX_0] = init_rrx_vtt;
assign dprioout[`rrx_s_rdlpbk_RXPMA_IDX_0] = init_rrx_s_rdlpbk;
assign dprioout[`rrx_bit_dc_RXPMA_IDX_3 : `rrx_bit_dc_RXPMA_IDX_0] = init_rrx_bit_dc;
assign dprioout[`rrx_lst_RXPMA_IDX_4 : `rrx_lst_RXPMA_IDX_0] = init_rrx_lst;

// PMA Per Channel RX Control Register 2 for Channel 0
assign dprioout[`rrxurstpma_RXPMA_IDX_0] = init_rrxurstpma;
assign dprioout[`rrx_test_RXPMA_IDX_0] = init_rrx_test;
assign dprioout[`rrx_sd_force_RXPMA_IDX_0] = init_rrx_sd_force;
assign dprioout[`rrx_oc_RXPMA_IDX_7 : `rrx_oc_RXPMA_IDX_0] = init_rrx_oc;
assign dprioout[`rrx_oc_en_RXPMA_IDX_0] = init_rrx_oc_en;
assign dprioout[`rrx_sdlv_RXPMA_IDX_3 : `rrx_sdlv_RXPMA_IDX_0] = init_rrx_sdlv;

// PMA Per Channel RX Control Register 3 for Channel 0
assign dprioout[`reserved_0_TB38_RXPMA_IDX_2 : `reserved_0_TB38_RXPMA_IDX_0] = init_reserved_0_TB38;
assign dprioout[`rpowdnr_RXPMA_IDX_0] = init_rpowdnr;
assign dprioout[`rrx_ib_pdb_RXPMA_IDX_0] = init_rrx_ib_pdb;
assign dprioout[`rurx_pdb_RXPMA_IDX_0] = init_rurx_pdb;
assign dprioout[`rrx_oc_calpd_RXPMA_IDX_0] = init_rrx_oc_calpd;
assign dprioout[`rrx_sd_off_RXPMA_IDX_4 : `rrx_sd_off_RXPMA_IDX_0] = init_rrx_sd_off;
assign dprioout[`rrx_sd_on_RXPMA_IDX_3 : `rrx_sd_on_RXPMA_IDX_0] = init_rrx_sd_on;

// PMA Per Channel RX Control Register 8 for Channel 0
assign dprioout[`reye_monitor_RXPMA_IDX_7 : `reye_monitor_RXPMA_IDX_0] = init_reye_monitor;
assign dprioout[`reserved_0_TB43_RXPMA_IDX_7 : `reserved_0_TB43_RXPMA_IDX_0] = init_reserved_0_TB43;

// PMA Per Channel RX Control Register 9 for Channel 0
assign dprioout[`rpma_reserved_0_TB44_RXPMA_IDX_15 : `rpma_reserved_0_TB44_RXPMA_IDX_0] = init_rpma_reserved_0_TB44;

// PMA Per Channel RX Control Register 10 for Channel 0
assign dprioout[`rppm_cnt_reset_RXPMA_IDX_0] = init_rppm_cnt_reset;
assign dprioout[`rforce1_freqdet_RXPMA_IDX_0] = init_rforce1_freqdet;
assign dprioout[`rforce0_freqdet_RXPMA_IDX_0] = init_rforce0_freqdet;
assign dprioout[`rppmsel_RXPMA_IDX_5 : `rppmsel_RXPMA_IDX_0] = init_rppmsel;
assign dprioout[`rfastsd_RXPMA_IDX_3 : `rfastsd_RXPMA_IDX_0] = init_rfastsd;
assign dprioout[`rtest_fastsd_RXPMA_IDX_0] = init_rtest_fastsd;
assign dprioout[`rpmadwidth_rx_RXPMA_IDX_0] = init_rpmadwidth_rx;
assign dprioout[`rpma_doublewidth_rx_RXPMA_IDX_0] = init_rpma_doublewidth_rx;

// PMA Per Channel RX Control Register 11 for Channel 0
assign dprioout[`reserved_0_TB46_RXPMA_IDX_7 : `reserved_0_TB46_RXPMA_IDX_0] = init_reserved_0_TB46;
assign dprioout[`rppm_gen1_2xcnt_en_RXPMA_IDX_0] = init_rppm_gen1_2xcnt_en;
assign dprioout[`rppm_post_eidle_del_RXPMA_IDX_0] = init_rppm_post_eidle_del;
assign dprioout[`r_dfe_2t_RXPMA_IDX_2 : `r_dfe_2t_RXPMA_IDX_0] = init_r_dfe_2t;
assign dprioout[`r_dfe_1t_RXPMA_IDX_2 : `r_dfe_1t_RXPMA_IDX_0] = init_r_dfe_1t;

// PMA Per Channel RX Control Register 12 for Channel 0
assign dprioout[`reqv_set_RXPMA_IDX_2 : `reqv_set_RXPMA_IDX_0] = init_reqv_set;
assign dprioout[`reqd_set_RXPMA_IDX_2 : `reqd_set_RXPMA_IDX_0] = init_reqd_set;
assign dprioout[`reqc_set_RXPMA_IDX_2 : `reqc_set_RXPMA_IDX_0] = init_reqc_set;
assign dprioout[`reqb_set_RXPMA_IDX_2 : `reqb_set_RXPMA_IDX_0] = init_reqb_set;
assign dprioout[`reqa_set_RXPMA_IDX_2 : `reqa_set_RXPMA_IDX_0] = init_reqa_set;
assign dprioout[`reserved_0_TB47_RXPMA_IDX_0] = init_reserved_0_TB47;

// PMA Per Channel RX Control Register 13 for Channel 0
assign dprioout[`rdc_freq_RXPMA_IDX_1 : `rdc_freq_RXPMA_IDX_0] = init_rdc_freq;
assign dprioout[`rhyst_lf_RXPMA_IDX_2 : `rhyst_lf_RXPMA_IDX_0] = init_rhyst_lf;
assign dprioout[`rclkdiv_RXPMA_IDX_3 : `rclkdiv_RXPMA_IDX_0] = init_rclkdiv;
assign dprioout[`rrgen_set_RXPMA_IDX_2 : `rrgen_set_RXPMA_IDX_0] = init_rrgen_set;
assign dprioout[`radce_adapt_RXPMA_IDX_0] = init_radce_adapt;
assign dprioout[`rseq_sel_RXPMA_IDX_1 : `rseq_sel_RXPMA_IDX_0] = init_rseq_sel;
assign dprioout[`rlock_lf_ovd_RXPMA_IDX_0] = init_rlock_lf_ovd;

// PMA Per Channel RX Control Register 14 for Channel 0
assign dprioout[`rrgen_vod_RXPMA_IDX_2 : `rrgen_vod_RXPMA_IDX_0] = init_rrgen_vod;
assign dprioout[`rf_hpf_RXPMA_IDX_1 : `rf_hpf_RXPMA_IDX_0] = init_rf_hpf;
assign dprioout[`rf_lpf_RXPMA_IDX_1 : `rf_lpf_RXPMA_IDX_0] = init_rf_lpf;
assign dprioout[`reserved_1_TB49_RXPMA_IDX_2 : `reserved_1_TB49_RXPMA_IDX_0] = init_reserved_1_TB49;
assign dprioout[`reserved_0_TB49_RXPMA_IDX_2 : `reserved_0_TB49_RXPMA_IDX_0] = init_reserved_0_TB49;
assign dprioout[`rhyst_hf_RXPMA_IDX_2 : `rhyst_hf_RXPMA_IDX_0] = init_rhyst_hf;

// PMA Per Channel RX Control Register 15 for Channel 0
assign dprioout[`radce_pdb_RXPMA_IDX_0] = init_radce_pdb;
assign dprioout[`radce_rst_RXPMA_IDX_0] = init_radce_rst;
assign dprioout[`rhf_os_RXPMA_IDX_3 : `rhf_os_RXPMA_IDX_0] = init_rhf_os;
assign dprioout[`rlf_os_RXPMA_IDX_3 : `rlf_os_RXPMA_IDX_0] = init_rlf_os;
assign dprioout[`rd2a_res_RXPMA_IDX_1 : `rd2a_res_RXPMA_IDX_0] = init_rd2a_res;
assign dprioout[`rrect_adj_RXPMA_IDX_1 : `rrect_adj_RXPMA_IDX_0] = init_rrect_adj;
assign dprioout[`rrgen_bw_RXPMA_IDX_1 : `rrgen_bw_RXPMA_IDX_0] = init_rrgen_bw;

// PMA Per Channel RX Control Register 16 for Channel 0
assign dprioout[`radce_hflck_RXPMA_IDX_14 : `radce_hflck_RXPMA_IDX_0] = init_radce_hflck;
assign dprioout[`reserved_0_TB51_RXPMA_IDX_0] = init_reserved_0_TB51;

// PMA Per Channel RX Control Register 17 for Channel 0
assign dprioout[`radce_lflck_RXPMA_IDX_14 : `radce_lflck_RXPMA_IDX_0] = init_radce_lflck;
assign dprioout[`reserved_0_TB52_RXPMA_IDX_0] = init_reserved_0_TB52;

// PMA Per Channel RX Control Register 18 for Channel 0
assign dprioout[`radce_digital_RXPMA_IDX_9 : `radce_digital_RXPMA_IDX_0] = init_radce_digital;
assign dprioout[`reserved_0_TB53_RXPMA_IDX_5 : `reserved_0_TB53_RXPMA_IDX_0] = init_reserved_0_TB53;

// Extra
assign dprioout[`RLPBK_RXPMA_IDX] = init_rlpbk;
assign dprioout[`RREVLB_SW_RXPMA_IDX] = init_rrevlb_sw;
assign dprioout[`RRX_S_LPBK_RXPMA_IDX] = init_rrx_s_lpbk;

// ---------------------------------------------------------------------------
// Set DPRIO CRAM
// ---------------------------------------------------------------------------

// PMA Per Channel RX Control Register 1 for Channel 0
assign cram_rrx_term_sel = (dpriodisable !== 1'b0) ? init_rrx_term_sel : dprioin_rrx_term_sel;
assign cram_rrx_vtt = (dpriodisable !== 1'b0) ? init_rrx_vtt : dprioin_rrx_vtt;
assign cram_rrx_s_rdlpbk = (dpriodisable !== 1'b0) ? init_rrx_s_rdlpbk : dprioin_rrx_s_rdlpbk;
assign cram_rrx_bit_dc = (dpriodisable !== 1'b0) ? init_rrx_bit_dc : dprioin_rrx_bit_dc;
assign cram_rrx_lst = (dpriodisable !== 1'b0) ? init_rrx_lst : dprioin_rrx_lst;

// PMA Per Channel RX Control Register 2 for Channel 0
assign cram_rrxurstpma = (dpriodisable !== 1'b0) ? init_rrxurstpma : dprioin_rrxurstpma;
assign cram_rrx_test = (dpriodisable !== 1'b0) ? init_rrx_test : dprioin_rrx_test;
assign cram_rrx_sd_force = (dpriodisable !== 1'b0) ? init_rrx_sd_force : dprioin_rrx_sd_force;
assign cram_rrx_oc = (dpriodisable !== 1'b0) ? init_rrx_oc : dprioin_rrx_oc;
assign cram_rrx_oc_en = (dpriodisable !== 1'b0) ? init_rrx_oc_en : dprioin_rrx_oc_en;
assign cram_rrx_sdlv = (dpriodisable !== 1'b0) ? init_rrx_sdlv : dprioin_rrx_sdlv;

// PMA Per Channel RX Control Register 3 for Channel 0
assign cram_reserved_0_TB38 = (dpriodisable !== 1'b0) ? init_reserved_0_TB38 : dprioin_reserved_0_TB38;
assign cram_rpowdnr = (dpriodisable !== 1'b0) ? init_rpowdnr : dprioin_rpowdnr;
assign cram_rrx_ib_pdb = (dpriodisable !== 1'b0) ? init_rrx_ib_pdb : dprioin_rrx_ib_pdb;
assign cram_rurx_pdb = (dpriodisable !== 1'b0) ? init_rurx_pdb : dprioin_rurx_pdb;
assign cram_rrx_oc_calpd = (dpriodisable !== 1'b0) ? init_rrx_oc_calpd : dprioin_rrx_oc_calpd;
assign cram_rrx_sd_off = (dpriodisable !== 1'b0) ? init_rrx_sd_off : dprioin_rrx_sd_off;
assign cram_rrx_sd_on = (dpriodisable !== 1'b0) ? init_rrx_sd_on : dprioin_rrx_sd_on;

// PMA Per Channel RX Control Register 8 for Channel 0
assign cram_reye_monitor = (dpriodisable !== 1'b0) ? init_reye_monitor : dprioin_reye_monitor;
assign cram_reserved_0_TB43 = (dpriodisable !== 1'b0) ? init_reserved_0_TB43 : dprioin_reserved_0_TB43;

// PMA Per Channel RX Control Register 9 for Channel 0
assign cram_rpma_reserved_0_TB44 = (dpriodisable !== 1'b0) ? init_rpma_reserved_0_TB44 : dprioin_rpma_reserved_0_TB44;

// PMA Per Channel RX Control Register 10 for Channel 0
assign cram_rppm_cnt_reset = (dpriodisable !== 1'b0) ? init_rppm_cnt_reset : dprioin_rppm_cnt_reset;
assign cram_rforce1_freqdet = (dpriodisable !== 1'b0) ? init_rforce1_freqdet : dprioin_rforce1_freqdet;
assign cram_rforce0_freqdet = (dpriodisable !== 1'b0) ? init_rforce0_freqdet : dprioin_rforce0_freqdet;
assign cram_rppmsel = (dpriodisable !== 1'b0) ? init_rppmsel : dprioin_rppmsel;
assign cram_rfastsd = (dpriodisable !== 1'b0) ? init_rfastsd : dprioin_rfastsd;
assign cram_rtest_fastsd = (dpriodisable !== 1'b0) ? init_rtest_fastsd : dprioin_rtest_fastsd;
assign cram_rpmadwidth_rx = (dpriodisable !== 1'b0) ? init_rpmadwidth_rx : dprioin_rpmadwidth_rx;
assign cram_rpma_doublewidth_rx = (dpriodisable !== 1'b0) ? init_rpma_doublewidth_rx : dprioin_rpma_doublewidth_rx;

// PMA Per Channel RX Control Register 11 for Channel 0
assign cram_reserved_0_TB46 = (dpriodisable !== 1'b0) ? init_reserved_0_TB46 : dprioin_reserved_0_TB46;
assign cram_rppm_gen1_2xcnt_en = (dpriodisable !== 1'b0) ? init_rppm_gen1_2xcnt_en : dprioin_rppm_gen1_2xcnt_en;
assign cram_rppm_post_eidle_del = (dpriodisable !== 1'b0) ? init_rppm_post_eidle_del : dprioin_rppm_post_eidle_del;
assign cram_r_dfe_2t = (dpriodisable !== 1'b0) ? init_r_dfe_2t : dprioin_r_dfe_2t;
assign cram_r_dfe_1t = (dpriodisable !== 1'b0) ? init_r_dfe_1t : dprioin_r_dfe_1t;

// PMA Per Channel RX Control Register 12 for Channel 0
assign cram_reqv_set = (dpriodisable !== 1'b0) ? init_reqv_set : dprioin_reqv_set;
assign cram_reqd_set = (dpriodisable !== 1'b0) ? init_reqd_set : dprioin_reqd_set;
assign cram_reqc_set = (dpriodisable !== 1'b0) ? init_reqc_set : dprioin_reqc_set;
assign cram_reqb_set = (dpriodisable !== 1'b0) ? init_reqb_set : dprioin_reqb_set;
assign cram_reqa_set = (dpriodisable !== 1'b0) ? init_reqa_set : dprioin_reqa_set;
assign cram_reserved_0_TB47 = (dpriodisable !== 1'b0) ? init_reserved_0_TB47 : dprioin_reserved_0_TB47;

// PMA Per Channel RX Control Register 13 for Channel 0
assign cram_rdc_freq = (dpriodisable !== 1'b0) ? init_rdc_freq : dprioin_rdc_freq;
assign cram_rhyst_lf = (dpriodisable !== 1'b0) ? init_rhyst_lf : dprioin_rhyst_lf;
assign cram_rclkdiv = (dpriodisable !== 1'b0) ? init_rclkdiv : dprioin_rclkdiv;
assign cram_rrgen_set = (dpriodisable !== 1'b0) ? init_rrgen_set : dprioin_rrgen_set;
assign cram_radce_adapt = (dpriodisable !== 1'b0) ? init_radce_adapt : dprioin_radce_adapt;
assign cram_rseq_sel = (dpriodisable !== 1'b0) ? init_rseq_sel : dprioin_rseq_sel;
assign cram_rlock_lf_ovd = (dpriodisable !== 1'b0) ? init_rlock_lf_ovd : dprioin_rlock_lf_ovd;

// PMA Per Channel RX Control Register 14 for Channel 0
assign cram_rrgen_vod = (dpriodisable !== 1'b0) ? init_rrgen_vod : dprioin_rrgen_vod;
assign cram_rf_hpf = (dpriodisable !== 1'b0) ? init_rf_hpf : dprioin_rf_hpf;
assign cram_rf_lpf = (dpriodisable !== 1'b0) ? init_rf_lpf : dprioin_rf_lpf;
assign cram_reserved_1_TB49 = (dpriodisable !== 1'b0) ? init_reserved_1_TB49 : dprioin_reserved_1_TB49;
assign cram_reserved_0_TB49 = (dpriodisable !== 1'b0) ? init_reserved_0_TB49 : dprioin_reserved_0_TB49;
assign cram_rhyst_hf = (dpriodisable !== 1'b0) ? init_rhyst_hf : dprioin_rhyst_hf;

// PMA Per Channel RX Control Register 15 for Channel 0
assign cram_radce_pdb = (dpriodisable !== 1'b0) ? init_radce_pdb : dprioin_radce_pdb;
assign cram_radce_rst = (dpriodisable !== 1'b0) ? init_radce_rst : dprioin_radce_rst;
assign cram_rhf_os = (dpriodisable !== 1'b0) ? init_rhf_os : dprioin_rhf_os;
assign cram_rlf_os = (dpriodisable !== 1'b0) ? init_rlf_os : dprioin_rlf_os;
assign cram_rd2a_res = (dpriodisable !== 1'b0) ? init_rd2a_res : dprioin_rd2a_res;
assign cram_rrect_adj = (dpriodisable !== 1'b0) ? init_rrect_adj : dprioin_rrect_adj;
assign cram_rrgen_bw = (dpriodisable !== 1'b0) ? init_rrgen_bw : dprioin_rrgen_bw;

// PMA Per Channel RX Control Register 16 for Channel 0
assign cram_radce_hflck = (dpriodisable !== 1'b0) ? init_radce_hflck : dprioin_radce_hflck;
assign cram_reserved_0_TB51 = (dpriodisable !== 1'b0) ? init_reserved_0_TB51 : dprioin_reserved_0_TB51;

// PMA Per Channel RX Control Register 17 for Channel 0
assign cram_radce_lflck = (dpriodisable !== 1'b0) ? init_radce_lflck : dprioin_radce_lflck;
assign cram_reserved_0_TB52 = (dpriodisable !== 1'b0) ? init_reserved_0_TB52 : dprioin_reserved_0_TB52;

// PMA Per Channel RX Control Register 18 for Channel 0
assign cram_radce_digital = (dpriodisable !== 1'b0) ? init_radce_digital : dprioin_radce_digital;
assign cram_reserved_0_TB53 = (dpriodisable !== 1'b0) ? init_reserved_0_TB53 : dprioin_reserved_0_TB53;

// Extra
assign cram_rlpbk = (dpriodisable !== 1'b0) ? init_rlpbk : dprioin_rlpbk;
assign cram_rrevlb_sw = (dpriodisable !== 1'b0) ? init_rrevlb_sw : dprioin_rrevlb_sw;
assign cram_rrx_s_lpbk = (dpriodisable !== 1'b0) ? init_rrx_s_lpbk : dprioin_rrx_s_lpbk;

// Function
function [8*`ARRIAII_HSSI_RX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] alpha_tolower;
input [8*`ARRIAII_HSSI_RX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] input_string;

reg [8*`ARRIAII_HSSI_RX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] return_string;
reg [8*`ARRIAII_HSSI_RX_PMA_ALPHA_TOLOWER_WORD_LENGTH:1] reg_string;
reg [8:1] tmp;
reg [8:1] conv_char;
integer byte_count;
begin
reg_string = input_string;
for (byte_count = `ARRIAII_HSSI_RX_PMA_ALPHA_TOLOWER_WORD_LENGTH; byte_count >= 1; byte_count = byte_count - 1)
begin
    tmp = reg_string[8*`ARRIAII_HSSI_RX_PMA_ALPHA_TOLOWER_WORD_LENGTH:(8*(`ARRIAII_HSSI_RX_PMA_ALPHA_TOLOWER_WORD_LENGTH-1)+1)];
    reg_string = reg_string << 8;
    if ((tmp >= 65) && (tmp <= 90)) // ASCII number of 'A' is 65, 'Z' is 90
    begin
	conv_char = tmp + 32; // 32 is the difference in the position of 'A' and 'a' in the ASCII char set
	return_string = {return_string, conv_char};
    end
    else
	return_string = {return_string, tmp};
end

alpha_tolower = return_string;
end
endfunction
// end function

initial 
begin
    // RX PMA control register 1
    init_rrx_term_sel = 3'b000;
    init_rrx_vtt = (alpha_tolower(common_mode) == "0.82v" ? 3'b010 : alpha_tolower(common_mode) == "tristate" ? 3'b100 : alpha_tolower(common_mode) == "1.1v" ? 3'b001 : 3'b000);
    init_rrx_s_rdlpbk = (alpha_tolower(send_direct_reverse_serial_loopback) == "pre-cdr") ? 1'b1 : 1'b0;
    init_rrx_bit_dc = (eq_dc_gain == 3 ? 4'b0001 : eq_dc_gain == 6 ? 4'b0011 : eq_dc_gain == 9 ? 4'b0111 : eq_dc_gain == 12 ? 4'b1111 : 4'b0000);
    init_rrx_lst = low_speed_test_select;
    	
    // RX PMA control register 2
    init_rrxurstpma = 1'b0;
    init_rrx_test = 1'b0;
    init_rrx_sd_force = (force_signal_detect == "true") ? 1'b1 : 1'b0;
    init_rrx_oc = offset_cancellation;
    init_rrx_oc_en = 1'b0;
    init_rrx_sdlv = 4'b0000;
    
    // RX PMA control register 3
    init_reserved_0_TB38 = 3'b000;
    init_rpowdnr = 1'b0;	
    init_rrx_ib_pdb = 1'b0;	
    init_rurx_pdb = 1'b0;	
    init_rrx_oc_calpd = 1'b0;
    init_rrx_sd_off = signal_detect_loss_threshold;
    init_rrx_sd_on = signal_detect_hysteresis_valid_threshold;
    	
    // RX PMA control register 12
    init_reqv_set = eqv_ctrl;
    init_reqd_set = eqd_ctrl;
    init_reqc_set = eqc_ctrl;
    init_reqb_set = eqb_ctrl;
    init_reqa_set = eqa_ctrl;
    init_reserved_0_TB47 = 1'b0;
    		
    // RX PMA Control Register 10
    init_rppmsel = ppmselect;
    	
    // extra
    init_rpma_doublewidth_rx = (deserialization_factor == 16 || deserialization_factor == 20) ? 1'b1 : 1'b0; //rdeser_div2_init
    init_rpmadwidth_rx = (deserialization_factor == 10 || deserialization_factor == 20) ? 1'b1 : 1'b0;	//rdeser_div5_init
    init_rlpbk = (alpha_tolower(send_direct_reverse_serial_loopback) == "post-cdr") ? 1'b1 : 1'b0;
    init_rrevlb_sw = init_rlpbk;    
    init_rrx_s_lpbk = (allow_serial_loopback == "true" ? 1'b1 : 1'b0);     
    
end
// ---------------------------------------------------------------------------
//  New DPRIO End                                                          
// ---------------------------------------------------------------------------

// ---------------------------------------------------------------------------
//  Model Implementation Begin                                               -
// ---------------------------------------------------------------------------

// SIMULATION_ONLY_PARAMETERS_BEGIN

parameter PARAM_DELAY = 0;

// SIMULATION_ONLY_PARAMETERS_END

// ---------------------------------------------------------------------------
//  Model / Submodule Instantiations                                         -
// ---------------------------------------------------------------------------

// ---------------------------------------------------------------------------
// INPUT FILTERING 
// ---------------------------------------------------------------------------

wire adcepowerdn_in;
wire adcereset_in;
wire adcestandby_in;
wire datain_in;

assign adcepowerdn_in = (adcepowerdn === 1'b1) ? 1'b0 : 1'b1;
assign adcereset_in = (adcereset === 1'b1) ? 1'b0 : 1'b1;
assign adcestandby_in = (adcestandby === 1'b1) ? 1'b0 : 1'b1;
assign datain_in = (datain === 1'b1 || datain === 1'b0) ? datain : 1'b0; //prevent x/z propagate to gate netlist

// ***************************************************************************
//  -- uses only *_cram                                                      *
//  -- should NOT use parameters nor *_dprioin                               *
// ***************************************************************************

    // supply wires common to modules
    wire vcce;
    wire vssex;
    
    assign vcce = 1'b1;
    assign vssex = 1'b0;

    // forward declarations
    // rx output wires
    wire rx_eqout_n;
    wire rx_eqout_p;

    // input wires for c_adce
    wire xadce_atb0;
    wire xadce_atb1;
    wire xadce_atben;
    wire xadce_fixed_clk;
    wire xadce_lock_lf_ovd;
    wire xadce_rdfe_en;
    wire xadce_vbn;
    wire radce_adapt;
    wire  [9:0] radce_digital;
    wire [14:0] radce_hflck;
    wire [14:0] radce_lflck;
    wire  [3:0] rclkdiv;
    wire  [1:0] rd2a_res;
    wire  [1:0] rdc_freq;
    wire  [1:0] rf_hpf;
    wire  [1:0] rf_lpf;
    wire  [3:0] rhf_os;
    wire  [2:0] rhyst_hf;
    wire  [2:0] rhyst_lf;
    wire  [3:0] rlf_os;
    wire  [1:0] rrect_adj;
    wire  [1:0] rrgen_bw;
    wire  [2:0] rrgen_set;
    wire  [2:0] rrgen_vod;
    wire  [1:0] rseq_sel;

    // supply wires for adce
    supply1 vccehxqyx;
    supply1 vccerxqyx;
    supply0 vssexqyx;

    // output wires
    wire  xadce_adapt_done;
    wire  [23:0] xadce_atbsel;
    wire  [5:0] xadce_eqctrlout;
    wire  xadce_fine_d2aout;
    wire  xadce_hf_adapt_done;
    wire  xadce_hf_clk;
    wire  xadce_hfclk_macro;
    wire  xadce_hfmac_cnt0_nclr;
    wire  xadce_hfmac_cnt2_nclr;
    wire  xadce_ibrgen1;
    wire  xadce_ibrgen2;
    wire  xadce_lf_adapt_done;
    wire  xadce_lf_clk;
    wire  xadce_lfclk_macro;
    wire  xadce_lfmac_cnt0_nclr;
    wire  xadce_lfmac_cnt2_nclr;
    wire  [5:0] xadce_rgenctrlout;
    wire  xadce_tmxselan;
    wire  xadce_tmxselbn;
    wire  xadce_tmxselcn;
    wire  xadce_tmxseldn;
    wire  xadce_tmxselvn;
    wire  xadce_updnn_hf;
    wire  xadce_updnn_lf;

    wire eqa_ctrl_wire;
    wire eqb_ctrl_wire;
    wire eqc_ctrl_wire;
    wire eqd_ctrl_wire;
    wire eqv_ctrl_wire;

    // inout
    wire atb_0;
    wire atb_1;
    wire xadce_ib50u_c;
    wire xadce_ib50u_t;
    wire xadce_rxn;
    wire xadce_rxp;
    wire xadce_vctl_quiet;

    arriaii_hssi_pma_c_adce xadce (.adapt_capture(adaptcapture),
                               .atben(xadce_atben),
                               .atbsel(xadce_atbsel),
                               .eqa_set(cram_reqa_set),
                               .eqb_set(cram_reqb_set),
                               .eqc_set(cram_reqc_set),
                               .eqd_set(cram_reqd_set),
                               .eqin_n(rx_eqout_n),
                               .eqin_p(rx_eqout_p),
                               .eqv_set(cram_reqv_set),
                               .fixed_clk(xadce_fixed_clk),
                               .lock_lf_ovd(xadce_lock_lf_ovd),
                               .lst(cram_rrx_lst),
                               .radce_adapt(radce_adapt),
                               .radce_digital(radce_digital),
                               .radce_hflck(radce_hflck),
                               .radce_lflck(radce_lflck),
                               .radce_pdb(adcepowerdn_in) ,
                               .radce_rstb(adcereset_in),
                               .radce_vod_int(),
                               .radce_vod_lsb(),
                               .rbit_dc(vssex),
                               .rclkdiv(rclkdiv),
                               .rd2a_res(rd2a_res),
                               .rdc_freq(rdc_freq),
                               .rdfe_en(xadce_rdfe_en),
                               .rf_hpf(rf_hpf),
                               .rf_lpf(rf_lpf),
                               .rhf_os(rhf_os),
                               .rhyst_hf(rhyst_hf),
                               .rhyst_lf(rhyst_lf),
                               .rlf_os(rlf_os),
                               .rrect_adj(rrect_adj),
                               .rrgen_bw(rrgen_bw),
                               .rrgen_set(rrgen_set),
                               .rrgen_vod(rrgen_vod),
                               .rseq_sel(rseq_sel),
                               .standby(adcestandby_in),
                               .vbn(xadce_vbn),

                               .atb0(xadce_atb0),
                               .atb1(xadce_atb1),
                               .atb_0(atb_0),
                               .atb_1(atb_1),
                               .ib50u_c(xadce_ib50u_c),
                               .ib50u_t(xadce_ib50u_t),
                               .outeqn(xadce_rxn),
                               .outeqp(xadce_rxp),
                               .vccehxqyx(vccehxqyx),
                               .vccerxqyx(vccerxqyx),
                               .vctl_quiet(xadce_vctl_quiet),
                               .vssexqyx(vssexqyx),

                               .adapt_done(xadce_adapt_done),
                               .e_clk(xadce_hf_clk),
                               .eqa_ctrl(eqa_ctrl_wire),
                               .eqb_ctrl(eqb_ctrl_wire),
                               .eqc_ctrl(eqc_ctrl_wire),
                               .eqctrlout(xadce_eqctrlout),
                               .eqd_ctrl(eqd_ctrl_wire),
                               .eqv_ctrl(eqv_ctrl_wire),
                               .fine_d2aout(xadce_fine_d2aout),
                               .hf_adapt_done(xadce_hf_adapt_done),
                               .hfclk_macro(xadce_hfclk_macro),
                               .hfmac_cnt0_nclr(xadce_hfmac_cnt0_nclr),
                               .hfmac_cnt2_nclr(xadce_hfmac_cnt2_nclr),
                               .ibrgen1(xadce_ibrgen1),
                               .ibrgen2(xadce_ibrgen2),
                               .lf_adapt_done(xadce_lf_adapt_done),
                               .lfclk_macro(xadce_lfclk_macro),
                               .lfmac_cnt0_nclr(xadce_lfmac_cnt0_nclr),
                               .lfmac_cnt2_nclr(xadce_lfmac_cnt2_nclr),
                               .r_clk(xadce_lf_clk),
                               .rgenctrlout(xadce_rgenctrlout),
                               .tmxselan(xadce_tmxselan),
                               .tmxselbn(xadce_tmxselbn),
                               .tmxselcn(xadce_tmxselcn),
                               .tmxseldn(xadce_tmxseldn),
                               .tmxselvn(xadce_tmxselvn),
                               .updnn_hf(xadce_updnn_hf),
                               .updnn_lf(xadce_updnn_lf)
                              );

    assign adaptdone = xadce_adapt_done;

    // input wires for c_rx
    wire [5:0] xrx_atbsel;
    wire [3:0] ibp50u;
    wire [1:0] ibc50u;
    wire [1:0] ibp150u;
    wire lpbkn;
    wire lpbkp;
    wire xrx_refclk;
    wire rs_lpbk;
    wire rx_n;
    wire [3:0] rx_50;
    wire xrx_pdb;
    wire [2:0] rrx_term;
    wire rrx_test;
    wire xrx_testclk;
    wire xrx_oc_calpd;
    wire xrx_ac_mode;
    wire xrx_bsmode;
    wire xrx_bsrxn_in;
    wire xrx_bsrxp_in;
    wire xrx_mem_init;
    wire xrx_pd2_term;
    wire xrx_pdb_clk;
    wire xrx_pdbh_term;
    wire xrx_rstn;
    wire xrx_pdshft_clk;
    wire [1:0] xrx_slew;

    // output wires
    wire analog_sd_icd;
    wire analog_sd_sw;
    wire analog_sd;   
    wire bsrxn_out;
    wire bsrxp_out;
    wire cdr_rxn;
    wire cdr_rxp;
    wire rx_pd2;
    wire rx_pd_rxclk_term;
    wire rx_pdbh_rx;
    wire rx_pdbh_rxclk_term;
    wire rx_rlpbkp;             // to lpbk_mux
    wire rx_rlpbkn;             // to lpbk_mux
    wire rx_rlpbkp_far;
    wire rx_rlpbkn_far;
    wire rx_sd_cpon;
    wire rx_sd_cpop;
    wire rx_rxbuf_ibias;
    wire sd_cdr;

    // connect inputs
    assign lpbkp = (seriallpbkin === 1'b0 || seriallpbkin === 1'b1) ? seriallpbkin : 1'b0;  //filtering X/Z
    assign rs_lpbk = (cram_rrx_s_lpbk == 1'b0) ? 1'b0 : seriallpbken;
    assign rx_n = ~datain_in;
    assign xrx_refclk = 1'b0;   // for now
    assign xrx_testclk = 1'b0;   // for now
    assign xrx_pdb = (powerdn === 1'b1) ? 1'b0 : 1'b1;
    assign rrx_test = 1'b0;   // for now : need parameter ?

    // c_rx instance
    arriaii_hssi_pma_c_rx xrx ( .ac_mode(xrx_ac_mode),
                        .atbsel(xrx_atbsel),
                        .bsmode(xrx_bsmode),
                        .bsrxn_in(xrx_bsrxn_in),
                        .bsrxp_in(xrx_bsrxp_in),
                        .ck0_sigdet(~deserclock[3]),
                        .eqa_ctrl(eqa_ctrl_wire),
                        .eqb_ctrl(eqb_ctrl_wire),
                        .eqc_ctrl(eqc_ctrl_wire),
                        .eqd_ctrl(eqd_ctrl_wire),
                        .lpbkn(lpbkn),
                        .lpbkp(lpbkp),
                        .mem_init(xrx_mem_init),
                        .oc_calpd(xrx_oc_calpd),
                        .oc_en(offsetcancellationen),
                        .pd2_term(xrx_pd2_term),
                        .pdb(xrx_pdb),
                        .pdb_clk(xrx_pdb_clk),
                        .pdbh_term(xrx_pdbh_term),
                        .pdshft_clk(xrx_pdshft_clk),
                        .rbit_dc(cram_rrx_bit_dc),
                        .refclk(xrx_refclk),
                        .rstn(xrx_rstn),
                        .rx_b50(rx_50),
                        .rx_oc(cram_rrx_oc),
                        .rx_test(rrx_test),
                        .rx_testclk(xrx_testclk),
                        .s_lpbk(rs_lpbk),
                        .s_rdlpbk(cram_rrx_s_rdlpbk),
                        .sd_force(cram_rrx_sd_force),
                        .sd_off(cram_rrx_sd_off),
                        .sd_on(cram_rrx_sd_on),
                        .sdlv(cram_rrx_sdlv),
                        .slew(xrx_slew),
                        .term(rrx_term),
                        .vccehtxqyx(vcce),
                        .vcce_la(vcce),
                        .vcce_oa(vcce),
                        .vssexqyx(vssexqyx),
                        .vtt(cram_rrx_vtt[2:0]),

                        .atb0_rx(atb_0),
                        .atb1_rx(atb_1),
                        .eqv_ctrl(eqv_ctrl_wire),
                        .ibc50u(ibc50u),
                        .ibp50u(ibp50u),
                        .ibp150u(ibp150u),
                        .inn(rx_n),
                        .inp(datain_in),

                        .analog_sd(analog_sd_icd),
                        .bsrxn_out(bsrxn_out),
                        .bsrxp_out(bsrxp_out),
                        .inn3(rx_eqout_n),
                        .inp3(rx_eqout_p),
                        .pd2(rx_pd2),
                        .pd_rxclk_term(rx_pd_rxclk_term),
                        .pdbh_rx(rx_pdbh_rx),
                        .pdbh_rxclk_term(rx_pdbh_rxclk_term),
                        .rdlpbkn(rx_rlpbkn),     // loopback to TX thro' mux
                        .rdlpbkn_far(rx_rlpbkn_far),
                        .rdlpbkp(rx_rlpbkp),     // loopback to TX thro' mux
                        .rdlpbkp_far(rx_rlpbkp_far),
                        .rxbuf_ibias(rx_rxbuf_ibias),
                        .rxn(cdr_rxn),       // to top
                        .rxp(cdr_rxp),       // to top
                        .sd_cdr(sd_cdr),          // to cdr
                        .sd_cpon(rx_sd_cpon),
                        .sd_cpop(rx_sd_cpop)
                       );

    // outputs from the c_rx

    assign dataout = cdr_rxp;
    assign signaldetect = analog_sd;


`ifdef STRATIXIV_HSSI_USE_ICD_SD
    assign analog_sd = analog_sd_icd;
`else
    assign analog_sd = analog_sd_sw;
`endif

    // simplified signal detect model like S2GX - SW ----------------
    // input
    wire sd_rx;
    wire sd_reset;
    // output
    reg signaldetect_reg;
    
    assign analog_sd_sw = signaldetect_reg;
    assign sd_rx = (rs_lpbk === 1'b1) ? seriallpbkin : datain;
    assign sd_reset = (powerdn === 1'b1 || rxpmareset === 1'b1) ? 1'b1 : 1'b0;
    
    initial begin
        signaldetect_reg = 1'b0;
    end
    
    always @ (sd_reset or sd_rx)
    begin
        if (sd_reset === 1'b1)
            signaldetect_reg <= 1'b0;
        else if (sd_rx === 1'b0 || sd_rx === 1'b1)
            signaldetect_reg <= 1'b1;
        else
            signaldetect_reg <= 1'b0;    
    end
    

    // PPMDETECT MODULE
    // ppmdetect module input wires
    wire ppmdetect_hardreset_in;
    wire ppmdetect_pd_in;
    wire ppmdetect_ppmcntreset_in;
    wire ppmdetect_scanmode_in;
    wire ppmdetect_rforcehigh_in;
    wire ppmdetect_rforcelow_in;

    // output wires
    wire ppmdetect_freqlock_out;
    wire [6:0] ppmdetect_ppmcntlatch_out;

    // assign inputs
    assign ppmdetect_hardreset_in = (rxpmareset === 1'b1) ? 1'b0 : 1'b1;
    assign ppmdetect_pd_in = (powerdn === 1'b1) ? 1'b0 : 1'b1;

    arriaii_hssi_pma_ppmdetect xppmdetect ( .fref(ppmdetectrefclk),
                                        .fvcobyn(ppmdetectdividedclk),
                                        .hard_reset(ppmdetect_hardreset_in),
                                        .pd(ppmdetect_pd_in),
                                        .ppmsel(cram_rppmsel),
                                        .ppm_cnt_reset(ppmdetect_ppmcntreset_in),
                                        .scan_mode(ppmdetect_scanmode_in),
                                        .rforcehigh(ppmdetect_rforcehigh_in),
                                        .rforcelow(ppmdetect_rforcelow_in),

                                        .freq_lock(ppmdetect_freqlock_out),
                                        .ppm_cnt_latch(ppmdetect_ppmcntlatch_out)
                                      );


// simplified freqlock behavior:
//  (1). Responding to rising edge of rxpll_lock with small counter;
//  (2). Responding to analogreset
//  (3). Not responding to loss of rxpll_lock

// freqlock
wire         mrxpll_not_locked;
reg          mfreqlocked_reg;
reg [3:0]    mfreqlocked_cnt;

wire         signal_detect_reg_n;
wire         lck2refctl_freqlock;

assign mrxpll_not_locked = (plllocked === 1'b1) ? 1'b0 : 1'b1;
assign signal_detect_reg_n = ~analog_sd;

initial
begin
    mfreqlocked_reg = 1'b0;
    mfreqlocked_cnt = 4'b000;
end

always @ (posedge ppmdetectrefclk or posedge rxpmareset)
begin
    if (rxpmareset === 1'b1)
        mfreqlocked_reg <= 1'b0;
    else if (mfreqlocked_cnt === 4'b1111)
        mfreqlocked_reg <= 1'b1;
    else
        mfreqlocked_reg <= 1'b0;
end

always @ (posedge ppmdetectrefclk or posedge mrxpll_not_locked or posedge signal_detect_reg_n)
begin
    if (mrxpll_not_locked === 1'b1 || signal_detect_reg_n === 1'b1)
        mfreqlocked_cnt <= 4'b0000;
    else if (mfreqlocked_cnt !== 4'b1111)
        mfreqlocked_cnt <= mfreqlocked_cnt + 4'b0001;
end

`ifdef STRATIXIV_HSSI_USE_ICD_PPMDETECT
    assign lck2refctl_freqlock = ppmdetect_freqlock_out;
`else
    assign lck2refctl_freqlock = mfreqlocked_reg;
`endif

    // CDR
    // input wires for cdr
    wire ltd;
    wire ltr;

    reg devenout, devenbout;
    reg doddout, oddbout;
    reg doddx, oddbx;
    reg oe1, oeb1;
    reg oo1, oob1;
    reg oe2, oeb2;
    reg oo2, oob2;
    reg rxlpbp_int, rxlpbn_int;
    reg rxlpbdp_int, rxlpbdn_int;

    wire deven;
    wire devenb;
    wire dodd;
    wire doddb;

    wire cdr_pdb;
    wire ck0_pd;  
    wire ck90_pd;  
    wire ck180_pd;  
    wire ck270_pd;  
    wire clk90_slpbk;
    wire clk270_slpbk;
    wire lck2ref;
    wire pdbx;
    wire pe;
    wire rlbk;
    wire rstb_slpbk;
    wire rst_n;
    wire rstn2;
    wire rxpll_lock;
    wire rxlpbp, rxlpbn;
    wire rxlpbdp, rxlpbdn;
    
    // connect inputs
    assign cdr_pdb = (powerdn === 1'b1) ? 1'b0 : 1'b1;
    assign ck0_pd = deserclock[0];
    assign ck90_pd = deserclock[1];
    assign ck180_pd = deserclock[2];
    assign ck270_pd = deserclock[3];
    assign ltd = locktodata;
    assign ltr = locktoref;
    assign rlbk = cram_rlpbk;
    assign rst_n = (rxpmareset === 1'b1) ? 1'b0 : 1'b1;

    assign deven = recoverdatain[0];
    assign dodd = recoverdatain[1];
    assign devenb = ~recoverdatain[0];
    assign doddb = ~recoverdatain[1];

    // * * c_lck2refctl * *
    assign lck2ref    = ~cdr_pdb ? 1'b1 :
                       (~sd_cdr | ~lck2refctl_freqlock) ? 1'b1 :
                       ( sd_cdr & lck2refctl_freqlock & ~plllocked & ~ignorephslck ) ? 1'b1 :
                       ( sd_cdr & lck2refctl_freqlock &  plllocked ) ? 1'b0 : 1'b0;

    assign rxpll_lock = ~lck2ref; 

    // * * c_slpbk * *
    assign pdbx         = cdr_pdb & rlbk;
    assign rstb_slpbk   = pdbx & rst_n;
    assign clk90_slpbk  = ~( ck90_pd  & pdbx );
    assign clk270_slpbk = ~( ck270_pd & pdbx );
    assign rstn2        = pe & vssex ;
    assign pe           = ~pdbx & rst_n & cram_rrx_s_rdlpbk;

    always @ ( posedge clk90_slpbk or negedge rstb_slpbk ) // xdff0 & xdff1
        if ( rstb_slpbk == 1'b0 ) 
        begin
            {devenout,devenbout} <= #(PARAM_DELAY) 2'b01;
            {doddx,oddbx}        <= #(PARAM_DELAY) 2'b01;
        end
        else 
        begin
            {devenout,devenbout} <= #(PARAM_DELAY) {deven,devenb};
            {doddx,oddbx}        <= #(PARAM_DELAY) {dodd,doddb};
        end

    always @ ( posedge clk270_slpbk or negedge rstb_slpbk ) // xdff2
        if ( rstb_slpbk == 1'b0 ) 
        begin
            {doddout,oddbout} <= #(PARAM_DELAY) 2'b01;
        end
        else
        begin
            {doddout,oddbout} <= #(PARAM_DELAY) {doddx,oddbx};
        end

    // xlatch_mux (used to be xpre_emp)
    always @ ( posedge clk270_slpbk or negedge rst_n ) // x1
        if ( rst_n == 1'b0 )
        begin
            {oe1,oeb1} <= #(PARAM_DELAY) 2'b01;
         end
        else 
        begin
            {oe1,oeb1} <= #(PARAM_DELAY) {devenout,devenbout};
        end

    always @ ( posedge clk90_slpbk or negedge rst_n ) // x12
        if ( rst_n == 1'b0 )
        begin
            {oo1,oob1} <= #(PARAM_DELAY) 2'b01;
        end
        else 
        begin
            {oo1,oob1} <= #(PARAM_DELAY) {doddout,oddbout};
	    end

    always @ ( posedge clk270_slpbk or negedge pdbx ) // x4
        if ( pdbx == 1'b0 ) 
        begin
            {rxlpbp_int,rxlpbn_int} <= #(PARAM_DELAY) 2'b11;
        end
        else 
        begin
            {rxlpbp_int,rxlpbn_int} <= #(PARAM_DELAY) {devenout,devenbout};
        end

    always @ ( posedge clk90_slpbk or negedge pdbx ) // x8
        if ( pdbx == 1'b0 ) 
        begin
            {rxlpbp_int,rxlpbn_int} <= #(PARAM_DELAY) 2'b11;
        end
        else 
        begin
            {rxlpbp_int,rxlpbn_int} <= #(PARAM_DELAY) {doddout,oddbout};
        end

    always @ ( posedge clk90_slpbk or negedge pe ) // x5 
        if ( pe == 1'b0 ) 
        begin
            {rxlpbdp_int,rxlpbdn_int} <= #(PARAM_DELAY) 2'b11;
        end
        else 
        begin
            {rxlpbdp_int,rxlpbdn_int} <= #(PARAM_DELAY) {oe1,oeb1};
        end

    always @ ( posedge clk270_slpbk or negedge pe ) // x9 
        if ( pe == 1'b0 ) 
        begin
            {rxlpbdp_int,rxlpbdn_int} <= #(PARAM_DELAY) 2'b11;
        end
        else 
        begin
            {rxlpbdp_int,rxlpbdn_int} <= #(PARAM_DELAY) {oo1,oob1};
        end

    assign { rxlpbp, rxlpbn} = { rxlpbp_int, rxlpbn_int};
    assign {rxlpbdp,rxlpbdn} = {rxlpbdp_int,rxlpbdn_int};

    // outputs from the c_cdr
    assign locktorefout = lck2ref;
    assign revserialfdbkout = rxlpbp;

////////////////end cdr
    // output wires
    wire ncvondp;
    wire ncvopdp;
    wire rlpbkdn;
    wire rlpbkdp;
    wire rlpbkn;
    wire rlpbkp;
    wire ncvonp;
    wire ncvopp;

    arriaii_hssi_pma_c_rlpbk_mux xrlpbk_mux ( .doddn(vssex),
                                      .doddp(vssex),
                                      .dodn(rxlpbdn),
                                      .dodp(rxlpbdp),
                                      .don(rxlpbn),
                                      .don_pre(vssex),
                                      .dop(rxlpbp),
                                      .dop_pre(vssex),
                                      .drxn(rx_rlpbkn),
                                      .drxp(rx_rlpbkp),
                                      .sel(cram_rrevlb_sw),
                                      .vcce_la(vcce),
                                      .vssex(vssex),

                                      .voddn(ncvondp),
                                      .voddp(ncvopdp),
                                      .vodn(rlpbkdn),
                                      .vodp(rlpbkdp),
                                      .von(rlpbkn),
                                      .von_pre(ncvonp),
                                      .vop(rlpbkp),
                                      .vop_pre(ncvopp)
                                    );

    // outputs from the lpbk_mux
    assign reverselpbkout = cdr_rxp;

    // input wires for the deserializer
    wire xdeser_clk90_in;  
    wire xdeser_pdb_in;
    wire xdeser_rst_n;
    wire xdeser_pcie_sw;
    wire rdynamic_sw;
    wire [3:0] rfast_sd;

    // output wires
    wire xdeser_clkdivrx_out;
    wire [19:0] xdeser_dout_out;
    wire xdeser_fsd_out;
    wire xdeser_pcieo_out;
    wire xdeser_rtest_fastsd;

    // 10g output wires
    wire xdeser_10g_clk_divrx;
    wire [63:0] xdeser_10g_dout;

    // connect the inputs
    assign xdeser_clk90_in = (deserialization_factor <= 20) ? ~deserclock[1] : 1'b0;
    assign xdeser_pdb_in = (powerdn === 1'b1) ? 1'b0 : 1'b1;
    assign xdeser_rst_n = (rxpmareset === 1'b1) ? 1'b0 : 1'b1;

    assign xdeser_pcie_sw = 1'b0;         // for now
    assign rdynamic_sw = 1'b0;       // for now;


    // generate blocks (for 10g only)
    generate
    if (deserialization_factor > 20)
    begin
        // input wires for the 10g deserializer
        wire xdeser_10g_pdb;
        wire xdeser_10g_rst_n;

        assign xdeser_10g_pdb = (powerdn === 1'b1) ? 1'b0 : 1'b1;
        assign xdeser_10g_rst_n = (rxpmareset === 1'b1) ? 1'b0 : 1'b1;

        arriaii_hssi_pma_c_deser_10g xdeser_10g ( .clk90b(~deserclock[1]),
                                              .deser_pdb(xdeser_10g_pdb),
                                              .deven(recoverdatain[0]),
                                              .devenb(~recoverdatain[0]),
                                              .dodd(recoverdatain[1]),
                                              .doddb(~recoverdatain[1]),
                                              .rst_n(xdeser_10g_rst_n),
                                              .vcce_la(vcce),
                                              .vssexqyx(vssexqyx),

                                              .clk_divrx(xdeser_10g_clk_divrx),
                                              .dout(xdeser_10g_dout)
                                         );    
    end
    endgenerate    

    arriaii_hssi_pma_c_deser xdeser (
                             .clk90b(xdeser_clk90_in),
                             .deser_div2(cram_rpma_doublewidth_rx),
                             .deser_div5(cram_rpmadwidth_rx),
                             .deser_pdb(xdeser_pdb_in),
                             .deven(deven),                // from top
                             .devenb(devenb),                // from top
                             .dodd(dodd),                // from top
                             .doddb(doddb),                // from top
                             .pcie_sw(xdeser_pcie_sw),
                             .rdynamic_sw(rdynamic_sw),
                             .rfast_sd(rfast_sd),
                             .rst_n(xdeser_rst_n),
                             .rtest_fastsd(xdeser_rtest_fastsd),
                             .rxinn(rx_rlpbkn),     // from c_rx
                             .rxinp(rx_rlpbkp),     // from c_rx
                             .vcce_la(vcce),
                             .vssexqyx(vssexqyx),

                             .clk_divrx(xdeser_clkdivrx_out),
                             .dout(xdeser_dout_out),
                             .fsd(xdeser_fsd_out),
                             .pcieo(xdeser_pcieo_out)
                            );

    reg param_use_pma_direct;
    initial
    begin
        param_use_pma_direct = (use_pma_direct == "true") ? 1'b1 : 1'b0;
    end
    
    // outputs from the deserializer
    assign clockout = (allow_vco_bypass == 0 ? (deserialization_factor <= 20 ? xdeser_clkdivrx_out : xdeser_10g_clk_divrx): allow_vco_bypass == 1 ? (!ppmdetectrefclk) : allow_vco_bypass == 2 ? ppmdetectdividedclk : xdeser_clkdivrx_out);
    assign recoverdataout[19:0] = (param_use_pma_direct == 1'b1 && deserialization_factor == 16) ? ({{4{1'bz}}, xdeser_dout_out[17:10], xdeser_dout_out[7:0]}) : (deserialization_factor <= 20) ? xdeser_dout_out : xdeser_10g_dout[19:0];
    assign recoverdataout[63:20] = (deserialization_factor <= 20) ? ({44{1'bz}}) : xdeser_10g_dout[63:20];

    assign dataoutfull = xdeser_dout_out;

    // drive 0 on analogtestbus
    assign analogtestbus = 8'b0;
 
// ---------------------------------------------------------------------------
// TIMING -- Tco/Tsu/Thold
// ---------------------------------------------------------------------------

specify
    (posedge adaptcapture => (adaptdone +: xadce_adapt_done)) = (0, 0);
endspecify
       
endmodule


`timescale 1 ns / 1 ps

module arriaii_hssi_pcs_reset (hard_reset, clk_2_b, refclk_b_in, scan_mode, rxpcs_rst, txpcs_rst,
                  rxrst_int, txrst_int);

input   hard_reset;
input   clk_2_b;
input   refclk_b_in;
input   scan_mode;
input   rxpcs_rst;
input   txpcs_rst;

output  rxrst_int;
output  txrst_int;

reg 	txrst_sync1, txrst_sync2;
reg     rxrst_sync1, rxrst_sync2;
wire    txrst_int, rxrst_int;

initial begin
    txrst_sync1 = 1'b0;
    txrst_sync2 = 1'b0;
    rxrst_sync1 = 1'b0;
    rxrst_sync2 = 1'b0;
end

always @(posedge hard_reset or posedge clk_2_b)
begin
	if (hard_reset)
		begin
		 rxrst_sync2	<= 1'b1;
		 rxrst_sync1 	<= 1'b1;
		end
	else
		begin
		 rxrst_sync2	<= #1 rxrst_sync1;
		 rxrst_sync1	<= rxpcs_rst;
		end
end

always @(posedge hard_reset or posedge refclk_b_in)
begin
	if (hard_reset)
		begin
		 txrst_sync2	<= 1'b1;
		 txrst_sync1 	<= 1'b1;
		end
	else
		begin
		 txrst_sync2	<= #1 txrst_sync1;
		 txrst_sync1	<= txpcs_rst;
		end
end

// 06-14-02 BT Changed SCAN_SHIFT signal to SCAN_MODE
//assign rxrst_int = !SCAN_SHIFT & rxrst_sync2;
//assign txrst_int = !SCAN_SHIFT & txrst_sync2;
assign rxrst_int = !scan_mode & rxrst_sync2;
assign txrst_int = !scan_mode & txrst_sync2;

endmodule

`timescale 1 ps / 1 ps
module arriaii_hssi_digi_chnl_hip_spt (
	rhip_ena,

	pcs_rxd_ch,
	pcs_rxvalid,
	pcs_rxelecidle,
	pcs_rxstatus_ch,
	pcs_phystatus,
	txpma_local_clk,
	txd_ch,
	hip_txd_ch,
	txdetectrxloopback,
	hip_txdetectrxloopback,
	rxpolarity,
	hip_rxpolarity,
	powerdown_ch,
	hip_powerdown_ch,
	txdeemph,
	hip_txdeemph,
	txmargin_ch,
	hip_txmargin_ch,
	eidleinfersel_ch,
	hip_eidleinfersel_ch,
	rate,
	hip_rate,
	hip_txelecidle,

	rxd_ch,
	hip_rxd_ch,
	rxvalid,
	hip_rxvalid,
	rxelecidle,
	hip_rxelecidle,
	rxstatus_ch,
	hip_rxstatus_ch,
	phystatus,
	hip_phystatus,
	hip_tx_clk,
	pcs_txd_ch,
	pcs_txdetectrxloopback,
	pcs_rxpolarity,
	pcs_powerdown_ch,
	pcs_txdeemph,
	pcs_txmargin_ch,
	pcs_eidleinfersel_ch,
	pcs_rate
);

input		rhip_ena;

input	[8:0]	pcs_rxd_ch;
input		pcs_rxvalid;
input		pcs_rxelecidle;
input	[2:0]	pcs_rxstatus_ch;
input		pcs_phystatus;
input		txpma_local_clk;
input	[10:0]	txd_ch;
input	[9:0]	hip_txd_ch;
input		txdetectrxloopback;
input		hip_txdetectrxloopback;
input		rxpolarity;
input		hip_rxpolarity;
input	[1:0]	powerdown_ch;
input	[1:0]	hip_powerdown_ch;
input		txdeemph;
input		hip_txdeemph;
input	[2:0]	txmargin_ch;
input	[2:0]	hip_txmargin_ch;
input	[2:0]	eidleinfersel_ch;
input	[2:0]	hip_eidleinfersel_ch;
input		rate;
input		hip_rate;
input		hip_txelecidle;

output	[8:0]	rxd_ch;
output	[8:0]	hip_rxd_ch;
output		rxvalid;
output		hip_rxvalid;
output		rxelecidle;
output		hip_rxelecidle;
output	[2:0]	rxstatus_ch;
output	[2:0]	hip_rxstatus_ch;
output		phystatus;
output		hip_phystatus;
output		hip_tx_clk;
output	[10:0]	pcs_txd_ch;
output		pcs_txdetectrxloopback;
output		pcs_rxpolarity;
output	[1:0]	pcs_powerdown_ch;
output		pcs_txdeemph;
output	[2:0]	pcs_txmargin_ch;
output	[2:0]	pcs_eidleinfersel_ch;
output	     	pcs_rate;


wire 	[8:0]	pcs_rxd_ch;
wire 	[2:0]	pcs_rxstatus_ch;
wire 	[10:0]	txd_ch;
wire 	[9:0]	hip_txd_ch;
wire 	[1:0]	powerdown_ch;
wire 	[1:0]	hip_powerdown_ch;
wire 	[2:0]	txmargin_ch;
wire 	[2:0]	hip_txmargin_ch;
wire 	[2:0]	eidleinfersel_ch;
wire 	[2:0]	hip_eidleinfersel_ch;
wire  	[8:0]	rxd_ch;
wire  	[8:0]	hip_rxd_ch;
wire  	[2:0]	rxstatus_ch;
wire  	[2:0]	hip_rxstatus_ch;
wire  	[10:0]	pcs_txd_ch;
wire  	[1:0]	pcs_powerdown_ch;
wire  	[2:0]	pcs_txmargin_ch;
wire  	[2:0]	pcs_eidleinfersel_ch;

//// SECTION for SPLIT signals
//// ===============================
////
// MUX/SPLIT #5,6,7,8 in Excel spreadsheet
assign rxd_ch     = pcs_rxd_ch;
assign hip_rxd_ch = rhip_ena ? pcs_rxd_ch : 9'b000000000;

// MUX/SPLIT #16 in Excel spreadsheet
assign rxvalid     = pcs_rxvalid;
assign hip_rxvalid = rhip_ena ? pcs_rxvalid : 1'b0;

// MUX/SPLIT #17 in Excel spreadsheet
assign rxelecidle     = pcs_rxelecidle;
assign hip_rxelecidle = rhip_ena ? pcs_rxelecidle : 1'b1;

// MUX/SPLIT #18,19,20,21 in Excel spreadsheet
assign rxstatus_ch     = pcs_rxstatus_ch;
assign hip_rxstatus_ch = rhip_ena ? pcs_rxstatus_ch : 3'b000;

// MUX/SPLIT #22 in Excel spreadsheet
assign phystatus     = pcs_phystatus;
assign hip_phystatus = rhip_ena ? pcs_phystatus : 1'b0;


   assign hip_tx_clk = txpma_local_clk;
   


//// SECTION for MUX signals
//// ===============================
////
// MUX/SPLIT #1,2,3,4 in Excel spreadsheet
assign pcs_txd_ch = rhip_ena ? {hip_txelecidle, hip_txd_ch} : txd_ch;

// MUX/SPLIT #10 in Excel spreadsheet
assign pcs_txdetectrxloopback = rhip_ena ? hip_txdetectrxloopback : txdetectrxloopback;

// MUX/SPLIT #11 in Excel spreadsheet
assign pcs_rxpolarity = rhip_ena ? hip_rxpolarity : rxpolarity;

// MUX/SPLIT #12,13,14,15 in Excel spreadsheet
assign pcs_powerdown_ch = rhip_ena ? hip_powerdown_ch : powerdown_ch;

// MUX/SPLIT #23 in Excel spreadsheet
assign pcs_txdeemph = rhip_ena ? hip_txdeemph : txdeemph;

// MUX/SPLIT #24,25,26,27 in Excel spreadsheet
assign pcs_txmargin_ch = rhip_ena ? hip_txmargin_ch : txmargin_ch;

// MUX/SPLIT #28,29,30,31 in Excel spreadsheet
assign pcs_eidleinfersel_ch = rhip_ena ? hip_eidleinfersel_ch : eidleinfersel_ch;

// MUX/SPLIT #32 in Excel spreadsheet
assign pcs_rate = rhip_ena ? hip_rate : rate;


endmodule



`timescale 1 ns / 1 ps

module arriaii_hssi_phystatus_generator_fsm (
				
				// General signals
				clk,
				reset_n,
				
				//CRAM
				phystat_ena,					// OR of rtx_pipe_enable and rrx_pipe_enable
				rphystatus_rst_toggle,			// no toggle (gen 2) = 0, toggle (option for gen 1) = 1
				
				// PLD Interface
				powerdown,					// power state control
				phystatus,					// communicate completion of power state transitions, receiver 
				// detection, rate change

				rindv_rx,
				rmaster_rx,
				rmaster_up_rx,
				
				// Auto Negotiation Module
				speed_change,					// asserted when signaling rate change between Gen 1 and Gen 2
				speed_change_centrl,				
				speed_change_quad_up,				
				speed_change_quad_down,				
				
				// RX PIPE Interface
				//	p1_sync,
				
				// PMA interface
				// TX PMA
				rx_detect_valid,				// rx_detect_bypass = 0 : Validation of rx_found: 
				// 					synchronized at pipe_interface_top level
				// rx_detect_bypass = 1 : delayed version of txdetectrx
				
				// RX PMA
				power_state_transition_done,		// asserted when successful power state transition occurs
				power_state_transition_done_ena,	// validates power_state_transition_done, currently tied to 0
				
				// Latched Power State Signals
				p1,							// P1 power state from TX PIPE interface
				
				// Internal Power State Done Generator
				internal_done					// faked successful power state transition generated by internal	
				// power state transition done module
				
				);
   
   
   //********************************************************************************
   // INCLUDE STATEMENTS
   //********************************************************************************
   
   //********************************************************************************
   // I/O SIGNALS
   //********************************************************************************
   // General signals
   input	   clk;
   input 	   reset_n;
   
   // CRAM
   input 	   phystat_ena;
   input 	   rphystatus_rst_toggle;
   
   // PLD Interface
   input [1:0] 	   powerdown;
   output 	   phystatus;

   input 	   rindv_rx;               // Select between XAUI mode or indiv  channel mode
   input 	   rmaster_rx;             // New bundle mode MDIO, selects master quad
   input 	   rmaster_up_rx;          // New bundle mode MDIO, selects master quad
   
   // Auto Negotiation Module
   input 	   speed_change;
   input 	   speed_change_centrl;
   input 	   speed_change_quad_up;
   input 	   speed_change_quad_down;
   
   // RX PIPE Interface
   //output			p1_sync;
   
   // PMA interface
   // TX PMA
   input 	   rx_detect_valid;
   
   // RX PMA
   input 	   power_state_transition_done;
   input 	   power_state_transition_done_ena;
   
   
   // Latched Power state signals
   input 	   p1;		// longer recovery time (64 us max) latency
   
   
   // Internal Power State Done Generator
   input 	   internal_done;
   
   //********************************************************************************
   // PARAMETERS
   //********************************************************************************
   
   //********************************************************************************
   // DECLARATIONS
   //********************************************************************************
   //reg		phystatus;
   
   // select between PMA done and internally generated done
   wire 	   done;
   reg 		   pre_power_state_transition_done_sync;
   reg 		   power_state_transition_done_sync;
   reg 		   power_state_transition_done_sync_reg;
   
   // Reset condition
   reg 		   reset_phystatus;
   
   // State transition
   reg 		   state_transition_phystatus;
   
   // Speed Negotiation
   reg 		   speed_change_reg;
   reg 		   speed_change_sync;
   reg 		   speed_change_sync_reg;
   reg 		   speed_change_phystatus;
   
   // Receiver Detection
   //reg		p1_reg;				// synchronize from tx clk domain to rx clk domain
   //reg		p1_sync;
   
   reg 		   rx_detect_valid_reg;		// Edge detection of receiver detection status signal
   reg 		   rx_detect_valid_phystatus;
   
	// P2 exit detection
   wire 	   decode_p2;
   reg 		   decode_p2_reg;
   reg 		   decode_p2_reg1;
   reg 		   phystatus_high_sel;
   reg 		   phystatus_high_sel_reg;
   
   // Reset
   reg 		   phystatus_toggle_sel;
   reg 		   phystatus_toggle_sel_reg;
   
   reg 		   pre_phystatus;
   
   wire 	   speed_change_local;
   
   reg 		   speed_change_centrl_del1;
   reg 		   speed_change_centrl_del2;
   
   
   //********************************************************************************
   // ASSIGN STATEMENTS
   //********************************************************************************
   // Move to PLD interface
   assign 	   phystatus = (~decode_p2 && decode_p2_reg1)? 1'b1: pre_phystatus;
   //assign phystatus= pre_phystatus;
   
   assign 	   done = power_state_transition_done_ena? (power_state_transition_done_sync && ! power_state_transition_done_sync_reg): internal_done;
   
   assign 	   decode_p2 = (powerdown == 2'b11)? phystat_ena: 1'b0;
   
   //********************************************************************************
   // SUBMODULE INSTANTIATIONS
   //********************************************************************************
   
   //********************************************************************************
   // MAIN CODE
   //********************************************************************************
   // Reset phystatus generation
   
   // Phystatus is asserted during reset and then the successful 'transition' into P1 is signal by the assertion
   // phystatus for 1 cycle.  Unlike regular operation, the first entry into P1 is not indicated by a 'done' signal
   // The assertion of phystatus occurs 4 cycles after reset is released
   always @ (reset_n)
     begin
	if (~reset_n)
	  reset_phystatus	= 1'b1;
	else
	  reset_phystatus	= 1'b0;
     end
   
   always @ (reset_n or rphystatus_rst_toggle or done or phystatus_toggle_sel_reg)
     begin
	if (~reset_n)
	  phystatus_toggle_sel 	= 1'b1;
	else if (rphystatus_rst_toggle | done)
	  phystatus_toggle_sel	= 1'b0;
	else
	  phystatus_toggle_sel	= phystatus_toggle_sel_reg;
     end
   
   
   always @ (posedge clk or negedge reset_n)
     begin
	if (~reset_n)
	  begin
	     phystatus_toggle_sel_reg	<= #1 1'b1;
	     phystatus_high_sel_reg	<= #1 1'b1;
	  end
	else
	  begin
	     phystatus_toggle_sel_reg	<= #1 phystatus_toggle_sel;
	     phystatus_high_sel_reg	<= #1 phystatus_high_sel;
	  end
     end
   // State transition: sync PMA signal to local clk.  Currently not being used
   // State transition: Internal done generator indicates that there was a successful state transition.  
   // Illegal transitions have been taken into account by the previous module.
   always @ (posedge clk or negedge reset_n)
     begin
	if (!reset_n)
	  begin
	     pre_power_state_transition_done_sync	<= #1 1'b0;
	     power_state_transition_done_sync		<= #1 1'b0;
	     power_state_transition_done_sync_reg	<= #1 1'b0;
	     
	  end
	else
	  begin
	     pre_power_state_transition_done_sync	<= #1 power_state_transition_done;
	     power_state_transition_done_sync		<= #1 pre_power_state_transition_done_sync;
	     power_state_transition_done_sync_reg	<= #1 power_state_transition_done_sync;
	     
	  end
     end
   
   always @ (reset_n or done)
     begin
	if (~reset_n)
	  state_transition_phystatus	= 1'b0;
	else if (done)
	  state_transition_phystatus	= 1'b1;
	else
	  state_transition_phystatus	= 1'b0;
     end
   
   
   always @ (posedge clk or negedge reset_n)
     begin
	if (!reset_n)
	  begin
	     speed_change_centrl_del1 <= #1 1'b0;
	     speed_change_centrl_del2 <= #1 1'b0;
	     
	  end
	else
	  begin
	     speed_change_centrl_del1 <= #1 speed_change_centrl;
	     speed_change_centrl_del2 <= #1 speed_change_centrl_del1;
	  end
     end // always @ (posedge clk or negedge reset_n)
      
   assign speed_change_local =   rmaster_rx ? (rindv_rx ? speed_change : speed_change_centrl_del2) : (rmaster_up_rx ? speed_change_quad_up : speed_change_quad_down);  
   
   // Speed Negotiation
   always @ (posedge clk or negedge reset_n)
     begin
	if (!reset_n)
	  begin
	     speed_change_reg		<= #1 1'b0;
	     speed_change_sync		<= #1 1'b0;
	     speed_change_sync_reg	<= #1 1'b0;
	     
	  end
	else
	  begin
	     speed_change_reg		<= #1 speed_change_local;
	     speed_change_sync		<= #1 speed_change_reg;
	     speed_change_sync_reg	<= #1 speed_change_sync;
	  end
     end
   
   
   always @ (reset_n or speed_change_sync or speed_change_sync_reg)
     begin
	if (~reset_n)
	  speed_change_phystatus	= 1'b0;
	else if (~speed_change_sync & speed_change_sync_reg)
	  speed_change_phystatus	= 1'b1;
	else
	  speed_change_phystatus	= 1'b0;
     end
   
   // Receiver Detection
   always @ (posedge clk or negedge reset_n)
     begin
	if (!reset_n)
	  begin
	     //		p1_reg					<= 1'b0;
	     //		p1_sync					<= 1'b0;
	     rx_detect_valid_reg			<= #1 1'b0;
	     
	     //		rx_detect_valid_phystatus	<= 1'b0;
	  end
	else
	  begin
	     //		p1_reg					<= p1;
	     //		p1_sync					<= p1_reg;
	     rx_detect_valid_reg			<= #1 rx_detect_valid;
	     
	     //		rx_detect_valid_phystatus	<= p1_sync && rx_detect_valid && !rx_detect_valid_reg;
	  end
     end
   
   always  @ (reset_n or /*p1_sync*/ p1 or rx_detect_valid or rx_detect_valid_reg)
     begin
	if (~reset_n)
	  rx_detect_valid_phystatus	= 1'b0;
	//	else if (p1_sync && rx_detect_valid && !rx_detect_valid_reg)
	else if (p1 && rx_detect_valid && !rx_detect_valid_reg)
	  rx_detect_valid_phystatus 	= 1'b1;
	else
	  rx_detect_valid_phystatus	= 1'b0;
	
     end
   
   // P2 state exit Detection
   always @ (posedge clk or negedge reset_n)
     begin
	if (!reset_n)
	  begin
	     decode_p2_reg			<= #1 1'b0;
	     decode_p2_reg1			<= #1 1'b0;
	  end
	else
	  begin
	     decode_p2_reg		<= #1 decode_p2;
	     decode_p2_reg1		<= #1 decode_p2_reg;
	  end
     end
   
   always @ (reset_n or decode_p2 or decode_p2_reg or phystatus_high_sel_reg or done)
     begin
	if (~reset_n)
	  phystatus_high_sel	= 1'b0;
	else if (~decode_p2 && decode_p2_reg)
	  phystatus_high_sel	= 1'b1;
	else if (done)
	  phystatus_high_sel	= 1'b0;
	else
	  phystatus_high_sel	= phystatus_high_sel_reg;
     end
   

   
   always @ (reset_n or phystatus_high_sel or reset_phystatus or state_transition_phystatus or rx_detect_valid_phystatus
	     or phystatus_toggle_sel or speed_change_phystatus)
     begin
	if (~reset_n)
	  begin
	     pre_phystatus	= 1'b1;
	  end
	else
	  begin
	     if (phystatus_high_sel || reset_phystatus || state_transition_phystatus || rx_detect_valid_phystatus || phystatus_toggle_sel
                 || speed_change_phystatus)
	       pre_phystatus	= 1'b1;
	     else
	       pre_phystatus	= 1'b0;
	  end
     end // always @ (reset_n or phystatus_high_sel or reset_phystatus or state_transition_phystatus or rx_detect_valid_phystatus...
   
endmodule // phystatus_generator_fsm



//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 53 oper_mux 1 arriaii_hssi_phystatus_generator_fsm 1 
`timescale 1 ps / 1 ps
module  arriaii_hssi_phystatus_generator
	( 
	clk,
	latched_p0,
	latched_p0s,
	latched_p1,
	latched_p2,
	phystat_ena,
	phystatus,
	power_state_transition_done,
	power_state_transition_done_ena,
	powerdown,
	reset_n,
	rindv_rx,
	rmaster_rx,
	rmaster_up_rx,
	rphystatus_delay,
	rphystatus_rst_toggle,
	rx_detect_valid,
	speed_change,
	speed_change_centrl,
	speed_change_quad_down,
	speed_change_quad_up) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   latched_p0;
	input   latched_p0s;
	input   latched_p1;
	input   latched_p2;
	input   phystat_ena;
	output   phystatus;
	input   power_state_transition_done;
	input   power_state_transition_done_ena;
	input   [1:0]  powerdown;
	input   reset_n;
	input   rindv_rx;
	input   rmaster_rx;
	input   rmaster_up_rx;
	input   [2:0]  rphystatus_delay;
	input   rphystatus_rst_toggle;
	input   rx_detect_valid;
	input   speed_change;
	input   speed_change_centrl;
	input   speed_change_quad_down;
	input   speed_change_quad_up;

	reg	nllOi21;
	reg	nllOi22;
	reg	nllOl19;
	reg	nllOl20;
	reg	nllOO17;
	reg	nllOO18;
	reg	nlO0l11;
	reg	nlO0l12;
	reg	nlO1i15;
	reg	nlO1i16;
	reg	nlO1O13;
	reg	nlO1O14;
	reg	nlOii10;
	reg	nlOii9;
	reg	nlOil7;
	reg	nlOil8;
	reg	nlOli5;
	reg	nlOli6;
	reg	nlOlO3;
	reg	nlOlO4;
	reg	nlOOl1;
	reg	nlOOl2;
	reg	ni0i;
	reg	ni0l;
	reg	ni1O;
	reg	niii;
	wire	wire_ni0O_CLRN;
	reg	n00i;
	reg	n00l;
	reg	n00O;
	reg	n01i;
	reg	n01l;
	reg	n01O;
	reg	n0ii;
	reg	n0il;
	reg	n0iO;
	reg	n0li;
	reg	n0ll;
	reg	n0lO;
	reg	n0Ol;
	reg	n0OO;
	reg	n1lO;
	reg	n1Ol;
	reg	n1OO;
	reg	ni1i;
	reg	ni1l;
	reg	niil;
	reg	niiO;
	reg	nili;
	reg	nill;
	reg	nilO;
	reg	niOi;
	reg	niOl;
	reg	nl1i;
	reg	niOO_clk_prev;
	wire	wire_niOO_CLRN;
	wire	wire_niOO_PRN;
	wire  wire_n1Oi_o;
	wire  wire_nl0O_phystatus;
	wire  nlO0O;
	wire  nlOiO;

	initial
		nllOi21 = 0;
	always @ ( posedge clk)
		  nllOi21 <= nllOi22;
	event nllOi21_event;
	initial
		#1 ->nllOi21_event;
	always @(nllOi21_event)
		nllOi21 <= {1{1'b1}};
	initial
		nllOi22 = 0;
	always @ ( posedge clk)
		  nllOi22 <= nllOi21;
	initial
		nllOl19 = 0;
	always @ ( posedge clk)
		  nllOl19 <= nllOl20;
	event nllOl19_event;
	initial
		#1 ->nllOl19_event;
	always @(nllOl19_event)
		nllOl19 <= {1{1'b1}};
	initial
		nllOl20 = 0;
	always @ ( posedge clk)
		  nllOl20 <= nllOl19;
	initial
		nllOO17 = 0;
	always @ ( posedge clk)
		  nllOO17 <= nllOO18;
	event nllOO17_event;
	initial
		#1 ->nllOO17_event;
	always @(nllOO17_event)
		nllOO17 <= {1{1'b1}};
	initial
		nllOO18 = 0;
	always @ ( posedge clk)
		  nllOO18 <= nllOO17;
	initial
		nlO0l11 = 0;
	always @ ( posedge clk)
		  nlO0l11 <= nlO0l12;
	event nlO0l11_event;
	initial
		#1 ->nlO0l11_event;
	always @(nlO0l11_event)
		nlO0l11 <= {1{1'b1}};
	initial
		nlO0l12 = 0;
	always @ ( posedge clk)
		  nlO0l12 <= nlO0l11;
	initial
		nlO1i15 = 0;
	always @ ( posedge clk)
		  nlO1i15 <= nlO1i16;
	event nlO1i15_event;
	initial
		#1 ->nlO1i15_event;
	always @(nlO1i15_event)
		nlO1i15 <= {1{1'b1}};
	initial
		nlO1i16 = 0;
	always @ ( posedge clk)
		  nlO1i16 <= nlO1i15;
	initial
		nlO1O13 = 0;
	always @ ( posedge clk)
		  nlO1O13 <= nlO1O14;
	event nlO1O13_event;
	initial
		#1 ->nlO1O13_event;
	always @(nlO1O13_event)
		nlO1O13 <= {1{1'b1}};
	initial
		nlO1O14 = 0;
	always @ ( posedge clk)
		  nlO1O14 <= nlO1O13;
	initial
		nlOii10 = 0;
	always @ ( posedge clk)
		  nlOii10 <= nlOii9;
	initial
		nlOii9 = 0;
	always @ ( posedge clk)
		  nlOii9 <= nlOii10;
	event nlOii9_event;
	initial
		#1 ->nlOii9_event;
	always @(nlOii9_event)
		nlOii9 <= {1{1'b1}};
	initial
		nlOil7 = 0;
	always @ ( posedge clk)
		  nlOil7 <= nlOil8;
	event nlOil7_event;
	initial
		#1 ->nlOil7_event;
	always @(nlOil7_event)
		nlOil7 <= {1{1'b1}};
	initial
		nlOil8 = 0;
	always @ ( posedge clk)
		  nlOil8 <= nlOil7;
	initial
		nlOli5 = 0;
	always @ ( posedge clk)
		  nlOli5 <= nlOli6;
	event nlOli5_event;
	initial
		#1 ->nlOli5_event;
	always @(nlOli5_event)
		nlOli5 <= {1{1'b1}};
	initial
		nlOli6 = 0;
	always @ ( posedge clk)
		  nlOli6 <= nlOli5;
	initial
		nlOlO3 = 0;
	always @ ( posedge clk)
		  nlOlO3 <= nlOlO4;
	event nlOlO3_event;
	initial
		#1 ->nlOlO3_event;
	always @(nlOlO3_event)
		nlOlO3 <= {1{1'b1}};
	initial
		nlOlO4 = 0;
	always @ ( posedge clk)
		  nlOlO4 <= nlOlO3;
	initial
		nlOOl1 = 0;
	always @ ( posedge clk)
		  nlOOl1 <= nlOOl2;
	event nlOOl1_event;
	initial
		#1 ->nlOOl1_event;
	always @(nlOOl1_event)
		nlOOl1 <= {1{1'b1}};
	initial
		nlOOl2 = 0;
	always @ ( posedge clk)
		  nlOOl2 <= nlOOl1;
	initial
	begin
		ni0i = 0;
		ni0l = 0;
		ni1O = 0;
		niii = 0;
	end
	always @ ( posedge clk or  negedge wire_ni0O_CLRN)
	begin
		if (wire_ni0O_CLRN == 1'b0) 
		begin
			ni0i <= 0;
			ni0l <= 0;
			ni1O <= 0;
			niii <= 0;
		end
		else if  (nlOiO == 1'b1) 
		begin
			ni0i <= niiO;
			ni0l <= nili;
			ni1O <= niil;
			niii <= nill;
		end
	end
	assign
		wire_ni0O_CLRN = ((nlO0l12 ^ nlO0l11) & reset_n);
	initial
	begin
		n00i = 0;
		n00l = 0;
		n00O = 0;
		n01i = 0;
		n01l = 0;
		n01O = 0;
		n0ii = 0;
		n0il = 0;
		n0iO = 0;
		n0li = 0;
		n0ll = 0;
		n0lO = 0;
		n0Ol = 0;
		n0OO = 0;
		n1lO = 0;
		n1Ol = 0;
		n1OO = 0;
		ni1i = 0;
		ni1l = 0;
		niil = 0;
		niiO = 0;
		nili = 0;
		nill = 0;
		nilO = 0;
		niOi = 0;
		niOl = 0;
		nl1i = 0;
	end
	always @ (clk or wire_niOO_PRN or wire_niOO_CLRN)
	begin
		if (wire_niOO_PRN == 1'b0) 
		begin
			n00i <= 1;
			n00l <= 1;
			n00O <= 1;
			n01i <= 1;
			n01l <= 1;
			n01O <= 1;
			n0ii <= 1;
			n0il <= 1;
			n0iO <= 1;
			n0li <= 1;
			n0ll <= 1;
			n0lO <= 1;
			n0Ol <= 1;
			n0OO <= 1;
			n1lO <= 1;
			n1Ol <= 1;
			n1OO <= 1;
			ni1i <= 1;
			ni1l <= 1;
			niil <= 1;
			niiO <= 1;
			nili <= 1;
			nill <= 1;
			nilO <= 1;
			niOi <= 1;
			niOl <= 1;
			nl1i <= 1;
		end
		else if  (wire_niOO_CLRN == 1'b0) 
		begin
			n00i <= 0;
			n00l <= 0;
			n00O <= 0;
			n01i <= 0;
			n01l <= 0;
			n01O <= 0;
			n0ii <= 0;
			n0il <= 0;
			n0iO <= 0;
			n0li <= 0;
			n0ll <= 0;
			n0lO <= 0;
			n0Ol <= 0;
			n0OO <= 0;
			n1lO <= 0;
			n1Ol <= 0;
			n1OO <= 0;
			ni1i <= 0;
			ni1l <= 0;
			niil <= 0;
			niiO <= 0;
			nili <= 0;
			nill <= 0;
			nilO <= 0;
			niOi <= 0;
			niOl <= 0;
			nl1i <= 0;
		end
		else 
		if (clk != niOO_clk_prev && clk == 1'b1) 
		begin
			n00i <= n00l;
			n00l <= n0ii;
			n00O <= wire_n1Oi_o;
			n01i <= n01l;
			n01l <= n01O;
			n01O <= n00i;
			n0ii <= n0il;
			n0il <= n0iO;
			n0iO <= n0li;
			n0li <= n0ll;
			n0ll <= ((phystat_ena & (~ power_state_transition_done_ena)) & n0lO);
			n0lO <= (~ (((((~ ((ni1O ^ n0Ol) ^ (~ (nlO1O14 ^ nlO1O13)))) & (~ (ni0i ^ n0OO))) & (~ (ni0l ^ ni1i))) & (~ (niii ^ ni1l))) & (nlO1i16 ^ nlO1i15)));
			n0Ol <= ni1O;
			n0OO <= ni0i;
			n1lO <= n1Ol;
			n1Ol <= n1OO;
			n1OO <= n01i;
			ni1i <= ni0l;
			ni1l <= niii;
			niil <= nilO;
			niiO <= niOi;
			nili <= niOl;
			nill <= nl1i;
			nilO <= latched_p0;
			niOi <= latched_p0s;
			niOl <= latched_p1;
			nl1i <= latched_p2;
		end
		niOO_clk_prev <= clk;
	end
	assign
		wire_niOO_CLRN = ((nlOil8 ^ nlOil7) & reset_n),
		wire_niOO_PRN = (nlOii10 ^ nlOii9);
	oper_mux   n1Oi
	( 
	.data({n1lO, n1Ol, ((nllOi22 ^ nllOi21) & n1OO), ((nllOl20 ^ nllOl19) & n01i), n01l, n01O, n00i, ((nllOO18 ^ nllOO17) & n00l)}),
	.o(wire_n1Oi_o),
	.sel({rphystatus_delay[2:0]}));
	defparam
		n1Oi.width_data = 8,
		n1Oi.width_sel = 3;
	arriaii_hssi_phystatus_generator_fsm   nl0O
	( 
	.clk(clk),
	.internal_done(n00O),
	.p1(latched_p1),
	.phystat_ena(phystat_ena),
	.phystatus(wire_nl0O_phystatus),
	.power_state_transition_done(power_state_transition_done),
	.power_state_transition_done_ena(power_state_transition_done_ena),
	.powerdown({powerdown[1:0]}),
	.reset_n(reset_n),
	.rindv_rx(rindv_rx),
	.rmaster_rx(rmaster_rx),
	.rmaster_up_rx(rmaster_up_rx),
	.rphystatus_rst_toggle(rphystatus_rst_toggle),
	.rx_detect_valid(rx_detect_valid),
	.speed_change(speed_change),
	.speed_change_centrl(speed_change_centrl),
	.speed_change_quad_down(speed_change_quad_down),
	.speed_change_quad_up(speed_change_quad_up));
	assign
		nlO0O = 1'b1,
		nlOiO = ((((((((((~ nill) & (~ nili)) & (~ niiO)) & niil) & (nlOOl2 ^ nlOOl1)) | ((((~ nill) & (~ nili)) & niiO) & (~ niil))) | (~ (nlOlO4 ^ nlOlO3))) | ((((~ nill) & nili) & (~ niiO)) & (~ niil))) | (~ (nlOli6 ^ nlOli5))) | (((nill & (~ nili)) & (~ niiO)) & (~ niil))),
		phystatus = wire_nl0O_phystatus;
endmodule //arriaii_hssi_phystatus_generator
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 50 mux21 146 
`timescale 1 ps / 1 ps
module  arriaii_hssi_rx_pipe_interface
	( 
	clk,
	latched_p1,
	polinv_rx,
	polinv_rx_int,
	rclkcmpinsertpad,
	reset_n,
	rind_error_reporting,
	rrdwidth_rx,
	rrx_pipe_enable,
	rx_detect_valid,
	rx_detect_valid_sync,
	rx_found,
	rx_found_sync,
	rxd,
	rxd_ch,
	rxelecidle,
	rxelectricalidle,
	rxpolarity,
	rxstatus,
	rxvalid,
	sigdetni,
	txdetectrx) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   latched_p1;
	input   polinv_rx;
	output   polinv_rx_int;
	input   rclkcmpinsertpad;
	input   reset_n;
	input   rind_error_reporting;
	input   rrdwidth_rx;
	input   rrx_pipe_enable;
	input   rx_detect_valid;
	input   rx_detect_valid_sync;
	input   rx_found;
	input   rx_found_sync;
	input   [63:0]  rxd;
	output   [63:0]  rxd_ch;
	output   rxelecidle;
	input   rxelectricalidle;
	input   rxpolarity;
	output   [2:0]  rxstatus;
	output   rxvalid;
	input   sigdetni;
	input   txdetectrx;

	reg	n110l7;
	reg	n110l8;
	reg	n111i11;
	reg	n111i12;
	reg	n111O10;
	reg	n111O9;
	reg	n11ii5;
	reg	n11ii6;
	reg	n11iO3;
	reg	n11iO4;
	reg	n11Ol1;
	reg	n11Ol2;
	reg	nlO0ll41;
	reg	nlO0ll42;
	reg	nlO0Oi39;
	reg	nlO0Oi40;
	reg	nlO0OO37;
	reg	nlO0OO38;
	reg	nlOi0l35;
	reg	nlOi0l36;
	reg	nlOiil33;
	reg	nlOiil34;
	reg	nlOilO31;
	reg	nlOilO32;
	reg	nlOiOl29;
	reg	nlOiOl30;
	reg	nlOl1l27;
	reg	nlOl1l28;
	reg	nlOlii25;
	reg	nlOlii26;
	reg	nlOlli23;
	reg	nlOlli24;
	reg	nlOlOi21;
	reg	nlOlOi22;
	reg	nlOO0i17;
	reg	nlOO0i18;
	reg	nlOO1i19;
	reg	nlOO1i20;
	reg	nlOOiO15;
	reg	nlOOiO16;
	reg	nlOOOl13;
	reg	nlOOOl14;
	reg	n00ii;
	reg	n0ill;
	reg	n0iOi;
	reg	n1l1l;
	reg	n1O0i;
	reg	n1O1O;
	reg	nlOOO;
	reg	nO;
	reg	nl_clk_prev;
	wire	wire_nl_CLRN;
	wire	wire_n000i_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00OO_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01iO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n100O_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10ii_dataout;
	wire	wire_n10il_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1i1O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1iOl_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1liO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Oll_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_n1OOO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_niii_dataout;
	wire	wire_niil_dataout;
	wire	wire_niiO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nli_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOOl_dataout;
	wire  n11lO;
	wire  nlO00i;
	wire  nlO00l;
	wire  nlO00O;
	wire  nlO01i;
	wire  nlO01l;
	wire  nlO01O;
	wire  nlO0ii;
	wire  nlO0il;
	wire  nlO0iO;
	wire  nlO0li;
	wire  nlOi0i;
	wire  nlOi1l;
	wire  nlOi1O;
	wire  nlOiii;
	wire  nlOili;
	wire  nlOill;
	wire  nlOl0i;
	wire  nlOl0l;
	wire  nlOl0O;
	wire  nlOl1i;
	wire  nlOliO;
	wire  nlOllO;
	wire  nlOlOO;
	wire  nlOO0O;
	wire  nlOO1O;
	wire  nlOOii;
	wire  nlOOil;
	wire  nlOOll;
	wire  nlOOlO;
	wire  nlOOOi;

	initial
		n110l7 = 0;
	always @ ( posedge clk)
		  n110l7 <= n110l8;
	event n110l7_event;
	initial
		#1 ->n110l7_event;
	always @(n110l7_event)
		n110l7 <= {1{1'b1}};
	initial
		n110l8 = 0;
	always @ ( posedge clk)
		  n110l8 <= n110l7;
	initial
		n111i11 = 0;
	always @ ( posedge clk)
		  n111i11 <= n111i12;
	event n111i11_event;
	initial
		#1 ->n111i11_event;
	always @(n111i11_event)
		n111i11 <= {1{1'b1}};
	initial
		n111i12 = 0;
	always @ ( posedge clk)
		  n111i12 <= n111i11;
	initial
		n111O10 = 0;
	always @ ( posedge clk)
		  n111O10 <= n111O9;
	initial
		n111O9 = 0;
	always @ ( posedge clk)
		  n111O9 <= n111O10;
	event n111O9_event;
	initial
		#1 ->n111O9_event;
	always @(n111O9_event)
		n111O9 <= {1{1'b1}};
	initial
		n11ii5 = 0;
	always @ ( posedge clk)
		  n11ii5 <= n11ii6;
	event n11ii5_event;
	initial
		#1 ->n11ii5_event;
	always @(n11ii5_event)
		n11ii5 <= {1{1'b1}};
	initial
		n11ii6 = 0;
	always @ ( posedge clk)
		  n11ii6 <= n11ii5;
	initial
		n11iO3 = 0;
	always @ ( posedge clk)
		  n11iO3 <= n11iO4;
	event n11iO3_event;
	initial
		#1 ->n11iO3_event;
	always @(n11iO3_event)
		n11iO3 <= {1{1'b1}};
	initial
		n11iO4 = 0;
	always @ ( posedge clk)
		  n11iO4 <= n11iO3;
	initial
		n11Ol1 = 0;
	always @ ( posedge clk)
		  n11Ol1 <= n11Ol2;
	event n11Ol1_event;
	initial
		#1 ->n11Ol1_event;
	always @(n11Ol1_event)
		n11Ol1 <= {1{1'b1}};
	initial
		n11Ol2 = 0;
	always @ ( posedge clk)
		  n11Ol2 <= n11Ol1;
	initial
		nlO0ll41 = 0;
	always @ ( posedge clk)
		  nlO0ll41 <= nlO0ll42;
	event nlO0ll41_event;
	initial
		#1 ->nlO0ll41_event;
	always @(nlO0ll41_event)
		nlO0ll41 <= {1{1'b1}};
	initial
		nlO0ll42 = 0;
	always @ ( posedge clk)
		  nlO0ll42 <= nlO0ll41;
	initial
		nlO0Oi39 = 0;
	always @ ( posedge clk)
		  nlO0Oi39 <= nlO0Oi40;
	event nlO0Oi39_event;
	initial
		#1 ->nlO0Oi39_event;
	always @(nlO0Oi39_event)
		nlO0Oi39 <= {1{1'b1}};
	initial
		nlO0Oi40 = 0;
	always @ ( posedge clk)
		  nlO0Oi40 <= nlO0Oi39;
	initial
		nlO0OO37 = 0;
	always @ ( posedge clk)
		  nlO0OO37 <= nlO0OO38;
	event nlO0OO37_event;
	initial
		#1 ->nlO0OO37_event;
	always @(nlO0OO37_event)
		nlO0OO37 <= {1{1'b1}};
	initial
		nlO0OO38 = 0;
	always @ ( posedge clk)
		  nlO0OO38 <= nlO0OO37;
	initial
		nlOi0l35 = 0;
	always @ ( posedge clk)
		  nlOi0l35 <= nlOi0l36;
	event nlOi0l35_event;
	initial
		#1 ->nlOi0l35_event;
	always @(nlOi0l35_event)
		nlOi0l35 <= {1{1'b1}};
	initial
		nlOi0l36 = 0;
	always @ ( posedge clk)
		  nlOi0l36 <= nlOi0l35;
	initial
		nlOiil33 = 0;
	always @ ( posedge clk)
		  nlOiil33 <= nlOiil34;
	event nlOiil33_event;
	initial
		#1 ->nlOiil33_event;
	always @(nlOiil33_event)
		nlOiil33 <= {1{1'b1}};
	initial
		nlOiil34 = 0;
	always @ ( posedge clk)
		  nlOiil34 <= nlOiil33;
	initial
		nlOilO31 = 0;
	always @ ( posedge clk)
		  nlOilO31 <= nlOilO32;
	event nlOilO31_event;
	initial
		#1 ->nlOilO31_event;
	always @(nlOilO31_event)
		nlOilO31 <= {1{1'b1}};
	initial
		nlOilO32 = 0;
	always @ ( posedge clk)
		  nlOilO32 <= nlOilO31;
	initial
		nlOiOl29 = 0;
	always @ ( posedge clk)
		  nlOiOl29 <= nlOiOl30;
	event nlOiOl29_event;
	initial
		#1 ->nlOiOl29_event;
	always @(nlOiOl29_event)
		nlOiOl29 <= {1{1'b1}};
	initial
		nlOiOl30 = 0;
	always @ ( posedge clk)
		  nlOiOl30 <= nlOiOl29;
	initial
		nlOl1l27 = 0;
	always @ ( posedge clk)
		  nlOl1l27 <= nlOl1l28;
	event nlOl1l27_event;
	initial
		#1 ->nlOl1l27_event;
	always @(nlOl1l27_event)
		nlOl1l27 <= {1{1'b1}};
	initial
		nlOl1l28 = 0;
	always @ ( posedge clk)
		  nlOl1l28 <= nlOl1l27;
	initial
		nlOlii25 = 0;
	always @ ( posedge clk)
		  nlOlii25 <= nlOlii26;
	event nlOlii25_event;
	initial
		#1 ->nlOlii25_event;
	always @(nlOlii25_event)
		nlOlii25 <= {1{1'b1}};
	initial
		nlOlii26 = 0;
	always @ ( posedge clk)
		  nlOlii26 <= nlOlii25;
	initial
		nlOlli23 = 0;
	always @ ( posedge clk)
		  nlOlli23 <= nlOlli24;
	event nlOlli23_event;
	initial
		#1 ->nlOlli23_event;
	always @(nlOlli23_event)
		nlOlli23 <= {1{1'b1}};
	initial
		nlOlli24 = 0;
	always @ ( posedge clk)
		  nlOlli24 <= nlOlli23;
	initial
		nlOlOi21 = 0;
	always @ ( posedge clk)
		  nlOlOi21 <= nlOlOi22;
	event nlOlOi21_event;
	initial
		#1 ->nlOlOi21_event;
	always @(nlOlOi21_event)
		nlOlOi21 <= {1{1'b1}};
	initial
		nlOlOi22 = 0;
	always @ ( posedge clk)
		  nlOlOi22 <= nlOlOi21;
	initial
		nlOO0i17 = 0;
	always @ ( posedge clk)
		  nlOO0i17 <= nlOO0i18;
	event nlOO0i17_event;
	initial
		#1 ->nlOO0i17_event;
	always @(nlOO0i17_event)
		nlOO0i17 <= {1{1'b1}};
	initial
		nlOO0i18 = 0;
	always @ ( posedge clk)
		  nlOO0i18 <= nlOO0i17;
	initial
		nlOO1i19 = 0;
	always @ ( posedge clk)
		  nlOO1i19 <= nlOO1i20;
	event nlOO1i19_event;
	initial
		#1 ->nlOO1i19_event;
	always @(nlOO1i19_event)
		nlOO1i19 <= {1{1'b1}};
	initial
		nlOO1i20 = 0;
	always @ ( posedge clk)
		  nlOO1i20 <= nlOO1i19;
	initial
		nlOOiO15 = 0;
	always @ ( posedge clk)
		  nlOOiO15 <= nlOOiO16;
	event nlOOiO15_event;
	initial
		#1 ->nlOOiO15_event;
	always @(nlOOiO15_event)
		nlOOiO15 <= {1{1'b1}};
	initial
		nlOOiO16 = 0;
	always @ ( posedge clk)
		  nlOOiO16 <= nlOOiO15;
	initial
		nlOOOl13 = 0;
	always @ ( posedge clk)
		  nlOOOl13 <= nlOOOl14;
	event nlOOOl13_event;
	initial
		#1 ->nlOOOl13_event;
	always @(nlOOOl13_event)
		nlOOOl13 <= {1{1'b1}};
	initial
		nlOOOl14 = 0;
	always @ ( posedge clk)
		  nlOOOl14 <= nlOOOl13;
	initial
	begin
		n00ii = 0;
		n0ill = 0;
		n0iOi = 0;
		n1l1l = 0;
		n1O0i = 0;
		n1O1O = 0;
	end
	always @ ( posedge clk or  negedge reset_n)
	begin
		if (reset_n == 1'b0) 
		begin
			n00ii <= 0;
			n0ill <= 0;
			n0iOi <= 0;
			n1l1l <= 0;
			n1O0i <= 0;
			n1O1O <= 0;
		end
		else 
		begin
			n00ii <= n0ill;
			n0ill <= txdetectrx;
			n0iOi <= rx_detect_valid_sync;
			n1l1l <= n1O1O;
			n1O0i <= rx_detect_valid_sync;
			n1O1O <= txdetectrx;
		end
	end
	initial
	begin
		nlOOO = 0;
		nO = 0;
	end
	always @ (clk or reset_n or wire_nl_CLRN)
	begin
		if (reset_n == 1'b0) 
		begin
			nlOOO <= 1;
			nO <= 1;
		end
		else if  (wire_nl_CLRN == 1'b0) 
		begin
			nlOOO <= 0;
			nO <= 0;
		end
		else 
		if (clk != nl_clk_prev && clk == 1'b1) 
		begin
			nlOOO <= rxelectricalidle;
			nO <= nlOOO;
		end
		nl_clk_prev <= clk;
	end
	assign
		wire_nl_CLRN = (n11Ol2 ^ n11Ol1);
	and(wire_n000i_dataout, (rxd[45] & rxd[46]), ~(nlOi0i));
	and(wire_n001i_dataout, wire_n001O_dataout, ~(nlOill));
	and(wire_n001l_dataout, nlOi0i, ~(nlOiii));
	and(wire_n001O_dataout, wire_n000i_dataout, ~(nlOiii));
	and(wire_n00i_dataout, rxd[9], rrx_pipe_enable);
	and(wire_n00l_dataout, rxd[10], rrx_pipe_enable);
	and(wire_n00O_dataout, rxd[11], rrx_pipe_enable);
	and(wire_n00OO_dataout, rxd[43], (nlOllO & (~ nlOliO)));
	and(wire_n010i_dataout, wire_n01il_dataout, ~(nlOi1l));
	and(wire_n010l_dataout, nlOi1O, ~(nlOi1l));
	and(wire_n010O_dataout, wire_n01iO_dataout, ~(nlOi1l));
	and(wire_n011i_dataout, wire_n010l_dataout, ~(nlOliO));
	and(wire_n011l_dataout, wire_n010O_dataout, ~(nlOliO));
	and(wire_n011O_dataout, wire_n01ii_dataout, ~(nlOliO));
	and(wire_n01i_dataout, rxd[6], rrx_pipe_enable);
	and(wire_n01ii_dataout, wire_n01li_dataout, ~(nlOi1l));
	and(wire_n01il_dataout, wire_n01ll_dataout, ~(nlOi1O));
	and(wire_n01iO_dataout, wire_n01lO_dataout, ~(nlOi1O));
	and(wire_n01l_dataout, rxd[7], rrx_pipe_enable);
	and(wire_n01li_dataout, wire_n01Oi_dataout, ~(nlOi1O));
	and(wire_n01ll_dataout, wire_n01Ol_dataout, ~(nlOl1i));
	or(wire_n01lO_dataout, wire_n01OO_dataout, nlOl1i);
	and(wire_n01O_dataout, rxd[8], rrx_pipe_enable);
	and(wire_n01Oi_dataout, wire_n001i_dataout, ~(nlOl1i));
	or(wire_n01Ol_dataout, wire_n001l_dataout, nlOill);
	and(wire_n01OO_dataout, nlOiii, ~(nlOill));
	and(wire_n0i_dataout, rxd[54], rrx_pipe_enable);
	and(wire_n0i1l_dataout, rxd[41], (nlOllO & (~ nlOliO)));
	and(wire_n0ii_dataout, rxd[12], rrx_pipe_enable);
	and(wire_n0il_dataout, rxd[13], rrx_pipe_enable);
	and(wire_n0iO_dataout, rxd[14], rrx_pipe_enable);
	and(wire_n0l_dataout, rxd[55], rrx_pipe_enable);
	and(wire_n0li_dataout, rxd[15], rrx_pipe_enable);
	and(wire_n0ll_dataout, rxd[16], rrx_pipe_enable);
	and(wire_n0lO_dataout, rxd[17], rrx_pipe_enable);
	and(wire_n0O_dataout, rxd[56], rrx_pipe_enable);
	and(wire_n0Oi_dataout, rxd[18], rrx_pipe_enable);
	and(wire_n0Ol_dataout, rxd[19], rrx_pipe_enable);
	and(wire_n0OO_dataout, rxd[20], rrx_pipe_enable);
	and(wire_n100O_dataout, wire_n10li_dataout, ~((~ reset_n)));
	assign		wire_n10i_dataout = (rrx_pipe_enable === 1'b1) ? wire_nliOl_dataout : rx_found;
	and(wire_n10ii_dataout, wire_n10ll_dataout, ~((~ reset_n)));
	and(wire_n10il_dataout, wire_n10lO_dataout, ~((~ reset_n)));
	and(wire_n10iO_dataout, wire_n10Oi_dataout, ~((~ reset_n)));
	assign		wire_n10l_dataout = (rrx_pipe_enable === 1'b1) ? wire_nliOO_dataout : rx_detect_valid;
	and(wire_n10li_dataout, wire_n10Ol_dataout, ~(nlO0li));
	and(wire_n10ll_dataout, wire_n10OO_dataout, ~(nlO0li));
	and(wire_n10lO_dataout, wire_n1i1i_dataout, ~(nlO0li));
	and(wire_n10O_dataout, wire_nll1i_dataout, rrx_pipe_enable);
	and(wire_n10Oi_dataout, wire_n1i1l_dataout, ~(nlO0li));
	and(wire_n10Ol_dataout, wire_n1i1O_dataout, ~(nlO01i));
	and(wire_n10OO_dataout, nlO01l, ~(nlO01i));
	and(wire_n11i_dataout, wire_n11l_dataout, ~((~ reset_n)));
	assign		wire_n11l_dataout = (rrdwidth_rx === 1'b1) ? ((rxd[10] | rxd[42]) | (~ (n11iO4 ^ n11iO3))) : rxd[10];
	and(wire_n1i_dataout, rxd[51], rrx_pipe_enable);
	and(wire_n1i0i_dataout, wire_n1iii_dataout, ~(nlO01l));
	and(wire_n1i0l_dataout, wire_n1iil_dataout, ~(nlO01l));
	and(wire_n1i0O_dataout, wire_n1iiO_dataout, ~(nlO0ii));
	and(wire_n1i1i_dataout, wire_n1i0i_dataout, ~(nlO01i));
	and(wire_n1i1l_dataout, wire_n1i0l_dataout, ~(nlO01i));
	and(wire_n1i1O_dataout, wire_n1i0O_dataout, ~(nlO01l));
	assign		wire_n1ii_dataout = (rrx_pipe_enable === 1'b1) ? wire_nlOOl_dataout : (~ sigdetni);
	or(wire_n1iii_dataout, wire_n1ili_dataout, nlO0ii);
	and(wire_n1iil_dataout, wire_n1ill_dataout, ~(nlO0ii));
	or(wire_n1iiO_dataout, wire_n1ilO_dataout, nlO00O);
	and(wire_n1il_dataout, wire_n11i_dataout, rrx_pipe_enable);
	and(wire_n1ili_dataout, nlO00i, ~(nlO00O));
	and(wire_n1ill_dataout, wire_n1iOi_dataout, ~(nlO00O));
	and(wire_n1ilO_dataout, nlO01O, ~(nlO00i));
	assign		wire_n1iO_dataout = (rrx_pipe_enable === 1'b1) ? rxpolarity : polinv_rx;
	and(wire_n1iOi_dataout, wire_n1iOl_dataout, ~(nlO00i));
	and(wire_n1iOl_dataout, (rxd[13] & rxd[14]), ~(nlO01O));
	and(wire_n1l_dataout, rxd[52], rrx_pipe_enable);
	and(wire_n1li_dataout, rxd[0], rrx_pipe_enable);
	and(wire_n1liO_dataout, rxd[11], (reset_n & (~ nlO0li)));
	and(wire_n1ll_dataout, rxd[1], rrx_pipe_enable);
	and(wire_n1lll_dataout, rxd[9], (reset_n & (~ nlO0li)));
	and(wire_n1lO_dataout, rxd[2], rrx_pipe_enable);
	and(wire_n1O_dataout, rxd[53], rrx_pipe_enable);
	and(wire_n1Oi_dataout, rxd[3], rrx_pipe_enable);
	and(wire_n1Ol_dataout, rxd[4], rrx_pipe_enable);
	and(wire_n1Oll_dataout, wire_n1OOO_dataout, ~(nlOl0O));
	and(wire_n1OlO_dataout, wire_n011i_dataout, ~(nlOl0O));
	and(wire_n1OO_dataout, rxd[5], rrx_pipe_enable);
	and(wire_n1OOi_dataout, wire_n011l_dataout, ~(nlOl0O));
	and(wire_n1OOl_dataout, wire_n011O_dataout, ~(nlOl0O));
	and(wire_n1OOO_dataout, wire_n010i_dataout, ~(nlOliO));
	and(wire_ni_dataout, rxd[63], rrx_pipe_enable);
	and(wire_ni0i_dataout, rxd[24], rrx_pipe_enable);
	and(wire_ni0l_dataout, rxd[25], rrx_pipe_enable);
	and(wire_ni0O_dataout, rxd[26], rrx_pipe_enable);
	and(wire_ni1i_dataout, rxd[21], rrx_pipe_enable);
	and(wire_ni1l_dataout, rxd[22], rrx_pipe_enable);
	and(wire_ni1O_dataout, rxd[23], rrx_pipe_enable);
	and(wire_nii_dataout, rxd[57], rrx_pipe_enable);
	and(wire_niii_dataout, rxd[27], rrx_pipe_enable);
	and(wire_niil_dataout, rxd[28], rrx_pipe_enable);
	and(wire_niiO_dataout, rxd[29], rrx_pipe_enable);
	and(wire_nil_dataout, rxd[58], rrx_pipe_enable);
	and(wire_nili_dataout, rxd[30], rrx_pipe_enable);
	and(wire_nill_dataout, rxd[31], rrx_pipe_enable);
	and(wire_nilO_dataout, rxd[32], rrx_pipe_enable);
	and(wire_niO_dataout, rxd[59], rrx_pipe_enable);
	and(wire_niOi_dataout, rxd[33], rrx_pipe_enable);
	and(wire_niOl_dataout, rxd[34], rrx_pipe_enable);
	and(wire_niOO_dataout, rxd[35], rrx_pipe_enable);
	and(wire_nl0i_dataout, rxd[39], rrx_pipe_enable);
	and(wire_nl0l_dataout, rxd[40], rrx_pipe_enable);
	and(wire_nl0O_dataout, rxd[41], rrx_pipe_enable);
	and(wire_nl1i_dataout, rxd[36], rrx_pipe_enable);
	and(wire_nl1l_dataout, rxd[37], rrx_pipe_enable);
	and(wire_nl1O_dataout, rxd[38], rrx_pipe_enable);
	and(wire_nli_dataout, rxd[60], rrx_pipe_enable);
	and(wire_nlii_dataout, rxd[42], rrx_pipe_enable);
	and(wire_nlil_dataout, rxd[43], rrx_pipe_enable);
	and(wire_nliO_dataout, rxd[44], rrx_pipe_enable);
	and(wire_nliOl_dataout, wire_nll1l_dataout, ~((~ reset_n)));
	and(wire_nliOO_dataout, wire_nll1O_dataout, ~((~ reset_n)));
	and(wire_nll_dataout, rxd[61], rrx_pipe_enable);
	and(wire_nll0i_dataout, wire_nllii_dataout, ~(nlOOOi));
	and(wire_nll0l_dataout, wire_nllil_dataout, ~(nlOOlO));
	and(wire_nll0O_dataout, wire_nlliO_dataout, ~(nlOOlO));
	and(wire_nll1i_dataout, wire_nll0i_dataout, ~((~ reset_n)));
	or(wire_nll1l_dataout, wire_nll0l_dataout, nlOOOi);
	or(wire_nll1O_dataout, wire_nll0O_dataout, nlOOOi);
	and(wire_nlli_dataout, rxd[45], rrx_pipe_enable);
	or(wire_nllii_dataout, wire_nllli_dataout, nlOOlO);
	or(wire_nllil_dataout, wire_nllll_dataout, nlOOll);
	and(wire_nlliO_dataout, wire_nlllO_dataout, ~(nlOOll));
	and(wire_nlll_dataout, rxd[46], rrx_pipe_enable);
	or(wire_nllli_dataout, wire_nllOi_dataout, nlOOll);
	and(wire_nllll_dataout, wire_nllOl_dataout, ~(nlOOil));
	or(wire_nlllO_dataout, wire_nllOO_dataout, nlOOil);
	and(wire_nllO_dataout, rxd[47], rrx_pipe_enable);
	or(wire_nllOi_dataout, wire_nlO1i_dataout, nlOOil);
	or(wire_nllOl_dataout, wire_nlO1l_dataout, nlOO0O);
	or(wire_nllOO_dataout, wire_nlO1O_dataout, nlOO0O);
	and(wire_nlO_dataout, rxd[62], rrx_pipe_enable);
	and(wire_nlO0i_dataout, (wire_n100O_dataout | wire_n1Oll_dataout), ~(nlOlOO));
	or(wire_nlO1i_dataout, nlOO1O, nlOO0O);
	and(wire_nlO1l_dataout, wire_nlO0i_dataout, ~(nlOO1O));
	and(wire_nlO1O_dataout, nlOlOO, ~(nlOO1O));
	and(wire_nlOi_dataout, rxd[48], rrx_pipe_enable);
	and(wire_nlOl_dataout, rxd[49], rrx_pipe_enable);
	and(wire_nlOO_dataout, rxd[50], rrx_pipe_enable);
	or(wire_nlOOl_dataout, nO, (~ reset_n));
	assign
		n11lO = 1'b1,
		nlO00i = (rclkcmpinsertpad & (nlO0il & nlO00l)),
		nlO00l = (((((((rxd[0] & rxd[1]) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		nlO00O = ((~ rclkcmpinsertpad) & ((~ nlO0iO) & nlO0il)),
		nlO01i = ((~ rxd[13]) & (~ rxd[14])),
		nlO01l = (rxd[13] & (~ rxd[14])),
		nlO01O = (rclkcmpinsertpad & (nlO0il & (~ nlO00l))),
		nlO0ii = ((~ rclkcmpinsertpad) & (nlO0iO & nlO0il)),
		nlO0il = ((~ rxd[13]) & rxd[14]),
		nlO0iO = ((((((((~ rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		nlO0li = ((rx_detect_valid_sync & (~ n1O0i)) & (nlO0ll42 ^ nlO0ll41)),
		nlOi0i = ((rclkcmpinsertpad & (nlOl0i & (~ nlOili))) & (nlOi0l36 ^ nlOi0l35)),
		nlOi1l = ((~ rxd[45]) & (~ rxd[46])),
		nlOi1O = ((rxd[45] & (~ rxd[46])) & (nlO0OO38 ^ nlO0OO37)),
		nlOiii = ((rclkcmpinsertpad & (nlOl0i & nlOili)) & (nlOiil34 ^ nlOiil33)),
		nlOili = ((((((((rxd[32] & rxd[33]) & rxd[34]) & (~ rxd[35])) & rxd[36]) & rxd[37]) & rxd[38]) & rxd[39]) & (nlO0Oi40 ^ nlO0Oi39)),
		nlOill = (((~ rclkcmpinsertpad) & (((~ nlOl0l) & nlOl0i) & (nlOiOl30 ^ nlOiOl29))) & (nlOilO32 ^ nlOilO31)),
		nlOl0i = ((~ rxd[45]) & rxd[46]),
		nlOl0l = ((((((((~ rxd[32]) & rxd[33]) & rxd[34]) & rxd[35]) & rxd[36]) & rxd[37]) & rxd[38]) & rxd[39]),
		nlOl0O = (((~ reset_n) | (~ rrdwidth_rx)) | (~ (nlOlii26 ^ nlOlii25))),
		nlOl1i = (((~ rclkcmpinsertpad) & (nlOl0l & nlOl0i)) & (nlOl1l28 ^ nlOl1l27)),
		nlOliO = ((rx_detect_valid_sync & (~ n0iOi)) & (nlOlli24 ^ nlOlli23)),
		nlOllO = ((reset_n & rrdwidth_rx) & (nlOlOi22 ^ nlOlOi21)),
		nlOlOO = ((wire_n10ii_dataout | wire_n1OlO_dataout) | (~ (nlOO1i20 ^ nlOO1i19))),
		nlOO0O = (nlOOii & rind_error_reporting),
		nlOO1O = ((nlOOii & (~ rind_error_reporting)) & (nlOO0i18 ^ nlOO0i17)),
		nlOOii = (wire_n1liO_dataout | wire_n00OO_dataout),
		nlOOil = ((wire_n10il_dataout | wire_n1OOi_dataout) | (~ (nlOOiO16 ^ nlOOiO15))),
		nlOOll = (wire_n10iO_dataout | wire_n1OOl_dataout),
		nlOOlO = (wire_n1lll_dataout | wire_n0i1l_dataout),
		nlOOOi = ((((~ n1O0i) & ((rx_detect_valid_sync & (latched_p1 & rx_found_sync)) & (n11ii6 ^ n11ii5))) & n1l1l) | ((((~ n0iOi) & ((rx_detect_valid_sync & ((rx_found_sync & ((rrdwidth_rx & latched_p1) & (n110l8 ^ n110l7))) & (n111O10 ^ n111O9))) & (n111i12 ^ n111i11))) & n00ii) & (nlOOOl14 ^ nlOOOl13))),
		polinv_rx_int = wire_n1iO_dataout,
		rxd_ch = {wire_ni_dataout, wire_nlO_dataout, wire_nll_dataout, wire_nli_dataout, wire_niO_dataout, wire_nil_dataout, wire_nii_dataout, wire_n0O_dataout, wire_n0l_dataout, wire_n0i_dataout, wire_n1O_dataout, wire_n1l_dataout, wire_n1i_dataout, wire_nlOO_dataout, wire_nlOl_dataout, wire_nlOi_dataout, wire_nllO_dataout, wire_nlll_dataout, wire_nlli_dataout, wire_nliO_dataout, wire_nlil_dataout, wire_nlii_dataout, wire_nl0O_dataout, wire_nl0l_dataout, wire_nl0i_dataout, wire_nl1O_dataout, wire_nl1l_dataout, wire_nl1i_dataout, wire_niOO_dataout, wire_niOl_dataout, wire_niOi_dataout, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout, wire_niiO_dataout, wire_niil_dataout, wire_niii_dataout, wire_ni0O_dataout, wire_ni0l_dataout, wire_ni0i_dataout, wire_ni1O_dataout, wire_ni1l_dataout, wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout, wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout, wire_n1li_dataout},
		rxelecidle = wire_n1ii_dataout,
		rxstatus = {wire_n10O_dataout, wire_n10l_dataout, wire_n10i_dataout},
		rxvalid = wire_n1il_dataout;
endmodule //arriaii_hssi_rx_pipe_interface
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 36 mux21 13 oper_mux 1 
`timescale 1 ps / 1 ps
module  arriaii_hssi_tx_pipe_interface
	( 
	clk,
	powerdown,
	powerstate,
	refclk_b,
	refclk_b_reset_n,
	reset_n,
	rev_loopbk,
	revloopback,
	rtx_elec_idle_delay,
	rtx_pipe_enable,
	rtxswing_sel_ena,
	tx_elec_idle,
	tx_elec_idle_comp,
	txd,
	txd_ch,
	txdeemph,
	txdeemph_int,
	txdetectrx,
	txdetectrxloopback,
	txelecidle,
	txmargin,
	txmargin_int,
	txswing,
	txswing_int) /* synthesis synthesis_clearbox=1 */;
	input   clk;
	input   [1:0]  powerdown;
	output   [3:0]  powerstate;
	input   refclk_b;
	input   refclk_b_reset_n;
	input   reset_n;
	output   rev_loopbk;
	input   revloopback;
	input   [2:0]  rtx_elec_idle_delay;
	input   rtx_pipe_enable;
	input   rtxswing_sel_ena;
	output   tx_elec_idle;
	input   tx_elec_idle_comp;
	output   [43:0]  txd;
	input   [43:0]  txd_ch;
	input   txdeemph;
	output   txdeemph_int;
	output   txdetectrx;
	input   txdetectrxloopback;
	input   txelecidle;
	input   [2:0]  txmargin;
	output   [2:0]  txmargin_int;
	input   txswing;
	output   txswing_int;

	reg	niiOl23;
	reg	niiOl24;
	reg	nil0i19;
	reg	nil0i20;
	reg	nil0l17;
	reg	nil0l18;
	reg	nil0O15;
	reg	nil0O16;
	reg	nil1i21;
	reg	nil1i22;
	reg	nilii13;
	reg	nilii14;
	reg	niliO11;
	reg	niliO12;
	reg	nilli10;
	reg	nilli9;
	reg	nilOi7;
	reg	nilOi8;
	reg	nilOl5;
	reg	nilOl6;
	reg	niO1i3;
	reg	niO1i4;
	reg	niO1O1;
	reg	niO1O2;
	reg	nl00i;
	reg	nl10i;
	reg	nl10l;
	reg	nl10O;
	reg	nl11O;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1iO;
	reg	nl1li;
	reg	nl01O_clk_prev;
	wire	wire_nl01O_CLRN;
	wire	wire_nl01O_PRN;
	reg	nl1lO;
	reg	nl1ll_clk_prev;
	wire	wire_nl1ll_CLRN;
	wire	wire_nl1ll_PRN;
	wire	wire_nl1ll_ENA;
	reg	nl1Oi;
	reg	nl1OO;
	wire	wire_niOll_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_nl00O_dataout;
	wire	wire_nl0il_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl11i_dataout;
	wire  wire_nl11l_o;
	wire  nil1O;
	wire  nilll;
	wire  nillO;
	wire  nilOO;

	initial
		niiOl23 = 0;
	always @ ( posedge refclk_b)
		  niiOl23 <= niiOl24;
	event niiOl23_event;
	initial
		#1 ->niiOl23_event;
	always @(niiOl23_event)
		niiOl23 <= {1{1'b1}};
	initial
		niiOl24 = 0;
	always @ ( posedge refclk_b)
		  niiOl24 <= niiOl23;
	initial
		nil0i19 = 0;
	always @ ( posedge refclk_b)
		  nil0i19 <= nil0i20;
	event nil0i19_event;
	initial
		#1 ->nil0i19_event;
	always @(nil0i19_event)
		nil0i19 <= {1{1'b1}};
	initial
		nil0i20 = 0;
	always @ ( posedge refclk_b)
		  nil0i20 <= nil0i19;
	initial
		nil0l17 = 0;
	always @ ( posedge refclk_b)
		  nil0l17 <= nil0l18;
	event nil0l17_event;
	initial
		#1 ->nil0l17_event;
	always @(nil0l17_event)
		nil0l17 <= {1{1'b1}};
	initial
		nil0l18 = 0;
	always @ ( posedge refclk_b)
		  nil0l18 <= nil0l17;
	initial
		nil0O15 = 0;
	always @ ( posedge refclk_b)
		  nil0O15 <= nil0O16;
	event nil0O15_event;
	initial
		#1 ->nil0O15_event;
	always @(nil0O15_event)
		nil0O15 <= {1{1'b1}};
	initial
		nil0O16 = 0;
	always @ ( posedge refclk_b)
		  nil0O16 <= nil0O15;
	initial
		nil1i21 = 0;
	always @ ( posedge refclk_b)
		  nil1i21 <= nil1i22;
	event nil1i21_event;
	initial
		#1 ->nil1i21_event;
	always @(nil1i21_event)
		nil1i21 <= {1{1'b1}};
	initial
		nil1i22 = 0;
	always @ ( posedge refclk_b)
		  nil1i22 <= nil1i21;
	initial
		nilii13 = 0;
	always @ ( posedge refclk_b)
		  nilii13 <= nilii14;
	event nilii13_event;
	initial
		#1 ->nilii13_event;
	always @(nilii13_event)
		nilii13 <= {1{1'b1}};
	initial
		nilii14 = 0;
	always @ ( posedge refclk_b)
		  nilii14 <= nilii13;
	initial
		niliO11 = 0;
	always @ ( posedge refclk_b)
		  niliO11 <= niliO12;
	event niliO11_event;
	initial
		#1 ->niliO11_event;
	always @(niliO11_event)
		niliO11 <= {1{1'b1}};
	initial
		niliO12 = 0;
	always @ ( posedge refclk_b)
		  niliO12 <= niliO11;
	initial
		nilli10 = 0;
	always @ ( posedge refclk_b)
		  nilli10 <= nilli9;
	initial
		nilli9 = 0;
	always @ ( posedge refclk_b)
		  nilli9 <= nilli10;
	event nilli9_event;
	initial
		#1 ->nilli9_event;
	always @(nilli9_event)
		nilli9 <= {1{1'b1}};
	initial
		nilOi7 = 0;
	always @ ( posedge refclk_b)
		  nilOi7 <= nilOi8;
	event nilOi7_event;
	initial
		#1 ->nilOi7_event;
	always @(nilOi7_event)
		nilOi7 <= {1{1'b1}};
	initial
		nilOi8 = 0;
	always @ ( posedge refclk_b)
		  nilOi8 <= nilOi7;
	initial
		nilOl5 = 0;
	always @ ( posedge refclk_b)
		  nilOl5 <= nilOl6;
	event nilOl5_event;
	initial
		#1 ->nilOl5_event;
	always @(nilOl5_event)
		nilOl5 <= {1{1'b1}};
	initial
		nilOl6 = 0;
	always @ ( posedge refclk_b)
		  nilOl6 <= nilOl5;
	initial
		niO1i3 = 0;
	always @ ( posedge refclk_b)
		  niO1i3 <= niO1i4;
	event niO1i3_event;
	initial
		#1 ->niO1i3_event;
	always @(niO1i3_event)
		niO1i3 <= {1{1'b1}};
	initial
		niO1i4 = 0;
	always @ ( posedge refclk_b)
		  niO1i4 <= niO1i3;
	initial
		niO1O1 = 0;
	always @ ( posedge refclk_b)
		  niO1O1 <= niO1O2;
	event niO1O1_event;
	initial
		#1 ->niO1O1_event;
	always @(niO1O1_event)
		niO1O1 <= {1{1'b1}};
	initial
		niO1O2 = 0;
	always @ ( posedge refclk_b)
		  niO1O2 <= niO1O1;
	initial
	begin
		nl00i = 0;
		nl10i = 0;
		nl10l = 0;
		nl10O = 0;
		nl11O = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1iO = 0;
		nl1li = 0;
	end
	always @ (refclk_b or wire_nl01O_PRN or wire_nl01O_CLRN)
	begin
		if (wire_nl01O_PRN == 1'b0) 
		begin
			nl00i <= 1;
			nl10i <= 1;
			nl10l <= 1;
			nl10O <= 1;
			nl11O <= 1;
			nl1ii <= 1;
			nl1il <= 1;
			nl1iO <= 1;
			nl1li <= 1;
		end
		else if  (wire_nl01O_CLRN == 1'b0) 
		begin
			nl00i <= 0;
			nl10i <= 0;
			nl10l <= 0;
			nl10O <= 0;
			nl11O <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1iO <= 0;
			nl1li <= 0;
		end
		else 
		if (refclk_b != nl01O_clk_prev && refclk_b == 1'b1) 
		begin
			nl00i <= nl11O;
			nl10i <= nl10l;
			nl10l <= nl10O;
			nl10O <= nl1ii;
			nl11O <= nl10i;
			nl1ii <= nl1il;
			nl1il <= nl1iO;
			nl1iO <= nl1li;
			nl1li <= nilOO;
		end
		nl01O_clk_prev <= refclk_b;
	end
	assign
		wire_nl01O_CLRN = (nilOl6 ^ nilOl5),
		wire_nl01O_PRN = ((nilOi8 ^ nilOi7) & refclk_b_reset_n);
	initial
	begin
		nl1lO = 0;
	end
	always @ (refclk_b or wire_nl1ll_PRN or wire_nl1ll_CLRN)
	begin
		if (wire_nl1ll_PRN == 1'b0) 
		begin
			nl1lO <= 1;
		end
		else if  (wire_nl1ll_CLRN == 1'b0) 
		begin
			nl1lO <= 0;
		end
		else if  (wire_nl1ll_ENA == 1'b1) 
		if (refclk_b != nl1ll_clk_prev && refclk_b == 1'b1) 
		begin
			nl1lO <= nilll;
		end
		nl1ll_clk_prev <= refclk_b;
	end
	assign
		wire_nl1ll_ENA = (((nl1OO & nl1lO) & (nilii14 ^ nilii13)) & (~ nl1Oi)),
		wire_nl1ll_CLRN = (nilli10 ^ nilli9),
		wire_nl1ll_PRN = ((niliO12 ^ niliO11) & refclk_b_reset_n);
	initial
	begin
		nl1Oi = 0;
		nl1OO = 0;
	end
	always @ ( posedge refclk_b or  negedge refclk_b_reset_n)
	begin
		if (refclk_b_reset_n == 1'b0) 
		begin
			nl1Oi <= 0;
			nl1OO <= 0;
		end
		else 
		begin
			nl1Oi <= nl1OO;
			nl1OO <= tx_elec_idle_comp;
		end
	end
	and(wire_niOll_dataout, (powerdown[0] & powerdown[1]), ~(nil1O));
	and(wire_niOlO_dataout, ((~ powerdown[0]) & powerdown[1]), ~(nil1O));
	and(wire_niOOi_dataout, ((powerdown[0] & (~ powerdown[1])) & (niiOl24 ^ niiOl23)), ~(nil1O));
	and(wire_niOOl_dataout, (((~ powerdown[0]) & (~ powerdown[1])) & (nil1i22 ^ nil1i21)), ~(nil1O));
	assign		wire_nl00O_dataout = ((~ rtx_pipe_enable) === 1'b1) ? txdetectrxloopback : (txdetectrxloopback & wire_niOlO_dataout);
	assign		wire_nl0il_dataout = ((~ rtx_pipe_enable) === 1'b1) ? txelecidle : wire_nl11i_dataout;
	assign		wire_nl0iO_dataout = ((~ rtx_pipe_enable) === 1'b1) ? revloopback : ((txdetectrxloopback & wire_niOOl_dataout) & (niO1O2 ^ niO1O1));
	and(wire_nl0ll_dataout, txswing, rtxswing_sel_ena);
	and(wire_nl0lO_dataout, wire_niOOl_dataout, rtx_pipe_enable);
	and(wire_nl0Oi_dataout, wire_niOOi_dataout, rtx_pipe_enable);
	and(wire_nl0Ol_dataout, wire_niOlO_dataout, rtx_pipe_enable);
	and(wire_nl0OO_dataout, wire_niOll_dataout, rtx_pipe_enable);
	assign		wire_nl11i_dataout = ((~ nilOO) === 1'b1) ? nl1li : wire_nl11l_o;
	oper_mux   nl11l
	( 
	.data({((nil0i20 ^ nil0i19) & nl00i), nl11O, nl10i, nl10l, ((nil0l18 ^ nil0l17) & nl10O), nl1ii, nl1il, nl1iO}),
	.o(wire_nl11l_o),
	.sel({rtx_elec_idle_delay[2:1], ((nil0O16 ^ nil0O15) & rtx_elec_idle_delay[0])}));
	defparam
		nl11l.width_data = 8,
		nl11l.width_sel = 3;
	assign
		nil1O = ((~ reset_n) | (~ rtx_pipe_enable)),
		nilll = 1'b0,
		nillO = 1'b1,
		nilOO = ((tx_elec_idle_comp | nl1lO) | (~ (niO1i4 ^ niO1i3))),
		powerstate = {wire_nl0OO_dataout, wire_nl0Ol_dataout, wire_nl0Oi_dataout, wire_nl0lO_dataout},
		rev_loopbk = wire_nl0iO_dataout,
		tx_elec_idle = wire_nl0il_dataout,
		txd = {txd_ch[43:0]},
		txdeemph_int = txdeemph,
		txdetectrx = wire_nl00O_dataout,
		txmargin_int = {txmargin[2:0]},
		txswing_int = wire_nl0ll_dataout;
endmodule //arriaii_hssi_tx_pipe_interface
//synopsys translate_on
//VALID FILE


`timescale 1 ns / 1 ps

module arriaii_hssi_q_pipe_interface_top (
			   
			   // General signals
			   pipe_tx_clk,				// TX PIPE interface clock == TX Phase Comp write clock
			   pipe_rx_clk,				// RX PIPE interface clock == RX Phase Comp read clock
			   refclk_b,					// TX Phase Comp FIFO read clock
			   tx_pipe_reset,				// synchronized reset i.e TX Phase Comp write clock
			   rx_pipe_reset,				// synchronized reset i.e.RX Phase Comp read clock
			   refclk_b_reset,			// synchronized reset i.e.TX Phase Comp read clock
			   
			   // CRAM 
			   rtx_pipe_enable,			// enable tx pipe interface
			   rrx_pipe_enable,			// enable rx pipe interface
			   rrdwidth_rx,				// Single width = 0, double width = 1
			   rtx_elec_idle_delay,		// programmable delay for controlling output buffer
			   rtxswing_sel_ena,			// Enables control of voltage swing level.  Implementation 
			   // is optional under PIPE 1.87.  When this CRAM is not set, full swing is the default mode
			   rrx_detect_bypass,			// normal = 0, bypass = 1
			   rclkcmpinsertpad,			// recognize EDB = 0, PAD = 1 insertion for 8b/10b decode errors
			   rind_error_reporting,		// Combined reporting = 0 i.e. 8b/10b error|disparity error=> rxstatus=3'b100
			   // individual reporting = 1 i.e. 8b/10b error => rxstatus = 3'b111;
			   // disparity error => rxstatus = 3'b100
			   rphystatus_rst_toggle,		// no toggle (gen 2) = 0, toggle (option for gen 1) = 1
			   
			   rphystatus_delay,			// programmable delay for the emulation circuitry of successfull power state
			   // transition.  Default delay between the change of power state and the assertion
			   // of ~ 13 parallel cycles.  Setting of this CRAM to 3'b000 will result in a delay
			   // of ~ 13 parallel cycles.
			   
			   // PLD - PIPE Interface
			   // TX PIPE Interface: Command 
			   txdetectrxloopback,			// P0 ==> loopback, P1 ==> RX detection
			   txelecidle,				// output buffer control
//			   txcompliance,				// compliance pattern command
			   powerdown,				// power state control
			   
			   txdeemph,					// Selects transmitter de-emphasis under Gen 2 speeds
			   txmargin,					// Selects transmitter voltage levels 
			   txswing,					// Selects transmitter voltage swing levels
			   
			   // TX PIPE Interface: Data
			   txd_ch,					// TX data path	
			   
			   // RX PIPE Interface: Command/Status
			   rxpolarity,				// polarity inversion command
			   
			   rxvalid,					// indicates symbol lock and valid data
			   rxelecidle,				// indicates receiver detection of electrical idle.  
			   rxstatus,					// encodes receiver status and error codes when receiving data
			   // encodes compliance pattern speed when doing receiver detection
			   
			   // RX PIPE Interface: Data
			   rxd_ch,					// RX data path
			   
			   // PHYStatus Generator
			   phystatus,				// communicate completion of power state transitions, receiver 
			   // detection, rate change
			   
			   // Commands
			   revloopback,				// enables reverse parallel loopback when in PIPE bypass mode
			   polinv_rx,				// enables polarity inversion when in PIPE bypass mode
			   
			   // PIPE - PCS Inteface
			   // TX PIPE Interface
			   txd,						// TX data path to TX Phase Comp FIFO
			   rev_loopbk,				// reverse parallel loopback control to MUX after the encoder
			   tx_elec_idle_comp,			// compensated txelecidle from the TX Phase Comp FIFO
			   // synchronous to refclk_b
			   
			   // Auto Speed Negotiation
			   rindv_rx,
			   rmaster_rx,
			   rmaster_up_rx,
			   
			   // Auto Negotiation Module
			   speed_change,				// asserted when signaling rate change between Gen 1 and Gen 2 is in process.  Sychronization occurs within PIPE module
			   speed_change_centrl,				
			   speed_change_quad_up,				
			   speed_change_quad_down,	
			   
			   // RX PIPE Interface
			   rxd,						// RX data path from the RX Phase comp FIFO
			   polinv_rx_int,				// polarity inversion control; sychronization occurs at 8b/10b decoder
			   
			   // PIPE - PMA Interface
			   // TX PIPE Interface
			   tx_elec_idle,				// command to the output buffer
			   txdetectrx,				// command to the PMA module for receiver detection
			   powerstate,				// decoded power state: used internally to the PIPE interface
			   sigdetni,				// ww25_2008
			   
			   // RX PIPE Interface
			   rx_found,					// PMA indication of receiver being detected
			   rx_detect_valid,			// Validation of rx_found
			   rxelectricalidle,			// electrical idle detection from Rx Electrical Idle inference module
			   
	txdetectrxin, //shawn
	powerstatein, //shawn
	use_powerstatein, //shawn

			   // PHYStatus Generator
			   power_state_transition_done,	// asserted when successful power state transition occurs
			   power_state_transition_done_ena,	// validates power_state_transition_done, currently tied to 0
			   
			   // PIPE-DPRIO interface
			   txdeemph_int,				// Selects transmitter de-emphasis under Gen 2 speeds
			   txmargin_int,				// Selects transmitter voltage levels 
			   txswing_int				// Selects transmitter voltage swing levels
			   
			   );
   
   //********************************************************************************
   // INCLUDE STATEMENTS
   //********************************************************************************
   
   //********************************************************************************
   // I/O SIGNALS
   //********************************************************************************
   // General signals
input           txdetectrxin; //shawn
input [3:0]     powerstatein; //shawn
input           use_powerstatein; //shawn

   input	pipe_tx_clk;
   input 	pipe_rx_clk;
   input 	refclk_b;
   input 	tx_pipe_reset;
   input 	rx_pipe_reset;
   input 	refclk_b_reset;
   
   // CRAM 
   input 	rtx_pipe_enable;
   input 	rrx_pipe_enable;
   input 	rrdwidth_rx;
   input [2:0] 	rtx_elec_idle_delay;
   input 	rtxswing_sel_ena;
   input 	rrx_detect_bypass;
   input 	rclkcmpinsertpad;
   input 	rind_error_reporting;
   input 	rphystatus_rst_toggle;
   input [2:0] 	rphystatus_delay;
   
   // PLD - PIPE Interface
   // TX PIPE Interface: Command 
   input 	txdetectrxloopback;
   input 	txelecidle;
   input [1:0] 	powerdown;
   
   input 	txdeemph;
   input [2:0] 	txmargin;
   input 	txswing;
   
   // TX PIPE Interface: Data
   input [43:0] txd_ch;
   
   // RX PIPE Interface: Command/Status
   input 	rxpolarity;
   
   // ww25_2008 - Bringing in signal detect from PMA
   // PMA - PIPE interface
   input 	sigdetni;

   output 	rxvalid;
   output 	rxelecidle;
   output [2:0] rxstatus;
   
   // RX PIPE Interface: Data
   output [63:0] rxd_ch;
   
   // PHYStatus Generator
   output 	 phystatus;
   
   // Commands
   input 	 revloopback;
   input 	 polinv_rx;
   
   // PIPE - PCS Inteface
   // TX PIPE Interface
   output [43:0] txd;
   output 	 rev_loopbk;
   input 	 tx_elec_idle_comp;
   
   input 	 rindv_rx;
   input 	 rmaster_rx;             // New bundle mode MDIO, selects master quad
   input 	 rmaster_up_rx;          // New bundle mode MDIO, selects master quad
   
   // Auto Negotiation Module
   input 	speed_change;
   input 	speed_change_centrl;
   input 	speed_change_quad_up;
   input 	speed_change_quad_down;
   
   // RX PIPE Interface
   input [63:0]  rxd;
   output 	 polinv_rx_int;
   
   // PIPE - PMA Interface
   // TX PIPE Interface
   output 	 tx_elec_idle;
   output 	 txdetectrx;
   output [3:0]  powerstate;

   // RX PIPE Interface
   input 	 rx_found;
   input 	 rx_detect_valid;
   input 	 rxelectricalidle;
   
   // PHYStatus Generator
   input 	 power_state_transition_done;
   input 	 power_state_transition_done_ena;
   
   // PIPE-DPRIO interface
   output 	 txdeemph_int;
   output [2:0]  txmargin_int;
   output 	 txswing_int;
   
   
   //********************************************************************************
   // PARAMETERS
   //********************************************************************************
   
   //********************************************************************************
   // DECLARATIONS
   //********************************************************************************
   
   wire 	 phystat_ena;
   
   reg 		 rx_found_reg_0;
   reg 		 rx_found_reg_1;
   
   reg 		 rx_detect_valid_reg_0;
   reg 		 rx_detect_valid_reg_1;
   
   wire 	 tx_pipe_reset_n;
   wire 	 rx_pipe_reset_n;
   wire 	 refclk_b_reset_n;	// reset for txelecidle_d_generator
   
// ww25_2008 - New wire for signal detect
   wire          sigdetni;
   
   reg 		 txdetectrx_reg_0;
   reg 		 txdetectrx_reg_1;
   reg 		 txdetectrx_reg_2;
   reg 		 txdetectrx_reg_3;
   reg 		 txdetectrx_reg_4;
   reg 		 txdetectrx_reg_5;
   reg 		 txdetectrx_reg_6;
   
   reg 		 bypass_rx_found;
   reg 		 bypass_rx_detect_valid;
   
   wire 	 rx_found_int;
   wire 	 rx_detect_valid_int;
   
   wire 	 latched_p0;
   wire 	 latched_p0s;
   wire 	 latched_p1;
   wire 	 latched_p2;
   
   wire 	 p1_sync;
   
wire            tmp_txdetectrxin;   //shawn

   //********************************************************************************
   // ASSIGN STATEMENTS
   //********************************************************************************
   assign 	 phystat_ena = rtx_pipe_enable || rrx_pipe_enable;
   
   assign 	 tx_pipe_reset_n = ~tx_pipe_reset;
   assign 	 rx_pipe_reset_n = ~rx_pipe_reset;
   assign 	 refclk_b_reset_n = ~refclk_b_reset;
   
   assign 	 rx_found_int = rrx_detect_bypass? bypass_rx_found: rx_found_reg_1;
   assign 	 rx_detect_valid_int = rrx_detect_bypass? bypass_rx_detect_valid: rx_detect_valid_reg_1;
   
assign tmp_txdetectrxin = (use_powerstatein == 1'b1) ? txdetectrxin : txdetectrx;  //shawn

assign latched_p0 = (use_powerstatein == 1'b1) ? powerstatein[0] : powerstate [0]; //shawn
assign latched_p0s = (use_powerstatein == 1'b1) ? powerstatein[1] : powerstate [1]; //shawn;
assign latched_p1 = (use_powerstatein == 1'b1) ? powerstatein[2] : powerstate [2]; //shawn;
assign latched_p2 = (use_powerstatein == 1'b1) ? powerstatein[3] : powerstate [3]; //shawn;
  

   //********************************************************************************
   // SUBMODULE INSTANTIATIONS
   //********************************************************************************
   
arriaii_hssi_tx_pipe_interface tx_pipe_interface_inst (
					     
					     // General signals
					     .clk							(pipe_tx_clk),
					     .refclk_b						(refclk_b),
					     .reset_n						(tx_pipe_reset_n),
					     .refclk_b_reset_n				(refclk_b_reset_n),
					     
					     // CRAM 
					     .rtx_pipe_enable				(rtx_pipe_enable),
					     .rtx_elec_idle_delay			(rtx_elec_idle_delay),
					     
					     .rtxswing_sel_ena				(rtxswing_sel_ena),
					     
					     // PLD - PIPE Interface
					     // TX PIPE Interface: Command
					     .txdetectrxloopback				(txdetectrxloopback),
					     .txelecidle					(txelecidle),
//					     .txcompliance					(txcompliance),
					     .powerdown					(powerdown),
					     
					     .txdeemph						(txdeemph),
					     .txmargin						(txmargin),
					     .txswing						(txswing),
					     
					     // TX PIPE Interface: Data
					     .txd_ch						(txd_ch),
					     
					     // Commands
					     .revloopback					(revloopback),
					     
					     // PIPE - PCS Inteface
					     // TX PIPE Interface
					     .txd							(txd),
					     .rev_loopbk					(rev_loopbk),
					     .tx_elec_idle_comp				(tx_elec_idle_comp),
					     
					     
					     // PIPE - PMA Interface
					     .tx_elec_idle					(tx_elec_idle),
					     .txdetectrx					(txdetectrx),
					     
					     // Central PCS
					     .powerstate					(powerstate),
					     
					     // PIPE - DPRIO
					     .txdeemph_int					(txdeemph_int),
					     .txmargin_int					(txmargin_int),
					     .txswing_int					(txswing_int)
					     
					     );
      
   
arriaii_hssi_rx_pipe_interface rx_pipe_interface_inst (
					     
					     // General signals
					     .clk							(pipe_rx_clk),
					     .reset_n						(rx_pipe_reset_n),
					     
					     // CRAM 
					     .rrx_pipe_enable				(rrx_pipe_enable),
					     .rrdwidth_rx					(rrdwidth_rx),
					     .rclkcmpinsertpad				(rclkcmpinsertpad),
					     .rind_error_reporting			(rind_error_reporting),
					     
					     // PLD - PIPE Interface
					     // RX PIPE Interface: Command/Status
					     .rxpolarity					(rxpolarity),
					     
					     .rxvalid						(rxvalid),
					     .rxelecidle					(rxelecidle),
					     .rxstatus						(rxstatus),
					     
					     // RX PIPE Interface: Data
					     .rxd_ch						(rxd_ch),
					     
					     // Commands
					     .polinv_rx					(polinv_rx),
					     
					     // PIPE - PCS Inteface
					     // RX PIPE Interface
					     .rxd							(rxd),
					     .polinv_rx_int					(polinv_rx_int),
					     
					     // TX PIPE Interface
					     // Latched Power State Signals
					     .latched_p1					(latched_p1),
					     
	.txdetectrx					(tmp_txdetectrxin), //shawn (txdetectrx),
					     
					     // PIPE - PMA Interface
					     // TX PIPE Interface
					     .rx_found						(rx_found),
					     .rx_found_sync					(rx_found_int),
					     .rx_detect_valid				(rx_detect_valid),
					     .rx_detect_valid_sync			(rx_detect_valid_int),	
                                             // ww25_2008 - Bringing in signal detect
					     .sigdetni			(sigdetni),	
					     
					     // RX PIPE Interface
					     .rxelectricalidle				(rxelectricalidle)					     
					     );
   
arriaii_hssi_phystatus_generator phystatus_generator_inst (
						 
						 // General signals
						 .clk							(pipe_rx_clk),
						 .reset_n						(rx_pipe_reset_n),
						 
						 //CRAM
						 .phystat_ena					(phystat_ena),
						 .rphystatus_rst_toggle			(rphystatus_rst_toggle),
						 .rphystatus_delay				(rphystatus_delay),
						 
						 // PLD Interface
						 .powerdown					(powerdown),
						 .phystatus					(phystatus),
						 
						 // Latched Power State Signals
						 .latched_p0					(latched_p0),
						 .latched_p0s					(latched_p0s),
						 .latched_p1					(latched_p1),
						 .latched_p2					(latched_p2),
						 
						 .rindv_rx(rindv_rx),
						 .rmaster_rx(rmaster_rx),
						 .rmaster_up_rx(rmaster_up_rx),
						 
						 // Auto Negotiation Module
						 .speed_change(speed_change),	
						 .speed_change_centrl(speed_change_centrl),				
						 .speed_change_quad_up(speed_change_quad_up),				
						 .speed_change_quad_down(speed_change_quad_down),
					      	 
						 // TX PMA Interface
						 .rx_detect_valid				(rx_detect_valid_int),
						 
						 // RX PMA Interface
						 .power_state_transition_done		(power_state_transition_done),
						 .power_state_transition_done_ena	(power_state_transition_done_ena)
						 
						 );
  
 
   //********************************************************************************
   // MAIN CODE 
   //********************************************************************************
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     rx_detect_valid_reg_0	<= #1 1'b0;
	     rx_found_reg_0			<= #1 1'b0;
	  end
	else
	  begin
	     rx_detect_valid_reg_0	<= #1 rx_detect_valid;
	     rx_found_reg_0			<= #1 rx_found;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     rx_detect_valid_reg_1	<= #1 1'b0;
	     rx_found_reg_1			<= #1 1'b0;
	  end
	else
	  begin
	     rx_detect_valid_reg_1	<= #1 rx_detect_valid_reg_0;
	     rx_found_reg_1			<= #1 rx_found_reg_0;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_0	<= #1 1'b0;
	  end
	else
	  begin
		txdetectrx_reg_0 <= #1 tmp_txdetectrxin;      // txdetectrx; shawn
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_1	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_1	<= #1 txdetectrx_reg_0;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_2	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_2	<= #1 txdetectrx_reg_1;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_3	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_3	<= #1 txdetectrx_reg_2;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_4	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_4	<= #1 txdetectrx_reg_3;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_5	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_5	<= #1 txdetectrx_reg_4;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     txdetectrx_reg_6	<= #1 1'b0;
	  end
	else
	  begin
	     txdetectrx_reg_6	<= #1 txdetectrx_reg_5;
	  end
     end
   
   always @ (posedge pipe_rx_clk or negedge rx_pipe_reset_n)
     begin
	if (!rx_pipe_reset_n)
	  begin
	     bypass_rx_found		<= #1 1'b0;
	     bypass_rx_detect_valid	<= #1 1'b0;
	  end
	else
	  begin
	     bypass_rx_found		<= #1 txdetectrx_reg_6;
	     bypass_rx_detect_valid	<= #1 txdetectrx_reg_6;
	  end
     end
   
endmodule // pipe_interface_top


`timescale 1 ps / 1 ps

module arriaii_hssi_tx_digis_txclk_gating (
		     select_n,
		     clk1,
		     clk2,
		     clk1out_n,
		     clk2out_n
		     );
   
   input select_n;
   input clk1;
   input clk2;
   output clk1out_n;
   output clk2out_n;
   
   assign clk1out_n = ~(select_n | clk1);
   assign clk2out_n = ~(~select_n | clk2);
		     
endmodule // txclk_gating




   


`timescale 1 ns / 1 ps

module arriaii_hssi_tx_digi_txclk_ctl (pld_tx_clk,
		  refclk_pma,             
		  txpma_local_clk,        
		  txrst,                  
		  scan_mode,              
		  gen2ngen1,              
    		  gen2ngen1_bundle,       
    		  tx_div2_sync_centrl,    
    		  tx_div2_sync_quad_up,   
    		  tx_div2_sync_quad_down, 
    		  rindv_tx,               
		  rtxwrclksel,            
		  rtxrdclksel,            
    		  rdwidth_tx,             
		  rfreerun_tx,            
    		  rauto_speed_ena,        
    		  rfreq_sel,              
    		  rtxpcsclkpwdn,          
    		  rmaster_tx,             
    		  rmaster_up_tx,          
		  rself_sw_en_tx,         
		  refclk_b,               
		  wr_clk_pos,             
		  fifo_rd_clk,            
		  tx_clk_out,             
		  refclk_b_raw,           
		  wr_clk_pos_raw,         
		  fifo_rd_clk_raw,        
		  tx_div2_sync_out  
                  );
   

   // Clock Inputs
   input        pld_tx_clk;             // PLD clock from PLD clock trees, the transmit clock from XGMII.
   input        refclk_pma;             // Quad based clk from TXPLL
   input        txpma_local_clk;        // Local channel TX PMA clock.

   // Control Inputs
   input        txrst;                  // reset for the tx_pcs
   input        scan_mode;              // Scan mode enable signal for selecting scan_clk from refclk_pma
   
   // New Control Inputs
   input        gen2ngen1;              // from PMA for PCIexp Gen1/Gen2 datawidth scaling
   input 	gen2ngen1_bundle;       // from PMA for PCIexp Gen1/Gen2 datawidth scaling in x4 and x8
   input 	tx_div2_sync_centrl;    // divided clock from the central channel (x2, x4 mode)
   input 	tx_div2_sync_quad_up;   // divided clock from quad above (> x4 mode)
   input 	tx_div2_sync_quad_down; // divided clock from quad below (> x4 mode)
   
   // MDIO Inputs
   input 	rindv_tx;               // Selects between indiv chan. mode and bundled mode
   input        rtxwrclksel;            // Selects which clock writes into FIFO
   input        rtxrdclksel;            // Selects which clock reads from FIFO and also clocks reest of TX logic
   input 	rdwidth_tx;             // divide by 1 or 2 before feeding to FIFO read clock
   input        rfreerun_tx;            // Select whether divider is permamently enabled (free -running) or  divider should be enabled / reset by TX PCS reset  

   // New MDIO Inputs
   input 	  rauto_speed_ena;        // auto speed negotiation enable
   input 	  rfreq_sel;              // freq scaling or data width scaling
   input 	  rtxpcsclkpwdn;          // TX clocking power down enable
   input 	  rmaster_tx;             // New bundle mode MDIO, selects master quad
   input 	  rmaster_up_tx;          // New bundle mode MDIO, selects master quad
   input          rself_sw_en_tx;         // enables self-switch to have correct /2 clock in all quads in bundle mode
   
   // Removed Inputs
   // input        tx_div2_sync_in_ch0;    // from the channel zero tx_div2_sync_out
   // input        tx_div2_sync_in_q0_ch0; // From channel0 of Master Quad
   // input        rphfifo_master_sel_tx;  // TX Phase comp. FIFO tx_div2_sync selection CRAM


   // Clock Outputs wtih CTS
   output       refclk_b;               // Drives the tx channel clock
   output       wr_clk_pos;             // Drives tx phase comp fifo write side
   output       fifo_rd_clk;            // Drives tx phase comp fifo read side

   // Clock Outputs to PLD, w/o CTS
   output       tx_clk_out;             // Drives to the PLD clock tree -- unconnected

   // New Clock Outputs with CTS
   output       refclk_b_raw;            // same as refclk_b, but with no clock gating
   output       wr_clk_pos_raw;          // same as wr_clk_pos, but with no clock gating
   output       fifo_rd_clk_raw;         // same as fifo_rd_clk, but with no clock gating

   // Control Outputs
   output       tx_div2_sync_out;       // Synchronizes the divided by two clock
   

   reg 		fifo_rd_clk_by2;
   reg 		gen2ngen1_local_sync;
   reg [1:0] 	counter;  
   
   wire 	tx_rst_n;
   wire 	tx_div2_sync;
   wire 	dynamic_div2ndiv1;
   wire 	gen2ngen1_local;
   wire 	tx_div2_this_quad;
   wire 	tx_div2_this_channel;
   wire 	tx_div2_other_quad;
   wire 	force_master;
   wire 	rtxpcsclkpwdn_nscan;
   
// shawn initial begin ------
initial begin
    fifo_rd_clk_by2 = 1'b0;
end             
// shawn initial end   ------

   wire 	  select_div1_n;
   wire 	  clk1out_n;
   wire 	  clk2out_n;
   
   // Old bundle logic:   
   // Select between the local synchronization signal or the global synchronization signal (either from Channel0 or 
   // Channel0 of Master Quad
   //assign tx_div2_sync = rindv_tx ? tx_div2_sync_out : tx_div2_sync_in;
   // assign 	tx_div2_sync = (rphfifo_master_sel_tx == 1'b0) ? tx_div2_sync_in_q0_ch0 :
   //                            (rindv_tx == 1'b0) ? tx_div2_sync_in_ch0 : 
   //                            (rauto_speed_ena & ~rfreq_sel) ? (tx_div2_sync_out | ~gen2ngen1_local_sync) : tx_div2_sync_out;

   always @(posedge txrst or posedge refclk_b_raw)
     begin
	if (txrst)
	  counter <= #1 2'b00;
	else if ((rauto_speed_ena & ~rfreq_sel & rself_sw_en_tx) & ~force_master)
	  counter <= #1 counter + 1'b1;
     end

   assign force_master = ((counter == 2'b11) && (rauto_speed_ena & ~rfreq_sel & rself_sw_en_tx)) ? 1'b1 : 1'b0;
      
   assign tx_div2_sync = (rmaster_tx || force_master) ? tx_div2_this_quad : tx_div2_other_quad;
   assign tx_div2_this_quad = (rindv_tx || force_master) ? tx_div2_this_channel : tx_div2_sync_centrl;
   assign tx_div2_this_channel = (rauto_speed_ena && ~rfreq_sel) ? (tx_div2_sync_out | ~gen2ngen1_local_sync) : tx_div2_sync_out;
   assign tx_div2_other_quad = rmaster_up_tx ? tx_div2_sync_quad_up : tx_div2_sync_quad_down;

   assign gen2ngen1_local = (rindv_tx == 1'b0) ? gen2ngen1_bundle : gen2ngen1;
   
   always @(posedge txrst or posedge refclk_b_raw)
     begin
	if (txrst)
	  gen2ngen1_local_sync <= #1 1'b0;
	else 
	  gen2ngen1_local_sync <= #1 gen2ngen1_local;
     end

   assign dynamic_div2ndiv1 = rdwidth_tx | (gen2ngen1_local_sync & rauto_speed_ena & ~rfreq_sel);   


   // Reset for Divide-by-2 FF
   assign tx_rst_n = (rfreerun_tx) ? 1'b1 : ~txrst;


   assign rtxpcsclkpwdn_nscan = rtxpcsclkpwdn & ~scan_mode;

   
   // Full speed clock for TX PCS
   assign refclk_b_raw = (scan_mode || rtxrdclksel) ?  refclk_pma : txpma_local_clk; 

   assign refclk_b = rtxpcsclkpwdn_nscan ? 1'b1 : refclk_b_raw;
   
   
   // Divide-by-2 FF
   always @(negedge tx_rst_n or posedge refclk_b_raw)
     begin
	if (~tx_rst_n)
	  fifo_rd_clk_by2 <= 1'b1;
	else
	  fifo_rd_clk_by2 <= tx_div2_sync; // local divided clock
     end
   
   assign tx_div2_sync_out = ~fifo_rd_clk_by2;   

   
   // TX FIFO read clock: could be fast or divided by 2
   // old code:
   // assign fifo_rd_clk = ((rdwidth_tx == 1'b0) || scan_mode) ? refclk_b_raw : fifo_rd_clk_by2;

   assign select_div1_n = ~(scan_mode | ~dynamic_div2ndiv1);
   
   arriaii_hssi_tx_digis_txclk_gating txclk_gating (
			      .select_n(select_div1_n),
			      .clk1(refclk_b_raw),
			      .clk2(fifo_rd_clk_by2),
			      .clk1out_n(clk1out_n),
			      .clk2out_n(clk2out_n)
			      );
   
   assign fifo_rd_clk_raw = ~(clk1out_n | clk2out_n);

   
   assign fifo_rd_clk = rtxpcsclkpwdn_nscan ? 1'b1 : fifo_rd_clk_raw;

   
   // TX FIFO write clock: used internal clock when in BIST or scan or HIP
   assign wr_clk_pos_raw = (scan_mode || rtxwrclksel) ?  fifo_rd_clk_raw : pld_tx_clk;
   assign wr_clk_pos = rtxpcsclkpwdn_nscan ? 1'b1 : wr_clk_pos_raw;
   
   
   // TX Clock Out
   assign tx_clk_out = fifo_rd_clk; // drives PLD clock tree
   
   
endmodule // txclk_ctl



`timescale 1ps / 1ps

module arriaii_hssi_tx_digis_ram8x49_syn (
    data_in,
    clk,
    fifo_wr,
    rst_l, 
    fifo_re,
    data_out
    );

input 		clk;
input 		rst_l;
input 	[7:0]	fifo_wr;
input 	[7:0] 	fifo_re;
input 	[53:0] 	data_in;
output 	[53:0] 	data_out;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 54;

reg [ram_width-1:0] data_out_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7;

wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7;

assign  data_out = re_l ? 54'h21000000000000 : data_out_i;

always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    fifo_re		
    )
begin
    case ( fifo_re )  // synopsys parallel_case full_case
    8'b00000001 : data_out_i = ram_array_q_0;
    8'b00000010 : data_out_i = ram_array_q_1;
    8'b00000100 : data_out_i = ram_array_q_2;
    8'b00001000 : data_out_i = ram_array_q_3;
    8'b00010000 : data_out_i = ram_array_q_4;
    8'b00100000 : data_out_i = ram_array_q_5;
    8'b01000000 : data_out_i = ram_array_q_6;
    8'b10000000 : data_out_i = ram_array_q_7;
    default     : data_out_i = ram_array_q_0;
    endcase
end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 54'h21000000000000;
	ram_array_q_1 <= #write_access_time 54'h21000000000000;
	ram_array_q_2 <= #write_access_time 54'h21000000000000;
	ram_array_q_3 <= #write_access_time 54'h21000000000000;
        ram_array_q_4 <= #write_access_time 54'h21000000000000;
        ram_array_q_5 <= #write_access_time 54'h21000000000000;
        ram_array_q_6 <= #write_access_time 54'h21000000000000;
        ram_array_q_7 <= #write_access_time 54'h21000000000000;
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	
       )
begin
    if(we) begin
	ram_array_d_0 =  data_reg_0;
	ram_array_d_1 =  data_reg_1;
	ram_array_d_2 =  data_reg_2;
	ram_array_d_3 =  data_reg_3;
        ram_array_d_4 =  data_reg_4;
        ram_array_d_5 =  data_reg_5;
        ram_array_d_6 =  data_reg_6;
        ram_array_d_7 =  data_reg_7; 
    end
    else begin
	ram_array_d_0 =  ram_array_q_0;
	ram_array_d_1 =  ram_array_q_1;
	ram_array_d_2 =  ram_array_q_2;
	ram_array_d_3 =  ram_array_q_3;
        ram_array_d_4 =  ram_array_q_4;
        ram_array_d_5 =  ram_array_q_5;
        ram_array_d_6 =  ram_array_q_6;
        ram_array_d_7 =  ram_array_q_7;
    end
end

endmodule

`timescale 1ps / 1ps

module arriaii_hssi_tx_digis_ph_fifo (
		   // inputs
		   rst_wclk,
		   rst_rclk,
		   wr_clk,
		   rd_clk,
		   bypass_en,
		   //en,
		   lowlatency_en,
		   we,
		   re,
		   din,
		   rphfifo_regmode_tx,
		   rindv_tx,
		   rauto_speed_ena,
		   reset_pc_ptrs,
		   reset_pc_ptrs_centrl,
		   reset_pc_ptrs_quad_up,
		   reset_pc_ptrs_quad_down,	
		   rmaster_tx,
		   rmaster_up_tx,	   
		   // outputs
		   data_out,
		   ph_fifo_full,
		   ph_fifo_empty,
		   wptr_bin,
		   rptr_bin
		   );
   
   // =======
   // inputs
   // =======
   input         rst_wclk;		// wr clk rst
   input         rst_rclk;		// rd clk rst
   input         wr_clk;		// Write Clock
   input         rd_clk;		// Read Clock
   input         bypass_en;	// FIFO bypass enable - only for Altera internal debug
   //input         en;		// Disable FIFO, reset wptr and rptr 
   // only for Altera internal debug
   input         lowlatency_en;	// Enable low latency option 
   input         we;		// PLD dynamic write pointer enable  
   input         re;		// PLD dynamic read pointer enable  
   input [53:0]  din;		// 10-bit code-group bus from deskew module.
   
   input 	 rphfifo_regmode_tx;
   input 	 rindv_tx;
   input 	 rmaster_tx;
   input 	 rmaster_up_tx;
   input 	 rauto_speed_ena;
   input 	 reset_pc_ptrs;
   input 	 reset_pc_ptrs_centrl;
   input 	 reset_pc_ptrs_quad_up;
   input 	 reset_pc_ptrs_quad_down;
   
   // =======
   // outputs
   // =======
   output        ph_fifo_full;	// Indicates overflow (rd_clk)
   output        ph_fifo_empty;	// FIFO empty (rd_clk)
   output [53:0] data_out;		// output data (rd_clk synchronous if not FIFO bypass)
   output [2:0]  wptr_bin;		// wptr test bus
   output [2:0]  rptr_bin;		// rptr test bus
   
   // ===================
   // signal declaration
   // ===================
   reg [ 7:0] 	 wptr, rptr;
   reg [ 7:0] 	 wptr0_pre;
   reg [ 7:0] 	 wptr0;
   reg [ 7:0] 	 wptr1;
   reg [ 2:0] 	 rptr_gray;
   reg [ 2:0] 	 rptr_gray0;
   reg [ 2:0] 	 rptr0;
   reg [ 2:0] 	 rptr1;
   reg [ 7:0] 	 rptr1_onehot;
   reg [ 2:0] 	 wptr_bin;		// wptr test bus
   reg [ 2:0] 	 rptr_bin;		// rptr test bus
   reg 		 first_rd;		// first read after reset
   reg [53:0] 	 ram_data_out;
   wire [53:0] 	 ram_data_out_pre;
   
   reg 		 ph_fifo_full, ph_fifo_empty;
   reg 		 ph_fifo_full_pre;
   
   // Invert rst for new FIFO     
   wire 	 rst_n;
   
   wire [3:0] 	 fifo_cnt;
   reg [3:0] 	 fifo_cnt_pre;
   reg [2:0] 	 wptr1_bin;
   reg [2:0] 	 rptr1_bin_wclk;

   wire 	 reset_ptrs_local;

   reg 		 reset_ptrs_local_sync1;
   reg 		 reset_ptrs_local_sync2;

   
   // =============
   // functionality
   // =============
   assign 	 rst_n = ~rst_wclk;
   
   assign 	 data_out[53:0] = (bypass_en)? din : ram_data_out;

   assign 	 reset_ptrs_local = rauto_speed_ena & (rmaster_tx ? (rindv_tx ? reset_pc_ptrs : reset_pc_ptrs_centrl) : (rmaster_up_tx ? reset_pc_ptrs_quad_up : reset_pc_ptrs_quad_down));
   
   //newly added fifo_cnt and fifo_cnt_pre logic for full/empty flag use
   assign 	 fifo_cnt = (wptr1_bin == rptr1_bin_wclk) ?
                              ((rst_wclk != 1'b1) ? ((fifo_cnt_pre==4'd7 || fifo_cnt_pre==4'd6 || fifo_cnt_pre==4'd8)?4'd8:4'd0) : 4'd0) :
				((wptr1_bin > rptr1_bin_wclk) ?
				 (wptr1_bin - rptr1_bin_wclk) :
				 (4'd8 - {1'b0,(rptr1_bin_wclk - wptr1_bin)} ));  // ww25.2008

   always @ (posedge rst_wclk or posedge wr_clk)
     begin
	if (rst_wclk == 1'b1)
	  begin
	     reset_ptrs_local_sync1 <= #1 1'b0;
	     reset_ptrs_local_sync2 <= #1 1'b0;
	  end 
	else if (rphfifo_regmode_tx)
	  begin
	     reset_ptrs_local_sync1 <= #1 1'b0;
	     reset_ptrs_local_sync2 <= #1 1'b0;
	  end
	else 
	  begin
	     reset_ptrs_local_sync1 <= #1 reset_ptrs_local;
	     reset_ptrs_local_sync2 <= #1 reset_ptrs_local_sync1;
	  end
     end // always @ (posedge rst_wclk or posedge wr_clk)
   
   
//ECO for S4GX to fix metastability issue
// replace the 1st FF with new flop w/o reset
// replace the 2nd FF with an enhanced flop
always @ (posedge wr_clk)
begin
  if (reset_ptrs_local_sync2 || rphfifo_regmode_tx)
    rptr0 <= #1 3'h0;
  else
    rptr0 <= #1 rptr_gray;
end // always @ (posedge rst_wclk or posedge wr_clk)
      
always @ (posedge rst_wclk or posedge wr_clk)
begin
  if (rst_wclk == 1'b1)
    rptr1 <= #1 3'h0;
  else if (reset_ptrs_local_sync2 || rphfifo_regmode_tx)
    rptr1 <= #1 3'h0;
  else
    rptr1 <= #1 rptr0;
end // always @ (posedge rst_wclk or posedge wr_clk)
      
   always @ (posedge rst_wclk or posedge wr_clk)
     begin
	if (rst_wclk == 1'b1)
	  begin
	     wptr  <= #1 8'h01;
	     wptr0_pre <= #1 8'h01;
	     wptr0 <= #1 8'h01;
	     wptr1 <= #1 8'h01;
	     ph_fifo_full_pre <= #1 1'b0;
	     ph_fifo_full <= #1 1'b0;
	     ph_fifo_empty <= #1 1'b0;
	     fifo_cnt_pre <= #1 4'b0000; // fifo_cnt previous value
	  end // if (rst_wclk == 1'b1)
	else if (reset_ptrs_local_sync2 || rphfifo_regmode_tx)
	  begin
	     wptr  <= #1 8'h01;
	     wptr0_pre <= #1 8'h01;
	     wptr0 <= #1 8'h01;
	     wptr1 <= #1 8'h01;
	     ph_fifo_full_pre <= #1 1'b0;
	     ph_fifo_full <= #1 1'b0;
	     ph_fifo_empty <= #1 1'b0;
	     fifo_cnt_pre <= #1 4'b0000; // fifo_cnt previous value
	  end // if (reset_ptrs_local_sync2)
	else
	  begin
	     fifo_cnt_pre <= #1 fifo_cnt;
	     
	     ph_fifo_full <= #1 ph_fifo_full_pre;
	     wptr0_pre <= #1 wptr;
	     wptr0 <= #1 wptr0_pre;
	     wptr1 <= #1 wptr0;
	     
	     // wptr operation
	     if (we == 1'b1)
               wptr <= #1 {wptr[6:0],wptr[7]};
	     
	     // full condition
	     //$if ({wptr1[6:0],wptr1[7]} == rptr1_onehot)
	     //new full flag requirement
             if ((fifo_cnt==4'd8) && (!ph_fifo_empty))
               ph_fifo_full_pre <= #1 1'b1;
	     //else if (ph_fifo_full_pre == 1'b1 & (wptr1 != rptr1_onehot)) //now become sticky flag until reset
               //ph_fifo_full_pre <= #1 1'b0;
	     
	     // empty condition
	     //$if ({rptr1_onehot[6:0],rptr1_onehot[7]} == wptr1)
	     //new empty flag requirement
             if (({wptr1[6:0],wptr1[7]} == rptr1_onehot) && (fifo_cnt_pre==4'd1 || fifo_cnt_pre==4'd0) && (!ph_fifo_full_pre)) //==1 to cover if wptr not moving
               ph_fifo_empty <= #1 1'b1;
	     //else if (ph_fifo_empty == 1'b1 & ({wptr1[6:0],wptr1[7]} != rptr1_onehot)) //now become sticky flag until reset
               //ph_fifo_empty <= #1 1'b0;
	  end
     end // always @ (posedge rst_wclk or posedge wr_clk)
// End of ECO
      
   
   always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk == 1'b1)
	  begin
	     first_rd <= #1 1'b1;
	     rptr  <= #1 8'h20;
	  end
	else if (reset_ptrs_local || rphfifo_regmode_tx)
	  begin
	     first_rd <= #1 1'b1;
	     rptr  <= #1 8'h20;
	  end
	else
	  begin
	     
	     if (first_rd == 1'b1 && re == 1'b1)
               first_rd <= #1 1'b0;
	     
	     // read pointer operation
	     if (re == 1'b1)
               // low latency option, advance 2 on the first read 
               if (first_rd == 1'b1 && lowlatency_en == 1'b1)
		 rptr <= #1 {rptr[5:0],rptr[7:6]};	
               else
		 rptr <= #1 {rptr[6:0],rptr[7]};
	  end
     end // always @ (posedge rst_rclk or posedge rd_clk)
   
   
   // Instantiate FIFO CORE Module. Fifo 8 words deep, 44 bits wide
   /*ram8x44_syn   ram8x44_syn_1 (
    .rst_l (rst_n),
    .clk (wr_clk),
    .fifo_wr (wptr),
    .data_in (din),
    .fifo_re (rptr),
    .data_out (ram_data_out_pre)
    );
    */
   
   arriaii_hssi_tx_digis_ram8x49_syn   ram8x49_syn_1 (
                                .rst_l (rst_n),
                                .clk (wr_clk),
                                .fifo_wr (wptr),
                                .data_in (din),
                                .fifo_re (rptr),
                                .data_out (ram_data_out_pre)
                                );
   
   
   always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk)
	  begin
	     ram_data_out <= #1 54'h20000000000000;
	  end
	else if (rphfifo_regmode_tx)
	  begin
	     ram_data_out <= #1 din;
	  end
	else
	  begin
             ram_data_out <= #1 ram_data_out_pre;
	  end
     end // always @ (posedge rst_rclk or posedge rd_clk)
         
   always@(wptr)
     begin
	case(wptr)
	  8'h01: wptr_bin = 3'h0;
	  8'h02: wptr_bin = 3'h1;
	  8'h04: wptr_bin = 3'h2;
	  8'h08: wptr_bin = 3'h3;
	  8'h10: wptr_bin = 3'h4;
	  8'h20: wptr_bin = 3'h5;
	  8'h40: wptr_bin = 3'h6;
	  8'h80: wptr_bin = 3'h7;
	  default: wptr_bin = 3'h7;
	endcase // case(wptr)
     end // always@ (wptr)
      
   always@(wptr1)
     begin
	case(wptr1)
	  8'h01: wptr1_bin = 3'h0;
	  8'h02: wptr1_bin = 3'h1;
	  8'h04: wptr1_bin = 3'h2;
	  8'h08: wptr1_bin = 3'h3;
	  8'h10: wptr1_bin = 3'h4;
	  8'h20: wptr1_bin = 3'h5;
	  8'h40: wptr1_bin = 3'h6;
	  8'h80: wptr1_bin = 3'h7;
	  default: wptr1_bin = 3'h7;
	endcase // case(wptr1)
     end // always@ (wptr1)
   
   always@(rptr)
     begin
	case(rptr)
	  8'h01: rptr_bin = 3'h0;
	  8'h02: rptr_bin = 3'h1;
	  8'h04: rptr_bin = 3'h2;
	  8'h08: rptr_bin = 3'h3;
	  8'h10: rptr_bin = 3'h4;
	  8'h20: rptr_bin = 3'h5;
	  8'h40: rptr_bin = 3'h6;
	  8'h80: rptr_bin = 3'h7;
	  default: rptr_bin = 3'h7;
	endcase // case(rptr)
     end // always@ (rptr)
      
   always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk == 1'b1)
          rptr_gray <= #1 3'h0;
        else
          rptr_gray <= #1 rptr_gray0;
     end

   always@(rptr)
     begin
	case(rptr)
	  8'h01: rptr_gray0 = 3'h0;
	  8'h02: rptr_gray0 = 3'h1;
	  8'h04: rptr_gray0 = 3'h3;
	  8'h08: rptr_gray0 = 3'h2;
	  8'h10: rptr_gray0 = 3'h6;
	  8'h20: rptr_gray0 = 3'h7;
	  8'h40: rptr_gray0 = 3'h5;
	  8'h80: rptr_gray0 = 3'h4;
	  default: rptr_gray0 = 3'h0;
	endcase // case(rptr)
     end // always@ (rptr)
      
   always@(rptr1)
     begin
	case(rptr1)
	  3'h0: rptr1_onehot = 8'h01;
	  3'h1: rptr1_onehot = 8'h02;
	  3'h3: rptr1_onehot = 8'h04;
	  3'h2: rptr1_onehot = 8'h08;
	  3'h6: rptr1_onehot = 8'h10;
	  3'h7: rptr1_onehot = 8'h20;
	  3'h5: rptr1_onehot = 8'h40;
	  3'h4: rptr1_onehot = 8'h80;
	  default: rptr1_onehot = 8'h01;
	endcase // case(rptr1)
     end // always@ (rptr1)
      
   always@(rptr1)
     begin
	case(rptr1)
	  3'h0: rptr1_bin_wclk = 3'h0;
	  3'h1: rptr1_bin_wclk = 3'h1;
	  3'h3: rptr1_bin_wclk = 3'h2;
	  3'h2: rptr1_bin_wclk = 3'h3;
	  3'h6: rptr1_bin_wclk = 3'h4;
	  3'h7: rptr1_bin_wclk = 3'h5;
	  3'h5: rptr1_bin_wclk = 3'h6;
	  3'h4: rptr1_bin_wclk = 3'h7;
	  default: rptr1_bin_wclk = 3'h0;
	endcase // case(rptr1)
     end // always@ (rptr1)
   
   
endmodule // ph_fifo_tx

`timescale 1 ps / 1ps

module arriaii_hssi_tx_digi_tx_ctrl (
		// inputs
		soft_reset, 
		fifo_wr_clk, 
		fifo_rd_clk,
		refclk_b_in, 
		scan_mode,
		rindv_tx, 
		//is_lane0,
		p_rlpbk, 
		selftest_en, 
		rdwidth_tx,
		txfifo_dis,
		rtxfifo_urst_en,
		txfifo_urst,
		rtxfifo_lowlatency_en,
		rtxphfifopldctl_en,
		rtx_pipe_enable,
		pld_we,
		pld_rd_dis,
		txd,
		txd_extend,
		rforce_disp,	
		tx_data_sg,
		tx_control_sg,	
		rxd_lpbk,
		redund_ctl,
		txd_redun,
		rforce_kchar,
		rforce_echar,
		// PCS bypass
		rtxpcsbypass_en,
		
		// TX PIPE signals
		txdetectrxloopback,
		powerdown,
		
		revloopback,
		txswing,
		txdeemph,
		txmargin,
		
		// RX PIPE signals
		rxpolarity,
		polinv_rx,
		eidleinfersel,
		
		// New inputs for new bundling scheme and new PCIE features like autospeed
    		reset_pc_ptrs,
    		reset_pc_ptrs_centrl,
    		reset_pc_ptrs_quad_up,
    		reset_pc_ptrs_quad_down,
    		gen2ngen1,
    		gen2ngen1_bundle,
    		dis_pc_byte,
    		wr_enable_centrl,
    		wr_enable_quad_up,
    		wr_enable_quad_down,
    		rd_enable_centrl,
    		rd_enable_quad_up,
    		rd_enable_quad_down,
		fifo_select_in_centrl,
    		fifo_select_in_quad_up,
    		fifo_select_in_quad_down,
		
		// New MDIO for new bundling scheme and new PCIE features like autospeed
    		rauto_speed_ena,
    		rfreq_sel,
    		rphfifo_regmode_tx,
    		rmaster_tx,
    		rmaster_up_tx,
		
		// outputs
		txd_extend_tc,
		tx_data_tc,
		tx_ctl_tc,
		tx_data_9_tc,
		rd_enable_sync,
		k_det,
		d21_5_eq_n,
		d2_2_eq_n,
		wr_enable_out,
		rd_enable_out,
		fifo_select_out,
		ph_fifo_full,
		ph_fifo_empty,
		soft_reset_wclk1,
		soft_reset_rclk1,
		pipe_electric_idle,
		
		// TX PIPE signals
		txdetectrxloopback_int,
		powerdown_int,
		
		revloopback_int,
		
		phfifo_txswing,
		phfifo_txdeemph,
		phfifo_txmargin,
		
		// RX PIPE signals
		rxpolarity_int,
		polinv_rx_int,
		gray_eidleinfersel,
		
		// test bus
		// fifo_select_out	// test_bus[8], bit re-used in test bus
		wr_enable2,		// test_bus[7]
		wptr_bin,		// test_bus[6:4]
		rd_enable2,		// test_bus[3]
		rptr_bin		// test_bus[2:0]
		);
   // *_xgmii = from XGMII interface
   // *_sg    = from selftest_gen
   // *_rc    = from rx_ctrl
   
   // ======
   // inputs
   // ======
   input	    soft_reset;	// Reset
   input 	    fifo_wr_clk;	// Used to be wr_clk_pos
   input 	    fifo_rd_clk;	// Coming from txclk_xg_ctl 
   input 	    refclk_b_in;	// The local reference clock used by the internal
   // transmit logic. Used to be tx_clk.
   input 	    scan_mode;	// scan enable
   input 	    p_rlpbk;	// Control bit/pin to enable parallel loop back at XGMII
   input 	    selftest_en;	// To select XGMII signals from selftest_gen (*_sg)
   input 	    rdwidth_tx;		// Control bit to support double-width data bus on xgmii.
   // When set, fifo_wr_clk is running at half frequency
   // as refclk_b_in and 2-byte/code-group of data should be sampled
   // at the rising edge of fifo_wr_clk. When DWIDTH=1'b0, the
   // fifo_wr_clk is running at the same frequency as refclk_b_in.
   input 	    rindv_tx; 
   //input		is_lane0; 	// lane 0 of the quad
   input [39:0]     rxd_lpbk; 	// rx data from rx_ctrl.
   input 	    txfifo_dis;
   
   input [39:0]     txd; 		// Tx data 
   // These extension bits may be used to force disparity or other uses.
   input [3:0] 	    txd_extend; 	// Extend txd by 2 bits. Used to force disparity.
   input [31:0]     tx_data_sg; 	// The xgmii data from selftest_gen..
   input [3:0] 	    tx_control_sg; 	// The xgmii control from selftest_gen.
   input [39:0]     txd_redun; 	// redundant Tx data , unused
   input [3:0] 	    redund_ctl;	// redundant Tx data select, unused
   input 	    rforce_disp; 	// Acting with {txd_extend, TXD[9]	forces current disparity to 1 or 0
   input 	    rforce_kchar;
   input 	    rforce_echar;
   
   input 	    rtxfifo_urst_en;	// user reset CRAM enable
   input 	    txfifo_urst;		// user reset 
   input 	    rtxfifo_lowlatency_en;	// low latency enable
   input 	    rtxphfifopldctl_en;	// CRAM to enable PLD controlled write/read enable
   input 	    rtx_pipe_enable;	// enable pipe
   input 	    pld_we;			// PLD phase comp. fifo we, level active
   input 	    pld_rd_dis;		// PLD phase comp. fifo rd dis, edge active
   // PCS Bypass mode
   input 	    rtxpcsbypass_en;
   
   // TX PIPE interface signals
   input 	    txdetectrxloopback;
   //input			txelecidle; 	txd[9]
   //input			txcompliance;	txd[10] and txd[32]
   input [1:0] 	    powerdown;
   
   input 	    revloopback;
   
   input		txswing;
   input		txdeemph;
   input	[2:0] txmargin;
   
   // RX PIPE interface signals
   input 	    rxpolarity;
   input 	    polinv_rx;
   input	[2:0]	eidleinfersel;
   
   // New Inputs for new bundling scheme and new PCIE features like autospeed
   input 	 reset_pc_ptrs;
   input 	 reset_pc_ptrs_centrl;
   input 	 reset_pc_ptrs_quad_up;
   input 	 reset_pc_ptrs_quad_down;
   input 	 gen2ngen1;
   input 	 gen2ngen1_bundle;
   input 	 dis_pc_byte;
   input 	 wr_enable_centrl;
   input 	 wr_enable_quad_up;
   input 	 wr_enable_quad_down;
   input 	 rd_enable_centrl;
   input 	 rd_enable_quad_up;
   input 	 rd_enable_quad_down;
   input 	 fifo_select_in_centrl;
   input 	 fifo_select_in_quad_up;
   input 	 fifo_select_in_quad_down;
   
   // New MDIO for new bundling scheme and new PCIE features like autospeed
   input 	 rauto_speed_ena;
   input 	 rfreq_sel;
   input 	 rphfifo_regmode_tx;
   input 	 rmaster_tx;
   input 	 rmaster_up_tx;
   
   
   // =======
   // outputs
   // =======
   output [1:0]     txd_extend_tc; 	// This will go to the encoder. This is serialized (muxed) txd_extend_int. But 
   // txd_extend_int has to go through the FIFOs first to be serialized. 
   output 	    wr_enable_out;	// ch0 wr_enable1 output for X4/X8 mode
   output 	    rd_enable_out;	// ch0 rd_enable1 output for X4/X8 mode
   output [15:0]    tx_data_tc; 	// 8-bit data passed onto the internal transmit logic.
   output [1:0]     tx_ctl_tc; 	// Control passed onto the internal transmit logic.
   // Can be bit 8 of the 10-bit code group.
   output [1:0]     tx_data_9_tc;	// Bit 9 of the 10-bit code group passed onto the internal transmit logic.
   output 	    rd_enable_sync;
   output [1:0]     k_det;
   output [1:0]     d21_5_eq_n;
   output [1:0]     d2_2_eq_n;
   output 	    fifo_select_out;	// New output for Rev.B 
   output 	    ph_fifo_full;		// fifo full flag
   output 	    ph_fifo_empty;		// fifo empty flag
   output 	    soft_reset_wclk1;	// synchronized reset for BIST;
   output 	    soft_reset_rclk1;	// syncrhonized reset for PIPE
   output 	    pipe_electric_idle;	// PIPE electric idle bit
   
   // TX PIPE interface signals
   output 	    txdetectrxloopback_int;
   //output			txelecidle; 	txd[9]
   //output			txcompliance;	txd[10] and txd[32]
   output [1:0]     powerdown_int;
   
   output 	    revloopback_int;
   
   output			phfifo_txswing;
   output			phfifo_txdeemph;
   output		[2:0]	phfifo_txmargin;
   
	
   // RX PIPE interface signals
   output 	    rxpolarity_int;
   output 	    polinv_rx_int;
   output	[2:0]	gray_eidleinfersel;
   
   // test bus
   // testbus[8]   = fifo_select_out
   // testbus[7]   = wr_enable2
   // testbus[6:4] = wptr_bin
   // testbus[3]   = rd_enable2
   // testbus[2:0] = rptr_bin
   output 	    wr_enable2;
   output [2:0]     wptr_bin;
   output 	    rd_enable2;
   output [2:0]     rptr_bin;
   
   // ================
   // internal signals
   // ================
   reg 		    rd_enable_sync;		
   
   // Begin: 22 Bits output of this module (44 to 22 / 22 to 22)
   wire [15:0] 	    tx_data_tc;
   wire [1:0] 	    tx_ctl_tc;
   wire [1:0] 	    tx_data_9_tc;
   wire [1:0] 	    txd_extend_tc;
   reg [15:0] 	    tx_data_tc_mux; //temp holder for non PCS bypass data branch before mux
   reg [1:0] 	    tx_ctl_tc_mux; //temp holder for non PCS bypass branch before mux
   reg [1:0] 	    tx_data_9_tc_mux; //temp holder for non PCS bypass branch before mux
   reg [1:0] 	    txd_extend_tc_mux; //temp holder for non PCS bypass branch before mux
   // End:   22 bits output of this module
   
   reg [19:0] 	    tx_data_lt;
   
   wire [39:0] 	    tx_data;
   wire [53:0] 	    din0;
   wire [39:0] 	    fifo_data_out;
   wire [1:0] 	    tx_data_9_tc_d;
   wire [1:0] 	    tx_data_9_tc_d_others;
   wire [1:0] 	    tx_ctl_tc_d;
   wire [1:0] 	    tx_ctl_tc_d_others;
   wire [15:0] 	    tx_data_tc_d;
   wire [17:0] 	    tx_data_tc_d_others;
   wire [1:0] 	    d21_5_eq_n_d;
   wire [1:0] 	    d2_2_eq_n_d;
   reg [1:0] 	    d21_5_eq_n;
   reg [1:0] 	    d2_2_eq_n;
   reg [1:0] 	    k_det; 
   reg [1:0] 	    k_det_sync1;
   reg 		    fifo_select_out;
   
   reg 		    txfifo_en_refclk0;
   reg 		    txfifo_en_refclk1;
   
   reg 		    wr_enable0;
   reg 		    wr_enable0p5;
   reg 		    wr_enable1;
   reg 		    wr_enable2;
   reg 		    rd_enable0;
   reg 		    rd_enable0p5;
   reg 		    rd_enable1;
   reg 		    rd_enable2;
   
   wire [3:0] 	    txd_extend_int;
   wire [1:0] 	    txd_extend_tc_d;// This is registered and sent out to the encoder as txd_extend_tc. 
   // This is serialized (muxed) txd_extend_int. But 
   // txd_extend_int has to go through the FIFOs first to be serialized. 
   wire [1:0] 	    txd_extend_low, txd_extend_high;
   wire [17:0] txd_data_extend_tmp;
   
   reg 		    txfifo_en_rclk0;
   reg 		    txfifo_en_rclk1;
   wire 	    txfifo_en;
   
   wire 	    soft_reset_local;
   reg 		    soft_reset_wclk0;
   reg 		    soft_reset_wclk1_b4scan;
   wire 	    soft_reset_wclk1_wire;
   reg 		    soft_reset_rclk0;
   reg 		    soft_reset_rclk1_b4scan;
   wire 	    soft_reset_rclk1_wire;
   wire [53:0] data_out_temp;
   
   reg 		    pld_rd_dis0, pld_rd_dis1, pld_rd_dis2, pld_rd_dis_edge;
   
   wire [2:0] 	    wptr_bin,rptr_bin;
   reg 		    pipe_electric_idle;	// PIPE electric idle bit
   
   // register rd_enable_sync to fast clock domain. Necessary to send out low 
   // byte first after soft_reset.
   reg 		    rd_enable_sync_refclk_b_in; 
   
   
   // PIPE command signals
   wire [4:0] 	    pipe_cmd;
   wire [4:0] 	    pipe_cmd_out;
   
   wire 	    rxpolarity_int;
   wire 	    polinv_rx_int;

   wire 	    rdwidth_or_auto;
   wire 	    gen2ngen1_int;
   reg 		    gen2ngen1_reg;
   reg 		    gen2ngen1_sync;
   
   wire	[4:0]	pipe_tx_trans;			// PIPE transmitter settings
   									// {txswing, txdeemph, txmargin}
   wire	[4:0]	pipe_tx_trans_out;
   
   reg	[2:0]	gray_eidleinfersel;
   // =============
   // functionality
   // =============
   assign soft_reset_wclk1 = soft_reset_wclk1_wire;
   assign soft_reset_rclk1 = soft_reset_rclk1_wire;
   assign 	    txd_extend_int = rforce_disp ? txd_extend : 4'b0000;
   
   // GiGE Idle Detection, replaced in 8b10b encoder
   assign 	    d21_5_eq_n_d[0] = ({tx_ctl_tc_d[0], tx_data_tc_d[7:0]}  !=  {9'b010110101});
   assign 	    d21_5_eq_n_d[1] = ({tx_ctl_tc_d[1], tx_data_tc_d[15:8]} !=  {9'b010110101});
   assign 	    d2_2_eq_n_d[0]  = ({tx_ctl_tc_d[0], tx_data_tc_d[7:0]}  !=  {9'b001000010});
   assign 	    d2_2_eq_n_d[1]  = ({tx_ctl_tc_d[1], tx_data_tc_d[15:8]} !=  {9'b001000010});
   
   assign 	    wr_enable_out = wr_enable1;
   assign 	    rd_enable_out = rd_enable1;
   
   // 2-17-04 BT: Tied the tx_data[9] to 1'b0 in selftest mode since it effects the 
   //             disparity input in the 8B/10B encoder
   assign 	    tx_data[19:0]  = (p_rlpbk)     ? rxd_lpbk[19:0] :
                    (selftest_en) ? {1'b0, tx_control_sg[1], tx_data_sg[15:8], 1'b0, tx_control_sg[0], tx_data_sg[7:0]} : 
                    (redund_ctl)  ? txd_redun[19:0] : txd[19:0];
   
   // enable 3G double-width BIST by mapping tx_data_sg[15:8] & tx_control_sg[1] to the 3rd symbol location
   assign 	    tx_data[39:20] = (p_rlpbk)     ? rxd_lpbk[39:20] :
                    (selftest_en) ? {1'b0, tx_control_sg[3], tx_data_sg[31:24], 1'b0, tx_control_sg[1], tx_data_sg[15:8]} : 
                    (redund_ctl)  ? txd_redun[39:20] : txd[39:20];	
   
   assign 	    txfifo_en = (rtxfifo_urst_en)? ~txfifo_urst : 1'b1;
   
   // PIPE electric idle is on txd[10]
   //assign pipe_electric_idle = txd_extend_tc_d[0];
   
   assign 	    soft_reset_local = soft_reset | (rtxfifo_urst_en && txfifo_urst);
   
   // PIPE cmd
   assign 	    pipe_cmd = {powerdown, txdetectrxloopback, revloopback, 1'b0};
   
   assign 	    revloopback_int = txfifo_dis? pipe_cmd[1] : pipe_cmd_out[1];
   assign 	    txdetectrxloopback_int = txfifo_dis? pipe_cmd[2] : pipe_cmd_out[2];
   assign 	    powerdown_int = txfifo_dis? pipe_cmd[4:3]: pipe_cmd_out[4:3];
   
   assign 	    rxpolarity_int = rxpolarity;
   assign 	    polinv_rx_int = polinv_rx;


   assign 	    gen2ngen1_int = rindv_tx ? gen2ngen1: gen2ngen1_bundle;
   
   //************************************
   // Synchronization of gen2ngen1
   //************************************
   always @ (posedge soft_reset or posedge refclk_b_in)
     begin
	if(soft_reset)
	  begin
	     gen2ngen1_reg <= 1'b0;
	     gen2ngen1_sync <= 1'b0;
	  end
	else
	  begin
	     gen2ngen1_reg <= gen2ngen1_int;
	     gen2ngen1_sync <= gen2ngen1_reg;
	  end
     end // always @ (posedge soft_reset or posedge refclk_b_in)
      
   assign 	    rdwidth_or_auto = (rdwidth_tx | (rauto_speed_ena & ~rfreq_sel & gen2ngen1_sync));
   
   assign 		pipe_tx_trans = {txswing, txdeemph, txmargin};
   
   assign 		phfifo_txswing = txfifo_dis? pipe_tx_trans[4]: pipe_tx_trans_out[4];
   assign			phfifo_txdeemph = txfifo_dis? pipe_tx_trans[3]: pipe_tx_trans_out[3];
   assign 		phfifo_txmargin = txfifo_dis? pipe_tx_trans [2:0]: pipe_tx_trans_out[2:0];
   
   
   // synchronize reset input (in refclk_b domain)
   always @(posedge soft_reset_local or posedge fifo_wr_clk)
     begin
	if (soft_reset_local)
	  begin
	     soft_reset_wclk0 <= #1 1'b1;
	     soft_reset_wclk1_b4scan <= #1 1'b1;
	  end
	else
	  begin
	     soft_reset_wclk0 <= #1 1'b0;
	     soft_reset_wclk1_b4scan <= #1 soft_reset_wclk0;
	  end
     end // always @ (posedge soft_reset_local or posedge fifo_wr_clk)
      
   assign soft_reset_wclk1_wire = (scan_mode)? 1'b0 : soft_reset_wclk1_b4scan;
   
   // synchronize reset input (in refclk_b domain) and balance it with fifo_wr_clk reset
   always @(posedge soft_reset_local or posedge fifo_rd_clk)
     begin
	if (soft_reset_local)
	  begin
	     soft_reset_rclk0 <= #1 1'b1;
	     soft_reset_rclk1_b4scan <= #1 1'b1;
	  end
	else
	  begin
	     soft_reset_rclk0 <= #1 1'b0;
	     soft_reset_rclk1_b4scan <= #1 soft_reset_rclk0;
	  end
     end // always @ (posedge soft_reset_local or posedge fifo_rd_clk)
      
   assign soft_reset_rclk1_wire = (scan_mode)? 1'b0 : soft_reset_rclk1_b4scan;
   
   // write enable
   always @ (posedge soft_reset_wclk1_wire or posedge fifo_wr_clk)
     begin
	if (soft_reset_wclk1_wire)
	  begin
	     wr_enable0   <= #1 1'b0;
	     wr_enable0p5 <= #1 1'b0;
	     wr_enable1   <= #1 1'b0;
	     wr_enable2   <= #1 1'b0;
	  end
	else
	  begin
	     //wr_enable0   <= txfifo_en;
	     //wr_enable0   <= 1'b1;
	     wr_enable0   <= #1 ~(rauto_speed_ena & dis_pc_byte);
	     wr_enable0p5 <= #1 wr_enable0;
	     wr_enable1   <= #1 (rtxphfifopldctl_en)? (wr_enable0p5 && pld_we) : wr_enable0p5;
	     wr_enable2   <= #1 rmaster_tx ? (rindv_tx ? wr_enable1 : wr_enable_centrl) : (rmaster_up_tx ? wr_enable_quad_up : wr_enable_quad_down);
	  end
     end // always @ (posedge soft_reset_wclk1 or posedge fifo_wr_clk)
      
   assign din0 = {pipe_tx_trans,pipe_cmd,txd_extend_int[3:2], tx_data[39:20], txd_extend_int[1:0], tx_data[19:0]};
   
   // Instantiate new FIFO
   arriaii_hssi_tx_digis_ph_fifo ph_fifo_tx_1 (	.rst_wclk(soft_reset_wclk1_wire),
				.rst_rclk(soft_reset_rclk1_wire),
				.wr_clk(fifo_wr_clk),
				.rd_clk(fifo_rd_clk),
				.bypass_en(txfifo_dis),
				//.en(1'b1),
				.lowlatency_en(rtxfifo_lowlatency_en),
				.we(wr_enable2),
				.re(rd_enable2),
				.din(din0),
				.data_out(data_out_temp),
				.ph_fifo_full(ph_fifo_full),
				.ph_fifo_empty(ph_fifo_empty),
				.wptr_bin(wptr_bin),
				.rptr_bin(rptr_bin),
				.rphfifo_regmode_tx(rphfifo_regmode_tx),
				.rindv_tx(rindv_tx),
				.rmaster_tx(rmaster_tx),
				.rmaster_up_tx(rmaster_up_tx),
				.rauto_speed_ena(rauto_speed_ena), 
				.reset_pc_ptrs(reset_pc_ptrs),
				.reset_pc_ptrs_centrl(reset_pc_ptrs_centrl),
				.reset_pc_ptrs_quad_up(reset_pc_ptrs_quad_up),
				.reset_pc_ptrs_quad_down(reset_pc_ptrs_quad_down)
				);
assign pipe_tx_trans_out = data_out_temp[53:49];
assign pipe_cmd_out = data_out_temp[48: 44];
assign txd_extend_high = data_out_temp[43: 42];
assign fifo_data_out[39:20] = data_out_temp[41: 22];
assign txd_extend_low = data_out_temp[21: 20];
assign fifo_data_out[19:0]= data_out_temp[19: 0];

   // Modified Byte Serializer logic to use fifo_select_out to ping-pong between 
   // low and high banks of FIFO during normal mode
   // Toggle between {19,9} and {39,29} when DWIDTH is set, else fixed to {19,9}
   assign tx_data_9_tc_d = (~txfifo_dis & rd_enable_sync & (~rdwidth_or_auto | fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
			     {fifo_data_out[19], fifo_data_out[9]} :
	  (~txfifo_dis & rd_enable_sync & (rdwidth_or_auto & ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	  {fifo_data_out[39], fifo_data_out[29]} :
          (txfifo_dis & (~rdwidth_or_auto | ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	  {tx_data[19], tx_data[9]}  :  tx_data_9_tc_d_others ;
   
   assign tx_data_9_tc_d_others = (~rforce_kchar & rforce_echar) ? 2'b00 : 
          (txfifo_dis & rdwidth_or_auto & fifo_select_out & ~rforce_kchar & ~rforce_echar) ? 
	    {tx_data_lt[19], tx_data_lt[9]} :  2'b00;
   
   // 8th bit in each word. Toggle between {18,8} and {38,28} when DWIDTH is set, else fixed to {18,8}
   assign tx_ctl_tc_d   =  (~txfifo_dis & rd_enable_sync & (~rdwidth_or_auto | fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
			     {fifo_data_out[18], fifo_data_out[8]}  :
	  (~txfifo_dis & rd_enable_sync & (rdwidth_or_auto & ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	  {fifo_data_out[38], fifo_data_out[28]} :
          (txfifo_dis & (~rdwidth_or_auto | ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? {tx_data[18], tx_data[8]} :
          tx_ctl_tc_d_others ;
   
   // When transmitting Error(FE) or bypassing FIFO, transmit 11 in the former case and transmit bypassed data/ctl in the latter
   assign tx_ctl_tc_d_others = (~rforce_kchar & rforce_echar) ? 2'b11 : 
          (txfifo_dis & rdwidth_or_auto & fifo_select_out & ~rforce_kchar & ~rforce_echar) ? 
	    {tx_data_lt[18], tx_data_lt[8]} :   2'b11;
   
   // After rd_enable_sync goes high, start transmitting. Initially, fifo_select_out is zero, so MSByte transmitted first.
   // Transmit data if not forced Error or K-char.
   assign txd_extend_tc_d =  txd_data_extend_tmp[17:16];
   assign tx_data_tc_d = txd_data_extend_tmp[15:0];
   assign txd_data_extend_tmp = 
	  (~txfifo_dis & rd_enable_sync & (~rdwidth_or_auto | fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	    {txd_extend_low, fifo_data_out[17:10], fifo_data_out[7:0]} : 
	  (~txfifo_dis & rd_enable_sync & (rdwidth_or_auto & ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	  {txd_extend_high, fifo_data_out[37:30], fifo_data_out[27:20]} :
	  (txfifo_dis & (~rdwidth_or_auto | ~fifo_select_out) & ~rforce_kchar & ~rforce_echar) ? 
	  {txd_extend_int[1:0], tx_data[17:10], tx_data[7:0]} : tx_data_tc_d_others;
   
   // When transmitting Error(FE) or bypassing FIFO, transmit FE in the former case and transmit bypassed data/ctl in the latter
   assign tx_data_tc_d_others = (~rforce_kchar & rforce_echar) ? {2'h0,8'b11111110, 8'b11111110} :
          (txfifo_dis & rdwidth_or_auto & fifo_select_out & ~rforce_kchar & ~rforce_echar) ? {txd_extend_int[3:2],tx_data_lt[17:10],tx_data_lt[7:0]} :
          (~rindv_tx)    ?       {2'h0,8'b00000111, 8'b00000111} :      {2'h0,8'b10111100, 8'b10111100} ;
   
   // read enable & 
   // read enable sync (for byte serializer output enable)
   always @(posedge soft_reset_rclk1_wire or posedge fifo_rd_clk)
     begin
	if (soft_reset_rclk1_wire)
	  begin
	     pld_rd_dis0 <= #1 1'b0;
	     pld_rd_dis1 <= #1 1'b0;
	     pld_rd_dis2 <= #1 1'b0;
	     pld_rd_dis_edge <= #1 1'b0;
	     rd_enable0   <= #1 1'b0;
	     rd_enable0p5 <= #1 1'b0;
	     rd_enable1   <= #1 1'b0;
	     rd_enable2   <= #1 1'b0;
	     txfifo_en_rclk0 <= #1 1'b0;
	     txfifo_en_rclk1 <= #1 1'b0;
	     rd_enable_sync  <= #1 1'b0;
	  end
	else
	  begin
	     pld_rd_dis0 <= #1 pld_rd_dis;
	     pld_rd_dis1 <= #1 pld_rd_dis0;
	     pld_rd_dis2 <= #1 pld_rd_dis1;
	     pld_rd_dis_edge <= #1 (pld_rd_dis2 != pld_rd_dis1);
	     
	     
	     //rd_enable0   <= txfifo_en;
	     // rd_enable0   <= 1'b1;
	     rd_enable0   <= #1 ~(rauto_speed_ena & dis_pc_byte);
	     rd_enable0p5 <= #1 rd_enable0;
	     rd_enable1   <= #1 (rtxphfifopldctl_en)? (rd_enable0p5 && !pld_rd_dis_edge) : rd_enable0p5;
	     rd_enable2   <= #1 rmaster_tx ? (rindv_tx ? rd_enable1 : rd_enable_centrl) : (rmaster_up_tx ? rd_enable_quad_up : rd_enable_quad_down);
	     
	     //txfifo_en_rclk0 <= txfifo_en;
	     txfifo_en_rclk0 <= #1 1'b1;
	     txfifo_en_rclk1 <= #1 txfifo_en_rclk0;
	     
	     // start with valid data, so rd_enable_sync serves as dout valid
	     // ideally should be "rptr_bin == 3'd7", 
	     // but fifo_data_out is registered (1 clk delay). rd_enable_sync is
	     // used in high/low byte selection enable
	     if (rphfifo_regmode_tx)
	       rd_enable_sync  <= #1 1'b1;
	     else if (rd_enable_sync == 1'b0 && rptr_bin == 3'd0) 	
	       rd_enable_sync <= #1 rmaster_tx ? (rindv_tx ? rd_enable1 : rd_enable_centrl) : (rmaster_up_tx ? rd_enable_quad_up : rd_enable_quad_down);
	     else if (txfifo_en_rclk1 == 1'b0)
	       rd_enable_sync <= #1 1'b0;
	  end
     end // always @ (posedge soft_reset_rclk1 or posedge fifo_rd_clk)
      
   always @(posedge soft_reset or posedge refclk_b_in)
     begin
	if (soft_reset)
	  begin
	     tx_data_9_tc_mux     <= #1 2'b00;
	     tx_ctl_tc_mux        <= #1 2'b00;
	     tx_data_tc_mux       <= #1 16'h0000;
	     txd_extend_tc_mux    <= #1 2'b00;
	     tx_data_lt       <= #1 20'h00000;
	     d21_5_eq_n  	<= #1 2'b11;
	     d2_2_eq_n   	<= #1 2'b11;
	     k_det_sync1 	<= #1 2'b00;
	     k_det 		<= #1 2'b00;       
	     pipe_electric_idle <= #1 1'b0;
	  end
	else
	  begin
	     tx_data_9_tc_mux     <= #1 tx_data_9_tc_d;
	     tx_ctl_tc_mux        <= #1 tx_ctl_tc_d;
	     tx_data_tc_mux       <= #1 tx_data_tc_d;
	     
	     // PIPE enabled, txd[21] & txd[10] are used as PIPE electric idle
	     // hence in PIPE mode, txd[21] & txd[10](crd_enforce_value) are forced to txd[20] & txd[9] 
	     // (crd_enforce_enable) to have crd negative enable.
	     // crd positive enable is not provided in PIPE mode
	     txd_extend_tc_mux    <= #1 (rtx_pipe_enable) ? {txd_extend_tc_d[1], tx_data_9_tc_d[0]} : txd_extend_tc_d;
	     pipe_electric_idle <= #1 txd_extend_tc_d[0];
	     
	     d21_5_eq_n      	<= #1 d21_5_eq_n_d;
	     d2_2_eq_n       	<= #1 d2_2_eq_n_d;
	     k_det          	<= #1 k_det_sync1;
	     
	     if (rdwidth_or_auto && ~fifo_select_out)
       	       tx_data_lt       <= #1 tx_data[39:20];
	     
	     if ({tx_ctl_tc_d[0], tx_data_tc_d[7:0]} == 9'b110111100)
       	       k_det_sync1[0] <= #1 1'b1;
	     else 
       	       k_det_sync1[0] <= #1 1'b0;
	     
	     if ({tx_ctl_tc_d[1], tx_data_tc_d[15:8]} == 9'b110111100)
       	       k_det_sync1[1] <= #1 1'b1;
	     else 
       	       k_det_sync1[1] <= #1 1'b0;
	  end
     end // always @ (posedge soft_reset or posedge refclk_b_in)
      
   // byte serializer high/low select
   always @(posedge soft_reset or posedge refclk_b_in)
     begin
	if (soft_reset)
	  begin
	     rd_enable_sync_refclk_b_in <= #1 1'b0;
             txfifo_en_refclk0 <= #1 1'b0;
             txfifo_en_refclk1 <= #1 1'b0;
	     fifo_select_out  <= #1 1'b0;
	  end
	else 
	  begin
             //txfifo_en_refclk0 <= txfifo_en;
             // txfifo_en_refclk0 <= 1'b1;
	     txfifo_en_refclk0 <= #1 ~(rauto_speed_ena & dis_pc_byte);
	     txfifo_en_refclk1 <= #1 txfifo_en_refclk0;
	     
             if (txfifo_en_refclk1 ==1'b0)
	       rd_enable_sync_refclk_b_in <= #1 1'b0;
             else if (rd_enable_sync_refclk_b_in == 1'b0)
	       rd_enable_sync_refclk_b_in <= #1 rd_enable2;
	     
             // was ~fifo_select_in, it allows 1 cycle to send the signal across x4, x8 channels
       	     if (rd_enable_sync_refclk_b_in == 1'b1)
	       fifo_select_out  <= #1 rmaster_tx ? (rindv_tx ? ~fifo_select_out : ~fifo_select_in_centrl) : (rmaster_up_tx ? ~fifo_select_in_quad_up : ~fifo_select_in_quad_down);
             else
	       fifo_select_out  <= #1 1'b0;
	  end
     end // always @ (posedge soft_reset or posedge refclk_b_in)
      
   assign tx_data_9_tc = (rtxpcsbypass_en & (~rdwidth_or_auto))? tx_data_9_tc_d : tx_data_9_tc_mux;
   assign tx_ctl_tc = (rtxpcsbypass_en & (~rdwidth_or_auto))? tx_ctl_tc_d : tx_ctl_tc_mux;
   assign tx_data_tc = (rtxpcsbypass_en & (~rdwidth_or_auto))? tx_data_tc_d : tx_data_tc_mux;
   assign txd_extend_tc = (rtxpcsbypass_en & (~rdwidth_or_auto))? txd_extend_tc_d : txd_extend_tc_mux;

// LMC bin to gray for eidlinfersel

always @ (posedge fifo_wr_clk or posedge soft_reset_wclk1_wire)
begin
	if (soft_reset_wclk1_wire)
	begin
		gray_eidleinfersel	<= 3'b000;
	end
	else
	begin
		case (eidleinfersel)
		3'b000:
			gray_eidleinfersel	<= 3'b000;
		3'b001:
			gray_eidleinfersel	<= 3'b001;
		3'b010:
			gray_eidleinfersel	<= 3'b011;
		3'b011:
			gray_eidleinfersel	<= 3'b010;
		3'b100:
			gray_eidleinfersel	<= 3'b110;
		3'b101:
			gray_eidleinfersel	<= 3'b111;
		3'b110:
			gray_eidleinfersel	<= 3'b101;
		3'b111:
			gray_eidleinfersel	<= 3'b100;
		default:
			gray_eidleinfersel	<= 3'b000;
		endcase
	end
end

endmodule // tx_ctrl


//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 211 mux21 446 oper_add 10 oper_selector 88 
`timescale 1 ps / 1 ps
module  arriaii_hssi_tx_digi_bist_gen
	( 
	bist_ctl_sg,
	bist_data_sg,
	rbist_sel,
	rbisten_tx,
	rcxpat_chnl_sel,
	rdwidth_tx,
	rpma_doublewidth_tx,
	rpmadwidth_tx,
	soft_reset,
	tx_clk) /* synthesis synthesis_clearbox=1 */;
	output   [1:0]  bist_ctl_sg;
	output   [15:0]  bist_data_sg;
	input   [1:0]  rbist_sel;
	input   rbisten_tx;
	input   [1:0]  rcxpat_chnl_sel;
	input   rdwidth_tx;
	input   rpma_doublewidth_tx;
	input   rpmadwidth_tx;
	input   soft_reset;
	input   tx_clk;

	reg	ni001l45;
	reg	ni001l46;
	reg	nii00O39;
	reg	nii00O40;
	reg	nii01O41;
	reg	nii01O42;
	reg	nii0il37;
	reg	nii0il38;
	reg	nii0li35;
	reg	nii0li36;
	reg	nii0lO33;
	reg	nii0lO34;
	reg	nii0OO31;
	reg	nii0OO32;
	reg	nii1OO43;
	reg	nii1OO44;
	reg	niii0i23;
	reg	niii0i24;
	reg	niii0O21;
	reg	niii0O22;
	reg	niii1i29;
	reg	niii1i30;
	reg	niii1l27;
	reg	niii1l28;
	reg	niii1O25;
	reg	niii1O26;
	reg	niillO19;
	reg	niillO20;
	reg	niilOi17;
	reg	niilOi18;
	reg	niilOO15;
	reg	niilOO16;
	reg	niiO0i10;
	reg	niiO0i9;
	reg	niiO0O7;
	reg	niiO0O8;
	reg	niiO1i13;
	reg	niiO1i14;
	reg	niiO1l11;
	reg	niiO1l12;
	reg	niiOll5;
	reg	niiOll6;
	reg	niiOOl3;
	reg	niiOOl4;
	reg	nil11i1;
	reg	nil11i2;
	reg	n100i;
	reg	n100l;
	reg	n100O;
	reg	n101i;
	reg	n101l;
	reg	n101O;
	reg	n10ii;
	reg	n10il;
	reg	n10iO;
	reg	n10li;
	reg	n10ll;
	reg	n10lO;
	reg	n10Oi;
	reg	n10Ol;
	reg	n10OO;
	reg	n110i;
	reg	n110l;
	reg	n110O;
	reg	n111i;
	reg	n111l;
	reg	n111O;
	reg	n11ii;
	reg	n11il;
	reg	n11iO;
	reg	n11li;
	reg	n11ll;
	reg	n11lO;
	reg	n11Oi;
	reg	n11Ol;
	reg	n11OO;
	reg	n1i0i;
	reg	n1i0l;
	reg	n1i0O;
	reg	n1i1i;
	reg	n1i1l;
	reg	n1i1O;
	reg	n1iii;
	reg	n1iil;
	reg	n1iiO;
	reg	n1ili;
	reg	n1ill;
	reg	n1ilO;
	reg	n1iOi;
	reg	n1iOl;
	reg	n1iOO;
	reg	n1l0i;
	reg	n1l0l;
	reg	n1l1i;
	reg	n1l1l;
	reg	n1l1O;
	reg	n1lii;
	reg	nliliO;
	reg	nlOOil;
	reg	nlOOiO;
	reg	nlOOli;
	reg	nlOOll;
	reg	nlOOlO;
	reg	nlOOOi;
	reg	nlOOOl;
	reg	nlOOOO;
	reg	n1liO;
	reg	nl00il;
	reg	nl00iO;
	reg	nl00li;
	reg	nl00ll;
	reg	nl00lO;
	reg	nl00Oi;
	reg	nl00Ol;
	reg	nl00OO;
	reg	nl0i0i;
	reg	nl0i0l;
	reg	nl0i0O;
	reg	nl0i1i;
	reg	nl0i1l;
	reg	nl0i1O;
	reg	nl0iii;
	reg	nl0iil;
	reg	nl0iiO;
	reg	nl0ili;
	reg	nl0ill;
	reg	nl0ilO;
	reg	nl0iOi;
	reg	nl0iOl;
	reg	nl0iOO;
	reg	nl0l0i;
	reg	nl0l0l;
	reg	nl0l0O;
	reg	nl0l1i;
	reg	nl0l1l;
	reg	nl0l1O;
	reg	nl0lii;
	reg	nl0lil;
	reg	nl0liO;
	reg	nl0lli;
	reg	nl0lll;
	reg	nl0llO;
	reg	nl0lOi;
	reg	nl0lOl;
	reg	nl0lOO;
	reg	nl0O0i;
	reg	nl0O0l;
	reg	nl0O0O;
	reg	nl0O1i;
	reg	nl0O1l;
	reg	nl0O1O;
	reg	nl0Oii;
	reg	nl0Oil;
	reg	nl0OiO;
	reg	nl0Oli;
	reg	nl0Oll;
	reg	nl0OlO;
	reg	nl0OOi;
	reg	nl0OOl;
	reg	nli11i;
	reg	nl0OOO_clk_prev;
	wire	wire_nl0OOO_PRN;
	reg	nli11O;
	reg	n0lOi;
	reg	niO0l;
	reg	niO0O;
	reg	niOii;
	reg	niOil;
	reg	niOiO;
	reg	niOli;
	reg	niOll;
	reg	niOlO;
	reg	niOOi;
	reg	niOOl;
	reg	niOOO;
	reg	nl00i;
	reg	nl00l;
	reg	nl00O;
	reg	nl01i;
	reg	nl01l;
	reg	nl01O;
	reg	nl0ii;
	reg	nl0il;
	reg	nl0iO;
	reg	nl0li;
	reg	nl0ll;
	reg	nl0lO;
	reg	nl0Oi;
	reg	nl0Ol;
	reg	nl0OO;
	reg	nl10i;
	reg	nl10l;
	reg	nl10O;
	reg	nl11i;
	reg	nl11l;
	reg	nl11O;
	reg	nl1ii;
	reg	nl1il;
	reg	nl1iO;
	reg	nl1li;
	reg	nl1ll;
	reg	nl1lO;
	reg	nl1Oi;
	reg	nl1Ol;
	reg	nl1OO;
	reg	nli0i;
	reg	nli0l;
	reg	nli0O;
	reg	nli1i;
	reg	nli1l;
	reg	nli1O;
	reg	nliil;
	reg	nlili;
	reg	nliiO_clk_prev;
	wire	wire_nliiO_CLRN;
	wire	wire_nliiO_PRN;
	wire	wire_n000i_dataout;
	wire	wire_n000l_dataout;
	wire	wire_n000O_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n1i_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1llO_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1lOO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O1i_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1OiO_dataout;
	wire	wire_n1Oli_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0OO_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii1i_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nili_dataout;
	wire	wire_nilii_dataout;
	wire	wire_nilil_dataout;
	wire	wire_niliO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilli_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nillO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilOi_dataout;
	wire	wire_nilOl_dataout;
	wire	wire_nilOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO00i_dataout;
	wire	wire_niO00l_dataout;
	wire	wire_niO00O_dataout;
	wire	wire_niO01i_dataout;
	wire	wire_niO01l_dataout;
	wire	wire_niO01O_dataout;
	wire	wire_niO0ii_dataout;
	wire	wire_niO0il_dataout;
	wire	wire_niO0iO_dataout;
	wire	wire_niO0li_dataout;
	wire	wire_niO0ll_dataout;
	wire	wire_niO0lO_dataout;
	wire	wire_niO0Oi_dataout;
	wire	wire_niO0Ol_dataout;
	wire	wire_niO0OO_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1iO_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1li_dataout;
	wire	wire_niO1ll_dataout;
	wire	wire_niO1lO_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niO1Oi_dataout;
	wire	wire_niO1Ol_dataout;
	wire	wire_niO1OO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOi0i_dataout;
	wire	wire_niOi0l_dataout;
	wire	wire_niOi0O_dataout;
	wire	wire_niOi1i_dataout;
	wire	wire_niOi1l_dataout;
	wire	wire_niOi1O_dataout;
	wire	wire_niOiii_dataout;
	wire	wire_niOiil_dataout;
	wire	wire_niOiiO_dataout;
	wire	wire_niOili_dataout;
	wire	wire_niOill_dataout;
	wire	wire_niOilO_dataout;
	wire	wire_niOiOi_dataout;
	wire	wire_niOiOl_dataout;
	wire	wire_niOiOO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl0i_dataout;
	wire	wire_niOl0l_dataout;
	wire	wire_niOl0O_dataout;
	wire	wire_niOl1i_dataout;
	wire	wire_niOl1l_dataout;
	wire	wire_niOl1O_dataout;
	wire	wire_niOlii_dataout;
	wire	wire_niOlil_dataout;
	wire	wire_niOliO_dataout;
	wire	wire_niOlli_dataout;
	wire	wire_niOlll_dataout;
	wire	wire_niOllO_dataout;
	wire	wire_niOlOi_dataout;
	wire	wire_niOlOl_dataout;
	wire	wire_niOlOO_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOO0i_dataout;
	wire	wire_niOO0l_dataout;
	wire	wire_niOO0O_dataout;
	wire	wire_niOO1i_dataout;
	wire	wire_niOO1l_dataout;
	wire	wire_niOO1O_dataout;
	wire	wire_niOOii_dataout;
	wire	wire_niOOil_dataout;
	wire	wire_niOOiO_dataout;
	wire	wire_niOOli_dataout;
	wire	wire_niOOll_dataout;
	wire	wire_niOOlO_dataout;
	wire	wire_niOOOi_dataout;
	wire	wire_niOOOl_dataout;
	wire	wire_niOOOO_dataout;
	wire	wire_nl000i_dataout;
	wire	wire_nl000l_dataout;
	wire	wire_nl000O_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl00ii_dataout;
	wire	wire_nl010i_dataout;
	wire	wire_nl010l_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl011i_dataout;
	wire	wire_nl011l_dataout;
	wire	wire_nl011O_dataout;
	wire	wire_nl01ii_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl01OO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl100i_dataout;
	wire	wire_nl100l_dataout;
	wire	wire_nl100O_dataout;
	wire	wire_nl101i_dataout;
	wire	wire_nl101l_dataout;
	wire	wire_nl101O_dataout;
	wire	wire_nl10ii_dataout;
	wire	wire_nl10il_dataout;
	wire	wire_nl10iO_dataout;
	wire	wire_nl10li_dataout;
	wire	wire_nl10ll_dataout;
	wire	wire_nl10lO_dataout;
	wire	wire_nl10Oi_dataout;
	wire	wire_nl10Ol_dataout;
	wire	wire_nl10OO_dataout;
	wire	wire_nl110i_dataout;
	wire	wire_nl110l_dataout;
	wire	wire_nl110O_dataout;
	wire	wire_nl111i_dataout;
	wire	wire_nl111l_dataout;
	wire	wire_nl111O_dataout;
	wire	wire_nl11ii_dataout;
	wire	wire_nl11il_dataout;
	wire	wire_nl11iO_dataout;
	wire	wire_nl11li_dataout;
	wire	wire_nl11ll_dataout;
	wire	wire_nl11lO_dataout;
	wire	wire_nl11Oi_dataout;
	wire	wire_nl11Ol_dataout;
	wire	wire_nl11OO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1i0i_dataout;
	wire	wire_nl1i0l_dataout;
	wire	wire_nl1i0O_dataout;
	wire	wire_nl1i1i_dataout;
	wire	wire_nl1i1l_dataout;
	wire	wire_nl1i1O_dataout;
	wire	wire_nl1iii_dataout;
	wire	wire_nl1iil_dataout;
	wire	wire_nl1iiO_dataout;
	wire	wire_nl1ili_dataout;
	wire	wire_nl1ill_dataout;
	wire	wire_nl1ilO_dataout;
	wire	wire_nl1iOi_dataout;
	wire	wire_nl1iOl_dataout;
	wire	wire_nl1iOO_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1l0i_dataout;
	wire	wire_nl1l0l_dataout;
	wire	wire_nl1l0O_dataout;
	wire	wire_nl1l1i_dataout;
	wire	wire_nl1l1l_dataout;
	wire	wire_nl1l1O_dataout;
	wire	wire_nl1lii_dataout;
	wire	wire_nl1lil_dataout;
	wire	wire_nl1liO_dataout;
	wire	wire_nl1lli_dataout;
	wire	wire_nl1lll_dataout;
	wire	wire_nl1llO_dataout;
	wire	wire_nl1lOi_dataout;
	wire	wire_nl1lOl_dataout;
	wire	wire_nl1lOO_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1O0i_dataout;
	wire	wire_nl1O0l_dataout;
	wire	wire_nl1O0O_dataout;
	wire	wire_nl1O1i_dataout;
	wire	wire_nl1O1l_dataout;
	wire	wire_nl1O1O_dataout;
	wire	wire_nl1Oii_dataout;
	wire	wire_nl1Oil_dataout;
	wire	wire_nl1OiO_dataout;
	wire	wire_nl1Oli_dataout;
	wire	wire_nl1Oll_dataout;
	wire	wire_nl1OlO_dataout;
	wire	wire_nl1OOi_dataout;
	wire	wire_nl1OOl_dataout;
	wire	wire_nl1OOO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00i_dataout;
	wire	wire_nli00l_dataout;
	wire	wire_nli00O_dataout;
	wire	wire_nli01i_dataout;
	wire	wire_nli01l_dataout;
	wire	wire_nli01O_dataout;
	wire	wire_nli0ii_dataout;
	wire	wire_nli0il_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0li_dataout;
	wire	wire_nli10i_dataout;
	wire	wire_nli10l_dataout;
	wire	wire_nli10O_dataout;
	wire	wire_nli1ii_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nli1iO_dataout;
	wire	wire_nli1li_dataout;
	wire	wire_nli1ll_dataout;
	wire	wire_nli1lO_dataout;
	wire	wire_nli1Oi_dataout;
	wire	wire_nli1Ol_dataout;
	wire	wire_nli1OO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nlilll_dataout;
	wire	wire_nlillO_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOll_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll11i_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nll1Oi_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nlllil_dataout;
	wire	wire_nllliO_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nlllll_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllOi_dataout;
	wire	wire_nlllOl_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllO0i_dataout;
	wire	wire_nllO0l_dataout;
	wire	wire_nllO0O_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllO1l_dataout;
	wire	wire_nllO1O_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nllOil_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nllOlO_dataout;
	wire	wire_nllOOi_dataout;
	wire	wire_nllOOl_dataout;
	wire	wire_nllOOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO00i_dataout;
	wire	wire_nlO00l_dataout;
	wire	wire_nlO00O_dataout;
	wire	wire_nlO01i_dataout;
	wire	wire_nlO01l_dataout;
	wire	wire_nlO01O_dataout;
	wire	wire_nlO0ii_dataout;
	wire	wire_nlO0il_dataout;
	wire	wire_nlO0iO_dataout;
	wire	wire_nlO0li_dataout;
	wire	wire_nlO0ll_dataout;
	wire	wire_nlO0lO_dataout;
	wire	wire_nlO0Oi_dataout;
	wire	wire_nlO0Ol_dataout;
	wire	wire_nlO0OO_dataout;
	wire	wire_nlO10i_dataout;
	wire	wire_nlO10l_dataout;
	wire	wire_nlO10O_dataout;
	wire	wire_nlO11i_dataout;
	wire	wire_nlO11l_dataout;
	wire	wire_nlO11O_dataout;
	wire	wire_nlO1ii_dataout;
	wire	wire_nlO1il_dataout;
	wire	wire_nlO1iO_dataout;
	wire	wire_nlO1li_dataout;
	wire	wire_nlO1ll_dataout;
	wire	wire_nlO1lO_dataout;
	wire	wire_nlO1Oi_dataout;
	wire	wire_nlO1Ol_dataout;
	wire	wire_nlO1OO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOi0i_dataout;
	wire	wire_nlOi0O_dataout;
	wire	wire_nlOi1i_dataout;
	wire	wire_nlOi1l_dataout;
	wire	wire_nlOi1O_dataout;
	wire	wire_nlOiii_dataout;
	wire	wire_nlOiil_dataout;
	wire	wire_nlOiiO_dataout;
	wire	wire_nlOili_dataout;
	wire	wire_nlOill_dataout;
	wire	wire_nlOilO_dataout;
	wire	wire_nlOiOi_dataout;
	wire	wire_nlOiOl_dataout;
	wire	wire_nlOiOO_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOl0i_dataout;
	wire	wire_nlOl0l_dataout;
	wire	wire_nlOl0O_dataout;
	wire	wire_nlOl1i_dataout;
	wire	wire_nlOl1l_dataout;
	wire	wire_nlOl1O_dataout;
	wire	wire_nlOlii_dataout;
	wire	wire_nlOlil_dataout;
	wire	wire_nlOliO_dataout;
	wire	wire_nlOlli_dataout;
	wire	wire_nlOlll_dataout;
	wire	wire_nlOllO_dataout;
	wire	wire_nlOlOi_dataout;
	wire	wire_nlOlOl_dataout;
	wire	wire_nlOlOO_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nlOO0i_dataout;
	wire	wire_nlOO0l_dataout;
	wire	wire_nlOO0O_dataout;
	wire	wire_nlOO1i_dataout;
	wire	wire_nlOO1l_dataout;
	wire	wire_nlOO1O_dataout;
	wire  [8:0]   wire_n00Oi_o;
	wire  [3:0]   wire_n01iO_o;
	wire  [2:0]   wire_n1lOi_o;
	wire  [5:0]   wire_n1Oll_o;
	wire  [2:0]   wire_n1OOO_o;
	wire  [6:0]   wire_nli0ll_o;
	wire  [6:0]   wire_nli0lO_o;
	wire  [7:0]   wire_nli0Oi_o;
	wire  [2:0]   wire_nliOl_o;
	wire  [4:0]   wire_nllli_o;
	wire  wire_n0iii_o;
	wire  wire_n0iil_o;
	wire  wire_n0iiO_o;
	wire  wire_n0ilO_o;
	wire  wire_n0iOl_o;
	wire  wire_n0l1i_o;
	wire  wire_n0l1O_o;
	wire  wire_n0lii_o;
	wire  wire_n0lil_o;
	wire  wire_n0liO_o;
	wire  wire_n0lli_o;
	wire  wire_n0lOl_o;
	wire  wire_n0O0l_o;
	wire  wire_n0O1l_o;
	wire  wire_n0Oil_o;
	wire  wire_n0Oll_o;
	wire  wire_n0OOl_o;
	wire  wire_ni00l_o;
	wire  wire_ni01i_o;
	wire  wire_ni01O_o;
	wire  wire_ni0ii_o;
	wire  wire_ni0iO_o;
	wire  wire_ni0ll_o;
	wire  wire_ni0Oi_o;
	wire  wire_ni10i_o;
	wire  wire_ni11l_o;
	wire  wire_ni1Ol_o;
	wire  wire_nil00l_o;
	wire  wire_nil01O_o;
	wire  wire_nil0il_o;
	wire  wire_nil0li_o;
	wire  wire_nil0Oi_o;
	wire  wire_nil1li_o;
	wire  wire_nil1lO_o;
	wire  wire_nil1OO_o;
	wire  wire_nili0i_o;
	wire  wire_nili0O_o;
	wire  wire_nili1i_o;
	wire  wire_niliil_o;
	wire  wire_nilili_o;
	wire  wire_nililO_o;
	wire  wire_niliOl_o;
	wire  wire_nill0O_o;
	wire  wire_nill1i_o;
	wire  wire_nill1O_o;
	wire  wire_nillil_o;
	wire  wire_nillli_o;
	wire  wire_nilllO_o;
	wire  wire_nillOl_o;
	wire  wire_nilO0l_o;
	wire  wire_nilO1i_o;
	wire  wire_nilO1O_o;
	wire  wire_nilOii_o;
	wire  wire_nilOiO_o;
	wire  wire_nilOli_o;
	wire  wire_nilOlO_o;
	wire  wire_nilOOl_o;
	wire  wire_niO11i_o;
	wire  wire_nlilOi_o;
	wire  wire_nliO0l_o;
	wire  wire_nliO1i_o;
	wire  wire_nliO1O_o;
	wire  wire_nliOii_o;
	wire  wire_nliOli_o;
	wire  wire_nliOlO_o;
	wire  wire_nliOOi_o;
	wire  wire_nliOOl_o;
	wire  wire_nll00O_o;
	wire  wire_nll01i_o;
	wire  wire_nll01O_o;
	wire  wire_nll0iO_o;
	wire  wire_nll0lO_o;
	wire  wire_nll0OO_o;
	wire  wire_nll10i_o;
	wire  wire_nll10O_o;
	wire  wire_nll11l_o;
	wire  wire_nll1il_o;
	wire  wire_nll1ll_o;
	wire  wire_nll1Ol_o;
	wire  wire_nlli0i_o;
	wire  wire_nlliil_o;
	wire  wire_nllili_o;
	wire  wire_nllilO_o;
	wire  wire_nlliOi_o;
	wire  wire_nlliOO_o;
	wire  wire_nlll0i_o;
	wire  wire_nlll0O_o;
	wire  wire_nlll1l_o;
	wire  ni000i;
	wire  ni000l;
	wire  ni000O;
	wire  ni001i;
	wire  ni001O;
	wire  ni00ii;
	wire  ni00il;
	wire  ni00iO;
	wire  ni00li;
	wire  ni00ll;
	wire  ni00lO;
	wire  ni00Oi;
	wire  ni00Ol;
	wire  ni00OO;
	wire  ni010i;
	wire  ni010l;
	wire  ni010O;
	wire  ni011i;
	wire  ni011l;
	wire  ni011O;
	wire  ni01ii;
	wire  ni01il;
	wire  ni01iO;
	wire  ni01li;
	wire  ni01ll;
	wire  ni01lO;
	wire  ni01Oi;
	wire  ni01Ol;
	wire  ni01OO;
	wire  ni0i0i;
	wire  ni0i0l;
	wire  ni0i0O;
	wire  ni0i1i;
	wire  ni0i1l;
	wire  ni0i1O;
	wire  ni0iii;
	wire  ni0iil;
	wire  ni0iiO;
	wire  ni0ili;
	wire  ni0ill;
	wire  ni0ilO;
	wire  ni0iOi;
	wire  ni0iOl;
	wire  ni0iOO;
	wire  ni0l0i;
	wire  ni0l0l;
	wire  ni0l0O;
	wire  ni0l1i;
	wire  ni0l1l;
	wire  ni0l1O;
	wire  ni0lii;
	wire  ni0lil;
	wire  ni0liO;
	wire  ni0lli;
	wire  ni0lll;
	wire  ni0llO;
	wire  ni0lOi;
	wire  ni0lOl;
	wire  ni0lOO;
	wire  ni0O0i;
	wire  ni0O0l;
	wire  ni0O0O;
	wire  ni0O1i;
	wire  ni0O1l;
	wire  ni0O1O;
	wire  ni0Oii;
	wire  ni0Oil;
	wire  ni0OiO;
	wire  ni0Oli;
	wire  ni0Oll;
	wire  ni0OlO;
	wire  ni0OOi;
	wire  ni0OOl;
	wire  ni0OOO;
	wire  ni1lll;
	wire  ni1llO;
	wire  ni1lOi;
	wire  ni1lOl;
	wire  ni1lOO;
	wire  ni1O0i;
	wire  ni1O0l;
	wire  ni1O0O;
	wire  ni1O1i;
	wire  ni1O1l;
	wire  ni1O1O;
	wire  ni1Oii;
	wire  ni1Oil;
	wire  ni1OiO;
	wire  ni1Oli;
	wire  ni1Oll;
	wire  ni1OlO;
	wire  ni1OOi;
	wire  ni1OOl;
	wire  ni1OOO;
	wire  nii00l;
	wire  nii01i;
	wire  nii01l;
	wire  nii0ii;
	wire  nii0ll;
	wire  nii0Ol;
	wire  nii10i;
	wire  nii10l;
	wire  nii10O;
	wire  nii11i;
	wire  nii11l;
	wire  nii11O;
	wire  nii1ii;
	wire  nii1il;
	wire  nii1iO;
	wire  nii1li;
	wire  nii1ll;
	wire  nii1lO;
	wire  nii1Oi;
	wire  nii1Ol;
	wire  niii0l;
	wire  niiiil;
	wire  niiiiO;
	wire  niiili;
	wire  niiill;
	wire  niiilO;
	wire  niiiOi;
	wire  niiiOl;
	wire  niiiOO;
	wire  niil0i;
	wire  niil0l;
	wire  niil0O;
	wire  niil1i;
	wire  niil1l;
	wire  niil1O;
	wire  niilii;
	wire  niilil;
	wire  niiliO;
	wire  niilli;
	wire  niilll;
	wire  niilOl;
	wire  niiOil;
	wire  niiOiO;
	wire  niiOli;
	wire  niiOOi;

	initial
		ni001l45 = 0;
	always @ ( posedge tx_clk)
		  ni001l45 <= ni001l46;
	event ni001l45_event;
	initial
		#1 ->ni001l45_event;
	always @(ni001l45_event)
		ni001l45 <= {1{1'b1}};
	initial
		ni001l46 = 0;
	always @ ( posedge tx_clk)
		  ni001l46 <= ni001l45;
	initial
		nii00O39 = 0;
	always @ ( posedge tx_clk)
		  nii00O39 <= nii00O40;
	event nii00O39_event;
	initial
		#1 ->nii00O39_event;
	always @(nii00O39_event)
		nii00O39 <= {1{1'b1}};
	initial
		nii00O40 = 0;
	always @ ( posedge tx_clk)
		  nii00O40 <= nii00O39;
	initial
		nii01O41 = 0;
	always @ ( posedge tx_clk)
		  nii01O41 <= nii01O42;
	event nii01O41_event;
	initial
		#1 ->nii01O41_event;
	always @(nii01O41_event)
		nii01O41 <= {1{1'b1}};
	initial
		nii01O42 = 0;
	always @ ( posedge tx_clk)
		  nii01O42 <= nii01O41;
	initial
		nii0il37 = 0;
	always @ ( posedge tx_clk)
		  nii0il37 <= nii0il38;
	event nii0il37_event;
	initial
		#1 ->nii0il37_event;
	always @(nii0il37_event)
		nii0il37 <= {1{1'b1}};
	initial
		nii0il38 = 0;
	always @ ( posedge tx_clk)
		  nii0il38 <= nii0il37;
	initial
		nii0li35 = 0;
	always @ ( posedge tx_clk)
		  nii0li35 <= nii0li36;
	event nii0li35_event;
	initial
		#1 ->nii0li35_event;
	always @(nii0li35_event)
		nii0li35 <= {1{1'b1}};
	initial
		nii0li36 = 0;
	always @ ( posedge tx_clk)
		  nii0li36 <= nii0li35;
	initial
		nii0lO33 = 0;
	always @ ( posedge tx_clk)
		  nii0lO33 <= nii0lO34;
	event nii0lO33_event;
	initial
		#1 ->nii0lO33_event;
	always @(nii0lO33_event)
		nii0lO33 <= {1{1'b1}};
	initial
		nii0lO34 = 0;
	always @ ( posedge tx_clk)
		  nii0lO34 <= nii0lO33;
	initial
		nii0OO31 = 0;
	always @ ( posedge tx_clk)
		  nii0OO31 <= nii0OO32;
	event nii0OO31_event;
	initial
		#1 ->nii0OO31_event;
	always @(nii0OO31_event)
		nii0OO31 <= {1{1'b1}};
	initial
		nii0OO32 = 0;
	always @ ( posedge tx_clk)
		  nii0OO32 <= nii0OO31;
	initial
		nii1OO43 = 0;
	always @ ( posedge tx_clk)
		  nii1OO43 <= nii1OO44;
	event nii1OO43_event;
	initial
		#1 ->nii1OO43_event;
	always @(nii1OO43_event)
		nii1OO43 <= {1{1'b1}};
	initial
		nii1OO44 = 0;
	always @ ( posedge tx_clk)
		  nii1OO44 <= nii1OO43;
	initial
		niii0i23 = 0;
	always @ ( posedge tx_clk)
		  niii0i23 <= niii0i24;
	event niii0i23_event;
	initial
		#1 ->niii0i23_event;
	always @(niii0i23_event)
		niii0i23 <= {1{1'b1}};
	initial
		niii0i24 = 0;
	always @ ( posedge tx_clk)
		  niii0i24 <= niii0i23;
	initial
		niii0O21 = 0;
	always @ ( posedge tx_clk)
		  niii0O21 <= niii0O22;
	event niii0O21_event;
	initial
		#1 ->niii0O21_event;
	always @(niii0O21_event)
		niii0O21 <= {1{1'b1}};
	initial
		niii0O22 = 0;
	always @ ( posedge tx_clk)
		  niii0O22 <= niii0O21;
	initial
		niii1i29 = 0;
	always @ ( posedge tx_clk)
		  niii1i29 <= niii1i30;
	event niii1i29_event;
	initial
		#1 ->niii1i29_event;
	always @(niii1i29_event)
		niii1i29 <= {1{1'b1}};
	initial
		niii1i30 = 0;
	always @ ( posedge tx_clk)
		  niii1i30 <= niii1i29;
	initial
		niii1l27 = 0;
	always @ ( posedge tx_clk)
		  niii1l27 <= niii1l28;
	event niii1l27_event;
	initial
		#1 ->niii1l27_event;
	always @(niii1l27_event)
		niii1l27 <= {1{1'b1}};
	initial
		niii1l28 = 0;
	always @ ( posedge tx_clk)
		  niii1l28 <= niii1l27;
	initial
		niii1O25 = 0;
	always @ ( posedge tx_clk)
		  niii1O25 <= niii1O26;
	event niii1O25_event;
	initial
		#1 ->niii1O25_event;
	always @(niii1O25_event)
		niii1O25 <= {1{1'b1}};
	initial
		niii1O26 = 0;
	always @ ( posedge tx_clk)
		  niii1O26 <= niii1O25;
	initial
		niillO19 = 0;
	always @ ( posedge tx_clk)
		  niillO19 <= niillO20;
	event niillO19_event;
	initial
		#1 ->niillO19_event;
	always @(niillO19_event)
		niillO19 <= {1{1'b1}};
	initial
		niillO20 = 0;
	always @ ( posedge tx_clk)
		  niillO20 <= niillO19;
	initial
		niilOi17 = 0;
	always @ ( posedge tx_clk)
		  niilOi17 <= niilOi18;
	event niilOi17_event;
	initial
		#1 ->niilOi17_event;
	always @(niilOi17_event)
		niilOi17 <= {1{1'b1}};
	initial
		niilOi18 = 0;
	always @ ( posedge tx_clk)
		  niilOi18 <= niilOi17;
	initial
		niilOO15 = 0;
	always @ ( posedge tx_clk)
		  niilOO15 <= niilOO16;
	event niilOO15_event;
	initial
		#1 ->niilOO15_event;
	always @(niilOO15_event)
		niilOO15 <= {1{1'b1}};
	initial
		niilOO16 = 0;
	always @ ( posedge tx_clk)
		  niilOO16 <= niilOO15;
	initial
		niiO0i10 = 0;
	always @ ( posedge tx_clk)
		  niiO0i10 <= niiO0i9;
	initial
		niiO0i9 = 0;
	always @ ( posedge tx_clk)
		  niiO0i9 <= niiO0i10;
	event niiO0i9_event;
	initial
		#1 ->niiO0i9_event;
	always @(niiO0i9_event)
		niiO0i9 <= {1{1'b1}};
	initial
		niiO0O7 = 0;
	always @ ( posedge tx_clk)
		  niiO0O7 <= niiO0O8;
	event niiO0O7_event;
	initial
		#1 ->niiO0O7_event;
	always @(niiO0O7_event)
		niiO0O7 <= {1{1'b1}};
	initial
		niiO0O8 = 0;
	always @ ( posedge tx_clk)
		  niiO0O8 <= niiO0O7;
	initial
		niiO1i13 = 0;
	always @ ( posedge tx_clk)
		  niiO1i13 <= niiO1i14;
	event niiO1i13_event;
	initial
		#1 ->niiO1i13_event;
	always @(niiO1i13_event)
		niiO1i13 <= {1{1'b1}};
	initial
		niiO1i14 = 0;
	always @ ( posedge tx_clk)
		  niiO1i14 <= niiO1i13;
	initial
		niiO1l11 = 0;
	always @ ( posedge tx_clk)
		  niiO1l11 <= niiO1l12;
	event niiO1l11_event;
	initial
		#1 ->niiO1l11_event;
	always @(niiO1l11_event)
		niiO1l11 <= {1{1'b1}};
	initial
		niiO1l12 = 0;
	always @ ( posedge tx_clk)
		  niiO1l12 <= niiO1l11;
	initial
		niiOll5 = 0;
	always @ ( posedge tx_clk)
		  niiOll5 <= niiOll6;
	event niiOll5_event;
	initial
		#1 ->niiOll5_event;
	always @(niiOll5_event)
		niiOll5 <= {1{1'b1}};
	initial
		niiOll6 = 0;
	always @ ( posedge tx_clk)
		  niiOll6 <= niiOll5;
	initial
		niiOOl3 = 0;
	always @ ( posedge tx_clk)
		  niiOOl3 <= niiOOl4;
	event niiOOl3_event;
	initial
		#1 ->niiOOl3_event;
	always @(niiOOl3_event)
		niiOOl3 <= {1{1'b1}};
	initial
		niiOOl4 = 0;
	always @ ( posedge tx_clk)
		  niiOOl4 <= niiOOl3;
	initial
		nil11i1 = 0;
	always @ ( posedge tx_clk)
		  nil11i1 <= nil11i2;
	event nil11i1_event;
	initial
		#1 ->nil11i1_event;
	always @(nil11i1_event)
		nil11i1 <= {1{1'b1}};
	initial
		nil11i2 = 0;
	always @ ( posedge tx_clk)
		  nil11i2 <= nil11i1;
	initial
	begin
		n100i = 0;
		n100l = 0;
		n100O = 0;
		n101i = 0;
		n101l = 0;
		n101O = 0;
		n10ii = 0;
		n10il = 0;
		n10iO = 0;
		n10li = 0;
		n10ll = 0;
		n10lO = 0;
		n10Oi = 0;
		n10Ol = 0;
		n10OO = 0;
		n110i = 0;
		n110l = 0;
		n110O = 0;
		n111i = 0;
		n111l = 0;
		n111O = 0;
		n11ii = 0;
		n11il = 0;
		n11iO = 0;
		n11li = 0;
		n11ll = 0;
		n11lO = 0;
		n11Oi = 0;
		n11Ol = 0;
		n11OO = 0;
		n1i0i = 0;
		n1i0l = 0;
		n1i0O = 0;
		n1i1i = 0;
		n1i1l = 0;
		n1i1O = 0;
		n1iii = 0;
		n1iil = 0;
		n1iiO = 0;
		n1ili = 0;
		n1ill = 0;
		n1ilO = 0;
		n1iOi = 0;
		n1iOl = 0;
		n1iOO = 0;
		n1l0i = 0;
		n1l0l = 0;
		n1l1i = 0;
		n1l1l = 0;
		n1l1O = 0;
		n1lii = 0;
		nliliO = 0;
		nlOOil = 0;
		nlOOiO = 0;
		nlOOli = 0;
		nlOOll = 0;
		nlOOlO = 0;
		nlOOOi = 0;
		nlOOOl = 0;
		nlOOOO = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n100i <= 0;
			n100l <= 0;
			n100O <= 0;
			n101i <= 0;
			n101l <= 0;
			n101O <= 0;
			n10ii <= 0;
			n10il <= 0;
			n10iO <= 0;
			n10li <= 0;
			n10ll <= 0;
			n10lO <= 0;
			n10Oi <= 0;
			n10Ol <= 0;
			n10OO <= 0;
			n110i <= 0;
			n110l <= 0;
			n110O <= 0;
			n111i <= 0;
			n111l <= 0;
			n111O <= 0;
			n11ii <= 0;
			n11il <= 0;
			n11iO <= 0;
			n11li <= 0;
			n11ll <= 0;
			n11lO <= 0;
			n11Oi <= 0;
			n11Ol <= 0;
			n11OO <= 0;
			n1i0i <= 0;
			n1i0l <= 0;
			n1i0O <= 0;
			n1i1i <= 0;
			n1i1l <= 0;
			n1i1O <= 0;
			n1iii <= 0;
			n1iil <= 0;
			n1iiO <= 0;
			n1ili <= 0;
			n1ill <= 0;
			n1ilO <= 0;
			n1iOi <= 0;
			n1iOl <= 0;
			n1iOO <= 0;
			n1l0i <= 0;
			n1l0l <= 0;
			n1l1i <= 0;
			n1l1l <= 0;
			n1l1O <= 0;
			n1lii <= 0;
			nliliO <= 0;
			nlOOil <= 0;
			nlOOiO <= 0;
			nlOOli <= 0;
			nlOOll <= 0;
			nlOOlO <= 0;
			nlOOOi <= 0;
			nlOOOl <= 0;
			nlOOOO <= 0;
		end
		else if  (wire_nll_dataout == 1'b1) 
		begin
			n100i <= wire_nll01O_o;
			n100l <= wire_nll00O_o;
			n100O <= wire_nll0iO_o;
			n101i <= wire_n001O_dataout;
			n101l <= ni0OlO;
			n101O <= wire_nliO1i_o;
			n10ii <= wire_nll0lO_o;
			n10il <= wire_nll0OO_o;
			n10iO <= (~ ni0OOi);
			n10li <= wire_nlli0i_o;
			n10ll <= (~ ni0OOl);
			n10lO <= wire_nlliil_o;
			n10Oi <= wire_nllili_o;
			n10Ol <= wire_nllilO_o;
			n10OO <= wire_nlliOi_o;
			n110i <= wire_n011i_dataout;
			n110l <= wire_n011l_dataout;
			n110O <= wire_n011O_dataout;
			n111i <= wire_n1OlO_dataout;
			n111l <= wire_n1OOi_dataout;
			n111O <= wire_n1OOl_dataout;
			n11ii <= wire_n010i_dataout;
			n11il <= wire_n01li_dataout;
			n11iO <= wire_n01ll_dataout;
			n11li <= wire_n01lO_dataout;
			n11ll <= wire_n01Oi_dataout;
			n11lO <= wire_n01Ol_dataout;
			n11Oi <= wire_n01OO_dataout;
			n11Ol <= wire_n001i_dataout;
			n11OO <= wire_n001l_dataout;
			n1i0i <= wire_nlll0O_o;
			n1i0l <= wire_nliO1O_o;
			n1i0O <= wire_nliO0l_o;
			n1i1i <= wire_nlliOO_o;
			n1i1l <= wire_nlll1l_o;
			n1i1O <= wire_nlll0i_o;
			n1iii <= wire_nliOii_o;
			n1iil <= wire_nliOli_o;
			n1iiO <= wire_nliOll_dataout;
			n1ili <= wire_nliOlO_o;
			n1ill <= wire_nliOOi_o;
			n1ilO <= wire_nliOOl_o;
			n1iOi <= wire_nll11i_dataout;
			n1iOl <= wire_nll11l_o;
			n1iOO <= wire_nll10i_o;
			n1l0i <= wire_nll1Oi_dataout;
			n1l0l <= wire_nll1Ol_o;
			n1l1i <= wire_nll10O_o;
			n1l1l <= wire_nll1il_o;
			n1l1O <= wire_nll1ll_o;
			n1lii <= wire_nll01i_o;
			nliliO <= wire_n1lli_dataout;
			nlOOil <= wire_n1lll_dataout;
			nlOOiO <= wire_n1llO_dataout;
			nlOOli <= wire_n1lOl_dataout;
			nlOOll <= wire_n1lOO_dataout;
			nlOOlO <= wire_n1O1i_dataout;
			nlOOOi <= wire_n1O1l_dataout;
			nlOOOl <= wire_n1O1O_dataout;
			nlOOOO <= wire_n1O0i_dataout;
		end
	end
	initial
	begin
		n1liO = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n1liO <= 1;
		end
		else if  (wire_nll_dataout == 1'b1) 
		begin
			n1liO <= niilOl;
		end
	end
	initial
	begin
		nl00il = 0;
		nl00iO = 0;
		nl00li = 0;
		nl00ll = 0;
		nl00lO = 0;
		nl00Oi = 0;
		nl00Ol = 0;
		nl00OO = 0;
		nl0i0i = 0;
		nl0i0l = 0;
		nl0i0O = 0;
		nl0i1i = 0;
		nl0i1l = 0;
		nl0i1O = 0;
		nl0iii = 0;
		nl0iil = 0;
		nl0iiO = 0;
		nl0ili = 0;
		nl0ill = 0;
		nl0ilO = 0;
		nl0iOi = 0;
		nl0iOl = 0;
		nl0iOO = 0;
		nl0l0i = 0;
		nl0l0l = 0;
		nl0l0O = 0;
		nl0l1i = 0;
		nl0l1l = 0;
		nl0l1O = 0;
		nl0lii = 0;
		nl0lil = 0;
		nl0liO = 0;
		nl0lli = 0;
		nl0lll = 0;
		nl0llO = 0;
		nl0lOi = 0;
		nl0lOl = 0;
		nl0lOO = 0;
		nl0O0i = 0;
		nl0O0l = 0;
		nl0O0O = 0;
		nl0O1i = 0;
		nl0O1l = 0;
		nl0O1O = 0;
		nl0Oii = 0;
		nl0Oil = 0;
		nl0OiO = 0;
		nl0Oli = 0;
		nl0Oll = 0;
		nl0OlO = 0;
		nl0OOi = 0;
		nl0OOl = 0;
		nli11i = 0;
	end
	always @ (tx_clk or wire_nl0OOO_PRN or soft_reset)
	begin
		if (wire_nl0OOO_PRN == 1'b0) 
		begin
			nl00il <= 1;
			nl00iO <= 1;
			nl00li <= 1;
			nl00ll <= 1;
			nl00lO <= 1;
			nl00Oi <= 1;
			nl00Ol <= 1;
			nl00OO <= 1;
			nl0i0i <= 1;
			nl0i0l <= 1;
			nl0i0O <= 1;
			nl0i1i <= 1;
			nl0i1l <= 1;
			nl0i1O <= 1;
			nl0iii <= 1;
			nl0iil <= 1;
			nl0iiO <= 1;
			nl0ili <= 1;
			nl0ill <= 1;
			nl0ilO <= 1;
			nl0iOi <= 1;
			nl0iOl <= 1;
			nl0iOO <= 1;
			nl0l0i <= 1;
			nl0l0l <= 1;
			nl0l0O <= 1;
			nl0l1i <= 1;
			nl0l1l <= 1;
			nl0l1O <= 1;
			nl0lii <= 1;
			nl0lil <= 1;
			nl0liO <= 1;
			nl0lli <= 1;
			nl0lll <= 1;
			nl0llO <= 1;
			nl0lOi <= 1;
			nl0lOl <= 1;
			nl0lOO <= 1;
			nl0O0i <= 1;
			nl0O0l <= 1;
			nl0O0O <= 1;
			nl0O1i <= 1;
			nl0O1l <= 1;
			nl0O1O <= 1;
			nl0Oii <= 1;
			nl0Oil <= 1;
			nl0OiO <= 1;
			nl0Oli <= 1;
			nl0Oll <= 1;
			nl0OlO <= 1;
			nl0OOi <= 1;
			nl0OOl <= 1;
			nli11i <= 1;
		end
		else if  (soft_reset == 1'b1) 
		begin
			nl00il <= 0;
			nl00iO <= 0;
			nl00li <= 0;
			nl00ll <= 0;
			nl00lO <= 0;
			nl00Oi <= 0;
			nl00Ol <= 0;
			nl00OO <= 0;
			nl0i0i <= 0;
			nl0i0l <= 0;
			nl0i0O <= 0;
			nl0i1i <= 0;
			nl0i1l <= 0;
			nl0i1O <= 0;
			nl0iii <= 0;
			nl0iil <= 0;
			nl0iiO <= 0;
			nl0ili <= 0;
			nl0ill <= 0;
			nl0ilO <= 0;
			nl0iOi <= 0;
			nl0iOl <= 0;
			nl0iOO <= 0;
			nl0l0i <= 0;
			nl0l0l <= 0;
			nl0l0O <= 0;
			nl0l1i <= 0;
			nl0l1l <= 0;
			nl0l1O <= 0;
			nl0lii <= 0;
			nl0lil <= 0;
			nl0liO <= 0;
			nl0lli <= 0;
			nl0lll <= 0;
			nl0llO <= 0;
			nl0lOi <= 0;
			nl0lOl <= 0;
			nl0lOO <= 0;
			nl0O0i <= 0;
			nl0O0l <= 0;
			nl0O0O <= 0;
			nl0O1i <= 0;
			nl0O1l <= 0;
			nl0O1O <= 0;
			nl0Oii <= 0;
			nl0Oil <= 0;
			nl0OiO <= 0;
			nl0Oli <= 0;
			nl0Oll <= 0;
			nl0OlO <= 0;
			nl0OOi <= 0;
			nl0OOl <= 0;
			nli11i <= 0;
		end
		else 
		if (tx_clk != nl0OOO_clk_prev && tx_clk == 1'b1) 
		begin
			nl00il <= wire_nli10i_dataout;
			nl00iO <= wire_nli10l_dataout;
			nl00li <= wire_nli10O_dataout;
			nl00ll <= wire_nli1ii_dataout;
			nl00lO <= wire_nli1il_dataout;
			nl00Oi <= wire_nli1iO_dataout;
			nl00Ol <= wire_nli1li_dataout;
			nl00OO <= wire_nli1ll_dataout;
			nl0i0i <= wire_nli1OO_dataout;
			nl0i0l <= wire_nli01i_dataout;
			nl0i0O <= wire_nli01l_dataout;
			nl0i1i <= wire_nli1lO_dataout;
			nl0i1l <= wire_nli1Oi_dataout;
			nl0i1O <= wire_nli1Ol_dataout;
			nl0iii <= wire_nli01O_dataout;
			nl0iil <= wire_nli00i_dataout;
			nl0iiO <= wire_nli00l_dataout;
			nl0ili <= wire_nli00O_dataout;
			nl0ill <= wire_nli0ii_dataout;
			nl0ilO <= wire_nli0il_dataout;
			nl0iOi <= wire_nli0iO_dataout;
			nl0iOl <= wire_nli0li_dataout;
			nl0iOO <= (~ (nli11O | nl0OOi));
			nl0l0i <= wire_nil01O_o;
			nl0l0l <= wire_nil00l_o;
			nl0l0O <= wire_nil0il_o;
			nl0l1i <= wire_nil1li_o;
			nl0l1l <= wire_nil1lO_o;
			nl0l1O <= wire_nil1OO_o;
			nl0lii <= wire_nil0li_o;
			nl0lil <= wire_nil0Oi_o;
			nl0liO <= wire_nili1i_o;
			nl0lli <= wire_nili0i_o;
			nl0lll <= wire_nili0O_o;
			nl0llO <= wire_niliil_o;
			nl0lOi <= wire_nilili_o;
			nl0lOl <= wire_nililO_o;
			nl0lOO <= wire_niliOl_o;
			nl0O0i <= wire_nillil_o;
			nl0O0l <= wire_nillli_o;
			nl0O0O <= wire_nilllO_o;
			nl0O1i <= wire_nill1i_o;
			nl0O1l <= wire_nill1O_o;
			nl0O1O <= wire_nill0O_o;
			nl0Oii <= wire_nillOl_o;
			nl0Oil <= wire_nilO1i_o;
			nl0OiO <= wire_nilO1O_o;
			nl0Oli <= wire_nilO0l_o;
			nl0Oll <= wire_nilOii_o;
			nl0OlO <= wire_nilOiO_o;
			nl0OOi <= wire_nilOli_o;
			nl0OOl <= wire_nilOlO_o;
			nli11i <= wire_nilOOl_o;
		end
		nl0OOO_clk_prev <= tx_clk;
	end
	assign
		wire_nl0OOO_PRN = (ni001l46 ^ ni001l45);
	initial
	begin
		nli11O = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nli11O <= 1;
		end
		else 
		begin
			nli11O <= wire_niO11i_o;
		end
	end
	initial
	begin
		n0lOi = 0;
		niO0l = 0;
		niO0O = 0;
		niOii = 0;
		niOil = 0;
		niOiO = 0;
		niOli = 0;
		niOll = 0;
		niOlO = 0;
		niOOi = 0;
		niOOl = 0;
		niOOO = 0;
		nl00i = 0;
		nl00l = 0;
		nl00O = 0;
		nl01i = 0;
		nl01l = 0;
		nl01O = 0;
		nl0ii = 0;
		nl0il = 0;
		nl0iO = 0;
		nl0li = 0;
		nl0ll = 0;
		nl0lO = 0;
		nl0Oi = 0;
		nl0Ol = 0;
		nl0OO = 0;
		nl10i = 0;
		nl10l = 0;
		nl10O = 0;
		nl11i = 0;
		nl11l = 0;
		nl11O = 0;
		nl1ii = 0;
		nl1il = 0;
		nl1iO = 0;
		nl1li = 0;
		nl1ll = 0;
		nl1lO = 0;
		nl1Oi = 0;
		nl1Ol = 0;
		nl1OO = 0;
		nli0i = 0;
		nli0l = 0;
		nli0O = 0;
		nli1i = 0;
		nli1l = 0;
		nli1O = 0;
		nliil = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			n0lOi <= 0;
			niO0l <= 0;
			niO0O <= 0;
			niOii <= 0;
			niOil <= 0;
			niOiO <= 0;
			niOli <= 0;
			niOll <= 0;
			niOlO <= 0;
			niOOi <= 0;
			niOOl <= 0;
			niOOO <= 0;
			nl00i <= 0;
			nl00l <= 0;
			nl00O <= 0;
			nl01i <= 0;
			nl01l <= 0;
			nl01O <= 0;
			nl0ii <= 0;
			nl0il <= 0;
			nl0iO <= 0;
			nl0li <= 0;
			nl0ll <= 0;
			nl0lO <= 0;
			nl0Oi <= 0;
			nl0Ol <= 0;
			nl0OO <= 0;
			nl10i <= 0;
			nl10l <= 0;
			nl10O <= 0;
			nl11i <= 0;
			nl11l <= 0;
			nl11O <= 0;
			nl1ii <= 0;
			nl1il <= 0;
			nl1iO <= 0;
			nl1li <= 0;
			nl1ll <= 0;
			nl1lO <= 0;
			nl1Oi <= 0;
			nl1Ol <= 0;
			nl1OO <= 0;
			nli0i <= 0;
			nli0l <= 0;
			nli0O <= 0;
			nli1i <= 0;
			nli1l <= 0;
			nli1O <= 0;
			nliil <= 0;
		end
		else if  (wire_nli_dataout == 1'b1) 
		begin
			n0lOi <= wire_nlill_dataout;
			niO0l <= wire_nlilO_dataout;
			niO0O <= wire_nliOi_dataout;
			niOii <= wire_nliOO_dataout;
			niOil <= wire_nll1i_dataout;
			niOiO <= wire_nll1l_dataout;
			niOli <= wire_nll1O_dataout;
			niOll <= wire_nll0i_dataout;
			niOlO <= niil1l;
			niOOi <= wire_n0ilO_o;
			niOOl <= (~ niil1O);
			niOOO <= niil0i;
			nl00i <= wire_n0lii_o;
			nl00l <= wire_n0lil_o;
			nl00O <= wire_n0liO_o;
			nl01i <= wire_n0l1i_o;
			nl01l <= wire_n0l1O_o;
			nl01O <= wire_n0l0O_dataout;
			nl0ii <= wire_n0lli_o;
			nl0il <= wire_n0llO_dataout;
			nl0iO <= wire_n0lOl_o;
			nl0li <= wire_n0O1i_dataout;
			nl0ll <= wire_n0O1l_o;
			nl0lO <= wire_n0O0i_dataout;
			nl0Oi <= wire_n0O0l_o;
			nl0Ol <= wire_n0Oii_dataout;
			nl0OO <= wire_n0Oil_o;
			nl10i <= (~ niilil);
			nl10l <= (~ niiliO);
			nl10O <= niilli;
			nl11i <= (~ niil0l);
			nl11l <= (~ niil0O);
			nl11O <= (~ niilii);
			nl1ii <= wire_ni1Ol_o;
			nl1il <= wire_ni01i_o;
			nl1iO <= wire_ni01O_o;
			nl1li <= wire_ni00l_o;
			nl1ll <= wire_ni0ii_o;
			nl1lO <= wire_ni0iO_o;
			nl1Oi <= wire_ni0ll_o;
			nl1Ol <= wire_ni0Oi_o;
			nl1OO <= wire_n0iOl_o;
			nli0i <= wire_n0OOl_o;
			nli0l <= wire_ni11i_dataout;
			nli0O <= wire_ni11l_o;
			nli1i <= wire_n0Oli_dataout;
			nli1l <= wire_n0Oll_o;
			nli1O <= wire_n0OOi_dataout;
			nliil <= wire_ni10i_o;
		end
	end
	initial
	begin
		nlili = 0;
	end
	always @ (tx_clk or wire_nliiO_PRN or wire_nliiO_CLRN)
	begin
		if (wire_nliiO_PRN == 1'b0) 
		begin
			nlili <= 1;
		end
		else if  (wire_nliiO_CLRN == 1'b0) 
		begin
			nlili <= 0;
		end
		else if  (wire_nli_dataout == 1'b1) 
		if (tx_clk != nliiO_clk_prev && tx_clk == 1'b1) 
		begin
			nlili <= niilOl;
		end
		nliiO_clk_prev <= tx_clk;
	end
	assign
		wire_nliiO_CLRN = (niilOi18 ^ niilOi17),
		wire_nliiO_PRN = ((niillO20 ^ niillO19) & (~ soft_reset));
	assign		wire_n000i_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[0] : n11il;
	assign		wire_n000l_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[1] : n11iO;
	assign		wire_n000O_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[2] : n11li;
	and(wire_n001i_dataout, wire_n00li_dataout, ~(wire_nlillO_dataout));
	and(wire_n001l_dataout, wire_n00ll_dataout, ~(wire_nlillO_dataout));
	and(wire_n001O_dataout, wire_n00lO_dataout, ~(wire_nlillO_dataout));
	assign		wire_n00i_dataout = (niiOil === 1'b1) ? nl0l0l : wire_niii_dataout;
	assign		wire_n00ii_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[3] : n11ll;
	assign		wire_n00il_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[4] : n11lO;
	assign		wire_n00iO_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[5] : n11Oi;
	assign		wire_n00l_dataout = (niiOil === 1'b1) ? nl0l0O : wire_niil_dataout;
	assign		wire_n00li_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[6] : n11Ol;
	assign		wire_n00ll_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[7] : n11OO;
	assign		wire_n00lO_dataout = (n1l1l === 1'b1) ? wire_n00Oi_o[8] : n101i;
	assign		wire_n00O_dataout = (niiOil === 1'b1) ? nl0lii : wire_niiO_dataout;
	and(wire_n010i_dataout, wire_n01il_dataout, ~(wire_nlilll_dataout));
	assign		wire_n010l_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[0] : n110i;
	assign		wire_n010O_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[1] : n110l;
	and(wire_n011i_dataout, wire_n010l_dataout, ~(wire_nlilll_dataout));
	and(wire_n011l_dataout, wire_n010O_dataout, ~(wire_nlilll_dataout));
	and(wire_n011O_dataout, wire_n01ii_dataout, ~(wire_nlilll_dataout));
	assign		wire_n01i_dataout = (niiOil === 1'b1) ? nl0l1l : wire_ni0i_dataout;
	assign		wire_n01ii_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[2] : n110O;
	assign		wire_n01il_dataout = (wire_nlilli_dataout === 1'b1) ? wire_n01iO_o[3] : n11ii;
	assign		wire_n01l_dataout = (niiOil === 1'b1) ? nl0l1O : wire_ni0l_dataout;
	and(wire_n01li_dataout, wire_n000i_dataout, ~(wire_nlillO_dataout));
	and(wire_n01ll_dataout, wire_n000l_dataout, ~(wire_nlillO_dataout));
	and(wire_n01lO_dataout, wire_n000O_dataout, ~(wire_nlillO_dataout));
	assign		wire_n01O_dataout = (niiOil === 1'b1) ? nl0l0i : wire_ni0O_dataout;
	and(wire_n01Oi_dataout, wire_n00ii_dataout, ~(wire_nlillO_dataout));
	and(wire_n01Ol_dataout, wire_n00il_dataout, ~(wire_nlillO_dataout));
	and(wire_n01OO_dataout, wire_n00iO_dataout, ~(wire_nlillO_dataout));
	and(wire_n0i_dataout, nl1ll, niiOli);
	assign		wire_n0ii_dataout = (niiOil === 1'b1) ? nl0lil : wire_nili_dataout;
	assign		wire_n0il_dataout = (niiOil === 1'b1) ? nl0liO : wire_nill_dataout;
	assign		wire_n0iO_dataout = (niiOil === 1'b1) ? nl0lli : wire_nilO_dataout;
	and(wire_n0l_dataout, nl1lO, niiOli);
	and(wire_n0l0O_dataout, (~ niiOOi), nl0ii);
	assign		wire_n0li_dataout = (niiOil === 1'b1) ? nl0lll : wire_niOi_dataout;
	assign		wire_n0ll_dataout = (niiOil === 1'b1) ? nl0llO : wire_niOl_dataout;
	and(wire_n0llO_dataout, (~ niiOOi), nl0iO);
	assign		wire_n0lO_dataout = (niiOil === 1'b1) ? nl0lOi : wire_niOO_dataout;
	and(wire_n0O_dataout, nl1Oi, niiOli);
	and(wire_n0O0i_dataout, (~ niiOOi), nl0Oi);
	and(wire_n0O1i_dataout, (~ niiOOi), nl0ll);
	assign		wire_n0Oi_dataout = (niiOil === 1'b1) ? nl0lOl : wire_nl1i_dataout;
	and(wire_n0Oii_dataout, (~ niiOOi), nl0OO);
	assign		wire_n0Ol_dataout = (niiOil === 1'b1) ? nl0lOO : wire_nl1l_dataout;
	and(wire_n0Oli_dataout, (~ niiOOi), nli1l);
	assign		wire_n0OO_dataout = (niiOil === 1'b1) ? nl0O1i : wire_nl1O_dataout;
	and(wire_n0OOi_dataout, (~ niiOOi), nli0i);
	and(wire_n1i_dataout, nl1il, niiOli);
	and(wire_n1l_dataout, nl1iO, niiOli);
	and(wire_n1lli_dataout, wire_n1lOi_o[0], wire_nlilOi_o);
	and(wire_n1lll_dataout, wire_n1lOi_o[1], wire_nlilOi_o);
	and(wire_n1llO_dataout, wire_n1lOi_o[2], wire_nlilOi_o);
	assign		wire_n1lOl_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[0] : wire_n1O0l_dataout;
	assign		wire_n1lOO_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[1] : wire_n1O0O_dataout;
	and(wire_n1O_dataout, nl1li, niiOli);
	assign		wire_n1O0i_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[5] : wire_n1Oli_dataout;
	and(wire_n1O0l_dataout, nlOOli, ~(wire_nlilii_dataout));
	and(wire_n1O0O_dataout, nlOOll, ~(wire_nlilii_dataout));
	assign		wire_n1O1i_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[2] : wire_n1Oii_dataout;
	assign		wire_n1O1l_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[3] : wire_n1Oil_dataout;
	assign		wire_n1O1O_dataout = (wire_nlil0O_dataout === 1'b1) ? wire_n1Oll_o[4] : wire_n1OiO_dataout;
	and(wire_n1Oii_dataout, nlOOlO, ~(wire_nlilii_dataout));
	and(wire_n1Oil_dataout, nlOOOi, ~(wire_nlilii_dataout));
	and(wire_n1OiO_dataout, nlOOOl, ~(wire_nlilii_dataout));
	and(wire_n1Oli_dataout, nlOOOO, ~(wire_nlilii_dataout));
	assign		wire_n1OlO_dataout = (wire_nlilil_dataout === 1'b1) ? wire_n1OOO_o[0] : n111i;
	assign		wire_n1OOi_dataout = (wire_nlilil_dataout === 1'b1) ? wire_n1OOO_o[1] : n111l;
	assign		wire_n1OOl_dataout = (wire_nlilil_dataout === 1'b1) ? wire_n1OOO_o[2] : n111O;
	assign		wire_ni0i_dataout = (niiOiO === 1'b1) ? n100i : wire_nlii_dataout;
	assign		wire_ni0l_dataout = (niiOiO === 1'b1) ? n100l : wire_nlil_dataout;
	assign		wire_ni0O_dataout = (niiOiO === 1'b1) ? n100O : wire_nliO_dataout;
	and(wire_ni0OO_dataout, niiiil, ~(niiilO));
	and(wire_ni11i_dataout, wire_nillO_dataout, nli0O);
	assign		wire_ni1i_dataout = (niiOil === 1'b1) ? nl0O1l : wire_nl0i_dataout;
	assign		wire_ni1l_dataout = (niiOil === 1'b1) ? nl0iOO : wire_nl0l_dataout;
	assign		wire_ni1O_dataout = (niiOil === 1'b1) ? nl0l1i : wire_nl0O_dataout;
	and(wire_nii_dataout, nl1Ol, niiOli);
	and(wire_nii0i_dataout, wire_niiil_dataout, niiOOi);
	and(wire_nii0l_dataout, wire_niiiO_dataout, niiOOi);
	assign		wire_nii0O_dataout = (niiilO === 1'b1) ? niiiil : niiiiO;
	and(wire_nii1i_dataout, niiiil, niiilO);
	and(wire_nii1l_dataout, wire_nii0O_dataout, ~(niiOOi));
	assign		wire_nii1O_dataout = (niiOOi === 1'b1) ? (~ niiili) : wire_niiii_dataout;
	assign		wire_niii_dataout = (niiOiO === 1'b1) ? n10ii : wire_nlli_dataout;
	assign		wire_niiii_dataout = (niiilO === 1'b1) ? (~ niiiil) : (~ niiiiO);
	and(wire_niiil_dataout, niiili, ~(niiilO));
	and(wire_niiiO_dataout, niiili, niiilO);
	assign		wire_niil_dataout = (niiOiO === 1'b1) ? n10il : wire_nlll_dataout;
	and(wire_niili_dataout, wire_nil1i_dataout, niiOOi);
	and(wire_niill_dataout, wire_nil1l_dataout, niiOOi);
	and(wire_niilO_dataout, wire_nil1O_dataout, niiOOi);
	assign		wire_niiO_dataout = (niiOiO === 1'b1) ? n10iO : wire_nllO_dataout;
	and(wire_niiOi_dataout, wire_nil0i_dataout, niiOOi);
	and(wire_niiOl_dataout, (~ niiill), niiOOi);
	and(wire_niiOO_dataout, niiill, niiOOi);
	and(wire_nil_dataout, niOlO, niiOli);
	and(wire_nil0i_dataout, niiilO, niiill);
	and(wire_nil0l_dataout, wire_nilil_dataout, ~(niiilO));
	and(wire_nil0O_dataout, wire_niliO_dataout, ~(niiilO));
	and(wire_nil1i_dataout, wire_nil0l_dataout, niiill);
	and(wire_nil1l_dataout, wire_nil0O_dataout, niiill);
	and(wire_nil1O_dataout, wire_nilii_dataout, niiill);
	assign		wire_nili_dataout = (niiOiO === 1'b1) ? n10li : wire_nlOi_dataout;
	and(wire_nilii_dataout, niil1i, ~(niiilO));
	and(wire_nilil_dataout, (~ niiiOO), ~(niil1i));
	and(wire_niliO_dataout, niiiOO, ~(niil1i));
	assign		wire_nill_dataout = (niiOiO === 1'b1) ? n10ll : wire_nlOl_dataout;
	and(wire_nilli_dataout, (~ niiiOl), niiOOi);
	or(wire_nilll_dataout, wire_nilOl_dataout, niiOOi);
	and(wire_nillO_dataout, wire_nilOO_dataout, ~(niiOOi));
	assign		wire_nilO_dataout = (niiOiO === 1'b1) ? n10lO : wire_nlOO_dataout;
	and(wire_nilOi_dataout, wire_niO1i_dataout, ~(niiOOi));
	or(wire_nilOl_dataout, wire_niO1l_dataout, niiilO);
	and(wire_nilOO_dataout, (~ niiiOl), ~(niiilO));
	and(wire_niO_dataout, niOOi, niiOli);
	assign		wire_niO00i_dataout = (niiOOi === 1'b1) ? nl00OO : nl0iil;
	assign		wire_niO00l_dataout = (niiOOi === 1'b1) ? nl0i1i : nl0iiO;
	assign		wire_niO00O_dataout = (niiOOi === 1'b1) ? nl0i1l : nl0ili;
	assign		wire_niO01i_dataout = (niiOOi === 1'b1) ? wire_niOOOi_dataout : wire_niOiOO_dataout;
	assign		wire_niO01l_dataout = (niiOOi === 1'b1) ? wire_niOOOl_dataout : wire_niOl1i_dataout;
	and(wire_niO01O_dataout, nl0iii, ~(niiOOi));
	assign		wire_niO0ii_dataout = (niiOOi === 1'b1) ? nl0i1O : nl0ill;
	assign		wire_niO0il_dataout = (niiOOi === 1'b1) ? nl0i0i : nl0ilO;
	assign		wire_niO0iO_dataout = (niiOOi === 1'b1) ? nl0i0l : nl0iOi;
	assign		wire_niO0li_dataout = (niiOOi === 1'b1) ? nl0i0O : nl0iOl;
	and(wire_niO0ll_dataout, nl00il, niiOOi);
	and(wire_niO0lO_dataout, nl00iO, niiOOi);
	and(wire_niO0Oi_dataout, nl00li, niiOOi);
	and(wire_niO0Ol_dataout, nl00ll, niiOOi);
	and(wire_niO0OO_dataout, nl00lO, niiOOi);
	assign		wire_niO10i_dataout = (niiOOi === 1'b1) ? wire_niOO1i_dataout : wire_niOi1O_dataout;
	assign		wire_niO10l_dataout = (niiOOi === 1'b1) ? wire_niOO1l_dataout : wire_niOi0i_dataout;
	assign		wire_niO10O_dataout = (niiOOi === 1'b1) ? wire_niOO1O_dataout : wire_niOi0l_dataout;
	and(wire_niO11l_dataout, wire_nlO_dataout, niiOOi);
	and(wire_niO11O_dataout, wire_nlO_dataout, ~(niiOOi));
	and(wire_niO1i_dataout, wire_niO1O_dataout, ~(niiilO));
	assign		wire_niO1ii_dataout = (niiOOi === 1'b1) ? wire_niOO0i_dataout : wire_niOi0O_dataout;
	assign		wire_niO1il_dataout = (niiOOi === 1'b1) ? wire_niOO0l_dataout : wire_niOiii_dataout;
	assign		wire_niO1iO_dataout = (niiOOi === 1'b1) ? wire_niOO0O_dataout : wire_niOiil_dataout;
	and(wire_niO1l_dataout, niiiOi, niiiOl);
	assign		wire_niO1li_dataout = (niiOOi === 1'b1) ? wire_niOOii_dataout : wire_niOiiO_dataout;
	assign		wire_niO1ll_dataout = (niiOOi === 1'b1) ? wire_niOOil_dataout : wire_niOili_dataout;
	assign		wire_niO1lO_dataout = (niiOOi === 1'b1) ? wire_niOOiO_dataout : wire_niOill_dataout;
	and(wire_niO1O_dataout, (~ niiiOi), niiiOl);
	assign		wire_niO1Oi_dataout = (niiOOi === 1'b1) ? wire_niOOli_dataout : wire_niOilO_dataout;
	assign		wire_niO1Ol_dataout = (niiOOi === 1'b1) ? wire_niOOll_dataout : wire_niOiOi_dataout;
	assign		wire_niO1OO_dataout = (niiOOi === 1'b1) ? wire_niOOlO_dataout : wire_niOiOl_dataout;
	assign		wire_niOi_dataout = (niiOiO === 1'b1) ? n10Oi : wire_n1i_dataout;
	and(wire_niOi0i_dataout, wire_niOl1O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOi0l_dataout, wire_niOl0i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOi0O_dataout, wire_niOl0l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOi1i_dataout, nl00Oi, niiOOi);
	and(wire_niOi1l_dataout, nl00Ol, niiOOi);
	and(wire_niOi1O_dataout, wire_niOl1l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiii_dataout, wire_niOl0O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiil_dataout, wire_niOlii_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiiO_dataout, wire_niOlil_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOili_dataout, wire_niOliO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOill_dataout, wire_niOlli_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOilO_dataout, wire_niOlll_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiOi_dataout, wire_niOllO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiOl_dataout, wire_niOlOi_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOiOO_dataout, wire_niOlOl_dataout, ~((~ wire_nlO_dataout)));
	assign		wire_niOl_dataout = (niiOiO === 1'b1) ? n10Ol : wire_n1l_dataout;
	and(wire_niOl0i_dataout, nl0O0l, ~(ni01Oi));
	and(wire_niOl0l_dataout, nl0O0O, ~(ni01Oi));
	and(wire_niOl0O_dataout, nl0Oii, ~(ni01Oi));
	or(wire_niOl1i_dataout, wire_niOlOO_dataout, (~ wire_nlO_dataout));
	and(wire_niOl1l_dataout, nl0O1O, ~(ni01Oi));
	and(wire_niOl1O_dataout, nl0O0i, ~(ni01Oi));
	and(wire_niOlii_dataout, nl0Oil, ~(ni01Oi));
	and(wire_niOlil_dataout, nl0OiO, ~(ni01Oi));
	and(wire_niOliO_dataout, nl0Oli, ~(ni01Oi));
	and(wire_niOlli_dataout, nl0Oll, ~(ni01Oi));
	or(wire_niOlll_dataout, nl0OlO, ni01Oi);
	and(wire_niOllO_dataout, nl0OOi, ~(ni01Oi));
	and(wire_niOlOi_dataout, nl0OOl, ~(ni01Oi));
	and(wire_niOlOl_dataout, nli11i, ~(ni01Oi));
	and(wire_niOlOO_dataout, nli11O, ~(ni01Oi));
	assign		wire_niOO_dataout = (niiOiO === 1'b1) ? n10OO : wire_n1O_dataout;
	and(wire_niOO0i_dataout, wire_nl111O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO0l_dataout, wire_nl110i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO0O_dataout, wire_nl110l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO1i_dataout, wire_niOOOO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO1l_dataout, wire_nl111i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOO1O_dataout, wire_nl111l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOii_dataout, wire_nl110O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOil_dataout, wire_nl11ii_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOiO_dataout, wire_nl11il_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOli_dataout, wire_nl11iO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOll_dataout, wire_nl11li_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOlO_dataout, wire_nl11ll_dataout, ~((~ wire_nlO_dataout)));
	and(wire_niOOOi_dataout, wire_nl11lO_dataout, ~((~ wire_nlO_dataout)));
	or(wire_niOOOl_dataout, wire_nl11Oi_dataout, (~ wire_nlO_dataout));
	and(wire_niOOOO_dataout, nl0O1O, ~(ni01Ol));
	and(wire_nl000i_dataout, nl0OOi, ~(wire_nlO_dataout));
	and(wire_nl000l_dataout, nl0OOl, ~(wire_nlO_dataout));
	or(wire_nl000O_dataout, nli11i, wire_nlO_dataout);
	and(wire_nl001i_dataout, nl0Oli, ~(wire_nlO_dataout));
	and(wire_nl001l_dataout, nl0Oll, ~(wire_nlO_dataout));
	and(wire_nl001O_dataout, nl0OlO, ~(wire_nlO_dataout));
	and(wire_nl00ii_dataout, nli11O, ~(wire_nlO_dataout));
	and(wire_nl010i_dataout, nl0OlO, ~(ni001i));
	and(wire_nl010l_dataout, nl0OOi, ~(ni001i));
	or(wire_nl010O_dataout, nl0OOl, ni001i);
	and(wire_nl011i_dataout, nl0OiO, ~(ni001i));
	and(wire_nl011l_dataout, nl0Oli, ~(ni001i));
	and(wire_nl011O_dataout, nl0Oll, ~(ni001i));
	and(wire_nl01ii_dataout, nli11i, ~(ni001i));
	and(wire_nl01il_dataout, nli11O, ~(ni001i));
	and(wire_nl01iO_dataout, nl0O1O, ~(wire_nlO_dataout));
	and(wire_nl01li_dataout, nl0O0i, ~(wire_nlO_dataout));
	and(wire_nl01ll_dataout, nl0O0l, ~(wire_nlO_dataout));
	and(wire_nl01lO_dataout, nl0O0O, ~(wire_nlO_dataout));
	and(wire_nl01Oi_dataout, nl0Oii, ~(wire_nlO_dataout));
	and(wire_nl01Ol_dataout, nl0Oil, ~(wire_nlO_dataout));
	and(wire_nl01OO_dataout, nl0OiO, ~(wire_nlO_dataout));
	assign		wire_nl0i_dataout = (niiOiO === 1'b1) ? n1i0i : wire_nii_dataout;
	assign		wire_nl0l_dataout = (niiOiO === 1'b1) ? n101l : wire_nil_dataout;
	assign		wire_nl0O_dataout = (niiOiO === 1'b1) ? n101O : wire_niO_dataout;
	assign		wire_nl100i_dataout = (niiOOi === 1'b1) ? wire_nl1O1i_dataout : wire_nl1i1O_dataout;
	assign		wire_nl100l_dataout = (niiOOi === 1'b1) ? wire_nl1O1l_dataout : wire_nl1i0i_dataout;
	assign		wire_nl100O_dataout = (niiOOi === 1'b1) ? wire_nl1O1O_dataout : wire_nl1i0l_dataout;
	assign		wire_nl101i_dataout = (niiOOi === 1'b1) ? wire_nl1lOi_dataout : wire_nl10OO_dataout;
	assign		wire_nl101l_dataout = (niiOOi === 1'b1) ? wire_nl1lOl_dataout : wire_nl1i1i_dataout;
	assign		wire_nl101O_dataout = (niiOOi === 1'b1) ? wire_nl1lOO_dataout : wire_nl1i1l_dataout;
	assign		wire_nl10ii_dataout = (niiOOi === 1'b1) ? wire_nl1O0i_dataout : wire_nl1i0O_dataout;
	assign		wire_nl10il_dataout = (niiOOi === 1'b1) ? wire_nl1O0l_dataout : wire_nl1iii_dataout;
	assign		wire_nl10iO_dataout = (niiOOi === 1'b1) ? wire_nl1O0O_dataout : wire_nl1iil_dataout;
	assign		wire_nl10li_dataout = (niiOOi === 1'b1) ? wire_nl1Oii_dataout : wire_nl1iiO_dataout;
	assign		wire_nl10ll_dataout = (niiOOi === 1'b1) ? wire_nl1Oil_dataout : wire_nl1ili_dataout;
	assign		wire_nl10lO_dataout = (niiOOi === 1'b1) ? wire_nl1OiO_dataout : wire_nl1ill_dataout;
	and(wire_nl10Oi_dataout, wire_nl1ilO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl10Ol_dataout, wire_nl1iOi_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl10OO_dataout, wire_nl1iOl_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl110i_dataout, nl0Oii, ~(ni01Ol));
	and(wire_nl110l_dataout, nl0Oil, ~(ni01Ol));
	and(wire_nl110O_dataout, nl0OiO, ~(ni01Ol));
	and(wire_nl111i_dataout, nl0O0i, ~(ni01Ol));
	and(wire_nl111l_dataout, nl0O0l, ~(ni01Ol));
	and(wire_nl111O_dataout, nl0O0O, ~(ni01Ol));
	and(wire_nl11ii_dataout, nl0Oli, ~(ni01Ol));
	and(wire_nl11il_dataout, nl0Oll, ~(ni01Ol));
	or(wire_nl11iO_dataout, nl0OlO, ni01Ol);
	and(wire_nl11li_dataout, nl0OOi, ~(ni01Ol));
	and(wire_nl11ll_dataout, nl0OOl, ~(ni01Ol));
	and(wire_nl11lO_dataout, nli11i, ~(ni01Ol));
	and(wire_nl11Oi_dataout, nli11O, ~(ni01Ol));
	assign		wire_nl11Ol_dataout = (niiOOi === 1'b1) ? wire_nl1lll_dataout : wire_nl10Oi_dataout;
	assign		wire_nl11OO_dataout = (niiOOi === 1'b1) ? wire_nl1llO_dataout : wire_nl10Ol_dataout;
	assign		wire_nl1i_dataout = (niiOiO === 1'b1) ? n1i1i : wire_n0i_dataout;
	and(wire_nl1i0i_dataout, wire_nl1l1O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i0l_dataout, wire_nl1l0i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i0O_dataout, wire_nl1l0l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i1i_dataout, wire_nl1iOO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i1l_dataout, wire_nl1l1i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1i1O_dataout, wire_nl1l1l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1iii_dataout, wire_nl1l0O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1iil_dataout, wire_nl1lii_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1iiO_dataout, wire_nl1lil_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1ili_dataout, wire_nl1liO_dataout, ~((~ wire_nlO_dataout)));
	or(wire_nl1ill_dataout, wire_nl1lli_dataout, (~ wire_nlO_dataout));
	and(wire_nl1ilO_dataout, nl0O1O, ~(ni01OO));
	and(wire_nl1iOi_dataout, nl0O0i, ~(ni01OO));
	and(wire_nl1iOl_dataout, nl0O0l, ~(ni01OO));
	and(wire_nl1iOO_dataout, nl0O0O, ~(ni01OO));
	assign		wire_nl1l_dataout = (niiOiO === 1'b1) ? n1i1l : wire_n0l_dataout;
	and(wire_nl1l0i_dataout, nl0Oli, ~(ni01OO));
	and(wire_nl1l0l_dataout, nl0Oll, ~(ni01OO));
	and(wire_nl1l0O_dataout, nl0OlO, ~(ni01OO));
	and(wire_nl1l1i_dataout, nl0Oii, ~(ni01OO));
	and(wire_nl1l1l_dataout, nl0Oil, ~(ni01OO));
	and(wire_nl1l1O_dataout, nl0OiO, ~(ni01OO));
	and(wire_nl1lii_dataout, nl0OOi, ~(ni01OO));
	or(wire_nl1lil_dataout, nl0OOl, ni01OO);
	and(wire_nl1liO_dataout, nli11i, ~(ni01OO));
	and(wire_nl1lli_dataout, nli11O, ~(ni01OO));
	and(wire_nl1lll_dataout, wire_nl1Oli_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1llO_dataout, wire_nl1Oll_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1lOi_dataout, wire_nl1OlO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1lOl_dataout, wire_nl1OOi_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1lOO_dataout, wire_nl1OOl_dataout, ~((~ wire_nlO_dataout)));
	assign		wire_nl1O_dataout = (niiOiO === 1'b1) ? n1i1O : wire_n0O_dataout;
	and(wire_nl1O0i_dataout, wire_nl011O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O0l_dataout, wire_nl010i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O0O_dataout, wire_nl010l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O1i_dataout, wire_nl1OOO_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O1l_dataout, wire_nl011i_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1O1O_dataout, wire_nl011l_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1Oii_dataout, wire_nl010O_dataout, ~((~ wire_nlO_dataout)));
	and(wire_nl1Oil_dataout, wire_nl01ii_dataout, ~((~ wire_nlO_dataout)));
	or(wire_nl1OiO_dataout, wire_nl01il_dataout, (~ wire_nlO_dataout));
	and(wire_nl1Oli_dataout, nl0O1O, ~(ni001i));
	and(wire_nl1Oll_dataout, nl0O0i, ~(ni001i));
	and(wire_nl1OlO_dataout, nl0O0l, ~(ni001i));
	and(wire_nl1OOi_dataout, nl0O0O, ~(ni001i));
	and(wire_nl1OOl_dataout, nl0Oii, ~(ni001i));
	and(wire_nl1OOO_dataout, nl0Oil, ~(ni001i));
	and(wire_nli_dataout, rbisten_tx, ((~ rbist_sel[0]) & rbist_sel[1]));
	and(wire_nli00i_dataout, wire_nli0Oi_o[1], ni001O);
	and(wire_nli00l_dataout, wire_nli0Oi_o[2], ni001O);
	and(wire_nli00O_dataout, wire_nli0Oi_o[3], ni001O);
	and(wire_nli01i_dataout, wire_nli0lO_o[5], ni001O);
	and(wire_nli01l_dataout, wire_nli0lO_o[6], ni001O);
	and(wire_nli01O_dataout, wire_nli0Oi_o[0], ni001O);
	and(wire_nli0ii_dataout, wire_nli0Oi_o[4], ni001O);
	and(wire_nli0il_dataout, wire_nli0Oi_o[5], ni001O);
	and(wire_nli0iO_dataout, wire_nli0Oi_o[6], ni001O);
	and(wire_nli0li_dataout, wire_nli0Oi_o[7], ni001O);
	and(wire_nli10i_dataout, wire_nli0ll_o[0], ni001O);
	and(wire_nli10l_dataout, wire_nli0ll_o[1], ni001O);
	and(wire_nli10O_dataout, wire_nli0ll_o[2], ni001O);
	and(wire_nli1ii_dataout, wire_nli0ll_o[3], ni001O);
	and(wire_nli1il_dataout, wire_nli0ll_o[4], ni001O);
	and(wire_nli1iO_dataout, wire_nli0ll_o[5], ni001O);
	and(wire_nli1li_dataout, wire_nli0ll_o[6], ni001O);
	and(wire_nli1ll_dataout, wire_nli0lO_o[0], ni001O);
	and(wire_nli1lO_dataout, wire_nli0lO_o[1], ni001O);
	and(wire_nli1Oi_dataout, wire_nli0lO_o[2], ni001O);
	and(wire_nli1Ol_dataout, wire_nli0lO_o[3], ni001O);
	and(wire_nli1OO_dataout, wire_nli0lO_o[4], ni001O);
	and(wire_nlii_dataout, niOOl, niiOli);
	and(wire_nlil_dataout, niOOO, niiOli);
	and(wire_nlil0O_dataout, wire_nllO1O_dataout, n1iOl);
	and(wire_nlilii_dataout, wire_nllO0i_dataout, n1iOl);
	and(wire_nlilil_dataout, niiOOi, n1iOO);
	and(wire_nlill_dataout, wire_nliOl_o[0], wire_n0iiO_o);
	and(wire_nlilli_dataout, wire_nlO10l_dataout, n1l1i);
	and(wire_nlilll_dataout, wire_nlO10O_dataout, n1l1i);
	and(wire_nlillO_dataout, wire_nlOi0O_dataout, n1l1l);
	and(wire_nlilO_dataout, wire_nliOl_o[1], wire_n0iiO_o);
	and(wire_nliO_dataout, nl11i, niiOli);
	and(wire_nliOi_dataout, wire_nliOl_o[2], wire_n0iiO_o);
	and(wire_nliOll_dataout, (~ niiOOi), n1ilO);
	assign		wire_nliOO_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[0] : wire_nll0l_dataout;
	and(wire_nll_dataout, rbisten_tx, (rbist_sel[0] & (~ rbist_sel[1])));
	assign		wire_nll0i_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[4] : wire_nlliO_dataout;
	and(wire_nll0l_dataout, niOii, ~(wire_n0iil_o));
	and(wire_nll0O_dataout, niOil, ~(wire_n0iil_o));
	and(wire_nll11i_dataout, wire_nlO1ll_dataout, n1l1i);
	assign		wire_nll1i_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[1] : wire_nll0O_dataout;
	assign		wire_nll1l_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[2] : wire_nllii_dataout;
	assign		wire_nll1O_dataout = (wire_n0iii_o === 1'b1) ? wire_nllli_o[3] : wire_nllil_dataout;
	and(wire_nll1Oi_dataout, wire_nlOlOO_dataout, n1l0l);
	and(wire_nlli_dataout, nl11l, niiOli);
	and(wire_nllii_dataout, niOiO, ~(wire_n0iil_o));
	and(wire_nllil_dataout, niOli, ~(wire_n0iil_o));
	and(wire_nlliO_dataout, niOll, ~(wire_n0iil_o));
	and(wire_nlll_dataout, nl11O, niiOli);
	and(wire_nlllil_dataout, ni0l0l, ~(ni0Oii));
	and(wire_nllliO_dataout, ni0l0l, ni0Oii);
	and(wire_nlllli_dataout, wire_nlllOl_dataout, ~(niiOOi));
	assign		wire_nlllll_dataout = (niiOOi === 1'b1) ? (~ ni0lii) : wire_nlllOO_dataout;
	and(wire_nllllO_dataout, wire_nllO1i_dataout, niiOOi);
	and(wire_nlllOi_dataout, wire_nllO1l_dataout, niiOOi);
	assign		wire_nlllOl_dataout = (ni0Oii === 1'b1) ? ni0l0l : ni0l0O;
	assign		wire_nlllOO_dataout = (ni0Oii === 1'b1) ? (~ ni0l0l) : (~ ni0l0O);
	and(wire_nllO_dataout, nl10i, niiOli);
	assign		wire_nllO0i_dataout = (niiOOi === 1'b1) ? ni0lil : ni0liO;
	and(wire_nllO0l_dataout, wire_nllOll_dataout, niiOOi);
	and(wire_nllO0O_dataout, wire_nllOlO_dataout, niiOOi);
	and(wire_nllO1i_dataout, ni0lii, ~(ni0Oii));
	and(wire_nllO1l_dataout, ni0lii, ni0Oii);
	assign		wire_nllO1O_dataout = (niiOOi === 1'b1) ? (~ ni0lil) : (~ ni0liO);
	and(wire_nllOii_dataout, wire_nllOOi_dataout, niiOOi);
	and(wire_nllOil_dataout, wire_nllOOl_dataout, niiOOi);
	and(wire_nllOiO_dataout, wire_nllOOO_dataout, niiOOi);
	and(wire_nllOli_dataout, ni0lli, niiOOi);
	and(wire_nllOll_dataout, wire_nlO11i_dataout, ~(ni0lli));
	and(wire_nllOlO_dataout, wire_nlO11l_dataout, ~(ni0lli));
	and(wire_nllOOi_dataout, wire_nlO11O_dataout, ~(ni0lli));
	and(wire_nllOOl_dataout, wire_nlO10i_dataout, ~(ni0lli));
	and(wire_nllOOO_dataout, (~ ni0lll), ~(ni0lli));
	and(wire_nlO_dataout, rbisten_tx, (((~ rbist_sel[0]) & (~ rbist_sel[1])) & (niiOll6 ^ niiOll5)));
	and(wire_nlO00i_dataout, wire_nlO0li_dataout, ~(ni0lOO));
	and(wire_nlO00l_dataout, ni0lOi, ~(ni0lOO));
	and(wire_nlO00O_dataout, wire_nlO0ll_dataout, ~(ni0lOi));
	and(wire_nlO01i_dataout, wire_nlO0ii_dataout, ~(ni0lOO));
	and(wire_nlO01l_dataout, wire_nlO0il_dataout, ~(ni0lOO));
	and(wire_nlO01O_dataout, wire_nlO0iO_dataout, ~(ni0lOO));
	and(wire_nlO0ii_dataout, wire_nlO0lO_dataout, ~(ni0lOi));
	and(wire_nlO0il_dataout, wire_nlO0Oi_dataout, ~(ni0lOi));
	and(wire_nlO0iO_dataout, wire_nlO0Ol_dataout, ~(ni0lOi));
	and(wire_nlO0li_dataout, (~ ni0lOl), ~(ni0lOi));
	and(wire_nlO0ll_dataout, wire_nlO0OO_dataout, ni0lOl);
	and(wire_nlO0lO_dataout, wire_nlOi1i_dataout, ni0lOl);
	and(wire_nlO0Oi_dataout, wire_nlOi1l_dataout, ni0lOl);
	and(wire_nlO0Ol_dataout, ni0Oii, ni0lOl);
	and(wire_nlO0OO_dataout, wire_nlOi1O_dataout, ~(ni0Oii));
	and(wire_nlO10i_dataout, ni0Oii, ni0lll);
	or(wire_nlO10l_dataout, (~ ni0llO), ~(niiOOi));
	and(wire_nlO10O_dataout, ni0llO, niiOOi);
	and(wire_nlO11i_dataout, wire_nlO0OO_dataout, ni0lll);
	and(wire_nlO11l_dataout, wire_nlOi1i_dataout, ni0lll);
	and(wire_nlO11O_dataout, wire_nlOi1l_dataout, ni0lll);
	and(wire_nlO1ii_dataout, wire_nlO1OO_dataout, ~(niiOOi));
	and(wire_nlO1il_dataout, wire_nlO01i_dataout, ~(niiOOi));
	and(wire_nlO1iO_dataout, wire_nlO01l_dataout, ~(niiOOi));
	and(wire_nlO1li_dataout, wire_nlO01O_dataout, ~(niiOOi));
	assign		wire_nlO1ll_dataout = (niiOOi === 1'b1) ? ni0llO : ni0lOO;
	and(wire_nlO1lO_dataout, wire_nlO00i_dataout, ~(niiOOi));
	and(wire_nlO1Oi_dataout, (~ ni0llO), niiOOi);
	and(wire_nlO1Ol_dataout, wire_nlO00l_dataout, ~(niiOOi));
	and(wire_nlO1OO_dataout, wire_nlO00O_dataout, ~(ni0lOO));
	and(wire_nlOi_dataout, nl10l, niiOli);
	and(wire_nlOi0i_dataout, ni0Oli, ~(ni0Oll));
	assign		wire_nlOi0O_dataout = (niiOOi === 1'b1) ? wire_nlOl1O_dataout : wire_nlOiiO_dataout;
	and(wire_nlOi1i_dataout, wire_nlOi0i_dataout, ~(ni0Oii));
	and(wire_nlOi1l_dataout, ni0Oll, ~(ni0Oii));
	and(wire_nlOi1O_dataout, (~ ni0Oli), ~(ni0Oll));
	assign		wire_nlOiii_dataout = (niiOOi === 1'b1) ? wire_nlOl0i_dataout : wire_nlOili_dataout;
	assign		wire_nlOiil_dataout = (niiOOi === 1'b1) ? wire_nlOl0l_dataout : wire_nlOill_dataout;
	assign		wire_nlOiiO_dataout = (ni0Oii === 1'b1) ? wire_nlOiOO_dataout : wire_nlOilO_dataout;
	assign		wire_nlOili_dataout = (ni0Oii === 1'b1) ? wire_nlOl1i_dataout : wire_nlOiOi_dataout;
	assign		wire_nlOill_dataout = (ni0Oii === 1'b1) ? wire_nlOl1l_dataout : wire_nlOiOl_dataout;
	and(wire_nlOilO_dataout, ni0O1i, ~(ni0O0i));
	or(wire_nlOiOi_dataout, ni0O1i, ni0O0i);
	and(wire_nlOiOl_dataout, (~ ni0O1i), ~(ni0O0i));
	and(wire_nlOiOO_dataout, ni0O1l, ~(ni0O0O));
	and(wire_nlOl_dataout, nl10O, niiOli);
	assign		wire_nlOl0i_dataout = (ni0Oii === 1'b1) ? wire_nlOlli_dataout : wire_nlOlii_dataout;
	assign		wire_nlOl0l_dataout = (ni0Oii === 1'b1) ? wire_nlOlll_dataout : wire_nlOlil_dataout;
	and(wire_nlOl0O_dataout, ni0O0i, ~(ni0O1O));
	or(wire_nlOl1i_dataout, ni0O1l, ni0O0O);
	and(wire_nlOl1l_dataout, (~ ni0O1l), ~(ni0O0O));
	assign		wire_nlOl1O_dataout = (ni0Oii === 1'b1) ? wire_nlOliO_dataout : wire_nlOl0O_dataout;
	or(wire_nlOlii_dataout, ni0O0i, ni0O1O);
	and(wire_nlOlil_dataout, (~ ni0O0i), ~(ni0O1O));
	and(wire_nlOliO_dataout, ni0O0O, ~(ni0O0l));
	or(wire_nlOlli_dataout, ni0O0O, ni0O0l);
	and(wire_nlOlll_dataout, (~ ni0O0O), ~(ni0O0l));
	and(wire_nlOllO_dataout, (~ ni0OiO), niiOOi);
	or(wire_nlOlOi_dataout, wire_nlOO1l_dataout, niiOOi);
	and(wire_nlOlOl_dataout, ni0Oii, ~(niiOOi));
	and(wire_nlOlOO_dataout, wire_nlOO1O_dataout, ~(niiOOi));
	and(wire_nlOO_dataout, nl1ii, niiOli);
	and(wire_nlOO0i_dataout, wire_nlOO0O_dataout, ~(ni0Oii));
	and(wire_nlOO0l_dataout, ni0Oil, ni0OiO);
	and(wire_nlOO0O_dataout, (~ ni0Oil), ni0OiO);
	and(wire_nlOO1i_dataout, wire_nlOO0i_dataout, ~(niiOOi));
	and(wire_nlOO1l_dataout, wire_nlOO0l_dataout, ~(ni0Oii));
	and(wire_nlOO1O_dataout, (~ ni0OiO), ~(ni0Oii));
	oper_add   n00Oi
	( 
	.a({n101i, n11OO, n11Ol, n11Oi, n11lO, n11ll, n11li, n11iO, n11il}),
	.b({{8{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n00Oi_o));
	defparam
		n00Oi.sgate_representation = 0,
		n00Oi.width_a = 9,
		n00Oi.width_b = 9,
		n00Oi.width_o = 9;
	oper_add   n01iO
	( 
	.a({n11ii, n110O, n110l, n110i}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n01iO_o));
	defparam
		n01iO.sgate_representation = 0,
		n01iO.width_a = 4,
		n01iO.width_b = 4,
		n01iO.width_o = 4;
	oper_add   n1lOi
	( 
	.a({nlOOiO, nlOOil, nliliO}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1lOi_o));
	defparam
		n1lOi.sgate_representation = 0,
		n1lOi.width_a = 3,
		n1lOi.width_b = 3,
		n1lOi.width_o = 3;
	oper_add   n1Oll
	( 
	.a({nlOOOO, nlOOOl, nlOOOi, nlOOlO, nlOOll, nlOOli}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1Oll_o));
	defparam
		n1Oll.sgate_representation = 0,
		n1Oll.width_a = 6,
		n1Oll.width_b = 6,
		n1Oll.width_o = 6;
	oper_add   n1OOO
	( 
	.a({n111O, n111l, n111i}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_n1OOO_o));
	defparam
		n1OOO.sgate_representation = 0,
		n1OOO.width_a = 3,
		n1OOO.width_b = 3,
		n1OOO.width_o = 3;
	oper_add   nli0ll
	( 
	.a({nl00Ol, nl00Oi, nl00lO, nl00ll, nl00li, nl00iO, nl00il}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0ll_o));
	defparam
		nli0ll.sgate_representation = 0,
		nli0ll.width_a = 7,
		nli0ll.width_b = 7,
		nli0ll.width_o = 7;
	oper_add   nli0lO
	( 
	.a({nl0i0O, nl0i0l, nl0i0i, nl0i1O, nl0i1l, nl0i1i, nl00OO}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0lO_o));
	defparam
		nli0lO.sgate_representation = 0,
		nli0lO.width_a = 7,
		nli0lO.width_b = 7,
		nli0lO.width_o = 7;
	oper_add   nli0Oi
	( 
	.a({nl0iOl, nl0iOi, nl0ilO, nl0ill, nl0ili, nl0iiO, nl0iil, nl0iii}),
	.b({{7{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nli0Oi_o));
	defparam
		nli0Oi.sgate_representation = 0,
		nli0Oi.width_a = 8,
		nli0Oi.width_b = 8,
		nli0Oi.width_o = 8;
	oper_add   nliOl
	( 
	.a({((niilOO16 ^ niilOO15) & niO0O), niO0l, n0lOi}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nliOl_o));
	defparam
		nliOl.sgate_representation = 0,
		nliOl.width_a = 3,
		nliOl.width_b = 3,
		nliOl.width_o = 3;
	oper_add   nllli
	( 
	.a({niOll, niOli, niOiO, ((niiO1i14 ^ niiO1i13) & niOil), niOii}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllli_o));
	defparam
		nllli.sgate_representation = 0,
		nllli.width_a = 5,
		nllli.width_b = 5,
		nllli.width_o = 5;
	oper_selector   n0iii
	( 
	.data({1'b0, wire_niiOl_dataout, (~ niiill)}),
	.o(wire_n0iii_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0iii.width_data = 3,
		n0iii.width_sel = 3;
	oper_selector   n0iil
	( 
	.data({1'b0, wire_niiOO_dataout, niiill}),
	.o(wire_n0iil_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0iil.width_data = 3,
		n0iil.width_sel = 3;
	oper_selector   n0iiO
	( 
	.data({1'b0, wire_nilOi_dataout, wire_nii1O_dataout, {2{(~ niiiil)}}}),
	.o(wire_n0iiO_o),
	.sel({ni0OOO, nli0O, nl01l, nl01i, nl1OO}));
	defparam
		n0iiO.width_data = 5,
		n0iiO.width_sel = 5;
	oper_selector   n0ilO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_n0ilO_o),
	.sel({nii11i, (~ nii11i)}));
	defparam
		n0ilO.width_data = 2,
		n0ilO.width_sel = 2;
	oper_selector   n0iOl
	( 
	.data({1'b0, niiiil, (~ niiiil)}),
	.o(wire_n0iOl_o),
	.sel({nii11l, nl01i, nl1OO}));
	defparam
		n0iOl.width_data = 3,
		n0iOl.width_sel = 3;
	oper_selector   n0l1i
	( 
	.data({1'b0, wire_nii1l_dataout, (~ niiiil)}),
	.o(wire_n0l1i_o),
	.sel({nii11O, nl01l, nl01i}));
	defparam
		n0l1i.width_data = 3,
		n0l1i.width_sel = 3;
	oper_selector   n0l1O
	( 
	.data({1'b0, niiOOi, 1'b1, wire_nii1O_dataout}),
	.o(wire_n0l1O_o),
	.sel({nii10i, nl0ii, (((nl00O | nl00l) | nl00i) | nl01O), nl01l}));
	defparam
		n0l1O.width_data = 4,
		n0l1O.width_sel = 4;
	oper_selector   n0lii
	( 
	.data({1'b0, wire_niili_dataout, wire_nil1i_dataout}),
	.o(wire_n0lii_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0lii.width_data = 3,
		n0lii.width_sel = 3;
	oper_selector   n0lil
	( 
	.data({1'b0, wire_niill_dataout, wire_nil1l_dataout}),
	.o(wire_n0lil_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0lil.width_data = 3,
		n0lil.width_sel = 3;
	oper_selector   n0liO
	( 
	.data({1'b0, wire_niilO_dataout, wire_nil1O_dataout}),
	.o(wire_n0liO_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0liO.width_data = 3,
		n0liO.width_sel = 3;
	oper_selector   n0lli
	( 
	.data({1'b0, wire_niiOi_dataout, wire_nil0i_dataout}),
	.o(wire_n0lli_o),
	.sel({nii10l, nl0iO, nl0il}));
	defparam
		n0lli.width_data = 3,
		n0lli.width_sel = 3;
	oper_selector   n0lOl
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0lOl_o),
	.sel({nii10O, nl0ll, nl0li}));
	defparam
		n0lOl.width_data = 3,
		n0lOl.width_sel = 3;
	oper_selector   n0O0l
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0O0l_o),
	.sel({nii1il, nl0OO, nl0Ol}));
	defparam
		n0O0l.width_data = 3,
		n0O0l.width_sel = 3;
	oper_selector   n0O1l
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0O1l_o),
	.sel({nii1ii, nl0Oi, nl0lO}));
	defparam
		n0O1l.width_data = 3,
		n0O1l.width_sel = 3;
	oper_selector   n0Oil
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0Oil_o),
	.sel({nii1iO, nli1l, nli1i}));
	defparam
		n0Oil.width_data = 3,
		n0Oil.width_sel = 3;
	oper_selector   n0Oll
	( 
	.data({1'b0, niiOOi, 1'b1}),
	.o(wire_n0Oll_o),
	.sel({nii1li, nli0i, nli1O}));
	defparam
		n0Oll.width_data = 3,
		n0Oll.width_sel = 3;
	oper_selector   n0OOl
	( 
	.data({1'b0, niiOOi, wire_nilll_dataout, 1'b1, wire_niiOl_dataout, (~ niiill)}),
	.o(wire_n0OOl_o),
	.sel({nii1ll, nliil, nli0O, nli0l, nl0iO, nl0il}));
	defparam
		n0OOl.width_data = 6,
		n0OOl.width_sel = 6;
	oper_selector   ni00l
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni00l_o),
	.sel({nii00l, (~ nii00l)}));
	defparam
		ni00l.width_data = 2,
		ni00l.width_sel = 2;
	oper_selector   ni01i
	( 
	.data({1'b0, ((nii1OO44 ^ nii1OO43) & niiOOi)}),
	.o(wire_ni01i_o),
	.sel({nii01i, (~ nii01i)}));
	defparam
		ni01i.width_data = 2,
		ni01i.width_sel = 2;
	oper_selector   ni01O
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni01O_o),
	.sel({nii01l, (~ nii01l)}));
	defparam
		ni01O.width_data = 2,
		ni01O.width_sel = 2;
	oper_selector   ni0ii
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni0ii_o),
	.sel({nii0ii, ((nii00O40 ^ nii00O39) & (~ nii0ii))}));
	defparam
		ni0ii.width_data = 2,
		ni0ii.width_sel = 2;
	oper_selector   ni0iO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni0iO_o),
	.sel({((nii0li36 ^ nii0li35) & nii0ll), (~ nii0ll)}));
	defparam
		ni0iO.width_data = 2,
		ni0iO.width_sel = 2;
	oper_selector   ni0ll
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni0ll_o),
	.sel({nii0Ol, (~ nii0Ol)}));
	defparam
		ni0ll.width_data = 2,
		ni0ll.width_sel = 2;
	oper_selector   ni0Oi
	( 
	.data({1'b0, ((nii0OO32 ^ nii0OO31) & wire_nilli_dataout), ((niii1i30 ^ niii1i29) & niiOOi), {7{niiOOi}}}),
	.o(wire_ni0Oi_o),
	.sel({((niii1l28 ^ niii1l27) & niii0l), nli0O, nli0i, nl0OO, nl0ll, nl0ii, nl00O, ((niii1O26 ^ niii1O25) & nl00l), ((niii0i24 ^ niii0i23) & nl00i), nl01l}));
	defparam
		ni0Oi.width_data = 10,
		ni0Oi.width_sel = 10;
	oper_selector   ni10i
	( 
	.data({niiilO, 1'b0, wire_nii0l_dataout, wire_nii1i_dataout}),
	.o(wire_ni10i_o),
	.sel({nlili, nii1Oi, nl01l, nl1OO}));
	defparam
		ni10i.width_data = 4,
		ni10i.width_sel = 4;
	oper_selector   ni11l
	( 
	.data({(~ niiilO), (~ niiOOi), wire_nilOi_dataout, 1'b0, wire_nii0i_dataout, wire_ni0OO_dataout}),
	.o(wire_ni11l_o),
	.sel({nlili, nliil, nli0O, nii1lO, nl01l, nl1OO}));
	defparam
		ni11l.width_data = 6,
		ni11l.width_sel = 6;
	oper_selector   ni1Ol
	( 
	.data({1'b0, niiOOi}),
	.o(wire_ni1Ol_o),
	.sel({nii1Ol, (~ nii1Ol)}));
	defparam
		ni1Ol.width_data = 2,
		ni1Ol.width_sel = 2;
	oper_selector   nil00l
	( 
	.data({1'b0, 1'b1, wire_niO00O_dataout}),
	.o(wire_nil00l_o),
	.sel({(nli11O | nl0O0l), ni1lOO, nl0OOi}));
	defparam
		nil00l.width_data = 3,
		nil00l.width_sel = 3;
	oper_selector   nil01O
	( 
	.data({1'b0, 1'b1, niiOOi, wire_niO00l_dataout}),
	.o(wire_nil01O_o),
	.sel({nli11O, ni1lOl, nl0OOl, nl0OOi}));
	defparam
		nil01O.width_data = 4,
		nil01O.width_sel = 4;
	oper_selector   nil0il
	( 
	.data({1'b0, 1'b1, wire_niO0ii_dataout}),
	.o(wire_nil0il_o),
	.sel({nli11O, ni1O1i, nl0OOi}));
	defparam
		nil0il.width_data = 3,
		nil0il.width_sel = 3;
	oper_selector   nil0li
	( 
	.data({1'b0, 1'b1, wire_niO0il_dataout}),
	.o(wire_nil0li_o),
	.sel({ni1O1O, ni1O1l, nl0OOi}));
	defparam
		nil0li.width_data = 3,
		nil0li.width_sel = 3;
	oper_selector   nil0Oi
	( 
	.data({1'b0, (~ niiOOi), wire_niO0iO_dataout, 1'b1}),
	.o(wire_nil0Oi_o),
	.sel({ni1O0l, nl0OOl, nl0OOi, ni1O0i}));
	defparam
		nil0Oi.width_data = 4,
		nil0Oi.width_sel = 4;
	oper_selector   nil1li
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nil1li_o),
	.sel({ni1lll, (~ ni1lll)}));
	defparam
		nil1li.width_data = 2,
		nil1li.width_sel = 2;
	oper_selector   nil1lO
	( 
	.data({1'b0, (~ niiOOi), wire_niO01O_dataout, 1'b1}),
	.o(wire_nil1lO_o),
	.sel({ni1llO, nl0OOl, nl0OOi, (nl0O0l | nl0O1O)}));
	defparam
		nil1lO.width_data = 4,
		nil1lO.width_sel = 4;
	oper_selector   nil1OO
	( 
	.data({1'b0, (~ niiOOi), wire_niO00i_dataout, 1'b1}),
	.o(wire_nil1OO_o),
	.sel({ni1lOi, nl0OOl, nl0OOi, (nl0O0l | nl0O0i)}));
	defparam
		nil1OO.width_data = 4,
		nil1OO.width_sel = 4;
	oper_selector   nili0i
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nili0i_o),
	.sel({ni1Oil, (~ ni1Oil)}));
	defparam
		nili0i.width_data = 2,
		nili0i.width_sel = 2;
	oper_selector   nili0O
	( 
	.data({1'b0, niiOOi, wire_niO0ll_dataout, niiOOi}),
	.o(wire_nili0O_o),
	.sel({ni1OiO, nl0OOl, nl0OOi, nl0O0O}));
	defparam
		nili0O.width_data = 4,
		nili0O.width_sel = 4;
	oper_selector   nili1i
	( 
	.data({1'b0, 1'b1, wire_niO0li_dataout}),
	.o(wire_nili1i_o),
	.sel({ni1Oii, ni1O0O, nl0OOi}));
	defparam
		nili1i.width_data = 3,
		nili1i.width_sel = 3;
	oper_selector   niliil
	( 
	.data({1'b0, niiOOi, wire_niO0lO_dataout, {5{niiOOi}}}),
	.o(wire_niliil_o),
	.sel({ni1Oli, nli11i, nl0OOi, nl0OlO, nl0Oli, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		niliil.width_data = 8,
		niliil.width_sel = 8;
	oper_selector   nilili
	( 
	.data({1'b0, {2{niiOOi}}, wire_niO0Oi_dataout, {4{niiOOi}}}),
	.o(wire_nilili_o),
	.sel({ni1Oll, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oli, nl0Oil, nl0O0i}));
	defparam
		nilili.width_data = 8,
		nilili.width_sel = 8;
	oper_selector   nililO
	( 
	.data({1'b0, {2{niiOOi}}, wire_niO0Ol_dataout, {5{niiOOi}}}),
	.o(wire_nililO_o),
	.sel({ni1OlO, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oli, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		nililO.width_data = 9,
		nililO.width_sel = 9;
	oper_selector   niliOl
	( 
	.data({1'b0, {2{niiOOi}}, wire_niO0OO_dataout, {4{niiOOi}}}),
	.o(wire_niliOl_o),
	.sel({ni1OOi, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oli, nl0O0O, nl0O0i}));
	defparam
		niliOl.width_data = 8,
		niliOl.width_sel = 8;
	oper_selector   nill0O
	( 
	.data({wire_nl01iO_dataout, wire_nl11Ol_dataout, 1'b0, wire_niO10i_dataout, wire_niO11O_dataout}),
	.o(wire_nill0O_o),
	.sel({nli11O, nli11i, ni011i, nl0OOi, nl0O0i}));
	defparam
		nill0O.width_data = 5,
		nill0O.width_sel = 5;
	oper_selector   nill1i
	( 
	.data({1'b0, niiOOi, wire_niOi1i_dataout, {4{niiOOi}}}),
	.o(wire_nill1i_o),
	.sel({ni1OOl, nl0OOl, nl0OOi, nl0Oli, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		nill1i.width_data = 7,
		nill1i.width_sel = 7;
	oper_selector   nill1O
	( 
	.data({1'b0, {2{niiOOi}}, wire_niOi1l_dataout, {3{niiOOi}}}),
	.o(wire_nill1O_o),
	.sel({ni1OOO, nli11i, nl0OOl, nl0OOi, nl0Oil, nl0O0O, nl0O0i}));
	defparam
		nill1O.width_data = 7,
		nill1O.width_sel = 7;
	oper_selector   nillil
	( 
	.data({wire_nl01li_dataout, wire_nl11OO_dataout, 1'b0, wire_niO10l_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nillil_o),
	.sel({nli11O, nli11i, ni011l, nl0OOi, nl0O0O, nl0O0l}));
	defparam
		nillil.width_data = 6,
		nillil.width_sel = 6;
	oper_selector   nillli
	( 
	.data({wire_nl01ll_dataout, wire_nl101i_dataout, 1'b0, wire_niO10O_dataout, wire_niO11O_dataout}),
	.o(wire_nillli_o),
	.sel({nli11O, nli11i, ni011O, nl0OOi, nl0O0O}));
	defparam
		nillli.width_data = 5,
		nillli.width_sel = 5;
	oper_selector   nilllO
	( 
	.data({wire_nl01lO_dataout, wire_nl101l_dataout, 1'b0, wire_niO1ii_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilllO_o),
	.sel({nli11O, nli11i, ni010i, nl0OOi, nl0Oil, nl0Oii}));
	defparam
		nilllO.width_data = 6,
		nilllO.width_sel = 6;
	oper_selector   nillOl
	( 
	.data({wire_nl01Oi_dataout, wire_nl101O_dataout, 1'b0, wire_niO1il_dataout, wire_niO11O_dataout}),
	.o(wire_nillOl_o),
	.sel({nli11O, nli11i, ni010l, nl0OOi, nl0Oil}));
	defparam
		nillOl.width_data = 5,
		nillOl.width_sel = 5;
	oper_selector   nilO0l
	( 
	.data({wire_nl001i_dataout, wire_nl100O_dataout, 1'b0, wire_niO1ll_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilO0l_o),
	.sel({nli11O, nli11i, ni01il, nl0OOi, nl0OlO, nl0Oll}));
	defparam
		nilO0l.width_data = 6,
		nilO0l.width_sel = 6;
	oper_selector   nilO1i
	( 
	.data({wire_nl01Ol_dataout, wire_nl100i_dataout, 1'b0, wire_niO1iO_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilO1i_o),
	.sel({nli11O, nli11i, ni010O, nl0OOi, nl0Oli, nl0OiO}));
	defparam
		nilO1i.width_data = 6,
		nilO1i.width_sel = 6;
	oper_selector   nilO1O
	( 
	.data({wire_nl01OO_dataout, wire_nl100l_dataout, 1'b0, wire_niO1li_dataout, wire_niO11O_dataout}),
	.o(wire_nilO1O_o),
	.sel({nli11O, nli11i, ni01ii, nl0OOi, nl0Oli}));
	defparam
		nilO1O.width_data = 5,
		nilO1O.width_sel = 5;
	oper_selector   nilOii
	( 
	.data({wire_nl001l_dataout, wire_nl10ii_dataout, 1'b0, wire_niO1lO_dataout, wire_niO11O_dataout}),
	.o(wire_nilOii_o),
	.sel({nli11O, nli11i, ni01iO, nl0OOi, nl0OlO}));
	defparam
		nilOii.width_data = 5,
		nilOii.width_sel = 5;
	oper_selector   nilOiO
	( 
	.data({wire_nl001O_dataout, wire_nl10il_dataout, 1'b0, wire_niO1Oi_dataout}),
	.o(wire_nilOiO_o),
	.sel({nli11O, nli11i, ni01ll, nl0OOi}));
	defparam
		nilOiO.width_data = 4,
		nilOiO.width_sel = 4;
	oper_selector   nilOli
	( 
	.data({wire_nl000i_dataout, wire_nl10iO_dataout, wire_nlO_dataout, wire_niO1Ol_dataout, 1'b0}),
	.o(wire_nilOli_o),
	.sel({nli11O, nli11i, nl0OOl, nl0OOi, ni01li}));
	defparam
		nilOli.width_data = 5,
		nilOli.width_sel = 5;
	oper_selector   nilOlO
	( 
	.data({wire_nl000l_dataout, wire_nl10li_dataout, 1'b0, wire_niO1OO_dataout}),
	.o(wire_nilOlO_o),
	.sel({nli11O, nli11i, ni01ll, nl0OOi}));
	defparam
		nilOlO.width_data = 4,
		nilOlO.width_sel = 4;
	oper_selector   nilOOl
	( 
	.data({wire_nl000O_dataout, wire_nl10ll_dataout, 1'b0, wire_niO01i_dataout, wire_niO11l_dataout, wire_nlO_dataout}),
	.o(wire_nilOOl_o),
	.sel({nli11O, nli11i, ni01lO, nl0OOi, nl0O0i, nl0O1O}));
	defparam
		nilOOl.width_data = 6,
		nilOOl.width_sel = 6;
	oper_selector   niO11i
	( 
	.data({wire_nl00ii_dataout, wire_nl10lO_dataout, (~ wire_nlO_dataout), wire_niO01l_dataout, {10{(~ wire_nlO_dataout)}}}),
	.o(wire_niO11i_o),
	.sel({nli11O, nli11i, nl0OOl, nl0OOi, nl0OlO, nl0Oll, nl0Oli, nl0OiO, nl0Oil, nl0Oii, nl0O0O, nl0O0l, nl0O0i, nl0O1O}));
	defparam
		niO11i.width_data = 14,
		niO11i.width_sel = 14;
	oper_selector   nlilOi
	( 
	.data({1'b0, wire_nlOO1i_dataout, wire_nlllll_dataout, {2{(~ ni0l0l)}}}),
	.o(wire_nlilOi_o),
	.sel({ni000i, n1l0l, n1iii, n1i0O, n1i0l}));
	defparam
		nlilOi.width_data = 5,
		nlilOi.width_sel = 5;
	oper_selector   nliO0l
	( 
	.data({1'b0, wire_nlllli_dataout, (~ ni0l0l)}),
	.o(wire_nliO0l_o),
	.sel({ni00ii, n1iii, n1i0O}));
	defparam
		nliO0l.width_data = 3,
		nliO0l.width_sel = 3;
	oper_selector   nliO1i
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nliO1i_o),
	.sel({ni000l, (~ ni000l)}));
	defparam
		nliO1i.width_data = 2,
		nliO1i.width_sel = 2;
	oper_selector   nliO1O
	( 
	.data({1'b0, ni0l0l, (~ ni0l0l)}),
	.o(wire_nliO1O_o),
	.sel({ni000O, n1i0O, n1i0l}));
	defparam
		nliO1O.width_data = 3,
		nliO1O.width_sel = 3;
	oper_selector   nliOii
	( 
	.data({1'b0, niiOOi, 1'b1, wire_nlllll_dataout}),
	.o(wire_nliOii_o),
	.sel({ni00il, n1ilO, (((n1ill | n1ili) | n1iiO) | n1iil), n1iii}));
	defparam
		nliOii.width_data = 4,
		nliOii.width_sel = 4;
	oper_selector   nliOli
	( 
	.data({1'b0, wire_nlO1ii_dataout, wire_nllO0l_dataout}),
	.o(wire_nliOli_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOli.width_data = 3,
		nliOli.width_sel = 3;
	oper_selector   nliOlO
	( 
	.data({1'b0, wire_nlO1il_dataout, wire_nllO0O_dataout}),
	.o(wire_nliOlO_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOlO.width_data = 3,
		nliOlO.width_sel = 3;
	oper_selector   nliOOi
	( 
	.data({1'b0, wire_nlO1iO_dataout, wire_nllOii_dataout}),
	.o(wire_nliOOi_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOOi.width_data = 3,
		nliOOi.width_sel = 3;
	oper_selector   nliOOl
	( 
	.data({1'b0, wire_nlO1li_dataout, wire_nllOil_dataout}),
	.o(wire_nliOOl_o),
	.sel({ni00iO, n1l1i, n1iOO}));
	defparam
		nliOOl.width_data = 3,
		nliOOl.width_sel = 3;
	oper_selector   nll00O
	( 
	.data({1'b0, 1'b1, (~ niiOOi)}),
	.o(wire_nll00O_o),
	.sel({ni0i0l, ni0i0i, n1iOi}));
	defparam
		nll00O.width_data = 3,
		nll00O.width_sel = 3;
	oper_selector   nll01i
	( 
	.data({ni0Oii, 1'b0, wire_nlllOi_dataout, wire_nllliO_dataout}),
	.o(wire_nll01i_o),
	.sel({n1liO, ni0i1i, n1iii, n1i0l}));
	defparam
		nll01i.width_data = 4,
		nll01i.width_sel = 4;
	oper_selector   nll01O
	( 
	.data({1'b0, 1'b1, (~ niiOOi)}),
	.o(wire_nll01O_o),
	.sel({ni0i1O, ni0i1l, n1iOi}));
	defparam
		nll01O.width_data = 3,
		nll01O.width_sel = 3;
	oper_selector   nll0iO
	( 
	.data({1'b0, 1'b1, niiOOi}),
	.o(wire_nll0iO_o),
	.sel({ni0iii, ni0i0O, n1iOi}));
	defparam
		nll0iO.width_data = 3,
		nll0iO.width_sel = 3;
	oper_selector   nll0lO
	( 
	.data({1'b0, 1'b1, (~ niiOOi)}),
	.o(wire_nll0lO_o),
	.sel({ni0iiO, ni0iil, n1iOi}));
	defparam
		nll0lO.width_data = 3,
		nll0lO.width_sel = 3;
	oper_selector   nll0OO
	( 
	.data({1'b0, 1'b1, niiOOi}),
	.o(wire_nll0OO_o),
	.sel({(((n1liO | n1l1O) | n1iOO) | n1iil), ni0ili, n1iOi}));
	defparam
		nll0OO.width_data = 3,
		nll0OO.width_sel = 3;
	oper_selector   nll10i
	( 
	.data({1'b0, wire_nlO1lO_dataout, wire_nllOiO_dataout, wire_nllO0i_dataout}),
	.o(wire_nll10i_o),
	.sel({ni00ll, n1l1i, n1iOO, n1iOl}));
	defparam
		nll10i.width_data = 4,
		nll10i.width_sel = 4;
	oper_selector   nll10O
	( 
	.data({1'b0, wire_nlOiii_dataout, wire_nlO1Oi_dataout, (~ niiOOi)}),
	.o(wire_nll10O_o),
	.sel({ni00lO, n1l1l, n1l1i, n1iOO}));
	defparam
		nll10O.width_data = 4,
		nll10O.width_sel = 4;
	oper_selector   nll11l
	( 
	.data({1'b0, 1'b1, wire_nllO1O_dataout}),
	.o(wire_nll11l_o),
	.sel({ni00li, n1iOi, n1iOl}));
	defparam
		nll11l.width_data = 3,
		nll11l.width_sel = 3;
	oper_selector   nll1il
	( 
	.data({1'b0, wire_nlOlOi_dataout, 1'b1, wire_nlOiil_dataout, wire_nlO1Ol_dataout, wire_nllOli_dataout}),
	.o(wire_nll1il_o),
	.sel({ni00Oi, n1l0l, (n1l0i | n1l1O), n1l1l, n1l1i, n1iOO}));
	defparam
		nll1il.width_data = 6,
		nll1il.width_sel = 6;
	oper_selector   nll1ll
	( 
	.data({1'b0, niiOOi, wire_nlOlOl_dataout}),
	.o(wire_nll1ll_o),
	.sel({ni00Ol, n1lii, n1l0l}));
	defparam
		nll1ll.width_data = 3,
		nll1ll.width_sel = 3;
	oper_selector   nll1Ol
	( 
	.data({(~ ni0Oii), (~ niiOOi), wire_nlOO1i_dataout, 1'b0, wire_nllllO_dataout, wire_nlllil_dataout}),
	.o(wire_nll1Ol_o),
	.sel({n1liO, n1lii, n1l0l, ni00OO, n1iii, n1i0l}));
	defparam
		nll1Ol.width_data = 6,
		nll1Ol.width_sel = 6;
	oper_selector   nlli0i
	( 
	.data({1'b0, 1'b1, niiOOi}),
	.o(wire_nlli0i_o),
	.sel({ni0ilO, ni0ill, n1iOi}));
	defparam
		nlli0i.width_data = 3,
		nlli0i.width_sel = 3;
	oper_selector   nlliil
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlliil_o),
	.sel({ni0iOi, (~ ni0iOi)}));
	defparam
		nlliil.width_data = 2,
		nlliil.width_sel = 2;
	oper_selector   nllili
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nllili_o),
	.sel({ni0iOl, (~ ni0iOl)}));
	defparam
		nllili.width_data = 2,
		nllili.width_sel = 2;
	oper_selector   nllilO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nllilO_o),
	.sel({ni0l1i, (~ ni0l1i)}));
	defparam
		nllilO.width_data = 2,
		nllilO.width_sel = 2;
	oper_selector   nlliOi
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlliOi_o),
	.sel({ni0iOO, (~ ni0iOO)}));
	defparam
		nlliOi.width_data = 2,
		nlliOi.width_sel = 2;
	oper_selector   nlliOO
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlliOO_o),
	.sel({ni0l1i, (~ ni0l1i)}));
	defparam
		nlliOO.width_data = 2,
		nlliOO.width_sel = 2;
	oper_selector   nlll0i
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlll0i_o),
	.sel({ni0l1O, (~ ni0l1O)}));
	defparam
		nlll0i.width_data = 2,
		nlll0i.width_sel = 2;
	oper_selector   nlll0O
	( 
	.data({1'b0, wire_nlOllO_dataout, {9{niiOOi}}}),
	.o(wire_nlll0O_o),
	.sel({ni0l0i, n1l0l, n1l1i, n1iOO, n1iOi, n1iOl, n1ilO, n1ill, n1ili, n1iil, n1iii}));
	defparam
		nlll0O.width_data = 11,
		nlll0O.width_sel = 11;
	oper_selector   nlll1l
	( 
	.data({1'b0, niiOOi}),
	.o(wire_nlll1l_o),
	.sel({ni0l1l, (~ ni0l1l)}));
	defparam
		nlll1l.width_data = 2,
		nlll1l.width_sel = 2;
	assign
		bist_ctl_sg = {wire_ni1O_dataout, wire_ni1l_dataout},
		bist_data_sg = {wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout, wire_n0lO_dataout, wire_n0ll_dataout, wire_n0li_dataout, wire_n0iO_dataout, wire_n0il_dataout, wire_n0ii_dataout, wire_n00O_dataout, wire_n00l_dataout, wire_n00i_dataout, wire_n01O_dataout, wire_n01l_dataout, wire_n01i_dataout},
		ni000i = (((((((((((((n1liO | n1lii) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil),
		ni000l = ((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1iiO) | n1i0O) | n1i0l),
		ni000O = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii),
		ni001i = ((((((((~ nl0iOl) & (~ nl0iOi)) & (~ nl0ilO)) & (~ nl0ill)) & (~ nl0ili)) & nl0iiO) & nl0iil) & nl0iii),
		ni001O = (nli11i | nl0OOi),
		ni00ii = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1i0l),
		ni00il = (((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1i0O) | n1i0l),
		ni00iO = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00li = (((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00ll = ((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00lO = ((((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1l1O) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00Oi = (((((((((((n1liO | n1lii) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00Ol = (((((((((((((((n1liO | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni00OO = ((((((((((((n1l0i | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1i0O),
		ni010i = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni010l = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni010O = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni011i = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O1O),
		ni011l = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0i) | nl0O1O),
		ni011O = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01ii = (((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01il = ((((((((nl0OOl | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01iO = (((((((((nl0OOl | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01li = (((((((((nl0OlO | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01ll = ((((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni01lO = ((((((((nl0OOl | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l),
		ni01Oi = (((((((nl0iOl & nl0iOi) & nl0ilO) & nl0ill) & nl0ili) & nl0iiO) & nl0iil) & nl0iii),
		ni01Ol = ((((((nl00Ol & nl00Oi) & nl00lO) & nl00ll) & nl00li) & nl00iO) & nl00il),
		ni01OO = ((((((((~ nl0iOl) & (~ nl0iOi)) & (~ nl0ilO)) & nl0ill) & (~ nl0ili)) & (~ nl0iiO)) & (~ nl0iil)) & (~ nl0iii)),
		ni0i0i = ((((((n1lii | n1l1O) | n1l1l) | n1iOO) | n1ill) | n1ili) | n1iil),
		ni0i0l = (((((((((n1liO | n1l0l) | n1l0i) | n1l1i) | n1iOl) | n1ilO) | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0i0O = (((((((((((n1l0l | n1l0i) | n1l1l) | n1l1i) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0i1i = ((((((((((((((n1lii | n1l0l) | n1l0i) | n1l1O) | n1l1l) | n1l1i) | n1iOO) | n1iOl) | n1iOi) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1i0O),
		ni0i1l = (((((((((n1lii | n1l0l) | n1l0i) | n1l1O) | n1iOO) | n1iOl) | n1ilO) | n1ill) | n1iiO) | n1iil),
		ni0i1O = ((((((n1liO | n1l1l) | n1l1i) | n1ili) | n1iii) | n1i0O) | n1i0l),
		ni0iii = ((((n1liO | n1lii) | n1l1O) | n1iOO) | n1iil),
		ni0iil = (((((((((((n1lii | n1l1O) | n1l1l) | n1iOO) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0iiO = ((((n1liO | n1l0l) | n1l0i) | n1l1i) | n1iOl),
		ni0ili = ((((((((((((n1lii | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0ill = (((((((n1lii | n1l0l) | n1l0i) | n1l1l) | n1l1i) | n1iOO) | n1iiO) | n1i0O),
		ni0ilO = ((((((((n1liO | n1l1O) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iil) | n1iii) | n1i0l),
		ni0iOi = (((((((((((n1liO | n1l0i) | n1l1O) | n1l1l) | n1iOO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0iOl = (((((((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1iOO) | n1iOl) | n1ilO) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0iOO = ((((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1iOO) | n1iOl) | n1iiO) | n1i0O) | n1i0l),
		ni0l0i = (((((((n1liO | n1lii) | n1l0i) | n1l1O) | n1l1l) | n1iiO) | n1i0O) | n1i0l),
		ni0l0l = ((nlOOiO & (~ nlOOil)) & nliliO),
		ni0l0O = ((nlOOiO & nlOOil) & (~ nliliO)),
		ni0l1i = ((((((n1liO | n1l0i) | n1l1i) | n1iOi) | n1iiO) | n1i0O) | n1i0l),
		ni0l1l = ((((((n1liO | n1lii) | n1l0l) | n1l0i) | n1iiO) | n1i0O) | n1i0l),
		ni0l1O = ((((((((((n1liO | n1l0i) | n1iOl) | n1iOi) | n1ill) | n1ili) | n1iiO) | n1iil) | n1iii) | n1i0O) | n1i0l),
		ni0lii = (((~ nlOOiO) & nlOOil) & (~ nliliO)),
		ni0lil = ((((((~ nlOOOO) & nlOOOl) & (~ nlOOOi)) & (~ nlOOlO)) & nlOOll) & nlOOli),
		ni0liO = (((((nlOOOO & (~ nlOOOl)) & (~ nlOOOi)) & nlOOlO) & nlOOll) & nlOOli),
		ni0lli = (((~ n111O) & n111l) & n111i),
		ni0lll = ((n111O & n111l) & n111i),
		ni0llO = ((((~ n11ii) & (~ n110O)) & n110l) & (~ n110i)),
		ni0lOi = ((((~ n11ii) & n110O) & n110l) & n110i),
		ni0lOl = (((n11ii & n110O) & n110l) & n110i),
		ni0lOO = (((((~ n11ii) & (~ n110O)) & n110l) & n110i) | (((n11ii & (~ n110O)) & n110l) & n110i)),
		ni0O0i = (((((((((~ n101i) & n11OO) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & n11iO) & n11il),
		ni0O0l = (((((((((~ n101i) & (~ n11OO)) & n11Ol) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & (~ n11iO)) & (~ n11il)),
		ni0O0O = (((((((((~ n101i) & n11OO) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & n11iO) & (~ n11il)),
		ni0O1i = ((((((((n101i & (~ n11OO)) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & n11li) & n11iO) & n11il),
		ni0O1l = ((((((((n101i & (~ n11OO)) & (~ n11Ol)) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & n11li) & n11iO) & (~ n11il)),
		ni0O1O = (((((((((~ n101i) & (~ n11OO)) & n11Ol) & (~ n11Oi)) & (~ n11lO)) & (~ n11ll)) & (~ n11li)) & (~ n11iO)) & n11il),
		ni0Oii = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		ni0Oil = (((~ nlOOiO) & (~ nlOOil)) & nliliO),
		ni0OiO = (ni0Oll | ni0Oli),
		ni0Oli = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		ni0Oll = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		ni0OlO = ((((n1lii | n1iiO) | n1iii) | n1i0O) | n1i0l),
		ni0OOi = ((((((n1liO | n1l0l) | n1l0i) | n1l1O) | n1ill) | n1ili) | n1i0l),
		ni0OOl = ((((((n1liO | n1l0l) | n1l1O) | n1l1l) | n1ili) | n1i0O) | n1i0l),
		ni0OOO = (((((((((((((((((((nlili | nliil) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O),
		ni1lll = ((((((nli11O | nl0OOi) | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1llO = (((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0i),
		ni1lOi = (((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O1O),
		ni1lOl = ((((((((((nli11i | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1lOO = ((((((((((nli11i | nl0OOl) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0i) | nl0O1O),
		ni1O0i = ((((((nl0Oli | nl0OiO) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O0l = ((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oil),
		ni1O0O = (((((((nli11i | nl0OOl) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O1i = (((((((((((nli11i | nl0OOl) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O1l = (((((((nli11i | nl0OOl) | nl0Oll) | nl0OiO) | nl0O0O) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1O1O = ((((nli11O | nl0OlO) | nl0Oli) | nl0Oil) | nl0Oii),
		ni1Oii = ((((nli11O | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO),
		ni1Oil = (((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OiO = ((((((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O0i) | nl0O1O),
		ni1Oli = ((((((nli11O | nl0OOl) | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1Oll = ((((((nli11O | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0O) | nl0O0l) | nl0O1O),
		ni1OlO = (((((nli11O | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OOi = ((((((nli11O | nl0Oll) | nl0OiO) | nl0Oil) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OOl = (((((((nli11O | nli11i) | nl0OlO) | nl0Oll) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		ni1OOO = (((((((nli11O | nl0OlO) | nl0Oll) | nl0Oli) | nl0OiO) | nl0Oii) | nl0O0l) | nl0O1O),
		nii00l = (((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0il) | nl01O) | nl01i) | nl1OO),
		nii01i = (((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii01l = (((((((((((((nlili | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (nii01O42 ^ nii01O41))),
		nii0ii = (((((((((((((nlili | nli0l) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0lO) | nl0li) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (nii0il38 ^ nii0il37))),
		nii0ll = ((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (nii0lO34 ^ nii0lO33))),
		nii0Ol = ((((((((((((((((nlili | nli0l) | nli1O) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0il) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii10i = (((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl01i) | nl1OO),
		nii10l = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii10O = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii11i = ((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO),
		nii11l = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l),
		nii11O = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl1OO),
		nii1ii = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1il = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1iO = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli0i) | nli1O) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1li = (((((((((((((((((((((nlili | nliil) | nli0O) | nli0l) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1ll = ((((((((((((((((((nlili | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		nii1lO = ((((((((((((((((((nli0l | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01i),
		nii1Oi = ((((((((((((((((((((nliil | nli0O) | nli0l) | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0lO) | nl0ll) | nl0li) | nl0iO) | nl0il) | nl0ii) | nl00O) | nl00l) | nl00i) | nl01O) | nl01i),
		nii1Ol = (((((((((((((((nlili | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0il) | nl00O) | nl00l) | nl00i) | nl01O) | nl01l) | nl01i) | nl1OO),
		niii0l = (((((((((((((((nlili | nliil) | nli0l) | nli1O) | nli1l) | nli1i) | nl0Ol) | nl0Oi) | nl0lO) | nl0li) | nl0iO) | nl0il) | nl01O) | nl01i) | nl1OO) | (~ (niii0O22 ^ niii0O21))),
		niiiil = ((niO0O & (~ niO0l)) & n0lOi),
		niiiiO = ((niO0O & niO0l) & (~ n0lOi)),
		niiili = (((~ niO0O) & niO0l) & (~ n0lOi)),
		niiill = ((((niOll & niOli) & niOiO) & niOil) & (~ niOii)),
		niiilO = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		niiiOi = (((~ niO0O) & (~ niO0l)) & n0lOi),
		niiiOl = (niil1i | niiiOO),
		niiiOO = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		niil0i = (((((((((nliil | nli0i) | nli1O) | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl0Oi) | nl0ll) | nl0li),
		niil0l = (((((((((nlili | nliil) | nli1l) | nl0OO) | nl0Oi) | nl0li) | nl0il) | nl0ii) | nl00O) | nl00i),
		niil0O = (((((((((nlili | nli0O) | nli0l) | nli1O) | nli1l) | nli1i) | nl0Oi) | nl0lO) | nl0iO) | nl00l),
		niil1i = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		niil1l = ((((nliil | nl01O) | nl01l) | nl01i) | nl1OO),
		niil1O = (((((((nlili | nli0i) | nl0lO) | nl0ll) | nl0ii) | nl01l) | nl01i) | nl1OO),
		niilii = (((((nlili | nli1l) | nli1i) | nl0OO) | nl0Ol) | nl00l),
		niilil = (((((((((((nlili | nli0O) | nli0l) | nli1O) | nli1i) | nl0Ol) | nl0lO) | nl0ll) | nl0il) | nl00l) | nl00i) | nl1OO),
		niiliO = (((((((((nlili | nli0i) | nli1l) | nl0Ol) | nl0Oi) | nl0lO) | nl0iO) | nl00l) | nl01l) | nl1OO),
		niilli = (((((((((nliil | nli0l) | nli0i) | nli1O) | nl0Ol) | nl0Oi) | nl0li) | nl0ii) | nl01O) | nl01l),
		niilll = 1'b1,
		niilOl = 1'b0,
		niiOil = (((~ rbist_sel[0]) & (~ rbist_sel[1])) & (niiO0O8 ^ niiO0O7)),
		niiOiO = ((rbist_sel[0] & (~ rbist_sel[1])) & (niiO0i10 ^ niiO0i9)),
		niiOli = (((~ rbist_sel[0]) & rbist_sel[1]) & (niiO1l12 ^ niiO1l11)),
		niiOOi = ((((rpmadwidth_tx & (~ rpma_doublewidth_tx)) & (nil11i2 ^ nil11i1)) & rdwidth_tx) | ((rpmadwidth_tx & rpma_doublewidth_tx) & (niiOOl4 ^ niiOOl3)));
endmodule //arriaii_hssi_tx_digi_bist_gen
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 106 mux21 189 oper_add 1 oper_decoder 1 oper_mux 23 oper_selector 23 
`timescale 1 ps / 1 ps
module  arriaii_hssi_tx_digi_prbs_gen
	( 
	cid_en,
	prbs_out,
	rcid_len,
	rcid_pattern,
	rpma_doublewidth_tx,
	rpmadwidth_tx,
	rprbs_en_tx,
	rprbs_sel,
	soft_reset,
	tx_clk) /* synthesis synthesis_clearbox=1 */;
	input   cid_en;
	output   [19:0]  prbs_out;
	input   [7:0]  rcid_len;
	input   rcid_pattern;
	input   rpma_doublewidth_tx;
	input   rpmadwidth_tx;
	input   rprbs_en_tx;
	input   [2:0]  rprbs_sel;
	input   soft_reset;
	input   tx_clk;

	reg	nll00l33;
	reg	nll00l34;
	reg	nll01i37;
	reg	nll01i38;
	reg	nll01O35;
	reg	nll01O36;
	reg	nll0ii31;
	reg	nll0ii32;
	reg	nll0iO29;
	reg	nll0iO30;
	reg	nll0Ol27;
	reg	nll0Ol28;
	reg	nll1ii45;
	reg	nll1ii46;
	reg	nll1li43;
	reg	nll1li44;
	reg	nll1lO41;
	reg	nll1lO42;
	reg	nll1Ol39;
	reg	nll1Ol40;
	reg	nlli0l23;
	reg	nlli0l24;
	reg	nlli1O25;
	reg	nlli1O26;
	reg	nlliil21;
	reg	nlliil22;
	reg	nlliiO19;
	reg	nlliiO20;
	reg	nllill17;
	reg	nllill18;
	reg	nlliOi15;
	reg	nlliOi16;
	reg	nlll0O11;
	reg	nlll0O12;
	reg	nlll1i13;
	reg	nlll1i14;
	reg	nlllil10;
	reg	nlllil9;
	reg	nllliO7;
	reg	nllliO8;
	reg	nlllli5;
	reg	nlllli6;
	reg	nlllll3;
	reg	nlllll4;
	reg	nlllOl1;
	reg	nlllOl2;
	reg	ni0O;
	reg	nlO0Ol;
	reg	nlO0OO;
	reg	nlOi0i;
	reg	nlOi0l;
	reg	nlOi0O;
	reg	nlOi1i;
	reg	nlOi1l;
	reg	nlOi1O;
	reg	nlOiii;
	reg	nlOiil;
	reg	nlOiiO;
	reg	nlOili;
	reg	nlOill;
	reg	nlOilO;
	reg	nlOiOi;
	reg	nlOiOl;
	reg	nlOiOO;
	reg	nlOl1i;
	reg	nlOl1l;
	reg	nlOl1O;
	reg	ni0l_clk_prev;
	wire	wire_ni0l_PRN;
	reg	n0i;
	reg	n1i;
	reg	n1l;
	reg	n1O;
	reg	nili;
	reg	nill;
	reg	nlll;
	reg	nllO;
	reg	nlOi;
	reg	nlOl;
	reg	nlOl0i;
	reg	nlOl0l;
	reg	nlOl0O;
	reg	nlOlii;
	reg	nlOlil;
	reg	nlOliO;
	reg	nlOlli;
	reg	nlOlll;
	reg	nlOllO;
	reg	nlOlOi;
	reg	nlOlOl;
	reg	nlOlOO;
	reg	nlOO;
	reg	nlOO0i;
	reg	nlOO0l;
	reg	nlOO0O;
	reg	nlOO1i;
	reg	nlOO1l;
	reg	nlOO1O;
	reg	nlOOii;
	reg	nlOOil;
	reg	nlOOiO;
	reg	nlOOli;
	reg	nlOOll;
	reg	nlOOlO;
	reg	nO;
	wire	wire_nl_CLRN;
	reg	nilO;
	reg	nlil;
	reg	nlli;
	wire	wire_nliO_PRN;
	wire	wire_n0l_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n100i_dataout;
	wire	wire_n100l_dataout;
	wire	wire_n100O_dataout;
	wire	wire_n101i_dataout;
	wire	wire_n101l_dataout;
	wire	wire_n101O_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10ii_dataout;
	wire	wire_n10il_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n110i_dataout;
	wire	wire_n110l_dataout;
	wire	wire_n110O_dataout;
	wire	wire_n111i_dataout;
	wire	wire_n111l_dataout;
	wire	wire_n111O_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11ii_dataout;
	wire	wire_n11il_dataout;
	wire	wire_n11iO_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11li_dataout;
	wire	wire_n11ll_dataout;
	wire	wire_n11lO_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n11Oi_dataout;
	wire	wire_n11Ol_dataout;
	wire	wire_n11OO_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1i1O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1iOl_dataout;
	wire	wire_n1iOO_dataout;
	wire	wire_n1l0i_dataout;
	wire	wire_n1l0l_dataout;
	wire	wire_n1l0O_dataout;
	wire	wire_n1l1i_dataout;
	wire	wire_n1l1l_dataout;
	wire	wire_n1l1O_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1lii_dataout;
	wire	wire_n1lil_dataout;
	wire	wire_n1liO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1llO_dataout;
	wire	wire_n1lOi_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1lOO_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O1i_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nilii_dataout;
	wire	wire_nilil_dataout;
	wire	wire_niliO_dataout;
	wire	wire_nilli_dataout;
	wire	wire_nilll_dataout;
	wire	wire_nillO_dataout;
	wire	wire_nilOi_dataout;
	wire	wire_nilOl_dataout;
	wire	wire_nilOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO0i_dataout;
	wire	wire_niO0l_dataout;
	wire	wire_niO0O_dataout;
	wire	wire_niO1i_dataout;
	wire	wire_niO1l_dataout;
	wire	wire_niO1O_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOii_dataout;
	wire	wire_niOil_dataout;
	wire	wire_niOiO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOli_dataout;
	wire	wire_niOll_dataout;
	wire	wire_niOlO_dataout;
	wire	wire_niOOi_dataout;
	wire	wire_niOOl_dataout;
	wire	wire_niOOO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0iO_dataout;
	wire	wire_nl0li_dataout;
	wire	wire_nl0ll_dataout;
	wire	wire_nl0lO_dataout;
	wire	wire_nl0Oi_dataout;
	wire	wire_nl0Ol_dataout;
	wire	wire_nl0OO_dataout;
	wire	wire_nl10i_dataout;
	wire	wire_nl10l_dataout;
	wire	wire_nl10O_dataout;
	wire	wire_nl11i_dataout;
	wire	wire_nl11l_dataout;
	wire	wire_nl11O_dataout;
	wire	wire_nl1ii_dataout;
	wire	wire_nl1il_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli0i_dataout;
	wire	wire_nli0l_dataout;
	wire	wire_nli0O_dataout;
	wire	wire_nli1i_dataout;
	wire	wire_nli1l_dataout;
	wire	wire_nli1O_dataout;
	wire	wire_nliii_dataout;
	wire	wire_nliil_dataout;
	wire	wire_nliiO_dataout;
	wire	wire_nlili_dataout;
	wire	wire_nlill_dataout;
	wire	wire_nlilO_dataout;
	wire	wire_nliOi_dataout;
	wire	wire_nliOl_dataout;
	wire	wire_nliOO_dataout;
	wire	wire_nll_dataout;
	wire	wire_nll0i_dataout;
	wire	wire_nll0l_dataout;
	wire	wire_nll0O_dataout;
	wire	wire_nll1i_dataout;
	wire	wire_nll1l_dataout;
	wire	wire_nll1O_dataout;
	wire	wire_nllii_dataout;
	wire	wire_nllil_dataout;
	wire	wire_nlliO_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOO_dataout;
	wire	wire_nlOOOi_dataout;
	wire	wire_nlOOOl_dataout;
	wire	wire_nlOOOO_dataout;
	wire  [8:0]   wire_ni_o;
	wire  [31:0]   wire_n00ii_o;
	wire  wire_n00il_o;
	wire  wire_n00iO_o;
	wire  wire_n00li_o;
	wire  wire_n00ll_o;
	wire  wire_n00lO_o;
	wire  wire_n00Oi_o;
	wire  wire_n00Ol_o;
	wire  wire_n00OO_o;
	wire  wire_n0i0i_o;
	wire  wire_n0i0l_o;
	wire  wire_n0i0O_o;
	wire  wire_n0i1i_o;
	wire  wire_n0i1l_o;
	wire  wire_n0i1O_o;
	wire  wire_n0iii_o;
	wire  wire_n0iil_o;
	wire  wire_n0iiO_o;
	wire  wire_n0ili_o;
	wire  wire_n0ill_o;
	wire  wire_n0ilO_o;
	wire  wire_n0iOi_o;
	wire  wire_n0iOl_o;
	wire  wire_n0iOO_o;
	wire  wire_n000i_o;
	wire  wire_n001O_o;
	wire  wire_n010i_o;
	wire  wire_n010O_o;
	wire  wire_n011i_o;
	wire  wire_n011l_o;
	wire  wire_n011O_o;
	wire  wire_n01iO_o;
	wire  wire_n01ll_o;
	wire  wire_n01lO_o;
	wire  wire_n01Oi_o;
	wire  wire_n01Ol_o;
	wire  wire_n1O0O_o;
	wire  wire_n1Oii_o;
	wire  wire_n1Oil_o;
	wire  wire_n1OiO_o;
	wire  wire_n1Oli_o;
	wire  wire_n1Oll_o;
	wire  wire_n1OlO_o;
	wire  wire_n1OOi_o;
	wire  wire_niOO_o;
	wire  wire_nl1i_o;
	wire  wire_nl1l_o;
	wire  nliiOO;
	wire  nlil0i;
	wire  nlil0l;
	wire  nlil0O;
	wire  nlil1i;
	wire  nlil1l;
	wire  nlil1O;
	wire  nlilii;
	wire  nlilil;
	wire  nliliO;
	wire  nlilli;
	wire  nlilll;
	wire  nlillO;
	wire  nlilOi;
	wire  nlilOl;
	wire  nlilOO;
	wire  nliO0i;
	wire  nliO0l;
	wire  nliO0O;
	wire  nliO1i;
	wire  nliO1l;
	wire  nliO1O;
	wire  nliOii;
	wire  nliOil;
	wire  nliOiO;
	wire  nliOli;
	wire  nliOll;
	wire  nliOlO;
	wire  nliOOi;
	wire  nliOOl;
	wire  nliOOO;
	wire  nll0ll;
	wire  nll0lO;
	wire  nll0Oi;
	wire  nll10i;
	wire  nll10l;
	wire  nll10O;
	wire  nll11i;
	wire  nll11l;
	wire  nll11O;
	wire  nll1iO;
	wire  nlli0i;
	wire  nlli1i;
	wire  nlli1l;
	wire  nlliii;
	wire  nllili;
	wire  nllilO;
	wire  nlliOl;
	wire  nlliOO;
	wire  nlll0i;
	wire  nlll0l;
	wire  nlll1O;
	wire  nllllO;

	initial
		nll00l33 = 0;
	always @ ( posedge tx_clk)
		  nll00l33 <= nll00l34;
	event nll00l33_event;
	initial
		#1 ->nll00l33_event;
	always @(nll00l33_event)
		nll00l33 <= {1{1'b1}};
	initial
		nll00l34 = 0;
	always @ ( posedge tx_clk)
		  nll00l34 <= nll00l33;
	initial
		nll01i37 = 0;
	always @ ( posedge tx_clk)
		  nll01i37 <= nll01i38;
	event nll01i37_event;
	initial
		#1 ->nll01i37_event;
	always @(nll01i37_event)
		nll01i37 <= {1{1'b1}};
	initial
		nll01i38 = 0;
	always @ ( posedge tx_clk)
		  nll01i38 <= nll01i37;
	initial
		nll01O35 = 0;
	always @ ( posedge tx_clk)
		  nll01O35 <= nll01O36;
	event nll01O35_event;
	initial
		#1 ->nll01O35_event;
	always @(nll01O35_event)
		nll01O35 <= {1{1'b1}};
	initial
		nll01O36 = 0;
	always @ ( posedge tx_clk)
		  nll01O36 <= nll01O35;
	initial
		nll0ii31 = 0;
	always @ ( posedge tx_clk)
		  nll0ii31 <= nll0ii32;
	event nll0ii31_event;
	initial
		#1 ->nll0ii31_event;
	always @(nll0ii31_event)
		nll0ii31 <= {1{1'b1}};
	initial
		nll0ii32 = 0;
	always @ ( posedge tx_clk)
		  nll0ii32 <= nll0ii31;
	initial
		nll0iO29 = 0;
	always @ ( posedge tx_clk)
		  nll0iO29 <= nll0iO30;
	event nll0iO29_event;
	initial
		#1 ->nll0iO29_event;
	always @(nll0iO29_event)
		nll0iO29 <= {1{1'b1}};
	initial
		nll0iO30 = 0;
	always @ ( posedge tx_clk)
		  nll0iO30 <= nll0iO29;
	initial
		nll0Ol27 = 0;
	always @ ( posedge tx_clk)
		  nll0Ol27 <= nll0Ol28;
	event nll0Ol27_event;
	initial
		#1 ->nll0Ol27_event;
	always @(nll0Ol27_event)
		nll0Ol27 <= {1{1'b1}};
	initial
		nll0Ol28 = 0;
	always @ ( posedge tx_clk)
		  nll0Ol28 <= nll0Ol27;
	initial
		nll1ii45 = 0;
	always @ ( posedge tx_clk)
		  nll1ii45 <= nll1ii46;
	event nll1ii45_event;
	initial
		#1 ->nll1ii45_event;
	always @(nll1ii45_event)
		nll1ii45 <= {1{1'b1}};
	initial
		nll1ii46 = 0;
	always @ ( posedge tx_clk)
		  nll1ii46 <= nll1ii45;
	initial
		nll1li43 = 0;
	always @ ( posedge tx_clk)
		  nll1li43 <= nll1li44;
	event nll1li43_event;
	initial
		#1 ->nll1li43_event;
	always @(nll1li43_event)
		nll1li43 <= {1{1'b1}};
	initial
		nll1li44 = 0;
	always @ ( posedge tx_clk)
		  nll1li44 <= nll1li43;
	initial
		nll1lO41 = 0;
	always @ ( posedge tx_clk)
		  nll1lO41 <= nll1lO42;
	event nll1lO41_event;
	initial
		#1 ->nll1lO41_event;
	always @(nll1lO41_event)
		nll1lO41 <= {1{1'b1}};
	initial
		nll1lO42 = 0;
	always @ ( posedge tx_clk)
		  nll1lO42 <= nll1lO41;
	initial
		nll1Ol39 = 0;
	always @ ( posedge tx_clk)
		  nll1Ol39 <= nll1Ol40;
	event nll1Ol39_event;
	initial
		#1 ->nll1Ol39_event;
	always @(nll1Ol39_event)
		nll1Ol39 <= {1{1'b1}};
	initial
		nll1Ol40 = 0;
	always @ ( posedge tx_clk)
		  nll1Ol40 <= nll1Ol39;
	initial
		nlli0l23 = 0;
	always @ ( posedge tx_clk)
		  nlli0l23 <= nlli0l24;
	event nlli0l23_event;
	initial
		#1 ->nlli0l23_event;
	always @(nlli0l23_event)
		nlli0l23 <= {1{1'b1}};
	initial
		nlli0l24 = 0;
	always @ ( posedge tx_clk)
		  nlli0l24 <= nlli0l23;
	initial
		nlli1O25 = 0;
	always @ ( posedge tx_clk)
		  nlli1O25 <= nlli1O26;
	event nlli1O25_event;
	initial
		#1 ->nlli1O25_event;
	always @(nlli1O25_event)
		nlli1O25 <= {1{1'b1}};
	initial
		nlli1O26 = 0;
	always @ ( posedge tx_clk)
		  nlli1O26 <= nlli1O25;
	initial
		nlliil21 = 0;
	always @ ( posedge tx_clk)
		  nlliil21 <= nlliil22;
	event nlliil21_event;
	initial
		#1 ->nlliil21_event;
	always @(nlliil21_event)
		nlliil21 <= {1{1'b1}};
	initial
		nlliil22 = 0;
	always @ ( posedge tx_clk)
		  nlliil22 <= nlliil21;
	initial
		nlliiO19 = 0;
	always @ ( posedge tx_clk)
		  nlliiO19 <= nlliiO20;
	event nlliiO19_event;
	initial
		#1 ->nlliiO19_event;
	always @(nlliiO19_event)
		nlliiO19 <= {1{1'b1}};
	initial
		nlliiO20 = 0;
	always @ ( posedge tx_clk)
		  nlliiO20 <= nlliiO19;
	initial
		nllill17 = 0;
	always @ ( posedge tx_clk)
		  nllill17 <= nllill18;
	event nllill17_event;
	initial
		#1 ->nllill17_event;
	always @(nllill17_event)
		nllill17 <= {1{1'b1}};
	initial
		nllill18 = 0;
	always @ ( posedge tx_clk)
		  nllill18 <= nllill17;
	initial
		nlliOi15 = 0;
	always @ ( posedge tx_clk)
		  nlliOi15 <= nlliOi16;
	event nlliOi15_event;
	initial
		#1 ->nlliOi15_event;
	always @(nlliOi15_event)
		nlliOi15 <= {1{1'b1}};
	initial
		nlliOi16 = 0;
	always @ ( posedge tx_clk)
		  nlliOi16 <= nlliOi15;
	initial
		nlll0O11 = 0;
	always @ ( posedge tx_clk)
		  nlll0O11 <= nlll0O12;
	event nlll0O11_event;
	initial
		#1 ->nlll0O11_event;
	always @(nlll0O11_event)
		nlll0O11 <= {1{1'b1}};
	initial
		nlll0O12 = 0;
	always @ ( posedge tx_clk)
		  nlll0O12 <= nlll0O11;
	initial
		nlll1i13 = 0;
	always @ ( posedge tx_clk)
		  nlll1i13 <= nlll1i14;
	event nlll1i13_event;
	initial
		#1 ->nlll1i13_event;
	always @(nlll1i13_event)
		nlll1i13 <= {1{1'b1}};
	initial
		nlll1i14 = 0;
	always @ ( posedge tx_clk)
		  nlll1i14 <= nlll1i13;
	initial
		nlllil10 = 0;
	always @ ( posedge tx_clk)
		  nlllil10 <= nlllil9;
	initial
		nlllil9 = 0;
	always @ ( posedge tx_clk)
		  nlllil9 <= nlllil10;
	event nlllil9_event;
	initial
		#1 ->nlllil9_event;
	always @(nlllil9_event)
		nlllil9 <= {1{1'b1}};
	initial
		nllliO7 = 0;
	always @ ( posedge tx_clk)
		  nllliO7 <= nllliO8;
	event nllliO7_event;
	initial
		#1 ->nllliO7_event;
	always @(nllliO7_event)
		nllliO7 <= {1{1'b1}};
	initial
		nllliO8 = 0;
	always @ ( posedge tx_clk)
		  nllliO8 <= nllliO7;
	initial
		nlllli5 = 0;
	always @ ( posedge tx_clk)
		  nlllli5 <= nlllli6;
	event nlllli5_event;
	initial
		#1 ->nlllli5_event;
	always @(nlllli5_event)
		nlllli5 <= {1{1'b1}};
	initial
		nlllli6 = 0;
	always @ ( posedge tx_clk)
		  nlllli6 <= nlllli5;
	initial
		nlllll3 = 0;
	always @ ( posedge tx_clk)
		  nlllll3 <= nlllll4;
	event nlllll3_event;
	initial
		#1 ->nlllll3_event;
	always @(nlllll3_event)
		nlllll3 <= {1{1'b1}};
	initial
		nlllll4 = 0;
	always @ ( posedge tx_clk)
		  nlllll4 <= nlllll3;
	initial
		nlllOl1 = 0;
	always @ ( posedge tx_clk)
		  nlllOl1 <= nlllOl2;
	event nlllOl1_event;
	initial
		#1 ->nlllOl1_event;
	always @(nlllOl1_event)
		nlllOl1 <= {1{1'b1}};
	initial
		nlllOl2 = 0;
	always @ ( posedge tx_clk)
		  nlllOl2 <= nlllOl1;
	initial
	begin
		ni0O = 0;
		nlO0Ol = 0;
		nlO0OO = 0;
		nlOi0i = 0;
		nlOi0l = 0;
		nlOi0O = 0;
		nlOi1i = 0;
		nlOi1l = 0;
		nlOi1O = 0;
		nlOiii = 0;
		nlOiil = 0;
		nlOiiO = 0;
		nlOili = 0;
		nlOill = 0;
		nlOilO = 0;
		nlOiOi = 0;
		nlOiOl = 0;
		nlOiOO = 0;
		nlOl1i = 0;
		nlOl1l = 0;
		nlOl1O = 0;
	end
	always @ (tx_clk or wire_ni0l_PRN or soft_reset)
	begin
		if (wire_ni0l_PRN == 1'b0) 
		begin
			ni0O <= 1;
			nlO0Ol <= 1;
			nlO0OO <= 1;
			nlOi0i <= 1;
			nlOi0l <= 1;
			nlOi0O <= 1;
			nlOi1i <= 1;
			nlOi1l <= 1;
			nlOi1O <= 1;
			nlOiii <= 1;
			nlOiil <= 1;
			nlOiiO <= 1;
			nlOili <= 1;
			nlOill <= 1;
			nlOilO <= 1;
			nlOiOi <= 1;
			nlOiOl <= 1;
			nlOiOO <= 1;
			nlOl1i <= 1;
			nlOl1l <= 1;
			nlOl1O <= 1;
		end
		else if  (soft_reset == 1'b1) 
		begin
			ni0O <= 0;
			nlO0Ol <= 0;
			nlO0OO <= 0;
			nlOi0i <= 0;
			nlOi0l <= 0;
			nlOi0O <= 0;
			nlOi1i <= 0;
			nlOi1l <= 0;
			nlOi1O <= 0;
			nlOiii <= 0;
			nlOiil <= 0;
			nlOiiO <= 0;
			nlOili <= 0;
			nlOill <= 0;
			nlOilO <= 0;
			nlOiOi <= 0;
			nlOiOl <= 0;
			nlOiOO <= 0;
			nlOl1i <= 0;
			nlOl1l <= 0;
			nlOl1O <= 0;
		end
		else if  (nlliii == 1'b0) 
		if (tx_clk != ni0l_clk_prev && tx_clk == 1'b1) 
		begin
			ni0O <= wire_n100O_dataout;
			nlO0Ol <= wire_n10ii_dataout;
			nlO0OO <= wire_n10il_dataout;
			nlOi0i <= wire_n10lO_dataout;
			nlOi0l <= wire_n10Oi_dataout;
			nlOi0O <= wire_n10Ol_dataout;
			nlOi1i <= wire_n10iO_dataout;
			nlOi1l <= wire_n10li_dataout;
			nlOi1O <= wire_n10ll_dataout;
			nlOiii <= wire_n10OO_dataout;
			nlOiil <= wire_n1i1i_dataout;
			nlOiiO <= wire_n1i1l_dataout;
			nlOili <= wire_n1i1O_dataout;
			nlOill <= wire_n1i0i_dataout;
			nlOilO <= wire_n1i0l_dataout;
			nlOiOi <= wire_n1i0O_dataout;
			nlOiOl <= wire_n1iii_dataout;
			nlOiOO <= wire_n1iil_dataout;
			nlOl1i <= wire_n1iiO_dataout;
			nlOl1l <= wire_n1ili_dataout;
			nlOl1O <= wire_n1ill_dataout;
		end
		ni0l_clk_prev <= tx_clk;
	end
	assign
		wire_ni0l_PRN = (nlli1O26 ^ nlli1O25);
	initial
	begin
		n0i = 0;
		n1i = 0;
		n1l = 0;
		n1O = 0;
		nili = 0;
		nill = 0;
		nlll = 0;
		nllO = 0;
		nlOi = 0;
		nlOl = 0;
		nlOl0i = 0;
		nlOl0l = 0;
		nlOl0O = 0;
		nlOlii = 0;
		nlOlil = 0;
		nlOliO = 0;
		nlOlli = 0;
		nlOlll = 0;
		nlOllO = 0;
		nlOlOi = 0;
		nlOlOl = 0;
		nlOlOO = 0;
		nlOO = 0;
		nlOO0i = 0;
		nlOO0l = 0;
		nlOO0O = 0;
		nlOO1i = 0;
		nlOO1l = 0;
		nlOO1O = 0;
		nlOOii = 0;
		nlOOil = 0;
		nlOOiO = 0;
		nlOOli = 0;
		nlOOll = 0;
		nlOOlO = 0;
		nO = 0;
	end
	always @ ( posedge tx_clk or  negedge wire_nl_CLRN)
	begin
		if (wire_nl_CLRN == 1'b0) 
		begin
			n0i <= 0;
			n1i <= 0;
			n1l <= 0;
			n1O <= 0;
			nili <= 0;
			nill <= 0;
			nlll <= 0;
			nllO <= 0;
			nlOi <= 0;
			nlOl <= 0;
			nlOl0i <= 0;
			nlOl0l <= 0;
			nlOl0O <= 0;
			nlOlii <= 0;
			nlOlil <= 0;
			nlOliO <= 0;
			nlOlli <= 0;
			nlOlll <= 0;
			nlOllO <= 0;
			nlOlOi <= 0;
			nlOlOl <= 0;
			nlOlOO <= 0;
			nlOO <= 0;
			nlOO0i <= 0;
			nlOO0l <= 0;
			nlOO0O <= 0;
			nlOO1i <= 0;
			nlOO1l <= 0;
			nlOO1O <= 0;
			nlOOii <= 0;
			nlOOil <= 0;
			nlOOiO <= 0;
			nlOOli <= 0;
			nlOOll <= 0;
			nlOOlO <= 0;
			nO <= 0;
		end
		else 
		begin
			n0i <= nO;
			n1i <= wire_nli_dataout;
			n1l <= wire_nll_dataout;
			n1O <= wire_nlO_dataout;
			nili <= nill;
			nill <= rprbs_en_tx;
			nlll <= wire_n0l_dataout;
			nllO <= wire_n0O_dataout;
			nlOi <= wire_nii_dataout;
			nlOl <= wire_nil_dataout;
			nlOl0i <= wire_nlOOOi_dataout;
			nlOl0l <= wire_nlOOOl_dataout;
			nlOl0O <= wire_nlOOOO_dataout;
			nlOlii <= wire_n111i_dataout;
			nlOlil <= wire_n111l_dataout;
			nlOliO <= wire_n111O_dataout;
			nlOlli <= wire_n110i_dataout;
			nlOlll <= wire_n110l_dataout;
			nlOllO <= wire_n110O_dataout;
			nlOlOi <= wire_n11ii_dataout;
			nlOlOl <= wire_n11il_dataout;
			nlOlOO <= wire_n11iO_dataout;
			nlOO <= wire_niO_dataout;
			nlOO0i <= wire_n11Oi_dataout;
			nlOO0l <= wire_n11Ol_dataout;
			nlOO0O <= wire_n11OO_dataout;
			nlOO1i <= wire_n11li_dataout;
			nlOO1l <= wire_n11ll_dataout;
			nlOO1O <= wire_n11lO_dataout;
			nlOOii <= wire_n101i_dataout;
			nlOOil <= wire_n101l_dataout;
			nlOOiO <= wire_n101O_dataout;
			nlOOli <= wire_n100i_dataout;
			nlOOll <= wire_n100l_dataout;
			nlOOlO <= nili;
			nO <= cid_en;
		end
	end
	assign
		wire_nl_CLRN = ((nlllOl2 ^ nlllOl1) & (~ soft_reset));
	initial
	begin
		nilO = 0;
		nlil = 0;
	end
	always @ ( posedge tx_clk or  posedge soft_reset)
	begin
		if (soft_reset == 1'b1) 
		begin
			nilO <= 0;
			nlil <= 0;
		end
		else if  (nlll0l == 1'b1) 
		begin
			nilO <= wire_niOO_o;
			nlil <= wire_nl1i_o;
		end
	end
	initial
	begin
		nlli = 0;
	end
	always @ ( posedge tx_clk or  negedge wire_nliO_PRN)
	begin
		if (wire_nliO_PRN == 1'b0) 
		begin
			nlli <= 1;
		end
		else if  (nlll0l == 1'b1) 
		begin
			nlli <= wire_nl1l_o;
		end
	end
	assign
		wire_nliO_PRN = ((nlll0O12 ^ nlll0O11) & (~ soft_reset));
	assign		wire_n0l_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[1] : rcid_len[0];
	assign		wire_n0O_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[2] : rcid_len[1];
	assign		wire_n100i_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1O1O_dataout;
	assign		wire_n100l_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1O0i_dataout;
	assign		wire_n100O_dataout = (nlOOlO === 1'b1) ? wire_n1O0l_dataout : ni0O;
	assign		wire_n101i_dataout = (nlliii === 1'b1) ? (~ (wire_n00ii_o[16] | wire_n00ii_o[2])) : wire_n1lOO_dataout;
	assign		wire_n101l_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1O1i_dataout;
	assign		wire_n101O_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1O1l_dataout;
	and(wire_n10i_dataout, nlOO0i, nlli1l);
	assign		wire_n10ii_dataout = (nlOOlO === 1'b1) ? wire_n1O0O_o : nlO0Ol;
	assign		wire_n10il_dataout = (nlOOlO === 1'b1) ? wire_n1Oii_o : nlO0OO;
	assign		wire_n10iO_dataout = (nlOOlO === 1'b1) ? wire_n1Oil_o : nlOi1i;
	and(wire_n10l_dataout, nlOO0l, nlli1l);
	assign		wire_n10li_dataout = (nlOOlO === 1'b1) ? wire_n1OiO_o : nlOi1l;
	assign		wire_n10ll_dataout = (nlOOlO === 1'b1) ? wire_n1Oli_o : nlOi1O;
	assign		wire_n10lO_dataout = (nlOOlO === 1'b1) ? wire_n1Oll_o : nlOi0i;
	and(wire_n10O_dataout, nlOO0O, nlli1l);
	assign		wire_n10Oi_dataout = (nlOOlO === 1'b1) ? wire_n1OlO_o : nlOi0l;
	assign		wire_n10Ol_dataout = (nlOOlO === 1'b1) ? wire_n1OOi_o : nlOi0O;
	assign		wire_n10OO_dataout = (nlOOlO === 1'b1) ? wire_n011i_o : nlOiii;
	or(wire_n110i_dataout, wire_n1l1O_dataout, nlliii);
	assign		wire_n110l_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1l0i_dataout;
	assign		wire_n110O_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1l0l_dataout;
	assign		wire_n111i_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1iOO_dataout;
	assign		wire_n111l_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1l1i_dataout;
	assign		wire_n111O_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1l1l_dataout;
	and(wire_n11i_dataout, nlOO1i, nlli1l);
	assign		wire_n11ii_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1l0O_dataout;
	assign		wire_n11il_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1lii_dataout;
	assign		wire_n11iO_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1lil_dataout;
	and(wire_n11l_dataout, nlOO1l, nlli1l);
	assign		wire_n11li_dataout = (nlliii === 1'b1) ? (~ wire_n00ii_o[2]) : wire_n1liO_dataout;
	assign		wire_n11ll_dataout = (nlliii === 1'b1) ? (~ wire_n00ii_o[2]) : wire_n1lli_dataout;
	assign		wire_n11lO_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1lll_dataout;
	and(wire_n11O_dataout, nlOO1O, nlli1l);
	assign		wire_n11Oi_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1llO_dataout;
	assign		wire_n11Ol_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1lOi_dataout;
	assign		wire_n11OO_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1lOl_dataout;
	assign		wire_n1i0i_dataout = (nlOOlO === 1'b1) ? wire_n010O_o : nlOill;
	assign		wire_n1i0l_dataout = (nlOOlO === 1'b1) ? wire_n01iO_o : nlOilO;
	assign		wire_n1i0O_dataout = (nlOOlO === 1'b1) ? wire_n01ll_o : nlOiOi;
	assign		wire_n1i1i_dataout = (nlOOlO === 1'b1) ? wire_n011l_o : nlOiil;
	assign		wire_n1i1l_dataout = (nlOOlO === 1'b1) ? wire_n011O_o : nlOiiO;
	assign		wire_n1i1O_dataout = (nlOOlO === 1'b1) ? wire_n010i_o : nlOili;
	and(wire_n1ii_dataout, nlOOii, nlli1l);
	assign		wire_n1iii_dataout = (nlOOlO === 1'b1) ? wire_n01lO_o : nlOiOl;
	assign		wire_n1iil_dataout = (nlOOlO === 1'b1) ? wire_n01Oi_o : nlOiOO;
	assign		wire_n1iiO_dataout = (nlOOlO === 1'b1) ? wire_n01Ol_o : nlOl1i;
	and(wire_n1il_dataout, nlOOil, nlli1l);
	assign		wire_n1ili_dataout = (nlOOlO === 1'b1) ? wire_n001O_o : nlOl1l;
	assign		wire_n1ill_dataout = (nlOOlO === 1'b1) ? wire_n000i_o : nlOl1O;
	assign		wire_n1ilO_dataout = (nlOOlO === 1'b1) ? wire_n00il_o : nlOl0i;
	and(wire_n1iO_dataout, nlOOiO, nlli1l);
	assign		wire_n1iOi_dataout = (nlOOlO === 1'b1) ? wire_n00iO_o : nlOl0l;
	assign		wire_n1iOl_dataout = (nlOOlO === 1'b1) ? wire_n00li_o : nlOl0O;
	assign		wire_n1iOO_dataout = (nlOOlO === 1'b1) ? wire_n00ll_o : nlOlii;
	assign		wire_n1l0i_dataout = (nlOOlO === 1'b1) ? wire_n00OO_o : nlOlll;
	assign		wire_n1l0l_dataout = (nlOOlO === 1'b1) ? wire_n0i1i_o : nlOllO;
	assign		wire_n1l0O_dataout = (nlOOlO === 1'b1) ? wire_n0i1l_o : nlOlOi;
	assign		wire_n1l1i_dataout = (nlOOlO === 1'b1) ? wire_n00lO_o : nlOlil;
	assign		wire_n1l1l_dataout = (nlOOlO === 1'b1) ? wire_n00Oi_o : nlOliO;
	assign		wire_n1l1O_dataout = (nlOOlO === 1'b1) ? wire_n00Ol_o : nlOlli;
	and(wire_n1li_dataout, nlOOli, nlli1l);
	assign		wire_n1lii_dataout = (nlOOlO === 1'b1) ? wire_n0i1O_o : nlOlOl;
	assign		wire_n1lil_dataout = (nlOOlO === 1'b1) ? wire_n0i0i_o : nlOlOO;
	assign		wire_n1liO_dataout = (nlOOlO === 1'b1) ? wire_n0i0l_o : nlOO1i;
	and(wire_n1ll_dataout, nlOOll, nlli1l);
	assign		wire_n1lli_dataout = (nlOOlO === 1'b1) ? wire_n0i0O_o : nlOO1l;
	assign		wire_n1lll_dataout = (nlOOlO === 1'b1) ? wire_n0iii_o : nlOO1O;
	assign		wire_n1llO_dataout = (nlOOlO === 1'b1) ? wire_n0iil_o : nlOO0i;
	assign		wire_n1lOi_dataout = (nlOOlO === 1'b1) ? wire_n0iiO_o : nlOO0l;
	assign		wire_n1lOl_dataout = (nlOOlO === 1'b1) ? wire_n0ili_o : nlOO0O;
	assign		wire_n1lOO_dataout = (nlOOlO === 1'b1) ? wire_n0ill_o : nlOOii;
	assign		wire_n1O0i_dataout = (nlOOlO === 1'b1) ? wire_n0iOO_o : nlOOll;
	assign		wire_n1O0l_dataout = (wire_n00ii_o[11] === 1'b1) ? (~ ni0O) : ni0O;
	assign		wire_n1O1i_dataout = (nlOOlO === 1'b1) ? wire_n0ilO_o : nlOOil;
	assign		wire_n1O1l_dataout = (nlOOlO === 1'b1) ? wire_n0iOi_o : nlOOiO;
	assign		wire_n1O1O_dataout = (nlOOlO === 1'b1) ? wire_n0iOl_o : nlOOli;
	assign		wire_nii_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[3] : rcid_len[2];
	or(wire_niiil_dataout, wire_niO1i_dataout, (~ ni0O));
	or(wire_niiiO_dataout, wire_niO1l_dataout, (~ ni0O));
	or(wire_niili_dataout, wire_niO1O_dataout, (~ ni0O));
	or(wire_niill_dataout, wire_niO0i_dataout, (~ ni0O));
	or(wire_niilO_dataout, wire_niO0l_dataout, (~ ni0O));
	and(wire_niiOi_dataout, wire_niO0O_dataout, ~((~ ni0O)));
	or(wire_niiOl_dataout, wire_niOii_dataout, (~ ni0O));
	and(wire_niiOO_dataout, wire_niOil_dataout, ~((~ ni0O)));
	assign		wire_nil_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[4] : rcid_len[3];
	and(wire_nil0i_dataout, wire_niOlO_dataout, ~((~ ni0O)));
	and(wire_nil0l_dataout, wire_niOOi_dataout, ~((~ ni0O)));
	and(wire_nil0O_dataout, wire_niOOl_dataout, ~((~ ni0O)));
	or(wire_nil1i_dataout, wire_niOiO_dataout, (~ ni0O));
	or(wire_nil1l_dataout, wire_niOli_dataout, (~ ni0O));
	and(wire_nil1O_dataout, wire_niOll_dataout, ~((~ ni0O)));
	and(wire_nilii_dataout, wire_niOOO_dataout, ~((~ ni0O)));
	and(wire_nilil_dataout, wire_nl11i_dataout, ~((~ ni0O)));
	and(wire_niliO_dataout, wire_nl11l_dataout, ~((~ ni0O)));
	and(wire_nilli_dataout, wire_nl11O_dataout, ~((~ ni0O)));
	and(wire_nilll_dataout, wire_nl10i_dataout, ~((~ ni0O)));
	and(wire_nillO_dataout, wire_nl10l_dataout, ~((~ ni0O)));
	and(wire_nilOi_dataout, wire_nl10O_dataout, ~((~ ni0O)));
	and(wire_nilOl_dataout, wire_nl1ii_dataout, ~((~ ni0O)));
	and(wire_nilOO_dataout, wire_nl1il_dataout, ~((~ ni0O)));
	assign		wire_niO_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[5] : rcid_len[4];
	and(wire_niO0i_dataout, nlOlii, ~(ni0O));
	and(wire_niO0l_dataout, nlOlil, ~(ni0O));
	or(wire_niO0O_dataout, nlOliO, ni0O);
	and(wire_niO1i_dataout, nlOl0i, ~(ni0O));
	and(wire_niO1l_dataout, nlOl0l, ~(ni0O));
	and(wire_niO1O_dataout, nlOl0O, ~(ni0O));
	and(wire_niOi_dataout, nlil, nlll0l);
	and(wire_niOii_dataout, nlOlli, ~(ni0O));
	or(wire_niOil_dataout, nlOlll, ni0O);
	and(wire_niOiO_dataout, nlOllO, ~(ni0O));
	and(wire_niOl_dataout, nlli, nlll0l);
	and(wire_niOli_dataout, nlOlOi, ~(ni0O));
	and(wire_niOll_dataout, nlOlOl, ~(ni0O));
	and(wire_niOlO_dataout, nlOlOO, ~(ni0O));
	and(wire_niOOi_dataout, nlOO1i, ~(ni0O));
	and(wire_niOOl_dataout, nlOO1l, ~(ni0O));
	and(wire_niOOO_dataout, nlOO1O, ~(ni0O));
	and(wire_nl0i_dataout, nlliOl, ~(nlliOO));
	and(wire_nl0iO_dataout, wire_nliOl_dataout, ~(wire_niOl_dataout));
	or(wire_nl0li_dataout, wire_nliOO_dataout, wire_niOl_dataout);
	and(wire_nl0ll_dataout, wire_nll1i_dataout, ~(wire_niOl_dataout));
	or(wire_nl0lO_dataout, wire_nll1l_dataout, wire_niOl_dataout);
	or(wire_nl0Oi_dataout, wire_nll1O_dataout, wire_niOl_dataout);
	and(wire_nl0Ol_dataout, wire_nll0i_dataout, ~(wire_niOl_dataout));
	or(wire_nl0OO_dataout, wire_nll0l_dataout, wire_niOl_dataout);
	and(wire_nl10i_dataout, nlOOii, ~(ni0O));
	and(wire_nl10l_dataout, nlOOil, ~(ni0O));
	and(wire_nl10O_dataout, nlOOiO, ~(ni0O));
	and(wire_nl11i_dataout, nlOO0i, ~(ni0O));
	and(wire_nl11l_dataout, nlOO0l, ~(ni0O));
	and(wire_nl11O_dataout, nlOO0O, ~(ni0O));
	and(wire_nl1ii_dataout, nlOOli, ~(ni0O));
	and(wire_nl1il_dataout, nlOOll, ~(ni0O));
	and(wire_nl1O_dataout, (~ nlliOl), ~(nlliOO));
	assign		wire_nli_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[6] : rcid_len[5];
	and(wire_nli0i_dataout, wire_nlliO_dataout, ~(wire_niOl_dataout));
	and(wire_nli0l_dataout, wire_nllli_dataout, ~(wire_niOl_dataout));
	and(wire_nli0O_dataout, wire_nllll_dataout, ~(wire_niOl_dataout));
	and(wire_nli1i_dataout, wire_nll0O_dataout, ~(wire_niOl_dataout));
	and(wire_nli1l_dataout, wire_nllii_dataout, ~(wire_niOl_dataout));
	and(wire_nli1O_dataout, wire_nllil_dataout, ~(wire_niOl_dataout));
	and(wire_nliii_dataout, wire_nlllO_dataout, ~(wire_niOl_dataout));
	and(wire_nliil_dataout, wire_nllOi_dataout, ~(wire_niOl_dataout));
	and(wire_nliiO_dataout, wire_nllOl_dataout, ~(wire_niOl_dataout));
	and(wire_nlili_dataout, wire_nllOO_dataout, ~(wire_niOl_dataout));
	and(wire_nlill_dataout, wire_nlO1i_dataout, ~(wire_niOl_dataout));
	and(wire_nlilO_dataout, wire_nlO1l_dataout, ~(wire_niOl_dataout));
	and(wire_nliOi_dataout, wire_nlO1O_dataout, ~(wire_niOl_dataout));
	assign		wire_nliOl_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOl0i;
	assign		wire_nliOO_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOl0l;
	assign		wire_nll_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[7] : rcid_len[6];
	assign		wire_nll0i_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOliO;
	assign		wire_nll0l_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOlli;
	assign		wire_nll0O_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOlll;
	assign		wire_nll1i_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOl0O;
	assign		wire_nll1l_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOlii;
	assign		wire_nll1O_dataout = (wire_niOi_dataout === 1'b1) ? rcid_pattern : nlOlil;
	and(wire_nllii_dataout, nlOllO, ~(wire_niOi_dataout));
	and(wire_nllil_dataout, nlOlOi, ~(wire_niOi_dataout));
	and(wire_nlliO_dataout, nlOlOl, ~(wire_niOi_dataout));
	and(wire_nllli_dataout, nlOlOO, ~(wire_niOi_dataout));
	and(wire_nllll_dataout, nlOO1i, ~(wire_niOi_dataout));
	and(wire_nlllO_dataout, nlOO1l, ~(wire_niOi_dataout));
	and(wire_nllOi_dataout, nlOO1O, ~(wire_niOi_dataout));
	and(wire_nllOl_dataout, nlOO0i, ~(wire_niOi_dataout));
	and(wire_nllOO_dataout, nlOO0l, ~(wire_niOi_dataout));
	assign		wire_nlO_dataout = (wire_niOi_dataout === 1'b1) ? wire_ni_o[8] : rcid_len[7];
	assign		wire_nlO0i_dataout = (nlli1l === 1'b1) ? nlOl0i : ((nll0Oi ^ nlOl0l) ^ nlOl0i);
	assign		wire_nlO0l_dataout = (nlli1l === 1'b1) ? nlOl0l : ((nlli1i ^ nlOl0O) ^ nlOl0l);
	assign		wire_nlO0O_dataout = (nlli1l === 1'b1) ? nlOl0O : ((((((((nlli1i ^ nlOliO) ^ (~ (nll01i38 ^ nll01i37))) ^ nlOlii) ^ (~ (nll1Ol40 ^ nll1Ol39))) ^ nlOl0O) ^ nlOl0l) ^ nlOl0i) ^ (~ (nll1lO42 ^ nll1lO41)));
	and(wire_nlO1i_dataout, nlOO0O, ~(wire_niOi_dataout));
	and(wire_nlO1l_dataout, nlOOii, ~(wire_niOi_dataout));
	and(wire_nlO1O_dataout, nlOOil, ~(wire_niOi_dataout));
	assign		wire_nlOii_dataout = (nlli1l === 1'b1) ? nlOlii : (((((((nlOlll ^ nlOliO) ^ nlOlil) ^ nlOlii) ^ (~ (nll00l34 ^ nll00l33))) ^ nlOl0O) ^ nlOl0i) ^ (~ (nll01O36 ^ nll01O35)));
	assign		wire_nlOil_dataout = (nlli1l === 1'b1) ? nlOlil : (nll0ll ^ nlOl0i);
	assign		wire_nlOiO_dataout = (nlli1l === 1'b1) ? nlOliO : (nll0lO ^ nlOl0l);
	assign		wire_nlOli_dataout = (nlli1l === 1'b1) ? nlOlli : ((nll0Oi ^ nlOl0O) ^ (~ (nll0ii32 ^ nll0ii31)));
	assign		wire_nlOll_dataout = (nlli1l === 1'b1) ? nlOlll : ((nlli1i ^ nlOlii) ^ (~ (nll0iO30 ^ nll0iO29)));
	and(wire_nlOlO_dataout, nlOllO, nlli1l);
	and(wire_nlOOi_dataout, nlOlOi, nlli1l);
	and(wire_nlOOl_dataout, nlOlOl, nlli1l);
	and(wire_nlOOO_dataout, nlOlOO, nlli1l);
	assign		wire_nlOOOi_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1ilO_dataout;
	assign		wire_nlOOOl_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1iOi_dataout;
	assign		wire_nlOOOO_dataout = (nlliii === 1'b1) ? (~ nlli0i) : wire_n1iOl_dataout;
	oper_add   ni
	( 
	.a({((nlllil10 ^ nlllil9) & n1O), ((nllliO8 ^ nllliO7) & n1l), n1i, nlOO, ((nlllli6 ^ nlllli5) & nlOl), nlOi, nllO, ((nlllll4 ^ nlllll3) & nlll), 1'b1}),
	.b({{7{1'b1}}, 1'b0, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_ni_o));
	defparam
		ni.sgate_representation = 0,
		ni.width_a = 9,
		ni.width_b = 9,
		ni.width_o = 9;
	oper_decoder   n00ii
	( 
	.i({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}),
	.o(wire_n00ii_o));
	defparam
		n00ii.width_i = 5,
		n00ii.width_o = 32;
	oper_mux   n00il
	( 
	.data({{3{1'b0}}, {3{1'b1}}, ((nlOO0l ^ nlOlii) ^ nlOOli), nliOOO, {5{1'b0}}, 1'b1, nliliO, (nlOlOl ^ nlOlOi), {4{1'b0}}, wire_niiil_dataout, {2{1'b1}}, nll1iO, {3{1'b0}}, nliO1l, 1'b0, (nlOl0O ^ nlOl0l), 1'b1, wire_nlO0i_dataout}),
	.o(wire_n00il_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00il.width_data = 32,
		n00il.width_sel = 5;
	oper_mux   n00iO
	( 
	.data({{3{1'b0}}, {2{1'b1}}, 1'b0, ((nlOO0O ^ nlOlil) ^ nlOOll), nll11i, {6{1'b0}}, nlilli, (nlOlOO ^ nlOlOl), {4{1'b0}}, wire_niiiO_dataout, 1'b1, 1'b0, nll10O, {3{1'b0}}, nliO1O, 1'b0, (nlOlii ^ nlOl0O), 1'b0, wire_nlO0l_dataout}),
	.o(wire_n00iO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00iO.width_data = 32,
		n00iO.width_sel = 5;
	oper_mux   n00li
	( 
	.data({{3{1'b0}}, {3{1'b1}}, (nlOliO ^ nlOl0i), nliOli, {5{1'b0}}, 1'b1, nlilll, nll11O, {4{1'b0}}, wire_niili_dataout, {2{1'b1}}, nll10l, {3{1'b0}}, nliO0i, 1'b0, nll0ll, 1'b1, wire_nlO0O_dataout}),
	.o(wire_n00li_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00li.width_data = 32,
		n00li.width_sel = 5;
	oper_mux   n00ll
	( 
	.data({{3{1'b0}}, {2{1'b1}}, 1'b0, (nlOlli ^ nlOl0l), nliOll, {6{1'b0}}, nlillO, nll10i, {4{1'b0}}, wire_niill_dataout, 1'b1, 1'b0, (nlOlli ^ nlOlii), {3{1'b0}}, nliO0l, 1'b0, nll0lO, 1'b0, wire_nlOii_dataout}),
	.o(wire_n00ll_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00ll.width_data = 32,
		n00ll.width_sel = 5;
	oper_mux   n00lO
	( 
	.data({{3{1'b0}}, {3{1'b1}}, nliliO, nliOlO, {5{1'b0}}, 1'b1, nlilOi, nliOOO, {4{1'b0}}, wire_niilO_dataout, {2{1'b1}}, (nlOlll ^ nlOlil), {3{1'b0}}, nliO0O, 1'b0, nll0Oi, 1'b1, wire_nlOil_dataout}),
	.o(wire_n00lO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00lO.width_data = 32,
		n00lO.width_sel = 5;
	oper_mux   n00Oi
	( 
	.data({{6{1'b0}}, nlilli, nliOOl, {6{1'b0}}, nlilOl, nll11i, {4{1'b0}}, wire_niiOi_dataout, {2{1'b0}}, (nlOllO ^ nlOliO), {3{1'b0}}, nliOii, 1'b0, nlli1i, 1'b0, wire_nlOiO_dataout}),
	.o(wire_n00Oi_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00Oi.width_data = 32,
		n00Oi.width_sel = 5;
	oper_mux   n00Ol
	( 
	.data({{3{1'b0}}, 1'b1, 1'b0, 1'b1, nlilll, (nliO0O ^ nlOO1l), {5{1'b0}}, 1'b1, nlilOO, (nliO1l ^ nlOlOi), {4{1'b0}}, wire_niiOl_dataout, 1'b0, 1'b1, (nlOlOi ^ nlOlli), {3{1'b0}}, nliOil, 1'b0, ((nlOlll ^ nlOl0l) ^ nlOl0O), 1'b1, wire_nlOli_dataout}),
	.o(wire_n00Ol_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00Ol.width_data = 32,
		n00Ol.width_sel = 5;
	oper_mux   n00OO
	( 
	.data({{6{1'b0}}, nlillO, nll11l, {6{1'b0}}, nliO1i, (nlOlOO ^ nlOlOi), {4{1'b0}}, wire_niiOO_dataout, {2{1'b0}}, (nll1iO ^ nlOlll), {3{1'b0}}, nliOiO, 1'b0, (nlOlii ^ nlOl0l), 1'b0, wire_nlOll_dataout}),
	.o(wire_n00OO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n00OO.width_data = 32,
		n00OO.width_sel = 5;
	oper_mux   n0i0i
	( 
	.data({{4{1'b0}}, 1'b1, 1'b0, nliO1i, (nlOOil ^ nlOO0O), {6{1'b0}}, nliO0l, nll11l, {4{1'b0}}, wire_nil0i_dataout, {6{1'b0}}, nlOlii, {3{1'b0}}, wire_nlOOO_dataout}),
	.o(wire_n0i0i_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i0i.width_data = 32,
		n0i0i.width_sel = 5;
	oper_mux   n0i0l
	( 
	.data({{4{1'b0}}, {2{1'b1}}, nliO1l, ((nlOOii ^ nlOO1O) ^ nlOO1l), {5{1'b0}}, 1'b1, nliO0O, ((nlOO1O ^ nlOlOl) ^ nlOlOi), {4{1'b0}}, wire_nil0l_dataout, {6{1'b0}}, nlOlil, {3{1'b0}}, wire_n11i_dataout}),
	.o(wire_n0i0l_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i0l.width_data = 32,
		n0i0l.width_sel = 5;
	oper_mux   n0i0O
	( 
	.data({{4{1'b0}}, 1'b1, 1'b0, nliO1O, ((nlOOil ^ nlOO0i) ^ nlOO1O), {6{1'b0}}, nliOii, ((nlOO0i ^ nlOlOO) ^ nlOlOl), {4{1'b0}}, wire_nil0O_dataout, {6{1'b0}}, nlOliO, {3{1'b0}}, wire_n11l_dataout}),
	.o(wire_n0i0O_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i0O.width_data = 32,
		n0i0O.width_sel = 5;
	oper_mux   n0i1i
	( 
	.data({{3{1'b0}}, 1'b1, 1'b0, 1'b1, nlilOi, (nlOO0l ^ nlOO1O), {5{1'b0}}, 1'b1, nliO1l, (nlOO1i ^ nlOlOl), {4{1'b0}}, wire_nil1i_dataout, 1'b0, 1'b1, (nll10O ^ nlOllO), {3{1'b0}}, nlOl0i, {3{1'b0}}, wire_nlOlO_dataout}),
	.o(wire_n0i1i_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i1i.width_data = 32,
		n0i1i.width_sel = 5;
	oper_mux   n0i1l
	( 
	.data({{3{1'b0}}, 1'b1, {2{1'b0}}, nlilOl, (nlOO0O ^ nlOO0i), {6{1'b0}}, nliO1O, (nlOO1l ^ nlOlOO), {4{1'b0}}, wire_nil1l_dataout, {2{1'b0}}, (nll10l ^ nlOlOi), {3{1'b0}}, nlOl0l, {3{1'b0}}, wire_nlOOi_dataout}),
	.o(wire_n0i1l_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i1l.width_data = 32,
		n0i1l.width_sel = 5;
	oper_mux   n0i1O
	( 
	.data({{4{1'b0}}, {2{1'b1}}, nlilOO, (nlOOii ^ nlOO0l), {5{1'b0}}, 1'b1, nliO0i, (nlOO1O ^ nlOO1i), {4{1'b0}}, wire_nil1O_dataout, {6{1'b0}}, nlOl0O, {3{1'b0}}, wire_nlOOl_dataout}),
	.o(wire_n0i1O_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0i1O.width_data = 32,
		n0i1O.width_sel = 5;
	oper_mux   n0iii
	( 
	.data({{4{1'b0}}, {2{1'b1}}, nliO0i, ((nliOli ^ nlOO1O) ^ nlOO1l), {5{1'b0}}, 1'b1, nliOil, ((nll11O ^ nlOlOl) ^ nlOlOi), {4{1'b0}}, wire_nilii_dataout, {6{1'b0}}, nlOlli, {3{1'b0}}, wire_n11O_dataout}),
	.o(wire_n0iii_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iii.width_data = 32,
		n0iii.width_sel = 5;
	oper_mux   n0iil
	( 
	.data({{3{1'b0}}, 1'b1, {2{1'b0}}, nliO0l, ((nliOll ^ nlOO0i) ^ nlOO1O), {6{1'b0}}, nliOiO, ((nll10i ^ nlOlOO) ^ nlOlOl), {4{1'b0}}, wire_nilil_dataout, {6{1'b0}}, nlOlll, {3{1'b0}}, wire_n10i_dataout}),
	.o(wire_n0iil_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iil.width_data = 32,
		n0iil.width_sel = 5;
	oper_mux   n0iiO
	( 
	.data({{5{1'b0}}, 1'b1, nliO0O, ((nliOlO ^ nlOO0l) ^ nlOO0i), {6{1'b0}}, nlOl0i, {5{1'b0}}, wire_niliO_dataout, {6{1'b0}}, nlOllO, {3{1'b0}}, wire_n10l_dataout}),
	.o(wire_n0iiO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iiO.width_data = 32,
		n0iiO.width_sel = 5;
	oper_mux   n0ili
	( 
	.data({{3{1'b0}}, 1'b1, {2{1'b0}}, nliOii, (nliOOi ^ nlOO0l), {6{1'b0}}, nlOl0l, {5{1'b0}}, wire_nilli_dataout, {6{1'b0}}, nlOlOi, {3{1'b0}}, wire_n10O_dataout}),
	.o(wire_n0ili_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0ili.width_data = 32,
		n0ili.width_sel = 5;
	oper_mux   n0ill
	( 
	.data({{5{1'b0}}, 1'b1, nliOil, ((nliOOi ^ nlOO1O) ^ nlOO1l), {6{1'b0}}, nlOl0O, {5{1'b0}}, wire_nilll_dataout, {6{1'b0}}, nlOlOl, {3{1'b0}}, wire_n1ii_dataout}),
	.o(wire_n0ill_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0ill.width_data = 32,
		n0ill.width_sel = 5;
	oper_mux   n0ilO
	( 
	.data({{6{1'b0}}, nliOiO, ((nliOOl ^ nlOO0i) ^ nlOO1l), {6{1'b0}}, nlOlii, {5{1'b0}}, wire_nillO_dataout, {6{1'b0}}, nlOlOO, {3{1'b0}}, wire_n1il_dataout}),
	.o(wire_n0ilO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0ilO.width_data = 32,
		n0ilO.width_sel = 5;
	oper_mux   n0iOi
	( 
	.data({{6{1'b0}}, nlOl0i, {7{1'b0}}, nlOlil, {5{1'b0}}, wire_nilOi_dataout, {6{1'b0}}, nlOO1i, {3{1'b0}}, wire_n1iO_dataout}),
	.o(wire_n0iOi_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iOi.width_data = 32,
		n0iOi.width_sel = 5;
	oper_mux   n0iOl
	( 
	.data({{6{1'b0}}, nlOl0l, {7{1'b0}}, nlOliO, {5{1'b0}}, wire_nilOl_dataout, {6{1'b0}}, nlOO1l, {3{1'b0}}, wire_n1li_dataout}),
	.o(wire_n0iOl_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iOl.width_data = 32,
		n0iOl.width_sel = 5;
	oper_mux   n0iOO
	( 
	.data({{6{1'b0}}, nlOl0O, {7{1'b0}}, nlOlli, {5{1'b0}}, wire_nilOO_dataout, {6{1'b0}}, nlOO1O, {3{1'b0}}, wire_n1ll_dataout}),
	.o(wire_n0iOO_o),
	.sel({rpma_doublewidth_tx, rpmadwidth_tx, rprbs_sel[2:0]}));
	defparam
		n0iOO.width_data = 32,
		n0iOO.width_sel = 5;
	oper_selector   n000i
	( 
	.data({1'b0, nlOOil, nlOlii, wire_nliOi_dataout}),
	.o(wire_n000i_o),
	.sel({nlilil, nlilii, wire_n00ii_o[25], wire_n00ii_o[0]}));
	defparam
		n000i.width_data = 4,
		n000i.width_sel = 4;
	oper_selector   n001O
	( 
	.data({1'b0, nlOOii, nlOlil, wire_nlilO_dataout}),
	.o(wire_n001O_o),
	.sel({nlilil, nlilii, wire_n00ii_o[25], wire_n00ii_o[0]}));
	defparam
		n001O.width_data = 4,
		n001O.width_sel = 4;
	oper_selector   n010i
	( 
	.data({1'b0, nlOlOO, nlOlOi, nlOO1l, wire_nli0l_dataout}),
	.o(wire_n010i_o),
	.sel({nlil0O, nlil1l, nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n010i.width_data = 5,
		n010i.width_sel = 5;
	oper_selector   n010O
	( 
	.data({1'b0, nlOO1i, nlOlOl, wire_nli0O_dataout}),
	.o(wire_n010O_o),
	.sel({nlil0O, nlil1O, ((wire_n00ii_o[16] | wire_n00ii_o[25]) | wire_n00ii_o[18]), wire_n00ii_o[0]}));
	defparam
		n010O.width_data = 4,
		n010O.width_sel = 4;
	oper_selector   n011i
	( 
	.data({1'b0, nlOllO, nlOO1O, nlOO0l, wire_nli1l_dataout}),
	.o(wire_n011i_o),
	.sel({nlilil, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[0]}));
	defparam
		n011i.width_data = 5,
		n011i.width_sel = 5;
	oper_selector   n011l
	( 
	.data({1'b0, nlOlOi, nlOO1l, nlOO0O, wire_nli1O_dataout}),
	.o(wire_n011l_o),
	.sel({nlilil, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[0]}));
	defparam
		n011l.width_data = 5,
		n011l.width_sel = 5;
	oper_selector   n011O
	( 
	.data({1'b0, nlOlOl, nlOO1i, nlOllO, nlOO1O, wire_nli0i_dataout}),
	.o(wire_n011O_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n011O.width_data = 6,
		n011O.width_sel = 6;
	oper_selector   n01iO
	( 
	.data({1'b0, nlOO1l, nlOlOi, nlOlOO, wire_nliii_dataout}),
	.o(wire_n01iO_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], ((wire_n00ii_o[16] | wire_n00ii_o[18]) | wire_n00ii_o[17]), wire_n00ii_o[0]}));
	defparam
		n01iO.width_data = 5,
		n01iO.width_sel = 5;
	oper_selector   n01ll
	( 
	.data({1'b0, nlOO1O, nlOllO, nlOO1i, nlOlOl, wire_nliil_dataout}),
	.o(wire_n01ll_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n01ll.width_data = 6,
		n01ll.width_sel = 6;
	oper_selector   n01lO
	( 
	.data({1'b0, nlOO0i, nlOlll, nlOO1l, nlOlOi, wire_nliiO_dataout}),
	.o(wire_n01lO_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n01lO.width_data = 6,
		n01lO.width_sel = 6;
	oper_selector   n01Oi
	( 
	.data({1'b0, nlOO0l, nlOlli, nlOO1O, nlOllO, wire_nlili_dataout}),
	.o(wire_n01Oi_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n01Oi.width_data = 6,
		n01Oi.width_sel = 6;
	oper_selector   n01Ol
	( 
	.data({1'b0, nlOO0O, nlOliO, nlOO0i, nlOlll, wire_nlill_dataout}),
	.o(wire_n01Ol_o),
	.sel({nlil0O, nlil0l, wire_n00ii_o[25], nlil0i, wire_n00ii_o[17], wire_n00ii_o[0]}));
	defparam
		n01Ol.width_data = 6,
		n01Ol.width_sel = 6;
	oper_selector   n1O0O
	( 
	.data({1'b0, nlOl0i, nlOOll, wire_nl0iO_dataout}),
	.o(wire_n1O0O_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1O0O.width_data = 4,
		n1O0O.width_sel = 4;
	oper_selector   n1Oii
	( 
	.data({1'b0, nlOl0l, nlOOli, wire_nl0li_dataout}),
	.o(wire_n1Oii_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1Oii.width_data = 4,
		n1Oii.width_sel = 4;
	oper_selector   n1Oil
	( 
	.data({1'b0, nlOl0O, nlOOiO, wire_nl0ll_dataout}),
	.o(wire_n1Oil_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1Oil.width_data = 4,
		n1Oil.width_sel = 4;
	oper_selector   n1OiO
	( 
	.data({1'b0, nlOlii, nlOOil, wire_nl0lO_dataout}),
	.o(wire_n1OiO_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1OiO.width_data = 4,
		n1OiO.width_sel = 4;
	oper_selector   n1Oli
	( 
	.data({1'b0, nlOlil, nlOOii, wire_nl0Oi_dataout}),
	.o(wire_n1Oli_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1Oli.width_data = 4,
		n1Oli.width_sel = 4;
	oper_selector   n1Oll
	( 
	.data({1'b0, nlOliO, nlOO0O, wire_nl0Ol_dataout}),
	.o(wire_n1Oll_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1Oll.width_data = 4,
		n1Oll.width_sel = 4;
	oper_selector   n1OlO
	( 
	.data({1'b0, nlOlli, nlOO0l, wire_nl0OO_dataout}),
	.o(wire_n1OlO_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1OlO.width_data = 4,
		n1OlO.width_sel = 4;
	oper_selector   n1OOi
	( 
	.data({1'b0, nlOlll, nlOO0i, wire_nli1i_dataout}),
	.o(wire_n1OOi_o),
	.sel({nlil1i, nlilii, nliiOO, wire_n00ii_o[0]}));
	defparam
		n1OOi.width_data = 4,
		n1OOi.width_sel = 4;
	oper_selector   niOO
	( 
	.data({nllilO, wire_nl1O_dataout, nllili}),
	.o(wire_niOO_o),
	.sel({nlli, nilO, ((nlliil22 ^ nlliil21) & nlil)}));
	defparam
		niOO.width_data = 3,
		niOO.width_sel = 3;
	oper_selector   nl1i
	( 
	.data({1'b0, ((nlliiO20 ^ nlliiO19) & nlliOO), (~ nllili)}),
	.o(wire_nl1i_o),
	.sel({nlli, nilO, ((nllill18 ^ nllill17) & nlil)}));
	defparam
		nl1i.width_data = 3,
		nl1i.width_sel = 3;
	oper_selector   nl1l
	( 
	.data({(~ nllilO), wire_nl0i_dataout, 1'b0}),
	.o(wire_nl1l_o),
	.sel({nlli, ((nlliOi16 ^ nlliOi15) & nilO), nlil}));
	defparam
		nl1l.width_data = 3,
		nl1l.width_sel = 3;
	assign
		nliiOO = ((wire_n00ii_o[25] | wire_n00ii_o[17]) | wire_n00ii_o[4]),
		nlil0i = (wire_n00ii_o[16] | wire_n00ii_o[18]),
		nlil0l = (((((((((wire_n00ii_o[24] | wire_n00ii_o[2]) | wire_n00ii_o[28]) | wire_n00ii_o[27]) | wire_n00ii_o[26]) | wire_n00ii_o[11]) | wire_n00ii_o[10]) | wire_n00ii_o[9]) | wire_n00ii_o[8]) | wire_n00ii_o[1]),
		nlil0O = ((((((((((((((((wire_n00ii_o[31] | wire_n00ii_o[30]) | wire_n00ii_o[29]) | wire_n00ii_o[23]) | wire_n00ii_o[22]) | wire_n00ii_o[21]) | wire_n00ii_o[20]) | wire_n00ii_o[19]) | wire_n00ii_o[15]) | wire_n00ii_o[14]) | wire_n00ii_o[13]) | wire_n00ii_o[12]) | wire_n00ii_o[7]) | wire_n00ii_o[6]) | wire_n00ii_o[5]) | wire_n00ii_o[4]) | wire_n00ii_o[3]),
		nlil1i = (((((((((((((((wire_n00ii_o[31] | wire_n00ii_o[30]) | wire_n00ii_o[29]) | wire_n00ii_o[23]) | wire_n00ii_o[22]) | wire_n00ii_o[21]) | wire_n00ii_o[20]) | wire_n00ii_o[19]) | wire_n00ii_o[15]) | wire_n00ii_o[14]) | wire_n00ii_o[13]) | wire_n00ii_o[12]) | wire_n00ii_o[7]) | wire_n00ii_o[6]) | wire_n00ii_o[5]) | wire_n00ii_o[3]),
		nlil1l = ((((((((((wire_n00ii_o[24] | wire_n00ii_o[2]) | wire_n00ii_o[28]) | wire_n00ii_o[27]) | wire_n00ii_o[26]) | wire_n00ii_o[25]) | wire_n00ii_o[11]) | wire_n00ii_o[10]) | wire_n00ii_o[9]) | wire_n00ii_o[8]) | wire_n00ii_o[1]),
		nlil1O = ((((((((((wire_n00ii_o[24] | wire_n00ii_o[2]) | wire_n00ii_o[28]) | wire_n00ii_o[27]) | wire_n00ii_o[26]) | wire_n00ii_o[17]) | wire_n00ii_o[11]) | wire_n00ii_o[10]) | wire_n00ii_o[9]) | wire_n00ii_o[8]) | wire_n00ii_o[1]),
		nlilii = (((((((((((wire_n00ii_o[24] | wire_n00ii_o[16]) | wire_n00ii_o[2]) | wire_n00ii_o[28]) | wire_n00ii_o[27]) | wire_n00ii_o[26]) | wire_n00ii_o[18]) | wire_n00ii_o[11]) | wire_n00ii_o[10]) | wire_n00ii_o[9]) | wire_n00ii_o[8]) | wire_n00ii_o[1]),
		nlilil = (((((((((((((((((wire_n00ii_o[31] | wire_n00ii_o[30]) | wire_n00ii_o[29]) | wire_n00ii_o[23]) | wire_n00ii_o[22]) | wire_n00ii_o[21]) | wire_n00ii_o[20]) | wire_n00ii_o[19]) | wire_n00ii_o[17]) | wire_n00ii_o[15]) | wire_n00ii_o[14]) | wire_n00ii_o[13]) | wire_n00ii_o[12]) | wire_n00ii_o[7]) | wire_n00ii_o[6]) | wire_n00ii_o[5]) | wire_n00ii_o[4]) | wire_n00ii_o[3]),
		nliliO = (nlOlll ^ nlOl0O),
		nlilli = (nlOllO ^ nlOlii),
		nlilll = (nlOlOi ^ nlOlil),
		nlillO = (nlOlOl ^ nlOliO),
		nlilOi = (nlOlOO ^ nlOlli),
		nlilOl = (nlOO1i ^ nlOlll),
		nlilOO = (nlOO1l ^ nlOllO),
		nliO0i = (nlOO0O ^ nlOO1i),
		nliO0l = (nlOOii ^ nlOO1l),
		nliO0O = (nlOOil ^ nlOO1O),
		nliO1i = (nlOO1O ^ nlOlOi),
		nliO1l = (nlOO0i ^ nlOlOl),
		nliO1O = (nlOO0l ^ nlOlOO),
		nliOii = (nlOOiO ^ nlOO0i),
		nliOil = (nlOOli ^ nlOO0l),
		nliOiO = (nlOOll ^ nlOO0O),
		nliOli = (nlOO0l ^ nlOO0i),
		nliOll = (nlOO0O ^ nlOO0l),
		nliOlO = (nlOOii ^ nlOO0O),
		nliOOi = (nliOOl ^ nlOO0O),
		nliOOl = (nlOOil ^ nlOOii),
		nliOOO = (nlOO1O ^ nlOO1l),
		nll0ll = (nlOlil ^ nlOlii),
		nll0lO = (nlOliO ^ nlOlil),
		nll0Oi = ((nlOlli ^ nlOliO) ^ (~ (nll0Ol28 ^ nll0Ol27))),
		nll10i = (nlOO1l ^ nlOO1i),
		nll10l = (nlOliO ^ nlOl0O),
		nll10O = ((nlOlil ^ nlOl0l) ^ (~ (nll1ii46 ^ nll1ii45))),
		nll11i = (nlOO0i ^ nlOO1O),
		nll11l = (nlOO0i ^ nlOO1l),
		nll11O = (nlOO1i ^ nlOlOO),
		nll1iO = ((nlOlii ^ nlOl0i) ^ (~ (nll1li44 ^ nll1li43))),
		nlli0i = (((wire_n00ii_o[24] | wire_n00ii_o[16]) | wire_n00ii_o[2]) | (~ (nlli0l24 ^ nlli0l23))),
		nlli1i = (nlOlll ^ nlOlli),
		nlli1l = (wire_niOl_dataout | wire_niOi_dataout),
		nlliii = (nili & (~ nlOOlO)),
		nllili = ((((((((~ n1O) & (~ n1l)) & (~ n1i)) & (~ nlOO)) & (~ nlOl)) & (~ nlOi)) & (~ nllO)) & nlll),
		nllilO = (((((((nlOlll & nlOlli) & nlOliO) & nlOlil) & nlOlii) & nlOl0O) & nlOl0l) & nlOl0i),
		nlliOl = ((((((((~ nlOlll) & nlOlli) & (~ nlOliO)) & nlOlil) & (~ nlOlii)) & (~ nlOl0O)) & (~ nlOl0l)) & (~ nlOl0i)),
		nlliOO = (((n0i & (~ nlll0i)) & nlll1O) & (nlll1i14 ^ nlll1i13)),
		nlll0i = ((((((((~ n1O) & (~ n1l)) & (~ n1i)) & (~ nlOO)) & (~ nlOl)) & (~ nlOi)) & (~ nllO)) & (~ nlll)),
		nlll0l = (((((~ rpmadwidth_tx) & (~ rpma_doublewidth_tx)) & (~ rprbs_sel[0])) & (~ rprbs_sel[1])) & (~ rprbs_sel[2])),
		nlll1O = (((((((nlOlll & nlOlli) & (~ nlOliO)) & nlOlil) & nlOlii) & (~ nlOl0O)) & (~ nlOl0l)) & (~ nlOl0i)),
		nllllO = 1'b1,
		prbs_out = {nlOl1O, nlOl1l, nlOl1i, nlOiOO, nlOiOl, nlOiOi, nlOilO, nlOill, nlOili, nlOiiO, nlOiil, nlOiii, nlOi0O, nlOi0l, nlOi0i, nlOi1O, nlOi1l, nlOi1i, nlO0OO, nlO0Ol};
endmodule //arriaii_hssi_tx_digi_prbs_gen
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 139 mux21 168 oper_decoder 2 oper_mux 184 
`timescale 1 ps / 1 ps
module  arriaii_hssi_tx_digi_enc_chnl_top
	( 
	cascaded_8b10b_en,
	clk,
	d21_5_eq_n,
	d2_2_eq_n,
	disp_out_3b,
	doublewidth,
	dwidth,
	endec,
	enpolinv_tx,
	ge_xaui_sel,
	ib_force_disparity,
	k_det,
	prbs_en,
	pudr,
	r8b10b_enc_ibm_en,
	renbitrev_tx,
	rendec_data_sel_tx,
	renpolinv_tx,
	rensymswap_tx,
	rev_loop_data,
	rev_loopbk,
	rforce_disp,
	rrev_loopbk,
	rst,
	rtxbitslip_en,
	tx_boundary_sel,
	tx_ctl_pre_en,
	tx_ctl_tc,
	tx_ctl_ts,
	tx_data_9_pre_en,
	tx_data_9_tc,
	tx_data_pg,
	tx_data_pre_en,
	tx_data_tc,
	tx_data_ts,
	txd_extend_tc,
	txlp20b) /* synthesis synthesis_clearbox=1 */;
	input   cascaded_8b10b_en;
	input   clk;
	input   d21_5_eq_n;
	input   d2_2_eq_n;
	output   [1:0]  disp_out_3b;
	input   doublewidth;
	input   dwidth;
	input   endec;
	input   enpolinv_tx;
	input   ge_xaui_sel;
	input   ib_force_disparity;
	input   k_det;
	input   prbs_en;
	output   [19:0]  pudr;
	input   r8b10b_enc_ibm_en;
	input   renbitrev_tx;
	input   rendec_data_sel_tx;
	input   renpolinv_tx;
	input   rensymswap_tx;
	input   [19:0]  rev_loop_data;
	input   rev_loopbk;
	input   rforce_disp;
	input   rrev_loopbk;
	input   rst;
	input   rtxbitslip_en;
	input   [4:0]  tx_boundary_sel;
	output   [1:0]  tx_ctl_pre_en;
	input   [1:0]  tx_ctl_tc;
	input   tx_ctl_ts;
	output   [1:0]  tx_data_9_pre_en;
	input   [1:0]  tx_data_9_tc;
	input   [19:0]  tx_data_pg;
	output   [15:0]  tx_data_pre_en;
	input   [15:0]  tx_data_tc;
	input   [7:0]  tx_data_ts;
	input   [1:0]  txd_extend_tc;
	output   [19:0]  txlp20b;

	reg	ni0O0l49;
	reg	ni0O0l50;
	reg	ni0O0O47;
	reg	ni0O0O48;
	reg	ni0Oii45;
	reg	ni0Oii46;
	reg	ni0OiO43;
	reg	ni0OiO44;
	reg	ni0Oli41;
	reg	ni0Oli42;
	reg	ni0Oll39;
	reg	ni0Oll40;
	reg	ni0OlO37;
	reg	ni0OlO38;
	reg	ni0OOi35;
	reg	ni0OOi36;
	reg	ni0OOl33;
	reg	ni0OOl34;
	reg	ni0OOO31;
	reg	ni0OOO32;
	reg	nii00i5;
	reg	nii00i6;
	reg	nii01l7;
	reg	nii01l8;
	reg	nii0ii3;
	reg	nii0ii4;
	reg	nii0iO1;
	reg	nii0iO2;
	reg	nii10i23;
	reg	nii10i24;
	reg	nii10l21;
	reg	nii10l22;
	reg	nii10O19;
	reg	nii10O20;
	reg	nii11i29;
	reg	nii11i30;
	reg	nii11l27;
	reg	nii11l28;
	reg	nii11O25;
	reg	nii11O26;
	reg	nii1ii17;
	reg	nii1ii18;
	reg	nii1il15;
	reg	nii1il16;
	reg	nii1li13;
	reg	nii1li14;
	reg	nii1lO11;
	reg	nii1lO12;
	reg	nii1OO10;
	reg	nii1OO9;
	reg	n01li;
	reg	n01iO_clk_prev;
	wire	wire_n01iO_PRN;
	wire	wire_n01iO_ENA;
	reg	n000i;
	reg	n000l;
	reg	n000O;
	reg	n001i;
	reg	n001l;
	reg	n001O;
	reg	n00ii;
	reg	n00il;
	reg	n00iO;
	reg	n00li;
	reg	n00ll;
	reg	n00lO;
	reg	n00Oi;
	reg	n00Ol;
	reg	n00OO;
	reg	n01ii;
	reg	n01il;
	reg	n01lO;
	reg	n01Oi;
	reg	n01Ol;
	reg	n01OO;
	reg	n0i1i;
	reg	n0i1l;
	reg	n0i1O;
	reg	n0iiO;
	reg	n0ill;
	reg	n0iOl;
	reg	n0iOO;
	reg	n0l0l;
	reg	n0l1i;
	reg	n0l1l;
	reg	n0l1O;
	reg	n0lii;
	reg	n0lil;
	reg	n0liO;
	reg	n0lli;
	reg	n0lll;
	reg	n0llO;
	reg	n0lOi;
	reg	ni00i;
	reg	ni01l;
	reg	ni0ii;
	reg	ni0il;
	reg	ni0iO;
	reg	ni0li;
	reg	ni0ll;
	reg	ni0Ol;
	reg	ni1li;
	reg	ni1ll;
	reg	nii0Oi;
	reg	nii0Ol;
	reg	nii0OO;
	reg	niii0i;
	reg	niii0l;
	reg	niii0O;
	reg	niii1i;
	reg	niii1l;
	reg	niii1O;
	reg	niiiii;
	reg	niiiil;
	reg	niiiiO;
	reg	niiili;
	reg	niiill;
	reg	niiilO;
	reg	niiiOi;
	reg	niiiOl;
	reg	niiiOO;
	reg	niil1i;
	reg	ni0Oi_clk_prev;
	wire	wire_ni0Oi_CLRN;
	wire	wire_ni0Oi_PRN;
	reg	n0i0i;
	reg	n0i0l;
	reg	n0i0O;
	reg	n0iii;
	reg	n0iil;
	reg	n0ili;
	reg	n0ilO;
	reg	n0iOi;
	reg	n0l0i;
	reg	n0l0O;
	reg	ni00l;
	reg	ni00O;
	reg	ni01i;
	reg	ni01O;
	reg	ni0lO;
	reg	ni1lO;
	reg	ni1Oi;
	reg	ni1Ol;
	reg	ni1OO;
	reg	nii1i;
	reg	ni0OO_clk_prev;
	wire	wire_ni0OO_CLRN;
	wire	wire_ni0OO_PRN;
	wire	wire_n00i_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0ll_dataout;
	wire	wire_n0lO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n10i_dataout;
	wire	wire_n10l_dataout;
	wire	wire_n10O_dataout;
	wire	wire_n11i_dataout;
	wire	wire_n11l_dataout;
	wire	wire_n11O_dataout;
	wire	wire_n1ii_dataout;
	wire	wire_n1il_dataout;
	wire	wire_n1iO_dataout;
	wire	wire_n1li_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_niiOl_dataout;
	wire	wire_niiOO_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil00l_dataout;
	wire	wire_nil00O_dataout;
	wire	wire_nil0i_dataout;
	wire	wire_nil0l_dataout;
	wire	wire_nil0O_dataout;
	wire	wire_nil0OO_dataout;
	wire	wire_nil1i_dataout;
	wire	wire_nil1l_dataout;
	wire	wire_nil1O_dataout;
	wire	wire_nili_dataout;
	wire	wire_nili1i_dataout;
	wire	wire_niliOl_dataout;
	wire	wire_niliOO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nill0i_dataout;
	wire	wire_nill0l_dataout;
	wire	wire_nill0O_dataout;
	wire	wire_nill1i_dataout;
	wire	wire_nill1l_dataout;
	wire	wire_nill1O_dataout;
	wire	wire_nillii_dataout;
	wire	wire_nillil_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilO0i_dataout;
	wire	wire_nilO0l_dataout;
	wire	wire_nilO0O_dataout;
	wire	wire_nilOii_dataout;
	wire	wire_nilOil_dataout;
	wire	wire_nilOiO_dataout;
	wire	wire_nilOli_dataout;
	wire	wire_nilOll_dataout;
	wire	wire_nilOlO_dataout;
	wire	wire_nilOOi_dataout;
	wire	wire_nilOOl_dataout;
	wire	wire_nilOOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOlOi_dataout;
	wire	wire_niOO_dataout;
	wire	wire_niOOOi_dataout;
	wire	wire_niOOOl_dataout;
	wire	wire_niOOOO_dataout;
	wire	wire_nl000i_dataout;
	wire	wire_nl000l_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl00ll_dataout;
	wire	wire_nl010O_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl10Ol_dataout;
	wire	wire_nl10OO_dataout;
	wire	wire_nl111i_dataout;
	wire	wire_nl111l_dataout;
	wire	wire_nl111O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1i0O_dataout;
	wire	wire_nl1iii_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli0il_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0li_dataout;
	wire	wire_nli0ll_dataout;
	wire	wire_nli0lO_dataout;
	wire	wire_nli0Oi_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliliO_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliO1i_dataout;
	wire	wire_nliO1l_dataout;
	wire	wire_nll_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlli0i_dataout;
	wire	wire_nlli0l_dataout;
	wire	wire_nlli1i_dataout;
	wire	wire_nlliiO_dataout;
	wire	wire_nllill_dataout;
	wire	wire_nllilO_dataout;
	wire	wire_nlliOi_dataout;
	wire	wire_nlliOl_dataout;
	wire	wire_nlliOO_dataout;
	wire	wire_nlll0O_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOli_dataout;
	wire	wire_nlOll_dataout;
	wire	wire_nlOlO_dataout;
	wire	wire_nlOOi_dataout;
	wire	wire_nlOOl_dataout;
	wire	wire_nlOOO_dataout;
	wire  [31:0]   wire_nili1O_o;
	wire  [15:0]   wire_nillli_o;
	wire  wire_n010i_o;
	wire  wire_n010l_o;
	wire  wire_n010O_o;
	wire  wire_n011i_o;
	wire  wire_n011l_o;
	wire  wire_n011O_o;
	wire  wire_n1O0i_o;
	wire  wire_n1O0l_o;
	wire  wire_n1O0O_o;
	wire  wire_n1O1l_o;
	wire  wire_n1O1O_o;
	wire  wire_n1Oii_o;
	wire  wire_n1Oil_o;
	wire  wire_n1OiO_o;
	wire  wire_n1Oli_o;
	wire  wire_n1Oll_o;
	wire  wire_n1OlO_o;
	wire  wire_n1OOi_o;
	wire  wire_n1OOl_o;
	wire  wire_n1OOO_o;
	wire  wire_niil0i_o;
	wire  wire_niil0l_o;
	wire  wire_niil0O_o;
	wire  wire_niil1l_o;
	wire  wire_niil1O_o;
	wire  wire_niilii_o;
	wire  wire_niilil_o;
	wire  wire_niiliO_o;
	wire  wire_niilli_o;
	wire  wire_niilll_o;
	wire  wire_niillO_o;
	wire  wire_niilOi_o;
	wire  wire_niilOl_o;
	wire  wire_niilOO_o;
	wire  wire_niiO0i_o;
	wire  wire_niiO0l_o;
	wire  wire_niiO0O_o;
	wire  wire_niiO1i_o;
	wire  wire_niiO1l_o;
	wire  wire_niiO1O_o;
	wire  wire_niiOii_o;
	wire  wire_niiOil_o;
	wire  wire_niiOiO_o;
	wire  wire_niiOli_o;
	wire  wire_niiOll_o;
	wire  wire_niiOlO_o;
	wire  wire_niiOOi_o;
	wire  wire_niiOOl_o;
	wire  wire_niiOOO_o;
	wire  wire_nil00i_o;
	wire  wire_nil01i_o;
	wire  wire_nil01l_o;
	wire  wire_nil01O_o;
	wire  wire_nil0ii_o;
	wire  wire_nil0il_o;
	wire  wire_nil0iO_o;
	wire  wire_nil0li_o;
	wire  wire_nil0ll_o;
	wire  wire_nil0lO_o;
	wire  wire_nil0Oi_o;
	wire  wire_nil0Ol_o;
	wire  wire_nil10i_o;
	wire  wire_nil10l_o;
	wire  wire_nil10O_o;
	wire  wire_nil11i_o;
	wire  wire_nil11l_o;
	wire  wire_nil11O_o;
	wire  wire_nil1ii_o;
	wire  wire_nil1il_o;
	wire  wire_nil1iO_o;
	wire  wire_nil1li_o;
	wire  wire_nil1ll_o;
	wire  wire_nil1lO_o;
	wire  wire_nil1Oi_o;
	wire  wire_nil1Ol_o;
	wire  wire_nil1OO_o;
	wire  wire_nili0i_o;
	wire  wire_nili0l_o;
	wire  wire_nili0O_o;
	wire  wire_nilii_o;
	wire  wire_niliii_o;
	wire  wire_niliil_o;
	wire  wire_niliiO_o;
	wire  wire_nilil_o;
	wire  wire_nilili_o;
	wire  wire_nilill_o;
	wire  wire_nililO_o;
	wire  wire_niliO_o;
	wire  wire_niliOi_o;
	wire  wire_nilli_o;
	wire  wire_nilll_o;
	wire  wire_nillll_o;
	wire  wire_nilllO_o;
	wire  wire_nillO_o;
	wire  wire_nillOi_o;
	wire  wire_nillOl_o;
	wire  wire_nillOO_o;
	wire  wire_nilO1i_o;
	wire  wire_nilO1l_o;
	wire  wire_nilO1O_o;
	wire  wire_nilOi_o;
	wire  wire_nilOl_o;
	wire  wire_nilOO_o;
	wire  wire_niO0i_o;
	wire  wire_niO0l_o;
	wire  wire_niO0O_o;
	wire  wire_niO1i_o;
	wire  wire_niO1l_o;
	wire  wire_niO1O_o;
	wire  wire_niOii_o;
	wire  wire_niOil_o;
	wire  wire_niOiO_o;
	wire  wire_niOli_o;
	wire  wire_niOll_o;
	wire  wire_niOlO_o;
	wire  wire_niOOi_o;
	wire  wire_niOOl_o;
	wire  wire_niOOO_o;
	wire  wire_nl00i_o;
	wire  wire_nl00l_o;
	wire  wire_nl00O_o;
	wire  wire_nl01i_o;
	wire  wire_nl01l_o;
	wire  wire_nl01O_o;
	wire  wire_nl0ii_o;
	wire  wire_nl0il_o;
	wire  wire_nl0iO_o;
	wire  wire_nl0li_o;
	wire  wire_nl0ll_o;
	wire  wire_nl0lO_o;
	wire  wire_nl0Oi_o;
	wire  wire_nl0Ol_o;
	wire  wire_nl0OO_o;
	wire  wire_nl10i_o;
	wire  wire_nl10l_o;
	wire  wire_nl10O_o;
	wire  wire_nl11i_o;
	wire  wire_nl11l_o;
	wire  wire_nl11O_o;
	wire  wire_nl1ii_o;
	wire  wire_nl1il_o;
	wire  wire_nl1iO_o;
	wire  wire_nl1li_o;
	wire  wire_nl1ll_o;
	wire  wire_nl1lO_o;
	wire  wire_nl1Oi_o;
	wire  wire_nl1Ol_o;
	wire  wire_nl1OO_o;
	wire  wire_nli0i_o;
	wire  wire_nli0l_o;
	wire  wire_nli0O_o;
	wire  wire_nli1i_o;
	wire  wire_nli1l_o;
	wire  wire_nli1O_o;
	wire  wire_nliii_o;
	wire  wire_nliil_o;
	wire  wire_nliiO_o;
	wire  wire_nlili_o;
	wire  wire_nlill_o;
	wire  wire_nlilO_o;
	wire  wire_nliOi_o;
	wire  wire_nliOl_o;
	wire  wire_nliOO_o;
	wire  wire_nll0i_o;
	wire  wire_nll0l_o;
	wire  wire_nll0O_o;
	wire  wire_nll1i_o;
	wire  wire_nll1l_o;
	wire  wire_nll1O_o;
	wire  wire_nllii_o;
	wire  wire_nllil_o;
	wire  wire_nlliO_o;
	wire  wire_nllli_o;
	wire  wire_nllll_o;
	wire  wire_nlllO_o;
	wire  wire_nllOi_o;
	wire  wire_nllOl_o;
	wire  wire_nllOO_o;
	wire  wire_nlO0i_o;
	wire  wire_nlO0l_o;
	wire  wire_nlO0O_o;
	wire  wire_nlO1i_o;
	wire  wire_nlO1l_o;
	wire  wire_nlO1O_o;
	wire  ni000i;
	wire  ni000l;
	wire  ni000O;
	wire  ni001i;
	wire  ni001l;
	wire  ni001O;
	wire  ni00ii;
	wire  ni00il;
	wire  ni00iO;
	wire  ni00li;
	wire  ni00ll;
	wire  ni00lO;
	wire  ni00Oi;
	wire  ni00Ol;
	wire  ni00OO;
	wire  ni01il;
	wire  ni01iO;
	wire  ni01li;
	wire  ni01ll;
	wire  ni01lO;
	wire  ni01Oi;
	wire  ni01Ol;
	wire  ni01OO;
	wire  ni0i0i;
	wire  ni0i0l;
	wire  ni0i0O;
	wire  ni0i1i;
	wire  ni0i1l;
	wire  ni0i1O;
	wire  ni0iii;
	wire  ni0iil;
	wire  ni0iiO;
	wire  ni0ili;
	wire  ni0ill;
	wire  ni0ilO;
	wire  ni0iOi;
	wire  ni0iOl;
	wire  ni0iOO;
	wire  ni0l0i;
	wire  ni0l0l;
	wire  ni0l0O;
	wire  ni0l1i;
	wire  ni0l1l;
	wire  ni0l1O;
	wire  ni0lii;
	wire  ni0lil;
	wire  ni0liO;
	wire  ni0lli;
	wire  ni0lll;
	wire  ni0llO;
	wire  ni0lOi;
	wire  ni0lOl;
	wire  ni0lOO;
	wire  ni0O0i;
	wire  ni0O1i;
	wire  ni0O1l;
	wire  ni0O1O;
	wire  ni0Oil;
	wire  nii00O;
	wire  nii1iO;
	wire  nii1Ol;

	initial
		ni0O0l49 = 0;
	always @ ( posedge clk)
		  ni0O0l49 <= ni0O0l50;
	event ni0O0l49_event;
	initial
		#1 ->ni0O0l49_event;
	always @(ni0O0l49_event)
		ni0O0l49 <= {1{1'b1}};
	initial
		ni0O0l50 = 0;
	always @ ( posedge clk)
		  ni0O0l50 <= ni0O0l49;
	initial
		ni0O0O47 = 0;
	always @ ( posedge clk)
		  ni0O0O47 <= ni0O0O48;
	event ni0O0O47_event;
	initial
		#1 ->ni0O0O47_event;
	always @(ni0O0O47_event)
		ni0O0O47 <= {1{1'b1}};
	initial
		ni0O0O48 = 0;
	always @ ( posedge clk)
		  ni0O0O48 <= ni0O0O47;
	initial
		ni0Oii45 = 0;
	always @ ( posedge clk)
		  ni0Oii45 <= ni0Oii46;
	event ni0Oii45_event;
	initial
		#1 ->ni0Oii45_event;
	always @(ni0Oii45_event)
		ni0Oii45 <= {1{1'b1}};
	initial
		ni0Oii46 = 0;
	always @ ( posedge clk)
		  ni0Oii46 <= ni0Oii45;
	initial
		ni0OiO43 = 0;
	always @ ( posedge clk)
		  ni0OiO43 <= ni0OiO44;
	event ni0OiO43_event;
	initial
		#1 ->ni0OiO43_event;
	always @(ni0OiO43_event)
		ni0OiO43 <= {1{1'b1}};
	initial
		ni0OiO44 = 0;
	always @ ( posedge clk)
		  ni0OiO44 <= ni0OiO43;
	initial
		ni0Oli41 = 0;
	always @ ( posedge clk)
		  ni0Oli41 <= ni0Oli42;
	event ni0Oli41_event;
	initial
		#1 ->ni0Oli41_event;
	always @(ni0Oli41_event)
		ni0Oli41 <= {1{1'b1}};
	initial
		ni0Oli42 = 0;
	always @ ( posedge clk)
		  ni0Oli42 <= ni0Oli41;
	initial
		ni0Oll39 = 0;
	always @ ( posedge clk)
		  ni0Oll39 <= ni0Oll40;
	event ni0Oll39_event;
	initial
		#1 ->ni0Oll39_event;
	always @(ni0Oll39_event)
		ni0Oll39 <= {1{1'b1}};
	initial
		ni0Oll40 = 0;
	always @ ( posedge clk)
		  ni0Oll40 <= ni0Oll39;
	initial
		ni0OlO37 = 0;
	always @ ( posedge clk)
		  ni0OlO37 <= ni0OlO38;
	event ni0OlO37_event;
	initial
		#1 ->ni0OlO37_event;
	always @(ni0OlO37_event)
		ni0OlO37 <= {1{1'b1}};
	initial
		ni0OlO38 = 0;
	always @ ( posedge clk)
		  ni0OlO38 <= ni0OlO37;
	initial
		ni0OOi35 = 0;
	always @ ( posedge clk)
		  ni0OOi35 <= ni0OOi36;
	event ni0OOi35_event;
	initial
		#1 ->ni0OOi35_event;
	always @(ni0OOi35_event)
		ni0OOi35 <= {1{1'b1}};
	initial
		ni0OOi36 = 0;
	always @ ( posedge clk)
		  ni0OOi36 <= ni0OOi35;
	initial
		ni0OOl33 = 0;
	always @ ( posedge clk)
		  ni0OOl33 <= ni0OOl34;
	event ni0OOl33_event;
	initial
		#1 ->ni0OOl33_event;
	always @(ni0OOl33_event)
		ni0OOl33 <= {1{1'b1}};
	initial
		ni0OOl34 = 0;
	always @ ( posedge clk)
		  ni0OOl34 <= ni0OOl33;
	initial
		ni0OOO31 = 0;
	always @ ( posedge clk)
		  ni0OOO31 <= ni0OOO32;
	event ni0OOO31_event;
	initial
		#1 ->ni0OOO31_event;
	always @(ni0OOO31_event)
		ni0OOO31 <= {1{1'b1}};
	initial
		ni0OOO32 = 0;
	always @ ( posedge clk)
		  ni0OOO32 <= ni0OOO31;
	initial
		nii00i5 = 0;
	always @ ( posedge clk)
		  nii00i5 <= nii00i6;
	event nii00i5_event;
	initial
		#1 ->nii00i5_event;
	always @(nii00i5_event)
		nii00i5 <= {1{1'b1}};
	initial
		nii00i6 = 0;
	always @ ( posedge clk)
		  nii00i6 <= nii00i5;
	initial
		nii01l7 = 0;
	always @ ( posedge clk)
		  nii01l7 <= nii01l8;
	event nii01l7_event;
	initial
		#1 ->nii01l7_event;
	always @(nii01l7_event)
		nii01l7 <= {1{1'b1}};
	initial
		nii01l8 = 0;
	always @ ( posedge clk)
		  nii01l8 <= nii01l7;
	initial
		nii0ii3 = 0;
	always @ ( posedge clk)
		  nii0ii3 <= nii0ii4;
	event nii0ii3_event;
	initial
		#1 ->nii0ii3_event;
	always @(nii0ii3_event)
		nii0ii3 <= {1{1'b1}};
	initial
		nii0ii4 = 0;
	always @ ( posedge clk)
		  nii0ii4 <= nii0ii3;
	initial
		nii0iO1 = 0;
	always @ ( posedge clk)
		  nii0iO1 <= nii0iO2;
	event nii0iO1_event;
	initial
		#1 ->nii0iO1_event;
	always @(nii0iO1_event)
		nii0iO1 <= {1{1'b1}};
	initial
		nii0iO2 = 0;
	always @ ( posedge clk)
		  nii0iO2 <= nii0iO1;
	initial
		nii10i23 = 0;
	always @ ( posedge clk)
		  nii10i23 <= nii10i24;
	event nii10i23_event;
	initial
		#1 ->nii10i23_event;
	always @(nii10i23_event)
		nii10i23 <= {1{1'b1}};
	initial
		nii10i24 = 0;
	always @ ( posedge clk)
		  nii10i24 <= nii10i23;
	initial
		nii10l21 = 0;
	always @ ( posedge clk)
		  nii10l21 <= nii10l22;
	event nii10l21_event;
	initial
		#1 ->nii10l21_event;
	always @(nii10l21_event)
		nii10l21 <= {1{1'b1}};
	initial
		nii10l22 = 0;
	always @ ( posedge clk)
		  nii10l22 <= nii10l21;
	initial
		nii10O19 = 0;
	always @ ( posedge clk)
		  nii10O19 <= nii10O20;
	event nii10O19_event;
	initial
		#1 ->nii10O19_event;
	always @(nii10O19_event)
		nii10O19 <= {1{1'b1}};
	initial
		nii10O20 = 0;
	always @ ( posedge clk)
		  nii10O20 <= nii10O19;
	initial
		nii11i29 = 0;
	always @ ( posedge clk)
		  nii11i29 <= nii11i30;
	event nii11i29_event;
	initial
		#1 ->nii11i29_event;
	always @(nii11i29_event)
		nii11i29 <= {1{1'b1}};
	initial
		nii11i30 = 0;
	always @ ( posedge clk)
		  nii11i30 <= nii11i29;
	initial
		nii11l27 = 0;
	always @ ( posedge clk)
		  nii11l27 <= nii11l28;
	event nii11l27_event;
	initial
		#1 ->nii11l27_event;
	always @(nii11l27_event)
		nii11l27 <= {1{1'b1}};
	initial
		nii11l28 = 0;
	always @ ( posedge clk)
		  nii11l28 <= nii11l27;
	initial
		nii11O25 = 0;
	always @ ( posedge clk)
		  nii11O25 <= nii11O26;
	event nii11O25_event;
	initial
		#1 ->nii11O25_event;
	always @(nii11O25_event)
		nii11O25 <= {1{1'b1}};
	initial
		nii11O26 = 0;
	always @ ( posedge clk)
		  nii11O26 <= nii11O25;
	initial
		nii1ii17 = 0;
	always @ ( posedge clk)
		  nii1ii17 <= nii1ii18;
	event nii1ii17_event;
	initial
		#1 ->nii1ii17_event;
	always @(nii1ii17_event)
		nii1ii17 <= {1{1'b1}};
	initial
		nii1ii18 = 0;
	always @ ( posedge clk)
		  nii1ii18 <= nii1ii17;
	initial
		nii1il15 = 0;
	always @ ( posedge clk)
		  nii1il15 <= nii1il16;
	event nii1il15_event;
	initial
		#1 ->nii1il15_event;
	always @(nii1il15_event)
		nii1il15 <= {1{1'b1}};
	initial
		nii1il16 = 0;
	always @ ( posedge clk)
		  nii1il16 <= nii1il15;
	initial
		nii1li13 = 0;
	always @ ( posedge clk)
		  nii1li13 <= nii1li14;
	event nii1li13_event;
	initial
		#1 ->nii1li13_event;
	always @(nii1li13_event)
		nii1li13 <= {1{1'b1}};
	initial
		nii1li14 = 0;
	always @ ( posedge clk)
		  nii1li14 <= nii1li13;
	initial
		nii1lO11 = 0;
	always @ ( posedge clk)
		  nii1lO11 <= nii1lO12;
	event nii1lO11_event;
	initial
		#1 ->nii1lO11_event;
	always @(nii1lO11_event)
		nii1lO11 <= {1{1'b1}};
	initial
		nii1lO12 = 0;
	always @ ( posedge clk)
		  nii1lO12 <= nii1lO11;
	initial
		nii1OO10 = 0;
	always @ ( posedge clk)
		  nii1OO10 <= nii1OO9;
	initial
		nii1OO9 = 0;
	always @ ( posedge clk)
		  nii1OO9 <= nii1OO10;
	event nii1OO9_event;
	initial
		#1 ->nii1OO9_event;
	always @(nii1OO9_event)
		nii1OO9 <= {1{1'b1}};
	initial
	begin
		n01li = 0;
	end
	always @ (clk or wire_n01iO_PRN or rst)
	begin
		if (wire_n01iO_PRN == 1'b0) 
		begin
			n01li <= 1;
		end
		else if  (rst == 1'b1) 
		begin
			n01li <= 0;
		end
		else if  (wire_n01iO_ENA == 1'b1) 
		if (clk != n01iO_clk_prev && clk == 1'b1) 
		begin
			n01li <= ni0Oil;
		end
		n01iO_clk_prev <= clk;
	end
	assign
		wire_n01iO_ENA = ((ib_force_disparity & tx_data_9_tc[0]) & (~ n01li)),
		wire_n01iO_PRN = (ni0O0l50 ^ ni0O0l49);
	initial
	begin
		n000i = 0;
		n000l = 0;
		n000O = 0;
		n001i = 0;
		n001l = 0;
		n001O = 0;
		n00ii = 0;
		n00il = 0;
		n00iO = 0;
		n00li = 0;
		n00ll = 0;
		n00lO = 0;
		n00Oi = 0;
		n00Ol = 0;
		n00OO = 0;
		n01ii = 0;
		n01il = 0;
		n01lO = 0;
		n01Oi = 0;
		n01Ol = 0;
		n01OO = 0;
		n0i1i = 0;
		n0i1l = 0;
		n0i1O = 0;
		n0iiO = 0;
		n0ill = 0;
		n0iOl = 0;
		n0iOO = 0;
		n0l0l = 0;
		n0l1i = 0;
		n0l1l = 0;
		n0l1O = 0;
		n0lii = 0;
		n0lil = 0;
		n0liO = 0;
		n0lli = 0;
		n0lll = 0;
		n0llO = 0;
		n0lOi = 0;
		ni00i = 0;
		ni01l = 0;
		ni0ii = 0;
		ni0il = 0;
		ni0iO = 0;
		ni0li = 0;
		ni0ll = 0;
		ni0Ol = 0;
		ni1li = 0;
		ni1ll = 0;
		nii0Oi = 0;
		nii0Ol = 0;
		nii0OO = 0;
		niii0i = 0;
		niii0l = 0;
		niii0O = 0;
		niii1i = 0;
		niii1l = 0;
		niii1O = 0;
		niiiii = 0;
		niiiil = 0;
		niiiiO = 0;
		niiili = 0;
		niiill = 0;
		niiilO = 0;
		niiiOi = 0;
		niiiOl = 0;
		niiiOO = 0;
		niil1i = 0;
	end
	always @ (clk or wire_ni0Oi_PRN or wire_ni0Oi_CLRN)
	begin
		if (wire_ni0Oi_PRN == 1'b0) 
		begin
			n000i <= 1;
			n000l <= 1;
			n000O <= 1;
			n001i <= 1;
			n001l <= 1;
			n001O <= 1;
			n00ii <= 1;
			n00il <= 1;
			n00iO <= 1;
			n00li <= 1;
			n00ll <= 1;
			n00lO <= 1;
			n00Oi <= 1;
			n00Ol <= 1;
			n00OO <= 1;
			n01ii <= 1;
			n01il <= 1;
			n01lO <= 1;
			n01Oi <= 1;
			n01Ol <= 1;
			n01OO <= 1;
			n0i1i <= 1;
			n0i1l <= 1;
			n0i1O <= 1;
			n0iiO <= 1;
			n0ill <= 1;
			n0iOl <= 1;
			n0iOO <= 1;
			n0l0l <= 1;
			n0l1i <= 1;
			n0l1l <= 1;
			n0l1O <= 1;
			n0lii <= 1;
			n0lil <= 1;
			n0liO <= 1;
			n0lli <= 1;
			n0lll <= 1;
			n0llO <= 1;
			n0lOi <= 1;
			ni00i <= 1;
			ni01l <= 1;
			ni0ii <= 1;
			ni0il <= 1;
			ni0iO <= 1;
			ni0li <= 1;
			ni0ll <= 1;
			ni0Ol <= 1;
			ni1li <= 1;
			ni1ll <= 1;
			nii0Oi <= 1;
			nii0Ol <= 1;
			nii0OO <= 1;
			niii0i <= 1;
			niii0l <= 1;
			niii0O <= 1;
			niii1i <= 1;
			niii1l <= 1;
			niii1O <= 1;
			niiiii <= 1;
			niiiil <= 1;
			niiiiO <= 1;
			niiili <= 1;
			niiill <= 1;
			niiilO <= 1;
			niiiOi <= 1;
			niiiOl <= 1;
			niiiOO <= 1;
			niil1i <= 1;
		end
		else if  (wire_ni0Oi_CLRN == 1'b0) 
		begin
			n000i <= 0;
			n000l <= 0;
			n000O <= 0;
			n001i <= 0;
			n001l <= 0;
			n001O <= 0;
			n00ii <= 0;
			n00il <= 0;
			n00iO <= 0;
			n00li <= 0;
			n00ll <= 0;
			n00lO <= 0;
			n00Oi <= 0;
			n00Ol <= 0;
			n00OO <= 0;
			n01ii <= 0;
			n01il <= 0;
			n01lO <= 0;
			n01Oi <= 0;
			n01Ol <= 0;
			n01OO <= 0;
			n0i1i <= 0;
			n0i1l <= 0;
			n0i1O <= 0;
			n0iiO <= 0;
			n0ill <= 0;
			n0iOl <= 0;
			n0iOO <= 0;
			n0l0l <= 0;
			n0l1i <= 0;
			n0l1l <= 0;
			n0l1O <= 0;
			n0lii <= 0;
			n0lil <= 0;
			n0liO <= 0;
			n0lli <= 0;
			n0lll <= 0;
			n0llO <= 0;
			n0lOi <= 0;
			ni00i <= 0;
			ni01l <= 0;
			ni0ii <= 0;
			ni0il <= 0;
			ni0iO <= 0;
			ni0li <= 0;
			ni0ll <= 0;
			ni0Ol <= 0;
			ni1li <= 0;
			ni1ll <= 0;
			nii0Oi <= 0;
			nii0Ol <= 0;
			nii0OO <= 0;
			niii0i <= 0;
			niii0l <= 0;
			niii0O <= 0;
			niii1i <= 0;
			niii1l <= 0;
			niii1O <= 0;
			niiiii <= 0;
			niiiil <= 0;
			niiiiO <= 0;
			niiili <= 0;
			niiill <= 0;
			niiilO <= 0;
			niiiOi <= 0;
			niiiOl <= 0;
			niiiOO <= 0;
			niil1i <= 0;
		end
		else 
		if (clk != ni0Oi_clk_prev && clk == 1'b1) 
		begin
			n000i <= tx_data_tc[3];
			n000l <= tx_data_tc[4];
			n000O <= tx_data_tc[5];
			n001i <= tx_data_tc[0];
			n001l <= tx_data_tc[1];
			n001O <= tx_data_tc[2];
			n00ii <= tx_data_tc[6];
			n00il <= tx_data_tc[7];
			n00iO <= tx_data_tc[8];
			n00li <= tx_data_tc[9];
			n00ll <= tx_data_tc[10];
			n00lO <= tx_data_tc[11];
			n00Oi <= tx_data_tc[12];
			n00Ol <= tx_data_tc[13];
			n00OO <= tx_data_tc[14];
			n01ii <= rev_loopbk;
			n01il <= wire_n01ll_dataout;
			n01lO <= tx_data_9_tc[0];
			n01Oi <= tx_data_9_tc[1];
			n01Ol <= tx_ctl_tc[0];
			n01OO <= tx_ctl_tc[1];
			n0i1i <= tx_data_tc[15];
			n0i1l <= n0lOi;
			n0i1O <= ni1ll;
			n0iiO <= ni01l;
			n0ill <= ni00i;
			n0iOl <= ni0ii;
			n0iOO <= ni0il;
			n0l0l <= ni0Ol;
			n0l1i <= ni0iO;
			n0l1l <= ni0li;
			n0l1O <= ni0ll;
			n0lii <= n0lil;
			n0lil <= rensymswap_tx;
			n0liO <= n0lli;
			n0lli <= renbitrev_tx;
			n0lll <= n0llO;
			n0llO <= (renpolinv_tx & enpolinv_tx);
			n0lOi <= wire_nii1l_dataout;
			ni00i <= wire_niill_dataout;
			ni01l <= wire_niiiO_dataout;
			ni0ii <= wire_niiOl_dataout;
			ni0il <= wire_niiOO_dataout;
			ni0iO <= wire_nil1i_dataout;
			ni0li <= wire_nil1l_dataout;
			ni0ll <= wire_nil1O_dataout;
			ni0Ol <= wire_nil0l_dataout;
			ni1li <= n01ii;
			ni1ll <= wire_nii1O_dataout;
			nii0Oi <= wire_niliO_o;
			nii0Ol <= wire_nilli_o;
			nii0OO <= wire_nilll_o;
			niii0i <= wire_nilOO_o;
			niii0l <= wire_niO1i_o;
			niii0O <= wire_niO1l_o;
			niii1i <= wire_nillO_o;
			niii1l <= wire_nilOi_o;
			niii1O <= wire_nilOl_o;
			niiiii <= wire_niO1O_o;
			niiiil <= wire_niO0i_o;
			niiiiO <= wire_niO0l_o;
			niiili <= wire_niO0O_o;
			niiill <= wire_niOii_o;
			niiilO <= wire_niOil_o;
			niiiOi <= wire_niOiO_o;
			niiiOl <= wire_niOli_o;
			niiiOO <= wire_niOll_o;
			niil1i <= wire_nilil_o;
		end
		ni0Oi_clk_prev <= clk;
	end
	assign
		wire_ni0Oi_CLRN = ((ni0Oii46 ^ ni0Oii45) & (~ rst)),
		wire_ni0Oi_PRN = (ni0O0O48 ^ ni0O0O47);
	initial
	begin
		n0i0i = 0;
		n0i0l = 0;
		n0i0O = 0;
		n0iii = 0;
		n0iil = 0;
		n0ili = 0;
		n0ilO = 0;
		n0iOi = 0;
		n0l0i = 0;
		n0l0O = 0;
		ni00l = 0;
		ni00O = 0;
		ni01i = 0;
		ni01O = 0;
		ni0lO = 0;
		ni1lO = 0;
		ni1Oi = 0;
		ni1Ol = 0;
		ni1OO = 0;
		nii1i = 0;
	end
	always @ (clk or wire_ni0OO_PRN or wire_ni0OO_CLRN)
	begin
		if (wire_ni0OO_PRN == 1'b0) 
		begin
			n0i0i <= 1;
			n0i0l <= 1;
			n0i0O <= 1;
			n0iii <= 1;
			n0iil <= 1;
			n0ili <= 1;
			n0ilO <= 1;
			n0iOi <= 1;
			n0l0i <= 1;
			n0l0O <= 1;
			ni00l <= 1;
			ni00O <= 1;
			ni01i <= 1;
			ni01O <= 1;
			ni0lO <= 1;
			ni1lO <= 1;
			ni1Oi <= 1;
			ni1Ol <= 1;
			ni1OO <= 1;
			nii1i <= 1;
		end
		else if  (wire_ni0OO_CLRN == 1'b0) 
		begin
			n0i0i <= 0;
			n0i0l <= 0;
			n0i0O <= 0;
			n0iii <= 0;
			n0iil <= 0;
			n0ili <= 0;
			n0ilO <= 0;
			n0iOi <= 0;
			n0l0i <= 0;
			n0l0O <= 0;
			ni00l <= 0;
			ni00O <= 0;
			ni01i <= 0;
			ni01O <= 0;
			ni0lO <= 0;
			ni1lO <= 0;
			ni1Oi <= 0;
			ni1Ol <= 0;
			ni1OO <= 0;
			nii1i <= 0;
		end
		else 
		if (clk != ni0OO_clk_prev && clk == 1'b1) 
		begin
			n0i0i <= ni1lO;
			n0i0l <= ni1Oi;
			n0i0O <= ni1Ol;
			n0iii <= ni1OO;
			n0iil <= ni01i;
			n0ili <= ni01O;
			n0ilO <= ni00l;
			n0iOi <= ni00O;
			n0l0i <= ni0lO;
			n0l0O <= nii1i;
			ni00l <= wire_niilO_dataout;
			ni00O <= wire_niiOi_dataout;
			ni01i <= wire_niiil_dataout;
			ni01O <= wire_niili_dataout;
			ni0lO <= wire_nil0i_dataout;
			ni1lO <= wire_nii0i_dataout;
			ni1Oi <= wire_nii0l_dataout;
			ni1Ol <= wire_nii0O_dataout;
			ni1OO <= wire_niiii_dataout;
			nii1i <= wire_nil0O_dataout;
		end
		ni0OO_clk_prev <= clk;
	end
	assign
		wire_ni0OO_CLRN = (ni0Oli42 ^ ni0Oli41),
		wire_ni0OO_PRN = ((ni0OiO44 ^ ni0OiO43) & (~ rst));
	assign		wire_n00i_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[11] : wire_ni0l_dataout;
	assign		wire_n00l_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[12] : wire_ni0O_dataout;
	assign		wire_n00O_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[13] : wire_niii_dataout;
	assign		wire_n01i_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[8] : wire_ni1l_dataout;
	assign		wire_n01l_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[9] : wire_ni1O_dataout;
	assign		wire_n01ll_dataout = (cascaded_8b10b_en === 1'b1) ? wire_nlli1i_dataout : wire_nl010O_dataout;
	assign		wire_n01O_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[10] : wire_ni0i_dataout;
	assign		wire_n0ii_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[14] : wire_niil_dataout;
	assign		wire_n0il_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[15] : wire_niiO_dataout;
	and(wire_n0iO_dataout, wire_nili_dataout, ~(nii1Ol));
	and(wire_n0li_dataout, wire_nill_dataout, ~(nii1Ol));
	and(wire_n0ll_dataout, wire_nilO_dataout, ~(nii1Ol));
	and(wire_n0lO_dataout, wire_niOi_dataout, ~(nii1Ol));
	assign		wire_n0O_dataout = (rendec_data_sel_tx === 1'b1) ? tx_ctl_tc[0] : tx_ctl_ts;
	assign		wire_n0O0i_dataout = (ib_force_disparity === 1'b1) ? (((~ n01li) & tx_data_9_tc[0]) | n01il) : wire_n0O0l_dataout;
	or(wire_n0O0l_dataout, wire_n0O0O_dataout, ((rforce_disp & (~ txd_extend_tc[0])) & tx_data_9_tc[0]));
	and(wire_n0O0O_dataout, n01il, ~(((rforce_disp & txd_extend_tc[0]) & tx_data_9_tc[0])));
	assign		wire_n0O1l_dataout = (cascaded_8b10b_en === 1'b1) ? wire_ni10i_dataout : wire_n0O0i_dataout;
	assign		wire_n0O1O_dataout = (cascaded_8b10b_en === 1'b1) ? wire_n0OOi_dataout : wire_nl010O_dataout;
	or(wire_n0Oi_dataout, wire_niOl_dataout, nii1Ol);
	and(wire_n0Ol_dataout, wire_niOO_dataout, ~(nii1Ol));
	or(wire_n0OO_dataout, wire_nl1i_dataout, nii1Ol);
	or(wire_n0OOi_dataout, wire_n0OOl_dataout, ((rforce_disp & (~ txd_extend_tc[1])) & tx_data_9_tc[1]));
	and(wire_n0OOl_dataout, wire_nl010O_dataout, ~(((rforce_disp & txd_extend_tc[1]) & tx_data_9_tc[1])));
	and(wire_n10i_dataout, tx_data_tc[12], rendec_data_sel_tx);
	and(wire_n10l_dataout, tx_data_tc[13], rendec_data_sel_tx);
	and(wire_n10O_dataout, tx_data_tc[14], rendec_data_sel_tx);
	and(wire_n11i_dataout, tx_data_tc[9], rendec_data_sel_tx);
	and(wire_n11l_dataout, tx_data_tc[10], rendec_data_sel_tx);
	and(wire_n11O_dataout, tx_data_tc[11], rendec_data_sel_tx);
	and(wire_n1ii_dataout, tx_data_tc[15], rendec_data_sel_tx);
	assign		wire_n1il_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[0] : wire_n0iO_dataout;
	assign		wire_n1iO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[1] : wire_n0li_dataout;
	assign		wire_n1li_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[2] : wire_n0ll_dataout;
	assign		wire_n1ll_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[3] : wire_n0lO_dataout;
	assign		wire_n1lO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[4] : wire_n0Oi_dataout;
	assign		wire_n1Oi_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[5] : wire_n0Ol_dataout;
	assign		wire_n1Ol_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[6] : wire_n0OO_dataout;
	assign		wire_n1OO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_data_tc[7] : wire_ni1i_dataout;
	and(wire_ni0i_dataout, wire_nl0l_dataout, ~(nii1Ol));
	and(wire_ni0l_dataout, wire_nl0O_dataout, ~(nii1Ol));
	and(wire_ni0O_dataout, wire_nlii_dataout, ~(nii1Ol));
	or(wire_ni10i_dataout, wire_ni10l_dataout, ((rforce_disp & (~ txd_extend_tc[0])) & tx_data_9_tc[0]));
	and(wire_ni10l_dataout, n01il, ~(((rforce_disp & txd_extend_tc[0]) & tx_data_9_tc[0])));
	and(wire_ni1i_dataout, wire_nl1l_dataout, ~(nii1Ol));
	and(wire_ni1l_dataout, wire_nl1O_dataout, ~(nii1Ol));
	and(wire_ni1O_dataout, wire_nl0i_dataout, ~(nii1Ol));
	and(wire_nii_dataout, tx_ctl_tc[1], rendec_data_sel_tx);
	assign		wire_nii0i_dataout = (rtxbitslip_en === 1'b1) ? wire_niil0i_o : wire_niliO_o;
	assign		wire_nii0l_dataout = (rtxbitslip_en === 1'b1) ? wire_niil0l_o : wire_nilli_o;
	assign		wire_nii0O_dataout = (rtxbitslip_en === 1'b1) ? wire_niil0O_o : wire_nilll_o;
	assign		wire_nii1l_dataout = (rtxbitslip_en === 1'b1) ? wire_niil1l_o : wire_nilii_o;
	assign		wire_nii1O_dataout = (rtxbitslip_en === 1'b1) ? wire_niil1O_o : wire_nilil_o;
	and(wire_niii_dataout, wire_nlil_dataout, ~(nii1Ol));
	assign		wire_niiii_dataout = (rtxbitslip_en === 1'b1) ? wire_niilii_o : wire_nillO_o;
	assign		wire_niiil_dataout = (rtxbitslip_en === 1'b1) ? wire_niilil_o : wire_nilOi_o;
	assign		wire_niiiO_dataout = (rtxbitslip_en === 1'b1) ? wire_niiliO_o : wire_nilOl_o;
	and(wire_niil_dataout, wire_nliO_dataout, ~(nii1Ol));
	assign		wire_niili_dataout = (rtxbitslip_en === 1'b1) ? wire_niilli_o : wire_nilOO_o;
	assign		wire_niill_dataout = (rtxbitslip_en === 1'b1) ? wire_niilll_o : wire_niO1i_o;
	assign		wire_niilO_dataout = (rtxbitslip_en === 1'b1) ? wire_niillO_o : wire_niO1l_o;
	and(wire_niiO_dataout, wire_nlli_dataout, ~(nii1Ol));
	assign		wire_niiOi_dataout = (rtxbitslip_en === 1'b1) ? wire_niilOi_o : wire_niO1O_o;
	assign		wire_niiOl_dataout = (rtxbitslip_en === 1'b1) ? wire_niilOl_o : wire_niO0i_o;
	assign		wire_niiOO_dataout = (rtxbitslip_en === 1'b1) ? wire_niilOO_o : wire_niO0l_o;
	assign		wire_nil_dataout = (cascaded_8b10b_en === 1'b1) ? tx_ctl_tc[0] : wire_nli_dataout;
	and(wire_nil00l_dataout, wire_nilOO_o, ~(ni01il));
	and(wire_nil00O_dataout, wire_niO1i_o, ~(ni01il));
	assign		wire_nil0i_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO0i_o : wire_niOiO_o;
	assign		wire_nil0l_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO0l_o : wire_niOli_o;
	assign		wire_nil0O_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO0O_o : wire_niOll_o;
	and(wire_nil0OO_dataout, wire_niOli_o, ~(ni01il));
	assign		wire_nil1i_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO1i_o : wire_niO0O_o;
	assign		wire_nil1l_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO1l_o : wire_niOii_o;
	assign		wire_nil1O_dataout = (rtxbitslip_en === 1'b1) ? wire_niiO1O_o : wire_niOil_o;
	or(wire_nili_dataout, wire_nlOii_dataout, nii1iO);
	and(wire_nili1i_dataout, wire_niOll_o, ~(ni01il));
	and(wire_niliOl_dataout, wire_niO1l_o, ni01iO);
	and(wire_niliOO_dataout, wire_niO1O_o, ni01iO);
	and(wire_nill_dataout, wire_nlOil_dataout, ~(nii1iO));
	and(wire_nill0i_dataout, wire_niOii_o, ni01iO);
	and(wire_nill0l_dataout, wire_niOil_o, ni01iO);
	and(wire_nill0O_dataout, wire_niOiO_o, ni01iO);
	and(wire_nill1i_dataout, wire_niO0i_o, ni01iO);
	and(wire_nill1l_dataout, wire_niO0l_o, ni01iO);
	and(wire_nill1O_dataout, wire_niO0O_o, ni01iO);
	and(wire_nillii_dataout, wire_niOli_o, ni01iO);
	and(wire_nillil_dataout, wire_niOll_o, ni01iO);
	or(wire_nilO_dataout, wire_nlOiO_dataout, nii1iO);
	and(wire_nilO0i_dataout, wire_nilOO_o, ~(ni01li));
	and(wire_nilO0l_dataout, wire_niO1i_o, ~(ni01li));
	and(wire_nilO0O_dataout, wire_niO1l_o, ~(ni01li));
	and(wire_nilOii_dataout, wire_niO1O_o, ~(ni01li));
	and(wire_nilOil_dataout, wire_niO0i_o, ~(ni01li));
	and(wire_nilOiO_dataout, wire_niO0l_o, ~(ni01li));
	and(wire_nilOli_dataout, wire_niO0O_o, ~(ni01li));
	and(wire_nilOll_dataout, wire_niOii_o, ~(ni01li));
	and(wire_nilOlO_dataout, wire_niOil_o, ~(ni01li));
	and(wire_nilOOi_dataout, wire_niOiO_o, ~(ni01li));
	and(wire_nilOOl_dataout, wire_niOli_o, ~(ni01li));
	and(wire_nilOOO_dataout, wire_niOll_o, ~(ni01li));
	assign		wire_niO_dataout = (cascaded_8b10b_en === 1'b1) ? tx_ctl_tc[1] : wire_nll_dataout;
	and(wire_niOi_dataout, wire_nlOli_dataout, ~(nii1iO));
	and(wire_niOl_dataout, wire_nlOll_dataout, ~(nii1iO));
	assign		wire_niOlOi_dataout = (((ni00il | ((wire_nl1iii_dataout | ni00ll) | ni00li)) | ni001i) === 1'b1) ? (~ wire_n0O1l_dataout) : wire_n0O1l_dataout;
	and(wire_niOO_dataout, wire_nlOlO_dataout, ~(nii1iO));
	assign		wire_niOOOi_dataout = (ni01OO === 1'b1) ? (~ wire_n1il_dataout) : wire_n1il_dataout;
	assign		wire_niOOOl_dataout = (ni01OO === 1'b1) ? (~ wire_nl1i0O_dataout) : wire_nl1i0O_dataout;
	assign		wire_niOOOO_dataout = (ni01OO === 1'b1) ? (~ wire_nl10OO_dataout) : wire_nl10OO_dataout;
	assign		wire_nl000i_dataout = (ni0i0i === 1'b1) ? (~ wire_n1OO_dataout) : wire_n1OO_dataout;
	assign		wire_nl000l_dataout = (ni0i0i === 1'b1) ? (~ wire_nl01iO_dataout) : wire_nl01iO_dataout;
	and(wire_nl001i_dataout, wire_n1Oi_dataout, ~(ni0i1O));
	assign		wire_nl001l_dataout = (ni0i0i === 1'b1) ? (~ wire_nl001i_dataout) : wire_nl001i_dataout;
	assign		wire_nl001O_dataout = (ni0i0i === 1'b1) ? (~ wire_nl01Ol_dataout) : wire_nl01Ol_dataout;
	assign		wire_nl00ll_dataout = (r8b10b_enc_ibm_en === 1'b1) ? ni0iii : wire_nil_dataout;
	assign		wire_nl010O_dataout = ((ni0i1i | (wire_n1OO_dataout & ni0i0O)) === 1'b1) ? (~ wire_niOlOi_dataout) : wire_niOlOi_dataout;
	or(wire_nl01iO_dataout, wire_nl01li_dataout, ni0i1O);
	and(wire_nl01li_dataout, (~ ni0i0O), ~(wire_n1OO_dataout));
	assign		wire_nl01Ol_dataout = (ni0i1i === 1'b1) ? (~ wire_n1Ol_dataout) : wire_n1Ol_dataout;
	and(wire_nl0i_dataout, wire_n11i_dataout, ~(nii1iO));
	and(wire_nl0l_dataout, wire_n11l_dataout, ~(nii1iO));
	and(wire_nl0O_dataout, wire_n11O_dataout, ~(nii1iO));
	assign		wire_nl10Ol_dataout = (ni00li === 1'b1) ? (~ wire_n1ll_dataout) : wire_n1ll_dataout;
	assign		wire_nl10OO_dataout = (((wire_n1lO_dataout & (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout))))) | ni00ll) === 1'b1) ? (~ wire_n1li_dataout) : wire_n1li_dataout;
	assign		wire_nl111i_dataout = (ni01OO === 1'b1) ? (~ wire_nl10Ol_dataout) : wire_nl10Ol_dataout;
	assign		wire_nl111l_dataout = (ni01OO === 1'b1) ? (~ ni000O) : ni000O;
	assign		wire_nl111O_dataout = (ni01OO === 1'b1) ? (~ ni001O) : ni001O;
	or(wire_nl1i_dataout, wire_nlOOi_dataout, nii1iO);
	assign		wire_nl1i0O_dataout = (ni00lO === 1'b1) ? (~ wire_n1iO_dataout) : wire_n1iO_dataout;
	assign		wire_nl1iii_dataout = (r8b10b_enc_ibm_en === 1'b1) ? ni0iii : wire_nil_dataout;
	or(wire_nl1l_dataout, wire_nlOOl_dataout, nii1iO);
	and(wire_nl1O_dataout, wire_nlOOO_dataout, ~(nii1iO));
	and(wire_nli_dataout, wire_n0O_dataout, ~(nii00O));
	assign		wire_nli0il_dataout = (ni0ilO === 1'b1) ? (~ wire_n01i_dataout) : wire_n01i_dataout;
	assign		wire_nli0iO_dataout = (ni0ilO === 1'b1) ? (~ wire_nliO1i_dataout) : wire_nliO1i_dataout;
	assign		wire_nli0li_dataout = (ni0ilO === 1'b1) ? (~ wire_nlilli_dataout) : wire_nlilli_dataout;
	assign		wire_nli0ll_dataout = (ni0ilO === 1'b1) ? (~ wire_nliliO_dataout) : wire_nliliO_dataout;
	assign		wire_nli0lO_dataout = (ni0ilO === 1'b1) ? (~ ni0l1O) : ni0l1O;
	assign		wire_nli0Oi_dataout = (ni0ilO === 1'b1) ? (~ ni0iOO) : ni0iOO;
	assign		wire_nli1il_dataout = (((ni0l0l | ((wire_nliO1l_dataout | ni0lil) | ni0lii)) | ni0iOi) === 1'b1) ? (~ wire_n0O1O_dataout) : wire_n0O1O_dataout;
	and(wire_nlii_dataout, wire_n10i_dataout, ~(nii1iO));
	and(wire_nlil_dataout, wire_n10l_dataout, ~(nii1iO));
	assign		wire_nliliO_dataout = (ni0lii === 1'b1) ? (~ wire_n00i_dataout) : wire_n00i_dataout;
	assign		wire_nlilli_dataout = (((wire_n00l_dataout & (wire_n00i_dataout & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & (~ wire_n01i_dataout))))) | ni0lil) === 1'b1) ? (~ wire_n01O_dataout) : wire_n01O_dataout;
	and(wire_nliO_dataout, wire_n10O_dataout, ~(nii1iO));
	assign		wire_nliO1i_dataout = (ni0liO === 1'b1) ? (~ wire_n01l_dataout) : wire_n01l_dataout;
	assign		wire_nliO1l_dataout = (r8b10b_enc_ibm_en === 1'b1) ? ni0O0i : wire_niO_dataout;
	and(wire_nll_dataout, wire_nii_dataout, ~(nii00O));
	and(wire_nlli_dataout, wire_n1ii_dataout, ~(nii1iO));
	or(wire_nlli0i_dataout, wire_nlli0l_dataout, ni0lOO);
	and(wire_nlli0l_dataout, (~ ni0O1O), ~(wire_n0il_dataout));
	assign		wire_nlli1i_dataout = ((ni0lOi | (wire_n0il_dataout & ni0O1O)) === 1'b1) ? (~ wire_nli1il_dataout) : wire_nli1il_dataout;
	assign		wire_nlliiO_dataout = (ni0lOi === 1'b1) ? (~ wire_n0ii_dataout) : wire_n0ii_dataout;
	and(wire_nllill_dataout, wire_n00O_dataout, ~(ni0lOO));
	assign		wire_nllilO_dataout = (ni0O1i === 1'b1) ? (~ wire_nllill_dataout) : wire_nllill_dataout;
	assign		wire_nlliOi_dataout = (ni0O1i === 1'b1) ? (~ wire_nlliiO_dataout) : wire_nlliiO_dataout;
	assign		wire_nlliOl_dataout = (ni0O1i === 1'b1) ? (~ wire_n0il_dataout) : wire_n0il_dataout;
	assign		wire_nlliOO_dataout = (ni0O1i === 1'b1) ? (~ wire_nlli0i_dataout) : wire_nlli0i_dataout;
	assign		wire_nlll0O_dataout = (r8b10b_enc_ibm_en === 1'b1) ? ni0O0i : wire_niO_dataout;
	assign		wire_nlOii_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[0] : tx_data_ts[0];
	assign		wire_nlOil_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[1] : tx_data_ts[1];
	assign		wire_nlOiO_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[2] : tx_data_ts[2];
	assign		wire_nlOli_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[3] : tx_data_ts[3];
	assign		wire_nlOll_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[4] : tx_data_ts[4];
	assign		wire_nlOlO_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[5] : tx_data_ts[5];
	assign		wire_nlOOi_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[6] : tx_data_ts[6];
	assign		wire_nlOOl_dataout = (rendec_data_sel_tx === 1'b1) ? tx_data_tc[7] : tx_data_ts[7];
	and(wire_nlOOO_dataout, tx_data_tc[8], rendec_data_sel_tx);
	oper_decoder   nili1O
	( 
	.i({tx_boundary_sel[4:0]}),
	.o(wire_nili1O_o));
	defparam
		nili1O.width_i = 5,
		nili1O.width_o = 32;
	oper_decoder   nillli
	( 
	.i({tx_boundary_sel[3:0]}),
	.o(wire_nillli_o));
	defparam
		nillli.width_i = 4,
		nillli.width_o = 16;
	oper_mux   n010i
	( 
	.data({{4{tx_data_pg[17]}}, rev_loop_data[17], wire_nlliOi_dataout, tx_data_pg[17], wire_nlliOi_dataout, {4{tx_data_pg[17]}}, rev_loop_data[17], tx_data_tc[15], tx_data_pg[17], tx_data_tc[15]}),
	.o(wire_n010i_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n010i.width_data = 16,
		n010i.width_sel = 4;
	oper_mux   n010l
	( 
	.data({{4{tx_data_pg[18]}}, rev_loop_data[18], wire_nlliOl_dataout, tx_data_pg[18], wire_nlliOl_dataout, {4{tx_data_pg[18]}}, rev_loop_data[18], tx_ctl_tc[1], tx_data_pg[18], tx_ctl_tc[1]}),
	.o(wire_n010l_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n010l.width_data = 16,
		n010l.width_sel = 4;
	oper_mux   n010O
	( 
	.data({{4{tx_data_pg[19]}}, rev_loop_data[19], wire_nlliOO_dataout, tx_data_pg[19], wire_nlliOO_dataout, {4{tx_data_pg[19]}}, rev_loop_data[19], tx_data_9_tc[1], tx_data_pg[19], tx_data_9_tc[1]}),
	.o(wire_n010O_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n010O.width_data = 16,
		n010O.width_sel = 4;
	oper_mux   n011i
	( 
	.data({{4{tx_data_pg[14]}}, rev_loop_data[14], wire_nli0lO_dataout, tx_data_pg[14], wire_nli0lO_dataout, {4{tx_data_pg[14]}}, rev_loop_data[14], tx_data_tc[12], tx_data_pg[14], tx_data_tc[12]}),
	.o(wire_n011i_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n011i.width_data = 16,
		n011i.width_sel = 4;
	oper_mux   n011l
	( 
	.data({{4{tx_data_pg[15]}}, rev_loop_data[15], wire_nli0Oi_dataout, tx_data_pg[15], wire_nli0Oi_dataout, {4{tx_data_pg[15]}}, rev_loop_data[15], tx_data_tc[13], tx_data_pg[15], tx_data_tc[13]}),
	.o(wire_n011l_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n011l.width_data = 16,
		n011l.width_sel = 4;
	oper_mux   n011O
	( 
	.data({{4{tx_data_pg[16]}}, rev_loop_data[16], wire_nllilO_dataout, tx_data_pg[16], wire_nllilO_dataout, {4{tx_data_pg[16]}}, rev_loop_data[16], tx_data_tc[14], tx_data_pg[16], tx_data_tc[14]}),
	.o(wire_n011O_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n011O.width_data = 16,
		n011O.width_sel = 4;
	oper_mux   n1O0i
	( 
	.data({{4{tx_data_pg[2]}}, rev_loop_data[2], wire_niOOOO_dataout, tx_data_pg[2], wire_niOOOO_dataout, {4{tx_data_pg[2]}}, rev_loop_data[2], tx_data_tc[2], tx_data_pg[2], tx_data_tc[2]}),
	.o(wire_n1O0i_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1O0i.width_data = 16,
		n1O0i.width_sel = 4;
	oper_mux   n1O0l
	( 
	.data({{4{tx_data_pg[3]}}, rev_loop_data[3], wire_nl111i_dataout, tx_data_pg[3], wire_nl111i_dataout, {4{tx_data_pg[3]}}, rev_loop_data[3], tx_data_tc[3], tx_data_pg[3], tx_data_tc[3]}),
	.o(wire_n1O0l_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1O0l.width_data = 16,
		n1O0l.width_sel = 4;
	oper_mux   n1O0O
	( 
	.data({{4{tx_data_pg[4]}}, rev_loop_data[4], wire_nl111l_dataout, tx_data_pg[4], wire_nl111l_dataout, {4{tx_data_pg[4]}}, rev_loop_data[4], tx_data_tc[4], tx_data_pg[4], tx_data_tc[4]}),
	.o(wire_n1O0O_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1O0O.width_data = 16,
		n1O0O.width_sel = 4;
	oper_mux   n1O1l
	( 
	.data({{4{tx_data_pg[0]}}, rev_loop_data[0], wire_niOOOi_dataout, tx_data_pg[0], wire_niOOOi_dataout, {4{tx_data_pg[0]}}, rev_loop_data[0], tx_data_tc[0], tx_data_pg[0], tx_data_tc[0]}),
	.o(wire_n1O1l_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1O1l.width_data = 16,
		n1O1l.width_sel = 4;
	oper_mux   n1O1O
	( 
	.data({{4{tx_data_pg[1]}}, rev_loop_data[1], wire_niOOOl_dataout, tx_data_pg[1], wire_niOOOl_dataout, {4{tx_data_pg[1]}}, rev_loop_data[1], tx_data_tc[1], tx_data_pg[1], tx_data_tc[1]}),
	.o(wire_n1O1O_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1O1O.width_data = 16,
		n1O1O.width_sel = 4;
	oper_mux   n1Oii
	( 
	.data({{4{tx_data_pg[5]}}, rev_loop_data[5], wire_nl111O_dataout, tx_data_pg[5], wire_nl111O_dataout, {4{tx_data_pg[5]}}, rev_loop_data[5], tx_data_tc[5], tx_data_pg[5], tx_data_tc[5]}),
	.o(wire_n1Oii_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1Oii.width_data = 16,
		n1Oii.width_sel = 4;
	oper_mux   n1Oil
	( 
	.data({{4{tx_data_pg[6]}}, rev_loop_data[6], wire_nl001l_dataout, tx_data_pg[6], wire_nl001l_dataout, {4{tx_data_pg[6]}}, rev_loop_data[6], tx_data_tc[6], tx_data_pg[6], tx_data_tc[6]}),
	.o(wire_n1Oil_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1Oil.width_data = 16,
		n1Oil.width_sel = 4;
	oper_mux   n1OiO
	( 
	.data({{4{tx_data_pg[7]}}, rev_loop_data[7], wire_nl001O_dataout, tx_data_pg[7], wire_nl001O_dataout, {4{tx_data_pg[7]}}, rev_loop_data[7], tx_data_tc[7], tx_data_pg[7], tx_data_tc[7]}),
	.o(wire_n1OiO_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1OiO.width_data = 16,
		n1OiO.width_sel = 4;
	oper_mux   n1Oli
	( 
	.data({{4{tx_data_pg[8]}}, rev_loop_data[8], wire_nl000i_dataout, tx_data_pg[8], wire_nl000i_dataout, {4{tx_data_pg[8]}}, rev_loop_data[8], tx_ctl_tc[1], tx_data_pg[8], tx_ctl_tc[0]}),
	.o(wire_n1Oli_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1Oli.width_data = 16,
		n1Oli.width_sel = 4;
	oper_mux   n1Oll
	( 
	.data({{4{tx_data_pg[9]}}, rev_loop_data[9], wire_nl000l_dataout, tx_data_pg[9], wire_nl000l_dataout, {4{tx_data_pg[9]}}, rev_loop_data[9], tx_data_9_tc[0], tx_data_pg[9], tx_data_9_tc[0]}),
	.o(wire_n1Oll_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1Oll.width_data = 16,
		n1Oll.width_sel = 4;
	oper_mux   n1OlO
	( 
	.data({{4{tx_data_pg[10]}}, rev_loop_data[10], wire_nli0il_dataout, tx_data_pg[10], wire_nli0il_dataout, {4{tx_data_pg[10]}}, rev_loop_data[10], tx_data_tc[8], tx_data_pg[10], tx_data_tc[8]}),
	.o(wire_n1OlO_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1OlO.width_data = 16,
		n1OlO.width_sel = 4;
	oper_mux   n1OOi
	( 
	.data({{4{tx_data_pg[11]}}, rev_loop_data[11], wire_nli0iO_dataout, tx_data_pg[11], wire_nli0iO_dataout, {4{tx_data_pg[11]}}, rev_loop_data[11], tx_data_tc[9], tx_data_pg[11], tx_data_tc[9]}),
	.o(wire_n1OOi_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1OOi.width_data = 16,
		n1OOi.width_sel = 4;
	oper_mux   n1OOl
	( 
	.data({{4{tx_data_pg[12]}}, rev_loop_data[12], wire_nli0li_dataout, tx_data_pg[12], wire_nli0li_dataout, {4{tx_data_pg[12]}}, rev_loop_data[12], tx_data_tc[10], tx_data_pg[12], tx_data_tc[10]}),
	.o(wire_n1OOl_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1OOl.width_data = 16,
		n1OOl.width_sel = 4;
	oper_mux   n1OOO
	( 
	.data({{4{tx_data_pg[13]}}, rev_loop_data[13], wire_nli0ll_dataout, tx_data_pg[13], wire_nli0ll_dataout, {4{tx_data_pg[13]}}, rev_loop_data[13], tx_data_tc[11], tx_data_pg[13], tx_data_tc[11]}),
	.o(wire_n1OOO_o),
	.sel({endec, prbs_en, rrev_loopbk, ni1li}));
	defparam
		n1OOO.width_data = 16,
		n1OOO.width_sel = 4;
	oper_mux   niil0i
	( 
	.data({wire_niiOiO_o, wire_nil1Ol_o, wire_nili0O_o, wire_nillOi_o}),
	.o(wire_niil0i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niil0i.width_data = 4,
		niil0i.width_sel = 2;
	oper_mux   niil0l
	( 
	.data({wire_niiOli_o, wire_nil1OO_o, wire_niliii_o, wire_nillOl_o}),
	.o(wire_niil0l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niil0l.width_data = 4,
		niil0l.width_sel = 2;
	oper_mux   niil0O
	( 
	.data({wire_niiOll_o, wire_nil01i_o, wire_niliil_o, wire_nillOO_o}),
	.o(wire_niil0O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niil0O.width_data = 4,
		niil0O.width_sel = 2;
	oper_mux   niil1l
	( 
	.data({wire_niiOii_o, wire_nil1lO_o, wire_nili0i_o, wire_nillll_o}),
	.o(wire_niil1l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niil1l.width_data = 4,
		niil1l.width_sel = 2;
	oper_mux   niil1O
	( 
	.data({wire_niiOil_o, wire_nil1Oi_o, wire_nili0l_o, wire_nilllO_o}),
	.o(wire_niil1O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niil1O.width_data = 4,
		niil1O.width_sel = 2;
	oper_mux   niilii
	( 
	.data({wire_niiOlO_o, wire_nil01l_o, wire_niliiO_o, wire_nilO1i_o}),
	.o(wire_niilii_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilii.width_data = 4,
		niilii.width_sel = 2;
	oper_mux   niilil
	( 
	.data({wire_niiOOi_o, wire_nil01O_o, wire_nilili_o, wire_nilO1l_o}),
	.o(wire_niilil_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilil.width_data = 4,
		niilil.width_sel = 2;
	oper_mux   niiliO
	( 
	.data({wire_niiOOl_o, wire_nil00i_o, wire_nilill_o, wire_nilO1O_o}),
	.o(wire_niiliO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiliO.width_data = 4,
		niiliO.width_sel = 2;
	oper_mux   niilli
	( 
	.data({wire_niiOOO_o, wire_nil00l_dataout, wire_nililO_o, wire_nilO0i_dataout}),
	.o(wire_niilli_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilli.width_data = 4,
		niilli.width_sel = 2;
	oper_mux   niilll
	( 
	.data({wire_nil11i_o, wire_nil00O_dataout, wire_niliOi_o, wire_nilO0l_dataout}),
	.o(wire_niilll_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilll.width_data = 4,
		niilll.width_sel = 2;
	oper_mux   niillO
	( 
	.data({wire_nil11l_o, wire_nil0ii_o, wire_niliOl_dataout, wire_nilO0O_dataout}),
	.o(wire_niillO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niillO.width_data = 4,
		niillO.width_sel = 2;
	oper_mux   niilOi
	( 
	.data({wire_nil11O_o, wire_nil0il_o, wire_niliOO_dataout, wire_nilOii_dataout}),
	.o(wire_niilOi_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilOi.width_data = 4,
		niilOi.width_sel = 2;
	oper_mux   niilOl
	( 
	.data({wire_nil10i_o, wire_nil0iO_o, wire_nill1i_dataout, wire_nilOil_dataout}),
	.o(wire_niilOl_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilOl.width_data = 4,
		niilOl.width_sel = 2;
	oper_mux   niilOO
	( 
	.data({wire_nil10l_o, wire_nil0li_o, wire_nill1l_dataout, wire_nilOiO_dataout}),
	.o(wire_niilOO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niilOO.width_data = 4,
		niilOO.width_sel = 2;
	oper_mux   niiO0i
	( 
	.data({wire_nil1iO_o, wire_nil0Ol_o, wire_nill0O_dataout, wire_nilOOi_dataout}),
	.o(wire_niiO0i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO0i.width_data = 4,
		niiO0i.width_sel = 2;
	oper_mux   niiO0l
	( 
	.data({wire_nil1li_o, wire_nil0OO_dataout, wire_nillii_dataout, wire_nilOOl_dataout}),
	.o(wire_niiO0l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO0l.width_data = 4,
		niiO0l.width_sel = 2;
	oper_mux   niiO0O
	( 
	.data({wire_nil1ll_o, wire_nili1i_dataout, wire_nillil_dataout, wire_nilOOO_dataout}),
	.o(wire_niiO0O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO0O.width_data = 4,
		niiO0O.width_sel = 2;
	oper_mux   niiO1i
	( 
	.data({wire_nil10O_o, wire_nil0ll_o, wire_nill1O_dataout, wire_nilOli_dataout}),
	.o(wire_niiO1i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO1i.width_data = 4,
		niiO1i.width_sel = 2;
	oper_mux   niiO1l
	( 
	.data({wire_nil1ii_o, wire_nil0lO_o, wire_nill0i_dataout, wire_nilOll_dataout}),
	.o(wire_niiO1l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO1l.width_data = 4,
		niiO1l.width_sel = 2;
	oper_mux   niiO1O
	( 
	.data({wire_nil1il_o, wire_nil0Oi_o, wire_nill0l_dataout, wire_nilOlO_dataout}),
	.o(wire_niiO1O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niiO1O.width_data = 4,
		niiO1O.width_sel = 2;
	oper_mux   niiOii
	( 
	.data({{12{wire_nilii_o}}, niil1i, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o}),
	.o(wire_niiOii_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOii.width_data = 32,
		niiOii.width_sel = 5;
	oper_mux   niiOil
	( 
	.data({{12{wire_nilil_o}}, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o}),
	.o(wire_niiOil_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOil.width_data = 32,
		niiOil.width_sel = 5;
	oper_mux   niiOiO
	( 
	.data({{12{wire_niliO_o}}, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o}),
	.o(wire_niiOiO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOiO.width_data = 32,
		niiOiO.width_sel = 5;
	oper_mux   niiOli
	( 
	.data({{12{wire_nilli_o}}, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o}),
	.o(wire_niiOli_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOli.width_data = 32,
		niiOli.width_sel = 5;
	oper_mux   niiOll
	( 
	.data({{12{wire_nilll_o}}, niii1i, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o}),
	.o(wire_niiOll_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOll.width_data = 32,
		niiOll.width_sel = 5;
	oper_mux   niiOlO
	( 
	.data({{12{wire_nillO_o}}, niii1l, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o}),
	.o(wire_niiOlO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOlO.width_data = 32,
		niiOlO.width_sel = 5;
	oper_mux   niiOOi
	( 
	.data({{12{wire_nilOi_o}}, niii1O, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o}),
	.o(wire_niiOOi_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOOi.width_data = 32,
		niiOOi.width_sel = 5;
	oper_mux   niiOOl
	( 
	.data({{12{wire_nilOl_o}}, niii0i, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o}),
	.o(wire_niiOOl_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOOl.width_data = 32,
		niiOOl.width_sel = 5;
	oper_mux   niiOOO
	( 
	.data({{12{wire_nilOO_o}}, niii0l, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o}),
	.o(wire_niiOOO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		niiOOO.width_data = 32,
		niiOOO.width_sel = 5;
	oper_mux   nil00i
	( 
	.data({{16{wire_nilOl_o}}, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o}),
	.o(wire_nil00i_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil00i.width_data = 32,
		nil00i.width_sel = 5;
	oper_mux   nil01i
	( 
	.data({{16{wire_nilll_o}}, niii1i, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o}),
	.o(wire_nil01i_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil01i.width_data = 32,
		nil01i.width_sel = 5;
	oper_mux   nil01l
	( 
	.data({{16{wire_nillO_o}}, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o}),
	.o(wire_nil01l_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil01l.width_data = 32,
		nil01l.width_sel = 5;
	oper_mux   nil01O
	( 
	.data({{16{wire_nilOi_o}}, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o}),
	.o(wire_nil01O_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil01O.width_data = 32,
		nil01O.width_sel = 5;
	oper_mux   nil0ii
	( 
	.data({{16{wire_niO1l_o}}, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o}),
	.o(wire_nil0ii_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0ii.width_data = 32,
		nil0ii.width_sel = 5;
	oper_mux   nil0il
	( 
	.data({{16{wire_niO1O_o}}, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o}),
	.o(wire_nil0il_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0il.width_data = 32,
		nil0il.width_sel = 5;
	oper_mux   nil0iO
	( 
	.data({{16{wire_niO0i_o}}, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o}),
	.o(wire_nil0iO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0iO.width_data = 32,
		nil0iO.width_sel = 5;
	oper_mux   nil0li
	( 
	.data({{16{wire_niO0l_o}}, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o}),
	.o(wire_nil0li_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0li.width_data = 32,
		nil0li.width_sel = 5;
	oper_mux   nil0ll
	( 
	.data({{16{wire_niO0O_o}}, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o}),
	.o(wire_nil0ll_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0ll.width_data = 32,
		nil0ll.width_sel = 5;
	oper_mux   nil0lO
	( 
	.data({{16{wire_niOii_o}}, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o}),
	.o(wire_nil0lO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0lO.width_data = 32,
		nil0lO.width_sel = 5;
	oper_mux   nil0Oi
	( 
	.data({{16{wire_niOil_o}}, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o}),
	.o(wire_nil0Oi_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0Oi.width_data = 32,
		nil0Oi.width_sel = 5;
	oper_mux   nil0Ol
	( 
	.data({{16{wire_niOiO_o}}, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o, wire_niOiO_o}),
	.o(wire_nil0Ol_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil0Ol.width_data = 32,
		nil0Ol.width_sel = 5;
	oper_mux   nil10i
	( 
	.data({{12{wire_niO0i_o}}, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o}),
	.o(wire_nil10i_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil10i.width_data = 32,
		nil10i.width_sel = 5;
	oper_mux   nil10l
	( 
	.data({{12{wire_niO0l_o}}, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o}),
	.o(wire_nil10l_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil10l.width_data = 32,
		nil10l.width_sel = 5;
	oper_mux   nil10O
	( 
	.data({{12{wire_niO0O_o}}, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o}),
	.o(wire_nil10O_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil10O.width_data = 32,
		nil10O.width_sel = 5;
	oper_mux   nil11i
	( 
	.data({{12{wire_niO1i_o}}, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o}),
	.o(wire_nil11i_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil11i.width_data = 32,
		nil11i.width_sel = 5;
	oper_mux   nil11l
	( 
	.data({{12{wire_niO1l_o}}, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o}),
	.o(wire_nil11l_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil11l.width_data = 32,
		nil11l.width_sel = 5;
	oper_mux   nil11O
	( 
	.data({{12{wire_niO1O_o}}, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o}),
	.o(wire_nil11O_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil11O.width_data = 32,
		nil11O.width_sel = 5;
	oper_mux   nil1ii
	( 
	.data({{12{wire_niOii_o}}, niiilO, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o}),
	.o(wire_nil1ii_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1ii.width_data = 32,
		nil1ii.width_sel = 5;
	oper_mux   nil1il
	( 
	.data({{12{wire_niOil_o}}, niiiOi, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o}),
	.o(wire_nil1il_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1il.width_data = 32,
		nil1il.width_sel = 5;
	oper_mux   nil1iO
	( 
	.data({{12{wire_niOiO_o}}, niiiOl, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o, wire_niOiO_o}),
	.o(wire_nil1iO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1iO.width_data = 32,
		nil1iO.width_sel = 5;
	oper_mux   nil1li
	( 
	.data({{12{wire_niOli_o}}, niiiOO, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o, wire_niOiO_o, wire_niOli_o}),
	.o(wire_nil1li_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1li.width_data = 32,
		nil1li.width_sel = 5;
	oper_mux   nil1ll
	( 
	.data({{12{wire_niOll_o}}, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o, wire_niO1l_o, wire_niO1O_o, wire_niO0i_o, wire_niO0l_o, wire_niO0O_o, wire_niOii_o, wire_niOil_o, wire_niOiO_o, wire_niOli_o, wire_niOll_o}),
	.o(wire_nil1ll_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1ll.width_data = 32,
		nil1ll.width_sel = 5;
	oper_mux   nil1lO
	( 
	.data({{16{wire_nilii_o}}, niil1i, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o}),
	.o(wire_nil1lO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1lO.width_data = 32,
		nil1lO.width_sel = 5;
	oper_mux   nil1Oi
	( 
	.data({{16{wire_nilil_o}}, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o}),
	.o(wire_nil1Oi_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1Oi.width_data = 32,
		nil1Oi.width_sel = 5;
	oper_mux   nil1Ol
	( 
	.data({{16{wire_niliO_o}}, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o}),
	.o(wire_nil1Ol_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1Ol.width_data = 32,
		nil1Ol.width_sel = 5;
	oper_mux   nil1OO
	( 
	.data({{16{wire_nilli_o}}, nii0OO, niii1i, niii1l, niii1O, niii0O, niiiii, niiiil, niiiiO, niiili, niiill, niiilO, niiiOi, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o}),
	.o(wire_nil1OO_o),
	.sel({tx_boundary_sel[4:0]}));
	defparam
		nil1OO.width_data = 32,
		nil1OO.width_sel = 5;
	oper_mux   nili0i
	( 
	.data({{6{wire_nilii_o}}, niil1i, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, wire_nilii_o}),
	.o(wire_nili0i_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nili0i.width_data = 16,
		nili0i.width_sel = 4;
	oper_mux   nili0l
	( 
	.data({{6{wire_nilil_o}}, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o}),
	.o(wire_nili0l_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nili0l.width_data = 16,
		nili0l.width_sel = 4;
	oper_mux   nili0O
	( 
	.data({{6{wire_niliO_o}}, nii0Ol, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o}),
	.o(wire_nili0O_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nili0O.width_data = 16,
		nili0O.width_sel = 4;
	oper_mux   nilii
	( 
	.data({wire_niOlO_o, wire_nl01l_o, wire_nliii_o, wire_nlllO_o}),
	.o(wire_nilii_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilii.width_data = 4,
		nilii.width_sel = 2;
	oper_mux   niliii
	( 
	.data({{6{wire_nilli_o}}, nii0OO, niii1i, niii1l, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o}),
	.o(wire_niliii_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		niliii.width_data = 16,
		niliii.width_sel = 4;
	oper_mux   niliil
	( 
	.data({{6{wire_nilll_o}}, niii1i, niii1l, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o}),
	.o(wire_niliil_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		niliil.width_data = 16,
		niliil.width_sel = 4;
	oper_mux   niliiO
	( 
	.data({{6{wire_nillO_o}}, niii1l, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o}),
	.o(wire_niliiO_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		niliiO.width_data = 16,
		niliiO.width_sel = 4;
	oper_mux   nilil
	( 
	.data({wire_niOOi_o, wire_nl01O_o, wire_nliil_o, wire_nllOi_o}),
	.o(wire_nilil_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilil.width_data = 4,
		nilil.width_sel = 2;
	oper_mux   nilili
	( 
	.data({{6{wire_nilOi_o}}, niii1O, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o}),
	.o(wire_nilili_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilili.width_data = 16,
		nilili.width_sel = 4;
	oper_mux   nilill
	( 
	.data({{6{wire_nilOl_o}}, niii0i, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o}),
	.o(wire_nilill_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilill.width_data = 16,
		nilill.width_sel = 4;
	oper_mux   nililO
	( 
	.data({{6{wire_nilOO_o}}, niii0l, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o}),
	.o(wire_nililO_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nililO.width_data = 16,
		nililO.width_sel = 4;
	oper_mux   niliO
	( 
	.data({wire_niOOl_o, wire_nl00i_o, wire_nliiO_o, wire_nllOl_o}),
	.o(wire_niliO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niliO.width_data = 4,
		niliO.width_sel = 2;
	oper_mux   niliOi
	( 
	.data({{6{wire_niO1i_o}}, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o, wire_nilOO_o, wire_niO1i_o}),
	.o(wire_niliOi_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		niliOi.width_data = 16,
		niliOi.width_sel = 4;
	oper_mux   nilli
	( 
	.data({wire_niOOO_o, wire_nl00l_o, wire_nlili_o, wire_nllOO_o}),
	.o(wire_nilli_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilli.width_data = 4,
		nilli.width_sel = 2;
	oper_mux   nilll
	( 
	.data({wire_nl11i_o, wire_nl00O_o, wire_nlill_o, wire_nlO1i_o}),
	.o(wire_nilll_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilll.width_data = 4,
		nilll.width_sel = 2;
	oper_mux   nillll
	( 
	.data({{8{wire_nilii_o}}, niil1i, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, wire_nilii_o}),
	.o(wire_nillll_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nillll.width_data = 16,
		nillll.width_sel = 4;
	oper_mux   nilllO
	( 
	.data({{8{wire_nilil_o}}, nii0Oi, nii0Ol, nii0OO, niii1i, niii1l, niii1O, wire_nilii_o, wire_nilil_o}),
	.o(wire_nilllO_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilllO.width_data = 16,
		nilllO.width_sel = 4;
	oper_mux   nillO
	( 
	.data({wire_nl11l_o, wire_nl0ii_o, wire_nlilO_o, wire_nlO1l_o}),
	.o(wire_nillO_o),
	.sel({doublewidth, dwidth}));
	defparam
		nillO.width_data = 4,
		nillO.width_sel = 2;
	oper_mux   nillOi
	( 
	.data({{8{wire_niliO_o}}, nii0Ol, nii0OO, niii1i, niii1l, niii1O, wire_nilii_o, wire_nilil_o, wire_niliO_o}),
	.o(wire_nillOi_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nillOi.width_data = 16,
		nillOi.width_sel = 4;
	oper_mux   nillOl
	( 
	.data({{8{wire_nilli_o}}, nii0OO, niii1i, niii1l, niii1O, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o}),
	.o(wire_nillOl_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nillOl.width_data = 16,
		nillOl.width_sel = 4;
	oper_mux   nillOO
	( 
	.data({{8{wire_nilll_o}}, niii1i, niii1l, niii1O, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o}),
	.o(wire_nillOO_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nillOO.width_data = 16,
		nillOO.width_sel = 4;
	oper_mux   nilO1i
	( 
	.data({{8{wire_nillO_o}}, niii1l, niii1O, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o}),
	.o(wire_nilO1i_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilO1i.width_data = 16,
		nilO1i.width_sel = 4;
	oper_mux   nilO1l
	( 
	.data({{8{wire_nilOi_o}}, niii1O, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o}),
	.o(wire_nilO1l_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilO1l.width_data = 16,
		nilO1l.width_sel = 4;
	oper_mux   nilO1O
	( 
	.data({{8{wire_nilOl_o}}, wire_nilii_o, wire_nilil_o, wire_niliO_o, wire_nilli_o, wire_nilll_o, wire_nillO_o, wire_nilOi_o, wire_nilOl_o}),
	.o(wire_nilO1O_o),
	.sel({tx_boundary_sel[3:0]}));
	defparam
		nilO1O.width_data = 16,
		nilO1O.width_sel = 4;
	oper_mux   nilOi
	( 
	.data({wire_nl11O_o, wire_nl0il_o, wire_nliOi_o, wire_nlO1O_o}),
	.o(wire_nilOi_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilOi.width_data = 4,
		nilOi.width_sel = 2;
	oper_mux   nilOl
	( 
	.data({wire_nl10i_o, wire_nl0iO_o, wire_nliOl_o, wire_nlO0i_o}),
	.o(wire_nilOl_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilOl.width_data = 4,
		nilOl.width_sel = 2;
	oper_mux   nilOO
	( 
	.data({wire_nl10l_o, wire_nl0li_o, wire_nliOO_o, wire_nlO0l_o}),
	.o(wire_nilOO_o),
	.sel({doublewidth, dwidth}));
	defparam
		nilOO.width_data = 4,
		nilOO.width_sel = 2;
	oper_mux   niO0i
	( 
	.data({wire_nl1iO_o, wire_nl0Ol_o, {2{wire_nll0i_o}}}),
	.o(wire_niO0i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO0i.width_data = 4,
		niO0i.width_sel = 2;
	oper_mux   niO0l
	( 
	.data({wire_nl1li_o, wire_nl0OO_o, {2{wire_nll0l_o}}}),
	.o(wire_niO0l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO0l.width_data = 4,
		niO0l.width_sel = 2;
	oper_mux   niO0O
	( 
	.data({wire_nl1ll_o, wire_nli1i_o, {2{wire_nll0O_o}}}),
	.o(wire_niO0O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO0O.width_data = 4,
		niO0O.width_sel = 2;
	oper_mux   niO1i
	( 
	.data({wire_nl10O_o, wire_nl0ll_o, wire_nll1i_o, wire_nlO0O_o}),
	.o(wire_niO1i_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO1i.width_data = 4,
		niO1i.width_sel = 2;
	oper_mux   niO1l
	( 
	.data({wire_nl1ii_o, wire_nl0lO_o, {2{wire_nll1l_o}}}),
	.o(wire_niO1l_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO1l.width_data = 4,
		niO1l.width_sel = 2;
	oper_mux   niO1O
	( 
	.data({wire_nl1il_o, wire_nl0Oi_o, {2{wire_nll1O_o}}}),
	.o(wire_niO1O_o),
	.sel({doublewidth, dwidth}));
	defparam
		niO1O.width_data = 4,
		niO1O.width_sel = 2;
	oper_mux   niOii
	( 
	.data({wire_nl1lO_o, wire_nli1l_o, {2{wire_nllii_o}}}),
	.o(wire_niOii_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOii.width_data = 4,
		niOii.width_sel = 2;
	oper_mux   niOil
	( 
	.data({wire_nl1Oi_o, wire_nli1O_o, {2{wire_nllil_o}}}),
	.o(wire_niOil_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOil.width_data = 4,
		niOil.width_sel = 2;
	oper_mux   niOiO
	( 
	.data({wire_nl1Ol_o, wire_nli0i_o, {2{wire_nlliO_o}}}),
	.o(wire_niOiO_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOiO.width_data = 4,
		niOiO.width_sel = 2;
	oper_mux   niOli
	( 
	.data({wire_nl1OO_o, wire_nli0l_o, {2{wire_nllli_o}}}),
	.o(wire_niOli_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOli.width_data = 4,
		niOli.width_sel = 2;
	oper_mux   niOll
	( 
	.data({wire_nl01i_o, wire_nli0O_o, {2{wire_nllll_o}}}),
	.o(wire_niOll_o),
	.sel({doublewidth, dwidth}));
	defparam
		niOll.width_data = 4,
		niOll.width_sel = 2;
	oper_mux   niOlO
	( 
	.data({(~ wire_n1Oll_o), (~ wire_n010O_o), (~ wire_n1OlO_o), (~ wire_n1O1l_o), wire_n1Oll_o, wire_n010O_o, wire_n1OlO_o, wire_n1O1l_o}),
	.o(wire_niOlO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		niOlO.width_data = 8,
		niOlO.width_sel = 3;
	oper_mux   niOOi
	( 
	.data({(~ wire_n1Oli_o), (~ wire_n010l_o), (~ wire_n1OOi_o), (~ wire_n1O1O_o), wire_n1Oli_o, wire_n010l_o, wire_n1OOi_o, wire_n1O1O_o}),
	.o(wire_niOOi_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		niOOi.width_data = 8,
		niOOi.width_sel = 3;
	oper_mux   niOOl
	( 
	.data({(~ wire_n1OiO_o), (~ wire_n010i_o), (~ wire_n1OOl_o), (~ wire_n1O0i_o), wire_n1OiO_o, wire_n010i_o, wire_n1OOl_o, wire_n1O0i_o}),
	.o(wire_niOOl_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		niOOl.width_data = 8,
		niOOl.width_sel = 3;
	oper_mux   niOOO
	( 
	.data({(~ wire_n1Oil_o), (~ wire_n011O_o), (~ wire_n1OOO_o), (~ wire_n1O0l_o), wire_n1Oil_o, wire_n011O_o, wire_n1OOO_o, wire_n1O0l_o}),
	.o(wire_niOOO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		niOOO.width_data = 8,
		niOOO.width_sel = 3;
	oper_mux   nl00i
	( 
	.data({(~ wire_n1Oii_o), (~ wire_n011l_o), (~ wire_n1OOl_o), (~ wire_n1O0i_o), wire_n1Oii_o, wire_n011l_o, wire_n1OOl_o, wire_n1O0i_o}),
	.o(wire_nl00i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl00i.width_data = 8,
		nl00i.width_sel = 3;
	oper_mux   nl00l
	( 
	.data({(~ wire_n1O0O_o), (~ wire_n011i_o), (~ wire_n1OOO_o), (~ wire_n1O0l_o), wire_n1O0O_o, wire_n011i_o, wire_n1OOO_o, wire_n1O0l_o}),
	.o(wire_nl00l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl00l.width_data = 8,
		nl00l.width_sel = 3;
	oper_mux   nl00O
	( 
	.data({(~ wire_n1O0l_o), (~ wire_n1OOO_o), (~ wire_n011i_o), (~ wire_n1O0O_o), wire_n1O0l_o, wire_n1OOO_o, wire_n011i_o, wire_n1O0O_o}),
	.o(wire_nl00O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl00O.width_data = 8,
		nl00O.width_sel = 3;
	oper_mux   nl01i
	( 
	.data({(~ wire_n1OlO_o), (~ wire_n1O1l_o), (~ wire_n1Oll_o), (~ wire_n010O_o), wire_n1OlO_o, wire_n1O1l_o, wire_n1Oll_o, wire_n010O_o}),
	.o(wire_nl01i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl01i.width_data = 8,
		nl01i.width_sel = 3;
	oper_mux   nl01l
	( 
	.data({(~ wire_n1OiO_o), (~ wire_n010i_o), (~ wire_n1OlO_o), (~ wire_n1O1l_o), wire_n1OiO_o, wire_n010i_o, wire_n1OlO_o, wire_n1O1l_o}),
	.o(wire_nl01l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl01l.width_data = 8,
		nl01l.width_sel = 3;
	oper_mux   nl01O
	( 
	.data({(~ wire_n1Oil_o), (~ wire_n011O_o), (~ wire_n1OOi_o), (~ wire_n1O1O_o), wire_n1Oil_o, wire_n011O_o, wire_n1OOi_o, wire_n1O1O_o}),
	.o(wire_nl01O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl01O.width_data = 8,
		nl01O.width_sel = 3;
	oper_mux   nl0ii
	( 
	.data({(~ wire_n1O0i_o), (~ wire_n1OOl_o), (~ wire_n011l_o), (~ wire_n1Oii_o), wire_n1O0i_o, wire_n1OOl_o, wire_n011l_o, wire_n1Oii_o}),
	.o(wire_nl0ii_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0ii.width_data = 8,
		nl0ii.width_sel = 3;
	oper_mux   nl0il
	( 
	.data({(~ wire_n1O1O_o), (~ wire_n1OOi_o), (~ wire_n011O_o), (~ wire_n1Oil_o), wire_n1O1O_o, wire_n1OOi_o, wire_n011O_o, wire_n1Oil_o}),
	.o(wire_nl0il_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0il.width_data = 8,
		nl0il.width_sel = 3;
	oper_mux   nl0iO
	( 
	.data({(~ wire_n1O1l_o), (~ wire_n1OlO_o), (~ wire_n010i_o), (~ wire_n1OiO_o), wire_n1O1l_o, wire_n1OlO_o, wire_n010i_o, wire_n1OiO_o}),
	.o(wire_nl0iO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0iO.width_data = 8,
		nl0iO.width_sel = 3;
	oper_mux   nl0li
	( 
	.data({{4{(~ wire_n1Oli_o)}}, {4{wire_n1Oli_o}}}),
	.o(wire_nl0li_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0li.width_data = 8,
		nl0li.width_sel = 3;
	oper_mux   nl0ll
	( 
	.data({{4{(~ wire_n1Oll_o)}}, {4{wire_n1Oll_o}}}),
	.o(wire_nl0ll_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0ll.width_data = 8,
		nl0ll.width_sel = 3;
	oper_mux   nl0lO
	( 
	.data({(~ wire_n010i_o), (~ wire_n1OiO_o), (~ wire_n1O1l_o), (~ wire_n1OlO_o), wire_n010i_o, wire_n1OiO_o, wire_n1O1l_o, wire_n1OlO_o}),
	.o(wire_nl0lO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0lO.width_data = 8,
		nl0lO.width_sel = 3;
	oper_mux   nl0Oi
	( 
	.data({(~ wire_n011O_o), (~ wire_n1Oil_o), (~ wire_n1O1O_o), (~ wire_n1OOi_o), wire_n011O_o, wire_n1Oil_o, wire_n1O1O_o, wire_n1OOi_o}),
	.o(wire_nl0Oi_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0Oi.width_data = 8,
		nl0Oi.width_sel = 3;
	oper_mux   nl0Ol
	( 
	.data({(~ wire_n011l_o), (~ wire_n1Oii_o), (~ wire_n1O0i_o), (~ wire_n1OOl_o), wire_n011l_o, wire_n1Oii_o, wire_n1O0i_o, wire_n1OOl_o}),
	.o(wire_nl0Ol_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0Ol.width_data = 8,
		nl0Ol.width_sel = 3;
	oper_mux   nl0OO
	( 
	.data({(~ wire_n011i_o), (~ wire_n1O0O_o), (~ wire_n1O0l_o), (~ wire_n1OOO_o), wire_n011i_o, wire_n1O0O_o, wire_n1O0l_o, wire_n1OOO_o}),
	.o(wire_nl0OO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl0OO.width_data = 8,
		nl0OO.width_sel = 3;
	oper_mux   nl10i
	( 
	.data({(~ wire_n1O0i_o), (~ wire_n1OOl_o), (~ wire_n010i_o), (~ wire_n1OiO_o), wire_n1O0i_o, wire_n1OOl_o, wire_n010i_o, wire_n1OiO_o}),
	.o(wire_nl10i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl10i.width_data = 8,
		nl10i.width_sel = 3;
	oper_mux   nl10l
	( 
	.data({(~ wire_n1O1O_o), (~ wire_n1OOi_o), (~ wire_n010l_o), (~ wire_n1Oli_o), wire_n1O1O_o, wire_n1OOi_o, wire_n010l_o, wire_n1Oli_o}),
	.o(wire_nl10l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl10l.width_data = 8,
		nl10l.width_sel = 3;
	oper_mux   nl10O
	( 
	.data({(~ wire_n1O1l_o), (~ wire_n1OlO_o), (~ wire_n010O_o), (~ wire_n1Oll_o), wire_n1O1l_o, wire_n1OlO_o, wire_n010O_o, wire_n1Oll_o}),
	.o(wire_nl10O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl10O.width_data = 8,
		nl10O.width_sel = 3;
	oper_mux   nl11i
	( 
	.data({(~ wire_n1Oii_o), (~ wire_n011l_o), (~ wire_n011i_o), (~ wire_n1O0O_o), wire_n1Oii_o, wire_n011l_o, wire_n011i_o, wire_n1O0O_o}),
	.o(wire_nl11i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl11i.width_data = 8,
		nl11i.width_sel = 3;
	oper_mux   nl11l
	( 
	.data({(~ wire_n1O0O_o), (~ wire_n011i_o), (~ wire_n011l_o), (~ wire_n1Oii_o), wire_n1O0O_o, wire_n011i_o, wire_n011l_o, wire_n1Oii_o}),
	.o(wire_nl11l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl11l.width_data = 8,
		nl11l.width_sel = 3;
	oper_mux   nl11O
	( 
	.data({(~ wire_n1O0l_o), (~ wire_n1OOO_o), (~ wire_n011O_o), (~ wire_n1Oil_o), wire_n1O0l_o, wire_n1OOO_o, wire_n011O_o, wire_n1Oil_o}),
	.o(wire_nl11O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl11O.width_data = 8,
		nl11O.width_sel = 3;
	oper_mux   nl1ii
	( 
	.data({(~ wire_n010O_o), (~ wire_n1Oll_o), (~ wire_n1O1l_o), (~ wire_n1OlO_o), wire_n010O_o, wire_n1Oll_o, wire_n1O1l_o, wire_n1OlO_o}),
	.o(wire_nl1ii_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1ii.width_data = 8,
		nl1ii.width_sel = 3;
	oper_mux   nl1il
	( 
	.data({(~ wire_n010l_o), (~ wire_n1Oli_o), (~ wire_n1O1O_o), (~ wire_n1OOi_o), wire_n010l_o, wire_n1Oli_o, wire_n1O1O_o, wire_n1OOi_o}),
	.o(wire_nl1il_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1il.width_data = 8,
		nl1il.width_sel = 3;
	oper_mux   nl1iO
	( 
	.data({(~ wire_n010i_o), (~ wire_n1OiO_o), (~ wire_n1O0i_o), (~ wire_n1OOl_o), wire_n010i_o, wire_n1OiO_o, wire_n1O0i_o, wire_n1OOl_o}),
	.o(wire_nl1iO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1iO.width_data = 8,
		nl1iO.width_sel = 3;
	oper_mux   nl1li
	( 
	.data({(~ wire_n011O_o), (~ wire_n1Oil_o), (~ wire_n1O0l_o), (~ wire_n1OOO_o), wire_n011O_o, wire_n1Oil_o, wire_n1O0l_o, wire_n1OOO_o}),
	.o(wire_nl1li_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1li.width_data = 8,
		nl1li.width_sel = 3;
	oper_mux   nl1ll
	( 
	.data({(~ wire_n011l_o), (~ wire_n1Oii_o), (~ wire_n1O0O_o), (~ wire_n011i_o), wire_n011l_o, wire_n1Oii_o, wire_n1O0O_o, wire_n011i_o}),
	.o(wire_nl1ll_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1ll.width_data = 8,
		nl1ll.width_sel = 3;
	oper_mux   nl1lO
	( 
	.data({(~ wire_n011i_o), (~ wire_n1O0O_o), (~ wire_n1Oii_o), (~ wire_n011l_o), wire_n011i_o, wire_n1O0O_o, wire_n1Oii_o, wire_n011l_o}),
	.o(wire_nl1lO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1lO.width_data = 8,
		nl1lO.width_sel = 3;
	oper_mux   nl1Oi
	( 
	.data({(~ wire_n1OOO_o), (~ wire_n1O0l_o), (~ wire_n1Oil_o), (~ wire_n011O_o), wire_n1OOO_o, wire_n1O0l_o, wire_n1Oil_o, wire_n011O_o}),
	.o(wire_nl1Oi_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1Oi.width_data = 8,
		nl1Oi.width_sel = 3;
	oper_mux   nl1Ol
	( 
	.data({(~ wire_n1OOl_o), (~ wire_n1O0i_o), (~ wire_n1OiO_o), (~ wire_n010i_o), wire_n1OOl_o, wire_n1O0i_o, wire_n1OiO_o, wire_n010i_o}),
	.o(wire_nl1Ol_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1Ol.width_data = 8,
		nl1Ol.width_sel = 3;
	oper_mux   nl1OO
	( 
	.data({(~ wire_n1OOi_o), (~ wire_n1O1O_o), (~ wire_n1Oli_o), (~ wire_n010l_o), wire_n1OOi_o, wire_n1O1O_o, wire_n1Oli_o, wire_n010l_o}),
	.o(wire_nl1OO_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nl1OO.width_data = 8,
		nl1OO.width_sel = 3;
	oper_mux   nli0i
	( 
	.data({(~ wire_n1OlO_o), (~ wire_n1O1l_o), (~ wire_n1OiO_o), (~ wire_n010i_o), wire_n1OlO_o, wire_n1O1l_o, wire_n1OiO_o, wire_n010i_o}),
	.o(wire_nli0i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli0i.width_data = 8,
		nli0i.width_sel = 3;
	oper_mux   nli0l
	( 
	.data({{4{(~ wire_n010l_o)}}, {4{wire_n010l_o}}}),
	.o(wire_nli0l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli0l.width_data = 8,
		nli0l.width_sel = 3;
	oper_mux   nli0O
	( 
	.data({{4{(~ wire_n010O_o)}}, {4{wire_n010O_o}}}),
	.o(wire_nli0O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli0O.width_data = 8,
		nli0O.width_sel = 3;
	oper_mux   nli1i
	( 
	.data({(~ wire_n1OOO_o), (~ wire_n1O0l_o), (~ wire_n1O0O_o), (~ wire_n011i_o), wire_n1OOO_o, wire_n1O0l_o, wire_n1O0O_o, wire_n011i_o}),
	.o(wire_nli1i_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli1i.width_data = 8,
		nli1i.width_sel = 3;
	oper_mux   nli1l
	( 
	.data({(~ wire_n1OOl_o), (~ wire_n1O0i_o), (~ wire_n1Oii_o), (~ wire_n011l_o), wire_n1OOl_o, wire_n1O0i_o, wire_n1Oii_o, wire_n011l_o}),
	.o(wire_nli1l_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli1l.width_data = 8,
		nli1l.width_sel = 3;
	oper_mux   nli1O
	( 
	.data({(~ wire_n1OOi_o), (~ wire_n1O1O_o), (~ wire_n1Oil_o), (~ wire_n011O_o), wire_n1OOi_o, wire_n1O1O_o, wire_n1Oil_o, wire_n011O_o}),
	.o(wire_nli1O_o),
	.sel({n0lll, n0liO, n0lii}));
	defparam
		nli1O.width_data = 8,
		nli1O.width_sel = 3;
	oper_mux   nliii
	( 
	.data({(~ wire_n1Oll_o), (~ wire_n1O1l_o), wire_n1Oll_o, wire_n1O1l_o}),
	.o(wire_nliii_o),
	.sel({n0lll, n0liO}));
	defparam
		nliii.width_data = 4,
		nliii.width_sel = 2;
	oper_mux   nliil
	( 
	.data({(~ wire_n1Oli_o), (~ wire_n1O1O_o), wire_n1Oli_o, wire_n1O1O_o}),
	.o(wire_nliil_o),
	.sel({n0lll, n0liO}));
	defparam
		nliil.width_data = 4,
		nliil.width_sel = 2;
	oper_mux   nliiO
	( 
	.data({(~ wire_n1OiO_o), (~ wire_n1O0i_o), wire_n1OiO_o, wire_n1O0i_o}),
	.o(wire_nliiO_o),
	.sel({n0lll, n0liO}));
	defparam
		nliiO.width_data = 4,
		nliiO.width_sel = 2;
	oper_mux   nlili
	( 
	.data({(~ wire_n1Oil_o), (~ wire_n1O0l_o), wire_n1Oil_o, wire_n1O0l_o}),
	.o(wire_nlili_o),
	.sel({n0lll, n0liO}));
	defparam
		nlili.width_data = 4,
		nlili.width_sel = 2;
	oper_mux   nlill
	( 
	.data({(~ wire_n1Oii_o), (~ wire_n1O0O_o), wire_n1Oii_o, wire_n1O0O_o}),
	.o(wire_nlill_o),
	.sel({n0lll, n0liO}));
	defparam
		nlill.width_data = 4,
		nlill.width_sel = 2;
	oper_mux   nlilO
	( 
	.data({(~ wire_n1O0O_o), (~ wire_n1Oii_o), wire_n1O0O_o, wire_n1Oii_o}),
	.o(wire_nlilO_o),
	.sel({n0lll, n0liO}));
	defparam
		nlilO.width_data = 4,
		nlilO.width_sel = 2;
	oper_mux   nliOi
	( 
	.data({(~ wire_n1O0l_o), (~ wire_n1Oil_o), wire_n1O0l_o, wire_n1Oil_o}),
	.o(wire_nliOi_o),
	.sel({n0lll, n0liO}));
	defparam
		nliOi.width_data = 4,
		nliOi.width_sel = 2;
	oper_mux   nliOl
	( 
	.data({(~ wire_n1O0i_o), (~ wire_n1OiO_o), wire_n1O0i_o, wire_n1OiO_o}),
	.o(wire_nliOl_o),
	.sel({n0lll, n0liO}));
	defparam
		nliOl.width_data = 4,
		nliOl.width_sel = 2;
	oper_mux   nliOO
	( 
	.data({(~ wire_n1O1O_o), (~ wire_n1Oli_o), wire_n1O1O_o, wire_n1Oli_o}),
	.o(wire_nliOO_o),
	.sel({n0lll, n0liO}));
	defparam
		nliOO.width_data = 4,
		nliOO.width_sel = 2;
	oper_mux   nll0i
	( 
	.data({{2{(~ wire_n1OOl_o)}}, {2{wire_n1OOl_o}}}),
	.o(wire_nll0i_o),
	.sel({n0lll, n0liO}));
	defparam
		nll0i.width_data = 4,
		nll0i.width_sel = 2;
	oper_mux   nll0l
	( 
	.data({{2{(~ wire_n1OOO_o)}}, {2{wire_n1OOO_o}}}),
	.o(wire_nll0l_o),
	.sel({n0lll, n0liO}));
	defparam
		nll0l.width_data = 4,
		nll0l.width_sel = 2;
	oper_mux   nll0O
	( 
	.data({{2{(~ wire_n011i_o)}}, {2{wire_n011i_o}}}),
	.o(wire_nll0O_o),
	.sel({n0lll, n0liO}));
	defparam
		nll0O.width_data = 4,
		nll0O.width_sel = 2;
	oper_mux   nll1i
	( 
	.data({(~ wire_n1O1l_o), (~ wire_n1Oll_o), wire_n1O1l_o, wire_n1Oll_o}),
	.o(wire_nll1i_o),
	.sel({n0lll, n0liO}));
	defparam
		nll1i.width_data = 4,
		nll1i.width_sel = 2;
	oper_mux   nll1l
	( 
	.data({{2{(~ wire_n1OlO_o)}}, {2{wire_n1OlO_o}}}),
	.o(wire_nll1l_o),
	.sel({n0lll, n0liO}));
	defparam
		nll1l.width_data = 4,
		nll1l.width_sel = 2;
	oper_mux   nll1O
	( 
	.data({{2{(~ wire_n1OOi_o)}}, {2{wire_n1OOi_o}}}),
	.o(wire_nll1O_o),
	.sel({n0lll, n0liO}));
	defparam
		nll1O.width_data = 4,
		nll1O.width_sel = 2;
	oper_mux   nllii
	( 
	.data({{2{(~ wire_n011l_o)}}, {2{wire_n011l_o}}}),
	.o(wire_nllii_o),
	.sel({n0lll, n0liO}));
	defparam
		nllii.width_data = 4,
		nllii.width_sel = 2;
	oper_mux   nllil
	( 
	.data({{2{(~ wire_n011O_o)}}, {2{wire_n011O_o}}}),
	.o(wire_nllil_o),
	.sel({n0lll, n0liO}));
	defparam
		nllil.width_data = 4,
		nllil.width_sel = 2;
	oper_mux   nlliO
	( 
	.data({((ni0Oll40 ^ ni0Oll39) & (~ wire_n010i_o)), (~ wire_n010i_o), wire_n010i_o, ((ni0OlO38 ^ ni0OlO37) & wire_n010i_o)}),
	.o(wire_nlliO_o),
	.sel({n0lll, n0liO}));
	defparam
		nlliO.width_data = 4,
		nlliO.width_sel = 2;
	oper_mux   nllli
	( 
	.data({(~ wire_n010l_o), ((ni0OOi36 ^ ni0OOi35) & (~ wire_n010l_o)), {2{wire_n010l_o}}}),
	.o(wire_nllli_o),
	.sel({n0lll, n0liO}));
	defparam
		nllli.width_data = 4,
		nllli.width_sel = 2;
	oper_mux   nllll
	( 
	.data({{2{(~ wire_n010O_o)}}, {2{wire_n010O_o}}}),
	.o(wire_nllll_o),
	.sel({n0lll, n0liO}));
	defparam
		nllll.width_data = 4,
		nllll.width_sel = 2;
	oper_mux   nlllO
	( 
	.data({(~ wire_n1OiO_o), (~ wire_n1O1l_o), wire_n1OiO_o, wire_n1O1l_o}),
	.o(wire_nlllO_o),
	.sel({n0lll, n0liO}));
	defparam
		nlllO.width_data = 4,
		nlllO.width_sel = 2;
	oper_mux   nllOi
	( 
	.data({(~ wire_n1Oil_o), ((ni0OOl34 ^ ni0OOl33) & (~ wire_n1O1O_o)), wire_n1Oil_o, wire_n1O1O_o}),
	.o(wire_nllOi_o),
	.sel({n0lll, n0liO}));
	defparam
		nllOi.width_data = 4,
		nllOi.width_sel = 2;
	oper_mux   nllOl
	( 
	.data({(~ wire_n1Oii_o), (~ wire_n1O0i_o), wire_n1Oii_o, wire_n1O0i_o}),
	.o(wire_nllOl_o),
	.sel({n0lll, n0liO}));
	defparam
		nllOl.width_data = 4,
		nllOl.width_sel = 2;
	oper_mux   nllOO
	( 
	.data({(~ wire_n1O0O_o), (~ wire_n1O0l_o), wire_n1O0O_o, ((ni0OOO32 ^ ni0OOO31) & wire_n1O0l_o)}),
	.o(wire_nllOO_o),
	.sel({n0lll, n0liO}));
	defparam
		nllOO.width_data = 4,
		nllOO.width_sel = 2;
	oper_mux   nlO0i
	( 
	.data({(~ wire_n1O1l_o), (~ wire_n1OiO_o), wire_n1O1l_o, wire_n1OiO_o}),
	.o(wire_nlO0i_o),
	.sel({n0lll, ((nii10l22 ^ nii10l21) & n0liO)}));
	defparam
		nlO0i.width_data = 4,
		nlO0i.width_sel = 2;
	oper_mux   nlO0l
	( 
	.data({((nii10O20 ^ nii10O19) & (~ wire_n1Oli_o)), (~ wire_n1Oli_o), {2{wire_n1Oli_o}}}),
	.o(wire_nlO0l_o),
	.sel({((nii1ii18 ^ nii1ii17) & n0lll), n0liO}));
	defparam
		nlO0l.width_data = 4,
		nlO0l.width_sel = 2;
	oper_mux   nlO0O
	( 
	.data({{2{(~ wire_n1Oll_o)}}, ((nii1il16 ^ nii1il15) & wire_n1Oll_o), wire_n1Oll_o}),
	.o(wire_nlO0O_o),
	.sel({n0lll, n0liO}));
	defparam
		nlO0O.width_data = 4,
		nlO0O.width_sel = 2;
	oper_mux   nlO1i
	( 
	.data({((nii11i30 ^ nii11i29) & (~ wire_n1O0l_o)), (~ wire_n1O0O_o), wire_n1O0l_o, wire_n1O0O_o}),
	.o(wire_nlO1i_o),
	.sel({n0lll, n0liO}));
	defparam
		nlO1i.width_data = 4,
		nlO1i.width_sel = 2;
	oper_mux   nlO1l
	( 
	.data({(~ wire_n1O0i_o), ((nii11l28 ^ nii11l27) & (~ wire_n1Oii_o)), ((nii11O26 ^ nii11O25) & wire_n1O0i_o), wire_n1Oii_o}),
	.o(wire_nlO1l_o),
	.sel({n0lll, n0liO}));
	defparam
		nlO1l.width_data = 4,
		nlO1l.width_sel = 2;
	oper_mux   nlO1O
	( 
	.data({(~ wire_n1O1O_o), (~ wire_n1Oil_o), wire_n1O1O_o, wire_n1Oil_o}),
	.o(wire_nlO1O_o),
	.sel({((nii10i24 ^ nii10i23) & n0lll), n0liO}));
	defparam
		nlO1O.width_data = 4,
		nlO1O.width_sel = 2;
	assign
		disp_out_3b = {wire_nlli1i_dataout, wire_nl010O_dataout},
		ni000i = (((((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni01ll)) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni01ll))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1iO_dataout) & wire_n1il_dataout)))) | (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1iO_dataout & (~ wire_n1il_dataout))))),
		ni000l = (((((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1iO_dataout & wire_n1il_dataout))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni01Ol))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni01Oi))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni01Ol))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni01Oi))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout))))),
		ni000O = (ni00il | (wire_n1lO_dataout & ni00ii)),
		ni001i = (wire_n1lO_dataout & ((wire_n1ll_dataout & ni00iO) | ni000i)),
		ni001l = (wire_nl1iii_dataout & ni000l),
		ni001O = ((((~ wire_n1lO_dataout) | wire_nl1iii_dataout) & ni000l) | (wire_n1lO_dataout & (((~ ni000i) & (~ ni000l)) & ni00ii))),
		ni00ii = ((~ wire_n1ll_dataout) | (wire_n1li_dataout | (wire_n1iO_dataout | wire_n1il_dataout))),
		ni00il = ((~ wire_n1lO_dataout) & ni00iO),
		ni00iO = (((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & wire_n1il_dataout))) | ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1iO_dataout & (~ wire_n1il_dataout))))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni01lO))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni01lO))),
		ni00li = (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1iO_dataout & wire_n1il_dataout))),
		ni00ll = ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout)))),
		ni00lO = (ni00li | ni00ll),
		ni00Oi = ((((wire_n1lO_dataout & wire_n1ll_dataout) & wire_n1li_dataout) & (~ wire_n1iO_dataout)) & (~ wire_n1il_dataout)),
		ni00Ol = (wire_n1iO_dataout & wire_n1il_dataout),
		ni00OO = ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout)),
		ni01il = ((((((((((((((wire_nili1O_o[15] | wire_nili1O_o[14]) | wire_nili1O_o[13]) | wire_nili1O_o[12]) | wire_nili1O_o[11]) | wire_nili1O_o[10]) | wire_nili1O_o[9]) | wire_nili1O_o[8]) | wire_nili1O_o[7]) | wire_nili1O_o[6]) | wire_nili1O_o[5]) | wire_nili1O_o[4]) | wire_nili1O_o[3]) | wire_nili1O_o[2]) | wire_nili1O_o[1]),
		ni01iO = ((((((wire_nillli_o[15] | wire_nillli_o[14]) | wire_nillli_o[13]) | wire_nillli_o[12]) | wire_nillli_o[11]) | wire_nillli_o[10]) | wire_nillli_o[0]),
		ni01li = ((((((wire_nillli_o[7] | wire_nillli_o[6]) | wire_nillli_o[5]) | wire_nillli_o[4]) | wire_nillli_o[3]) | wire_nillli_o[2]) | wire_nillli_o[1]),
		ni01ll = (wire_n1iO_dataout & wire_n1il_dataout),
		ni01lO = ((~ wire_n1iO_dataout) & (~ wire_n1il_dataout)),
		ni01Oi = (wire_n1iO_dataout & (~ wire_n1il_dataout)),
		ni01Ol = ((~ wire_n1iO_dataout) & wire_n1il_dataout),
		ni01OO = (((((((~ wire_n1ll_dataout) & (wire_n1li_dataout & (wire_n1iO_dataout & wire_n1il_dataout))) | (wire_n1lO_dataout & ni00ll)) | (wire_n1lO_dataout & ni00li)) | (wire_n1lO_dataout & ni000i)) | ni001l) ^ ((~ wire_n0O1l_dataout) & (ni001l | ((ni00lO | ((~ wire_n1lO_dataout) & (((~ wire_n1ll_dataout) & ni000i) | ni00iO))) | ni001i)))),
		ni0i0i = ((((~ wire_niOlOi_dataout) & (wire_nl00ll_dataout & (~ ni0i0O))) | ni0i0l) ^ ((~ wire_niOlOi_dataout) & ni0i0O)),
		ni0i0l = (wire_n1Ol_dataout & wire_n1Oi_dataout),
		ni0i0O = (ni0i0l | ni0i1l),
		ni0i1i = ((~ wire_n1OO_dataout) & ni0i1l),
		ni0i1l = ((~ wire_n1Ol_dataout) & (~ wire_n1Oi_dataout)),
		ni0i1O = (wire_n1OO_dataout & (wire_n1Ol_dataout & (wire_n1Oi_dataout & ((((~ wire_niOlOi_dataout) & ((wire_n1lO_dataout & (~ wire_n1ll_dataout)) & (((((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & ((~ wire_n1iO_dataout) & wire_n1il_dataout))) | ((~ wire_n1ll_dataout) & ((~ wire_n1li_dataout) & (wire_n1iO_dataout & (~ wire_n1il_dataout))))) | ((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni00OO))) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni00OO))))) | (wire_niOlOi_dataout & (((~ wire_n1lO_dataout) & wire_n1ll_dataout) & (((((~ wire_n1ll_dataout) & (wire_n1li_dataout & ni00Ol)) | (wire_n1ll_dataout & ((~ wire_n1li_dataout) & ni00Ol))) | (wire_n1ll_dataout & (wire_n1li_dataout & ((~ wire_n1iO_dataout) & wire_n1il_dataout)))) | (wire_n1ll_dataout & (wire_n1li_dataout & (wire_n1iO_dataout & (~ wire_n1il_dataout)))))))) | (wire_n1OO_dataout & (wire_n1Ol_dataout & (wire_nil_dataout & wire_n1Oi_dataout))))))),
		ni0iii = (wire_nil_dataout & ni00Oi),
		ni0iil = (wire_n01l_dataout & wire_n01i_dataout),
		ni0iiO = ((~ wire_n01l_dataout) & (~ wire_n01i_dataout)),
		ni0ili = (wire_n01l_dataout & (~ wire_n01i_dataout)),
		ni0ill = ((~ wire_n01l_dataout) & wire_n01i_dataout),
		ni0ilO = (((((((~ wire_n00i_dataout) & (wire_n01O_dataout & (wire_n01l_dataout & wire_n01i_dataout))) | (wire_n00l_dataout & ni0lil)) | (wire_n00l_dataout & ni0lii)) | (wire_n00l_dataout & ni0l1i)) | ni0iOl) ^ ((~ wire_n0O1O_dataout) & (ni0iOl | ((ni0liO | ((~ wire_n00l_dataout) & (((~ wire_n00i_dataout) & ni0l1i) | ni0l0O))) | ni0iOi)))),
		ni0iOi = (wire_n00l_dataout & ((wire_n00i_dataout & ni0l0O) | ni0l1i)),
		ni0iOl = (wire_nliO1l_dataout & ni0l1l),
		ni0iOO = ((((~ wire_n00l_dataout) | wire_nliO1l_dataout) & ni0l1l) | (wire_n00l_dataout & (((~ ni0l1i) & (~ ni0l1l)) & ni0l0i))),
		ni0l0i = ((~ wire_n00i_dataout) | (wire_n01O_dataout | (wire_n01l_dataout | wire_n01i_dataout))),
		ni0l0l = ((~ wire_n00l_dataout) & ni0l0O),
		ni0l0O = (((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & wire_n01i_dataout))) | ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01l_dataout & (~ wire_n01i_dataout))))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0iiO))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0iiO))),
		ni0l1i = (((((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0iil)) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0iil))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01l_dataout) & wire_n01i_dataout)))) | (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01l_dataout & (~ wire_n01i_dataout))))),
		ni0l1l = (((((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01l_dataout & wire_n01i_dataout))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0ill))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0ili))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0ill))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0ili))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01l_dataout) & (~ wire_n01i_dataout))))),
		ni0l1O = (ni0l0l | (wire_n00l_dataout & ni0l0i)),
		ni0lii = (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01l_dataout & wire_n01i_dataout))),
		ni0lil = ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & (~ wire_n01i_dataout)))),
		ni0liO = (ni0lii | ni0lil),
		ni0lli = ((((wire_n00l_dataout & wire_n00i_dataout) & wire_n01O_dataout) & (~ wire_n01l_dataout)) & (~ wire_n01i_dataout)),
		ni0lll = (wire_n01l_dataout & wire_n01i_dataout),
		ni0llO = ((~ wire_n01l_dataout) & (~ wire_n01i_dataout)),
		ni0lOi = ((~ wire_n0il_dataout) & ni0lOl),
		ni0lOl = ((~ wire_n0ii_dataout) & (~ wire_n00O_dataout)),
		ni0lOO = (wire_n0il_dataout & (wire_n0ii_dataout & (wire_n00O_dataout & ((((~ wire_nli1il_dataout) & ((wire_n00l_dataout & (~ wire_n00i_dataout)) & (((((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & ((~ wire_n01l_dataout) & wire_n01i_dataout))) | ((~ wire_n00i_dataout) & ((~ wire_n01O_dataout) & (wire_n01l_dataout & (~ wire_n01i_dataout))))) | ((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0llO))) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0llO))))) | (wire_nli1il_dataout & (((~ wire_n00l_dataout) & wire_n00i_dataout) & (((((~ wire_n00i_dataout) & (wire_n01O_dataout & ni0lll)) | (wire_n00i_dataout & ((~ wire_n01O_dataout) & ni0lll))) | (wire_n00i_dataout & (wire_n01O_dataout & ((~ wire_n01l_dataout) & wire_n01i_dataout)))) | (wire_n00i_dataout & (wire_n01O_dataout & (wire_n01l_dataout & (~ wire_n01i_dataout)))))))) | (wire_n0il_dataout & (wire_n0ii_dataout & (wire_niO_dataout & wire_n00O_dataout))))))),
		ni0O0i = (wire_niO_dataout & ni0lli),
		ni0O1i = ((((~ wire_nli1il_dataout) & (wire_nlll0O_dataout & (~ ni0O1O))) | ni0O1l) ^ ((~ wire_nli1il_dataout) & ni0O1O)),
		ni0O1l = (wire_n0ii_dataout & wire_n00O_dataout),
		ni0O1O = (ni0O1l | ni0lOl),
		ni0Oil = 1'b1,
		nii00O = ((((((d21_5_eq_n & d2_2_eq_n) & (nii0iO2 ^ nii0iO1)) & ge_xaui_sel) & (~ tx_ctl_tc[0])) & (nii0ii4 ^ nii0ii3)) & k_det),
		nii1iO = (((((((d21_5_eq_n & d2_2_eq_n) & (nii1lO12 ^ nii1lO11)) & ge_xaui_sel) & (~ tx_ctl_tc[0])) & (nii1li14 ^ nii1li13)) & k_det) & (~ n01il)),
		nii1Ol = ((((((((d21_5_eq_n & d2_2_eq_n) & (nii00i6 ^ nii00i5)) & ge_xaui_sel) & (~ tx_ctl_tc[0])) & k_det) & (nii01l8 ^ nii01l7)) & n01il) & (nii1OO10 ^ nii1OO9)),
		pudr = {nii1i, ni0Ol, ni0lO, ni0ll, ni0li, ni0iO, ni0il, ni0ii, ni00O, ni00l, ni00i, ni01O, ni01l, ni01i, ni1OO, ni1Ol, ni1Oi, ni1lO, ni1ll, n0lOi},
		tx_ctl_pre_en = {n01OO, n01Ol},
		tx_data_9_pre_en = {n01Oi, n01lO},
		tx_data_pre_en = {n0i1i, n00OO, n00Ol, n00Oi, n00lO, n00ll, n00li, n00iO, n00il, n00ii, n000O, n000l, n000i, n001O, n001l, n001i},
		txlp20b = {n0l0O, n0l0l, n0l0i, n0l1O, n0l1l, n0l1i, n0iOO, n0iOl, n0iOi, n0ilO, n0ill, n0ili, n0iiO, n0iil, n0iii, n0i0O, n0i0l, n0i0i, n0i1O, n0i1l};
endmodule //arriaii_hssi_tx_digi_enc_chnl_top
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 12 mux21 13 
`timescale 1 ps / 1 ps
module  arriaii_hssi_tx_digi_iq_pipe_tx
	( 
	fifo_rd_clk_raw,
	fifo_select_in_centrl,
	fifo_select_in_pipe_quad_down,
	fifo_select_in_pipe_quad_up,
	fifo_select_out_pipe,
	rd_enable_in_centrl,
	rd_enable_in_pipe_quad_down,
	rd_enable_in_pipe_quad_up,
	rd_enable_out_pipe,
	refclk_b_raw,
	rfreerun_tx,
	rmaster_tx,
	rmaster_up_tx,
	rpipeline_bypass_tx,
	soft_reset_rclk1,
	soft_reset_wclk1,
	tx_div2_sync_in_centrl,
	tx_div2_sync_in_pipe_quad_down,
	tx_div2_sync_in_pipe_quad_up,
	tx_div2_sync_out_pipe,
	txrst,
	wr_clk_pos_raw,
	wr_enable_in_centrl,
	wr_enable_in_pipe_quad_down,
	wr_enable_in_pipe_quad_up,
	wr_enable_out_pipe) /* synthesis synthesis_clearbox=1 */;
	input   fifo_rd_clk_raw;
	input   fifo_select_in_centrl;
	input   fifo_select_in_pipe_quad_down;
	input   fifo_select_in_pipe_quad_up;
	output   fifo_select_out_pipe;
	input   rd_enable_in_centrl;
	input   rd_enable_in_pipe_quad_down;
	input   rd_enable_in_pipe_quad_up;
	output   rd_enable_out_pipe;
	input   refclk_b_raw;
	input   rfreerun_tx;
	input   rmaster_tx;
	input   rmaster_up_tx;
	input   rpipeline_bypass_tx;
	input   soft_reset_rclk1;
	input   soft_reset_wclk1;
	input   tx_div2_sync_in_centrl;
	input   tx_div2_sync_in_pipe_quad_down;
	input   tx_div2_sync_in_pipe_quad_up;
	output   tx_div2_sync_out_pipe;
	input   txrst;
	input   wr_clk_pos_raw;
	input   wr_enable_in_centrl;
	input   wr_enable_in_pipe_quad_down;
	input   wr_enable_in_pipe_quad_up;
	output   wr_enable_out_pipe;

	reg	n0ii7;
	reg	n0ii8;
	reg	n0il5;
	reg	n0il6;
	reg	n0li3;
	reg	n0li4;
	reg	n0Oi1;
	reg	n0Oi2;
	reg	n1l;
	reg	n1i_clk_prev;
	wire	wire_n1i_CLRN;
	reg	nO;
	wire	wire_nl_CLRN;
	reg	ni;
	reg	nlO_clk_prev;
	wire	wire_nlO_CLRN;
	reg	nlOO;
	reg	nlOl_clk_prev;
	wire	wire_nlOl_PRN;
	wire	wire_n0i_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n1O_dataout;
	wire	wire_nii_dataout;
	wire	wire_nil_dataout;
	wire	wire_niO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nll_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nlOi_dataout;
	wire  n0ll;

	initial
		n0ii7 = 0;
	always @ ( posedge refclk_b_raw)
		  n0ii7 <= n0ii8;
	event n0ii7_event;
	initial
		#1 ->n0ii7_event;
	always @(n0ii7_event)
		n0ii7 <= {1{1'b1}};
	initial
		n0ii8 = 0;
	always @ ( posedge refclk_b_raw)
		  n0ii8 <= n0ii7;
	initial
		n0il5 = 0;
	always @ ( posedge refclk_b_raw)
		  n0il5 <= n0il6;
	event n0il5_event;
	initial
		#1 ->n0il5_event;
	always @(n0il5_event)
		n0il5 <= {1{1'b1}};
	initial
		n0il6 = 0;
	always @ ( posedge refclk_b_raw)
		  n0il6 <= n0il5;
	initial
		n0li3 = 0;
	always @ ( posedge refclk_b_raw)
		  n0li3 <= n0li4;
	event n0li3_event;
	initial
		#1 ->n0li3_event;
	always @(n0li3_event)
		n0li3 <= {1{1'b1}};
	initial
		n0li4 = 0;
	always @ ( posedge refclk_b_raw)
		  n0li4 <= n0li3;
	initial
		n0Oi1 = 0;
	always @ ( posedge refclk_b_raw)
		  n0Oi1 <= n0Oi2;
	event n0Oi1_event;
	initial
		#1 ->n0Oi1_event;
	always @(n0Oi1_event)
		n0Oi1 <= {1{1'b1}};
	initial
		n0Oi2 = 0;
	always @ ( posedge refclk_b_raw)
		  n0Oi2 <= n0Oi1;
	initial
	begin
		n1l = 0;
	end
	always @ (refclk_b_raw or wire_n1O_dataout or wire_n1i_CLRN)
	begin
		if (wire_n1O_dataout == 1'b1) 
		begin
			n1l <= 1;
		end
		else if  (wire_n1i_CLRN == 1'b0) 
		begin
			n1l <= 0;
		end
		else 
		if (refclk_b_raw != n1i_clk_prev && refclk_b_raw == 1'b1) 
		begin
			n1l <= wire_nli_dataout;
		end
		n1i_clk_prev <= refclk_b_raw;
	end
	assign
		wire_n1i_CLRN = (n0il6 ^ n0il5);
	initial
	begin
		nO = 0;
	end
	always @ ( posedge fifo_rd_clk_raw or  negedge wire_nl_CLRN)
	begin
		if (wire_nl_CLRN == 1'b0) 
		begin
			nO <= 0;
		end
		else 
		begin
			nO <= wire_n0i_dataout;
		end
	end
	assign
		wire_nl_CLRN = ((n0Oi2 ^ n0Oi1) & (~ soft_reset_rclk1));
	initial
	begin
		ni = 0;
	end
	always @ (refclk_b_raw or txrst or wire_nlO_CLRN)
	begin
		if (txrst == 1'b1) 
		begin
			ni <= 1;
		end
		else if  (wire_nlO_CLRN == 1'b0) 
		begin
			ni <= 0;
		end
		else 
		if (refclk_b_raw != nlO_clk_prev && refclk_b_raw == 1'b1) 
		begin
			ni <= wire_nil_dataout;
		end
		nlO_clk_prev <= refclk_b_raw;
	end
	assign
		wire_nlO_CLRN = (n0li4 ^ n0li3);
	initial
	begin
		nlOO = 0;
	end
	always @ (wr_clk_pos_raw or wire_nlOl_PRN or soft_reset_wclk1)
	begin
		if (wire_nlOl_PRN == 1'b0) 
		begin
			nlOO <= 1;
		end
		else if  (soft_reset_wclk1 == 1'b1) 
		begin
			nlOO <= 0;
		end
		else 
		if (wr_clk_pos_raw != nlOl_clk_prev && wr_clk_pos_raw == 1'b1) 
		begin
			nlOO <= wire_n0O_dataout;
		end
		nlOl_clk_prev <= wr_clk_pos_raw;
	end
	assign
		wire_nlOl_PRN = (n0ii8 ^ n0ii7);
	assign		wire_n0i_dataout = ((~ rmaster_tx) === 1'b1) ? wire_n0l_dataout : rd_enable_in_centrl;
	assign		wire_n0l_dataout = (rmaster_up_tx === 1'b1) ? rd_enable_in_pipe_quad_up : rd_enable_in_pipe_quad_down;
	assign		wire_n0O_dataout = ((~ rmaster_tx) === 1'b1) ? wire_nii_dataout : wr_enable_in_centrl;
	and(wire_n1O_dataout, txrst, ~(rfreerun_tx));
	assign		wire_nii_dataout = (rmaster_up_tx === 1'b1) ? wr_enable_in_pipe_quad_up : wr_enable_in_pipe_quad_down;
	assign		wire_nil_dataout = ((~ rmaster_tx) === 1'b1) ? wire_niO_dataout : fifo_select_in_centrl;
	assign		wire_niO_dataout = (rmaster_up_tx === 1'b1) ? fifo_select_in_pipe_quad_up : fifo_select_in_pipe_quad_down;
	assign		wire_nli_dataout = ((~ rmaster_tx) === 1'b1) ? wire_nll_dataout : tx_div2_sync_in_centrl;
	assign		wire_nll_dataout = (rmaster_up_tx === 1'b1) ? tx_div2_sync_in_pipe_quad_up : tx_div2_sync_in_pipe_quad_down;
	assign		wire_nlli_dataout = (rpipeline_bypass_tx === 1'b1) ? wire_n0i_dataout : nO;
	assign		wire_nlll_dataout = (rpipeline_bypass_tx === 1'b1) ? wire_n0O_dataout : nlOO;
	assign		wire_nllO_dataout = (rpipeline_bypass_tx === 1'b1) ? wire_nil_dataout : ni;
	assign		wire_nlOi_dataout = (rpipeline_bypass_tx === 1'b1) ? wire_nli_dataout : n1l;
	assign
		fifo_select_out_pipe = wire_nllO_dataout,
		n0ll = 1'b1,
		rd_enable_out_pipe = wire_nlli_dataout,
		tx_div2_sync_out_pipe = wire_nlOi_dataout,
		wr_enable_out_pipe = wire_nlll_dataout;
endmodule //arriaii_hssi_tx_digi_iq_pipe_tx
//synopsys translate_on
//VALID FILE


`timescale 1ps / 1ps

module arriaii_hssi_tx_digi (txpcs_rst, scan_mode, txd, 
		pld_tx_clk, polinv_tx, rev_loop_data, wrenable_tx, rddisable_tx, 
		phfifourst_tx, 
		txdetectrxloopback, powerdown, revloopback,
		txswing, pcs_txdeemph, pcs_txmargin,
		rxpolarity, polinv_rx,
		full_tx, empty_tx,
                tx_data_ts, tx_ctl_ts, refclk_pma, txpma_local_clk,
                tx_clk_out, tx_data_tc, tx_ctl_tc, pudr, 
                rd_enable_sync, refclk_b, txlp20b, tx_pipe_clk, encoder_testbus, tx_ctrl_testbus,
                tx_pipe_soft_reset, tx_pipe_electidle, 
 		txdetectrxloopback_int, powerdown_int, revloopback_int,
 		phfifo_txswing, phfifo_txdeemph, phfifo_txmargin,
		rxpolarity_int, polinv_rx_int,
                rrev_loopbk, rev_loopbk, eidleinfersel, gray_eidleinfersel,rbisten_tx, 
                rforce_disp, rib_force_disp, rforce_echar, rforce_kchar, rendec_tx, 
                rge_xaui_tx, 
                rdwidth_tx, rtxfifo_dis, rcascaded_8b10b_en_tx, 
                rprbsen_tx, rprbs_sel, rbist_sel, rcxpat_chnl_en, 
                renpolinv_tx, rphfifopldentx, rphfifoursttx,
                rfreerun_tx, rtxwrclksel, rtxrdclksel, renbitrev_tx, rensymswap_tx,
                r8b10b_enc_ibm_en, rtxfifo_lowlatency_en,
                rpmadwidth_tx, rpma_doublewidth_tx, rtx_pipe_enable,
                rindv_tx, rendec_data_sel_tx, 
                rtxpcsbypass_en,
		rtxpcsclkpwdn,
		rauto_speed_ena, 
                rfreq_sel, 
                gen2ngen1, 
                gen2ngen1_bundle,
		rcid_pattern_tx,
		rcid_len_tx,
		tx_div2_sync_in_centrl,
		tx_div2_sync_in_quad_up,
		tx_div2_sync_in_quad_down,
		wr_enable_in_centrl,
		wr_enable_in_quad_up,
		wr_enable_in_quad_down,
		rd_enable_in_centrl,
		rd_enable_in_quad_up,
		rd_enable_in_quad_down,
		fifo_select_in_centrl,
		fifo_select_in_quad_up,
		fifo_select_in_quad_down,
		dis_pc_byte,
		reset_pc_ptrs,
		reset_pc_ptrs_in_centrl,
		reset_pc_ptrs_in_quad_up,
		reset_pc_ptrs_in_quad_down,
		tx_div2_sync_in_pipe_quad_up,
		tx_div2_sync_in_pipe_quad_down,
		wr_enable_in_pipe_quad_up,
		wr_enable_in_pipe_quad_down,
		rd_enable_in_pipe_quad_up,
		rd_enable_in_pipe_quad_down,
		fifo_select_in_pipe_quad_up,
		fifo_select_in_pipe_quad_down,
		rmaster_tx,
		rmaster_up_tx,
		rself_sw_en_tx,
		rpipeline_bypass_tx,
		rphfifo_regmode_tx,
		rtxbitslip_en,
		tx_div2_sync_out_pipe_up,
		fifo_select_out_pipe_up,
		wr_enable_out_pipe_up,
		rd_enable_out_pipe_up,
		tx_div2_sync_out_pipe_down,
		fifo_select_out_pipe_down,
		wr_enable_out_pipe_down,
		rd_enable_out_pipe_down,
		prbs_cid_en,
		tx_boundary_sel
		);

// Reset inputs
input          txpcs_rst;             // TX PCS resets

// Scan inputs
input          scan_mode;             // 1'b1 = scan mode active; 
                                      // 1'b0 = normal mode
// TX PCS channel inputs/outputs
input   [43:0] txd;                   // TXD data bus from PLD
input          pld_tx_clk;            // XGMII tx clock for this lane from PLD
input          polinv_tx;             // TX polarity inversion dynamic control signal
input   [7:0]  tx_data_ts;            // 8-bit tx data from 10G ethernet 
                                      // tx state machine (tx_sm)
input          tx_ctl_ts;             // 1-bit tx control from 10G ethernet tx state machine (tx_sm)
input          refclk_pma;            // Global parallel clock from TX PLL
input          txpma_local_clk;       // Individual TX PMA clock from TX PMA Extension
input          rev_loopbk;	      // Dynamic signal causes reverse loopback
input   [19:0] rev_loop_data;	      // 10 bit data from RX rate matching FIFO, reverse loopback
input          wrenable_tx;           // TX phase comp. FIFO write enable control signal
input          rddisable_tx;          // TX phase comp. FIFO read disable control signal
input          phfifourst_tx;	      // TX phase comp. FIFO user reset

	// TX PIPE interface signals
input			txdetectrxloopback;
//input			txelecidle; 	txd[9]
//input			txcompliance;	txd[10] and txd[32]
input	[1:0]	powerdown;
	
input			revloopback;

// push through TX Phase Comp FIFO
input			txswing;
input			pcs_txdeemph;
input	[2:0]	pcs_txmargin;

	// RX PIPE interface signals
input			rxpolarity;
input			polinv_rx;
input	[2:0]	eidleinfersel;

input	       rtxpcsclkpwdn;
input	       rauto_speed_ena; 
input          rfreq_sel; 
input          gen2ngen1; 
input 	       gen2ngen1_bundle;
   
   
input 	       prbs_cid_en; //PRBS-CID dynamic signal

input   [4:0]  tx_boundary_sel;

output         full_tx;               // TX Phase comp. FIFO full flag
output         empty_tx;              // TX Phase comp. FIFO empty flag
output         tx_clk_out;
output  [7:0]  tx_data_tc;            // 8-bit tx data from tx_ctrl to XAUI TX SM
output         tx_ctl_tc;             // TX control/TX data bit 8 from tx_ctrl to XAUI TX SM
output  [19:0] pudr;                  // TX PCS 20-bit code group bus to TX PMA
output         rd_enable_sync;
output         refclk_b;              
output [19:0]  txlp20b;               // tx 20-bit code group bus to RX PCS for loopback
output         tx_pipe_clk;           // TX PIPE interface clock
output [9:0]   encoder_testbus;       // Test bus from 8B10B encoder
output [9:0]   tx_ctrl_testbus;       // Test bus from TX FIFO
output         tx_pipe_soft_reset;    // TX PIPE soft reset from TX FIFO
output         tx_pipe_electidle;     // TxElecIdle output from TX FIFO

	// TX PIPE interface signals
output			txdetectrxloopback_int;
//output			txelecidle; 	txd[9]
//output			txcompliance;	txd[10] and txd[32]
output	[1:0]	powerdown_int;
	
output			revloopback_int;

// push through TX Phase Comp FIFO
output			phfifo_txswing;
output			phfifo_txdeemph;
output	[2:0]	phfifo_txmargin;

	// RX PIPE interface signals
output			rxpolarity_int;
output			polinv_rx_int;
output	[2:0]		gray_eidleinfersel;

// TX PCS CRAMs
input          rrev_loopbk;	      // CRAM - Enable dynamic Reverse, PIPE mode
input          rbisten_tx;            // ENBIST CRAM
input 	       rforce_disp;	      // Acting with TXD[9, 19] forces current disparity to 1 or 0
input          rib_force_disp;        // Disparity force CRAM in IB mode
input          rforce_echar;          // Force /E/ char CRAM
input          rforce_kchar;          // Force /K/ char CRAM
input          rendec_tx;             // Enable 8B/10B encoder CRAM
input          rge_xaui_tx;           // GIGE Idle test enable CRAM
input          rdwidth_tx;            // TX parallel interface data width CRAM
input          rtxfifo_dis;           // TX FIFO disable CRAM
input          rcascaded_8b10b_en_tx; // Caascaded 8b/10b encoder enable CRAM
input          rprbsen_tx;            // PRBS generator enable CRAM
input   [2:0]  rprbs_sel;             // PRBS selection CRAM
input   [1:0]  rbist_sel;             // BIST selection CRAM
input   [1:0]  rcxpat_chnl_en;        // CRPAT or CJPAT selection CRAM
input          renpolinv_tx;          // TX Polarity inversion enable CRAM
input          rphfifopldentx;        // TX phase comp. FIFO PLD read/write enable CRAM
input          rphfifoursttx;         // TX phase comp. FIFO user reset enable CRAM
input          rfreerun_tx;           // TX_CLK out free running during TX PCS reset enable CRAM
input          rtxwrclksel;           // TX FIFO write clock selection CRAM
input          rtxrdclksel;           // TX FIFO read clock selection CRAM
input          renbitrev_tx;          // TX bit reversal enable CRAM
input          rensymswap_tx;         // TX symbol swap enable CRAM
input          r8b10b_enc_ibm_en;     // 8B10B Encoder fix enable CRAM
input          rtxfifo_lowlatency_en; // TX FIFO low latency enable CRAM
input          rpmadwidth_tx;         // TX PCS to TX PMA data width selection CRAM
input          rpma_doublewidth_tx;   // PCS/PMA double width (16/20) selection CRAM
input          rtx_pipe_enable;       // TX PIPE enable CRAM
input	       rcid_pattern_tx;       // CID pattern to be 0 or 1
input	[7:0]  rcid_len_tx;	      // Length of CID pattern in cycles

// Common PCS CRAMs
input          rindv_tx;              // TX SM bypassing CRAM
input          rendec_data_sel_tx;    // TX 8B10B encoder data in selection CRAM
input          rtxpcsbypass_en;       // CRAM for enable low-latency PCS bypass mode


   // new signal inputs for bundling
   input       tx_div2_sync_in_centrl;
   input       tx_div2_sync_in_quad_up;
   input       tx_div2_sync_in_quad_down;
   input       wr_enable_in_centrl;
   input       wr_enable_in_quad_up;
   input       wr_enable_in_quad_down;
   input       rd_enable_in_centrl;
   input       rd_enable_in_quad_up;
   input       rd_enable_in_quad_down;
   input       fifo_select_in_centrl;
   input       fifo_select_in_quad_up;
   input       fifo_select_in_quad_down;
   input       reset_pc_ptrs;
   input       reset_pc_ptrs_in_centrl;
   input       reset_pc_ptrs_in_quad_up;
   input       reset_pc_ptrs_in_quad_down;

   input       tx_div2_sync_in_pipe_quad_up;
   input       tx_div2_sync_in_pipe_quad_down;
   input       wr_enable_in_pipe_quad_up;
   input       wr_enable_in_pipe_quad_down;
   input       rd_enable_in_pipe_quad_up;
   input       rd_enable_in_pipe_quad_down;
   input       fifo_select_in_pipe_quad_up;
   input       fifo_select_in_pipe_quad_down;

   input        dis_pc_byte;
   
   // new MDIO inputs for bundling and auto speed
   input       rmaster_tx;
   input       rmaster_up_tx;
   input       rself_sw_en_tx;
   input       rpipeline_bypass_tx;
   input       rphfifo_regmode_tx;
      
   // new outputs for bundling and auto speed
   output      tx_div2_sync_out_pipe_up;
   output      fifo_select_out_pipe_up;
   output      wr_enable_out_pipe_up;
   output      rd_enable_out_pipe_up;   
   output      tx_div2_sync_out_pipe_down;
   output      fifo_select_out_pipe_down;
   output      wr_enable_out_pipe_down;
   output      rd_enable_out_pipe_down;
    
   // new signals in this module for bundling and auto speed
   wire        refclk_b_raw;
   wire        wr_clk_pos_raw;
   wire        fifo_rd_clk_raw;
   wire        nc_new_bundle1;
   wire        nc_new_bundle2;
   wire        nc_new_bundle3;
   wire        fifo_select_out_testbus;

  //CRAM for TX bitslip 
   input       rtxbitslip_en;
   // removed
   // txfifo_shared_sig_in_ch0
   // txfifo_shared_sig_in_q0_ch0
   // rphfifo_master_sel_tx
   // txfifo_shared_sig_out
      

// Wiring section
wire	       refclk_b;
wire           wr_clk_pos;
wire           fifo_rd_clk;
wire			soft_reset_wclk1;
wire    [7:0]  tx_data_tc_high;       // high 8-bit tx data from tx_ctrl
wire    [7:0]  tx_data_tc;            // low 8-bit tx data from tx_ctrl
wire           tx_ctl_tc_high;        // high tx control/tx data bit 8 from tx_ctrl
wire           tx_ctl_tc;             // low tx control/tx data bit 8 from tx_ctrl
wire	       rd_enable_sync;
wire	[1:0]  tx_ctl_pre_en;  
wire    [15:0] tx_data_pre_en;
wire    [1:0]  tx_data_9_pre_en;
wire    [15:0] tx_data_sg;            // 16-bit data sequence generated by bist_gen.
wire    [1:0]  tx_control_sg;         // 2-bit control sequence generated by selftest_gen.
wire    [1:0]  tx_data_9_tc;          // tx data bit 9 from tx_ctrl
wire    [19:0]  tx_data_pg;           // 20-bit tx code group generated by prbs_gen
wire           soft_reset_int;
wire    [1:0]  k_det, d21_5_eq_n, d2_2_eq_n;
wire 	[1:0]  txd_extend_tc;         // Extend txd by 2 bits. Used to force disparity. This will go to the encoder. 
				      // THis is input from the PLD Fabric
wire    [1:0]  disp_out_3b;           // Disparity output from encoder for testbus
wire 	       wr_enable2;
wire    [2:0]  wptr_bin;
wire 	       rd_enable2;
wire    [2:0]  rptr_bin;

wire [15:0] tx_data_tc_temp;
wire [1:0] tx_ctl_tc_temp;

// Gated soft reset by scan_mode signal
//assign soft_reset_int = (scan_mode) ? 1'b0 : txpcs_rst;
assign soft_reset_int =  txpcs_rst;

// TX PIPE interface clock
//assign tx_pipe_clk = wr_clk_pos;
assign tx_pipe_clk = fifo_rd_clk;

// Encoder testbus
assign encoder_testbus = {disp_out_3b, pudr[7:0]};

// TX FIFO testbus
assign tx_ctrl_testbus = {1'b0, fifo_select_out_testbus, wr_enable2, wptr_bin, rd_enable2, rptr_bin};
   
   
   // Clock selection module
   arriaii_hssi_tx_digi_txclk_ctl txclk_ctl_1 (
			  .pld_tx_clk(pld_tx_clk),
			  .refclk_pma(refclk_pma),             
			  .txpma_local_clk(txpma_local_clk),        
			  .txrst(txpcs_rst),                  
			  .scan_mode(scan_mode),              
			  .gen2ngen1(gen2ngen1),              
    			  .gen2ngen1_bundle(gen2ngen1_bundle),       
    			  .tx_div2_sync_centrl(tx_div2_sync_in_centrl),    
    			  .tx_div2_sync_quad_up(tx_div2_sync_in_quad_up),    
    			  .tx_div2_sync_quad_down(tx_div2_sync_in_quad_down),  
    			  .rindv_tx(rindv_tx),               
			  .rtxwrclksel(rtxwrclksel),            
			  .rtxrdclksel(rtxrdclksel),            
    			  .rdwidth_tx(rdwidth_tx),             
			  .rfreerun_tx(rfreerun_tx),            
    			  .rauto_speed_ena(rauto_speed_ena),        
    			  .rfreq_sel(rfreq_sel),              
    			  .rtxpcsclkpwdn(rtxpcsclkpwdn),          
    			  .rmaster_tx(rmaster_tx),              
    			  .rmaster_up_tx(rmaster_up_tx),           
			  .rself_sw_en_tx(rself_sw_en_tx),          
			  .refclk_b(refclk_b),               
			  .wr_clk_pos(wr_clk_pos),             
			  .fifo_rd_clk(fifo_rd_clk),            
			  .tx_clk_out(tx_clk_out),             
			  .refclk_b_raw(refclk_b_raw),            
			  .wr_clk_pos_raw(wr_clk_pos_raw),          
			  .fifo_rd_clk_raw(fifo_rd_clk_raw),         
			  .tx_div2_sync_out(nc_new_bundle1)  
			  );
   

// TX Phase compensation FIFO module
   arriaii_hssi_tx_digi_tx_ctrl           tx_ctrl_1 (
				.soft_reset (soft_reset_int),
				.fifo_wr_clk (wr_clk_pos),
				.fifo_rd_clk (fifo_rd_clk),
				.refclk_b_in (refclk_b),
				.scan_mode(scan_mode),
				.rindv_tx (rindv_tx),
				.p_rlpbk (1'b0),
				.selftest_en (rbisten_tx),
				.rdwidth_tx (rdwidth_tx),
				// S. Park 11/29/07 - Phase FIFO bypass feature removed
				// .txfifo_dis (rtxfifo_dis),
				.txfifo_dis (1'b0),
				.rtxfifo_urst_en(rphfifoursttx),
				.txfifo_urst(phfifourst_tx),
				.rtxfifo_lowlatency_en(rtxfifo_lowlatency_en),
				.rtxphfifopldctl_en(rphfifopldentx),
				.rtx_pipe_enable(rtx_pipe_enable),
				.pld_we(wrenable_tx),
				.pld_rd_dis(rddisable_tx),
				.txd ({txd[42:33],txd[31:22],txd[20:11],txd[9:0]}),
				.txd_extend ({txd[43],txd[32],txd[21],txd[10]}),               
				.rforce_disp (rforce_disp),
				.tx_data_sg ({16'h0000,tx_data_sg}),      
				.tx_control_sg ({2'b00,tx_control_sg}),   
				.rxd_lpbk (40'h0000000000),
				.redund_ctl (4'h0),
				.txd_redun (40'h0000000000),
				.rforce_kchar (rforce_kchar),
				.rforce_echar (rforce_echar),
				.rtxpcsbypass_en (rtxpcsbypass_en),
				// TX PIPE signals
				.txdetectrxloopback 	(txdetectrxloopback),
				.powerdown			(powerdown),
				.revloopback			(revloopback),
				.txswing				(txswing),
				.txdeemph				(pcs_txdeemph),
				.txmargin				(pcs_txmargin),
				// RX PIPE signals
				.rxpolarity			(rxpolarity),
				.polinv_rx			(polinv_rx),
				.eidleinfersel			(eidleinfersel),
				.reset_pc_ptrs(reset_pc_ptrs), 
    				.reset_pc_ptrs_centrl(reset_pc_ptrs_in_centrl), 
    				.reset_pc_ptrs_quad_up(reset_pc_ptrs_in_quad_up), 
    				.reset_pc_ptrs_quad_down(reset_pc_ptrs_in_quad_down), 
    				.gen2ngen1(gen2ngen1), 
    				.gen2ngen1_bundle(gen2ngen1_bundle), 
    				.dis_pc_byte(dis_pc_byte), 
    				.wr_enable_centrl(wr_enable_in_centrl), 
    				.wr_enable_quad_up(wr_enable_in_quad_up), 
    				.wr_enable_quad_down(wr_enable_in_quad_down), 
    				.rd_enable_centrl(rd_enable_in_centrl), 
    				.rd_enable_quad_up(rd_enable_in_quad_up), 
    				.rd_enable_quad_down(rd_enable_in_quad_down), 
				.fifo_select_in_centrl(fifo_select_in_centrl), 
    				.fifo_select_in_quad_up(fifo_select_in_quad_up), 
    				.fifo_select_in_quad_down(fifo_select_in_quad_down), 
    				.rauto_speed_ena(rauto_speed_ena), 
    				.rfreq_sel(rfreq_sel), 
    				.rphfifo_regmode_tx(rphfifo_regmode_tx), 
    				.rmaster_tx(rmaster_tx), 
    				.rmaster_up_tx(rmaster_up_tx), 
				.txd_extend_tc (txd_extend_tc),               
				.tx_data_tc (tx_data_tc_temp),             
				.tx_ctl_tc (tx_ctl_tc_temp),             
				.tx_data_9_tc (tx_data_9_tc),
				.rd_enable_sync (rd_enable_sync),
				.k_det (k_det),
				.d21_5_eq_n (d21_5_eq_n),
				.d2_2_eq_n (d2_2_eq_n),
				.wr_enable_out(nc_new_bundle2),  
				.rd_enable_out(nc_new_bundle3),  
				.fifo_select_out (fifo_select_out_testbus),  
				.ph_fifo_full(full_tx),
				.ph_fifo_empty(empty_tx),
				.soft_reset_wclk1(soft_reset_wclk1),
				.soft_reset_rclk1(tx_pipe_soft_reset),
				.pipe_electric_idle(tx_pipe_electidle),
				// TX PIPE signals
				.txdetectrxloopback_int		(txdetectrxloopback_int),
				.powerdown_int				(powerdown_int),
				.revloopback_int			(revloopback_int),
				.gray_eidleinfersel			(gray_eidleinfersel),
				
				.phfifo_txswing			(phfifo_txswing),
				.phfifo_txdeemph			(phfifo_txdeemph),
				.phfifo_txmargin			(phfifo_txmargin),
				
				// RX PIPE signals
				.rxpolarity_int			(rxpolarity_int),
				.polinv_rx_int				(polinv_rx_int),
				.wr_enable2(wr_enable2),
				.wptr_bin(wptr_bin),
				.rd_enable2(rd_enable2),
				.rptr_bin(rptr_bin)
				);           
assign tx_data_tc_high = tx_data_tc_temp[15:8];
assign tx_data_tc = tx_data_tc_temp[7:0];
assign tx_ctl_tc_high = tx_ctl_tc_temp[1];
assign tx_ctl_tc = tx_ctl_tc_temp[0];
// BIST generator module
arriaii_hssi_tx_digi_bist_gen selftest_gen_1  (
                          .tx_clk(wr_clk_pos),
                          .soft_reset(soft_reset_wclk1),
                          .rbisten_tx(rbisten_tx),
                          .rpmadwidth_tx(rpmadwidth_tx),
                          .rpma_doublewidth_tx(rpma_doublewidth_tx),
                          .rdwidth_tx(rdwidth_tx),
                          .rbist_sel(rbist_sel),
                          .rcxpat_chnl_sel(rcxpat_chnl_en),
                          .bist_data_sg(tx_data_sg),
                          .bist_ctl_sg(tx_control_sg)
                         );

// PRBS generator module
arriaii_hssi_tx_digi_prbs_gen prbs_gen_1      (
                          .tx_clk(refclk_b), 
                          .soft_reset(soft_reset_int), 
                          .rprbs_en_tx(rprbsen_tx), 
                          .rpmadwidth_tx(rpmadwidth_tx),
                          .rpma_doublewidth_tx(rpma_doublewidth_tx),
                          .cid_en(prbs_cid_en),
                          .rcid_len(rcid_len_tx),
                          .rcid_pattern(rcid_pattern_tx),
                          .rprbs_sel(rprbs_sel),
                          .prbs_out(tx_data_pg)
                         );

// 8B-10B Encoder module
arriaii_hssi_tx_digi_enc_chnl_top enc_chnl_top_1 (
                             .rst(soft_reset_int), 
                             .clk(refclk_b), 
                             .cascaded_8b10b_en(rcascaded_8b10b_en_tx),
                             .rendec_data_sel_tx(rendec_data_sel_tx), 
                             .rrev_loopbk(rrev_loopbk), 
                             .rev_loopbk(rev_loopbk),
                             .dwidth(rpmadwidth_tx),
                             .doublewidth(rpma_doublewidth_tx),
                             .endec(rendec_tx), 
                             .ge_xaui_sel(rge_xaui_tx), 
                             .rforce_disp(rforce_disp), 
                             .ib_force_disparity(rib_force_disp), 
                             .prbs_en(rprbsen_tx), 
                             .r8b10b_enc_ibm_en(r8b10b_enc_ibm_en),
                             .rev_loop_data(rev_loop_data),
                             .tx_ctl_ts(tx_ctl_ts),
                             .tx_ctl_tc({tx_ctl_tc_high,tx_ctl_tc}),
                             .tx_data_ts(tx_data_ts),
                             .txd_extend_tc(txd_extend_tc),
                             .tx_data_tc({tx_data_tc_high,tx_data_tc}), 
                             .tx_data_9_tc(tx_data_9_tc),
                             .tx_data_pg(tx_data_pg),
                             .k_det(k_det[0]),
                             .d21_5_eq_n(d21_5_eq_n[0]),
                             .d2_2_eq_n(d2_2_eq_n[0]),
                             .renpolinv_tx(renpolinv_tx),
                             .enpolinv_tx(polinv_tx),
                             .renbitrev_tx(renbitrev_tx),
                             .rensymswap_tx(rensymswap_tx),
                             .rtxbitslip_en(rtxbitslip_en),  
                             .tx_boundary_sel(tx_boundary_sel),
                             .pudr(pudr), 
                             .txlp20b(txlp20b),
                             .tx_data_pre_en(tx_data_pre_en),
                             .tx_data_9_pre_en(tx_data_9_pre_en), 
                             .tx_ctl_pre_en(tx_ctl_pre_en),
                             .disp_out_3b(disp_out_3b)
                             );

   
   arriaii_hssi_tx_digi_iq_pipe_tx iqp_out_up (
						      .refclk_b_raw(refclk_b_raw),
    						      .wr_clk_pos_raw(wr_clk_pos_raw),
						      .fifo_rd_clk_raw(fifo_rd_clk_raw),
    						      .txrst(txpcs_rst),
    						      .soft_reset_rclk1(tx_pipe_soft_reset),
    						      .soft_reset_wclk1(soft_reset_wclk1),
    						      .tx_div2_sync_in_centrl(tx_div2_sync_in_centrl),   
    						      .tx_div2_sync_in_pipe_quad_up(1'b0),  
    						      .tx_div2_sync_in_pipe_quad_down(tx_div2_sync_in_pipe_quad_down),
    						      .wr_enable_in_centrl(wr_enable_in_centrl),
    						      .wr_enable_in_pipe_quad_up(1'b0),
    						      .wr_enable_in_pipe_quad_down(wr_enable_in_pipe_quad_down),
    						      .rd_enable_in_centrl(rd_enable_in_centrl),
    						      .rd_enable_in_pipe_quad_up(1'b0),
    						      .rd_enable_in_pipe_quad_down(rd_enable_in_pipe_quad_down),
    						      .fifo_select_in_centrl(fifo_select_in_centrl),
    						      .fifo_select_in_pipe_quad_up(1'b0),
    						      .fifo_select_in_pipe_quad_down(fifo_select_in_pipe_quad_down),
						      .rmaster_tx(rmaster_tx),
    						      .rmaster_up_tx(rmaster_up_tx),
    						      .rpipeline_bypass_tx(rpipeline_bypass_tx),
    						      .rfreerun_tx(rfreerun_tx),
						      .tx_div2_sync_out_pipe(tx_div2_sync_out_pipe_up),
    						      .fifo_select_out_pipe(fifo_select_out_pipe_up),
    						      .wr_enable_out_pipe(wr_enable_out_pipe_up),
    						      .rd_enable_out_pipe(rd_enable_out_pipe_up)
						      );

   arriaii_hssi_tx_digi_iq_pipe_tx iqp_out_down (
							.refclk_b_raw(refclk_b_raw),
    							.wr_clk_pos_raw(wr_clk_pos_raw),
							.fifo_rd_clk_raw(fifo_rd_clk_raw),
    							.txrst(txpcs_rst),
    							.soft_reset_rclk1(tx_pipe_soft_reset),
    							.soft_reset_wclk1(soft_reset_wclk1),
    							.tx_div2_sync_in_centrl(tx_div2_sync_in_centrl),   
    							.tx_div2_sync_in_pipe_quad_up(tx_div2_sync_in_pipe_quad_up),  
    							.tx_div2_sync_in_pipe_quad_down(1'b0),
    							.wr_enable_in_centrl(wr_enable_in_centrl),
    							.wr_enable_in_pipe_quad_up(wr_enable_in_pipe_quad_up),
    							.wr_enable_in_pipe_quad_down(1'b0),
    							.rd_enable_in_centrl(rd_enable_in_centrl),
    							.rd_enable_in_pipe_quad_up(rd_enable_in_pipe_quad_up),
    							.rd_enable_in_pipe_quad_down(1'b0),
    							.fifo_select_in_centrl(fifo_select_in_centrl),
    							.fifo_select_in_pipe_quad_up(fifo_select_in_pipe_quad_up),
    							.fifo_select_in_pipe_quad_down(1'b0),
							.rmaster_tx(rmaster_tx),
    							.rmaster_up_tx(rmaster_up_tx),
    							.rpipeline_bypass_tx(rpipeline_bypass_tx),
    							.rfreerun_tx(rfreerun_tx),
							.tx_div2_sync_out_pipe(tx_div2_sync_out_pipe_down),
    							.fifo_select_out_pipe(fifo_select_out_pipe_down),
    							.wr_enable_out_pipe(wr_enable_out_pipe_down),
    							.rd_enable_out_pipe(rd_enable_out_pipe_down)
							);
   

endmodule // digi_tx


////////////////////////////////////////////////////////////////////////////////
// hssi_module: transmitter **************************************************//
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// DPRIO INDEX TABLE --------------------------------------------------------//
///////////////////////////////////////////////////////////////////////////////

// Table1: PCS Per Channel TX Control Register 1 for Channel 0
`define rforce_disp_TXPCS_IDX_0         0
`define rrev_loopbk_TXPCS_IDX_0         1
`define rtxrdclksel_TXPCS_IDX_0         2
`define rtxwrclksel_TXPCS_IDX_0         3
`define rfreerun_tx_TXPCS_IDX_0         4
`define rtxurstpcs_TXPCS_IDX_0         5
`define reserved_0_TB1_TXPCS_IDX_0         6
`define rphfifoursttx_TXPCS_IDX_0         7
`define rphfifopldentx_TXPCS_IDX_0         8
`define rge_xaui_tx_TXPCS_IDX_0         9
`define rdwidth_tx_TXPCS_IDX_0         10
`define rtxfifo_lowlatency_en_TXPCS_IDX_0         11
`define rib_force_disp_TXPCS_IDX_0         12
`define rtxfifo_dis_TXPCS_IDX_0         13
`define rforce_echar_TXPCS_IDX_0         14
`define rforce_kchar_TXPCS_IDX_0         15

// Table2: PCS Per Channel TX Control Register 2 for Channel 0
`define rtxpcsbypass_en_TXPCS_IDX_0         16
`define rcxpat_chnl_en_TXPCS_IDX_0         17
`define rcxpat_chnl_en_TXPCS_IDX_1         18
`define rbist_sel_TXPCS_IDX_0         19
`define rbist_sel_TXPCS_IDX_1         20
`define rbisten_tx_TXPCS_IDX_0         21
`define rprbs_sel_TXPCS_IDX_0         22
`define rprbs_sel_TXPCS_IDX_1         23
`define rprbs_sel_TXPCS_IDX_2         24
`define rprbsen_tx_TXPCS_IDX_0         25
`define renbitrev_tx_TXPCS_IDX_0         26
`define renpolinv_tx_TXPCS_IDX_0         27
`define rensymswap_tx_TXPCS_IDX_0         28
`define rcascaded_8b10b_en_tx_TXPCS_IDX_0         29
`define r8b10b_enc_ibm_en_TXPCS_IDX_0         30
`define rendec_tx_TXPCS_IDX_0         31

// Table3: PCS Per Channel TX Control Register 3 for Channel 0
`define reserved_0_TB3_TXPCS_IDX_0         32
`define rcid_len_tx_TXPCS_IDX_0         33
`define rcid_len_tx_TXPCS_IDX_1         34
`define rcid_len_tx_TXPCS_IDX_2         35
`define rcid_len_tx_TXPCS_IDX_3         36
`define rcid_len_tx_TXPCS_IDX_4         37
`define rcid_len_tx_TXPCS_IDX_5         38
`define rcid_len_tx_TXPCS_IDX_6         39
`define rcid_len_tx_TXPCS_IDX_7         40
`define rcid_pattern_tx_TXPCS_IDX_0         41
`define rtxpcsclkpwdn_TXPCS_IDX_0         42
`define rtxswing_sel_ena_TXPCS_IDX_0         43
`define rtx_elec_idle_delay_TXPCS_IDX_0         44
`define rtx_elec_idle_delay_TXPCS_IDX_1         45
`define rtx_elec_idle_delay_TXPCS_IDX_2         46
`define rtx_pipe_enable_TXPCS_IDX_0         47

// Table4: PCS Per Channel TX Control Register 4 for Channel 0
`define reserved_0_TB4_TXPCS_IDX_0         48
`define reserved_0_TB4_TXPCS_IDX_1         49
`define reserved_0_TB4_TXPCS_IDX_2         50
`define reserved_0_TB4_TXPCS_IDX_3         51
`define reserved_0_TB4_TXPCS_IDX_4         52
`define reserved_0_TB4_TXPCS_IDX_5         53
`define reserved_0_TB4_TXPCS_IDX_6         54
`define reserved_0_TB4_TXPCS_IDX_7         55
`define reserved_0_TB4_TXPCS_IDX_8         56
`define reserved_0_TB4_TXPCS_IDX_9         57
`define reserved_0_TB4_TXPCS_IDX_10         58
`define reserved_0_TB4_TXPCS_IDX_11         59
`define rtxbitslip_en_TXPCS_IDX_0         60
`define rphfifo_regmode_tx_TXPCS_IDX_0         61
`define rpipeline_bypass_tx_TXPCS_IDX_0         62
`define rself_sw_en_tx_TXPCS_IDX_0         63

// Existing
`define rauto_speed_ena_TX_IDX          64
`define rendec_data_sel_tx_TX_IDX       65
`define rfreq_sel_TX_IDX                66
`define rhip_ena_TX_IDX                 67
`define rindv_tx_TX_IDX                 68
`define rphfifo_master_sel_tx_TX_IDX    69
`define rpma_doublewidth_tx_TX_IDX      70
`define rpmadwidth_tx_TX_IDX            71
`define rtx_cmu_sel_TX_IDX              72
`define rmaster_tx_TX_IDX               73
`define rmaster_up_tx_TX_IDX            74

`timescale 1 ps / 1 ps
module arriaii_hssi_tx_pcs (
    bitslipboundaryselect,
    coreclk,
    ctrlenable,
    datain,
    datainfull,
    detectrxloop,
    digitalreset,
    dispval,
    dpriodisable,
    dprioin,
    elecidleinfersel,
    enrevparallellpbk,
    forcedisp,
    forcedispcompliance,   //to remove
    forceelecidle,
    freezptr,
    hipdatain,
    hipdetectrxloop,
    hipelecidleinfersel,
    hipforceelecidle,
    hippowerdn,
    hiptxdeemph,
    hiptxmargin,
    invpol,
    iqpphfifoxnbytesel,
    iqpphfifoxnrdclk,
    iqpphfifoxnrdenable,
    iqpphfifoxnwrenable,
    localrefclk,
    phfifobyteserdisable,
    phfifoptrsreset,
    phfiforddisable,
    phfiforeset,
    phfifowrenable,
    phfifox4bytesel,
    phfifox4rdclk,
    phfifox4rdenable,
    phfifox4wrenable,
    phfifoxnbottombytesel,
    phfifoxnbottomrdclk,
    phfifoxnbottomrdenable,
    phfifoxnbottomwrenable,
    phfifoxnbytesel,
    phfifoxnptrsreset,
    phfifoxnrdclk,
    phfifoxnrdenable,
    phfifoxntopbytesel,
    phfifoxntoprdclk,
    phfifoxntoprdenable,
    phfifoxntopwrenable,
    phfifoxnwrenable,
    pipestatetransdone,
    pipetxdeemph,                    // RTL=txdeemph,
    pipetxmargin,                    // RTL=txmargin[2:0]
    pipetxswing,                     // RTL=txswing
    powerdn,
    prbscidenable,
    quadreset,
    rateswitch,                      // RTL=rate
    rateswitchisdone,
    rateswitchxndone,
    refclk,
    revparallelfdbk,
    xgmctrl,
    xgmdatain,

    clkout,
    coreclkout,
    dataout,
    dprioout,
    forceelecidleout,
    grayelecidleinferselout,
    hiptxclkout,
    iqpphfifobyteselout,
    iqpphfifordclkout,
    iqpphfifordenableout,
    iqpphfifowrenableout,
    parallelfdbkout,
    phfifobyteselout,
    phfifooverflow,
    phfifordclkout,
    phfiforddisableout,
    phfifordenableout,
    phfiforesetout,
    phfifounderflow,
    phfifowrenableout,
    pipeenrevparallellpbkout,
    pipepowerdownout,
    pipepowerstateout,
    rateswitchout,                   // RTL=rate_int
    rdenablesync,
    txdetectrx,
    xgmctrlenable,
    xgmdataout
);

`define ARRIAII_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH 25

parameter lpm_type                 = "arriaii_hssi_tx_pcs";
parameter allow_polarity_inversion = "false";
parameter auto_spd_self_switch_enable = "false";
parameter bitslip_enable              = "false";
parameter channel_bonding          = "none";   // none, x8, x4
parameter channel_number           = 0;
parameter channel_width            = 8;
parameter core_clock_0ppm          = "false";
parameter datapath_low_latency_mode   = "false";
parameter datapath_protocol           = "basic";   //replaced by protocol_hint
parameter disable_ph_low_latency_mode = "false";
parameter disparity_mode           = "none";   // legacy, new, none
parameter dprio_config_mode        = 6'h00;
parameter elec_idle_delay          = 6;  // new in 6.0 <3-6>
parameter enable_bit_reversal      = "false";
parameter enable_idle_selection    = "false";  
parameter enable_phfifo_bypass     = "false"; 
parameter enable_reverse_parallel_loopback = "false";
parameter enable_self_test_mode    = "false";
parameter enable_symbol_swap       = "false";
parameter enc_8b_10b_compatibility_mode    = "true"; 
parameter enc_8b_10b_mode          = "none";   // cascade, normal, none
parameter force_echar              = "false";
parameter force_kchar              = "false";
parameter hip_enable               = "false";
parameter iqp_bypass               = "false";
parameter iqp_ph_fifo_xn_select    =  9999 ;
parameter logical_channel_address  =  0 ;
parameter ph_fifo_reg_mode         = "false";
parameter ph_fifo_reset_enable     = "false";
parameter ph_fifo_user_ctrl_enable = "false";
parameter ph_fifo_xn_mapping0      = "none";   
parameter ph_fifo_xn_mapping1      = "none";   
parameter ph_fifo_xn_mapping2      = "none";   
parameter ph_fifo_xn_select        =  9999 ;
parameter pipe_auto_speed_nego_enable = "false";
parameter pipe_freq_scale_mode        = "data width";
parameter pipe_voltage_swing_control = "false";
parameter prbs_all_one_detect      = "false";
parameter prbs_cid_pattern         = "false";
parameter prbs_cid_pattern_length  =  0 ;
parameter protocol_hint            = "basic";
parameter refclk_select            = "local";        // cmu_clk_divider
parameter reset_clock_output_during_digital_reset = "false"; 
parameter self_test_mode           = "incremental";      
parameter use_double_data_mode     = "false"; 
parameter use_serializer_double_data_mode = "false";
parameter wr_clk_mux_select        = "core_clk";  // INT_CLK                  // int_clk

// SIMULATION_ONLY_PARAMETERS_BEGIN

parameter use_top_quad_as_mater    = "true";   // NEW_PARAM todo: select top/bottom to provide phfifo pointers
parameter dprio_width   = 150;
parameter migrated_from_prev_family = "false";

// SIMULATION_ONLY_PARAMETERS_END

// LOCAL_PARAMETERS_BEGIN

parameter mph_fifo_xn_mapping = (ph_fifo_xn_select == 0) ? ph_fifo_xn_mapping0 :(ph_fifo_xn_select == 1) ? ph_fifo_xn_mapping1 :(ph_fifo_xn_select == 2) ? ph_fifo_xn_mapping2 : "none";                               
parameter MPHFIFO_INDEX     = (ph_fifo_xn_select == 0 || ph_fifo_xn_select == 1 || ph_fifo_xn_select == 2) ? ph_fifo_xn_select : 0;
parameter MIQP_PHFIFO_INDEX = (ph_fifo_xn_select == 0 || ph_fifo_xn_select == 1) ? ph_fifo_xn_select : 0;
parameter DPRIO_CHANNEL_INTERFACE_BIT = 4;

// LOCAL_PARAMETERS_END

input [4 : 0]              bitslipboundaryselect;
input                      coreclk;
input [3 : 0]              ctrlenable;
input [39:0]               datain;
input [43:0]               datainfull;
input                      detectrxloop;
input                      digitalreset;
input [3 : 0]              dispval;
input                      dpriodisable;
input [149 : 0]            dprioin;
input  [2 : 0]             elecidleinfersel;
input                      enrevparallellpbk;
input  [3 : 0]             forcedisp;             //fix_width
input                      forcedispcompliance;
input                      forceelecidle;
input                      freezptr;
input  [9 : 0]             hipdatain;
input                      hipdetectrxloop;
input  [2 : 0]             hipelecidleinfersel; // hip_eidleinfersel of digi_chnl_hip_support
input                      hipforceelecidle;
input  [1 : 0]             hippowerdn;
input                      hiptxdeemph;
input  [2 : 0]             hiptxmargin;
input                      invpol;
input  [1 : 0]             iqpphfifoxnbytesel;
input  [1 : 0]             iqpphfifoxnrdclk;
input  [1 : 0]             iqpphfifoxnrdenable;
input  [1 : 0]             iqpphfifoxnwrenable;
input                      localrefclk;
input                      phfifobyteserdisable;
input                      phfifoptrsreset;
input                      phfiforddisable;
input                      phfiforeset;
input                      phfifowrenable;
input                      phfifox4bytesel;
input                      phfifox4rdclk;
input                      phfifox4rdenable;
input                      phfifox4wrenable;
input                      phfifoxnbottombytesel;
input                      phfifoxnbottomrdclk;
input                      phfifoxnbottomrdenable;
input                      phfifoxnbottomwrenable;
input  [2 : 0]             phfifoxnbytesel;
input  [2 : 0]             phfifoxnptrsreset;
input  [2 : 0]             phfifoxnrdclk;
input  [2 : 0]             phfifoxnrdenable;
input                      phfifoxntopbytesel;
input                      phfifoxntoprdclk;
input                      phfifoxntoprdenable;
input                      phfifoxntopwrenable;
input  [2 : 0]             phfifoxnwrenable;
input                      pipestatetransdone;
input                      pipetxdeemph;           // RTL=txdeemph;
input [2:0]                pipetxmargin;           // RTL=txmargin[2:0]
input                      pipetxswing;            // RTL=txswing
input [1:0]                   powerdn;
input                      prbscidenable;
input                      quadreset;
input                      rateswitch;
input                      rateswitchisdone;
input                      rateswitchxndone;
input                      refclk;
input [19:0]               revparallelfdbk;
input                      xgmctrl;
input [7:0]                   xgmdatain;

output                     clkout;
output                     coreclkout;
output [19:0]              dataout;
output [149 : 0]           dprioout;
output                     forceelecidleout;
output [2 : 0]             grayelecidleinferselout;  //gray_eidleinfersel(2:0)
output                     hiptxclkout;
output                     iqpphfifobyteselout;
output                     iqpphfifordclkout;
output                     iqpphfifordenableout;
output                     iqpphfifowrenableout;
output [19:0]              parallelfdbkout;
output                     phfifooverflow;
output                     phfifobyteselout;
output                     phfifordclkout;
output                     phfiforddisableout;
output                     phfifordenableout;
output                     phfiforesetout;
output                     phfifounderflow;
output                     phfifowrenableout;
output                     pipeenrevparallellpbkout;
output [1:0]               pipepowerdownout;   
output [3:0]               pipepowerstateout;
output                     rateswitchout;
output                     rdenablesync;
output                     txdetectrx;
output                     xgmctrlenable;
output [7:0]               xgmdataout;

wire  [3  : 0]   tmp_ctrlenable;
wire  [39 : 0]   tmp_datain;
wire  [3  : 0]   tmp_dispval;
wire  [3  : 0]   tmp_forcedisp;

// ---------------------------------------------------------------------------
// Initial CRAM  
// ---------------------------------------------------------------------------
// atom level initial CRAM ---------------------------------------------------
// Existing
reg init_is_lane0;
reg init_rauto_speed_ena;
reg init_rclkcmpinsertpad;             // rx only ========= pipe ===========    
reg init_rendec_data_sel_tx;
reg init_rfreq_sel;
reg init_rhip_ena;
reg init_rindv_tx;
reg init_rmaster_tx;
reg init_rmaster_up_tx;
reg init_rphfifo_master_sel_tx;
reg init_rpma_doublewidth_tx;
reg init_rpmadwidth_tx;
reg init_rrdwidth_rx;                  // rx only
reg init_rrx_detect_bypass;            // rx only
reg init_rrx_pipe_enable;              // rx only
reg init_rtx_cmu_sel;          // added in 6.1
reg init_scan_mode;

// PCS Per Channel TX Control Register 1 for Channel 0
reg init_rforce_disp;
reg init_rrev_loopbk;
reg init_rtxrdclksel;
reg init_rtxwrclksel;
reg init_rfreerun_tx;
reg init_rtxurstpcs;
reg init_reserved_0_TB1;
reg init_rphfifoursttx;
reg init_rphfifopldentx;
reg init_rge_xaui_tx;
reg init_rdwidth_tx;
reg init_rtxfifo_lowlatency_en;
reg init_rib_force_disp;
reg init_rtxfifo_dis;
reg init_rforce_echar;
reg init_rforce_kchar;

// PCS Per Channel TX Control Register 2 for Channel 0
reg init_rtxpcsbypass_en;
reg [1:0] init_rcxpat_chnl_en;
reg [1:0] init_rbist_sel;
reg init_rbisten_tx;
reg [2:0] init_rprbs_sel;
reg init_rprbsen_tx;
reg init_renbitrev_tx;
reg init_renpolinv_tx;
reg init_rensymswap_tx;
reg init_rcascaded_8b10b_en_tx;
reg init_r8b10b_enc_ibm_en;
reg init_rendec_tx;

// PCS Per Channel TX Control Register 3 for Channel 0
reg init_reserved_0_TB3;
reg [7:0] init_rcid_len_tx;
reg init_rcid_pattern_tx;
reg init_rtxpcsclkpwdn;
reg init_rtxswing_sel_ena;
reg [2:0] init_rtx_elec_idle_delay;
reg init_rtx_pipe_enable;

// PCS Per Channel TX Control Register 4 for Channel 0
reg [11:0] init_reserved_0_TB4;
reg init_rtxbitslip_en;
reg init_rphfifo_regmode_tx;
reg init_rpipeline_bypass_tx;
reg init_rself_sw_en_tx;
                             
////////////////////////////////////////////////////////////////////////////////
// sub-block interface: pcs_reset     ----------------------------------------//
////////////////////////////////////////////////////////////////////////////////

wire   pr_in_hard_reset;
wire   pr_in_clk_2_b;
wire   pr_in_refclk_b_in;
wire   pr_in_scan_mode;
wire   pr_in_rxpcs_rst;
wire   pr_in_txpcs_rst;
wire   pr_out_txrst_int;

////////////////////////////////////////////////////////////////////////////////
// sub-block interface: chnl_hip_spt  ----------------------------------------//
////////////////////////////////////////////////////////////////////////////////

wire [2:0]  hs_in_eidleinfersel_ch;
wire [2:0]  hs_in_hip_eidleinfersel_ch;
wire [1:0]  hs_in_hip_powerdown_ch;
wire        hs_in_hip_rate;
wire        hs_in_hip_rxpolarity;
wire [9:0]  hs_in_hip_txd_ch;
wire        hs_in_hip_txdeemph;
wire        hs_in_hip_txdetectrxloopback;
wire        hs_in_hip_txelecidle;
wire [2:0]  hs_in_hip_txmargin_ch;
wire        hs_in_pcs_phystatus;
wire [8:0]  hs_in_pcs_rxd_ch;
wire        hs_in_pcs_rxelecidle;
wire [2:0]  hs_in_pcs_rxstatus_ch;
wire        hs_in_pcs_rxvalid;
wire [1:0]  hs_in_powerdown_ch;
wire        hs_in_rate;
wire        hs_in_rhip_ena;
wire        hs_in_rxpolarity;
wire [10:0] hs_in_txd_ch;
wire        hs_in_txdeemph;
wire        hs_in_txdetectrxloopback;
wire [2:0]  hs_in_txmargin_ch;
wire        hs_in_txpma_local_clk;

wire        hs_out_hip_phystatus;
wire [8:0]  hs_out_hip_rxd_ch;
wire        hs_out_hip_rxelecidle;
wire [2:0]  hs_out_hip_rxstatus_ch;
wire        hs_out_hip_rxvalid;
wire        hs_out_hip_tx_clk;
wire [2:0]  hs_out_pcs_eidleinfersel_ch;
wire [1:0]  hs_out_pcs_powerdown_ch;
wire        hs_out_pcs_rate;
wire        hs_out_pcs_rxpolarity;
wire [10:0] hs_out_pcs_txd_ch;
wire        hs_out_pcs_txdeemph;
wire        hs_out_pcs_txdetectrxloopback;
wire [2:0]  hs_out_pcs_txmargin_ch;
wire        hs_out_phystatus;
wire [8:0]  hs_out_rxd_ch;
wire        hs_out_rxelecidle;
wire [2:0]  hs_out_rxstatus_ch;
wire        hs_out_rxvalid;

////////////////////////////////////////////////////////////////////////////////
// sub-block interface: pipe_interface  --------------------------------------//
////////////////////////////////////////////////////////////////////////////////

// inputs
wire         pi_in_pipe_tx_clk;
wire  [1:0]  pi_in_powerdown;
wire         pi_in_refclk_b;
wire         pi_in_refclk_b_reset_n;
wire         pi_in_revloopback;
wire         pi_in_state_transition_done;
wire         pi_in_tx_elec_idle_comp;
wire         pi_in_tx_pipe_reset_n;
wire  [43:0] pi_in_txd_ch;
wire  [43:0] pi_in_txd_ch_dprio;             // new in 6.1
wire         pi_in_txdetectrxloopback;
wire         pi_in_txelecidle;
wire  [43:0] pi_in_txd_ch_tmp;               // before interleaving in dwidth_single PMA

// outputs
wire  [3:0]  pi_out_powerstate; // to top - both cmu and rx
wire         pi_out_rev_loopbk;       // to TD
wire         pi_out_tx_elec_idle;     // to tx PMA - TX sending electrical idle
wire  [43:0] pi_out_txd;
wire         pi_out_txdetectrx;       // to tx PMA - RX_DET

// new input in ARRIAII - ww26.5 =====================================
// from PLD
wire         pi_in_txdeemph;
wire  [2:0]  pi_in_txmargin;
wire         pi_in_txswing;

// new output in ARRIAII - ww26.5 ====================================
// exposed to digi_top
wire         pi_out_txdeemph_int;
wire  [2:0]  pi_out_txmargin_int;
wire         pi_out_txswing_int;

////////////////////////////////////////////////////////////////////////////////
// sub-block interface: tx digital  ------------------------------------------//
////////////////////////////////////////////////////////////////////////////////

// inputs
wire         td_in_phfifourst_tx;
wire         td_in_pld_tx_clk;
wire         td_in_polinv_tx;
wire         td_in_rddisable_tx;
wire         td_in_refclk_pma;
wire  [19:0] td_in_rev_loop_data;
wire         td_in_rev_loopbk;
wire         td_in_tx_ctl_ts;
wire  [7:0]  td_in_tx_data_ts;
wire  [43:0] td_in_txd;
wire         td_in_txpcs_rst;
wire         td_in_txpma_local_clk;
wire         td_in_wrenable_tx;

// new input in ARRIAII - ww26.5 ======================================

// freeze pointer for TX/RX phase comp FIFO during freq negotiation
// to tx_ctrl from rx_digi (auto_speed_neg sub-block) 
wire         td_in_freeze_ptr; 
// to tx_ctrl from TX PMA local clock divider 
wire         td_in_gen2ngen1; 
// to tx_ctrl from central clock divider 
wire         td_in_gen2ngen1_bundle;
// to tx_ctrl from PLD (RX polarity inversion dynamic control)
//       paired with polinv_tx
// path: polinv_rx (pld) -> tx_digi (tx_ctrl after encoder) ->
//    (just a simple wire in tx_ctrl so leaving it out of tx)
//       rx_pipe (mux with rxpolarity) -> rx_digi (wordalign and decoder)
wire         td_in_polinv_rx;
// to tx_ctrl from PLD
// generating powerdown_int output feeding both rx_pipe and tx_pipe
wire [1:0]   td_in_powerdown;    
// to tx_ctrl from quad pcs top
// generating rate_int output feeding rx_digi (auto_speed_neg)
wire         td_in_rate;
// to tx_ctrl from quad pcs top
// generating revloopback_int output feeding tx_pipe
wire         td_in_revloopback;
// to tx_ctrl from quad pcs top (no functionality change)
// path: rxpolarity (pld) -> tx_digi (tx_ctrl)->
//       rx_pipe (muxing with polinv_rx) --> rx_digi
wire         td_in_rxpolarity;
// to tx_ctrl from quad pcs top
//    (just a simple wire in tx_ctrl so leaving it out of tx)
// generating txdetectrxloopback_int output feeding tx_pipe
wire         td_in_txdetectrxloopback;

// new output in ARRIAII - ww26.5 ===================================
// to rx_digi muxed with rxpolarity_int
wire         td_out_polinv_rx_int;
// to rx_pipe and tx_pipe
wire [1:0]   td_out_powerdown_int;
// to tx_pipe
wire         td_out_revloopback_int;
// to rx_digi (mux with polinv_rx_int)
wire         td_out_rxpolarity_int;
// to tx_pipe
wire         td_out_txdetectrxloopback_int;

// outputs
wire         td_out_empty_tx;
wire  [9:0]  td_out_encoder_testbus;
wire         td_out_full_tx;
wire  [19:0] td_out_pudr;
wire         td_out_rd_enable_sync;
wire         td_out_refclk_b;
wire         td_out_tx_clk_out;
wire         td_out_tx_ctl_tc;
wire  [9:0]  td_out_tx_ctrl_testbus;
wire  [7:0]  td_out_tx_data_tc;
wire         td_out_tx_pipe_clk;
wire         td_out_tx_pipe_electidle;
wire         td_out_tx_pipe_soft_reset;
wire  [3:0]  td_out_txfifo_shared_sig_out;
wire  [19:0] td_out_txlp20b;

wire         td_in_prbs_cid_en; //PRBS-CID dynamic signal
wire [4:0]   td_in_tx_boundary_sel;

// new signal inputs for bundling
wire td_in_tx_div2_sync_in_centrl;
wire td_in_tx_div2_sync_in_quad_up;
wire td_in_tx_div2_sync_in_quad_down;
wire td_in_wr_enable_in_centrl;
wire td_in_wr_enable_in_quad_up;
wire td_in_wr_enable_in_quad_down;
wire td_in_rd_enable_in_centrl;
wire td_in_rd_enable_in_quad_up;
wire td_in_rd_enable_in_quad_down;
wire td_in_fifo_select_in_centrl;
wire td_in_fifo_select_in_quad_up;
wire td_in_fifo_select_in_quad_down;
wire td_in_reset_pc_ptrs;
wire td_in_reset_pc_ptrs_in_centrl;
wire td_in_reset_pc_ptrs_in_quad_up;
wire td_in_reset_pc_ptrs_in_quad_down;

wire td_in_tx_div2_sync_in_pipe_quad_up;
wire td_in_tx_div2_sync_in_pipe_quad_down;
wire td_in_wr_enable_in_pipe_quad_up;
wire td_in_wr_enable_in_pipe_quad_down;
wire td_in_rd_enable_in_pipe_quad_up;
wire td_in_rd_enable_in_pipe_quad_down;
wire td_in_fifo_select_in_pipe_quad_up;
wire td_in_fifo_select_in_pipe_quad_down;

wire td_in_dis_pc_byte;
   
// new outputs for bundling and auto speed
wire td_out_tx_div2_sync_out_pipe;
wire td_out_fifo_select_out_pipe;
wire td_out_wr_enable_out_pipe;
wire td_out_rd_enable_out_pipe;

// push through TX Phase Comp FIFO
wire       td_in_txswing;
wire       td_in_pcs_txdeemph;
wire [2:0] td_in_pcs_txmargin;

// RX PIPE interface signals
wire [2:0] td_in_eidleinfersel;

// push through TX Phase Comp FIFO
wire       td_out_phfifo_txswing;
wire       td_out_phfifo_txdeemph;
wire [2:0] td_out_phfifo_txmargin;

// RX PIPE interface signals
wire [2:0] td_out_gray_eidleinfersel;

// new outputs for bundling and auto speed
// splitting _out_pipe into _up and _down
wire       td_out_tx_div2_sync_out_pipe_up;
wire       td_out_fifo_select_out_pipe_up;
wire       td_out_wr_enable_out_pipe_up;
wire       td_out_rd_enable_out_pipe_up;   
wire       td_out_tx_div2_sync_out_pipe_down;
wire       td_out_fifo_select_out_pipe_down;
wire       td_out_wr_enable_out_pipe_down;
wire       td_out_rd_enable_out_pipe_down;

// ---------------------------------------------------------------------------
// DPRIO input CRAM  
// ---------------------------------------------------------------------------
// atom level DPRIO input CRAM ------------------------------------------------
// Existing
wire dprioin_is_lane0;
wire dprioin_rauto_speed_ena;
wire dprioin_rclkcmpinsertpad;         // rx only ========= pipe ===========    
wire dprioin_rendec_data_sel_tx;
wire dprioin_rfreq_sel;
wire dprioin_rhip_ena;
wire dprioin_rindv_tx;
wire dprioin_rmaster_tx;
wire dprioin_rmaster_up_tx;
wire dprioin_rphfifo_master_sel_tx;
wire dprioin_rpma_doublewidth_tx;
wire dprioin_rpmadwidth_tx;
wire dprioin_rrdwidth_rx;              // rx only
wire dprioin_rrx_detect_bypass;        // rx only
wire dprioin_rrx_pipe_enable;          // rx only
wire dprioin_rtx_cmu_sel;                 // added in 6.1
wire dprioin_scan_mode;

// PCS Per Channel TX Control Register 1 for Channel 0
wire dprioin_rforce_disp;
wire dprioin_rrev_loopbk;
wire dprioin_rtxrdclksel;
wire dprioin_rtxwrclksel;
wire dprioin_rfreerun_tx;
wire dprioin_rtxurstpcs;
wire dprioin_reserved_0_TB1;
wire dprioin_rphfifoursttx;
wire dprioin_rphfifopldentx;
wire dprioin_rge_xaui_tx;
wire dprioin_rdwidth_tx;
wire dprioin_rtxfifo_lowlatency_en;
wire dprioin_rib_force_disp;
wire dprioin_rtxfifo_dis;
wire dprioin_rforce_echar;
wire dprioin_rforce_kchar;

// PCS Per Channel TX Control Register 2 for Channel 0
wire dprioin_rtxpcsbypass_en;
wire [1:0] dprioin_rcxpat_chnl_en;
wire [1:0] dprioin_rbist_sel;
wire dprioin_rbisten_tx;
wire [2:0] dprioin_rprbs_sel;
wire dprioin_rprbsen_tx;
wire dprioin_renbitrev_tx;
wire dprioin_renpolinv_tx;
wire dprioin_rensymswap_tx;
wire dprioin_rcascaded_8b10b_en_tx;
wire dprioin_r8b10b_enc_ibm_en;
wire dprioin_rendec_tx;

// PCS Per Channel TX Control Register 3 for Channel 0
wire dprioin_reserved_0_TB3;
wire [7:0] dprioin_rcid_len_tx;
wire dprioin_rcid_pattern_tx;
wire dprioin_rtxpcsclkpwdn;
wire dprioin_rtxswing_sel_ena;
wire [2:0] dprioin_rtx_elec_idle_delay;
wire dprioin_rtx_pipe_enable;

// PCS Per Channel TX Control Register 4 for Channel 0
wire [11:0] dprioin_reserved_0_TB4;
wire dprioin_rtxbitslip_en;
wire dprioin_rphfifo_regmode_tx;
wire dprioin_rpipeline_bypass_tx;
wire dprioin_rself_sw_en_tx;

// ---------------------------------------------------------------------------
// CRAM  
// ---------------------------------------------------------------------------
// Final CRAM to pass to RTL ------------------------------------------
// Existing
wire cram_is_lane0;
wire cram_rauto_speed_ena;
wire cram_rclkcmpinsertpad;             // rx only ========= pipe ===========    
wire cram_rendec_data_sel_tx;
wire cram_rfreq_sel;
wire cram_rhip_ena;
wire cram_rindv_tx;
wire cram_rmaster_tx;
wire cram_rmaster_up_tx;
wire cram_rphfifo_master_sel_tx;
wire cram_rpma_doublewidth_tx;
wire cram_rpmadwidth_tx;
wire cram_rrdwidth_rx;                  // rx only
wire cram_rrx_detect_bypass;            // rx only
wire cram_rrx_pipe_enable;              // rx only
wire cram_rtx_cmu_sel;          // added in 6.1
wire cram_scan_mode;

// PCS Per Channel TX Control Register 1 for Channel 0
wire cram_rforce_disp;
wire cram_rrev_loopbk;
wire cram_rtxrdclksel;
wire cram_rtxwrclksel;
wire cram_rfreerun_tx;
wire cram_rtxurstpcs;
wire cram_reserved_0_TB1;
wire cram_rphfifoursttx;
wire cram_rphfifopldentx;
wire cram_rge_xaui_tx;
wire cram_rdwidth_tx;
wire cram_rtxfifo_lowlatency_en;
wire cram_rib_force_disp;
wire cram_rtxfifo_dis;
wire cram_rforce_echar;
wire cram_rforce_kchar;

// PCS Per Channel TX Control Register 2 for Channel 0
wire cram_rtxpcsbypass_en;
wire [1:0] cram_rcxpat_chnl_en;
wire [1:0] cram_rbist_sel;
wire cram_rbisten_tx;
wire [2:0] cram_rprbs_sel;
wire cram_rprbsen_tx;
wire cram_renbitrev_tx;
wire cram_renpolinv_tx;
wire cram_rensymswap_tx;
wire cram_rcascaded_8b10b_en_tx;
wire cram_r8b10b_enc_ibm_en;
wire cram_rendec_tx;

// PCS Per Channel TX Control Register 3 for Channel 0
wire cram_reserved_0_TB3;
wire [7:0] cram_rcid_len_tx;
wire cram_rcid_pattern_tx;
wire cram_rtxpcsclkpwdn;
wire cram_rtxswing_sel_ena;
wire [2:0] cram_rtx_elec_idle_delay;
wire cram_rtx_pipe_enable;

// PCS Per Channel TX Control Register 4 for Channel 0
wire [11:0] cram_reserved_0_TB4;
wire cram_rtxbitslip_en;
wire cram_rphfifo_regmode_tx;
wire cram_rpipeline_bypass_tx;
wire cram_rself_sw_en_tx;

////////////////////////////////////////////////////////////////////////////////
// Internal Variables  -------------------------------------------------------//
////////////////////////////////////////////////////////////////////////////////

integer i;
integer j;
reg     rxdet_fixclk_reg;

////////////////////////////////////////////////////////////////////////////////
// Function 		   -------------------------------------------------------//
////////////////////////////////////////////////////////////////////////////////

function [2:0] compute_rprbs_sel;
input          pma_doublewidth;
input          pma_width;
input          test_mode;
reg [8*20:1]   test_mode;
reg [2:0]      res;

begin
    case ({pma_doublewidth, pma_width})
        2'b00 : 
                begin
                    if (test_mode == "prbs_8" || test_mode == "prbs8")
                        res = 3'b000;
                    else if (test_mode == "prbs7")
                        res = 3'b010;                     
                    else if (test_mode == "prbs23")
                        res = 3'b100;
                    else if (test_mode == "high frequency")
                        res = 3'b001;
                    else                        
                        res = 3'b000;     // PRBS_8
                end
        2'b01 :
                begin
                    if (test_mode == "prbs_10" || test_mode == "prbs10")
                        res = 3'b000;
                    else if (test_mode == "high frequency")
                        res = 3'b001;
                    else if (test_mode == "low frequency")
                        res = 3'b010;
                    else if (test_mode == "mixed frequency")
                        res = 3'b011;
                    else 
                        res = 3'b000;                     // PRBS_10
                end
        2'b10 : 
                begin
                    if (test_mode == "prbs_7" || test_mode == "prbs7")
                        res = 3'b000;
                    else if (test_mode == "PRBS_23" || test_mode == "prbs_23" || test_mode == "prbs23")
                        res = 3'b001;
                    else if (test_mode == "high frequency")
                        res = 3'b010;
                    else 
                        res = 3'b000;                     // PRBS_7
                end
        2'b11 :
                begin
                    if (test_mode == "prbs_7" || test_mode == "prbs7")
                        res = 3'b000;
                    else if (test_mode == "prbs_23" || test_mode == "prbs23")
                        res = 3'b001;                     
                    else if (test_mode == "high frequency")
                        res = 3'b010;
                    else if (test_mode == "low frequency")
                        res = 3'b011;
                    else if (test_mode == "mixed frequency")
                        res = 3'b100;
                    else 
                        res = 3'b000;     // default
                end

        default : begin
        			$display("Invalid pma_doublewidth and pma_width selection");
        			$display("Time: %0t  Instance: %m", $time);
        		  end
    endcase
    compute_rprbs_sel = res;
end
endfunction

function [8*`ARRIAII_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH:1] alpha_tolower;
input [8*`ARRIAII_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH:1] input_string;

reg [8*`ARRIAII_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH:1] return_string;
reg [8*`ARRIAII_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH:1] reg_string;
reg [8:1] tmp;
reg [8:1] conv_char;
integer byte_count;
begin
reg_string = input_string;
for (byte_count = `ARRIAII_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH; byte_count >= 1; byte_count = byte_count - 1)
begin
    tmp = reg_string[8*`ARRIAII_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH:(8*(`ARRIAII_HSSI_TX_PCS_ALPHA_TOLOWER_WORD_LENGTH-1)+1)];
    reg_string = reg_string << 8;
    if ((tmp >= 65) && (tmp <= 90)) // ASCII number of 'A' is 65, 'Z' is 90
    begin
	conv_char = tmp + 32; // 32 is the difference in the position of 'A' and 'a' in the ASCII char set
	return_string = {return_string, conv_char};
    end
    else
	return_string = {return_string, tmp};
end

alpha_tolower = return_string;
end
endfunction

////////////////////////////////////////////////////////////////////////////////
// Timing - INPUT BUFFERS  ---------------------------------------------------//
////////////////////////////////////////////////////////////////////////////////

wire [3:0]      ctrlenable_ipd;
wire [39:0]     datain_ipd;
wire [3:0]      dispval_ipd;
wire [3:0]      forcedisp_ipd;
wire [1:0]    powerdn_ipd;

wire coreclk_ipd;
wire detectrxloop_ipd;
wire enrevparallellpbk_ipd;
wire forcedispcompliance_ipd;
wire invpol_ipd;
wire phfifowrenable_ipd;
wire pipetxdeemph_ipd;
wire [2:0] pipetxmargin_ipd;
wire pipetxswing_ipd;
wire rateswitch_ipd;
wire refclk_ipd;
wire rxrst_int_wire;
wire phfiforeset_ipd;
wire phfiforddisable_ipd;

//ww47 new inputs
wire [4 : 0]   bitslipboundaryselect_in;  
wire           forceelecidle_ipd;      
wire  [9 : 0]  hipdatain_in;          
wire           hipdetectrxloop_in;    
wire           hipforceelecidle_in;   
wire  [1 : 0]  hippowerdn_in;         
wire           hiptxdeemph_in;        
wire  [2 : 0]  hiptxmargin_in;        
wire  [1 : 0]  iqpphfifoxnbytesel_in;    
wire  [1 : 0]  iqpphfifoxnrdclk_in;      
wire  [1 : 0]  iqpphfifoxnrdenable_in;   
wire  [1 : 0]  iqpphfifoxnwrenable_in;   
wire           phfifobyteserdisable_in;   
wire           phfifoptrsreset_in;        
wire  [2 : 0]  phfifoxnbytesel_in;     
wire  [2 : 0]  phfifoxnptrsreset_in;   
wire  [2 : 0]  phfifoxnrdclk_in;       
wire  [2 : 0]  phfifoxnrdenable_in;    
wire  [2 : 0]  phfifoxnwrenable_in;   
wire           prbscidenable_in;   

wire [2:0] elecidleinfersel_in;
wire [2:0] hipelecidleinfersel_in;

assign refclk_ipd               = refclk;
assign coreclk_ipd              = coreclk;
assign ctrlenable_ipd           = ctrlenable;
assign datain_ipd               = datain;
assign dispval_ipd              = dispval;
assign forcedisp_ipd            = forcedisp;

assign forcedispcompliance_ipd  = forcedispcompliance;
assign phfifowrenable_ipd       = phfifowrenable;
assign detectrxloop_ipd         = detectrxloop;
assign forceelecidle_ipd        = forceelecidle;
assign powerdn_ipd              = powerdn;
assign pipetxdeemph_ipd         = pipetxdeemph;
assign pipetxmargin_ipd         = pipetxmargin;
assign pipetxswing_ipd          = pipetxswing;

assign invpol_ipd               = invpol;
assign phfiforddisable_ipd      = phfiforddisable;
assign enrevparallellpbk_ipd    = enrevparallellpbk;
assign phfiforeset_ipd          = phfiforeset;
assign rateswitch_ipd           = rateswitch;

assign bitslipboundaryselect_in[0] = (bitslipboundaryselect[0] === 1'b1) ? 1'b1 : 1'b0;  
assign bitslipboundaryselect_in[1] = (bitslipboundaryselect[1] === 1'b1) ? 1'b1 : 1'b0;  
assign bitslipboundaryselect_in[2] = (bitslipboundaryselect[2] === 1'b1) ? 1'b1 : 1'b0;  
assign bitslipboundaryselect_in[3] = (bitslipboundaryselect[3] === 1'b1) ? 1'b1 : 1'b0;  
assign bitslipboundaryselect_in[4] = (bitslipboundaryselect[4] === 1'b1) ? 1'b1 : 1'b0;  

assign hipdatain_in             = hipdatain;          
assign hipdetectrxloop_in       = hipdetectrxloop;    
assign hipforceelecidle_in      = hipforceelecidle;   
assign hippowerdn_in            = hippowerdn;         
assign hiptxdeemph_in           = hiptxdeemph;        
assign hiptxmargin_in           = hiptxmargin;        
assign iqpphfifoxnbytesel_in    = iqpphfifoxnbytesel;    
assign iqpphfifoxnrdclk_in      = iqpphfifoxnrdclk;      
assign iqpphfifoxnrdenable_in   = iqpphfifoxnrdenable;   
assign iqpphfifoxnwrenable_in   = iqpphfifoxnwrenable;   
assign phfifobyteserdisable_in  = phfifobyteserdisable;   
assign phfifoptrsreset_in       = phfifoptrsreset;        
assign phfifoxnbytesel_in       = phfifoxnbytesel;     
assign phfifoxnptrsreset_in     = phfifoxnptrsreset;   
assign phfifoxnrdclk_in         = phfifoxnrdclk;       
assign phfifoxnrdenable_in      = phfifoxnrdenable;    
assign phfifoxnwrenable_in      = phfifoxnwrenable;   
assign prbscidenable_in         = prbscidenable;   

assign elecidleinfersel_in[0] = (elecidleinfersel[0] === 1'b1)? 1'b1 : 1'b0;
assign elecidleinfersel_in[1] = (elecidleinfersel[1] === 1'b1)? 1'b1 : 1'b0;
assign elecidleinfersel_in[2] = (elecidleinfersel[2] === 1'b1)? 1'b1 : 1'b0;

assign hipelecidleinfersel_in[0] = (hipelecidleinfersel[0] === 1'b1)? 1'b1 : 1'b0;
assign hipelecidleinfersel_in[1] = (hipelecidleinfersel[1] === 1'b1)? 1'b1 : 1'b0;
assign hipelecidleinfersel_in[2] = (hipelecidleinfersel[2] === 1'b1)? 1'b1 : 1'b0;

////////////////////////////////////////////////////////////////////////////////
// TIMING -- TCO/TSU/HOLD                                                     //
////////////////////////////////////////////////////////////////////////////////

specify

    $setuphold(posedge coreclk, ctrlenable,     0, 0);
    $setuphold(posedge coreclk, datain,         0, 0);
    $setuphold(posedge coreclk, detectrxloop,   0, 0);
    $setuphold(posedge coreclk, dispval,        0, 0);
    $setuphold(posedge coreclk, forcedisp,      0, 0);
    $setuphold(posedge coreclk, forcedispcompliance, 0, 0);
    $setuphold(posedge coreclk, phfifowrenable, 0, 0);
    $setuphold(posedge coreclk, forceelecidle,  0, 0);
    $setuphold(posedge coreclk, powerdn,        0, 0);
    $setuphold(posedge coreclk, pipetxdeemph,   0, 0);
    $setuphold(posedge coreclk, pipetxswing,    0, 0);
    $setuphold(posedge coreclk, pipetxmargin,   0, 0);

    (posedge coreclk => (phfifooverflow  +: td_out_full_tx))  = (0, 0);
    (posedge coreclk => (phfifounderflow +: td_out_empty_tx)) = (0, 0);

endspecify

////////////////////////////////////////////////////////////////////////////////
// dprio outputs
////////////////////////////////////////////////////////////////////////////////

wire [149:0]  dprioin_in;
assign dprioin_in = dprioin;

// inital CRAMs from parameters - CRAM_TABLE 1
initial begin
    init_r8b10b_enc_ibm_en     = (enc_8b_10b_compatibility_mode == "true") ? 1'b1 : 1'b0;
    init_rbist_sel             = (self_test_mode == "incremental") ? 2'b00 :        // to bist_gen
                                 (self_test_mode == "cjpat")        ? 2'b01 :
                                 (self_test_mode == "crpat")        ? 2'b10 : 2'b00;
    init_rbisten_tx            = ((enable_self_test_mode == "true") && 
                                  (self_test_mode == "incremental" || self_test_mode == "cjpat" || self_test_mode == "cjpat")) ? 1'b1 : 1'b0;  // bist_gen        
    init_rcascaded_8b10b_en_tx = (enc_8b_10b_mode == "cascaded") ? 1'b1 : 1'b0;
    init_rcxpat_chnl_en        = (channel_number == 1) ? 2'b01 :               // bist_gen
                                 (channel_number == 2) ? 2'b10 :
                                 (channel_number == 3) ? 2'b11 : 2'b00;
    init_rdwidth_tx            = (use_double_data_mode == "true") ? 1'b1 : 1'b0;
    init_renbitrev_tx          = (enable_bit_reversal == "true") ? 1'b1 : 1'b0;
    init_rendec_data_sel_tx    = (protocol_hint == "xaui") ? 1'b0 : 1'b1; // 0=ts_; 1=tc_ 
    init_rendec_tx             = (enc_8b_10b_mode != "none") ? 1'b1 : 1'b0;
    init_renpolinv_tx          = (allow_polarity_inversion == "true") ? 1'b1 : 1'b0;
    init_rensymswap_tx         = (enable_symbol_swap == "true") ? 1'b1 : 1'b0;
    init_rforce_disp           = (disparity_mode == "new") ? 1'b1 : 1'b0;
    init_rforce_echar          = (force_echar == "true") ? 1'b1 : 1'b0;
    init_rforce_kchar          = (force_kchar == "true") ? 1'b1 : 1'b0;
    init_rfreerun_tx           = (reset_clock_output_during_digital_reset == "false") ? 1'b1 : 1'b0;
    init_rge_xaui_tx           = (protocol_hint == "gige" || enable_idle_selection == "true") ? 1'b1 : 1'b0;
    init_rib_force_disp        = (disparity_mode == "legacy") ? 1'b1 : 1'b0;
    init_rindv_tx              = (channel_bonding == "x4" || channel_bonding == "x8" || protocol_hint == "xaui") ? 1'b0 : 1'b1;
    init_rphfifo_master_sel_tx = (channel_bonding == "x8") ? 1'b0 : 1'b1;
    init_rphfifopldentx        = 1'b1;        // Altera Internal Mode - Enable PLD controlled write and read ** enabled to match ASM
    init_rphfifoursttx         = 1'b1;        // Altera Internal Mode - 0 = normal operation:                ** enabled for POF
    init_rpma_doublewidth_tx   = (use_serializer_double_data_mode == "true") ? 1'b1 : 1'b0; // 1 = 16/20, 0 = 8/10
    init_rpmadwidth_tx         = ((enc_8b_10b_mode == "none") && ((channel_width == 8) || (channel_width == 16) || (channel_width == 32))) ? 1'b0 : 1'b1; // 0 = 8 bit, 1 = 10 bit
    init_rprbs_sel             = compute_rprbs_sel(init_rpma_doublewidth_tx,init_rpmadwidth_tx,self_test_mode);
    init_rprbsen_tx            = ((enable_self_test_mode == "true") && (self_test_mode != "incremental") &&
                                  (self_test_mode != "cjpat") && (self_test_mode != "crpat")) ?
                                   1'b1 : 1'b0;  // prbs_gen
    init_rrev_loopbk           = (enable_reverse_parallel_loopback == "true") ? 1'b1 : 1'b0;
    init_rtx_pipe_enable       = (protocol_hint == "pcie" || protocol_hint == "pcie2") ? 1'b1 : 1'b0;
    init_rtxfifo_dis           = (enable_phfifo_bypass == "true") ? 1'b1 : 1'b0;           // cannot bypass
    init_rtxfifo_lowlatency_en = (disable_ph_low_latency_mode == "false") ? 1'b1 : 1'b0; 
    init_rtxpcsbypass_en       = (datapath_low_latency_mode == "true") ? 1'b1 : 1'b0;
    init_rtxrdclksel           = (refclk_select == "cmu_clock_divider" || refclk_select == "cmu clock divider") ? 1'b1 : 1'b0;      // TxFifo Rd clock 1=refclk_pma, 0=local_refclk_pma
    init_rtxswing_sel_ena      = (pipe_voltage_swing_control == "true") ? 1'b1 : 1'b0;
    init_rtxwrclksel           = (wr_clk_mux_select == "int_clk" || wr_clk_mux_select == "int clk" || wr_clk_mux_select == "internal clock") ? 1'b1 : 1'b0;  // TxFifo Write clk. 1=int_clk; 0=pld_tx_clk
    init_rclkcmpinsertpad      = 1'b1;      // for rx only   ====== pipe section started ========    
    init_rrdwidth_rx           = 1'b1;      // for rx only extra r in pipe interface
    init_rrx_detect_bypass     = 1'b1;      // for rx only
    init_rrx_pipe_enable       = 1'b1;      // for rx only
    init_rtx_elec_idle_delay   = (elec_idle_delay == 0) ? 3'b011 : (elec_idle_delay - 3); // 3'b011 Engineering bits - delay numbers - on purpse seting 6 to compensate PMA model
    init_is_lane0              = (channel_number == 0) ? 1'b1 : 1'b0;
    init_scan_mode             = 1'b0;
    
    // NEW
    init_rauto_speed_ena       = (pipe_auto_speed_nego_enable == "true") ? 1'b1 : 1'b0;
    init_rfreq_sel             = (alpha_tolower(pipe_freq_scale_mode) == "data width") ? 1'b0 : 1'b1;     // default is Frequency
    init_rtxpcsclkpwdn         = 1'b0; 
    init_rcid_pattern_tx       = (prbs_cid_pattern == "true") ? 1'b1 : 1'b0;
    init_rcid_len_tx           = prbs_cid_pattern_length;
    init_rmaster_tx            = (mph_fifo_xn_mapping == "central"  || channel_bonding != "x8") ? 1'b1 : 1'b0;

// ----------------------------------------------------------------------------
// megafuncton gets rmaster_up opposite as input mux but still in simulation
// input as I connect the input (from master channel) into both in_up and
// in_down. The reason I care now is due to ww12 RTL: I use the cram to mux
// iqp <= (up, down)
// ----------------------------------------------------------------------------
    init_rmaster_up_tx         = (mph_fifo_xn_mapping == "down") ? 1'b1 : 1'b0;  //flip  
    init_rself_sw_en_tx        = (auto_spd_self_switch_enable == "true") ? 1'b1 : 1'b0;
    init_rpipeline_bypass_tx   = (iqp_bypass == "true") ? 1'b1 : 1'b0;
    init_rphfifo_regmode_tx    = (ph_fifo_reg_mode == "true") ? 1'b1 : 1'b0;    
    init_rtxbitslip_en         = (bitslip_enable == "true") ? 1'b1 : 1'b0;
    init_rhip_ena              = (hip_enable == "true") ? 1'b1 : 1'b0;
end

// Set DPRIO input CRAM from dprioin - CRAM_Table 2A -------------------------
// ---------------------------------------------------------------------------
// Set DPRIO CRAM input from dprioin  
// ---------------------------------------------------------------------------
// Table 2A needs to use def'ed INDEX for PCS
// Existing
assign dprioin_rpma_doublewidth_tx   = dprioin_in[`rpma_doublewidth_tx_TX_IDX];   
assign dprioin_rpmadwidth_tx         = dprioin_in[`rpmadwidth_tx_TX_IDX];        
assign dprioin_rendec_data_sel_tx    = dprioin_in[`rendec_data_sel_tx_TX_IDX];
assign dprioin_rindv_tx              = dprioin_in[`rindv_tx_TX_IDX];
assign dprioin_rmaster_tx            = dprioin_in[`rmaster_tx_TX_IDX];
assign dprioin_rmaster_up_tx         = dprioin_in[`rmaster_up_tx_TX_IDX];

assign dprioin_is_lane0              = init_is_lane0;
assign dprioin_rauto_speed_ena       = dprioin_in[`rauto_speed_ena_TX_IDX];
assign dprioin_rclkcmpinsertpad      = init_rclkcmpinsertpad;  // rx only ========= pipe ===========    
assign dprioin_rfreq_sel             = dprioin_in[`rfreq_sel_TX_IDX];
assign dprioin_rhip_ena              = dprioin_in[`rhip_ena_TX_IDX];
assign dprioin_rphfifo_master_sel_tx = init_rphfifo_master_sel_tx;    // obsolete cram
assign dprioin_rrdwidth_rx           = init_rrdwidth_rx;              // rx only
assign dprioin_rrx_detect_bypass     = init_rrx_detect_bypass;        // rx only
assign dprioin_rrx_pipe_enable       = init_rrx_pipe_enable;          // rx only
assign dprioin_rtx_cmu_sel           = dprioin_in[`rtx_cmu_sel_TX_IDX];
assign dprioin_scan_mode             = init_scan_mode;

// PCS Per Channel TX Control Register 1 for Channel 0
assign dprioin_rforce_disp    = dprioin[`rforce_disp_TXPCS_IDX_0];
assign dprioin_rrev_loopbk    = dprioin[`rrev_loopbk_TXPCS_IDX_0];
assign dprioin_rtxrdclksel    = dprioin[`rtxrdclksel_TXPCS_IDX_0];
assign dprioin_rtxwrclksel    = dprioin[`rtxwrclksel_TXPCS_IDX_0];
assign dprioin_rfreerun_tx    = dprioin[`rfreerun_tx_TXPCS_IDX_0];
assign dprioin_rtxurstpcs    = dprioin[`rtxurstpcs_TXPCS_IDX_0];
assign dprioin_reserved_0_TB1    = dprioin[`reserved_0_TB1_TXPCS_IDX_0];
assign dprioin_rphfifoursttx    = dprioin[`rphfifoursttx_TXPCS_IDX_0];
assign dprioin_rphfifopldentx    = dprioin[`rphfifopldentx_TXPCS_IDX_0];
assign dprioin_rge_xaui_tx    = dprioin[`rge_xaui_tx_TXPCS_IDX_0];
assign dprioin_rdwidth_tx    = dprioin[`rdwidth_tx_TXPCS_IDX_0];
assign dprioin_rtxfifo_lowlatency_en    = dprioin[`rtxfifo_lowlatency_en_TXPCS_IDX_0];
assign dprioin_rib_force_disp    = dprioin[`rib_force_disp_TXPCS_IDX_0];
assign dprioin_rtxfifo_dis    = dprioin[`rtxfifo_dis_TXPCS_IDX_0];
assign dprioin_rforce_echar    = dprioin[`rforce_echar_TXPCS_IDX_0];
assign dprioin_rforce_kchar    = dprioin[`rforce_kchar_TXPCS_IDX_0];

// PCS Per Channel TX Control Register 2 for Channel 0
assign dprioin_rtxpcsbypass_en    = dprioin[`rtxpcsbypass_en_TXPCS_IDX_0];
assign dprioin_rcxpat_chnl_en    = dprioin[`rcxpat_chnl_en_TXPCS_IDX_1 : `rcxpat_chnl_en_TXPCS_IDX_0];
assign dprioin_rbist_sel    = dprioin[`rbist_sel_TXPCS_IDX_1 : `rbist_sel_TXPCS_IDX_0];
assign dprioin_rbisten_tx    = dprioin[`rbisten_tx_TXPCS_IDX_0];
assign dprioin_rprbs_sel    = dprioin[`rprbs_sel_TXPCS_IDX_2 : `rprbs_sel_TXPCS_IDX_0];
assign dprioin_rprbsen_tx    = dprioin[`rprbsen_tx_TXPCS_IDX_0];
assign dprioin_renbitrev_tx    = dprioin[`renbitrev_tx_TXPCS_IDX_0];
assign dprioin_renpolinv_tx    = dprioin[`renpolinv_tx_TXPCS_IDX_0];
assign dprioin_rensymswap_tx    = dprioin[`rensymswap_tx_TXPCS_IDX_0];
assign dprioin_rcascaded_8b10b_en_tx    = dprioin[`rcascaded_8b10b_en_tx_TXPCS_IDX_0];
assign dprioin_r8b10b_enc_ibm_en    = dprioin[`r8b10b_enc_ibm_en_TXPCS_IDX_0];
assign dprioin_rendec_tx    = dprioin[`rendec_tx_TXPCS_IDX_0];

// PCS Per Channel TX Control Register 3 for Channel 0
assign dprioin_reserved_0_TB3    = dprioin[`reserved_0_TB3_TXPCS_IDX_0];
assign dprioin_rcid_len_tx    = dprioin[`rcid_len_tx_TXPCS_IDX_7 : `rcid_len_tx_TXPCS_IDX_0];
assign dprioin_rcid_pattern_tx    = dprioin[`rcid_pattern_tx_TXPCS_IDX_0];
assign dprioin_rtxpcsclkpwdn    = dprioin[`rtxpcsclkpwdn_TXPCS_IDX_0];
assign dprioin_rtxswing_sel_ena    = dprioin[`rtxswing_sel_ena_TXPCS_IDX_0];
assign dprioin_rtx_elec_idle_delay    = dprioin[`rtx_elec_idle_delay_TXPCS_IDX_2 : `rtx_elec_idle_delay_TXPCS_IDX_0];
assign dprioin_rtx_pipe_enable    = dprioin[`rtx_pipe_enable_TXPCS_IDX_0];

// PCS Per Channel TX Control Register 4 for Channel 0
assign dprioin_reserved_0_TB4    = dprioin[`reserved_0_TB4_TXPCS_IDX_11 : `reserved_0_TB4_TXPCS_IDX_0];
assign dprioin_rtxbitslip_en    = dprioin[`rtxbitslip_en_TXPCS_IDX_0];
assign dprioin_rphfifo_regmode_tx    = dprioin[`rphfifo_regmode_tx_TXPCS_IDX_0];
assign dprioin_rpipeline_bypass_tx    = dprioin[`rpipeline_bypass_tx_TXPCS_IDX_0];
assign dprioin_rself_sw_en_tx    = dprioin[`rself_sw_en_tx_TXPCS_IDX_0];

// ---------------------------------------------------------------------------
// Set DPRIO output from initial CRAM
// ---------------------------------------------------------------------------
// Set DPRIO reg with initial parameters - CRAM_Table 2B ---------------------------
// Existing
assign dprioout[`rpma_doublewidth_tx_TX_IDX]   = init_rpma_doublewidth_tx;   
assign dprioout[`rpmadwidth_tx_TX_IDX]         = init_rpmadwidth_tx;         
assign dprioout[`rendec_data_sel_tx_TX_IDX]    = init_rendec_data_sel_tx;
assign dprioout[`rindv_tx_TX_IDX]              = init_rindv_tx;
assign dprioout[`rmaster_tx_TX_IDX]            = init_rmaster_tx;
assign dprioout[`rmaster_up_tx_TX_IDX]         = init_rmaster_up_tx;

assign dprioout[`rauto_speed_ena_TX_IDX]       = init_rauto_speed_ena;           
assign dprioout[`rfreq_sel_TX_IDX]             = init_rfreq_sel;           
assign dprioout[`rhip_ena_TX_IDX]              = init_rhip_ena;
assign dprioout[`rtx_cmu_sel_TX_IDX]           = init_rtx_cmu_sel;           

// PCS Per Channel TX Control Register 1 for Channel 0
assign dprioout[`rforce_disp_TXPCS_IDX_0] = init_rforce_disp;
assign dprioout[`rrev_loopbk_TXPCS_IDX_0] = init_rrev_loopbk;
assign dprioout[`rtxrdclksel_TXPCS_IDX_0] = init_rtxrdclksel;
assign dprioout[`rtxwrclksel_TXPCS_IDX_0] = init_rtxwrclksel;
assign dprioout[`rfreerun_tx_TXPCS_IDX_0] = init_rfreerun_tx;
assign dprioout[`rtxurstpcs_TXPCS_IDX_0] = init_rtxurstpcs;
assign dprioout[`reserved_0_TB1_TXPCS_IDX_0] = init_reserved_0_TB1;
assign dprioout[`rphfifoursttx_TXPCS_IDX_0] = init_rphfifoursttx;
assign dprioout[`rphfifopldentx_TXPCS_IDX_0] = init_rphfifopldentx;
assign dprioout[`rge_xaui_tx_TXPCS_IDX_0] = init_rge_xaui_tx;
assign dprioout[`rdwidth_tx_TXPCS_IDX_0] = init_rdwidth_tx;
assign dprioout[`rtxfifo_lowlatency_en_TXPCS_IDX_0] = init_rtxfifo_lowlatency_en;
assign dprioout[`rib_force_disp_TXPCS_IDX_0] = init_rib_force_disp;
assign dprioout[`rtxfifo_dis_TXPCS_IDX_0] = init_rtxfifo_dis;
assign dprioout[`rforce_echar_TXPCS_IDX_0] = init_rforce_echar;
assign dprioout[`rforce_kchar_TXPCS_IDX_0] = init_rforce_kchar;

// PCS Per Channel TX Control Register 2 for Channel 0
assign dprioout[`rtxpcsbypass_en_TXPCS_IDX_0] = init_rtxpcsbypass_en;
assign dprioout[`rcxpat_chnl_en_TXPCS_IDX_1 : `rcxpat_chnl_en_TXPCS_IDX_0] = init_rcxpat_chnl_en;
assign dprioout[`rbist_sel_TXPCS_IDX_1 : `rbist_sel_TXPCS_IDX_0] = init_rbist_sel;
assign dprioout[`rbisten_tx_TXPCS_IDX_0] = init_rbisten_tx;
assign dprioout[`rprbs_sel_TXPCS_IDX_2 : `rprbs_sel_TXPCS_IDX_0] = init_rprbs_sel;
assign dprioout[`rprbsen_tx_TXPCS_IDX_0] = init_rprbsen_tx;
assign dprioout[`renbitrev_tx_TXPCS_IDX_0] = init_renbitrev_tx;
assign dprioout[`renpolinv_tx_TXPCS_IDX_0] = init_renpolinv_tx;
assign dprioout[`rensymswap_tx_TXPCS_IDX_0] = init_rensymswap_tx;
assign dprioout[`rcascaded_8b10b_en_tx_TXPCS_IDX_0] = init_rcascaded_8b10b_en_tx;
assign dprioout[`r8b10b_enc_ibm_en_TXPCS_IDX_0] = init_r8b10b_enc_ibm_en;
assign dprioout[`rendec_tx_TXPCS_IDX_0] = init_rendec_tx;

// PCS Per Channel TX Control Register 3 for Channel 0
assign dprioout[`reserved_0_TB3_TXPCS_IDX_0] = init_reserved_0_TB3;
assign dprioout[`rcid_len_tx_TXPCS_IDX_7 : `rcid_len_tx_TXPCS_IDX_0] = init_rcid_len_tx;
assign dprioout[`rcid_pattern_tx_TXPCS_IDX_0] = init_rcid_pattern_tx;
assign dprioout[`rtxpcsclkpwdn_TXPCS_IDX_0] = init_rtxpcsclkpwdn;
assign dprioout[`rtxswing_sel_ena_TXPCS_IDX_0] = init_rtxswing_sel_ena;
assign dprioout[`rtx_elec_idle_delay_TXPCS_IDX_2 : `rtx_elec_idle_delay_TXPCS_IDX_0] = init_rtx_elec_idle_delay;
assign dprioout[`rtx_pipe_enable_TXPCS_IDX_0] = init_rtx_pipe_enable;

// PCS Per Channel TX Control Register 4 for Channel 0
assign dprioout[`reserved_0_TB4_TXPCS_IDX_11 : `reserved_0_TB4_TXPCS_IDX_0] = init_reserved_0_TB4;
assign dprioout[`rtxbitslip_en_TXPCS_IDX_0] = init_rtxbitslip_en;
assign dprioout[`rphfifo_regmode_tx_TXPCS_IDX_0] = init_rphfifo_regmode_tx;
assign dprioout[`rpipeline_bypass_tx_TXPCS_IDX_0] = init_rpipeline_bypass_tx;
assign dprioout[`rself_sw_en_tx_TXPCS_IDX_0] = init_rself_sw_en_tx;

// ---------------------------------------------------------------------------
// Set DPRIO CRAM
// ---------------------------------------------------------------------------
// select CRAMs between DPIRO vs. parameters ----------------------------------------------------------------
// Set DPRIO CRAM
wire dpriodisable_in;
assign dpriodisable_in  = (dpriodisable === 1'b0) ? 1'b0 : 1'b1;

// Existing
assign cram_rpma_doublewidth_tx   = (dpriodisable_in == 1'b1) ? init_rpma_doublewidth_tx  : dprioin_rpma_doublewidth_tx;
assign cram_rpmadwidth_tx         = (dpriodisable_in == 1'b1) ? init_rpmadwidth_tx        : dprioin_rpmadwidth_tx;      
assign cram_rendec_data_sel_tx    = (dpriodisable_in == 1'b1) ? init_rendec_data_sel_tx   : dprioin_rendec_data_sel_tx;
assign cram_rindv_tx              = (dpriodisable_in == 1'b1) ? init_rindv_tx             : dprioin_rindv_tx;
assign cram_rmaster_tx            = (dpriodisable_in == 1'b1) ?  init_rmaster_tx          : dprioin_rmaster_tx;
assign cram_rmaster_up_tx         = (dpriodisable_in == 1'b1) ?  init_rmaster_up_tx       : dprioin_rmaster_up_tx;

assign cram_is_lane0              = (dpriodisable_in == 1'b1) ? init_is_lane0 : dprioin_is_lane0;
assign cram_rauto_speed_ena       = (dpriodisable_in == 1'b1) ? init_rauto_speed_ena : dprioin_rauto_speed_ena;
assign cram_rclkcmpinsertpad      = (dpriodisable_in == 1'b1) ? init_rclkcmpinsertpad : dprioin_rclkcmpinsertpad;           // rx only     
assign cram_rfreq_sel             = (dpriodisable_in == 1'b1) ? init_rfreq_sel : dprioin_rfreq_sel;
assign cram_rhip_ena              = (dpriodisable_in == 1'b1) ?  init_rhip_ena            :  dprioin_rhip_ena;
assign cram_rphfifo_master_sel_tx = (dpriodisable_in == 1'b1) ? init_rphfifo_master_sel_tx : dprioin_rphfifo_master_sel_tx;
assign cram_rrdwidth_rx           = (dpriodisable_in == 1'b1) ? init_rrdwidth_rx : dprioin_rrdwidth_rx;                     // rx only
assign cram_rrx_detect_bypass     = (dpriodisable_in == 1'b1) ? init_rrx_detect_bypass : dprioin_rrx_detect_bypass;         // rx only
assign cram_rrx_pipe_enable       = (dpriodisable_in == 1'b1) ? init_rrx_pipe_enable : dprioin_rrx_pipe_enable;             // rx only
assign cram_rtx_cmu_sel           = (dpriodisable_in == 1'b1) ? init_rtx_cmu_sel : dprioin_rtx_cmu_sel;
assign cram_scan_mode             = (dpriodisable_in == 1'b1) ? init_scan_mode : dprioin_scan_mode;

// PCS Per Channel TX Control Register 1 for Channel 0
assign cram_rforce_disp = (dpriodisable_in == 1'b1) ? init_rforce_disp : dprioin_rforce_disp;
assign cram_rrev_loopbk = (dpriodisable_in == 1'b1) ? init_rrev_loopbk : dprioin_rrev_loopbk;
assign cram_rtxrdclksel = (dpriodisable_in == 1'b1) ? init_rtxrdclksel : dprioin_rtxrdclksel;
assign cram_rtxwrclksel = (dpriodisable_in == 1'b1) ? init_rtxwrclksel : dprioin_rtxwrclksel;
assign cram_rfreerun_tx = (dpriodisable_in == 1'b1) ? init_rfreerun_tx : dprioin_rfreerun_tx;
assign cram_rtxurstpcs = (dpriodisable_in == 1'b1) ? init_rtxurstpcs : dprioin_rtxurstpcs;
assign cram_reserved_0_TB1 = (dpriodisable_in == 1'b1) ? init_reserved_0_TB1 : dprioin_reserved_0_TB1;
assign cram_rphfifoursttx = (dpriodisable_in == 1'b1) ? init_rphfifoursttx : dprioin_rphfifoursttx;
assign cram_rphfifopldentx = (dpriodisable_in == 1'b1) ? init_rphfifopldentx : dprioin_rphfifopldentx;
assign cram_rge_xaui_tx = (dpriodisable_in == 1'b1) ? init_rge_xaui_tx : dprioin_rge_xaui_tx;
assign cram_rdwidth_tx = (dpriodisable_in == 1'b1) ? init_rdwidth_tx : dprioin_rdwidth_tx;
assign cram_rtxfifo_lowlatency_en = (dpriodisable_in == 1'b1) ? init_rtxfifo_lowlatency_en : dprioin_rtxfifo_lowlatency_en;
assign cram_rib_force_disp = (dpriodisable_in == 1'b1) ? init_rib_force_disp : dprioin_rib_force_disp;
assign cram_rtxfifo_dis = (dpriodisable_in == 1'b1) ? init_rtxfifo_dis : dprioin_rtxfifo_dis;
assign cram_rforce_echar = (dpriodisable_in == 1'b1) ? init_rforce_echar : dprioin_rforce_echar;
assign cram_rforce_kchar = (dpriodisable_in == 1'b1) ? init_rforce_kchar : dprioin_rforce_kchar;

// PCS Per Channel TX Control Register 2 for Channel 0
assign cram_rtxpcsbypass_en = (dpriodisable_in == 1'b1) ? init_rtxpcsbypass_en : dprioin_rtxpcsbypass_en;
assign cram_rcxpat_chnl_en = (dpriodisable_in == 1'b1) ? init_rcxpat_chnl_en : dprioin_rcxpat_chnl_en;
assign cram_rbist_sel = (dpriodisable_in == 1'b1) ? init_rbist_sel : dprioin_rbist_sel;
assign cram_rbisten_tx = (dpriodisable_in == 1'b1) ? init_rbisten_tx : dprioin_rbisten_tx;
assign cram_rprbs_sel = (dpriodisable_in == 1'b1) ? init_rprbs_sel : dprioin_rprbs_sel;
assign cram_rprbsen_tx = (dpriodisable_in == 1'b1) ? init_rprbsen_tx : dprioin_rprbsen_tx;
assign cram_renbitrev_tx = (dpriodisable_in == 1'b1) ? init_renbitrev_tx : dprioin_renbitrev_tx;
assign cram_renpolinv_tx = (dpriodisable_in == 1'b1) ? init_renpolinv_tx : dprioin_renpolinv_tx;
assign cram_rensymswap_tx = (dpriodisable_in == 1'b1) ? init_rensymswap_tx : dprioin_rensymswap_tx;
assign cram_rcascaded_8b10b_en_tx = (dpriodisable_in == 1'b1) ? init_rcascaded_8b10b_en_tx : dprioin_rcascaded_8b10b_en_tx;
assign cram_r8b10b_enc_ibm_en = (dpriodisable_in == 1'b1) ? init_r8b10b_enc_ibm_en : dprioin_r8b10b_enc_ibm_en;
assign cram_rendec_tx = (dpriodisable_in == 1'b1) ? init_rendec_tx : dprioin_rendec_tx;

// PCS Per Channel TX Control Register 3 for Channel 0
assign cram_reserved_0_TB3 = (dpriodisable_in == 1'b1) ? init_reserved_0_TB3 : dprioin_reserved_0_TB3;
assign cram_rcid_len_tx = (dpriodisable_in == 1'b1) ? init_rcid_len_tx : dprioin_rcid_len_tx;
assign cram_rcid_pattern_tx = (dpriodisable_in == 1'b1) ? init_rcid_pattern_tx : dprioin_rcid_pattern_tx;
assign cram_rtxpcsclkpwdn = (dpriodisable_in == 1'b1) ? init_rtxpcsclkpwdn : dprioin_rtxpcsclkpwdn;
assign cram_rtxswing_sel_ena = (dpriodisable_in == 1'b1) ? init_rtxswing_sel_ena : dprioin_rtxswing_sel_ena;
assign cram_rtx_elec_idle_delay = (dpriodisable_in == 1'b1) ? init_rtx_elec_idle_delay : dprioin_rtx_elec_idle_delay;
assign cram_rtx_pipe_enable = (dpriodisable_in == 1'b1) ? init_rtx_pipe_enable : dprioin_rtx_pipe_enable;

// PCS Per Channel TX Control Register 4 for Channel 0
assign cram_reserved_0_TB4 = (dpriodisable_in == 1'b1) ? init_reserved_0_TB4 : dprioin_reserved_0_TB4;
assign cram_rtxbitslip_en = (dpriodisable_in == 1'b1) ? init_rtxbitslip_en : dprioin_rtxbitslip_en;
assign cram_rphfifo_regmode_tx = (dpriodisable_in == 1'b1) ? init_rphfifo_regmode_tx : dprioin_rphfifo_regmode_tx;
assign cram_rpipeline_bypass_tx = (dpriodisable_in == 1'b1) ? init_rpipeline_bypass_tx : dprioin_rpipeline_bypass_tx;
assign cram_rself_sw_en_tx = (dpriodisable_in == 1'b1) ? init_rself_sw_en_tx : dprioin_rself_sw_en_tx;

////////////////////////////////////////////////////////////////////////////////
// Connect Atom level input to appropriate RTL  - PORT_IN_Table ------------- //
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////////////////////////
// datain TXD mapping - datain[32/40], ctrlenable[4], forcedispacompliance, forcedisp[4], dispval[4]
////////////////////////////////////////////////////////////////////////////////////////////////////

assign tmp_ctrlenable[0] = (ctrlenable_ipd[0] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_ctrlenable[1] = (ctrlenable_ipd[1] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_ctrlenable[2] = (ctrlenable_ipd[2] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_ctrlenable[3] = (ctrlenable_ipd[3] === 1'b1) ? 1'b1 : 1'b0;

assign tmp_dispval[0] = (dispval_ipd[0] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_dispval[1] = (dispval_ipd[1] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_dispval[2] = (dispval_ipd[2] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_dispval[3] = (dispval_ipd[3] === 1'b1) ? 1'b1 : 1'b0;

assign tmp_forcedisp[0] = (forcedisp_ipd[0] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_forcedisp[1] = (forcedisp_ipd[1] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_forcedisp[2] = (forcedisp_ipd[2] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_forcedisp[3] = (forcedisp_ipd[3] === 1'b1) ? 1'b1 : 1'b0;

assign tmp_datain[0] = (datain_ipd[0] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[1] = (datain_ipd[1] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[2] = (datain_ipd[2] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[3] = (datain_ipd[3] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[4] = (datain_ipd[4] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[5] = (datain_ipd[5] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[6] = (datain_ipd[6] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[7] = (datain_ipd[7] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[8] = (datain_ipd[8] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[9] = (datain_ipd[9] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[10] = (datain_ipd[10] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[11] = (datain_ipd[11] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[12] = (datain_ipd[12] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[13] = (datain_ipd[13] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[14] = (datain_ipd[14] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[15] = (datain_ipd[15] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[16] = (datain_ipd[16] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[17] = (datain_ipd[17] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[18] = (datain_ipd[18] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[19] = (datain_ipd[19] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[20] = (datain_ipd[20] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[21] = (datain_ipd[21] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[22] = (datain_ipd[22] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[23] = (datain_ipd[23] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[24] = (datain_ipd[24] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[25] = (datain_ipd[25] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[26] = (datain_ipd[26] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[27] = (datain_ipd[27] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[28] = (datain_ipd[28] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[29] = (datain_ipd[29] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[30] = (datain_ipd[30] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[31] = (datain_ipd[31] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[32] = (datain_ipd[32] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[33] = (datain_ipd[33] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[34] = (datain_ipd[34] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[35] = (datain_ipd[35] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[36] = (datain_ipd[36] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[37] = (datain_ipd[37] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[38] = (datain_ipd[38] === 1'b1) ? 1'b1 : 1'b0;
assign tmp_datain[39] = (datain_ipd[39] === 1'b1) ? 1'b1 : 1'b0;

assign pi_in_txd_ch_tmp[7:0] = tmp_datain[7:0];
assign pi_in_txd_ch_tmp[8] = (cram_rendec_tx == 1'b1) ? tmp_ctrlenable[0] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[8] : 1'bx;
assign pi_in_txd_ch_tmp[9] = (cram_rendec_tx == 1'b1) ? tmp_forcedisp[0] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[9] : 1'bx;
assign pi_in_txd_ch_tmp[10] = (cram_rendec_tx == 1'b1) ? tmp_dispval[0] : 1'bx;

assign pi_in_txd_ch_tmp[18:11] = (cram_rendec_tx == 1'b1 || cram_rpmadwidth_tx == 1'b0) ? tmp_datain[15:8] : tmp_datain[17:10];
assign pi_in_txd_ch_tmp[19] = (cram_rendec_tx == 1'b1) ? tmp_ctrlenable[1] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[18] : 1'bx;
assign pi_in_txd_ch_tmp[20] = (cram_rendec_tx == 1'b1) ? tmp_forcedisp[1] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[19] : 1'bx;
assign pi_in_txd_ch_tmp[21] = (cram_rendec_tx == 1'b1) ? tmp_dispval[1] : 1'bx;

assign pi_in_txd_ch_tmp[29:22] = (cram_rendec_tx == 1'b1 || cram_rpmadwidth_tx == 1'b0) ? tmp_datain[23:16] : tmp_datain[27:20];
assign pi_in_txd_ch_tmp[30] = (cram_rendec_tx == 1'b1) ? tmp_ctrlenable[2] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[28] : 1'bx;
assign pi_in_txd_ch_tmp[31] = (cram_rendec_tx == 1'b1) ? tmp_forcedisp[2] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[29] : 1'bx;
assign pi_in_txd_ch_tmp[32] = (cram_rendec_tx == 1'b1) ? tmp_dispval[2] : 1'bx;

assign pi_in_txd_ch_tmp[40:33] = (cram_rendec_tx == 1'b1 || cram_rpmadwidth_tx == 1'b0) ? tmp_datain[31:24] : tmp_datain[37:30];
assign pi_in_txd_ch_tmp[41] = (cram_rendec_tx == 1'b1) ? tmp_ctrlenable[3] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[38] : 1'bx;
assign pi_in_txd_ch_tmp[42] = (cram_rendec_tx == 1'b1) ? tmp_forcedisp[3] : 
                          cram_rpmadwidth_tx == 1'b1 ? tmp_datain[39] : 1'bx;
assign pi_in_txd_ch_tmp[43] = (cram_rendec_tx == 1'b1) ? tmp_dispval[3] : 1'bx;

//interleaving
assign pi_in_txd_ch[10:0]  = pi_in_txd_ch_tmp[10:0];
assign pi_in_txd_ch[32:22] = (cram_rdwidth_tx == 1'b1 && cram_rpma_doublewidth_tx == 1'b0) ? pi_in_txd_ch_tmp[21:11] : pi_in_txd_ch_tmp[32:22];  
assign pi_in_txd_ch[21:11] = (cram_rdwidth_tx == 1'b1 && cram_rpma_doublewidth_tx == 1'b0) ? pi_in_txd_ch_tmp[32:22] : pi_in_txd_ch_tmp[21:11];  
assign pi_in_txd_ch[43:33]  = pi_in_txd_ch_tmp[43:33];

assign pi_in_txd_ch_dprio = ((dprio_config_mode & DPRIO_CHANNEL_INTERFACE_BIT) != 0) ? datainfull : pi_in_txd_ch;

////////////////////////////////////////////////////////////////////////////////
// Connect Atom level output to appropriate RTL  - PORT_OUT_Table ----------- //
////////////////////////////////////////////////////////////////////////////////

assign clkout            = td_out_tx_clk_out;
assign dataout           = td_out_pudr;
assign parallelfdbkout   = td_out_txlp20b;
assign phfifooverflow    = td_out_full_tx;
assign phfifounderflow   = td_out_empty_tx;

assign pipepowerdownout  = td_out_powerdown_int;
assign pipepowerstateout = pi_out_powerstate[3:0];
assign rdenablesync      = td_out_rd_enable_sync;
assign txdetectrx        = pi_out_txdetectrx;
assign xgmctrlenable     = td_out_tx_ctl_tc;
assign xgmdataout        = td_out_tx_data_tc;

// ww47 output ----------------------------------------------------------------
assign coreclkout           = coreclk_ipd;
assign hiptxclkout          = hs_out_hip_tx_clk;
assign iqpphfifobyteselout  = td_out_fifo_select_out_pipe;
assign iqpphfifordclkout    = td_out_tx_div2_sync_out_pipe;
assign iqpphfifordenableout = td_out_rd_enable_out_pipe;
assign iqpphfifowrenableout = td_out_wr_enable_out_pipe;
assign phfiforddisableout   = phfiforddisable_ipd;
assign phfiforesetout       = phfiforeset_ipd;
assign phfifowrenableout    = phfifowrenable_ipd;

// ww12 output ----------------------------------------------------------------
assign grayelecidleinferselout = td_out_gray_eidleinfersel;

assign pipeenrevparallellpbkout = pi_out_rev_loopbk;  // to td and rd

// q90 ww47 fix ---------------------------------------------------------------
assign forceelecidleout     = pi_out_tx_elec_idle;

////////////////////////////////////////////////////////////////////////////////
// tx sub-block instantiation: pcs_reset -------------------------------------//
////////////////////////////////////////////////////////////////////////////////

assign pr_in_hard_reset  = (quadreset === 1'b1) ? 1'b1 : 1'b0;      // from top
assign pr_in_clk_2_b     = 1'b0;                           // for rx side 
assign pr_in_refclk_b_in = td_out_refclk_b;
assign pr_in_scan_mode   = 1'b0;
assign pr_in_rxpcs_rst   = 1'b0;                           // for rx side
assign pr_in_txpcs_rst   = (digitalreset === 1'b1) ? 1'b1 : 1'b0;  // from top

arriaii_hssi_pcs_reset  tx_pcs_reset_1 (
              .hard_reset  (pr_in_hard_reset), 
              .clk_2_b     (pr_in_clk_2_b), 
              .refclk_b_in (pr_in_refclk_b_in),
              .scan_mode   (pr_in_scan_mode),
              .rxpcs_rst   (pr_in_rxpcs_rst), 
              .txpcs_rst   (pr_in_txpcs_rst),
              .rxrst_int   (rxrst_int_wire), 
              .txrst_int   (pr_out_txrst_int)
);

////////////////////////////////////////////////////////////////////////////////
// tx sub-block instantiation: chnl_hip_support ------------------------------//
////////////////////////////////////////////////////////////////////////////////

assign hs_in_eidleinfersel_ch       = elecidleinfersel_in;    
assign hs_in_hip_eidleinfersel_ch   = hipelecidleinfersel_in;
assign hs_in_hip_powerdown_ch       = hippowerdn_in;
assign hs_in_hip_rate               = 1'bx;
assign hs_in_hip_rxpolarity         = 1'bx;
assign hs_in_hip_txd_ch             = hipdatain_in;
assign hs_in_hip_txdeemph           = hiptxdeemph_in;
assign hs_in_hip_txdetectrxloopback = (hipdetectrxloop_in === 1'b1) ? 1'b1 : 1'b0;
assign hs_in_hip_txelecidle         = hipforceelecidle_in;
assign hs_in_hip_txmargin_ch        = hiptxmargin_in;
assign hs_in_pcs_phystatus          = 1'bx;
assign hs_in_pcs_rxd_ch             = 9'bxxxxxxxxx;
assign hs_in_pcs_rxelecidle         = 1'bx;
assign hs_in_pcs_rxstatus_ch        = 1'bx;
assign hs_in_pcs_rxvalid            = 1'bx;
assign hs_in_powerdown_ch           = powerdn_ipd;
assign hs_in_rate                   = 1'bx;
assign hs_in_rhip_ena               = cram_rhip_ena;
assign hs_in_rxpolarity             = 1'bx;
assign hs_in_txd_ch                 = pi_in_txd_ch_dprio[10:0];
assign hs_in_txdeemph               = pipetxdeemph_ipd;
assign hs_in_txdetectrxloopback     = (detectrxloop_ipd === 1'b1) ? 1'b1 : 1'b0;
assign hs_in_txmargin_ch            = pipetxmargin_ipd;
assign hs_in_txpma_local_clk        = localrefclk;

arriaii_hssi_digi_chnl_hip_spt mtx_hs(

    .eidleinfersel_ch (  hs_in_eidleinfersel_ch),
    .hip_eidleinfersel_ch      (hs_in_hip_eidleinfersel_ch    ),
    .hip_powerdown_ch          (hs_in_hip_powerdown_ch        ),
    .hip_rate                  (hs_in_hip_rate                ),
    .hip_rxpolarity            (hs_in_hip_rxpolarity          ),
    .hip_txd_ch                (hs_in_hip_txd_ch              ),
    .hip_txdeemph              (hs_in_hip_txdeemph            ),
    .hip_txdetectrxloopback    (hs_in_hip_txdetectrxloopback  ),
    .hip_txelecidle            (hs_in_hip_txelecidle          ),
    .hip_txmargin_ch           (hs_in_hip_txmargin_ch         ),
    .pcs_phystatus             (hs_in_pcs_phystatus           ),
    .pcs_rxd_ch                (hs_in_pcs_rxd_ch              ),
    .pcs_rxelecidle            (hs_in_pcs_rxelecidle          ),
    .pcs_rxstatus_ch           (hs_in_pcs_rxstatus_ch         ),
    .pcs_rxvalid               (hs_in_pcs_rxvalid             ),
    .powerdown_ch              (hs_in_powerdown_ch            ),
    .rate                      (hs_in_rate                    ),
    .rhip_ena                  (hs_in_rhip_ena                ),
    .rxpolarity                (hs_in_rxpolarity              ),
    .txd_ch                    (hs_in_txd_ch                  ),
    .txdeemph                  (hs_in_txdeemph                ),
    .txdetectrxloopback        (hs_in_txdetectrxloopback      ),
    .txmargin_ch               (hs_in_txmargin_ch             ),
    .txpma_local_clk           (hs_in_txpma_local_clk         ),

    .hip_phystatus             (hs_out_hip_phystatus          ),
    .hip_rxd_ch                (hs_out_hip_rxd_ch             ),
    .hip_rxelecidle            (hs_out_hip_rxelecidle         ),
    .hip_rxstatus_ch           (hs_out_hip_rxstatus_ch        ),
    .hip_rxvalid               (hs_out_hip_rxvalid            ),
    .hip_tx_clk                (hs_out_hip_tx_clk             ),
    .pcs_eidleinfersel_ch      (hs_out_pcs_eidleinfersel_ch   ),
    .pcs_powerdown_ch          (hs_out_pcs_powerdown_ch       ),
    .pcs_rate                  (hs_out_pcs_rate               ),
    .pcs_rxpolarity            (hs_out_pcs_rxpolarity         ),
    .pcs_txd_ch                (hs_out_pcs_txd_ch             ),
    .pcs_txdeemph              (hs_out_pcs_txdeemph           ),
    .pcs_txdetectrxloopback    (hs_out_pcs_txdetectrxloopback ),
    .pcs_txmargin_ch           (hs_out_pcs_txmargin_ch        ),
    .phystatus                 (hs_out_phystatus              ),
    .rxd_ch                    (hs_out_rxd_ch                 ),
    .rxelecidle                (hs_out_rxelecidle             ),
    .rxstatus_ch               (hs_out_rxstatus_ch            ),
    .rxvalid                   (hs_out_rxvalid                )
);

////////////////////////////////////////////////////////////////////////////////
// tx sub-block instantiation: pipe_interface --------------------------------//
////////////////////////////////////////////////////////////////////////////////

assign pi_in_pipe_tx_clk        = (cram_rtx_pipe_enable === 1'b0) ? 1'b0 : td_out_tx_pipe_clk; 
assign pi_in_powerdown          = td_out_powerdown_int;
assign pi_in_refclk_b           = (cram_rtx_pipe_enable === 1'b0) ? 1'b0 : td_out_refclk_b;
assign pi_in_refclk_b_reset_n   = ~pr_out_txrst_int;
assign pi_in_revloopback        = td_out_revloopback_int; // (enrevparallellpbk_ipd === 1'b1) ? 1'b1 : 1'b0; 
assign pi_in_tx_elec_idle_comp  = td_out_tx_pipe_electidle;
assign pi_in_tx_pipe_reset_n    = ~td_out_tx_pipe_soft_reset;
assign pi_in_txdetectrxloopback = td_out_txdetectrxloopback_int;
assign pi_in_txelecidle         = forceelecidle_ipd;      
assign pi_in_state_transition_done = pipestatetransdone;

// new connection in ww12
assign pi_in_txdeemph           = td_out_phfifo_txdeemph;
assign pi_in_txmargin           = td_out_phfifo_txmargin;
assign pi_in_txswing            = td_out_phfifo_txswing;


arriaii_hssi_tx_pipe_interface tx_pipe_interface_inst (
    .clk                   (pi_in_pipe_tx_clk),
    .refclk_b              (pi_in_refclk_b),
    .refclk_b_reset_n      (pi_in_refclk_b_reset_n),
    .reset_n               (pi_in_tx_pipe_reset_n),
    .rtx_pipe_enable       (cram_rtx_pipe_enable),
    .rtx_elec_idle_delay   (cram_rtx_elec_idle_delay),
    .txdetectrxloopback    (pi_in_txdetectrxloopback),
    .txelecidle            (pi_in_txelecidle),
    .powerdown             (pi_in_powerdown),
    .txd_ch                (pi_in_txd_ch_dprio),
    .revloopback           (pi_in_revloopback),
    .txd                   (pi_out_txd),
    .rev_loopbk            (pi_out_rev_loopbk),
    .tx_elec_idle_comp     (pi_in_tx_elec_idle_comp),
    .tx_elec_idle          (pi_out_tx_elec_idle),
    .txdetectrx            (pi_out_txdetectrx),
    .powerstate            (pi_out_powerstate),
    
    // new interfaces in ARRIAII - ww26.5
    .rtxswing_sel_ena      (cram_rtxswing_sel_ena),
    .txdeemph              (pi_in_txdeemph),
    .txmargin              (pi_in_txmargin),
    .txswing               (pi_in_txswing),
    .txdeemph_int          (pi_out_txdeemph_int),
    .txmargin_int          (pi_out_txmargin_int),
    .txswing_int           (pi_out_txswing_int)
);

////////////////////////////////////////////////////////////////////////////////
// tx sub-block instantiation: tx_digi ---------------------------------------//
////////////////////////////////////////////////////////////////////////////////

assign td_in_phfifourst_tx  = (phfiforeset_ipd === 1'b1) ? 1'b1 : 1'b0;
assign td_in_pld_tx_clk     =  coreclk; // coreclk_ipd;
assign td_in_polinv_tx      = (invpol_ipd === 1'b1) ? 1'b1 : 1'b0;
assign td_in_rddisable_tx   = (phfiforddisable_ipd === 1'b1) ? 1'b1 : 1'b0; // enable by default
assign td_in_refclk_pma     = refclk_ipd;
assign td_in_rev_loop_data  = revparallelfdbk;
assign td_in_rev_loopbk     = pi_out_rev_loopbk;              
assign td_in_tx_data_ts     = xgmdatain;
assign td_in_tx_ctl_ts      = xgmctrl;
assign td_in_txd            = {pi_in_txd_ch_dprio[43:11], hs_out_pcs_txd_ch};//pi_in_txd_ch_dprio; // pi_out_txd - 44 bit
assign td_in_txpcs_rst       = pr_out_txrst_int;
assign td_in_txpma_local_clk = localrefclk;         
assign td_in_wrenable_tx     = (phfifowrenable_ipd === 1'b0) ? 1'b0 : 1'b1;  // enable by default 

// new input in ARRIAII - ww26.5 --------------------------------------------------
assign td_in_gen2ngen1            = (rateswitchisdone === 1'b1) ? 1'b1 : 1'b0;  //from tx_pma local clk divider
assign td_in_gen2ngen1_bundle     = (rateswitchxndone === 1'b1) ? 1'b1 : 1'b0;  //from central clk divider
assign td_in_polinv_rx            = 1'b0;  // leaving it out of tx as it is a simple wire in tx_ctrl 
assign td_in_powerdown            = hs_out_pcs_powerdown_ch;
assign td_in_revloopback          = (enrevparallellpbk_ipd === 1'b1) ? 1'b1 : 1'b0;
assign td_in_rxpolarity           = 1'b0;  //// leaving it out of tx as it is a simple wire in tx_ctrl
assign td_in_txdetectrxloopback   = hs_out_pcs_txdetectrxloopback;

assign td_in_prbs_cid_en     = prbscidenable_in;
assign td_in_tx_boundary_sel = bitslipboundaryselect_in;

// new signal inputs for bundling
// temporary disabled by forcing rindv_tx = 1'b0 todo
assign td_in_tx_div2_sync_in_centrl    = phfifoxnrdclk_in[MPHFIFO_INDEX];
assign td_in_tx_div2_sync_in_quad_up   = phfifoxnrdclk_in[MPHFIFO_INDEX];
assign td_in_tx_div2_sync_in_quad_down = phfifoxnrdclk_in[MPHFIFO_INDEX];
assign td_in_wr_enable_in_centrl       = phfifoxnwrenable_in[MPHFIFO_INDEX];
assign td_in_wr_enable_in_quad_up      = phfifoxnwrenable_in[MPHFIFO_INDEX];
assign td_in_wr_enable_in_quad_down    = phfifoxnwrenable_in[MPHFIFO_INDEX];
assign td_in_rd_enable_in_centrl       = phfifoxnrdenable_in[MPHFIFO_INDEX];
assign td_in_rd_enable_in_quad_up      = phfifoxnrdenable_in[MPHFIFO_INDEX];
assign td_in_rd_enable_in_quad_down    = phfifoxnrdenable_in[MPHFIFO_INDEX];
assign td_in_fifo_select_in_centrl     = phfifoxnbytesel_in[MPHFIFO_INDEX];
assign td_in_fifo_select_in_quad_up    = phfifoxnbytesel_in[MPHFIFO_INDEX];
assign td_in_fifo_select_in_quad_down  = phfifoxnbytesel_in[MPHFIFO_INDEX];
assign td_in_reset_pc_ptrs             = phfifoptrsreset_in;  // from rx
assign td_in_reset_pc_ptrs_in_centrl   = phfifoxnptrsreset_in[MPHFIFO_INDEX];
assign td_in_reset_pc_ptrs_in_quad_up  = phfifoxnptrsreset_in[MPHFIFO_INDEX];
assign td_in_reset_pc_ptrs_in_quad_down = phfifoxnptrsreset_in[MPHFIFO_INDEX];

assign td_in_tx_div2_sync_in_pipe_quad_up   = iqpphfifoxnrdclk_in[MIQP_PHFIFO_INDEX];
assign td_in_tx_div2_sync_in_pipe_quad_down = iqpphfifoxnrdclk_in[MIQP_PHFIFO_INDEX];
assign td_in_wr_enable_in_pipe_quad_up      = iqpphfifoxnwrenable_in[MIQP_PHFIFO_INDEX];
assign td_in_wr_enable_in_pipe_quad_down    = iqpphfifoxnwrenable_in[MIQP_PHFIFO_INDEX];
assign td_in_rd_enable_in_pipe_quad_up      = iqpphfifoxnrdenable_in[MIQP_PHFIFO_INDEX];
assign td_in_rd_enable_in_pipe_quad_down    = iqpphfifoxnrdenable_in[MIQP_PHFIFO_INDEX];
assign td_in_fifo_select_in_pipe_quad_up    = iqpphfifoxnbytesel_in[MIQP_PHFIFO_INDEX];
assign td_in_fifo_select_in_pipe_quad_down  = iqpphfifoxnbytesel_in[MIQP_PHFIFO_INDEX];

assign td_in_dis_pc_byte     = phfifobyteserdisable_in; // from rx
         
// push through TX Phase Comp FIFO
assign td_in_txswing       = pipetxswing_ipd;         
assign td_in_pcs_txdeemph  = hs_out_pcs_txdeemph;     
assign td_in_pcs_txmargin  = hs_out_pcs_txmargin_ch;  

// RX PIPE interface signals
assign td_in_eidleinfersel = hs_out_pcs_eidleinfersel_ch;

assign td_out_tx_div2_sync_out_pipe = (cram_rmaster_up_tx === 1'b0) ? td_out_tx_div2_sync_out_pipe_up : td_out_tx_div2_sync_out_pipe_down;
assign td_out_fifo_select_out_pipe  = (cram_rmaster_up_tx === 1'b0) ? td_out_fifo_select_out_pipe_up  : td_out_fifo_select_out_pipe_down;
assign td_out_wr_enable_out_pipe    = (cram_rmaster_up_tx === 1'b0) ? td_out_wr_enable_out_pipe_up    : td_out_wr_enable_out_pipe_down;
assign td_out_rd_enable_out_pipe    = (cram_rmaster_up_tx === 1'b0) ? td_out_rd_enable_out_pipe_up    : td_out_rd_enable_out_pipe_down;   

arriaii_hssi_tx_digi digi_tx_1 (
    .empty_tx                        (td_out_empty_tx),
    .encoder_testbus                 (td_out_encoder_testbus),
    .full_tx                         (td_out_full_tx),
    .phfifourst_tx                   (td_in_phfifourst_tx),
    .pld_tx_clk                      (td_in_pld_tx_clk),
    .polinv_tx                       (td_in_polinv_tx),
    .pudr                            (td_out_pudr),
    .r8b10b_enc_ibm_en               (cram_r8b10b_enc_ibm_en),
    .rbist_sel                       (cram_rbist_sel),
    .rbisten_tx                      (cram_rbisten_tx),
    .rcascaded_8b10b_en_tx           (cram_rcascaded_8b10b_en_tx),
    .rcxpat_chnl_en                  (cram_rcxpat_chnl_en),
    .rd_enable_sync                  (td_out_rd_enable_sync),
    .rddisable_tx                    (td_in_rddisable_tx),
    .rdwidth_tx                      (cram_rdwidth_tx),
    .refclk_b                        (td_out_refclk_b),
    .refclk_pma                      (td_in_refclk_pma),
    .renbitrev_tx                    (cram_renbitrev_tx),
    .rendec_data_sel_tx              (cram_rendec_data_sel_tx),
    .rendec_tx                       (cram_rendec_tx),
    .renpolinv_tx                    (cram_renpolinv_tx),
    .rensymswap_tx                   (cram_rensymswap_tx),
    .rev_loop_data                   (td_in_rev_loop_data),
    .rev_loopbk                      (td_in_rev_loopbk),
    .rforce_disp                     (cram_rforce_disp),
    .rforce_echar                    (cram_rforce_echar),
    .rforce_kchar                    (cram_rforce_kchar),
    .rfreerun_tx                     (cram_rfreerun_tx),
    .rge_xaui_tx                     (cram_rge_xaui_tx),
    .rib_force_disp                  (cram_rib_force_disp),
    .rindv_tx                        (cram_rindv_tx),
    .rphfifopldentx                  (cram_rphfifopldentx),
    .rphfifoursttx                   (cram_rphfifoursttx),
    .rpma_doublewidth_tx             (cram_rpma_doublewidth_tx),
    .rpmadwidth_tx                   (cram_rpmadwidth_tx),
    .rprbs_sel                       (cram_rprbs_sel),
    .rprbsen_tx                      (cram_rprbsen_tx),
    .rrev_loopbk                     (cram_rrev_loopbk),
    .rtx_pipe_enable                 (cram_rtx_pipe_enable),
    .rtxfifo_dis                     (cram_rtxfifo_dis),
    .rtxfifo_lowlatency_en           (cram_rtxfifo_lowlatency_en),
    .rtxrdclksel                     (cram_rtxrdclksel),
    .rtxwrclksel                     (cram_rtxwrclksel),
    .scan_mode                       (cram_scan_mode),
    .tx_clk_out                      (td_out_tx_clk_out),
    .tx_ctl_tc                       (td_out_tx_ctl_tc),
    .tx_ctl_ts                       (td_in_tx_ctl_ts),
    .tx_ctrl_testbus                 (td_out_tx_ctrl_testbus),
    .tx_data_tc                      (td_out_tx_data_tc),
    .tx_data_ts                      (td_in_tx_data_ts),
    .tx_pipe_clk                     (td_out_tx_pipe_clk),
    .tx_pipe_electidle               (td_out_tx_pipe_electidle),
    .tx_pipe_soft_reset              (td_out_tx_pipe_soft_reset),
    .txd                             (td_in_txd),
    .txlp20b                         (td_out_txlp20b),
    .txpcs_rst                       (td_in_txpcs_rst),
    .txpma_local_clk                 (td_in_txpma_local_clk),
    .wrenable_tx                     (td_in_wrenable_tx),
    
    .gen2ngen1                       (td_in_gen2ngen1),
    .gen2ngen1_bundle                (td_in_gen2ngen1_bundle),
    .polinv_rx                       (td_in_polinv_rx),
    .powerdown                       (td_in_powerdown),
    .revloopback                     (td_in_revloopback),
    .rxpolarity                      (td_in_rxpolarity),
    .txdetectrxloopback              (td_in_txdetectrxloopback),

    .rauto_speed_ena                 (cram_rauto_speed_ena),
    .rfreq_sel                       (cram_rfreq_sel),
    .rtxpcsbypass_en                 (cram_rtxpcsbypass_en),
    .rtxpcsclkpwdn                   (cram_rtxpcsclkpwdn),

    .polinv_rx_int                   (td_out_polinv_rx_int),
    .powerdown_int                   (td_out_powerdown_int),
    .revloopback_int                 (td_out_revloopback_int),
    .rxpolarity_int                  (td_out_rxpolarity_int),
    .txdetectrxloopback_int          (td_out_txdetectrxloopback_int),
    
    .prbs_cid_en                     (td_in_prbs_cid_en),
    .tx_boundary_sel                 (td_in_tx_boundary_sel),
    .rcid_pattern_tx                 (cram_rcid_pattern_tx),
    .rcid_len_tx                     (cram_rcid_len_tx),
    
    .tx_div2_sync_in_centrl          (td_in_tx_div2_sync_in_centrl),
    .tx_div2_sync_in_quad_up         (td_in_tx_div2_sync_in_quad_up),
    .tx_div2_sync_in_quad_down       (td_in_tx_div2_sync_in_quad_down),
    .wr_enable_in_centrl             (td_in_wr_enable_in_centrl),
    .wr_enable_in_quad_up            (td_in_wr_enable_in_quad_up),
    .wr_enable_in_quad_down          (td_in_wr_enable_in_quad_down),
    .rd_enable_in_centrl             (td_in_rd_enable_in_centrl),
    .rd_enable_in_quad_up            (td_in_rd_enable_in_quad_up),
    .rd_enable_in_quad_down          (td_in_rd_enable_in_quad_down),
    .fifo_select_in_centrl           (td_in_fifo_select_in_centrl),
    .fifo_select_in_quad_up          (td_in_fifo_select_in_quad_up),
    .fifo_select_in_quad_down        (td_in_fifo_select_in_quad_down),
    .reset_pc_ptrs                   (td_in_reset_pc_ptrs),
    .reset_pc_ptrs_in_centrl         (td_in_reset_pc_ptrs_in_centrl),
    .reset_pc_ptrs_in_quad_up        (td_in_reset_pc_ptrs_in_quad_up),
    .reset_pc_ptrs_in_quad_down      (td_in_reset_pc_ptrs_in_quad_down),
    .tx_div2_sync_in_pipe_quad_up    (td_in_tx_div2_sync_in_pipe_quad_up),
    .tx_div2_sync_in_pipe_quad_down  (td_in_tx_div2_sync_in_pipe_quad_down),
    .wr_enable_in_pipe_quad_up       (td_in_wr_enable_in_pipe_quad_up),
    .wr_enable_in_pipe_quad_down     (td_in_wr_enable_in_pipe_quad_down),
    .rd_enable_in_pipe_quad_up       (td_in_rd_enable_in_pipe_quad_up),
    .rd_enable_in_pipe_quad_down     (td_in_rd_enable_in_pipe_quad_down),
    .fifo_select_in_pipe_quad_up     (td_in_fifo_select_in_pipe_quad_up),
    .fifo_select_in_pipe_quad_down   (td_in_fifo_select_in_pipe_quad_down),
    
    .dis_pc_byte                     (td_in_dis_pc_byte),
    
    .rmaster_tx                      (cram_rmaster_tx),
    .rmaster_up_tx                   (cram_rmaster_up_tx),
    .rself_sw_en_tx                  (cram_rself_sw_en_tx),
    .rpipeline_bypass_tx             (cram_rpipeline_bypass_tx),
    .rphfifo_regmode_tx              (cram_rphfifo_regmode_tx),
    
    .tx_div2_sync_out_pipe_up        (td_out_tx_div2_sync_out_pipe_up),
    .fifo_select_out_pipe_up         (td_out_fifo_select_out_pipe_up),
    .wr_enable_out_pipe_up           (td_out_wr_enable_out_pipe_up),
    .rd_enable_out_pipe_up           (td_out_rd_enable_out_pipe_up),
    .tx_div2_sync_out_pipe_down      (td_out_tx_div2_sync_out_pipe_down),
    .fifo_select_out_pipe_down       (td_out_fifo_select_out_pipe_down),
    .wr_enable_out_pipe_down         (td_out_wr_enable_out_pipe_down),
    .rd_enable_out_pipe_down         (td_out_rd_enable_out_pipe_down),
    
    .txswing                         (td_in_txswing),
    .pcs_txdeemph                    (td_in_pcs_txdeemph),
    .pcs_txmargin                    (td_in_pcs_txmargin),
    .eidleinfersel                   (td_in_eidleinfersel),

    .phfifo_txswing                  (td_out_phfifo_txswing),
    .phfifo_txdeemph                 (td_out_phfifo_txdeemph),
    .phfifo_txmargin                 (td_out_phfifo_txmargin),
    .gray_eidleinfersel              (td_out_gray_eidleinfersel),
    
    .rtxbitslip_en                   (cram_rtxbitslip_en)
);

endmodule // stratixiigx_hssi_transmitter 


//Rev: 1.13   Tue Aug 12 10:38:50 PDT 2008 
//
`timescale 1 ps / 1 ps
 
module arriaii_hssi_rx_digis_ph_fifo (
		   // inputs
		   rst_wclk,
		   rst_rclk,
		   wr_clk,
		   rd_clk,
		   en,
		   lowlatency_en,
		   we,
		   re,
		   din,
		   rphfifo_regmode_rx,
		   rindv_rx,
		   rauto_speed_ena,
		   reset_pc_ptrs,
		   reset_pc_ptrs_centrl,
		   reset_pc_ptrs_quad_up,
		   reset_pc_ptrs_quad_down,	
		   rmaster_rx,
		   rmaster_up_rx,
		   // outputs
		   data_out,
		   ph_fifo_full,
		   ph_fifo_empty,
		   wptr_bin,
		   rptr_bin,
		   pcs_wrapback_in,
		   rpcs_wrapback_en,
		   scan_mode
		   );

   // =======
   // inputs 
   // =======
   input         rst_wclk;
   input         rst_rclk;
   input         wr_clk;           // Write Clock
   input         rd_clk;           // Read Clock
   input         en;            	// Disable FIFO or bypass - only for Altera internal debug
   input         lowlatency_en; 	// low latency enable
   input         we;	    	// PLD dynamic write pointer enable  
   input         re;	    	// PLD dynamic read pointer enable  
   input [69:0]  din;              // 10-bit code-group bus from deskew module.
   
   input 	 rphfifo_regmode_rx;
   input 	 rindv_rx;
   input 	 rmaster_rx;
   input 	 rmaster_up_rx;
   input 	 rauto_speed_ena;
   input 	 reset_pc_ptrs;
   input 	 reset_pc_ptrs_centrl;
   input 	 reset_pc_ptrs_quad_up;
   input 	 reset_pc_ptrs_quad_down;

   input [69:0]  pcs_wrapback_in;
   input 	rpcs_wrapback_en;
   input 	scan_mode;
   

   
   // =======
   // outputs 
   // =======
   output        ph_fifo_full;	// Indicates overflow (rd_clk)
   output        ph_fifo_empty;	// FIFO empty (rd_clk)
   output [69:0] data_out;		// output data (rd_clk synchronous if not FIFO bypass)
   output [2:0]  wptr_bin;		// test bus
   output [2:0]  rptr_bin;		// test bus
   
   // ===================
   // signal declaration
   // ===================
   reg [ 7:0] 	 wptr, rptr;
   reg [ 2:0] 	 wptr_gray;
   reg [ 2:0] 	 wptr_gray0;
   reg [ 2:0] 	 wptr0;
   reg [ 2:0] 	 wptr1;
   reg [ 7:0] 	 wptr1_onehot;
   reg [ 7:0] 	 rptr0_pre;
   reg [ 7:0] 	 rptr0;
   reg [ 7:0] 	 rptr1;
   reg 		 first_rd;
   reg [69:0] 	 ram_data_out;
   wire [69:0] 	 ram_data_out_pre;
   reg [2:0] 	 wptr_bin;		// test bus
   reg [2:0] 	 rptr_bin;		// test bus
   
   reg 		 ph_fifo_full, ph_fifo_empty;
   reg 		 ph_fifo_empty_pre;
   
   wire 	 rst_n;			// Invert rst for new FIFO     
   
   wire [3:0] 	 fifo_cnt;
   reg [3:0] 	 fifo_cnt_pre;
   reg [2:0] 	 rptr1_bin;
   reg [2:0] 	 wptr1_bin_rclk;

   wire 	 reset_ptrs_local;

   reg 		 reset_ptrs_local_sync1;
   reg 		 reset_ptrs_local_sync2;
   
      
   // =============
   // functionality
   // =============
   assign rst_n = ~rst_wclk;
   
   // bypass
   assign data_out[69:0] = en ? ram_data_out : din;

   assign reset_ptrs_local = rauto_speed_ena & (rmaster_rx ? (rindv_rx ? reset_pc_ptrs : reset_pc_ptrs_centrl) : (rmaster_up_rx ? reset_pc_ptrs_quad_up : reset_pc_ptrs_quad_down));
      
   // write pointer
   always @ (posedge rst_wclk or posedge wr_clk)
     begin
	if (rst_wclk == 1'b1)
	  begin
	     wptr <= #1 8'h01;
	  end
	else if (rphfifo_regmode_rx)
	  begin
	     wptr <= #1 8'h01;
	  end
	else if (reset_ptrs_local)
	  begin
	     wptr <= #1 8'h01;
	  end
	else
	  begin
	     if (we == 1'b1)
               wptr <= #1 {wptr[6:0],wptr[7]};
	  end
     end // always @ (posedge rst_wclk or posedge wr_clk)
   
   
   //newly added fifo_cnt and fifo_cnt_pre logic for full/empty flag use
   assign fifo_cnt = (rptr1_bin == wptr1_bin_rclk) ?
                     //((rst_rclk != 1'b1) ? ((fifo_cnt_pre==4'd1)?4'd0:4'd8) : 4'd0) :
                     ((rst_rclk != 1'b1) ? (((fifo_cnt_pre==4'd7 || fifo_cnt_pre==4'd6||fifo_cnt_pre==4'd8))?4'd8:4'd0) : 4'd0) :
                     ((wptr1_bin_rclk > rptr1_bin) ?
                      (wptr1_bin_rclk - rptr1_bin) :
                      (4'd8 - (rptr1_bin - wptr1_bin_rclk)));
   
   always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk == 1'b1)
	  begin
	     reset_ptrs_local_sync1 <= #1 1'b0;
	     reset_ptrs_local_sync2 <= #1 1'b0;
	  end // if (rst_rclk == 1'b1)
	else if (rphfifo_regmode_rx)
	  begin
	     reset_ptrs_local_sync1 <= #1 1'b0;
	     reset_ptrs_local_sync2 <= #1 1'b0;
	  end
	else 
	  begin
	     reset_ptrs_local_sync1 <= #1 reset_ptrs_local;
	     reset_ptrs_local_sync2 <= #1 reset_ptrs_local_sync1;
	  end
     end // always @ (posedge rst_rclk or posedge rd_clk)
   
//ECO for S4GX to fix metastability issue
// replace the 1st FF with new flop w/o reset
// replace the 2nd FF with an enhanced flop
always @ (posedge rd_clk)
begin
  if (reset_ptrs_local_sync2 || rphfifo_regmode_rx)
    wptr0 <= #1 3'b001;
  else
    wptr0 <= #1 wptr_gray;
end // always @ (posedge rst_rclk or posedge rd_clk)
   
always @ (posedge rst_rclk or posedge rd_clk)
begin
  if (rst_rclk == 1'b1)
    wptr1 <= #1 3'b001;
  else if (reset_ptrs_local_sync2 || rphfifo_regmode_rx)
    wptr1 <= #1 3'b001;
  else
    wptr1 <= #1 wptr0;
end // always @ (posedge rst_rclk or posedge rd_clk)
   
   // read pointer
   // full & empty
   always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk == 1'b1)
	  begin
	     rptr  <= #1 8'h20;
	     rptr0_pre <= #1 8'h10;
	     rptr0 <= #1 8'h10;
	     rptr1 <= #1 8'h10;
	     ph_fifo_full <= #1 1'b0;
	     ph_fifo_empty <= #1 1'b0;
	     ph_fifo_empty_pre <= #1 1'b0;
	     first_rd <= #1 1'b1;
	     fifo_cnt_pre <= #1 4'b0000; // fifo_cnt previous value
	  end // if (rst_rclk == 1'b1)
	else if (reset_ptrs_local_sync2 || rphfifo_regmode_rx)
	  begin
	     rptr  <= #1 8'h20;
	     rptr0_pre <= #1 8'h10;
	     rptr0 <= #1 8'h10;
	     rptr1 <= #1 8'h10;
	     ph_fifo_full <= #1 1'b0;
	     ph_fifo_empty <= #1 1'b0;
	     ph_fifo_empty_pre <= #1 1'b0;
	     first_rd <= #1 1'b1;
	     fifo_cnt_pre <= #1 4'b0000; // fifo_cnt previous value
	  end // if (reset_ptrs_local_sync2)
	else
	  begin
	     ph_fifo_empty <= #1 ph_fifo_empty_pre;
	     fifo_cnt_pre <= #1 fifo_cnt;
	     
	     rptr0_pre <= #1 rptr;
	     rptr0 <= #1 rptr0_pre;
	     rptr1 <= #1 rptr0;
	     
	     if (first_rd == 1'b1 && re == 1'b1)
               first_rd <= #1 1'b0;
	     
	     // advance by 2 on first read in low-latency mode
	     if (re == 1'b1)
               if (first_rd == 1'b1 && lowlatency_en == 1'b1)
		 rptr <= #1 {rptr[5:0],rptr[7:6]};
               else
		 rptr <= #1 {rptr[6:0],rptr[7]};
	     
	     // full condition
	     //$if ({wptr1_onehot[6:0],wptr1_onehot[7]} == rptr1)
	     //new full flag requirement
             if (({rptr1[6:0],rptr1[7]} == wptr1_onehot) && (fifo_cnt_pre==4'd7 || fifo_cnt_pre==4'd8) && (!ph_fifo_empty_pre)) 
               ph_fifo_full <= #1 1'b1;
             //else if (ph_fifo_full == 1'b1 && ({rptr1[6:0],rptr1[7]} != wptr1_onehot)) //become sticky until reset
               //ph_fifo_full <= #1 1'b0;
	     
	     // empty condition
	     //$if ({rptr1[6:0],rptr1[7]} == wptr1_onehot)
	     //new empty flag requirement
	     if (fifo_cnt==4'd0 && (!ph_fifo_full))
               ph_fifo_empty_pre <= #1 1'b1;
	     //else if (ph_fifo_empty_pre == 1'b1 && (rptr1 != wptr1_onehot)) // become sticky until reset
               //ph_fifo_empty_pre <= #1 1'b0;
	  end // else: !if(rst_rclk == 1'b1)
     end // always @ (posedge rst_rclk or posedge rd_clk)
   
   
   /*ram8x65_syn   ram8x65_syn_1 (
    .rst_l   (rst_n),
    .clk     (wr_clk),
    .fifo_wr (wptr),
    .data_in (din),
    .fifo_re (rptr),
    .data_out(ram_data_out_pre)
    ); 
    */
   
   arriaii_hssi_rx_digis_ram8x70_syn   ram8x70_syn_1 (
                                .rst_l   (rst_n),
                                .clk     (wr_clk),
                                .fifo_wr (wptr),
                                .data_in (din),
                                .fifo_re (rptr),
                                .data_out(ram_data_out_pre)
                                );

         
  always @ (posedge rst_rclk or posedge rd_clk)
     begin
	if (rst_rclk)
	  begin
	     ram_data_out <= #1 70'h000000000000000000;
	  end
	else if (rphfifo_regmode_rx)
	  begin
	     ram_data_out <= #1 din;
	  end
	else
	  begin
             ram_data_out <= #1 ram_data_out_pre;
	  end
  end // always @ (posedge rst_rclk or posedge rd_clk)

      
  always@(wptr)
     begin
	case(wptr)
	  8'h01: wptr_bin = 3'h0;
	  8'h02: wptr_bin = 3'h1;
	  8'h04: wptr_bin = 3'h2;
	  8'h08: wptr_bin = 3'h3;
	  8'h10: wptr_bin = 3'h4;
	  8'h20: wptr_bin = 3'h5;
	  8'h40: wptr_bin = 3'h6;
	  8'h80: wptr_bin = 3'h7;
	  default: wptr_bin = 3'h7;
	endcase // case(wptr)
     end // always@ (wptr)
   
   
   always@(rptr)
     begin
	case(rptr)
	  8'h01: rptr_bin = 3'h0;
	  8'h02: rptr_bin = 3'h1;
	  8'h04: rptr_bin = 3'h2;
	  8'h08: rptr_bin = 3'h3;
	  8'h10: rptr_bin = 3'h4;
	  8'h20: rptr_bin = 3'h5;
	  8'h40: rptr_bin = 3'h6;
	  8'h80: rptr_bin = 3'h7;
	  default: rptr_bin = 3'h7;
	endcase // case(rptr)
     end // always@ (rptr)
   
   
   always@(rptr1)
     begin
	case(rptr1)
	  8'h01: rptr1_bin = 3'h0;
	  8'h02: rptr1_bin = 3'h1;
	  8'h04: rptr1_bin = 3'h2;
	  8'h08: rptr1_bin = 3'h3;
	  8'h10: rptr1_bin = 3'h4;
	  8'h20: rptr1_bin = 3'h5;
	  8'h40: rptr1_bin = 3'h6;
	  8'h80: rptr1_bin = 3'h7;
	  default: rptr1_bin = 3'h7;
	endcase // case(rptr1)
     end // always@ (rptr1)
   
   always @ (posedge rst_wclk or posedge wr_clk)
     begin
	if (rst_wclk == 1'b1)
          wptr_gray <= #1 3'h0;
        else
          wptr_gray <= #1 wptr_gray0;
     end
   
   always@(wptr)
     begin
	case(wptr)
	  8'h01: wptr_gray0 = 3'h0;
	  8'h02: wptr_gray0 = 3'h1;
	  8'h04: wptr_gray0 = 3'h3;
	  8'h08: wptr_gray0 = 3'h2;
	  8'h10: wptr_gray0 = 3'h6;
	  8'h20: wptr_gray0 = 3'h7;
	  8'h40: wptr_gray0 = 3'h5;
	  8'h80: wptr_gray0 = 3'h4;
	  default: wptr_gray0 = 3'h0;
	endcase // case(wptr)
     end // always@ (wptr)
   
   
   always@(wptr1)
     begin
	case(wptr1)
	  3'h0: wptr1_onehot = 8'h01;
	  3'h1: wptr1_onehot = 8'h02;
	  3'h3: wptr1_onehot = 8'h04;
	  3'h2: wptr1_onehot = 8'h08;
	  3'h6: wptr1_onehot = 8'h10;
	  3'h7: wptr1_onehot = 8'h20;
	  3'h5: wptr1_onehot = 8'h40;
	  3'h4: wptr1_onehot = 8'h80;
	  default: wptr1_onehot = 8'h80;
	endcase // case(wptr1)
     end // always@ (wptr1)
   
   
   always@(wptr1)
     begin
	case(wptr1)
	  3'h0: wptr1_bin_rclk = 3'h0;
	  3'h1: wptr1_bin_rclk = 3'h1;
	  3'h3: wptr1_bin_rclk = 3'h2;
	  3'h2: wptr1_bin_rclk = 3'h3;
	  3'h6: wptr1_bin_rclk = 3'h4;
	  3'h7: wptr1_bin_rclk = 3'h5;
	  3'h5: wptr1_bin_rclk = 3'h6;
	  3'h4: wptr1_bin_rclk = 3'h7;
	  default: wptr1_bin_rclk = 3'h0;
	endcase // case(wptr1)
     end // always@ (wptr1)
      
endmodule // ph_fifo_rx



`timescale 1ns / 1ps

module arriaii_hssi_rx_digis_ram16x14_syn (
    clk,
    rst_l, 
    addr_wr,
    addr_rd1,
    addr_rd2,
    data_in,
    we,
    re_l,
    data_out1,
    data_out2
    );

input 		clk;
input 		rst_l;
input 	[15:0]	addr_wr;
input 	[15:0] 	addr_rd1;
input 	[15:0] 	addr_rd2;
input 	[13:0] 	data_in;
input 		we, re_l;
output 	[13:0] 	data_out1;
output 	[13:0] 	data_out2;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 14;

reg [ram_width-1:0] data_out1_i, data_out2_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, ram_array_d_3,
		    ram_array_d_4, ram_array_d_5, ram_array_d_6, ram_array_d_7,
		    ram_array_d_8, ram_array_d_9, ram_array_d_10, 
                    ram_array_d_11,
		    ram_array_d_12, ram_array_d_13, ram_array_d_14, 
                    ram_array_d_15,
		    ram_array_q_0, ram_array_q_1, ram_array_q_2, ram_array_q_3,
		    ram_array_q_4, ram_array_q_5, ram_array_q_6, ram_array_q_7,
		    ram_array_q_8, ram_array_q_9, ram_array_q_10, 
                    ram_array_q_11,
		    ram_array_q_12, ram_array_q_13, ram_array_q_14, 
                    ram_array_q_15;
wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7,
		     data_reg_8, data_reg_9, data_reg_10, data_reg_11,
		     data_reg_12, data_reg_13, data_reg_14, data_reg_15;

 /* Modelling the read port */
 /* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( addr_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( addr_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( addr_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( addr_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( addr_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( addr_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( addr_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( addr_wr[7] == 1'b1 ) ? data_in : ram_array_q_7,
    data_reg_8 = ( addr_wr[8] == 1'b1 ) ? data_in : ram_array_q_8,
    data_reg_9 = ( addr_wr[9] == 1'b1 ) ? data_in : ram_array_q_9,
    data_reg_10 = ( addr_wr[10] == 1'b1 ) ? data_in : ram_array_q_10,
    data_reg_11 = ( addr_wr[11] == 1'b1 ) ? data_in : ram_array_q_11,
    data_reg_12 = ( addr_wr[12] == 1'b1 ) ? data_in : ram_array_q_12,
    data_reg_13 = ( addr_wr[13] == 1'b1 ) ? data_in : ram_array_q_13,
    data_reg_14 = ( addr_wr[14] == 1'b1 ) ? data_in : ram_array_q_14,
    data_reg_15 = ( addr_wr[15] == 1'b1 ) ? data_in : ram_array_q_15;


assign #read_access_time data_out1 = re_l ? 14'b00000000000000 : data_out1_i;
assign #read_access_time data_out2 = re_l ? 14'b00000000000000 : data_out2_i;


always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or 
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15      or 
    addr_rd1		or
    addr_rd2		)
begin
    case ( addr_rd1 )  // synopsys parallel_case full_case
    16'b0000000000000001 : data_out1_i = ram_array_q_0;
    16'b0000000000000010 : data_out1_i = ram_array_q_1;
    16'b0000000000000100 : data_out1_i = ram_array_q_2;
    16'b0000000000001000 : data_out1_i = ram_array_q_3;
    16'b0000000000010000 : data_out1_i = ram_array_q_4;
    16'b0000000000100000 : data_out1_i = ram_array_q_5;
    16'b0000000001000000 : data_out1_i = ram_array_q_6;
    16'b0000000010000000 : data_out1_i = ram_array_q_7;
    16'b0000000100000000 : data_out1_i = ram_array_q_8;
    16'b0000001000000000 : data_out1_i = ram_array_q_9;
    16'b0000010000000000 : data_out1_i = ram_array_q_10;
    16'b0000100000000000 : data_out1_i = ram_array_q_11;
    16'b0001000000000000 : data_out1_i = ram_array_q_12;
    16'b0010000000000000 : data_out1_i = ram_array_q_13;
    16'b0100000000000000 : data_out1_i = ram_array_q_14;
    16'b1000000000000000 : data_out1_i = ram_array_q_15;
    endcase

    case ( addr_rd2 )  // synopsys parallel_case full_case
    16'b0000000000000001 : data_out2_i = ram_array_q_0;
    16'b0000000000000010 : data_out2_i = ram_array_q_1;
    16'b0000000000000100 : data_out2_i = ram_array_q_2;
    16'b0000000000001000 : data_out2_i = ram_array_q_3;
    16'b0000000000010000 : data_out2_i = ram_array_q_4;
    16'b0000000000100000 : data_out2_i = ram_array_q_5;
    16'b0000000001000000 : data_out2_i = ram_array_q_6;
    16'b0000000010000000 : data_out2_i = ram_array_q_7;
    16'b0000000100000000 : data_out2_i = ram_array_q_8;
    16'b0000001000000000 : data_out2_i = ram_array_q_9;
    16'b0000010000000000 : data_out2_i = ram_array_q_10;
    16'b0000100000000000 : data_out2_i = ram_array_q_11;
    16'b0001000000000000 : data_out2_i = ram_array_q_12;
    16'b0010000000000000 : data_out2_i = ram_array_q_13;
    16'b0100000000000000 : data_out2_i = ram_array_q_14;
    16'b1000000000000000 : data_out2_i = ram_array_q_15;
    endcase

end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 0;
	ram_array_q_1 <= #write_access_time 0;
	ram_array_q_2 <= #write_access_time 0; 
	ram_array_q_3 <= #write_access_time 0; 
        ram_array_q_4 <= #write_access_time 0;
        ram_array_q_5 <= #write_access_time 0;
        ram_array_q_6 <= #write_access_time 0;
        ram_array_q_7 <= #write_access_time 0; 
        ram_array_q_8 <= #write_access_time 0;
        ram_array_q_9 <= #write_access_time 0;
        ram_array_q_10 <= #write_access_time 0;
        ram_array_q_11 <= #write_access_time 0; 
        ram_array_q_12 <= #write_access_time 0;
        ram_array_q_13 <= #write_access_time 0;
        ram_array_q_14 <= #write_access_time 0;
        ram_array_q_15 <= #write_access_time 0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
        ram_array_q_8 <= #write_access_time ram_array_d_8;
        ram_array_q_9 <= #write_access_time ram_array_d_9;
        ram_array_q_10 <= #write_access_time ram_array_d_10;
        ram_array_q_11 <= #write_access_time ram_array_d_11;
        ram_array_q_12 <= #write_access_time ram_array_d_12;
        ram_array_q_13 <= #write_access_time ram_array_d_13;
        ram_array_q_14 <= #write_access_time ram_array_d_14;
        ram_array_q_15 <= #write_access_time ram_array_d_15;
    end
end
         

always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    data_reg_8          or
    data_reg_9          or
    data_reg_10         or
    data_reg_11         or
    data_reg_12         or
    data_reg_13         or
    data_reg_14         or
    data_reg_15         or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	or
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11	or
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15	)
begin
    if(we) begin
	ram_array_d_0 <= #write_access_time data_reg_0;
	ram_array_d_1 <= #write_access_time data_reg_1;
	ram_array_d_2 <= #write_access_time data_reg_2;
	ram_array_d_3 <= #write_access_time data_reg_3;
        ram_array_d_4 <= #write_access_time data_reg_4;
        ram_array_d_5 <= #write_access_time data_reg_5;
        ram_array_d_6 <= #write_access_time data_reg_6;
        ram_array_d_7 <= #write_access_time data_reg_7; 
        ram_array_d_8 <= #write_access_time data_reg_8;
        ram_array_d_9 <= #write_access_time data_reg_9;
        ram_array_d_10 <= #write_access_time data_reg_10;
        ram_array_d_11 <= #write_access_time data_reg_11; 
        ram_array_d_12 <= #write_access_time data_reg_12;
        ram_array_d_13 <= #write_access_time data_reg_13;
        ram_array_d_14 <= #write_access_time data_reg_14;
        ram_array_d_15 <= #write_access_time data_reg_15; 
    end
    else begin
	ram_array_d_0 <= #write_access_time ram_array_q_0;
	ram_array_d_1 <= #write_access_time ram_array_q_1;
	ram_array_d_2 <= #write_access_time ram_array_q_2;
	ram_array_d_3 <= #write_access_time ram_array_q_3;
        ram_array_d_4 <= #write_access_time ram_array_q_4;
        ram_array_d_5 <= #write_access_time ram_array_q_5;
        ram_array_d_6 <= #write_access_time ram_array_q_6;
        ram_array_d_7 <= #write_access_time ram_array_q_7;
        ram_array_d_8 <= #write_access_time ram_array_q_8;
        ram_array_d_9 <= #write_access_time ram_array_q_9;
        ram_array_d_10 <= #write_access_time ram_array_q_10;
        ram_array_d_11 <= #write_access_time ram_array_q_11;
        ram_array_d_12 <= #write_access_time ram_array_q_12;
        ram_array_d_13 <= #write_access_time ram_array_q_13;
        ram_array_d_14 <= #write_access_time ram_array_q_14;
        ram_array_d_15 <= #write_access_time ram_array_q_15;

    end
end

endmodule


`timescale 1ps / 1ps

module arriaii_hssi_rx_digis_ram20x16_syn (
    data_in,
    clk,
    fifo_wr,
    rst_l, 
    fifo_re1,
    fifo_re2,
    data_out1,
    data_out2
    );

input 		clk;
input 		rst_l;
input 	[19:0]	fifo_wr;
input 	[19:0] 	fifo_re1;
input 	[19:0] 	fifo_re2;
input 	[15:0] 	data_in;
output 	[15:0] 	data_out1;
output 	[15:0] 	data_out2;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 16;

reg [ram_width-1:0] data_out1_i, data_out2_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, ram_array_d_8, 
                    ram_array_d_9, ram_array_d_10, ram_array_d_11,
                    ram_array_d_12, ram_array_d_13, ram_array_d_14,
		    ram_array_d_15, ram_array_d_16, ram_array_d_17, 
		    ram_array_d_18, ram_array_d_19, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7, ram_array_q_8, 
                    ram_array_q_9, ram_array_q_10, ram_array_q_11,
                    ram_array_q_12, ram_array_q_13, ram_array_q_14,
		    ram_array_q_15, ram_array_q_16, ram_array_q_17, 
		    ram_array_q_18, ram_array_q_19; 
wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7,
		     data_reg_8, data_reg_9, data_reg_10, data_reg_11, 
		     data_reg_12, data_reg_13, data_reg_14, data_reg_15, 
	             data_reg_16, data_reg_17, data_reg_18, data_reg_19;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7,
    data_reg_8 = ( fifo_wr[8] == 1'b1 ) ? data_in : ram_array_q_8,
    data_reg_9 = ( fifo_wr[9] == 1'b1 ) ? data_in : ram_array_q_9,
    data_reg_10 = ( fifo_wr[10] == 1'b1 ) ? data_in : ram_array_q_10,
    data_reg_11 = ( fifo_wr[11] == 1'b1 ) ? data_in : ram_array_q_11,
    data_reg_12 = ( fifo_wr[12] == 1'b1 ) ? data_in : ram_array_q_12,
    data_reg_13 = ( fifo_wr[13] == 1'b1 ) ? data_in : ram_array_q_13,
    data_reg_14 = ( fifo_wr[14] == 1'b1 ) ? data_in : ram_array_q_14,
    data_reg_15 = ( fifo_wr[15] == 1'b1 ) ? data_in : ram_array_q_15,
    data_reg_16 = ( fifo_wr[16] == 1'b1 ) ? data_in : ram_array_q_16,
    data_reg_17 = ( fifo_wr[17] == 1'b1 ) ? data_in : ram_array_q_17,
    data_reg_18 = ( fifo_wr[18] == 1'b1 ) ? data_in : ram_array_q_18,
    data_reg_19 = ( fifo_wr[19] == 1'b1 ) ? data_in : ram_array_q_19;


// 03/22/05 VC: LEDA fix: Remove delay on combinatorial statement
//                        and changed 15'b0 to 16'd0
//assign #read_access_time data_out1 = re_l ? 15'b0 : data_out1_i;
//assign #read_access_time data_out2 = re_l ? 15'b0 : data_out2_i;
assign data_out1 = re_l ? 16'd0 : data_out1_i;
assign data_out2 = re_l ? 16'd0 : data_out2_i;


always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or 
    ram_array_q_12      or 
    ram_array_q_13      or 
    ram_array_q_14      or 
    ram_array_q_15      or 
    ram_array_q_16      or 
    ram_array_q_17      or 
    ram_array_q_18      or 
    ram_array_q_19      or 
    fifo_re1		or
    fifo_re2		)
begin
// 03/22/05 VC: Removed full case statement because
//              not all cases are listed
//    case ( fifo_re1 )  // synopsys parallel_case full_case
    case ( fifo_re1 )  // synopsys parallel_case
    20'b00000000000000000001 : data_out1_i = ram_array_q_0;
    20'b00000000000000000010 : data_out1_i = ram_array_q_1;
    20'b00000000000000000100 : data_out1_i = ram_array_q_2;
    20'b00000000000000001000 : data_out1_i = ram_array_q_3;
    20'b00000000000000010000 : data_out1_i = ram_array_q_4;
    20'b00000000000000100000 : data_out1_i = ram_array_q_5;
    20'b00000000000001000000 : data_out1_i = ram_array_q_6;
    20'b00000000000010000000 : data_out1_i = ram_array_q_7;
    20'b00000000000100000000 : data_out1_i = ram_array_q_8;
    20'b00000000001000000000 : data_out1_i = ram_array_q_9;
    20'b00000000010000000000 : data_out1_i = ram_array_q_10;
    20'b00000000100000000000 : data_out1_i = ram_array_q_11;
    20'b00000001000000000000 : data_out1_i = ram_array_q_12;
    20'b00000010000000000000 : data_out1_i = ram_array_q_13;
    20'b00000100000000000000 : data_out1_i = ram_array_q_14;
    20'b00001000000000000000 : data_out1_i = ram_array_q_15;
    20'b00010000000000000000 : data_out1_i = ram_array_q_16;
    20'b00100000000000000000 : data_out1_i = ram_array_q_17;
    20'b01000000000000000000 : data_out1_i = ram_array_q_18;
    20'b10000000000000000000 : data_out1_i = ram_array_q_19;
// 03/22/05 VC: LEDA fix: Added default clause to case statement
    default                  : data_out1_i = ram_array_q_0;
    endcase

// 03/22/05 VC: Removed full case statement because
//              not all cases are listed
//    case ( fifo_re2 )  // synopsys parallel_case full_case
    case ( fifo_re2 )  // synopsys parallel_case
    20'b00000000000000000001 : data_out2_i = ram_array_q_0;
    20'b00000000000000000010 : data_out2_i = ram_array_q_1;
    20'b00000000000000000100 : data_out2_i = ram_array_q_2;
    20'b00000000000000001000 : data_out2_i = ram_array_q_3;
    20'b00000000000000010000 : data_out2_i = ram_array_q_4;
    20'b00000000000000100000 : data_out2_i = ram_array_q_5;
    20'b00000000000001000000 : data_out2_i = ram_array_q_6;
    20'b00000000000010000000 : data_out2_i = ram_array_q_7;
    20'b00000000000100000000 : data_out2_i = ram_array_q_8;
    20'b00000000001000000000 : data_out2_i = ram_array_q_9;
    20'b00000000010000000000 : data_out2_i = ram_array_q_10;
    20'b00000000100000000000 : data_out2_i = ram_array_q_11;
    20'b00000001000000000000 : data_out2_i = ram_array_q_12;
    20'b00000010000000000000 : data_out2_i = ram_array_q_13;
    20'b00000100000000000000 : data_out2_i = ram_array_q_14;
    20'b00001000000000000000 : data_out2_i = ram_array_q_15;
    20'b00010000000000000000 : data_out2_i = ram_array_q_16;
    20'b00100000000000000000 : data_out2_i = ram_array_q_17;
    20'b01000000000000000000 : data_out2_i = ram_array_q_18;
    20'b10000000000000000000 : data_out2_i = ram_array_q_19;
// 03/22/05 VC: LEDA fix: Added default clause to case statement
    default                  : data_out2_i = ram_array_q_0;
    endcase
end


// 03/22/05 VC: LEDA fix: Change 0 to 16'd0
/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 16'd0;
	ram_array_q_1 <= #write_access_time 16'd0;
	ram_array_q_2 <= #write_access_time 16'd0; 
	ram_array_q_3 <= #write_access_time 16'd0; 
        ram_array_q_4 <= #write_access_time 16'd0;
        ram_array_q_5 <= #write_access_time 16'd0;
        ram_array_q_6 <= #write_access_time 16'd0;
        ram_array_q_7 <= #write_access_time 16'd0; 
        ram_array_q_8 <= #write_access_time 16'd0;
        ram_array_q_9 <= #write_access_time 16'd0;
        ram_array_q_10 <= #write_access_time 16'd0;
        ram_array_q_11 <= #write_access_time 16'd0; 
        ram_array_q_12 <= #write_access_time 16'd0; 
        ram_array_q_13 <= #write_access_time 16'd0; 
        ram_array_q_14 <= #write_access_time 16'd0; 
        ram_array_q_15 <= #write_access_time 16'd0; 
        ram_array_q_16 <= #write_access_time 16'd0; 
        ram_array_q_17 <= #write_access_time 16'd0; 
        ram_array_q_18 <= #write_access_time 16'd0; 
        ram_array_q_19 <= #write_access_time 16'd0; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
        ram_array_q_8 <= #write_access_time ram_array_d_8;
        ram_array_q_9 <= #write_access_time ram_array_d_9;
        ram_array_q_10 <= #write_access_time ram_array_d_10;
        ram_array_q_11 <= #write_access_time ram_array_d_11;
        ram_array_q_12 <= #write_access_time ram_array_d_12;
        ram_array_q_13 <= #write_access_time ram_array_d_13;
        ram_array_q_14 <= #write_access_time ram_array_d_14;
        ram_array_q_15 <= #write_access_time ram_array_d_15;
        ram_array_q_16 <= #write_access_time ram_array_d_16;
        ram_array_q_17 <= #write_access_time ram_array_d_17;
        ram_array_q_18 <= #write_access_time ram_array_d_18;
        ram_array_q_19 <= #write_access_time ram_array_d_19;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    data_reg_8          or
    data_reg_9          or
    data_reg_10         or
    data_reg_11         or
    data_reg_12         or
    data_reg_13         or
    data_reg_14         or
    data_reg_15         or
    data_reg_16         or
    data_reg_17         or
    data_reg_18         or
    data_reg_19         or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	or
    ram_array_q_8       or
    ram_array_q_9       or
    ram_array_q_10      or
    ram_array_q_11      or
    ram_array_q_12      or
    ram_array_q_13      or
    ram_array_q_14      or
    ram_array_q_15      or
    ram_array_q_16      or
    ram_array_q_17      or
    ram_array_q_18      or
    ram_array_q_19	)
begin
    if(we) begin
	ram_array_d_0 = data_reg_0;
	ram_array_d_1 = data_reg_1;
	ram_array_d_2 = data_reg_2;
	ram_array_d_3 = data_reg_3;
        ram_array_d_4 = data_reg_4;
        ram_array_d_5 = data_reg_5;
        ram_array_d_6 = data_reg_6;
        ram_array_d_7 = data_reg_7; 
        ram_array_d_8 = data_reg_8;
        ram_array_d_9 = data_reg_9;
        ram_array_d_10 = data_reg_10;
        ram_array_d_11 = data_reg_11; 
        ram_array_d_12 = data_reg_12; 
        ram_array_d_13 = data_reg_13; 
        ram_array_d_14 = data_reg_14; 
        ram_array_d_15 = data_reg_15; 
        ram_array_d_16 = data_reg_16; 
        ram_array_d_17 = data_reg_17; 
        ram_array_d_18 = data_reg_18; 
        ram_array_d_19 = data_reg_19; 
    end
    else begin
	ram_array_d_0 = ram_array_q_0;
	ram_array_d_1 = ram_array_q_1;
	ram_array_d_2 = ram_array_q_2;
	ram_array_d_3 = ram_array_q_3;
        ram_array_d_4 = ram_array_q_4;
        ram_array_d_5 = ram_array_q_5;
        ram_array_d_6 = ram_array_q_6;
        ram_array_d_7 = ram_array_q_7;
        ram_array_d_8 = ram_array_q_8;
        ram_array_d_9 = ram_array_q_9;
        ram_array_d_10 = ram_array_q_10;
        ram_array_d_11 = ram_array_q_11;
        ram_array_d_12 = ram_array_q_12;
        ram_array_d_13 = ram_array_q_13;
        ram_array_d_14 = ram_array_q_14;
        ram_array_d_15 = ram_array_q_15;
        ram_array_d_16 = ram_array_q_16;
        ram_array_d_17 = ram_array_q_17;
        ram_array_d_18 = ram_array_q_18;
        ram_array_d_19 = ram_array_q_19;
    end
end

endmodule

`timescale 1 ps / 1 ps

module arriaii_hssi_rx_digis_ram8x70_syn (
    rst_l, 
    clk,
    fifo_wr,
    data_in,
    fifo_re,
    data_out
    );

input 		rst_l;
input 		clk;
input 	[7:0]	fifo_wr;
input 	[69:0] 	data_in;
input 	[7:0] 	fifo_re;
output 	[69:0] 	data_out;

parameter read_access_time = 0;
parameter write_access_time = 0;
parameter ram_width = 70;

reg [ram_width-1:0] data_out_i;
reg [ram_width-1:0] ram_array_d_0, ram_array_d_1, ram_array_d_2, 
                    ram_array_d_3, ram_array_d_4, ram_array_d_5, 
                    ram_array_d_6, ram_array_d_7, 
 		    ram_array_q_0, ram_array_q_1, ram_array_q_2, 
                    ram_array_q_3, ram_array_q_4, ram_array_q_5, 
                    ram_array_q_6, ram_array_q_7;

wire [ram_width-1:0] data_reg_0, data_reg_1, data_reg_2, data_reg_3,
		     data_reg_4, data_reg_5, data_reg_6, data_reg_7;

wire 		we, re_l;

assign we = 1'b1;
assign re_l = 1'b0;

/* Modelling the read port */
/* Assuming address trigerred operation only */
//assignment
assign
    data_reg_0 = ( fifo_wr[0] == 1'b1 ) ? data_in : ram_array_q_0,
    data_reg_1 = ( fifo_wr[1] == 1'b1 ) ? data_in : ram_array_q_1,
    data_reg_2 = ( fifo_wr[2] == 1'b1 ) ? data_in : ram_array_q_2,
    data_reg_3 = ( fifo_wr[3] == 1'b1 ) ? data_in : ram_array_q_3,
    data_reg_4 = ( fifo_wr[4] == 1'b1 ) ? data_in : ram_array_q_4,
    data_reg_5 = ( fifo_wr[5] == 1'b1 ) ? data_in : ram_array_q_5,
    data_reg_6 = ( fifo_wr[6] == 1'b1 ) ? data_in : ram_array_q_6,
    data_reg_7 = ( fifo_wr[7] == 1'b1 ) ? data_in : ram_array_q_7;

assign  data_out = re_l ? 70'b0 : data_out_i;

always @(
    ram_array_q_0	or 
    ram_array_q_1	or 
    ram_array_q_2	or 
    ram_array_q_3	or 
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7       or 
    fifo_re		
    )
begin
    case ( fifo_re )  // synopsys parallel_case full_case
    8'b00000001 : data_out_i = ram_array_q_0;
    8'b00000010 : data_out_i = ram_array_q_1;
    8'b00000100 : data_out_i = ram_array_q_2;
    8'b00001000 : data_out_i = ram_array_q_3;
    8'b00010000 : data_out_i = ram_array_q_4;
    8'b00100000 : data_out_i = ram_array_q_5;
    8'b01000000 : data_out_i = ram_array_q_6;
    8'b10000000 : data_out_i = ram_array_q_7;
    default     : data_out_i = ram_array_q_0;
    endcase

end


/* Modelling the write port */
always @(posedge clk or negedge rst_l) 
begin
    if(~rst_l) begin
	ram_array_q_0 <= #write_access_time 70'h020000000000000000;
	ram_array_q_1 <= #write_access_time 70'h020000000000000000;
	ram_array_q_2 <= #write_access_time 70'h020000000000000000; 
	ram_array_q_3 <= #write_access_time 70'h020000000000000000; 
        ram_array_q_4 <= #write_access_time 70'h020000000000000000;
        ram_array_q_5 <= #write_access_time 70'h020000000000000000;
        ram_array_q_6 <= #write_access_time 70'h020000000000000000;
        ram_array_q_7 <= #write_access_time 70'h020000000000000000; 
    end
    else begin
	ram_array_q_0 <= #write_access_time ram_array_d_0;
	ram_array_q_1 <= #write_access_time ram_array_d_1;
	ram_array_q_2 <= #write_access_time ram_array_d_2;
	ram_array_q_3 <= #write_access_time ram_array_d_3;
        ram_array_q_4 <= #write_access_time ram_array_d_4;
        ram_array_q_5 <= #write_access_time ram_array_d_5;
        ram_array_q_6 <= #write_access_time ram_array_d_6;
        ram_array_q_7 <= #write_access_time ram_array_d_7;
    end
end
         
always @( 
    we 			or 
    data_reg_0 		or 
    data_reg_1 		or 
    data_reg_2		or 
    data_reg_3		or
    data_reg_4          or
    data_reg_5          or
    data_reg_6          or
    data_reg_7          or
    ram_array_q_0 	or 
    ram_array_q_1	or
    ram_array_q_2	or
    ram_array_q_3	or
    ram_array_q_4       or
    ram_array_q_5       or
    ram_array_q_6       or
    ram_array_q_7	
       )
begin
    if(we) begin
	ram_array_d_0 =  data_reg_0;
	ram_array_d_1 =  data_reg_1;
	ram_array_d_2 =  data_reg_2;
	ram_array_d_3 =  data_reg_3;
        ram_array_d_4 =  data_reg_4;
        ram_array_d_5 =  data_reg_5;
        ram_array_d_6 =  data_reg_6;
        ram_array_d_7 =  data_reg_7; 
    end
    else begin
	ram_array_d_0 =  ram_array_q_0;
	ram_array_d_1 =  ram_array_q_1;
	ram_array_d_2 =  ram_array_q_2;
	ram_array_d_3 =  ram_array_q_3;
        ram_array_d_4 =  ram_array_q_4;
        ram_array_d_5 =  ram_array_q_5;
        ram_array_d_6 =  ram_array_q_6;
        ram_array_d_7 =  ram_array_q_7;
    end
end

endmodule

`timescale 1 ps / 1 ps

module arriaii_hssi_rx_digis_rxclk_gating (
		     select_n,
		     clk1,
		     clk2,
		     clk1out_n,
		     clk2out_n
		     );
   
   input select_n;
   input clk1;
   input clk2;
   output clk1out_n;
   output clk2out_n;
   
   assign clk1out_n = ~(select_n | clk1);
   assign clk2out_n = ~(~select_n | clk2);
   
endmodule // rxclk_gating


`timescale 1 ns /1 ps

module arriaii_hssi_rx_digi_rxclk_ctl (pld_rx_clk,	
		  rcvd_clk_pma,	          
    		  rcvd_clk0_pma,          
		  tx_pma_clk,	          
		  refclk_pma,             
    		  fref,                 
    		  clklow,
		  scan_mode,              
    		  gen2ngen1,              
    		  gen2ngen1_bundle,       
    		  rx_div2_sync_centrl,    
    		  rx_div2_sync_quad_up,   
    		  rx_div2_sync_quad_down, 
		  rrcvd_clk_sel,
     		  rclk_1_sel,
     		  rclk_2_sel,
		  rrx_rd_clk_sel,         
		  rxrst,                  
		  rindv_rx,               
    		  rdwidth_rx,             
		  rfreerun_rx,            
    		  rauto_speed_ena,        
    		  rfreq_sel,              
    		  rrxpcsclkpwdn,          
    		  rmaster_rx,             
    		  rmaster_up_rx,          
		  rself_sw_en_rx,         
    		  fref_muxed,
    		  clklow_muxed,       
		  rcvd_clk,
		  clk_1_b,
		  clk_2_b,
		  rx_wr_clk,              
		  rx_rd_clk,              
		  rx_clk,                 
		  rcvd_clk_pma_b,         
    		  clk_2_b_raw,            
    		  rx_wr_clk_raw,          
		  rx_rd_clk_raw,          
		  rx_div2_sync_out 
                  );

   // Clock Inputs
   input          pld_rx_clk;	          // PLD clock from PLD clock trees
   input          rcvd_clk_pma;	          // local recovered clock
   input 	  rcvd_clk0_pma;          // channel zero recovered clock
   input          tx_pma_clk;	          // local TX PMA clock
   input          refclk_pma;             // Quad based clk from TXPLL
   input 	  fref;                 
   input 	  clklow;

   // Control Inputs
   input          scan_mode;              // Scan mode enable signal
   input          rxrst;                  // This is the soft_reset for the RX_PCS

   // New Control Inputs
   input 	  gen2ngen1;              // from PMA for PCIexp Gen1/Gen2 datawidth scaling
   input 	  gen2ngen1_bundle;       // from PMA for PCIexp Gen1/Gen2 datawidth scaling in x4 and x8 
   input 	  rx_div2_sync_centrl;    // divided clock from the central channel (x2, x4 mode)
   input 	  rx_div2_sync_quad_up;   // divided clock from quad above (> x4 mode)
   input 	  rx_div2_sync_quad_down; // divided clock from quad below (> x4 mode)
   
   // MDIO Inputs
   input [1:0] 	  rrcvd_clk_sel;
   input [1:0] 	  rclk_1_sel;
   input [1:0] 	  rclk_2_sel;
   input          rrx_rd_clk_sel;         // Select clock for rx ph comp fifo read side
   input          rindv_rx;               // Select between XAUI mode or indiv  channel mode
   input 	  rdwidth_rx;             // divide by 1 or 2 before feeding to FIFO write clock
   input          rfreerun_rx;            // Select whether divider is permamently enabled (free -running) or divider should be enabled / reset by RX PCS reset

   // New MDIO Inputs
   input 	  rauto_speed_ena;        // auto speed negotiation enable
   input 	  rfreq_sel;              // freq scaling or data width scaling
   input 	  rrxpcsclkpwdn;          // RX clocking power down enable
   input 	  rmaster_rx;             // New bundle mode MDIO, selects master quad
   input 	  rmaster_up_rx;          // New bundle mode MDIO, selects master quad
   input          rself_sw_en_rx;         // enables self-switch to have correct /2 clock in all quads in bundle mode
   
   // Removed Inputs
   //    input          rphfifo_master_sel_rx;  // RX Phase comp. FIFO rx_div2_sync selection CRAM
   //    input          rx_div2_sync_in_ch0;    // Connect from channel zero rx_div2_sync_out
   //    input          rx_div2_sync_in_q0_ch0; // Connect from channel zero rx_div2_sync_out of Master Quad

 
   // Clock Outputs with CTS
   output 	  fref_muxed;
   output 	  clklow_muxed;       
   output         rcvd_clk;
   output         clk_1_b;
   output         clk_2_b;
   output         rx_wr_clk;              // drives the rx ph comp fifo write clock tree
   output         rx_rd_clk;              // drives the rx ph comp fifo read clock tree

   // Clock Outputs to PLD, no CTS
   output         rx_clk;                 // drives the PLD clock tree in x1 mode, logically same as rx_wr_clk
   output         rcvd_clk_pma_b;         // debug output clock to PLD

   // New Clock Outputs with CTS
   output 	  clk_2_b_raw;            // same as clk_2_b, but with no clock gating
   output 	  rx_wr_clk_raw;          // same as rx_wr_clk, but with no clock gating
   output         rx_rd_clk_raw;          // same as rx_rd_clk, but with no clock gating

   // Control Outputs
   output         rx_div2_sync_out;       // inverted /2 clock.  not used w/new bundling scheme. (left for safety)

   
   reg 		  rx_clk_2_by2;
   reg 		  gen2ngen1_local_sync;
   reg [1:0] 	  counter;
      
   wire 	  rx_div2_sync;
   wire 	  rx_div2_sync_out;
   wire 	  rx_rst_n;
   wire [1:0] 	  rrcvd_clk_sel_int;
   wire [1:0] 	  rclk_1_sel_int;
   wire [1:0] 	  rclk_2_sel_int;
   wire 	  dynamic_div2ndiv1;
   wire 	  gen2ngen1_local;
   wire 	  fref_muxed;
   wire 	  clklow_muxed;
   wire 	  rrxpcsclkpwdn_nscan;
   wire 	  rx_div2_this_quad;
   wire           rx_div2_this_channel;
   wire 	  rx_div2_other_quad;
   wire 	  force_master;

   wire 	  select_div1_n;
   wire 	  clk1out_n;
   wire 	  clk2out_n;
   
// shawn initial begin ------
initial begin
		rx_clk_2_by2 = 1'b1;
end             
// shawn initial end   ------
   
   // Old bundle logic:
   // Select between the local synchronization signal or the global synchronization signal
   //assign rx_div2_sync = rindv_rx ? rx_div2_sync_out : rx_div2_sync_in;
   // assign 	  rx_div2_sync = (rphfifo_master_sel_rx == 1'b0) ? rx_div2_sync_in_q0_ch0 :
   // 				 (rindv_rx == 1'b0) ? rx_div2_sync_in_ch0 : 
   // 				 (rauto_speed_ena & ~rfreq_sel) ? (rx_div2_sync_out | ~gen2ngen1_local_sync) : rx_div2_sync_out;

   always @(posedge rxrst or posedge clk_2_b_raw)
     begin
	if (rxrst)
	  counter <= #1 2'b00;
	else if ((rauto_speed_ena & ~rfreq_sel & rself_sw_en_rx) & ~force_master)
	  counter <= #1 counter + 1'b1;
     end

   assign force_master = ((counter == 2'b11) & (rauto_speed_ena & ~rfreq_sel & rself_sw_en_rx)) ? 1'b1 : 1'b0;
      
   assign rx_div2_sync = (rmaster_rx | force_master) ? rx_div2_this_quad : rx_div2_other_quad;
   assign rx_div2_this_quad = (rindv_rx | force_master) ? rx_div2_this_channel : rx_div2_sync_centrl;
   assign rx_div2_this_channel = (rauto_speed_ena & ~rfreq_sel) ? (rx_div2_sync_out | ~gen2ngen1_local_sync) : rx_div2_sync_out;
   assign rx_div2_other_quad = rmaster_up_rx ? rx_div2_sync_quad_up : rx_div2_sync_quad_down;
   
   assign gen2ngen1_local = (rindv_rx == 1'b0) ? gen2ngen1_bundle : gen2ngen1;
   

   always @(posedge rxrst or posedge clk_2_b_raw)
     begin
	if (rxrst)
	  gen2ngen1_local_sync <= #1 1'b0;
	else
	  gen2ngen1_local_sync <= #1 gen2ngen1_local;
     end
   
   assign dynamic_div2ndiv1 = rdwidth_rx | (gen2ngen1_local_sync & rauto_speed_ena & ~rfreq_sel);


   // Reset for Divide-by-2 FF and synchronization FF's for clock gating
   assign rx_rst_n = (rfreerun_rx) ? 1'b1 : ~rxrst;

   assign rrxpcsclkpwdn_nscan = rrxpcsclkpwdn & ~scan_mode;
   
  
   
   // clocks are assigned below in the order in which they appear in the out flowing data path
   // RCVD_CLK selection
   assign rrcvd_clk_sel_int = (scan_mode) ? 2'b01 : rrcvd_clk_sel;
   assign rcvd_clk = 	rrxpcsclkpwdn_nscan ? 1'b1 :
	                (rrcvd_clk_sel_int == 2'b00) ? rcvd_clk_pma  : 
	                (rrcvd_clk_sel_int == 2'b01) ? refclk_pma : 
	                (rrcvd_clk_sel_int == 2'b10) ? tx_pma_clk : 
	                (rrcvd_clk_sel_int == 2'b11) ? rcvd_clk_pma : rcvd_clk_pma; 
   
   // CLK_1 seleciton
   assign rclk_1_sel_int = (scan_mode) ? 2'b01 : rclk_1_sel;
   assign clk_1_b =     rrxpcsclkpwdn_nscan ? 1'b1 :
 	                (rclk_1_sel_int == 2'b00) ? rcvd_clk_pma  : 
	                (rclk_1_sel_int == 2'b01) ? refclk_pma : 
	                (rclk_1_sel_int == 2'b10) ? tx_pma_clk : 
	                (rclk_1_sel_int == 2'b11) ? rcvd_clk0_pma : rcvd_clk_pma; 
   
   // CLK_2 selection
   assign rclk_2_sel_int = (scan_mode) ? 2'b10 : rclk_2_sel;
   assign clk_2_b_raw =	(rclk_2_sel_int == 2'b00) ? rcvd_clk_pma : 
	                (rclk_2_sel_int == 2'b01) ? tx_pma_clk : 
	                (rclk_2_sel_int == 2'b10) ? refclk_pma : rcvd_clk_pma; 
   //change made for S3GX to remove pld_rx_clk from mux input 
   //(rclk_2_sel_int == 2'b10) ? refclk_pma : 
   //(rclk_2_sel_int == 2'b11) ? pld_rx_clk : rcvd_clk_pma;

   assign clk_2_b = rrxpcsclkpwdn_nscan ? 1'b1 : clk_2_b_raw;
   

   // This register is used to generate divided by two clock. Div by 2 clock starts off high after reset
   // No #1 on this FF as it generates a clock
   always @(negedge rx_rst_n or posedge clk_2_b_raw)
     begin
	if (~rx_rst_n)
	  rx_clk_2_by2 <= 1'b1;
	else
	  rx_clk_2_by2 <= rx_div2_sync;
     end
      
   assign rx_div2_sync_out = ~rx_clk_2_by2;

      

   // RX FIFO write clock: could be fast or divided by 2
   // old code:
   // assign rx_wr_clk = ((rdwidth_rx == 1'b0) || scan_mode) ? clk_2_b_raw : rx_clk_2_by2;
   
   assign select_div1_n = ~(scan_mode | ~dynamic_div2ndiv1);
   
   arriaii_hssi_rx_digis_rxclk_gating rxclk_gating (
			      .select_n(select_div1_n),
			      .clk1(clk_2_b_raw),
			      .clk2(rx_clk_2_by2),
			      .clk1out_n(clk1out_n),
			      .clk2out_n(clk2out_n)
			      );
   
   assign rx_wr_clk_raw = ~(clk1out_n | clk2out_n);

   
   assign rx_wr_clk = rrxpcsclkpwdn_nscan ? 1'b1 : rx_wr_clk_raw;

      
   // RX FIFO read clock
   assign rx_rd_clk_raw = (scan_mode | (rrx_rd_clk_sel == 1'b0)) ? rx_wr_clk_raw : pld_rx_clk;
   assign rx_rd_clk = rrxpcsclkpwdn_nscan ? 1'b1 : rx_rd_clk_raw;

   
   // RX clock out
   assign rx_clk = rx_wr_clk; // drives PLD clock tree
   
   // Recovered clock for debugging
   assign rcvd_clk_pma_b = rcvd_clk_pma; // Goes out to PLD as debug clock. This clock may or may not be routed out to PLD fabric. TBD

   
   assign fref_muxed = scan_mode ? refclk_pma : rrxpcsclkpwdn ? 1'b1 : fref;
   assign clklow_muxed = scan_mode ? refclk_pma : rrxpcsclkpwdn ? 1'b1 : clklow;
   
   
endmodule // rxclk_ctl

//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 74 mux21 44 oper_add 1 oper_decoder 1 oper_mux 4 
`timescale 1 ps / 1 ps
module  arriaii_hssi_rx_digi_auto_speed_neg
	( 
	config_sel,
	config_sel_centrl,
	config_sel_quad_down,
	config_sel_quad_up,
	cs,
	dis_pc_byte,
	gen2ngen1,
	pcie_switch,
	rate,
	rauto_deassert_pc_rst_cnt,
	rauto_pc_en_cnt,
	rauto_speed_ena,
	refclk,
	reset_pc_ptrs,
	rindv_rx,
	rmaster_rx,
	rmaster_up_rx,
	rphfifo_regmode_rx,
	rpma_done_count,
	rwait_for_phfifo_cnt,
	rxpcs_rst_int,
	singleorbundle,
	speed_change) /* synthesis synthesis_clearbox=1 */;
	output   config_sel;
	input   config_sel_centrl;
	input   config_sel_quad_down;
	input   config_sel_quad_up;
	output   [3:0]  cs;
	output   dis_pc_byte;
	input   gen2ngen1;
	output   pcie_switch;
	input   rate;
	input   [3:0]  rauto_deassert_pc_rst_cnt;
	input   [4:0]  rauto_pc_en_cnt;
	input   rauto_speed_ena;
	input   refclk;
	output   reset_pc_ptrs;
	input   rindv_rx;
	input   rmaster_rx;
	input   rmaster_up_rx;
	input   rphfifo_regmode_rx;
	input   [17:0]  rpma_done_count;
	input   [5:0]  rwait_for_phfifo_cnt;
	input   rxpcs_rst_int;
	input   singleorbundle;
	output   speed_change;

	reg	n000l43;
	reg	n000l44;
	reg	n00ii41;
	reg	n00ii42;
	reg	n00il39;
	reg	n00il40;
	reg	n00ll37;
	reg	n00ll38;
	reg	n00Ol35;
	reg	n00Ol36;
	reg	n0i0i31;
	reg	n0i0i32;
	reg	n0i0O29;
	reg	n0i0O30;
	reg	n0i1i33;
	reg	n0i1i34;
	reg	n0iil27;
	reg	n0iil28;
	reg	n0ili25;
	reg	n0ili26;
	reg	n0ilO23;
	reg	n0ilO24;
	reg	n0iOl21;
	reg	n0iOl22;
	reg	n0l0i17;
	reg	n0l0i18;
	reg	n0l0O15;
	reg	n0l0O16;
	reg	n0l1i19;
	reg	n0l1i20;
	reg	n0lli13;
	reg	n0lli14;
	reg	n0lOO11;
	reg	n0lOO12;
	reg	n0O0i3;
	reg	n0O0i4;
	reg	n0O0l1;
	reg	n0O0l2;
	reg	n0O1i10;
	reg	n0O1i9;
	reg	n0O1l7;
	reg	n0O1l8;
	reg	n0O1O5;
	reg	n0O1O6;
	reg	n11l;
	reg	n11i_clk_prev;
	wire	wire_n11i_PRN;
	wire	wire_n11i_ENA;
	reg	n00i;
	reg	n00l;
	reg	n00O;
	reg	n01i;
	reg	n01l;
	reg	n01O;
	reg	n0ii;
	reg	n0il;
	reg	n0iO;
	reg	n0li;
	reg	n0ll;
	reg	n0lO;
	reg	n0Oi;
	reg	n0Ol;
	reg	n0OO;
	reg	n10i;
	reg	n10l;
	reg	n11O;
	reg	n1il;
	reg	n1iO;
	reg	n1li;
	reg	n1Ol;
	reg	n1OO;
	reg	ni1i;
	reg	ni1O;
	reg	nll0i;
	reg	nlOOi;
	reg	nlOOl;
	reg	nlOOO;
	wire	wire_ni1l_CLRN;
	wire	wire_n1ll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niil_dataout;
	wire	wire_niiO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nill_dataout;
	wire	wire_nilO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nllli_dataout;
	wire	wire_nllll_dataout;
	wire	wire_nlllO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllOi_dataout;
	wire	wire_nllOl_dataout;
	wire	wire_nllOO_dataout;
	wire	wire_nlO0i_dataout;
	wire	wire_nlO0l_dataout;
	wire	wire_nlO0O_dataout;
	wire	wire_nlO1i_dataout;
	wire	wire_nlO1l_dataout;
	wire	wire_nlO1O_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOii_dataout;
	wire	wire_nlOil_dataout;
	wire	wire_nlOiO_dataout;
	wire	wire_nlOli_dataout;
	wire  [18:0]   wire_nO_o;
	wire  [15:0]   wire_nllii_o;
	wire  wire_nliOO_o;
	wire  wire_nll1i_o;
	wire  wire_nll1l_o;
	wire  wire_nll1O_o;
	wire  n000i;
	wire  n001l;
	wire  n001O;
	wire  n00li;
	wire  n00lO;
	wire  n00Oi;
	wire  n0i1O;
	wire  n0l1O;
	wire  n0lil;
	wire  n0liO;
	wire  n0llO;

	initial
		n000l43 = 0;
	always @ ( posedge refclk)
		  n000l43 <= n000l44;
	event n000l43_event;
	initial
		#1 ->n000l43_event;
	always @(n000l43_event)
		n000l43 <= {1{1'b1}};
	initial
		n000l44 = 0;
	always @ ( posedge refclk)
		  n000l44 <= n000l43;
	initial
		n00ii41 = 0;
	always @ ( posedge refclk)
		  n00ii41 <= n00ii42;
	event n00ii41_event;
	initial
		#1 ->n00ii41_event;
	always @(n00ii41_event)
		n00ii41 <= {1{1'b1}};
	initial
		n00ii42 = 0;
	always @ ( posedge refclk)
		  n00ii42 <= n00ii41;
	initial
		n00il39 = 0;
	always @ ( posedge refclk)
		  n00il39 <= n00il40;
	event n00il39_event;
	initial
		#1 ->n00il39_event;
	always @(n00il39_event)
		n00il39 <= {1{1'b1}};
	initial
		n00il40 = 0;
	always @ ( posedge refclk)
		  n00il40 <= n00il39;
	initial
		n00ll37 = 0;
	always @ ( posedge refclk)
		  n00ll37 <= n00ll38;
	event n00ll37_event;
	initial
		#1 ->n00ll37_event;
	always @(n00ll37_event)
		n00ll37 <= {1{1'b1}};
	initial
		n00ll38 = 0;
	always @ ( posedge refclk)
		  n00ll38 <= n00ll37;
	initial
		n00Ol35 = 0;
	always @ ( posedge refclk)
		  n00Ol35 <= n00Ol36;
	event n00Ol35_event;
	initial
		#1 ->n00Ol35_event;
	always @(n00Ol35_event)
		n00Ol35 <= {1{1'b1}};
	initial
		n00Ol36 = 0;
	always @ ( posedge refclk)
		  n00Ol36 <= n00Ol35;
	initial
		n0i0i31 = 0;
	always @ ( posedge refclk)
		  n0i0i31 <= n0i0i32;
	event n0i0i31_event;
	initial
		#1 ->n0i0i31_event;
	always @(n0i0i31_event)
		n0i0i31 <= {1{1'b1}};
	initial
		n0i0i32 = 0;
	always @ ( posedge refclk)
		  n0i0i32 <= n0i0i31;
	initial
		n0i0O29 = 0;
	always @ ( posedge refclk)
		  n0i0O29 <= n0i0O30;
	event n0i0O29_event;
	initial
		#1 ->n0i0O29_event;
	always @(n0i0O29_event)
		n0i0O29 <= {1{1'b1}};
	initial
		n0i0O30 = 0;
	always @ ( posedge refclk)
		  n0i0O30 <= n0i0O29;
	initial
		n0i1i33 = 0;
	always @ ( posedge refclk)
		  n0i1i33 <= n0i1i34;
	event n0i1i33_event;
	initial
		#1 ->n0i1i33_event;
	always @(n0i1i33_event)
		n0i1i33 <= {1{1'b1}};
	initial
		n0i1i34 = 0;
	always @ ( posedge refclk)
		  n0i1i34 <= n0i1i33;
	initial
		n0iil27 = 0;
	always @ ( posedge refclk)
		  n0iil27 <= n0iil28;
	event n0iil27_event;
	initial
		#1 ->n0iil27_event;
	always @(n0iil27_event)
		n0iil27 <= {1{1'b1}};
	initial
		n0iil28 = 0;
	always @ ( posedge refclk)
		  n0iil28 <= n0iil27;
	initial
		n0ili25 = 0;
	always @ ( posedge refclk)
		  n0ili25 <= n0ili26;
	event n0ili25_event;
	initial
		#1 ->n0ili25_event;
	always @(n0ili25_event)
		n0ili25 <= {1{1'b1}};
	initial
		n0ili26 = 0;
	always @ ( posedge refclk)
		  n0ili26 <= n0ili25;
	initial
		n0ilO23 = 0;
	always @ ( posedge refclk)
		  n0ilO23 <= n0ilO24;
	event n0ilO23_event;
	initial
		#1 ->n0ilO23_event;
	always @(n0ilO23_event)
		n0ilO23 <= {1{1'b1}};
	initial
		n0ilO24 = 0;
	always @ ( posedge refclk)
		  n0ilO24 <= n0ilO23;
	initial
		n0iOl21 = 0;
	always @ ( posedge refclk)
		  n0iOl21 <= n0iOl22;
	event n0iOl21_event;
	initial
		#1 ->n0iOl21_event;
	always @(n0iOl21_event)
		n0iOl21 <= {1{1'b1}};
	initial
		n0iOl22 = 0;
	always @ ( posedge refclk)
		  n0iOl22 <= n0iOl21;
	initial
		n0l0i17 = 0;
	always @ ( posedge refclk)
		  n0l0i17 <= n0l0i18;
	event n0l0i17_event;
	initial
		#1 ->n0l0i17_event;
	always @(n0l0i17_event)
		n0l0i17 <= {1{1'b1}};
	initial
		n0l0i18 = 0;
	always @ ( posedge refclk)
		  n0l0i18 <= n0l0i17;
	initial
		n0l0O15 = 0;
	always @ ( posedge refclk)
		  n0l0O15 <= n0l0O16;
	event n0l0O15_event;
	initial
		#1 ->n0l0O15_event;
	always @(n0l0O15_event)
		n0l0O15 <= {1{1'b1}};
	initial
		n0l0O16 = 0;
	always @ ( posedge refclk)
		  n0l0O16 <= n0l0O15;
	initial
		n0l1i19 = 0;
	always @ ( posedge refclk)
		  n0l1i19 <= n0l1i20;
	event n0l1i19_event;
	initial
		#1 ->n0l1i19_event;
	always @(n0l1i19_event)
		n0l1i19 <= {1{1'b1}};
	initial
		n0l1i20 = 0;
	always @ ( posedge refclk)
		  n0l1i20 <= n0l1i19;
	initial
		n0lli13 = 0;
	always @ ( posedge refclk)
		  n0lli13 <= n0lli14;
	event n0lli13_event;
	initial
		#1 ->n0lli13_event;
	always @(n0lli13_event)
		n0lli13 <= {1{1'b1}};
	initial
		n0lli14 = 0;
	always @ ( posedge refclk)
		  n0lli14 <= n0lli13;
	initial
		n0lOO11 = 0;
	always @ ( posedge refclk)
		  n0lOO11 <= n0lOO12;
	event n0lOO11_event;
	initial
		#1 ->n0lOO11_event;
	always @(n0lOO11_event)
		n0lOO11 <= {1{1'b1}};
	initial
		n0lOO12 = 0;
	always @ ( posedge refclk)
		  n0lOO12 <= n0lOO11;
	initial
		n0O0i3 = 0;
	always @ ( posedge refclk)
		  n0O0i3 <= n0O0i4;
	event n0O0i3_event;
	initial
		#1 ->n0O0i3_event;
	always @(n0O0i3_event)
		n0O0i3 <= {1{1'b1}};
	initial
		n0O0i4 = 0;
	always @ ( posedge refclk)
		  n0O0i4 <= n0O0i3;
	initial
		n0O0l1 = 0;
	always @ ( posedge refclk)
		  n0O0l1 <= n0O0l2;
	event n0O0l1_event;
	initial
		#1 ->n0O0l1_event;
	always @(n0O0l1_event)
		n0O0l1 <= {1{1'b1}};
	initial
		n0O0l2 = 0;
	always @ ( posedge refclk)
		  n0O0l2 <= n0O0l1;
	initial
		n0O1i10 = 0;
	always @ ( posedge refclk)
		  n0O1i10 <= n0O1i9;
	initial
		n0O1i9 = 0;
	always @ ( posedge refclk)
		  n0O1i9 <= n0O1i10;
	event n0O1i9_event;
	initial
		#1 ->n0O1i9_event;
	always @(n0O1i9_event)
		n0O1i9 <= {1{1'b1}};
	initial
		n0O1l7 = 0;
	always @ ( posedge refclk)
		  n0O1l7 <= n0O1l8;
	event n0O1l7_event;
	initial
		#1 ->n0O1l7_event;
	always @(n0O1l7_event)
		n0O1l7 <= {1{1'b1}};
	initial
		n0O1l8 = 0;
	always @ ( posedge refclk)
		  n0O1l8 <= n0O1l7;
	initial
		n0O1O5 = 0;
	always @ ( posedge refclk)
		  n0O1O5 <= n0O1O6;
	event n0O1O5_event;
	initial
		#1 ->n0O1O5_event;
	always @(n0O1O5_event)
		n0O1O5 <= {1{1'b1}};
	initial
		n0O1O6 = 0;
	always @ ( posedge refclk)
		  n0O1O6 <= n0O1O5;
	initial
	begin
		n11l = 0;
	end
	always @ (refclk or wire_n11i_PRN or rxpcs_rst_int)
	begin
		if (wire_n11i_PRN == 1'b0) 
		begin
			n11l <= 1;
		end
		else if  (rxpcs_rst_int == 1'b1) 
		begin
			n11l <= 0;
		end
		else if  (wire_n11i_ENA == 1'b1) 
		if (refclk != n11i_clk_prev && refclk == 1'b1) 
		begin
			n11l <= n1il;
		end
		n11i_clk_prev <= refclk;
	end
	assign
		wire_n11i_ENA = wire_nllii_o[3],
		wire_n11i_PRN = (n00ii42 ^ n00ii41);
	initial
	begin
		n00i = 0;
		n00l = 0;
		n00O = 0;
		n01i = 0;
		n01l = 0;
		n01O = 0;
		n0ii = 0;
		n0il = 0;
		n0iO = 0;
		n0li = 0;
		n0ll = 0;
		n0lO = 0;
		n0Oi = 0;
		n0Ol = 0;
		n0OO = 0;
		n10i = 0;
		n10l = 0;
		n11O = 0;
		n1il = 0;
		n1iO = 0;
		n1li = 0;
		n1Ol = 0;
		n1OO = 0;
		ni1i = 0;
		ni1O = 0;
		nll0i = 0;
		nlOOi = 0;
		nlOOl = 0;
		nlOOO = 0;
	end
	always @ ( posedge refclk or  negedge wire_ni1l_CLRN)
	begin
		if (wire_ni1l_CLRN == 1'b0) 
		begin
			n00i <= 0;
			n00l <= 0;
			n00O <= 0;
			n01i <= 0;
			n01l <= 0;
			n01O <= 0;
			n0ii <= 0;
			n0il <= 0;
			n0iO <= 0;
			n0li <= 0;
			n0ll <= 0;
			n0lO <= 0;
			n0Oi <= 0;
			n0Ol <= 0;
			n0OO <= 0;
			n10i <= 0;
			n10l <= 0;
			n11O <= 0;
			n1il <= 0;
			n1iO <= 0;
			n1li <= 0;
			n1Ol <= 0;
			n1OO <= 0;
			ni1i <= 0;
			ni1O <= 0;
			nll0i <= 0;
			nlOOi <= 0;
			nlOOl <= 0;
			nlOOO <= 0;
		end
		else 
		begin
			n00i <= wire_nili_dataout;
			n00l <= wire_nill_dataout;
			n00O <= wire_nilO_dataout;
			n01i <= wire_niii_dataout;
			n01l <= wire_niil_dataout;
			n01O <= wire_niiO_dataout;
			n0ii <= wire_niOi_dataout;
			n0il <= wire_niOl_dataout;
			n0iO <= wire_niOO_dataout;
			n0li <= wire_nl1i_dataout;
			n0ll <= wire_nl1l_dataout;
			n0lO <= wire_nl1O_dataout;
			n0Oi <= wire_nl0i_dataout;
			n0Ol <= wire_nl0l_dataout;
			n0OO <= wire_nl0O_dataout;
			n10i <= gen2ngen1;
			n10l <= n1il;
			n11O <= ((n10i ^ gen2ngen1) ^ (~ (n00il40 ^ n00il39)));
			n1il <= n1iO;
			n1iO <= rate;
			n1li <= wire_ni0i_dataout;
			n1Ol <= wire_ni0l_dataout;
			n1OO <= wire_ni0O_dataout;
			ni1i <= wire_nlii_dataout;
			ni1O <= wire_nlil_dataout;
			nll0i <= wire_nliOO_o;
			nlOOi <= wire_nll1i_o;
			nlOOl <= wire_nll1l_o;
			nlOOO <= wire_nll1O_o;
		end
	end
	assign
		wire_ni1l_CLRN = ((n00ll38 ^ n00ll37) & (~ rxpcs_rst_int));
	assign		wire_n1ll_dataout = (rmaster_rx === 1'b1) ? wire_n1Oi_dataout : wire_n1lO_dataout;
	assign		wire_n1lO_dataout = (rmaster_up_rx === 1'b1) ? config_sel_quad_up : config_sel_quad_down;
	assign		wire_n1Oi_dataout = (rindv_rx === 1'b1) ? n11l : config_sel_centrl;
	and(wire_ni0i_dataout, wire_nliO_dataout, ~((~ n00lO)));
	and(wire_ni0l_dataout, wire_nO_o[0], ~((~ n00lO)));
	and(wire_ni0O_dataout, wire_nO_o[1], ~((~ n00lO)));
	and(wire_niii_dataout, wire_nO_o[2], ~((~ n00lO)));
	and(wire_niil_dataout, wire_nO_o[3], ~((~ n00lO)));
	and(wire_niiO_dataout, wire_nO_o[4], ~((~ n00lO)));
	and(wire_nili_dataout, wire_nO_o[5], ~((~ n00lO)));
	and(wire_nill_dataout, wire_nO_o[6], ~((~ n00lO)));
	and(wire_nilO_dataout, wire_nO_o[7], ~((~ n00lO)));
	and(wire_niOi_dataout, wire_nO_o[8], ~((~ n00lO)));
	and(wire_niOl_dataout, wire_nO_o[9], ~((~ n00lO)));
	and(wire_niOO_dataout, wire_nO_o[10], ~((~ n00lO)));
	and(wire_nl0i_dataout, wire_nO_o[14], ~((~ n00lO)));
	and(wire_nl0l_dataout, wire_nO_o[15], ~((~ n00lO)));
	and(wire_nl0O_dataout, wire_nO_o[16], ~((~ n00lO)));
	and(wire_nl1i_dataout, wire_nO_o[11], ~((~ n00lO)));
	and(wire_nl1l_dataout, wire_nO_o[12], ~((~ n00lO)));
	and(wire_nl1O_dataout, wire_nO_o[13], ~((~ n00lO)));
	and(wire_nlii_dataout, wire_nO_o[17], ~((~ n00lO)));
	and(wire_nlil_dataout, wire_nO_o[18], ~((~ n00lO)));
	or(wire_nliO_dataout, wire_nlli_dataout, n1li);
	assign		wire_nlli_dataout = (wire_nllii_o[5] === 1'b1) ? (((((gen2ngen1 & n0i1O) & (n0i1i34 ^ n0i1i33)) & n1Ol) & (n00Ol36 ^ n00Ol35)) | ((~ gen2ngen1) & n00Oi)) : wire_nlll_dataout;
	assign		wire_nlll_dataout = (wire_nllii_o[7] === 1'b1) ? ((((gen2ngen1 & (((((~ ((n1OO ^ rauto_deassert_pc_rst_cnt[0]) ^ (~ (n0l1i20 ^ n0l1i19)))) & (~ (n01i ^ rauto_deassert_pc_rst_cnt[1]))) & (~ ((n01l ^ rauto_deassert_pc_rst_cnt[2]) ^ (~ (n0iOl22 ^ n0iOl21))))) & (~ ((n01O ^ rauto_deassert_pc_rst_cnt[3]) ^ (~ (n0ilO24 ^ n0ilO23))))) & (n0ili26 ^ n0ili25))) & n1Ol) & (n0iil28 ^ n0iil27)) | ((~ gen2ngen1) & (((((~ (n1Ol ^ rauto_deassert_pc_rst_cnt[0])) & (~ ((n1OO ^ rauto_deassert_pc_rst_cnt[1]) ^ (~ (n0i0O30 ^ n0i0O29))))) & (~ (n01i ^ rauto_deassert_pc_rst_cnt[2]))) & (~ (n01l ^ rauto_deassert_pc_rst_cnt[3]))) & (n0i0i32 ^ n0i0i31)))) : wire_nllO_dataout;
	and(wire_nllli_dataout, nll0i, ~(n1li));
	or(wire_nllll_dataout, nlOOi, n1li);
	and(wire_nlllO_dataout, nlOOl, ~(n1li));
	assign		wire_nllO_dataout = (wire_nllii_o[9] === 1'b1) ? (((((gen2ngen1 & n0lil) & (n0l0O16 ^ n0l0O15)) & n1Ol) & (n0l0i18 ^ n0l0i17)) | ((~ gen2ngen1) & n0l1O)) : wire_nlOi_dataout;
	or(wire_nllOi_dataout, nlOOO, n1li);
	and(wire_nllOl_dataout, nlOOi, ~(n1li));
	assign		wire_nllOO_dataout = (n1li === 1'b1) ? (~ rphfifo_regmode_rx) : nlOOl;
	or(wire_nlO0i_dataout, nlOOl, n11O);
	and(wire_nlO0l_dataout, nlOOO, ~(n11O));
	and(wire_nlO0O_dataout, nlOOO, ~(n1li));
	assign		wire_nlO1i_dataout = (n1li === 1'b1) ? rphfifo_regmode_rx : nlOOO;
	or(wire_nlO1l_dataout, nll0i, n11O);
	and(wire_nlO1O_dataout, nlOOi, ~(n11O));
	assign		wire_nlOi_dataout = (wire_nllii_o[1] === 1'b1) ? ((((gen2ngen1 & n0llO) & (n0lli14 ^ n0lli13)) & n1Ol) | ((~ gen2ngen1) & n0liO)) : n1li;
	or(wire_nlOii_dataout, nll0i, n000i);
	assign		wire_nlOil_dataout = (n000i === 1'b1) ? rphfifo_regmode_rx : nlOOi;
	and(wire_nlOiO_dataout, nlOOl, ~(n000i));
	and(wire_nlOli_dataout, nlOOO, ~(n000i));
	oper_add   nO
	( 
	.a({ni1O, ((n0lOO12 ^ n0lOO11) & ni1i), n0OO, n0Ol, n0Oi, n0lO, n0ll, ((n0O1i10 ^ n0O1i9) & n0li), n0iO, ((n0O1l8 ^ n0O1l7) & n0il), ((n0O1O6 ^ n0O1O5) & n0ii), n00O, n00l, ((n0O0i4 ^ n0O0i3) & n00i), n01O, n01l, n01i, n1OO, ((n0O0l2 ^ n0O0l1) & n1Ol)}),
	.b({{18{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nO_o));
	defparam
		nO.sgate_representation = 0,
		nO.width_a = 19,
		nO.width_b = 19,
		nO.width_o = 19;
	oper_decoder   nllii
	( 
	.i({nlOOO, nlOOl, nlOOi, nll0i}),
	.o(wire_nllii_o));
	defparam
		nllii.width_i = 4,
		nllii.width_o = 16;
	oper_mux   nliOO
	( 
	.data({{6{1'b0}}, wire_nllli_dataout, 1'b1, wire_nllli_dataout, 1'b1, wire_nllli_dataout, wire_nlO1l_dataout, 1'b0, 1'b1, wire_nllli_dataout, wire_nlOii_dataout}),
	.o(wire_nliOO_o),
	.sel({nlOOO, nlOOl, nlOOi, nll0i}));
	defparam
		nliOO.width_data = 16,
		nliOO.width_sel = 4;
	oper_mux   nll1i
	( 
	.data({{6{1'b0}}, wire_nllll_dataout, 1'b0, wire_nllOl_dataout, 1'b1, wire_nllll_dataout, wire_nlO1O_dataout, 1'b0, 1'b1, wire_nllll_dataout, wire_nlOil_dataout}),
	.o(wire_nll1i_o),
	.sel({nlOOO, nlOOl, nlOOi, nll0i}));
	defparam
		nll1i.width_data = 16,
		nll1i.width_sel = 4;
	oper_mux   nll1l
	( 
	.data({{6{1'b0}}, wire_nlllO_dataout, 1'b0, wire_nlllO_dataout, 1'b1, wire_nllOO_dataout, wire_nlO0i_dataout, 1'b1, 1'b0, wire_nlllO_dataout, wire_nlOiO_dataout}),
	.o(wire_nll1l_o),
	.sel({nlOOO, nlOOl, nlOOi, nll0i}));
	defparam
		nll1l.width_data = 16,
		nll1l.width_sel = 4;
	oper_mux   nll1O
	( 
	.data({{6{1'b0}}, wire_nllOi_dataout, 1'b1, wire_nllOi_dataout, 1'b0, wire_nlO1i_dataout, wire_nlO0l_dataout, {2{1'b0}}, wire_nlO0O_dataout, wire_nlOli_dataout}),
	.o(wire_nll1O_o),
	.sel({nlOOO, nlOOl, nlOOi, nll0i}));
	defparam
		nll1O.width_data = 16,
		nll1O.width_sel = 4;
	assign
		config_sel = n11l,
		cs = {nlOOO, nlOOl, nlOOi, nll0i},
		dis_pc_byte = n001O,
		n000i = ((((n1il ^ n10l) ^ (~ (n000l44 ^ n000l43))) & rauto_speed_ena) & singleorbundle),
		n001l = (((((((wire_nllii_o[15] | wire_nllii_o[14]) | wire_nllii_o[13]) | wire_nllii_o[12]) | wire_nllii_o[11]) | wire_nllii_o[10]) | wire_nllii_o[1]) | wire_nllii_o[0]),
		n001O = (((((wire_nllii_o[7] | wire_nllii_o[6]) | wire_nllii_o[5]) | wire_nllii_o[4]) | wire_nllii_o[2]) | wire_nllii_o[3]),
		n00li = 1'b1,
		n00lO = (((wire_nllii_o[7] | wire_nllii_o[5]) | wire_nllii_o[1]) | wire_nllii_o[9]),
		n00Oi = ((((((((((((((((((~ (n1Ol ^ rpma_done_count[0])) & (~ (n1OO ^ rpma_done_count[1]))) & (~ (n01i ^ rpma_done_count[2]))) & (~ (n01l ^ rpma_done_count[3]))) & (~ (n01O ^ rpma_done_count[4]))) & (~ (n00i ^ rpma_done_count[5]))) & (~ (n00l ^ rpma_done_count[6]))) & (~ (n00O ^ rpma_done_count[7]))) & (~ (n0ii ^ rpma_done_count[8]))) & (~ (n0il ^ rpma_done_count[9]))) & (~ (n0iO ^ rpma_done_count[10]))) & (~ (n0li ^ rpma_done_count[11]))) & (~ (n0ll ^ rpma_done_count[12]))) & (~ (n0lO ^ rpma_done_count[13]))) & (~ (n0Oi ^ rpma_done_count[14]))) & (~ (n0Ol ^ rpma_done_count[15]))) & (~ (n0OO ^ rpma_done_count[16]))) & (~ (ni1i ^ rpma_done_count[17]))),
		n0i1O = ((((((((((((((((((~ (n1OO ^ rpma_done_count[0])) & (~ (n01i ^ rpma_done_count[1]))) & (~ (n01l ^ rpma_done_count[2]))) & (~ (n01O ^ rpma_done_count[3]))) & (~ (n00i ^ rpma_done_count[4]))) & (~ (n00l ^ rpma_done_count[5]))) & (~ (n00O ^ rpma_done_count[6]))) & (~ (n0ii ^ rpma_done_count[7]))) & (~ (n0il ^ rpma_done_count[8]))) & (~ (n0iO ^ rpma_done_count[9]))) & (~ (n0li ^ rpma_done_count[10]))) & (~ (n0ll ^ rpma_done_count[11]))) & (~ (n0lO ^ rpma_done_count[12]))) & (~ (n0Oi ^ rpma_done_count[13]))) & (~ (n0Ol ^ rpma_done_count[14]))) & (~ (n0OO ^ rpma_done_count[15]))) & (~ (ni1i ^ rpma_done_count[16]))) & (~ (ni1O ^ rpma_done_count[17]))),
		n0l1O = (((((~ (n1Ol ^ rauto_pc_en_cnt[0])) & (~ (n1OO ^ rauto_pc_en_cnt[1]))) & (~ (n01i ^ rauto_pc_en_cnt[2]))) & (~ (n01l ^ rauto_pc_en_cnt[3]))) & (~ (n01O ^ rauto_pc_en_cnt[4]))),
		n0lil = (((((~ (n1OO ^ rauto_pc_en_cnt[0])) & (~ (n01i ^ rauto_pc_en_cnt[1]))) & (~ (n01l ^ rauto_pc_en_cnt[2]))) & (~ (n01O ^ rauto_pc_en_cnt[3]))) & (~ (n00i ^ rauto_pc_en_cnt[4]))),
		n0liO = ((((((~ (n1Ol ^ rwait_for_phfifo_cnt[0])) & (~ (n1OO ^ rwait_for_phfifo_cnt[1]))) & (~ (n01i ^ rwait_for_phfifo_cnt[2]))) & (~ (n01l ^ rwait_for_phfifo_cnt[3]))) & (~ (n01O ^ rwait_for_phfifo_cnt[4]))) & (~ (n00i ^ rwait_for_phfifo_cnt[5]))),
		n0llO = ((((((~ (n1OO ^ rwait_for_phfifo_cnt[0])) & (~ (n01i ^ rwait_for_phfifo_cnt[1]))) & (~ (n01l ^ rwait_for_phfifo_cnt[2]))) & (~ (n01O ^ rwait_for_phfifo_cnt[3]))) & (~ (n00i ^ rwait_for_phfifo_cnt[4]))) & (~ (n00l ^ rwait_for_phfifo_cnt[5]))),
		pcie_switch = wire_n1ll_dataout,
		reset_pc_ptrs = (((wire_nllii_o[5] | wire_nllii_o[4]) | wire_nllii_o[2]) | wire_nllii_o[3]),
		speed_change = (~ n001l);
endmodule //arriaii_hssi_rx_digi_auto_speed_neg
//synopsys translate_on
//VALID FILE
//IP Functional Simulation Model
//VERSION_BEGIN 9.1 cbx_mgl 2009:10:21:21:37:49:SJ cbx_simgen 2009:10:21:21:22:16:SJ  VERSION_END
// synthesis VERILOG_INPUT_VERSION VERILOG_2001
// altera message_off 10463



// Copyright (C) 1991-2009 Altera Corporation
// Your use of Altera Corporation's design tools, logic functions 
// and other software and tools, and its AMPP partner logic 
// functions, and any output files from any of the foregoing 
// (including device programming or simulation files), and any 
// associated documentation or information are expressly subject 
// to the terms and conditions of the Altera Program License 
// Subscription Agreement, Altera MegaCore Function License 
// Agreement, or other applicable license agreement, including, 
// without limitation, that your use is for the sole purpose of 
// programming logic devices manufactured by Altera and sold by 
// Altera or its authorized distributors.  Please refer to the 
// applicable agreement for further details.

// You may only use these simulation model output files for simulation
// purposes and expressly not for synthesis or any other purposes (in which
// event Altera disclaims all warranties of any kind).


//synopsys translate_off

//synthesis_resources = lut 149 mux21 612 oper_add 8 oper_decoder 4 oper_mux 37 oper_selector 4 
`timescale 1 ps / 1 ps
module  arriaii_hssi_rx_digi_bist_ver
	( 
	bistdone,
	bisterr,
	clk_2,
	cur_state,
	err_ctl,
	err_data,
	prbs_done,
	prbs_err,
	rbist_clr_rx,
	rbist_sel,
	rbisten_rx,
	rcxpat_chnl_sel,
	rdwidth_rx,
	rpma_doublewidth_rx,
	rpmadwidth_rx,
	rxc,
	rxd,
	selftest_done,
	selftest_err,
	soft_reset,
	sync_status) /* synthesis synthesis_clearbox=1 */;
	output   bistdone;
	output   bisterr;
	input   clk_2;
	output   [4:0]  cur_state;
	output   [1:0]  err_ctl;
	output   [15:0]  err_data;
	input   prbs_done;
	input   prbs_err;
	input   rbist_clr_rx;
	input   [1:0]  rbist_sel;
	input   rbisten_rx;
	input   [1:0]  rcxpat_chnl_sel;
	input   rdwidth_rx;
	input   rpma_doublewidth_rx;
	input   rpmadwidth_rx;
	input   [3:0]  rxc;
	input   [63:0]  rxd;
	output   selftest_done;
	output   selftest_err;
	input   soft_reset;
	input   sync_status;

	reg	n0li1O47;
	reg	n0li1O48;
	reg	n0lOOi45;
	reg	n0lOOi46;
	reg	n0lOOl43;
	reg	n0lOOl44;
	reg	n0lOOO41;
	reg	n0lOOO42;
	reg	n0O10i33;
	reg	n0O10i34;
	reg	n0O10l31;
	reg	n0O10l32;
	reg	n0O10O29;
	reg	n0O10O30;
	reg	n0O11i39;
	reg	n0O11i40;
	reg	n0O11l37;
	reg	n0O11l38;
	reg	n0O11O35;
	reg	n0O11O36;
	reg	n0O1ii27;
	reg	n0O1ii28;
	reg	n0O1Ol25;
	reg	n0O1Ol26;
	reg	n0Oi0O21;
	reg	n0Oi0O22;
	reg	n0Oi1O23;
	reg	n0Oi1O24;
	reg	n0OiOi19;
	reg	n0OiOi20;
	reg	n0OiOO17;
	reg	n0OiOO18;
	reg	n0Ol0i11;
	reg	n0Ol0i12;
	reg	n0Ol0O10;
	reg	n0Ol0O9;
	reg	n0Ol1i15;
	reg	n0Ol1i16;
	reg	n0Ol1l13;
	reg	n0Ol1l14;
	reg	n0Olil7;
	reg	n0Olil8;
	reg	n0OlOO5;
	reg	n0OlOO6;
	reg	n0OO0i1;
	reg	n0OO0i2;
	reg	n0OO1l3;
	reg	n0OO1l4;
	reg	ni00i;
	reg	ni01l;
	reg	ni1lOl;
	reg	niiilO;
	reg	niiiOi;
	reg	niiiOl;
	reg	niiiOO;
	reg	niil0i;
	reg	niil0l;
	reg	niil0O;
	reg	niil1i;
	reg	niil1l;
	reg	niil1O;
	reg	niilii;
	reg	niilil;
	reg	niiliO;
	reg	niilli;
	reg	niilll;
	reg	niillO;
	reg	niilOi;
	reg	niilOl;
	reg	niiO1i;
	reg	niiO1l;
	reg	nll00O;
	reg	nll0ii;
	wire	wire_ni01O_CLRN;
	reg	n11Oi;
	reg	ni00l;
	reg	ni00O;
	reg	ni01i;
	reg	ni0ii;
	reg	ni0il;
	reg	ni0iO;
	reg	ni0li;
	reg	ni0ll;
	reg	ni0lO;
	reg	ni0Oi;
	reg	ni0Ol;
	reg	nii1i;
	reg	niilOO;
	reg	niiO0l;
	reg	niiO0O;
	reg	niiOii;
	reg	niiOil;
	reg	niiOiO;
	reg	niiOli;
	reg	niiOll;
	reg	niiOlO;
	reg	niiOOi;
	reg	niiOOl;
	reg	niiOOO;
	reg	nil00i;
	reg	nil00l;
	reg	nil00O;
	reg	nil01i;
	reg	nil01l;
	reg	nil01O;
	reg	nil10i;
	reg	nil10l;
	reg	nil10O;
	reg	nil11i;
	reg	nil11l;
	reg	nil11O;
	reg	nil1ii;
	reg	nil1il;
	reg	nil1iO;
	reg	nil1li;
	reg	nil1ll;
	reg	nil1lO;
	reg	nil1Oi;
	reg	nil1Ol;
	reg	nil1OO;
	reg	nl1Oll;
	reg	nll00l;
	reg	nll0il;
	reg	nll0iO;
	reg	nll0li;
	reg	nll0ll;
	reg	nll0lO;
	reg	nll0Oi;
	reg	nll0Ol;
	reg	nll0OO;
	reg	nlli0i;
	reg	nlli0l;
	reg	nlli0O;
	reg	nlli1i;
	reg	nlli1l;
	reg	nlli1O;
	reg	nlliii;
	reg	nlliil;
	reg	nlliiO;
	reg	nllili;
	reg	nllill;
	reg	nllilO;
	reg	nlliOi;
	reg	nlliOl;
	reg	nlliOO;
	reg	nlll0i;
	reg	nlll1i;
	reg	nlll1l;
	reg	nlll1O;
	reg	ni0OO_clk_prev;
	wire	wire_ni0OO_CLRN;
	wire	wire_ni0OO_PRN;
	reg	niiO0i;
	reg	niiO1O_clk_prev;
	wire	wire_niiO1O_CLRN;
	wire	wire_n000i_dataout;
	wire	wire_n000l_dataout;
	wire	wire_n000O_dataout;
	wire	wire_n001i_dataout;
	wire	wire_n001l_dataout;
	wire	wire_n001O_dataout;
	wire	wire_n00i_dataout;
	wire	wire_n00ii_dataout;
	wire	wire_n00il_dataout;
	wire	wire_n00iO_dataout;
	wire	wire_n00l_dataout;
	wire	wire_n00li_dataout;
	wire	wire_n00ll_dataout;
	wire	wire_n00lO_dataout;
	wire	wire_n00O_dataout;
	wire	wire_n00Oi_dataout;
	wire	wire_n00Ol_dataout;
	wire	wire_n00OO_dataout;
	wire	wire_n010i_dataout;
	wire	wire_n010l_dataout;
	wire	wire_n010O_dataout;
	wire	wire_n011i_dataout;
	wire	wire_n011l_dataout;
	wire	wire_n011O_dataout;
	wire	wire_n01i_dataout;
	wire	wire_n01ii_dataout;
	wire	wire_n01il_dataout;
	wire	wire_n01iO_dataout;
	wire	wire_n01l_dataout;
	wire	wire_n01li_dataout;
	wire	wire_n01ll_dataout;
	wire	wire_n01lO_dataout;
	wire	wire_n01O_dataout;
	wire	wire_n01Oi_dataout;
	wire	wire_n01Ol_dataout;
	wire	wire_n01OO_dataout;
	wire	wire_n0i_dataout;
	wire	wire_n0i0i_dataout;
	wire	wire_n0i0l_dataout;
	wire	wire_n0i0O_dataout;
	wire	wire_n0i1i_dataout;
	wire	wire_n0i1l_dataout;
	wire	wire_n0i1O_dataout;
	wire	wire_n0ii_dataout;
	wire	wire_n0iii_dataout;
	wire	wire_n0iil_dataout;
	wire	wire_n0iiO_dataout;
	wire	wire_n0il_dataout;
	wire	wire_n0ili_dataout;
	wire	wire_n0ill_dataout;
	wire	wire_n0ilO_dataout;
	wire	wire_n0iO_dataout;
	wire	wire_n0iOi_dataout;
	wire	wire_n0iOl_dataout;
	wire	wire_n0iOO_dataout;
	wire	wire_n0l_dataout;
	wire	wire_n0l0i_dataout;
	wire	wire_n0l0l_dataout;
	wire	wire_n0l0O_dataout;
	wire	wire_n0l1i_dataout;
	wire	wire_n0l1l_dataout;
	wire	wire_n0l1O_dataout;
	wire	wire_n0li_dataout;
	wire	wire_n0lii_dataout;
	wire	wire_n0lil_dataout;
	wire	wire_n0liO_dataout;
	wire	wire_n0lli_dataout;
	wire	wire_n0lll_dataout;
	wire	wire_n0llO_dataout;
	wire	wire_n0lOi_dataout;
	wire	wire_n0lOl_dataout;
	wire	wire_n0lOO_dataout;
	wire	wire_n0O_dataout;
	wire	wire_n0O0i_dataout;
	wire	wire_n0O0l_dataout;
	wire	wire_n0O0O_dataout;
	wire	wire_n0O1i_dataout;
	wire	wire_n0O1l_dataout;
	wire	wire_n0O1O_dataout;
	wire	wire_n0Oi_dataout;
	wire	wire_n0Oii_dataout;
	wire	wire_n0Oil_dataout;
	wire	wire_n0OiO_dataout;
	wire	wire_n0Ol_dataout;
	wire	wire_n0Oli_dataout;
	wire	wire_n0Oll_dataout;
	wire	wire_n0OlO_dataout;
	wire	wire_n0OO_dataout;
	wire	wire_n0OOi_dataout;
	wire	wire_n0OOl_dataout;
	wire	wire_n0OOO_dataout;
	wire	wire_n100O_dataout;
	wire	wire_n10ii_dataout;
	wire	wire_n10il_dataout;
	wire	wire_n10iO_dataout;
	wire	wire_n10li_dataout;
	wire	wire_n10ll_dataout;
	wire	wire_n10lO_dataout;
	wire	wire_n10Oi_dataout;
	wire	wire_n10Ol_dataout;
	wire	wire_n10OO_dataout;
	wire	wire_n1i0i_dataout;
	wire	wire_n1i0l_dataout;
	wire	wire_n1i0O_dataout;
	wire	wire_n1i1i_dataout;
	wire	wire_n1i1l_dataout;
	wire	wire_n1iii_dataout;
	wire	wire_n1iil_dataout;
	wire	wire_n1iiO_dataout;
	wire	wire_n1ili_dataout;
	wire	wire_n1ill_dataout;
	wire	wire_n1ilO_dataout;
	wire	wire_n1iOi_dataout;
	wire	wire_n1iOl_dataout;
	wire	wire_n1iOO_dataout;
	wire	wire_n1l_dataout;
	wire	wire_n1l0i_dataout;
	wire	wire_n1l0l_dataout;
	wire	wire_n1l0O_dataout;
	wire	wire_n1l1i_dataout;
	wire	wire_n1l1l_dataout;
	wire	wire_n1l1O_dataout;
	wire	wire_n1lii_dataout;
	wire	wire_n1lil_dataout;
	wire	wire_n1liO_dataout;
	wire	wire_n1ll_dataout;
	wire	wire_n1lli_dataout;
	wire	wire_n1lll_dataout;
	wire	wire_n1lO_dataout;
	wire	wire_n1lOi_dataout;
	wire	wire_n1lOl_dataout;
	wire	wire_n1lOO_dataout;
	wire	wire_n1O_dataout;
	wire	wire_n1O0i_dataout;
	wire	wire_n1O0l_dataout;
	wire	wire_n1O0O_dataout;
	wire	wire_n1O1i_dataout;
	wire	wire_n1O1l_dataout;
	wire	wire_n1O1O_dataout;
	wire	wire_n1Oi_dataout;
	wire	wire_n1Oii_dataout;
	wire	wire_n1Oil_dataout;
	wire	wire_n1OiO_dataout;
	wire	wire_n1Ol_dataout;
	wire	wire_n1Oli_dataout;
	wire	wire_n1Oll_dataout;
	wire	wire_n1OlO_dataout;
	wire	wire_n1OO_dataout;
	wire	wire_n1OOi_dataout;
	wire	wire_n1OOl_dataout;
	wire	wire_n1OOO_dataout;
	wire	wire_ni_dataout;
	wire	wire_ni000i_dataout;
	wire	wire_ni000l_dataout;
	wire	wire_ni000O_dataout;
	wire	wire_ni001i_dataout;
	wire	wire_ni001l_dataout;
	wire	wire_ni001O_dataout;
	wire	wire_ni00il_dataout;
	wire	wire_ni00iO_dataout;
	wire	wire_ni00ll_dataout;
	wire	wire_ni00lO_dataout;
	wire	wire_ni00Ol_dataout;
	wire	wire_ni00OO_dataout;
	wire	wire_ni010i_dataout;
	wire	wire_ni010l_dataout;
	wire	wire_ni010O_dataout;
	wire	wire_ni011l_dataout;
	wire	wire_ni011O_dataout;
	wire	wire_ni01ii_dataout;
	wire	wire_ni01il_dataout;
	wire	wire_ni01li_dataout;
	wire	wire_ni01ll_dataout;
	wire	wire_ni01Oi_dataout;
	wire	wire_ni01Ol_dataout;
	wire	wire_ni0i_dataout;
	wire	wire_ni0i0i_dataout;
	wire	wire_ni0i0l_dataout;
	wire	wire_ni0i1i_dataout;
	wire	wire_ni0i1l_dataout;
	wire	wire_ni0i1O_dataout;
	wire	wire_ni0iii_dataout;
	wire	wire_ni0iil_dataout;
	wire	wire_ni0ili_dataout;
	wire	wire_ni0ill_dataout;
	wire	wire_ni0iOi_dataout;
	wire	wire_ni0iOl_dataout;
	wire	wire_ni0iOO_dataout;
	wire	wire_ni0l_dataout;
	wire	wire_ni0l0l_dataout;
	wire	wire_ni0l0O_dataout;
	wire	wire_ni0l1i_dataout;
	wire	wire_ni0l1l_dataout;
	wire	wire_ni0l1O_dataout;
	wire	wire_ni0lil_dataout;
	wire	wire_ni0liO_dataout;
	wire	wire_ni0lli_dataout;
	wire	wire_ni0lll_dataout;
	wire	wire_ni0llO_dataout;
	wire	wire_ni0lOi_dataout;
	wire	wire_ni0lOl_dataout;
	wire	wire_ni0lOO_dataout;
	wire	wire_ni0O_dataout;
	wire	wire_ni0O0i_dataout;
	wire	wire_ni0O0l_dataout;
	wire	wire_ni0O0O_dataout;
	wire	wire_ni0O1i_dataout;
	wire	wire_ni0O1l_dataout;
	wire	wire_ni0O1O_dataout;
	wire	wire_ni0OiO_dataout;
	wire	wire_ni0Oli_dataout;
	wire	wire_ni0Oll_dataout;
	wire	wire_ni0OlO_dataout;
	wire	wire_ni0OOi_dataout;
	wire	wire_ni0OOl_dataout;
	wire	wire_ni0OOO_dataout;
	wire	wire_ni10i_dataout;
	wire	wire_ni10l_dataout;
	wire	wire_ni10O_dataout;
	wire	wire_ni11i_dataout;
	wire	wire_ni11l_dataout;
	wire	wire_ni11O_dataout;
	wire	wire_ni1i_dataout;
	wire	wire_ni1ii_dataout;
	wire	wire_ni1il_dataout;
	wire	wire_ni1iO_dataout;
	wire	wire_ni1l_dataout;
	wire	wire_ni1l0i_dataout;
	wire	wire_ni1l0l_dataout;
	wire	wire_ni1l0O_dataout;
	wire	wire_ni1l1i_dataout;
	wire	wire_ni1l1l_dataout;
	wire	wire_ni1l1O_dataout;
	wire	wire_ni1lii_dataout;
	wire	wire_ni1lil_dataout;
	wire	wire_ni1liO_dataout;
	wire	wire_ni1lli_dataout;
	wire	wire_ni1lll_dataout;
	wire	wire_ni1llO_dataout;
	wire	wire_ni1lOO_dataout;
	wire	wire_ni1O_dataout;
	wire	wire_ni1O0i_dataout;
	wire	wire_ni1O0l_dataout;
	wire	wire_ni1O0O_dataout;
	wire	wire_ni1O1i_dataout;
	wire	wire_ni1O1l_dataout;
	wire	wire_ni1O1O_dataout;
	wire	wire_ni1Oii_dataout;
	wire	wire_ni1OiO_dataout;
	wire	wire_ni1Oli_dataout;
	wire	wire_ni1Oll_dataout;
	wire	wire_ni1OlO_dataout;
	wire	wire_ni1OOl_dataout;
	wire	wire_ni1OOO_dataout;
	wire	wire_nii_dataout;
	wire	wire_nii00i_dataout;
	wire	wire_nii00l_dataout;
	wire	wire_nii00O_dataout;
	wire	wire_nii0i_dataout;
	wire	wire_nii0ii_dataout;
	wire	wire_nii0l_dataout;
	wire	wire_nii0ll_dataout;
	wire	wire_nii0O_dataout;
	wire	wire_nii0Oi_dataout;
	wire	wire_nii10i_dataout;
	wire	wire_nii10l_dataout;
	wire	wire_nii10O_dataout;
	wire	wire_nii11i_dataout;
	wire	wire_nii11l_dataout;
	wire	wire_nii11O_dataout;
	wire	wire_nii1ii_dataout;
	wire	wire_nii1il_dataout;
	wire	wire_nii1iO_dataout;
	wire	wire_nii1l_dataout;
	wire	wire_nii1O_dataout;
	wire	wire_niii_dataout;
	wire	wire_niiii_dataout;
	wire	wire_niiil_dataout;
	wire	wire_niiiO_dataout;
	wire	wire_niil_dataout;
	wire	wire_niili_dataout;
	wire	wire_niill_dataout;
	wire	wire_niilO_dataout;
	wire	wire_niiO_dataout;
	wire	wire_niiOi_dataout;
	wire	wire_nil_dataout;
	wire	wire_nil0ii_dataout;
	wire	wire_nil0il_dataout;
	wire	wire_nil0iO_dataout;
	wire	wire_nil0li_dataout;
	wire	wire_nil0ll_dataout;
	wire	wire_nil0lO_dataout;
	wire	wire_nil0Oi_dataout;
	wire	wire_nil0Ol_dataout;
	wire	wire_nil0OO_dataout;
	wire	wire_nili_dataout;
	wire	wire_nili0i_dataout;
	wire	wire_nili0l_dataout;
	wire	wire_nili0O_dataout;
	wire	wire_nili1i_dataout;
	wire	wire_nili1l_dataout;
	wire	wire_nili1O_dataout;
	wire	wire_niliii_dataout;
	wire	wire_niliil_dataout;
	wire	wire_niliiO_dataout;
	wire	wire_nilili_dataout;
	wire	wire_nilill_dataout;
	wire	wire_nililO_dataout;
	wire	wire_niliOi_dataout;
	wire	wire_niliOl_dataout;
	wire	wire_niliOO_dataout;
	wire	wire_nill_dataout;
	wire	wire_nill0i_dataout;
	wire	wire_nill0l_dataout;
	wire	wire_nill0O_dataout;
	wire	wire_nill1i_dataout;
	wire	wire_nill1l_dataout;
	wire	wire_nill1O_dataout;
	wire	wire_nillii_dataout;
	wire	wire_nillil_dataout;
	wire	wire_nilliO_dataout;
	wire	wire_nillli_dataout;
	wire	wire_nillll_dataout;
	wire	wire_nilllO_dataout;
	wire	wire_nillOi_dataout;
	wire	wire_nillOl_dataout;
	wire	wire_nillOO_dataout;
	wire	wire_nilO_dataout;
	wire	wire_nilO0i_dataout;
	wire	wire_nilO0l_dataout;
	wire	wire_nilO0O_dataout;
	wire	wire_nilO1i_dataout;
	wire	wire_nilO1l_dataout;
	wire	wire_nilO1O_dataout;
	wire	wire_nilOii_dataout;
	wire	wire_nilOil_dataout;
	wire	wire_nilOiO_dataout;
	wire	wire_nilOli_dataout;
	wire	wire_nilOll_dataout;
	wire	wire_nilOlO_dataout;
	wire	wire_nilOOi_dataout;
	wire	wire_nilOOl_dataout;
	wire	wire_nilOOO_dataout;
	wire	wire_niO_dataout;
	wire	wire_niO00i_dataout;
	wire	wire_niO00l_dataout;
	wire	wire_niO00O_dataout;
	wire	wire_niO01i_dataout;
	wire	wire_niO01l_dataout;
	wire	wire_niO01O_dataout;
	wire	wire_niO0ii_dataout;
	wire	wire_niO0il_dataout;
	wire	wire_niO0iO_dataout;
	wire	wire_niO0li_dataout;
	wire	wire_niO0ll_dataout;
	wire	wire_niO0lO_dataout;
	wire	wire_niO0Oi_dataout;
	wire	wire_niO10i_dataout;
	wire	wire_niO10l_dataout;
	wire	wire_niO10O_dataout;
	wire	wire_niO11i_dataout;
	wire	wire_niO11l_dataout;
	wire	wire_niO11O_dataout;
	wire	wire_niO1ii_dataout;
	wire	wire_niO1il_dataout;
	wire	wire_niO1iO_dataout;
	wire	wire_niO1li_dataout;
	wire	wire_niO1ll_dataout;
	wire	wire_niO1lO_dataout;
	wire	wire_niO1Oi_dataout;
	wire	wire_niO1Ol_dataout;
	wire	wire_niO1OO_dataout;
	wire	wire_niOi_dataout;
	wire	wire_niOi0i_dataout;
	wire	wire_niOi0l_dataout;
	wire	wire_niOi0O_dataout;
	wire	wire_niOi1l_dataout;
	wire	wire_niOi1O_dataout;
	wire	wire_niOiii_dataout;
	wire	wire_niOiil_dataout;
	wire	wire_niOiiO_dataout;
	wire	wire_niOili_dataout;
	wire	wire_niOill_dataout;
	wire	wire_niOilO_dataout;
	wire	wire_niOiOi_dataout;
	wire	wire_niOiOl_dataout;
	wire	wire_niOiOO_dataout;
	wire	wire_niOl_dataout;
	wire	wire_niOl1i_dataout;
	wire	wire_niOl1l_dataout;
	wire	wire_niOO_dataout;
	wire	wire_nl_dataout;
	wire	wire_nl000l_dataout;
	wire	wire_nl000O_dataout;
	wire	wire_nl001i_dataout;
	wire	wire_nl001l_dataout;
	wire	wire_nl001O_dataout;
	wire	wire_nl00ii_dataout;
	wire	wire_nl00il_dataout;
	wire	wire_nl00iO_dataout;
	wire	wire_nl00li_dataout;
	wire	wire_nl00ll_dataout;
	wire	wire_nl00lO_dataout;
	wire	wire_nl00Oi_dataout;
	wire	wire_nl00Ol_dataout;
	wire	wire_nl00OO_dataout;
	wire	wire_nl01il_dataout;
	wire	wire_nl01iO_dataout;
	wire	wire_nl01li_dataout;
	wire	wire_nl01ll_dataout;
	wire	wire_nl01lO_dataout;
	wire	wire_nl01Oi_dataout;
	wire	wire_nl01Ol_dataout;
	wire	wire_nl01OO_dataout;
	wire	wire_nl0i_dataout;
	wire	wire_nl0i0i_dataout;
	wire	wire_nl0i0l_dataout;
	wire	wire_nl0i0O_dataout;
	wire	wire_nl0i1i_dataout;
	wire	wire_nl0i1l_dataout;
	wire	wire_nl0i1O_dataout;
	wire	wire_nl0iii_dataout;
	wire	wire_nl0iil_dataout;
	wire	wire_nl0iiO_dataout;
	wire	wire_nl0ili_dataout;
	wire	wire_nl0ill_dataout;
	wire	wire_nl0ilO_dataout;
	wire	wire_nl0iOl_dataout;
	wire	wire_nl0iOO_dataout;
	wire	wire_nl0l_dataout;
	wire	wire_nl0l0i_dataout;
	wire	wire_nl0l0l_dataout;
	wire	wire_nl0l0O_dataout;
	wire	wire_nl0l1i_dataout;
	wire	wire_nl0l1l_dataout;
	wire	wire_nl0l1O_dataout;
	wire	wire_nl0lii_dataout;
	wire	wire_nl0lil_dataout;
	wire	wire_nl0liO_dataout;
	wire	wire_nl0lli_dataout;
	wire	wire_nl0lll_dataout;
	wire	wire_nl0llO_dataout;
	wire	wire_nl0lOi_dataout;
	wire	wire_nl0lOl_dataout;
	wire	wire_nl0lOO_dataout;
	wire	wire_nl0O_dataout;
	wire	wire_nl0O0i_dataout;
	wire	wire_nl0O0l_dataout;
	wire	wire_nl0O0O_dataout;
	wire	wire_nl0O1i_dataout;
	wire	wire_nl0O1l_dataout;
	wire	wire_nl0O1O_dataout;
	wire	wire_nl0Oii_dataout;
	wire	wire_nl0Oil_dataout;
	wire	wire_nl0OiO_dataout;
	wire	wire_nl0Oli_dataout;
	wire	wire_nl0Oll_dataout;
	wire	wire_nl0OlO_dataout;
	wire	wire_nl0OOi_dataout;
	wire	wire_nl0OOl_dataout;
	wire	wire_nl0OOO_dataout;
	wire	wire_nl1i_dataout;
	wire	wire_nl1l_dataout;
	wire	wire_nl1O_dataout;
	wire	wire_nl1Oii_dataout;
	wire	wire_nl1Oil_dataout;
	wire	wire_nl1Oli_dataout;
	wire	wire_nl1OlO_dataout;
	wire	wire_nl1OOi_dataout;
	wire	wire_nl1OOl_dataout;
	wire	wire_nl1OOO_dataout;
	wire	wire_nli_dataout;
	wire	wire_nli00i_dataout;
	wire	wire_nli00l_dataout;
	wire	wire_nli00O_dataout;
	wire	wire_nli01i_dataout;
	wire	wire_nli01l_dataout;
	wire	wire_nli01O_dataout;
	wire	wire_nli0ii_dataout;
	wire	wire_nli0il_dataout;
	wire	wire_nli0iO_dataout;
	wire	wire_nli0li_dataout;
	wire	wire_nli0ll_dataout;
	wire	wire_nli0lO_dataout;
	wire	wire_nli0Oi_dataout;
	wire	wire_nli0Ol_dataout;
	wire	wire_nli0OO_dataout;
	wire	wire_nli10i_dataout;
	wire	wire_nli10l_dataout;
	wire	wire_nli10O_dataout;
	wire	wire_nli11i_dataout;
	wire	wire_nli11l_dataout;
	wire	wire_nli11O_dataout;
	wire	wire_nli1ii_dataout;
	wire	wire_nli1il_dataout;
	wire	wire_nli1iO_dataout;
	wire	wire_nli1li_dataout;
	wire	wire_nli1ll_dataout;
	wire	wire_nli1lO_dataout;
	wire	wire_nli1Oi_dataout;
	wire	wire_nli1Ol_dataout;
	wire	wire_nli1OO_dataout;
	wire	wire_nlii_dataout;
	wire	wire_nlii0i_dataout;
	wire	wire_nlii0l_dataout;
	wire	wire_nlii0O_dataout;
	wire	wire_nlii1i_dataout;
	wire	wire_nlii1l_dataout;
	wire	wire_nlii1O_dataout;
	wire	wire_nliiii_dataout;
	wire	wire_nliiil_dataout;
	wire	wire_nliiiO_dataout;
	wire	wire_nliill_dataout;
	wire	wire_nliilO_dataout;
	wire	wire_nliiOi_dataout;
	wire	wire_nliiOl_dataout;
	wire	wire_nliiOO_dataout;
	wire	wire_nlil_dataout;
	wire	wire_nlil0i_dataout;
	wire	wire_nlil0l_dataout;
	wire	wire_nlil0O_dataout;
	wire	wire_nlil1i_dataout;
	wire	wire_nlil1l_dataout;
	wire	wire_nlil1O_dataout;
	wire	wire_nlilii_dataout;
	wire	wire_nlilil_dataout;
	wire	wire_nliliO_dataout;
	wire	wire_nlilli_dataout;
	wire	wire_nlilll_dataout;
	wire	wire_nlillO_dataout;
	wire	wire_nlilOi_dataout;
	wire	wire_nlilOl_dataout;
	wire	wire_nlilOO_dataout;
	wire	wire_nliO_dataout;
	wire	wire_nliO0i_dataout;
	wire	wire_nliO0l_dataout;
	wire	wire_nliO0O_dataout;
	wire	wire_nliO1i_dataout;
	wire	wire_nliO1l_dataout;
	wire	wire_nliO1O_dataout;
	wire	wire_nliOii_dataout;
	wire	wire_nliOil_dataout;
	wire	wire_nliOiO_dataout;
	wire	wire_nliOli_dataout;
	wire	wire_nliOll_dataout;
	wire	wire_nliOlO_dataout;
	wire	wire_nliOOi_dataout;
	wire	wire_nliOOl_dataout;
	wire	wire_nliOOO_dataout;
	wire	wire_nll10i_dataout;
	wire	wire_nll10l_dataout;
	wire	wire_nll10O_dataout;
	wire	wire_nll11i_dataout;
	wire	wire_nll11O_dataout;
	wire	wire_nll1ii_dataout;
	wire	wire_nll1il_dataout;
	wire	wire_nll1iO_dataout;
	wire	wire_nll1li_dataout;
	wire	wire_nll1ll_dataout;
	wire	wire_nll1lO_dataout;
	wire	wire_nll1Oi_dataout;
	wire	wire_nll1Ol_dataout;
	wire	wire_nlli_dataout;
	wire	wire_nlll_dataout;
	wire	wire_nlll0l_dataout;
	wire	wire_nlll0O_dataout;
	wire	wire_nlllii_dataout;
	wire	wire_nlllil_dataout;
	wire	wire_nllliO_dataout;
	wire	wire_nlllli_dataout;
	wire	wire_nlllll_dataout;
	wire	wire_nllllO_dataout;
	wire	wire_nlllOi_dataout;
	wire	wire_nlllOl_dataout;
	wire	wire_nlllOO_dataout;
	wire	wire_nllO_dataout;
	wire	wire_nllO0l_dataout;
	wire	wire_nllO0O_dataout;
	wire	wire_nllO1i_dataout;
	wire	wire_nllO1l_dataout;
	wire	wire_nllO1O_dataout;
	wire	wire_nllOii_dataout;
	wire	wire_nllOiO_dataout;
	wire	wire_nllOli_dataout;
	wire	wire_nllOll_dataout;
	wire	wire_nllOlO_dataout;
	wire	wire_nllOOi_dataout;
	wire	wire_nllOOl_dataout;
	wire	wire_nllOOO_dataout;
	wire	wire_nlO00i_dataout;
	wire	wire_nlO00l_dataout;
	wire	wire_nlO01i_dataout;
	wire	wire_nlO01l_dataout;
	wire	wire_nlO01O_dataout;
	wire	wire_nlO10i_dataout;
	wire	wire_nlO10l_dataout;
	wire	wire_nlO10O_dataout;
	wire	wire_nlO11i_dataout;
	wire	wire_nlO11O_dataout;
	wire	wire_nlO1ii_dataout;
	wire	wire_nlO1il_dataout;
	wire	wire_nlO1iO_dataout;
	wire	wire_nlO1li_dataout;
	wire	wire_nlO1ll_dataout;
	wire	wire_nlO1lO_dataout;
	wire	wire_nlO1Oi_dataout;
	wire	wire_nlO1Ol_dataout;
	wire	wire_nlO1OO_dataout;
	wire	wire_nlOi_dataout;
	wire	wire_nlOl_dataout;
	wire	wire_nlOO_dataout;
	wire	wire_nO_dataout;
	wire  [4:0]   wire_niiOl_o;
	wire  [6:0]   wire_niO0Ol_o;
	wire  [6:0]   wire_niO0OO_o;
	wire  [8:0]   wire_niOi1i_o;
	wire  [5:0]   wire_nllO0i_o;
	wire  [2:0]   wire_nllOil_o;
	wire  [8:0]   wire_nlO00O_o;
	wire  [3:0]   wire_nlO11l_o;
	wire  [31:0]   wire_n11li_o;
	wire  [15:0]   wire_ni1iii_o;
	wire  [15:0]   wire_nii0Ol_o;
	wire  [15:0]   wire_nl1OiO_o;
	wire  wire_n100i_o;
	wire  wire_n100l_o;
	wire  wire_n101i_o;
	wire  wire_n101l_o;
	wire  wire_n101O_o;
	wire  wire_n11Ol_o;
	wire  wire_n11OO_o;
	wire  wire_ni1iil_o;
	wire  wire_ni1iiO_o;
	wire  wire_ni1ili_o;
	wire  wire_ni1ill_o;
	wire  wire_ni1ilO_o;
	wire  wire_ni1iOi_o;
	wire  wire_ni1iOl_o;
	wire  wire_ni1iOO_o;
	wire  wire_nii0iO_o;
	wire  wire_nii0li_o;
	wire  wire_nii0lO_o;
	wire  wire_nii0OO_o;
	wire  wire_niii0i_o;
	wire  wire_niii0l_o;
	wire  wire_niii0O_o;
	wire  wire_niii1i_o;
	wire  wire_niii1l_o;
	wire  wire_niii1O_o;
	wire  wire_niiiii_o;
	wire  wire_niiiil_o;
	wire  wire_niiiiO_o;
	wire  wire_niiili_o;
	wire  wire_niiill_o;
	wire  wire_nl010i_o;
	wire  wire_nl010l_o;
	wire  wire_nl010O_o;
	wire  wire_nl011i_o;
	wire  wire_nl011l_o;
	wire  wire_nl011O_o;
	wire  wire_nl01ii_o;
	wire  wire_n11ii_o;
	wire  wire_n11il_o;
	wire  wire_n11ll_o;
	wire  wire_ni1i0l_o;
	wire  n0iO0i;
	wire  n0iO0l;
	wire  n0iO0O;
	wire  n0iO1i;
	wire  n0iO1l;
	wire  n0iO1O;
	wire  n0iOii;
	wire  n0iOil;
	wire  n0iOiO;
	wire  n0iOli;
	wire  n0iOll;
	wire  n0iOlO;
	wire  n0iOOi;
	wire  n0iOOl;
	wire  n0iOOO;
	wire  n0l00i;
	wire  n0l00l;
	wire  n0l00O;
	wire  n0l01i;
	wire  n0l01l;
	wire  n0l01O;
	wire  n0l0ii;
	wire  n0l0il;
	wire  n0l0iO;
	wire  n0l0li;
	wire  n0l0ll;
	wire  n0l0lO;
	wire  n0l0Oi;
	wire  n0l0Ol;
	wire  n0l0OO;
	wire  n0l10i;
	wire  n0l10l;
	wire  n0l10O;
	wire  n0l11i;
	wire  n0l11l;
	wire  n0l11O;
	wire  n0l1ii;
	wire  n0l1il;
	wire  n0l1iO;
	wire  n0l1li;
	wire  n0l1ll;
	wire  n0l1lO;
	wire  n0l1Oi;
	wire  n0l1Ol;
	wire  n0l1OO;
	wire  n0li0i;
	wire  n0li0l;
	wire  n0li0O;
	wire  n0li1i;
	wire  n0li1l;
	wire  n0liii;
	wire  n0liil;
	wire  n0liiO;
	wire  n0lili;
	wire  n0lill;
	wire  n0lilO;
	wire  n0liOi;
	wire  n0liOl;
	wire  n0liOO;
	wire  n0ll0i;
	wire  n0ll0l;
	wire  n0ll0O;
	wire  n0ll1i;
	wire  n0ll1l;
	wire  n0ll1O;
	wire  n0llii;
	wire  n0llil;
	wire  n0lliO;
	wire  n0llli;
	wire  n0llll;
	wire  n0lllO;
	wire  n0llOi;
	wire  n0llOl;
	wire  n0llOO;
	wire  n0lO0i;
	wire  n0lO0l;
	wire  n0lO0O;
	wire  n0lO1i;
	wire  n0lO1l;
	wire  n0lO1O;
	wire  n0lOii;
	wire  n0lOil;
	wire  n0lOiO;
	wire  n0lOli;
	wire  n0lOll;
	wire  n0lOlO;
	wire  n0O00i;
	wire  n0O00l;
	wire  n0O00O;
	wire  n0O01i;
	wire  n0O01l;
	wire  n0O01O;
	wire  n0O0ii;
	wire  n0O0il;
	wire  n0O0iO;
	wire  n0O0li;
	wire  n0O0ll;
	wire  n0O0lO;
	wire  n0O0Oi;
	wire  n0O0Ol;
	wire  n0O0OO;
	wire  n0O1il;
	wire  n0O1iO;
	wire  n0O1li;
	wire  n0O1ll;
	wire  n0O1lO;
	wire  n0O1Oi;
	wire  n0Oi0l;
	wire  n0Oi1i;
	wire  n0Oi1l;
	wire  n0Oiil;
	wire  n0OiiO;
	wire  n0Oili;
	wire  n0Oill;
	wire  n0OilO;
	wire  n0OiOl;
	wire  n0Olli;
	wire  n0Olll;
	wire  n0OllO;
	wire  n0OlOi;
	wire  n0OlOl;

	initial
		n0li1O47 = 0;
	always @ ( posedge clk_2)
		  n0li1O47 <= n0li1O48;
	event n0li1O47_event;
	initial
		#1 ->n0li1O47_event;
	always @(n0li1O47_event)
		n0li1O47 <= {1{1'b1}};
	initial
		n0li1O48 = 0;
	always @ ( posedge clk_2)
		  n0li1O48 <= n0li1O47;
	initial
		n0lOOi45 = 0;
	always @ ( posedge clk_2)
		  n0lOOi45 <= n0lOOi46;
	event n0lOOi45_event;
	initial
		#1 ->n0lOOi45_event;
	always @(n0lOOi45_event)
		n0lOOi45 <= {1{1'b1}};
	initial
		n0lOOi46 = 0;
	always @ ( posedge clk_2)
		  n0lOOi46 <= n0lOOi45;
	initial
		n0lOOl43 = 0;
	always @ ( posedge clk_2)
		  n0lOOl43 <= n0lOOl44;
	event n0lOOl43_event;
	initial
		#1 ->n0lOOl43_event;
	always @(n0lOOl43_event)
		n0lOOl43 <= {1{1'b1}};
	initial
		n0lOOl44 = 0;
	always @ ( posedge clk_2)
		  n0lOOl44 <= n0lOOl43;
	initial
		n0lOOO41 = 0;
	always @ ( posedge clk_2)
		  n0lOOO41 <= n0lOOO42;
	event n0lOOO41_event;
	initial
		#1 ->n0lOOO41_event;
	always @(n0lOOO41_event)
		n0lOOO41 <= {1{1'b1}};
	initial
		n0lOOO42 = 0;
	always @ ( posedge clk_2)
		  n0lOOO42 <= n0lOOO41;
	initial
		n0O10i33 = 0;
	always @ ( posedge clk_2)
		  n0O10i33 <= n0O10i34;
	event n0O10i33_event;
	initial
		#1 ->n0O10i33_event;
	always @(n0O10i33_event)
		n0O10i33 <= {1{1'b1}};
	initial
		n0O10i34 = 0;
	always @ ( posedge clk_2)
		  n0O10i34 <= n0O10i33;
	initial
		n0O10l31 = 0;
	always @ ( posedge clk_2)
		  n0O10l31 <= n0O10l32;
	event n0O10l31_event;
	initial
		#1 ->n0O10l31_event;
	always @(n0O10l31_event)
		n0O10l31 <= {1{1'b1}};
	initial
		n0O10l32 = 0;
	always @ ( posedge clk_2)
		  n0O10l32 <= n0O10l31;
	initial
		n0O10O29 = 0;
	always @ ( posedge clk_2)
		  n0O10O29 <= n0O10O30;
	event n0O10O29_event;
	initial
		#1 ->n0O10O29_event;
	always @(n0O10O29_event)
		n0O10O29 <= {1{1'b1}};
	initial
		n0O10O30 = 0;
	always @ ( posedge clk_2)
		  n0O10O30 <= n0O10O29;
	initial
		n0O11i39 = 0;
	always @ ( posedge clk_2)
		  n0O11i39 <= n0O11i40;
	event n0O11i39_event;
	initial
		#1 ->n0O11i39_event;
	always @(n0O11i39_event)
		n0O11i39 <= {1{1'b1}};
	initial
		n0O11i40 = 0;
	always @ ( posedge clk_2)
		  n0O11i40 <= n0O11i39;
	initial
		n0O11l37 = 0;
	always @ ( posedge clk_2)
		  n0O11l37 <= n0O11l38;
	event n0O11l37_event;
	initial
		#1 ->n0O11l37_event;
	always @(n0O11l37_event)
		n0O11l37 <= {1{1'b1}};
	initial
		n0O11l38 = 0;
	always @ ( posedge clk_2)
		  n0O11l38 <= n0O11l37;
	initial
		n0O11O35 = 0;
	always @ ( posedge clk_2)
		  n0O11O35 <= n0O11O36;
	event n0O11O35_event;
	initial
		#1 ->n0O11O35_event;
	always @(n0O11O35_event)
		n0O11O35 <= {1{1'b1}};
	initial
		n0O11O36 = 0;
	always @ ( posedge clk_2)
		  n0O11O36 <= n0O11O35;
	initial
		n0O1ii27 = 0;
	always @ ( posedge clk_2)
		  n0O1ii27 <= n0O1ii28;
	event n0O1ii27_event;
	initial
		#1 ->n0O1ii27_event;
	always @(n0O1ii27_event)
		n0O1ii27 <= {1{1'b1}};
	initial
		n0O1ii28 = 0;
	always @ ( posedge clk_2)
		  n0O1ii28 <= n0O1ii27;
	initial
		n0O1Ol25 = 0;
	always @ ( posedge clk_2)
		  n0O1Ol25 <= n0O1Ol26;
	event n0O1Ol25_event;
	initial
		#1 ->n0O1Ol25_event;
	always @(n0O1Ol25_event)
		n0O1Ol25 <= {1{1'b1}};
	initial
		n0O1Ol26 = 0;
	always @ ( posedge clk_2)
		  n0O1Ol26 <= n0O1Ol25;
	initial
		n0Oi0O21 = 0;
	always @ ( posedge clk_2)
		  n0Oi0O21 <= n0Oi0O22;
	event n0Oi0O21_event;
	initial
		#1 ->n0Oi0O21_event;
	always @(n0Oi0O21_event)
		n0Oi0O21 <= {1{1'b1}};
	initial
		n0Oi0O22 = 0;
	always @ ( posedge clk_2)
		  n0Oi0O22 <= n0Oi0O21;
	initial
		n0Oi1O23 = 0;
	always @ ( posedge clk_2)
		  n0Oi1O23 <= n0Oi1O24;
	event n0Oi1O23_event;
	initial
		#1 ->n0Oi1O23_event;
	always @(n0Oi1O23_event)
		n0Oi1O23 <= {1{1'b1}};
	initial
		n0Oi1O24 = 0;
	always @ ( posedge clk_2)
		  n0Oi1O24 <= n0Oi1O23;
	initial
		n0OiOi19 = 0;
	always @ ( posedge clk_2)
		  n0OiOi19 <= n0OiOi20;
	event n0OiOi19_event;
	initial
		#1 ->n0OiOi19_event;
	always @(n0OiOi19_event)
		n0OiOi19 <= {1{1'b1}};
	initial
		n0OiOi20 = 0;
	always @ ( posedge clk_2)
		  n0OiOi20 <= n0OiOi19;
	initial
		n0OiOO17 = 0;
	always @ ( posedge clk_2)
		  n0OiOO17 <= n0OiOO18;
	event n0OiOO17_event;
	initial
		#1 ->n0OiOO17_event;
	always @(n0OiOO17_event)
		n0OiOO17 <= {1{1'b1}};
	initial
		n0OiOO18 = 0;
	always @ ( posedge clk_2)
		  n0OiOO18 <= n0OiOO17;
	initial
		n0Ol0i11 = 0;
	always @ ( posedge clk_2)
		  n0Ol0i11 <= n0Ol0i12;
	event n0Ol0i11_event;
	initial
		#1 ->n0Ol0i11_event;
	always @(n0Ol0i11_event)
		n0Ol0i11 <= {1{1'b1}};
	initial
		n0Ol0i12 = 0;
	always @ ( posedge clk_2)
		  n0Ol0i12 <= n0Ol0i11;
	initial
		n0Ol0O10 = 0;
	always @ ( posedge clk_2)
		  n0Ol0O10 <= n0Ol0O9;
	initial
		n0Ol0O9 = 0;
	always @ ( posedge clk_2)
		  n0Ol0O9 <= n0Ol0O10;
	event n0Ol0O9_event;
	initial
		#1 ->n0Ol0O9_event;
	always @(n0Ol0O9_event)
		n0Ol0O9 <= {1{1'b1}};
	initial
		n0Ol1i15 = 0;
	always @ ( posedge clk_2)
		  n0Ol1i15 <= n0Ol1i16;
	event n0Ol1i15_event;
	initial
		#1 ->n0Ol1i15_event;
	always @(n0Ol1i15_event)
		n0Ol1i15 <= {1{1'b1}};
	initial
		n0Ol1i16 = 0;
	always @ ( posedge clk_2)
		  n0Ol1i16 <= n0Ol1i15;
	initial
		n0Ol1l13 = 0;
	always @ ( posedge clk_2)
		  n0Ol1l13 <= n0Ol1l14;
	event n0Ol1l13_event;
	initial
		#1 ->n0Ol1l13_event;
	always @(n0Ol1l13_event)
		n0Ol1l13 <= {1{1'b1}};
	initial
		n0Ol1l14 = 0;
	always @ ( posedge clk_2)
		  n0Ol1l14 <= n0Ol1l13;
	initial
		n0Olil7 = 0;
	always @ ( posedge clk_2)
		  n0Olil7 <= n0Olil8;
	event n0Olil7_event;
	initial
		#1 ->n0Olil7_event;
	always @(n0Olil7_event)
		n0Olil7 <= {1{1'b1}};
	initial
		n0Olil8 = 0;
	always @ ( posedge clk_2)
		  n0Olil8 <= n0Olil7;
	initial
		n0OlOO5 = 0;
	always @ ( posedge clk_2)
		  n0OlOO5 <= n0OlOO6;
	event n0OlOO5_event;
	initial
		#1 ->n0OlOO5_event;
	always @(n0OlOO5_event)
		n0OlOO5 <= {1{1'b1}};
	initial
		n0OlOO6 = 0;
	always @ ( posedge clk_2)
		  n0OlOO6 <= n0OlOO5;
	initial
		n0OO0i1 = 0;
	always @ ( posedge clk_2)
		  n0OO0i1 <= n0OO0i2;
	event n0OO0i1_event;
	initial
		#1 ->n0OO0i1_event;
	always @(n0OO0i1_event)
		n0OO0i1 <= {1{1'b1}};
	initial
		n0OO0i2 = 0;
	always @ ( posedge clk_2)
		  n0OO0i2 <= n0OO0i1;
	initial
		n0OO1l3 = 0;
	always @ ( posedge clk_2)
		  n0OO1l3 <= n0OO1l4;
	event n0OO1l3_event;
	initial
		#1 ->n0OO1l3_event;
	always @(n0OO1l3_event)
		n0OO1l3 <= {1{1'b1}};
	initial
		n0OO1l4 = 0;
	always @ ( posedge clk_2)
		  n0OO1l4 <= n0OO1l3;
	initial
	begin
		ni00i = 0;
		ni01l = 0;
		ni1lOl = 0;
		niiilO = 0;
		niiiOi = 0;
		niiiOl = 0;
		niiiOO = 0;
		niil0i = 0;
		niil0l = 0;
		niil0O = 0;
		niil1i = 0;
		niil1l = 0;
		niil1O = 0;
		niilii = 0;
		niilil = 0;
		niiliO = 0;
		niilli = 0;
		niilll = 0;
		niillO = 0;
		niilOi = 0;
		niilOl = 0;
		niiO1i = 0;
		niiO1l = 0;
		nll00O = 0;
		nll0ii = 0;
	end
	always @ ( posedge clk_2 or  negedge wire_ni01O_CLRN)
	begin
		if (wire_ni01O_CLRN == 1'b0) 
		begin
			ni00i <= 0;
			ni01l <= 0;
			ni1lOl <= 0;
			niiilO <= 0;
			niiiOi <= 0;
			niiiOl <= 0;
			niiiOO <= 0;
			niil0i <= 0;
			niil0l <= 0;
			niil0O <= 0;
			niil1i <= 0;
			niil1l <= 0;
			niil1O <= 0;
			niilii <= 0;
			niilil <= 0;
			niiliO <= 0;
			niilli <= 0;
			niilll <= 0;
			niillO <= 0;
			niilOi <= 0;
			niilOl <= 0;
			niiO1i <= 0;
			niiO1l <= 0;
			nll00O <= 0;
			nll0ii <= 0;
		end
		else 
		begin
			ni00i <= wire_nii1O_dataout;
			ni01l <= wire_nii1l_dataout;
			ni1lOl <= wire_nil0ii_dataout;
			niiilO <= wire_nil0il_dataout;
			niiiOi <= wire_nil0iO_dataout;
			niiiOl <= wire_nil0li_dataout;
			niiiOO <= wire_nil0ll_dataout;
			niil0i <= wire_nil0OO_dataout;
			niil0l <= wire_nili1i_dataout;
			niil0O <= wire_nili1l_dataout;
			niil1i <= wire_nil0lO_dataout;
			niil1l <= wire_nil0Oi_dataout;
			niil1O <= wire_nil0Ol_dataout;
			niilii <= wire_nili1O_dataout;
			niilil <= wire_nili0i_dataout;
			niiliO <= wire_nili0l_dataout;
			niilli <= wire_nili0O_dataout;
			niilll <= wire_niliii_dataout;
			niillO <= wire_niliil_dataout;
			niilOi <= wire_niliiO_dataout;
			niilOl <= wire_nilili_dataout;
			niiO1i <= wire_nilill_dataout;
			niiO1l <= wire_nililO_dataout;
			nll00O <= wire_nlll0l_dataout;
			nll0ii <= wire_nlll0O_dataout;
		end
	end
	assign
		wire_ni01O_CLRN = ((n0OiOi20 ^ n0OiOi19) & (~ soft_reset));
	initial
	begin
		n11Oi = 0;
		ni00l = 0;
		ni00O = 0;
		ni01i = 0;
		ni0ii = 0;
		ni0il = 0;
		ni0iO = 0;
		ni0li = 0;
		ni0ll = 0;
		ni0lO = 0;
		ni0Oi = 0;
		ni0Ol = 0;
		nii1i = 0;
		niilOO = 0;
		niiO0l = 0;
		niiO0O = 0;
		niiOii = 0;
		niiOil = 0;
		niiOiO = 0;
		niiOli = 0;
		niiOll = 0;
		niiOlO = 0;
		niiOOi = 0;
		niiOOl = 0;
		niiOOO = 0;
		nil00i = 0;
		nil00l = 0;
		nil00O = 0;
		nil01i = 0;
		nil01l = 0;
		nil01O = 0;
		nil10i = 0;
		nil10l = 0;
		nil10O = 0;
		nil11i = 0;
		nil11l = 0;
		nil11O = 0;
		nil1ii = 0;
		nil1il = 0;
		nil1iO = 0;
		nil1li = 0;
		nil1ll = 0;
		nil1lO = 0;
		nil1Oi = 0;
		nil1Ol = 0;
		nil1OO = 0;
		nl1Oll = 0;
		nll00l = 0;
		nll0il = 0;
		nll0iO = 0;
		nll0li = 0;
		nll0ll = 0;
		nll0lO = 0;
		nll0Oi = 0;
		nll0Ol = 0;
		nll0OO = 0;
		nlli0i = 0;
		nlli0l = 0;
		nlli0O = 0;
		nlli1i = 0;
		nlli1l = 0;
		nlli1O = 0;
		nlliii = 0;
		nlliil = 0;
		nlliiO = 0;
		nllili = 0;
		nllill = 0;
		nllilO = 0;
		nlliOi = 0;
		nlliOl = 0;
		nlliOO = 0;
		nlll0i = 0;
		nlll1i = 0;
		nlll1l = 0;
		nlll1O = 0;
	end
	always @ (clk_2 or wire_ni0OO_PRN or wire_ni0OO_CLRN)
	begin
		if (wire_ni0OO_PRN == 1'b0) 
		begin
			n11Oi <= 1;
			ni00l <= 1;
			ni00O <= 1;
			ni01i <= 1;
			ni0ii <= 1;
			ni0il <= 1;
			ni0iO <= 1;
			ni0li <= 1;
			ni0ll <= 1;
			ni0lO <= 1;
			ni0Oi <= 1;
			ni0Ol <= 1;
			nii1i <= 1;
			niilOO <= 1;
			niiO0l <= 1;
			niiO0O <= 1;
			niiOii <= 1;
			niiOil <= 1;
			niiOiO <= 1;
			niiOli <= 1;
			niiOll <= 1;
			niiOlO <= 1;
			niiOOi <= 1;
			niiOOl <= 1;
			niiOOO <= 1;
			nil00i <= 1;
			nil00l <= 1;
			nil00O <= 1;
			nil01i <= 1;
			nil01l <= 1;
			nil01O <= 1;
			nil10i <= 1;
			nil10l <= 1;
			nil10O <= 1;
			nil11i <= 1;
			nil11l <= 1;
			nil11O <= 1;
			nil1ii <= 1;
			nil1il <= 1;
			nil1iO <= 1;
			nil1li <= 1;
			nil1ll <= 1;
			nil1lO <= 1;
			nil1Oi <= 1;
			nil1Ol <= 1;
			nil1OO <= 1;
			nl1Oll <= 1;
			nll00l <= 1;
			nll0il <= 1;
			nll0iO <= 1;
			nll0li <= 1;
			nll0ll <= 1;
			nll0lO <= 1;
			nll0Oi <= 1;
			nll0Ol <= 1;
			nll0OO <= 1;
			nlli0i <= 1;
			nlli0l <= 1;
			nlli0O <= 1;
			nlli1i <= 1;
			nlli1l <= 1;
			nlli1O <= 1;
			nlliii <= 1;
			nlliil <= 1;
			nlliiO <= 1;
			nllili <= 1;
			nllill <= 1;
			nllilO <= 1;
			nlliOi <= 1;
			nlliOl <= 1;
			nlliOO <= 1;
			nlll0i <= 1;
			nlll1i <= 1;
			nlll1l <= 1;
			nlll1O <= 1;
		end
		else if  (wire_ni0OO_CLRN == 1'b0) 
		begin
			n11Oi <= 0;
			ni00l <= 0;
			ni00O <= 0;
			ni01i <= 0;
			ni0ii <= 0;
			ni0il <= 0;
			ni0iO <= 0;
			ni0li <= 0;
			ni0ll <= 0;
			ni0lO <= 0;
			ni0Oi <= 0;
			ni0Ol <= 0;
			nii1i <= 0;
			niilOO <= 0;
			niiO0l <= 0;
			niiO0O <= 0;
			niiOii <= 0;
			niiOil <= 0;
			niiOiO <= 0;
			niiOli <= 0;
			niiOll <= 0;
			niiOlO <= 0;
			niiOOi <= 0;
			niiOOl <= 0;
			niiOOO <= 0;
			nil00i <= 0;
			nil00l <= 0;
			nil00O <= 0;
			nil01i <= 0;
			nil01l <= 0;
			nil01O <= 0;
			nil10i <= 0;
			nil10l <= 0;
			nil10O <= 0;
			nil11i <= 0;
			nil11l <= 0;
			nil11O <= 0;
			nil1ii <= 0;
			nil1il <= 0;
			nil1iO <= 0;
			nil1li <= 0;
			nil1ll <= 0;
			nil1lO <= 0;
			nil1Oi <= 0;
			nil1Ol <= 0;
			nil1OO <= 0;
			nl1Oll <= 0;
			nll00l <= 0;
			nll0il <= 0;
			nll0iO <= 0;
			nll0li <= 0;
			nll0ll <= 0;
			nll0lO <= 0;
			nll0Oi <= 0;
			nll0Ol <= 0;
			nll0OO <= 0;
			nlli0i <= 0;
			nlli0l <= 0;
			nlli0O <= 0;
			nlli1i <= 0;
			nlli1l <= 0;
			nlli1O <= 0;
			nlliii <= 0;
			nlliil <= 0;
			nlliiO <= 0;
			nllili <= 0;
			nllill <= 0;
			nllilO <= 0;
			nlliOi <= 0;
			nlliOl <= 0;
			nlliOO <= 0;
			nlll0i <= 0;
			nlll1i <= 0;
			nlll1l <= 0;
			nlll1O <= 0;
		end
		else if  (rbist_clr_rx == 1'b0) 
		if (clk_2 != ni0OO_clk_prev && clk_2 == 1'b1) 
		begin
			n11Oi <= ni01i;
			ni00l <= wire_n11ll_o;
			ni00O <= wire_nii0i_dataout;
			ni01i <= sync_status;
			ni0ii <= wire_nii0l_dataout;
			ni0il <= wire_nii0O_dataout;
			ni0iO <= wire_niiii_dataout;
			ni0li <= wire_niiil_dataout;
			ni0ll <= wire_n101i_o;
			ni0lO <= wire_n101l_o;
			ni0Oi <= wire_n101O_o;
			ni0Ol <= wire_n100i_o;
			nii1i <= wire_n100l_o;
			niilOO <= wire_ni1iiO_o;
			niiO0l <= wire_niO1Oi_dataout;
			niiO0O <= wire_niO1Ol_dataout;
			niiOii <= wire_niO1OO_dataout;
			niiOil <= wire_niO01i_dataout;
			niiOiO <= wire_niO01l_dataout;
			niiOli <= wire_niO01O_dataout;
			niiOll <= wire_niO00i_dataout;
			niiOlO <= wire_niO10i_dataout;
			niiOOi <= wire_niO10l_dataout;
			niiOOl <= wire_niO10O_dataout;
			niiOOO <= wire_niO1ii_dataout;
			nil00i <= wire_ni1iOi_o;
			nil00l <= wire_ni1iOl_o;
			nil00O <= wire_ni1iOO_o;
			nil01i <= nil00l;
			nil01l <= nil00O;
			nil01O <= wire_ni1ilO_o;
			nil10i <= wire_niO1ll_dataout;
			nil10l <= wire_niO00l_dataout;
			nil10O <= wire_niO00O_dataout;
			nil11i <= wire_niO1il_dataout;
			nil11l <= wire_niO1iO_dataout;
			nil11O <= wire_niO1li_dataout;
			nil1ii <= wire_niO0ii_dataout;
			nil1il <= wire_niO0il_dataout;
			nil1iO <= wire_niO0iO_dataout;
			nil1li <= wire_niO0li_dataout;
			nil1ll <= wire_niO0ll_dataout;
			nil1lO <= wire_niO0lO_dataout;
			nil1Oi <= wire_niO0Oi_dataout;
			nil1Ol <= nil01O;
			nil1OO <= nil00i;
			nl1Oll <= nll00l;
			nll00l <= sync_status;
			nll0il <= wire_nl011i_o;
			nll0iO <= wire_nlllii_dataout;
			nll0li <= wire_nlllil_dataout;
			nll0ll <= wire_nllliO_dataout;
			nll0lO <= wire_nlllli_dataout;
			nll0Oi <= wire_nlllll_dataout;
			nll0Ol <= wire_nllllO_dataout;
			nll0OO <= wire_nllO0l_dataout;
			nlli0i <= wire_nllOli_dataout;
			nlli0l <= wire_nllOll_dataout;
			nlli0O <= wire_nllOlO_dataout;
			nlli1i <= wire_nllO0O_dataout;
			nlli1l <= wire_nllOii_dataout;
			nlli1O <= wire_nllOiO_dataout;
			nlliii <= wire_nlO11O_dataout;
			nlliil <= wire_nlO10i_dataout;
			nlliiO <= wire_nlO10l_dataout;
			nllili <= wire_nlO10O_dataout;
			nllill <= wire_nlO1ii_dataout;
			nllilO <= wire_nlO1il_dataout;
			nlliOi <= wire_nlO1iO_dataout;
			nlliOl <= wire_nlO1li_dataout;
			nlliOO <= wire_nlO1ll_dataout;
			nlll0i <= wire_nl01ii_o;
			nlll1i <= wire_nl010i_o;
			nlll1l <= wire_nl010l_o;
			nlll1O <= wire_nl010O_o;
		end
		ni0OO_clk_prev <= clk_2;
	end
	assign
		wire_ni0OO_CLRN = ((n0Ol1i16 ^ n0Ol1i15) & (~ soft_reset)),
		wire_ni0OO_PRN = (n0OiOO18 ^ n0OiOO17);
	initial
	begin
		niiO0i = 0;
	end
	always @ (clk_2 or soft_reset or wire_niiO1O_CLRN)
	begin
		if (soft_reset == 1'b1) 
		begin
			niiO0i <= 1;
		end
		else if  (wire_niiO1O_CLRN == 1'b0) 
		begin
			niiO0i <= 0;
		end
		else if  (rbist_clr_rx == 1'b0) 
		if (clk_2 != niiO1O_clk_prev && clk_2 == 1'b1) 
		begin
			niiO0i <= wire_niO1lO_dataout;
		end
		niiO1O_clk_prev <= clk_2;
	end
	assign
		wire_niiO1O_CLRN = (n0li1O48 ^ n0li1O47);
	or(wire_n000i_dataout, ni01l, (~ n0O01O));
	or(wire_n000l_dataout, ni00i, (~ n0O01O));
	or(wire_n000O_dataout, wire_n00lO_dataout, (~ n0O01O));
	or(wire_n001i_dataout, nii1i, n0Oi1i);
	and(wire_n001l_dataout, wire_n00ll_dataout, ~((~ n0O01O)));
	and(wire_n001O_dataout, wire_n0i1l_dataout, ~((~ n0O01O)));
	assign		wire_n00i_dataout = (n0Olll === 1'b1) ? nlll0i : wire_n0iO_dataout;
	and(wire_n00ii_dataout, wire_n00Oi_dataout, ~((~ n0O01O)));
	or(wire_n00il_dataout, wire_n00Ol_dataout, (~ n0O01O));
	and(wire_n00iO_dataout, wire_n00OO_dataout, ~((~ n0O01O)));
	and(wire_n00l_dataout, wire_n0li_dataout, ~(n0Olll));
	or(wire_n00li_dataout, wire_n0i1i_dataout, (~ n0O01O));
	and(wire_n00ll_dataout, (~ n0O00i), n0OlOi);
	or(wire_n00lO_dataout, wire_n1Oii_dataout, ~(n0OlOi));
	and(wire_n00O_dataout, ni0ll, n0OllO);
	or(wire_n00Oi_dataout, wire_n1Oil_dataout, ~(n0OlOi));
	or(wire_n00Ol_dataout, wire_n1OiO_dataout, ~(n0OlOi));
	or(wire_n00OO_dataout, wire_n1Oli_dataout, ~(n0OlOi));
	and(wire_n010i_dataout, wire_n01iO_dataout, ~(n0OiiO));
	and(wire_n010l_dataout, wire_n01li_dataout, ~(n0OiiO));
	or(wire_n010O_dataout, wire_n01ll_dataout, n0OiiO);
	or(wire_n011i_dataout, wire_n010O_dataout, n0Oill);
	or(wire_n011l_dataout, wire_n01ii_dataout, n0OiiO);
	and(wire_n011O_dataout, wire_n01il_dataout, ~(n0OiiO));
	assign		wire_n01i_dataout = (n0Olll === 1'b1) ? nlll1i : wire_n00O_dataout;
	and(wire_n01ii_dataout, wire_n01lO_dataout, ~(n0Oiil));
	or(wire_n01il_dataout, wire_n01Oi_dataout, n0Oiil);
	and(wire_n01iO_dataout, wire_n01Ol_dataout, ~(n0Oiil));
	assign		wire_n01l_dataout = (n0Olll === 1'b1) ? nlll1l : wire_n0ii_dataout;
	and(wire_n01li_dataout, wire_n01OO_dataout, ~(n0Oiil));
	or(wire_n01ll_dataout, wire_n001i_dataout, n0Oiil);
	or(wire_n01lO_dataout, ni0ll, n0Oi1i);
	assign		wire_n01O_dataout = (n0Olll === 1'b1) ? nlll1O : wire_n0il_dataout;
	or(wire_n01Oi_dataout, ni0lO, n0Oi1i);
	and(wire_n01Ol_dataout, ni0Oi, ~(n0Oi1i));
	and(wire_n01OO_dataout, ni0Ol, ~(n0Oi1i));
	assign		wire_n0i_dataout = (n0OlOl === 1'b1) ? rxd[33] : rxd[17];
	or(wire_n0i0i_dataout, ni00i, (~ n0O00l));
	or(wire_n0i0l_dataout, ni01l, (~ n0O00O));
	or(wire_n0i0O_dataout, ni00i, (~ n0O00O));
	and(wire_n0i1i_dataout, wire_n1Oll_dataout, n0OlOi);
	and(wire_n0i1l_dataout, n0O00i, n0OlOi);
	or(wire_n0i1O_dataout, ni01l, (~ n0O00l));
	and(wire_n0ii_dataout, ni0lO, n0OllO);
	or(wire_n0iii_dataout, (~ n0OlOi), (~ n0O00O));
	and(wire_n0iil_dataout, n0OlOi, ~((~ n0O00O)));
	or(wire_n0iiO_dataout, ni01l, (~ n0O0ii));
	and(wire_n0il_dataout, ni0Oi, n0OllO);
	or(wire_n0ili_dataout, ni00i, (~ n0O0ii));
	or(wire_n0ill_dataout, ni01l, (~ n0O0il));
	or(wire_n0ilO_dataout, ni00i, (~ n0O0il));
	and(wire_n0iO_dataout, ni0Ol, n0OllO);
	or(wire_n0iOi_dataout, (~ n0OlOi), (~ n0O0il));
	and(wire_n0iOl_dataout, (~ n0OlOi), ~((~ n0O0il)));
	or(wire_n0iOO_dataout, n0OlOi, (~ n0O0il));
	assign		wire_n0l_dataout = (n0OlOl === 1'b1) ? rxd[34] : rxd[18];
	or(wire_n0l0i_dataout, ni00i, (~ n0O0li));
	or(wire_n0l0l_dataout, (~ n0OlOi), (~ n0O0li));
	and(wire_n0l0O_dataout, n0OlOi, ~((~ n0O0li)));
	or(wire_n0l1i_dataout, ni01l, (~ n0O0iO));
	or(wire_n0l1l_dataout, ni00i, (~ n0O0iO));
	or(wire_n0l1O_dataout, ni01l, (~ n0O0li));
	and(wire_n0li_dataout, nii1i, n0OllO);
	or(wire_n0lii_dataout, ni01l, (~ n0O0ll));
	or(wire_n0lil_dataout, ni00i, (~ n0O0ll));
	or(wire_n0liO_dataout, ni01l, (~ n0O0lO));
	or(wire_n0lli_dataout, ni00i, (~ n0O0lO));
	and(wire_n0lll_dataout, (~ n0OlOi), ~((~ n0O0lO)));
	or(wire_n0llO_dataout, (~ n0OlOi), (~ n0O0lO));
	and(wire_n0lOi_dataout, n0OlOi, ~((~ n0O0lO)));
	or(wire_n0lOl_dataout, ni01l, (~ n0O0Oi));
	or(wire_n0lOO_dataout, ni00i, (~ n0O0Oi));
	assign		wire_n0O_dataout = (n0OlOl === 1'b1) ? rxd[35] : rxd[19];
	and(wire_n0O0i_dataout, n0OlOi, ~((~ n0O0Ol)));
	and(wire_n0O0l_dataout, ni0ll, ~((~ n0Oi1i)));
	and(wire_n0O0O_dataout, ni0lO, ~((~ n0Oi1i)));
	or(wire_n0O1i_dataout, ni01l, (~ n0O0Ol));
	or(wire_n0O1l_dataout, ni00i, (~ n0O0Ol));
	or(wire_n0O1O_dataout, (~ n0OlOi), (~ n0O0Ol));
	and(wire_n0Oi_dataout, ni1lOl, n0Olli);
	or(wire_n0Oii_dataout, ni0Oi, (~ n0Oi1i));
	and(wire_n0Oil_dataout, ni0Ol, ~((~ n0Oi1i)));
	and(wire_n0OiO_dataout, nii1i, ~((~ n0Oi1i)));
	and(wire_n0Ol_dataout, niiilO, n0Olli);
	and(wire_n0Oli_dataout, wire_n0OOO_dataout, ~(n0Oili));
	assign		wire_n0Oll_dataout = (n0Oili === 1'b1) ? (~ n0OlOi) : wire_ni11i_dataout;
	assign		wire_n0OlO_dataout = (n0Oili === 1'b1) ? n0OlOi : wire_ni11l_dataout;
	and(wire_n0OO_dataout, niiiOi, n0Olli);
	and(wire_n0OOi_dataout, wire_ni11O_dataout, ~(n0Oili));
	and(wire_n0OOl_dataout, wire_ni10i_dataout, ~(n0Oili));
	and(wire_n0OOO_dataout, wire_ni10l_dataout, ~(n0Oi1l));
	and(wire_n100O_dataout, ni00i, ~((~ wire_ni_dataout)));
	and(wire_n10ii_dataout, ni01l, ~((~ wire_ni_dataout)));
	and(wire_n10il_dataout, ni0ll, ~((~ wire_ni_dataout)));
	and(wire_n10iO_dataout, ni0lO, ~((~ wire_ni_dataout)));
	and(wire_n10li_dataout, ni0Oi, ~((~ wire_ni_dataout)));
	and(wire_n10ll_dataout, ni0Ol, ~((~ wire_ni_dataout)));
	and(wire_n10lO_dataout, nii1i, ~((~ wire_ni_dataout)));
	or(wire_n10Oi_dataout, ni00l, ~(n0O1il));
	or(wire_n10Ol_dataout, wire_n1i1l_dataout, n0O1il);
	or(wire_n10OO_dataout, ni00i, n0O1il);
	or(wire_n1i0i_dataout, ni00l, ~((~ n0O1li)));
	or(wire_n1i0l_dataout, wire_n1i1l_dataout, (~ n0O1li));
	or(wire_n1i0O_dataout, ni00i, (~ n0O1li));
	or(wire_n1i1i_dataout, ni00l, n0O1il);
	or(wire_n1i1l_dataout, ni01l, ni00l);
	or(wire_n1iii_dataout, ni00l, (~ n0O1li));
	or(wire_n1iil_dataout, ni00l, ~((~ n0O1ll)));
	or(wire_n1iiO_dataout, wire_n1i1l_dataout, (~ n0O1ll));
	or(wire_n1ili_dataout, ni00i, (~ n0O1ll));
	or(wire_n1ill_dataout, ni00l, (~ n0O1ll));
	or(wire_n1ilO_dataout, ni00l, ~((~ n0O1lO)));
	or(wire_n1iOi_dataout, wire_n1i1l_dataout, (~ n0O1lO));
	or(wire_n1iOl_dataout, ni00i, (~ n0O1lO));
	or(wire_n1iOO_dataout, ni00l, (~ n0O1lO));
	assign		wire_n1l_dataout = (n0OlOl === 1'b1) ? rxc[2] : rxc[1];
	or(wire_n1l0i_dataout, (~ n0O01i), n0OlOi);
	or(wire_n1l0l_dataout, wire_n1lll_dataout, ~(n0OlOi));
	or(wire_n1l0O_dataout, ni01l, (~ n0O01i));
	assign		wire_n1l1i_dataout = (n0OlOi === 1'b1) ? wire_n1lil_dataout : ni00l;
	assign		wire_n1l1l_dataout = (n0OlOi === 1'b1) ? wire_n1liO_dataout : wire_n1l0O_dataout;
	assign		wire_n1l1O_dataout = (n0OlOi === 1'b1) ? wire_n1lli_dataout : wire_n1lii_dataout;
	or(wire_n1lii_dataout, ni00i, (~ n0O01i));
	or(wire_n1lil_dataout, ni00l, ~(n0O1Oi));
	or(wire_n1liO_dataout, wire_n1i1l_dataout, n0O1Oi);
	assign		wire_n1ll_dataout = (n0Olli === 1'b1) ? nil01O : wire_n01i_dataout;
	or(wire_n1lli_dataout, ni00i, n0O1Oi);
	or(wire_n1lll_dataout, ni00l, n0O1Oi);
	assign		wire_n1lO_dataout = (n0Olli === 1'b1) ? nil00i : wire_n01l_dataout;
	and(wire_n1lOi_dataout, (~ n0O00i), ~((~ n0O01l)));
	and(wire_n1lOl_dataout, n0O00i, ~((~ n0O01l)));
	or(wire_n1lOO_dataout, ni01l, (~ n0O01l));
	assign		wire_n1O_dataout = (n0OlOl === 1'b1) ? rxd[32] : rxd[16];
	or(wire_n1O0i_dataout, wire_n1OiO_dataout, (~ n0O01l));
	and(wire_n1O0l_dataout, wire_n1Oli_dataout, ~((~ n0O01l)));
	or(wire_n1O0O_dataout, wire_n1Oll_dataout, (~ n0O01l));
	or(wire_n1O1i_dataout, ni00i, (~ n0O01l));
	or(wire_n1O1l_dataout, wire_n1Oii_dataout, (~ n0O01l));
	and(wire_n1O1O_dataout, wire_n1Oil_dataout, ~((~ n0O01l)));
	assign		wire_n1Oi_dataout = (n0Olli === 1'b1) ? nil00l : wire_n01O_dataout;
	and(wire_n1Oii_dataout, wire_n1OlO_dataout, n0O00i);
	and(wire_n1Oil_dataout, wire_n1OOi_dataout, n0O00i);
	or(wire_n1OiO_dataout, wire_n1OOl_dataout, ~(n0O00i));
	assign		wire_n1Ol_dataout = (n0Olli === 1'b1) ? nil00O : wire_n00i_dataout;
	and(wire_n1Oli_dataout, wire_n1OOO_dataout, n0O00i);
	and(wire_n1Oll_dataout, wire_n011i_dataout, n0O00i);
	and(wire_n1OlO_dataout, wire_n011l_dataout, ~(n0Oill));
	and(wire_n1OO_dataout, wire_n00l_dataout, ~(n0Olli));
	and(wire_n1OOi_dataout, wire_n011O_dataout, ~(n0Oill));
	and(wire_n1OOl_dataout, wire_n010i_dataout, ~(n0Oill));
	and(wire_n1OOO_dataout, wire_n010l_dataout, ~(n0Oill));
	and(wire_ni_dataout, rbisten_rx, (((~ rbist_sel[0]) & rbist_sel[1]) & (n0OO1l4 ^ n0OO1l3)));
	assign		wire_ni000i_dataout = (n0OlOi === 1'b1) ? n0l11O : n0l11i;
	or(wire_ni000l_dataout, niiO1i, n0l11i);
	or(wire_ni000O_dataout, niiO1l, n0l11i);
	assign		wire_ni001i_dataout = (n0OlOi === 1'b1) ? wire_ni00il_dataout : wire_ni000l_dataout;
	assign		wire_ni001l_dataout = (n0OlOi === 1'b1) ? wire_ni00iO_dataout : wire_ni000O_dataout;
	or(wire_ni001O_dataout, n0l11i, n0OlOi);
	or(wire_ni00il_dataout, niiO1i, n0l11O);
	or(wire_ni00iO_dataout, niiO1l, n0l11O);
	or(wire_ni00ll_dataout, niiO1i, n0l10l);
	or(wire_ni00lO_dataout, niiO1l, n0l10l);
	assign		wire_ni00Ol_dataout = (n0OlOi === 1'b1) ? wire_ni0iii_dataout : wire_ni0i0i_dataout;
	assign		wire_ni00OO_dataout = (n0OlOi === 1'b1) ? wire_ni0iil_dataout : wire_ni0i0l_dataout;
	or(wire_ni010i_dataout, n0iOli, n0OlOi);
	assign		wire_ni010l_dataout = (n0OlOi === 1'b1) ? (~ n0iOlO) : (~ n0iOli);
	assign		wire_ni010O_dataout = (n0OlOi === 1'b1) ? n0iOlO : n0iOli;
	assign		wire_ni011l_dataout = (n0OlOi === 1'b1) ? wire_ni01li_dataout : wire_ni01ii_dataout;
	assign		wire_ni011O_dataout = (n0OlOi === 1'b1) ? wire_ni01ll_dataout : wire_ni01il_dataout;
	or(wire_ni01ii_dataout, niiO1i, n0iOli);
	or(wire_ni01il_dataout, niiO1l, n0iOli);
	or(wire_ni01li_dataout, niiO1i, n0iOlO);
	or(wire_ni01ll_dataout, niiO1l, n0iOlO);
	or(wire_ni01Oi_dataout, niiO1i, n0iOOl);
	or(wire_ni01Ol_dataout, niiO1l, n0iOOl);
	and(wire_ni0i_dataout, niil1l, n0Olli);
	or(wire_ni0i0i_dataout, niiO1i, n0l1ii);
	or(wire_ni0i0l_dataout, niiO1l, n0l1ii);
	or(wire_ni0i1i_dataout, n0l1ii, n0OlOi);
	assign		wire_ni0i1l_dataout = (n0OlOi === 1'b1) ? (~ n0l1iO) : (~ n0l1ii);
	assign		wire_ni0i1O_dataout = (n0OlOi === 1'b1) ? n0l1iO : n0l1ii;
	or(wire_ni0iii_dataout, niiO1i, n0l1iO);
	or(wire_ni0iil_dataout, niiO1l, n0l1iO);
	or(wire_ni0ili_dataout, niiO1i, n0l1ll);
	or(wire_ni0ill_dataout, niiO1l, n0l1ll);
	assign		wire_ni0iOi_dataout = (n0OlOi === 1'b1) ? wire_ni0l0l_dataout : wire_ni0l1l_dataout;
	assign		wire_ni0iOl_dataout = (n0OlOi === 1'b1) ? wire_ni0l0O_dataout : wire_ni0l1O_dataout;
	or(wire_ni0iOO_dataout, n0l1Oi, n0OlOi);
	and(wire_ni0l_dataout, niil1O, n0Olli);
	or(wire_ni0l0l_dataout, niiO1i, n0l01i);
	or(wire_ni0l0O_dataout, niiO1l, n0l01i);
	assign		wire_ni0l1i_dataout = (n0OlOi === 1'b1) ? n0l01i : n0l1Oi;
	or(wire_ni0l1l_dataout, niiO1i, n0l1Oi);
	or(wire_ni0l1O_dataout, niiO1l, n0l1Oi);
	or(wire_ni0lil_dataout, niiO1i, n0l0ii);
	or(wire_ni0liO_dataout, niiO1l, n0l0ii);
	or(wire_ni0lli_dataout, wire_ni0lOl_dataout, n0l0ii);
	and(wire_ni0lll_dataout, wire_ni0lOO_dataout, ~(n0l0ii));
	or(wire_ni0llO_dataout, wire_ni0O1i_dataout, n0l0ii);
	or(wire_ni0lOi_dataout, wire_ni0O1l_dataout, n0l0ii);
	or(wire_ni0lOl_dataout, wire_ni0O1O_dataout, n0l00l);
	or(wire_ni0lOO_dataout, wire_ni0O0i_dataout, n0l00l);
	and(wire_ni0O_dataout, niil0i, n0Olli);
	or(wire_ni0O0i_dataout, nil00i, n0l00i);
	and(wire_ni0O0l_dataout, nil00l, ~(n0l00i));
	and(wire_ni0O0O_dataout, nil00O, ~(n0l00i));
	and(wire_ni0O1i_dataout, wire_ni0O0l_dataout, ~(n0l00l));
	and(wire_ni0O1l_dataout, wire_ni0O0O_dataout, ~(n0l00l));
	or(wire_ni0O1O_dataout, nil01O, n0l00i);
	or(wire_ni0OiO_dataout, wire_nii11i_dataout, n0l0Ol);
	or(wire_ni0Oli_dataout, niiO1i, n0l0Ol);
	or(wire_ni0Oll_dataout, niiO1l, n0l0Ol);
	or(wire_ni0OlO_dataout, wire_nii11l_dataout, n0l0Ol);
	and(wire_ni0OOi_dataout, wire_nii11O_dataout, ~(n0l0Ol));
	or(wire_ni0OOl_dataout, wire_nii10i_dataout, n0l0Ol);
	or(wire_ni0OOO_dataout, wire_nii10l_dataout, n0l0Ol);
	and(wire_ni10i_dataout, wire_ni1iO_dataout, ~(n0Oi1l));
	assign		wire_ni10l_dataout = (n0O0OO === 1'b1) ? (~ n0OlOi) : ni0ll;
	assign		wire_ni10O_dataout = (n0O0OO === 1'b1) ? (~ n0OlOi) : ni0lO;
	assign		wire_ni11i_dataout = (n0Oi1l === 1'b1) ? (~ n0OlOi) : wire_ni10O_dataout;
	assign		wire_ni11l_dataout = (n0Oi1l === 1'b1) ? n0OlOi : wire_ni1ii_dataout;
	and(wire_ni11O_dataout, wire_ni1il_dataout, ~(n0Oi1l));
	and(wire_ni1i_dataout, niiiOl, n0Olli);
	assign		wire_ni1ii_dataout = (n0O0OO === 1'b1) ? n0OlOi : ni0Oi;
	and(wire_ni1il_dataout, ni0Ol, ~(n0O0OO));
	and(wire_ni1iO_dataout, nii1i, ~(n0O0OO));
	and(wire_ni1l_dataout, niiiOO, n0Olli);
	and(wire_ni1l0i_dataout, nil01O, ~((~ wire_nO_dataout)));
	and(wire_ni1l0l_dataout, nil00i, ~((~ wire_nO_dataout)));
	and(wire_ni1l0O_dataout, nil00l, ~((~ wire_nO_dataout)));
	and(wire_ni1l1i_dataout, niilOO, ~((~ wire_nO_dataout)));
	and(wire_ni1l1l_dataout, niiO1i, ~((~ wire_nO_dataout)));
	and(wire_ni1l1O_dataout, niiO1l, ~((~ wire_nO_dataout)));
	and(wire_ni1lii_dataout, nil00O, ~((~ wire_nO_dataout)));
	or(wire_ni1lil_dataout, niilOO, ~(n0iO1l));
	or(wire_ni1liO_dataout, niiO1i, n0iO1l);
	or(wire_ni1lli_dataout, wire_ni1llO_dataout, n0iO1l);
	or(wire_ni1lll_dataout, niilOO, n0iO1l);
	or(wire_ni1llO_dataout, niiO1l, niilOO);
	assign		wire_ni1lOO_dataout = (n0OlOi === 1'b1) ? wire_ni1OiO_dataout : niilOO;
	and(wire_ni1O_dataout, niil1i, n0Olli);
	or(wire_ni1O0i_dataout, n0iO0i, n0OlOi);
	or(wire_ni1O0l_dataout, wire_ni1OlO_dataout, ~(n0OlOi));
	or(wire_ni1O0O_dataout, niiO1i, n0iO0i);
	assign		wire_ni1O1i_dataout = (n0OlOi === 1'b1) ? n0iO0O : n0iO0i;
	assign		wire_ni1O1l_dataout = (n0OlOi === 1'b1) ? wire_ni1Oli_dataout : wire_ni1O0O_dataout;
	assign		wire_ni1O1O_dataout = (n0OlOi === 1'b1) ? wire_ni1Oll_dataout : wire_ni1Oii_dataout;
	or(wire_ni1Oii_dataout, niiO1l, n0iO0i);
	or(wire_ni1OiO_dataout, niilOO, ~(n0iO0O));
	or(wire_ni1Oli_dataout, niiO1i, n0iO0O);
	or(wire_ni1Oll_dataout, wire_ni1llO_dataout, n0iO0O);
	or(wire_ni1OlO_dataout, niilOO, n0iO0O);
	or(wire_ni1OOl_dataout, niiO1i, n0iOil);
	or(wire_ni1OOO_dataout, niiO1l, n0iOil);
	assign		wire_nii_dataout = (n0OlOl === 1'b1) ? rxd[36] : rxd[20];
	or(wire_nii00i_dataout, nil01O, n0li1l);
	and(wire_nii00l_dataout, nil00i, ~(n0li1l));
	and(wire_nii00O_dataout, nil00l, ~(n0li1l));
	assign		wire_nii0i_dataout = (wire_n11ii_o === 1'b1) ? wire_niiOl_o[0] : wire_niiiO_dataout;
	and(wire_nii0ii_dataout, nil00O, ~(n0li1l));
	assign		wire_nii0l_dataout = (wire_n11ii_o === 1'b1) ? wire_niiOl_o[1] : wire_niili_dataout;
	or(wire_nii0ll_dataout, wire_niOi0i_dataout, ~(wire_nii0Ol_o[2]));
	assign		wire_nii0O_dataout = (wire_n11ii_o === 1'b1) ? wire_niiOl_o[2] : wire_niill_dataout;
	or(wire_nii0Oi_dataout, wire_niOi0O_dataout, ~(wire_nii0Ol_o[2]));
	and(wire_nii10i_dataout, wire_nii1il_dataout, ~(n0l0ll));
	and(wire_nii10l_dataout, wire_nii1iO_dataout, ~(n0l0ll));
	and(wire_nii10O_dataout, nil01O, ~(n0l0iO));
	and(wire_nii11i_dataout, (~ n0l0iO), ~(n0l0ll));
	and(wire_nii11l_dataout, wire_nii10O_dataout, ~(n0l0ll));
	or(wire_nii11O_dataout, wire_nii1ii_dataout, n0l0ll);
	or(wire_nii1ii_dataout, nil00i, n0l0iO);
	and(wire_nii1il_dataout, nil00l, ~(n0l0iO));
	and(wire_nii1iO_dataout, nil00O, ~(n0l0iO));
	and(wire_nii1l_dataout, wire_n11OO_o, ~(rbist_clr_rx));
	and(wire_nii1O_dataout, wire_n11Ol_o, ~(rbist_clr_rx));
	and(wire_niii_dataout, niil0l, n0Olli);
	assign		wire_niiii_dataout = (wire_n11ii_o === 1'b1) ? wire_niiOl_o[3] : wire_niilO_dataout;
	assign		wire_niiil_dataout = (wire_n11ii_o === 1'b1) ? wire_niiOl_o[4] : wire_niiOi_dataout;
	and(wire_niiiO_dataout, ni00O, ~(wire_n11il_o));
	and(wire_niil_dataout, niil0O, n0Olli);
	and(wire_niili_dataout, ni0ii, ~(wire_n11il_o));
	and(wire_niill_dataout, ni0il, ~(wire_n11il_o));
	and(wire_niilO_dataout, ni0iO, ~(wire_n11il_o));
	and(wire_niiO_dataout, niilii, n0Olli);
	and(wire_niiOi_dataout, ni0li, ~(wire_n11il_o));
	assign		wire_nil_dataout = (n0OlOl === 1'b1) ? rxd[37] : rxd[21];
	and(wire_nil0ii_dataout, wire_niliOi_dataout, ~(rbist_clr_rx));
	and(wire_nil0il_dataout, wire_niliOl_dataout, ~(rbist_clr_rx));
	and(wire_nil0iO_dataout, wire_niliOO_dataout, ~(rbist_clr_rx));
	and(wire_nil0li_dataout, wire_nill1i_dataout, ~(rbist_clr_rx));
	and(wire_nil0ll_dataout, wire_nill1l_dataout, ~(rbist_clr_rx));
	and(wire_nil0lO_dataout, wire_nill1O_dataout, ~(rbist_clr_rx));
	and(wire_nil0Oi_dataout, wire_nill0i_dataout, ~(rbist_clr_rx));
	and(wire_nil0Ol_dataout, wire_nill0l_dataout, ~(rbist_clr_rx));
	and(wire_nil0OO_dataout, wire_nill0O_dataout, ~(rbist_clr_rx));
	and(wire_nili_dataout, niilil, n0Olli);
	and(wire_nili0i_dataout, wire_nillli_dataout, ~(rbist_clr_rx));
	and(wire_nili0l_dataout, wire_nillll_dataout, ~(rbist_clr_rx));
	and(wire_nili0O_dataout, wire_nilllO_dataout, ~(rbist_clr_rx));
	and(wire_nili1i_dataout, wire_nillii_dataout, ~(rbist_clr_rx));
	and(wire_nili1l_dataout, wire_nillil_dataout, ~(rbist_clr_rx));
	and(wire_nili1O_dataout, wire_nilliO_dataout, ~(rbist_clr_rx));
	and(wire_niliii_dataout, wire_nillOi_dataout, ~(rbist_clr_rx));
	and(wire_niliil_dataout, wire_nillOl_dataout, ~(rbist_clr_rx));
	and(wire_niliiO_dataout, wire_nillOO_dataout, ~(rbist_clr_rx));
	and(wire_nilili_dataout, wire_ni1iil_o, ~(rbist_clr_rx));
	and(wire_nilill_dataout, wire_ni1ili_o, ~(rbist_clr_rx));
	and(wire_nililO_dataout, wire_ni1ill_o, ~(rbist_clr_rx));
	and(wire_niliOi_dataout, wire_nilO1i_dataout, ~((~ wire_nO_dataout)));
	and(wire_niliOl_dataout, wire_nilO1l_dataout, ~((~ wire_nO_dataout)));
	and(wire_niliOO_dataout, wire_nilO1O_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill_dataout, niiliO, n0Olli);
	and(wire_nill0i_dataout, wire_nilOii_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill0l_dataout, wire_nilOil_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill0O_dataout, wire_nilOiO_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill1i_dataout, wire_nilO0i_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill1l_dataout, wire_nilO0l_dataout, ~((~ wire_nO_dataout)));
	and(wire_nill1O_dataout, wire_nilO0O_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillii_dataout, wire_nilOli_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillil_dataout, wire_nilOll_dataout, ~((~ wire_nO_dataout)));
	and(wire_nilliO_dataout, wire_nilOlO_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillli_dataout, wire_nilOOi_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillll_dataout, wire_nilOOl_dataout, ~((~ wire_nO_dataout)));
	and(wire_nilllO_dataout, wire_nilOOO_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillOi_dataout, wire_niO11i_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillOl_dataout, wire_niO11l_dataout, ~((~ wire_nO_dataout)));
	and(wire_nillOO_dataout, wire_niO11O_dataout, ~((~ wire_nO_dataout)));
	and(wire_nilO_dataout, niilli, n0Olli);
	assign		wire_nilO0i_dataout = (niilOl === 1'b1) ? wire_nii0lO_o : niiiOl;
	assign		wire_nilO0l_dataout = (niilOl === 1'b1) ? wire_nii0Oi_dataout : niiiOO;
	assign		wire_nilO0O_dataout = (niilOl === 1'b1) ? wire_nii0OO_o : niil1i;
	assign		wire_nilO1i_dataout = (niilOl === 1'b1) ? wire_nii0iO_o : ni1lOl;
	assign		wire_nilO1l_dataout = (niilOl === 1'b1) ? wire_nii0li_o : niiilO;
	assign		wire_nilO1O_dataout = (niilOl === 1'b1) ? wire_nii0ll_dataout : niiiOi;
	assign		wire_nilOii_dataout = (niilOl === 1'b1) ? wire_niii1i_o : niil1l;
	assign		wire_nilOil_dataout = (niilOl === 1'b1) ? wire_niii1l_o : niil1O;
	assign		wire_nilOiO_dataout = (niilOl === 1'b1) ? wire_niii1O_o : niil0i;
	assign		wire_nilOli_dataout = (niilOl === 1'b1) ? wire_niii0i_o : niil0l;
	assign		wire_nilOll_dataout = (niilOl === 1'b1) ? wire_niii0l_o : niil0O;
	assign		wire_nilOlO_dataout = (niilOl === 1'b1) ? wire_niii0O_o : niilii;
	assign		wire_nilOOi_dataout = (niilOl === 1'b1) ? wire_niiiii_o : niilil;
	assign		wire_nilOOl_dataout = (niilOl === 1'b1) ? wire_niiiil_o : niiliO;
	assign		wire_nilOOO_dataout = (niilOl === 1'b1) ? wire_niiiiO_o : niilli;
	assign		wire_niO_dataout = (n0OlOl === 1'b1) ? rxd[38] : rxd[22];
	and(wire_niO00i_dataout, wire_niO0OO_o[6], wire_ni1i0l_o);
	and(wire_niO00l_dataout, wire_niOi1i_o[0], wire_ni1i0l_o);
	and(wire_niO00O_dataout, wire_niOi1i_o[1], wire_ni1i0l_o);
	and(wire_niO01i_dataout, wire_niO0OO_o[3], wire_ni1i0l_o);
	and(wire_niO01l_dataout, wire_niO0OO_o[4], wire_ni1i0l_o);
	and(wire_niO01O_dataout, wire_niO0OO_o[5], wire_ni1i0l_o);
	and(wire_niO0ii_dataout, wire_niOi1i_o[2], wire_ni1i0l_o);
	and(wire_niO0il_dataout, wire_niOi1i_o[3], wire_ni1i0l_o);
	and(wire_niO0iO_dataout, wire_niOi1i_o[4], wire_ni1i0l_o);
	and(wire_niO0li_dataout, wire_niOi1i_o[5], wire_ni1i0l_o);
	and(wire_niO0ll_dataout, wire_niOi1i_o[6], wire_ni1i0l_o);
	and(wire_niO0lO_dataout, wire_niOi1i_o[7], wire_ni1i0l_o);
	and(wire_niO0Oi_dataout, wire_niOi1i_o[8], wire_ni1i0l_o);
	and(wire_niO10i_dataout, niiOlO, wire_ni1i0l_o);
	and(wire_niO10l_dataout, wire_niO0Ol_o[0], wire_ni1i0l_o);
	and(wire_niO10O_dataout, wire_niO0Ol_o[1], wire_ni1i0l_o);
	assign		wire_niO11i_dataout = (niilOl === 1'b1) ? wire_niiili_o : niilll;
	assign		wire_niO11l_dataout = (niilOl === 1'b1) ? (~ wire_nii0Ol_o[2]) : niillO;
	assign		wire_niO11O_dataout = (niilOl === 1'b1) ? wire_niiill_o : niilOi;
	and(wire_niO1ii_dataout, wire_niO0Ol_o[2], wire_ni1i0l_o);
	and(wire_niO1il_dataout, wire_niO0Ol_o[3], wire_ni1i0l_o);
	and(wire_niO1iO_dataout, wire_niO0Ol_o[4], wire_ni1i0l_o);
	and(wire_niO1li_dataout, wire_niO0Ol_o[5], wire_ni1i0l_o);
	and(wire_niO1ll_dataout, wire_niO0Ol_o[6], wire_ni1i0l_o);
	or(wire_niO1lO_dataout, niiO0i, ~(wire_ni1i0l_o));
	and(wire_niO1Oi_dataout, wire_niO0OO_o[0], wire_ni1i0l_o);
	and(wire_niO1Ol_dataout, wire_niO0OO_o[1], wire_ni1i0l_o);
	and(wire_niO1OO_dataout, wire_niO0OO_o[2], wire_ni1i0l_o);
	and(wire_niOi_dataout, niilll, n0Olli);
	assign		wire_niOi0i_dataout = (n0OlOi === 1'b1) ? niiOOl : nil1ii;
	assign		wire_niOi0l_dataout = (n0OlOi === 1'b1) ? niiOOO : nil1il;
	assign		wire_niOi0O_dataout = (n0OlOi === 1'b1) ? nil11i : nil1iO;
	assign		wire_niOi1l_dataout = (n0OlOi === 1'b1) ? niiOlO : nil10l;
	assign		wire_niOi1O_dataout = (n0OlOi === 1'b1) ? niiOOi : nil10O;
	assign		wire_niOiii_dataout = (n0OlOi === 1'b1) ? nil11l : nil1li;
	assign		wire_niOiil_dataout = (n0OlOi === 1'b1) ? nil11O : nil1ll;
	assign		wire_niOiiO_dataout = (n0OlOi === 1'b1) ? nil10i : nil1lO;
	and(wire_niOili_dataout, niiO0i, n0OlOi);
	and(wire_niOill_dataout, niiO0l, n0OlOi);
	and(wire_niOilO_dataout, niiO0O, n0OlOi);
	and(wire_niOiOi_dataout, niiOii, n0OlOi);
	and(wire_niOiOl_dataout, niiOil, n0OlOi);
	and(wire_niOiOO_dataout, niiOiO, n0OlOi);
	and(wire_niOl_dataout, niillO, n0Olli);
	and(wire_niOl1i_dataout, niiOli, n0OlOi);
	and(wire_niOl1l_dataout, niiOll, n0OlOi);
	and(wire_niOO_dataout, niilOi, n0Olli);
	and(wire_nl_dataout, rbisten_rx, (rbist_sel[0] & (~ rbist_sel[1])));
	or(wire_nl000l_dataout, nll0il, ~((~ n0li0O)));
	or(wire_nl000O_dataout, wire_nl001O_dataout, (~ n0li0O));
	or(wire_nl001i_dataout, nll0ii, n0li0i);
	or(wire_nl001l_dataout, nll0il, n0li0i);
	or(wire_nl001O_dataout, nll00O, nll0il);
	or(wire_nl00ii_dataout, nll0ii, (~ n0li0O));
	or(wire_nl00il_dataout, nll0il, (~ n0li0O));
	or(wire_nl00iO_dataout, nll0il, ~((~ n0liii)));
	or(wire_nl00li_dataout, wire_nl001O_dataout, (~ n0liii));
	or(wire_nl00ll_dataout, nll0ii, (~ n0liii));
	or(wire_nl00lO_dataout, nll0il, (~ n0liii));
	or(wire_nl00Oi_dataout, nll0il, ~((~ n0liil)));
	or(wire_nl00Ol_dataout, wire_nl001O_dataout, (~ n0liil));
	or(wire_nl00OO_dataout, nll0ii, (~ n0liil));
	and(wire_nl01il_dataout, nll0ii, ~((~ wire_nl_dataout)));
	and(wire_nl01iO_dataout, nll00O, ~((~ wire_nl_dataout)));
	and(wire_nl01li_dataout, nlll1i, ~((~ wire_nl_dataout)));
	and(wire_nl01ll_dataout, nlll1l, ~((~ wire_nl_dataout)));
	and(wire_nl01lO_dataout, nlll1O, ~((~ wire_nl_dataout)));
	and(wire_nl01Oi_dataout, nlll0i, ~((~ wire_nl_dataout)));
	or(wire_nl01Ol_dataout, nll0il, ~(n0li0i));
	or(wire_nl01OO_dataout, wire_nl001O_dataout, n0li0i);
	assign		wire_nl0i_dataout = (n0Olll === 1'b1) ? nll00O : wire_nl0O_dataout;
	assign		wire_nl0i0i_dataout = (n0OlOi === 1'b1) ? wire_nl0ill_dataout : wire_nl0iil_dataout;
	or(wire_nl0i0l_dataout, (~ n0lili), n0OlOi);
	or(wire_nl0i0O_dataout, wire_nl0ilO_dataout, ~(n0OlOi));
	or(wire_nl0i1i_dataout, nll0il, (~ n0liil));
	assign		wire_nl0i1l_dataout = (n0OlOi === 1'b1) ? wire_nl0iiO_dataout : nll0il;
	assign		wire_nl0i1O_dataout = (n0OlOi === 1'b1) ? wire_nl0ili_dataout : wire_nl0iii_dataout;
	or(wire_nl0iii_dataout, nll00O, (~ n0lili));
	or(wire_nl0iil_dataout, nll0ii, (~ n0lili));
	or(wire_nl0iiO_dataout, nll0il, ~(n0liiO));
	or(wire_nl0ili_dataout, wire_nl001O_dataout, n0liiO);
	or(wire_nl0ill_dataout, nll0ii, n0liiO);
	or(wire_nl0ilO_dataout, nll0il, n0liiO);
	and(wire_nl0iOl_dataout, wire_nl0l0O_dataout, ~((~ n0lill)));
	and(wire_nl0iOO_dataout, wire_nl0l0l_dataout, ~((~ n0lill)));
	and(wire_nl0l_dataout, ni00i, n0OllO);
	or(wire_nl0l0i_dataout, wire_nl0l0O_dataout, (~ n0lill));
	assign		wire_nl0l0l_dataout = (n0OlOi === 1'b1) ? n0lilO : n0liOi;
	assign		wire_nl0l0O_dataout = (n0OlOi === 1'b1) ? (~ n0lilO) : (~ n0liOi);
	or(wire_nl0l1i_dataout, nll00O, (~ n0lill));
	or(wire_nl0l1l_dataout, nll0ii, (~ n0lill));
	or(wire_nl0l1O_dataout, wire_nl0l0l_dataout, (~ n0lill));
	or(wire_nl0lii_dataout, nll00O, (~ n0liOl));
	or(wire_nl0lil_dataout, nll0ii, (~ n0liOl));
	and(wire_nl0liO_dataout, n0OlOi, ~((~ n0liOO)));
	or(wire_nl0lli_dataout, nll00O, (~ n0liOO));
	or(wire_nl0lll_dataout, nll0ii, (~ n0liOO));
	or(wire_nl0llO_dataout, wire_nl0O1i_dataout, (~ n0liOO));
	or(wire_nl0lOi_dataout, wire_nl0O1l_dataout, (~ n0liOO));
	or(wire_nl0lOl_dataout, wire_nl0O1O_dataout, (~ n0liOO));
	or(wire_nl0lOO_dataout, wire_nl0O0i_dataout, (~ n0liOO));
	and(wire_nl0O_dataout, ni01l, n0OllO);
	and(wire_nl0O0i_dataout, wire_nl0Oil_dataout, n0OlOi);
	or(wire_nl0O0l_dataout, wire_nl0OiO_dataout, n0ll1i);
	and(wire_nl0O0O_dataout, wire_nl0Oli_dataout, ~(n0ll1i));
	and(wire_nl0O1i_dataout, wire_nl0O0l_dataout, n0OlOi);
	or(wire_nl0O1l_dataout, wire_nl0O0O_dataout, ~(n0OlOi));
	or(wire_nl0O1O_dataout, wire_nl0Oii_dataout, ~(n0OlOi));
	or(wire_nl0Oii_dataout, wire_nl0Oll_dataout, n0ll1i);
	and(wire_nl0Oil_dataout, wire_nl0OlO_dataout, ~(n0ll1i));
	or(wire_nl0OiO_dataout, wire_nl0OOi_dataout, ~(n0ll1l));
	or(wire_nl0Oli_dataout, wire_nl0OOl_dataout, ~(n0ll1l));
	or(wire_nl0Oll_dataout, wire_nl0OOO_dataout, ~(n0ll1l));
	and(wire_nl0OlO_dataout, wire_nli11i_dataout, n0ll1l);
	and(wire_nl0OOi_dataout, wire_nli11l_dataout, ~(n0lOiO));
	or(wire_nl0OOl_dataout, wire_nli11O_dataout, n0lOiO);
	and(wire_nl0OOO_dataout, wire_nli10i_dataout, ~(n0lOiO));
	assign		wire_nl1i_dataout = (n0Olli === 1'b1) ? niiO1i : wire_nl1O_dataout;
	assign		wire_nl1l_dataout = (n0Olli === 1'b1) ? niiO1l : wire_nl0i_dataout;
	assign		wire_nl1O_dataout = (n0Olll === 1'b1) ? nll0ii : wire_nl0l_dataout;
	and(wire_nl1Oii_dataout, wire_nliill_dataout, wire_nl1OiO_o[5]);
	and(wire_nl1Oil_dataout, n0llil, wire_nl1OiO_o[5]);
	and(wire_nl1Oli_dataout, wire_nli1Ol_dataout, wire_nl1OiO_o[6]);
	and(wire_nl1OlO_dataout, wire_nli1OO_dataout, wire_nl1OiO_o[6]);
	and(wire_nl1OOi_dataout, wire_nl0liO_dataout, wire_nl1OiO_o[7]);
	and(wire_nl1OOl_dataout, wire_nl0iOl_dataout, wire_nl1OiO_o[8]);
	and(wire_nl1OOO_dataout, wire_nl0iOO_dataout, wire_nl1OiO_o[8]);
	assign		wire_nli_dataout = (n0OlOl === 1'b1) ? rxd[39] : rxd[23];
	or(wire_nli00i_dataout, wire_nli0li_dataout, (~ n0ll1O));
	or(wire_nli00l_dataout, wire_nli0ll_dataout, (~ n0ll1O));
	or(wire_nli00O_dataout, wire_nli0lO_dataout, (~ n0ll1O));
	or(wire_nli01i_dataout, nll00O, (~ n0ll1O));
	or(wire_nli01l_dataout, nll0ii, (~ n0ll1O));
	or(wire_nli01O_dataout, wire_nli0iO_dataout, (~ n0ll1O));
	or(wire_nli0ii_dataout, (~ n0ll0i), ~(n0OlOi));
	and(wire_nli0il_dataout, n0ll0i, n0OlOi);
	assign		wire_nli0iO_dataout = (n0OlOi === 1'b1) ? n0ll0i : wire_nli0Oi_dataout;
	assign		wire_nli0li_dataout = (n0OlOi === 1'b1) ? (~ n0ll0i) : wire_nli0Ol_dataout;
	assign		wire_nli0ll_dataout = (n0OlOi === 1'b1) ? (~ n0ll0i) : wire_nli0OO_dataout;
	assign		wire_nli0lO_dataout = (n0OlOi === 1'b1) ? n0ll0i : wire_nlii1i_dataout;
	or(wire_nli0Oi_dataout, wire_nlii1l_dataout, n0llii);
	and(wire_nli0Ol_dataout, wire_nlii1O_dataout, ~(n0llii));
	and(wire_nli0OO_dataout, wire_nlii0i_dataout, ~(n0llii));
	and(wire_nli10i_dataout, wire_nli1il_dataout, ~(n0lO1l));
	or(wire_nli10l_dataout, wire_nli1iO_dataout, n0lO1l);
	and(wire_nli10O_dataout, wire_nli1li_dataout, ~(n0lO1i));
	or(wire_nli11i_dataout, wire_nli10l_dataout, n0lOiO);
	or(wire_nli11l_dataout, wire_nli10O_dataout, n0lO1l);
	or(wire_nli11O_dataout, wire_nli1ii_dataout, n0lO1l);
	and(wire_nli1ii_dataout, wire_nli1ll_dataout, ~(n0lO1i));
	or(wire_nli1il_dataout, wire_nli1lO_dataout, n0lO1i);
	or(wire_nli1iO_dataout, wire_nli1Oi_dataout, n0lO1i);
	or(wire_nli1li_dataout, nlll1i, n0lO0i);
	and(wire_nli1ll_dataout, nlll1l, ~(n0lO0i));
	or(wire_nli1lO_dataout, nlll1O, n0lO0i);
	or(wire_nli1Oi_dataout, nlll0i, n0lO0i);
	and(wire_nli1Ol_dataout, wire_nli0ii_dataout, ~((~ n0ll1O)));
	and(wire_nli1OO_dataout, wire_nli0il_dataout, ~((~ n0ll1O)));
	and(wire_nlii_dataout, wire_n1l_dataout, n0OlOi);
	or(wire_nlii0i_dataout, wire_nliiil_dataout, n0ll0l);
	and(wire_nlii0l_dataout, wire_nliiiO_dataout, ~(n0ll0l));
	or(wire_nlii0O_dataout, wire_nl0OOi_dataout, ~(n0ll0O));
	or(wire_nlii1i_dataout, wire_nlii0l_dataout, n0llii);
	or(wire_nlii1l_dataout, wire_nlii0O_dataout, n0ll0l);
	and(wire_nlii1O_dataout, wire_nliiii_dataout, ~(n0ll0l));
	or(wire_nliiii_dataout, wire_nl0OOl_dataout, ~(n0ll0O));
	or(wire_nliiil_dataout, wire_nl0OOO_dataout, ~(n0ll0O));
	and(wire_nliiiO_dataout, wire_nli11i_dataout, n0ll0O);
	and(wire_nliill_dataout, wire_nlil1i_dataout, ~((~ n0llil)));
	or(wire_nliilO_dataout, nll00O, (~ n0llil));
	or(wire_nliiOi_dataout, nll0ii, (~ n0llil));
	or(wire_nliiOl_dataout, wire_nlil1l_dataout, (~ n0llil));
	or(wire_nliiOO_dataout, wire_nlil1O_dataout, (~ n0llil));
	and(wire_nlil_dataout, wire_n1O_dataout, n0OlOi);
	assign		wire_nlil0i_dataout = (n0OlOi === 1'b1) ? wire_nlilli_dataout : wire_nlilii_dataout;
	assign		wire_nlil0l_dataout = (n0OlOi === 1'b1) ? wire_nlilll_dataout : wire_nlilil_dataout;
	assign		wire_nlil0O_dataout = (n0OlOi === 1'b1) ? wire_nlillO_dataout : wire_nliliO_dataout;
	assign		wire_nlil1i_dataout = (n0lOiO === 1'b1) ? wire_nlilOi_dataout : wire_nlil0i_dataout;
	assign		wire_nlil1l_dataout = (n0lOiO === 1'b1) ? wire_nlilOl_dataout : wire_nlil0l_dataout;
	assign		wire_nlil1O_dataout = (n0lOiO === 1'b1) ? wire_nlilOO_dataout : wire_nlil0O_dataout;
	and(wire_nlilii_dataout, n0lliO, ~(n0llll));
	and(wire_nlilil_dataout, (~ n0lliO), ~(n0llll));
	or(wire_nliliO_dataout, n0lliO, n0llll);
	and(wire_nlilli_dataout, n0llll, ~(n0llli));
	and(wire_nlilll_dataout, (~ n0llll), ~(n0llli));
	or(wire_nlillO_dataout, n0llll, n0llli);
	assign		wire_nlilOi_dataout = (n0OlOi === 1'b1) ? wire_nliO0i_dataout : wire_nliO1i_dataout;
	assign		wire_nlilOl_dataout = (n0OlOi === 1'b1) ? wire_nliO0l_dataout : wire_nliO1l_dataout;
	assign		wire_nlilOO_dataout = (n0OlOi === 1'b1) ? wire_nliO0O_dataout : wire_nliO1O_dataout;
	and(wire_nliO_dataout, wire_n0i_dataout, n0OlOi);
	and(wire_nliO0i_dataout, n0llOl, ~(n0llOi));
	and(wire_nliO0l_dataout, (~ n0llOl), ~(n0llOi));
	or(wire_nliO0O_dataout, n0llOl, n0llOi);
	and(wire_nliO1i_dataout, n0lllO, ~(n0llOl));
	and(wire_nliO1l_dataout, (~ n0lllO), ~(n0llOl));
	or(wire_nliO1O_dataout, n0lllO, n0llOl);
	or(wire_nliOii_dataout, nll00O, (~ n0llOO));
	or(wire_nliOil_dataout, nll0ii, (~ n0llOO));
	and(wire_nliOiO_dataout, wire_nliOOi_dataout, ~(n0lOiO));
	and(wire_nliOli_dataout, wire_nliOOl_dataout, ~(n0lOiO));
	or(wire_nliOll_dataout, wire_nliOOO_dataout, n0lOiO);
	and(wire_nliOlO_dataout, wire_nll11i_dataout, ~(n0lOiO));
	or(wire_nliOOi_dataout, nlll1i, n0lOii);
	and(wire_nliOOl_dataout, nlll1l, ~(n0lOii));
	or(wire_nliOOO_dataout, nlll1O, n0lOii);
	assign		wire_nll10i_dataout = (n0lOil === 1'b1) ? (~ n0OlOi) : wire_nll1il_dataout;
	assign		wire_nll10l_dataout = (n0lOil === 1'b1) ? n0OlOi : wire_nll1iO_dataout;
	and(wire_nll10O_dataout, wire_nll1li_dataout, ~(n0lOil));
	and(wire_nll11i_dataout, nlll0i, ~(n0lOii));
	and(wire_nll11O_dataout, wire_nll1ii_dataout, ~(n0lOil));
	assign		wire_nll1ii_dataout = (n0lO0l === 1'b1) ? n0OlOi : wire_nll1ll_dataout;
	assign		wire_nll1il_dataout = (n0lO0l === 1'b1) ? (~ n0OlOi) : wire_nll1lO_dataout;
	assign		wire_nll1iO_dataout = (n0lO0l === 1'b1) ? n0OlOi : wire_nll1Oi_dataout;
	and(wire_nll1li_dataout, wire_nll1Ol_dataout, ~(n0lO0l));
	or(wire_nll1ll_dataout, nlll1i, n0lO1O);
	assign		wire_nll1lO_dataout = (n0lO1O === 1'b1) ? (~ n0OlOi) : nlll1l;
	assign		wire_nll1Oi_dataout = (n0lO1O === 1'b1) ? n0OlOi : nlll1O;
	and(wire_nll1Ol_dataout, nlll0i, ~(n0lO1O));
	and(wire_nlli_dataout, wire_n0l_dataout, n0OlOi);
	and(wire_nlll_dataout, wire_n0O_dataout, n0OlOi);
	and(wire_nlll0l_dataout, wire_nl011O_o, ~(rbist_clr_rx));
	and(wire_nlll0O_dataout, wire_nl011l_o, ~(rbist_clr_rx));
	assign		wire_nlllii_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[0] : wire_nlllOi_dataout;
	assign		wire_nlllil_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[1] : wire_nlllOl_dataout;
	assign		wire_nllliO_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[2] : wire_nlllOO_dataout;
	assign		wire_nlllli_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[3] : wire_nllO1i_dataout;
	assign		wire_nlllll_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[4] : wire_nllO1l_dataout;
	assign		wire_nllllO_dataout = (wire_nl1OOl_dataout === 1'b1) ? wire_nllO0i_o[5] : wire_nllO1O_dataout;
	and(wire_nlllOi_dataout, nll0iO, ~(wire_nl1OOO_dataout));
	and(wire_nlllOl_dataout, nll0li, ~(wire_nl1OOO_dataout));
	and(wire_nlllOO_dataout, nll0ll, ~(wire_nl1OOO_dataout));
	and(wire_nllO_dataout, wire_nii_dataout, n0OlOi);
	assign		wire_nllO0l_dataout = (wire_nl1OOi_dataout === 1'b1) ? wire_nllOil_o[0] : nll0OO;
	assign		wire_nllO0O_dataout = (wire_nl1OOi_dataout === 1'b1) ? wire_nllOil_o[1] : nlli1i;
	and(wire_nllO1i_dataout, nll0lO, ~(wire_nl1OOO_dataout));
	and(wire_nllO1l_dataout, nll0Oi, ~(wire_nl1OOO_dataout));
	and(wire_nllO1O_dataout, nll0Ol, ~(wire_nl1OOO_dataout));
	assign		wire_nllOii_dataout = (wire_nl1OOi_dataout === 1'b1) ? wire_nllOil_o[2] : nlli1l;
	and(wire_nllOiO_dataout, wire_nllOOi_dataout, ~(wire_nl1OlO_dataout));
	and(wire_nllOli_dataout, wire_nllOOl_dataout, ~(wire_nl1OlO_dataout));
	and(wire_nllOll_dataout, wire_nllOOO_dataout, ~(wire_nl1OlO_dataout));
	and(wire_nllOlO_dataout, wire_nlO11i_dataout, ~(wire_nl1OlO_dataout));
	assign		wire_nllOOi_dataout = (wire_nl1Oli_dataout === 1'b1) ? wire_nlO11l_o[0] : nlli1O;
	assign		wire_nllOOl_dataout = (wire_nl1Oli_dataout === 1'b1) ? wire_nlO11l_o[1] : nlli0i;
	assign		wire_nllOOO_dataout = (wire_nl1Oli_dataout === 1'b1) ? wire_nlO11l_o[2] : nlli0l;
	assign		wire_nlO00i_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[7] : nlliOl;
	assign		wire_nlO00l_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[8] : nlliOO;
	assign		wire_nlO01i_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[4] : nllill;
	assign		wire_nlO01l_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[5] : nllilO;
	assign		wire_nlO01O_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[6] : nlliOi;
	and(wire_nlO10i_dataout, wire_nlO1Oi_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO10l_dataout, wire_nlO1Ol_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO10O_dataout, wire_nlO1OO_dataout, ~(wire_nl1Oii_dataout));
	assign		wire_nlO11i_dataout = (wire_nl1Oli_dataout === 1'b1) ? wire_nlO11l_o[3] : nlli0O;
	and(wire_nlO11O_dataout, wire_nlO1lO_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO1ii_dataout, wire_nlO01i_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO1il_dataout, wire_nlO01l_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO1iO_dataout, wire_nlO01O_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO1li_dataout, wire_nlO00i_dataout, ~(wire_nl1Oii_dataout));
	and(wire_nlO1ll_dataout, wire_nlO00l_dataout, ~(wire_nl1Oii_dataout));
	assign		wire_nlO1lO_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[0] : nlliii;
	assign		wire_nlO1Oi_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[1] : nlliil;
	assign		wire_nlO1Ol_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[2] : nlliiO;
	assign		wire_nlO1OO_dataout = (wire_nl1Oil_dataout === 1'b1) ? wire_nlO00O_o[3] : nllili;
	and(wire_nlOi_dataout, wire_nil_dataout, n0OlOi);
	and(wire_nlOl_dataout, wire_niO_dataout, n0OlOi);
	and(wire_nlOO_dataout, wire_nli_dataout, n0OlOi);
	and(wire_nO_dataout, rbisten_rx, (((~ rbist_sel[0]) & (~ rbist_sel[1])) & (n0OO0i2 ^ n0OO0i1)));
	oper_add   niiOl
	( 
	.a({ni0li, ni0iO, ni0il, ni0ii, ni00O}),
	.b({{4{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niiOl_o));
	defparam
		niiOl.sgate_representation = 0,
		niiOl.width_a = 5,
		niiOl.width_b = 5,
		niiOl.width_o = 5;
	oper_add   niO0Ol
	( 
	.a({nil10i, nil11O, nil11l, nil11i, niiOOO, niiOOl, niiOOi}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niO0Ol_o));
	defparam
		niO0Ol.sgate_representation = 0,
		niO0Ol.width_a = 7,
		niO0Ol.width_b = 7,
		niO0Ol.width_o = 7;
	oper_add   niO0OO
	( 
	.a({niiOll, niiOli, niiOiO, niiOil, niiOii, niiO0O, niiO0l}),
	.b({{6{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niO0OO_o));
	defparam
		niO0OO.sgate_representation = 0,
		niO0OO.width_a = 7,
		niO0OO.width_b = 7,
		niO0OO.width_o = 7;
	oper_add   niOi1i
	( 
	.a({nil1Oi, nil1lO, nil1ll, nil1li, nil1iO, nil1il, nil1ii, nil10O, nil10l}),
	.b({{8{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_niOi1i_o));
	defparam
		niOi1i.sgate_representation = 0,
		niOi1i.width_a = 9,
		niOi1i.width_b = 9,
		niOi1i.width_o = 9;
	oper_add   nllO0i
	( 
	.a({nll0Ol, nll0Oi, nll0lO, nll0ll, nll0li, nll0iO}),
	.b({{5{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllO0i_o));
	defparam
		nllO0i.sgate_representation = 0,
		nllO0i.width_a = 6,
		nllO0i.width_b = 6,
		nllO0i.width_o = 6;
	oper_add   nllOil
	( 
	.a({nlli1l, nlli1i, nll0OO}),
	.b({{2{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nllOil_o));
	defparam
		nllOil.sgate_representation = 0,
		nllOil.width_a = 3,
		nllOil.width_b = 3,
		nllOil.width_o = 3;
	oper_add   nlO00O
	( 
	.a({nlliOO, nlliOl, nlliOi, nllilO, nllill, nllili, nlliiO, nlliil, nlliii}),
	.b({{8{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO00O_o));
	defparam
		nlO00O.sgate_representation = 0,
		nlO00O.width_a = 9,
		nlO00O.width_b = 9,
		nlO00O.width_o = 9;
	oper_add   nlO11l
	( 
	.a({nlli0O, nlli0l, nlli0i, nlli1O}),
	.b({{3{1'b0}}, 1'b1}),
	.cin(1'b0),
	.cout(),
	.o(wire_nlO11l_o));
	defparam
		nlO11l.sgate_representation = 0,
		nlO11l.width_a = 4,
		nlO11l.width_b = 4,
		nlO11l.width_o = 4;
	oper_decoder   n11li
	( 
	.i({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}),
	.o(wire_n11li_o));
	defparam
		n11li.width_i = 5,
		n11li.width_o = 32;
	oper_decoder   ni1iii
	( 
	.i({nil00O, nil00l, nil00i, nil01O}),
	.o(wire_ni1iii_o));
	defparam
		ni1iii.width_i = 4,
		ni1iii.width_o = 16;
	oper_decoder   nii0Ol
	( 
	.i({nil01l, nil01i, nil1OO, nil1Ol}),
	.o(wire_nii0Ol_o));
	defparam
		nii0Ol.width_i = 4,
		nii0Ol.width_o = 16;
	oper_decoder   nl1OiO
	( 
	.i({nlll0i, nlll1O, nlll1l, nlll1i}),
	.o(wire_nl1OiO_o));
	defparam
		nl1OiO.width_i = 4,
		nl1OiO.width_o = 16;
	oper_mux   n100i
	( 
	.data({{10{1'b0}}, wire_n10ll_dataout, {5{1'b0}}, wire_n1O0l_dataout, wire_n00iO_dataout, n0O00l, n0O00O, ((n0O11l38 ^ n0O11l37) & n0O0ii), n0O0il, n0O0iO, n0O0li, n0O0ll, wire_n0lOi_dataout, {3{1'b0}}, wire_n0Oil_dataout, wire_n0OOi_dataout, 1'b0}),
	.o(wire_n100i_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n100i.width_data = 32,
		n100i.width_sel = 5;
	oper_mux   n100l
	( 
	.data({{10{1'b0}}, wire_n10lO_dataout, ((n0O11O36 ^ n0O11O35) & wire_n1i1i_dataout), wire_n1iii_dataout, wire_n1ill_dataout, ((n0O10i34 ^ n0O10i33) & wire_n1iOO_dataout), wire_n1l0l_dataout, wire_n1O0O_dataout, wire_n00li_dataout, (~ n0O00l), (~ n0O00O), (~ n0O0ii), ((n0O10l32 ^ n0O10l31) & (~ n0O0il)), ((n0O10O30 ^ n0O10O29) & (~ n0O0iO)), (~ n0O0li), (~ n0O0ll), (~ n0O0lO), (~ n0O0Oi), (~ n0O0Ol), 1'b0, wire_n0OiO_dataout, wire_n0OOl_dataout, 1'b0}),
	.o(wire_n100l_o),
	.sel({((n0O1ii28 ^ n0O1ii27) & nii1i), ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n100l.width_data = 32,
		n100l.width_sel = 5;
	oper_mux   n101i
	( 
	.data({{10{1'b0}}, wire_n10il_dataout, {4{1'b1}}, wire_n1l0i_dataout, wire_n1O1l_dataout, wire_n000O_dataout, (~ n0O00l), wire_n0iii_dataout, (~ n0O0ii), wire_n0iOi_dataout, (~ n0O0iO), wire_n0l0l_dataout, (~ n0O0ll), wire_n0llO_dataout, (~ n0O0Oi), wire_n0O1O_dataout, 1'b0, wire_n0O0l_dataout, wire_n0Oli_dataout, (wire_ni_dataout & n11Oi)}),
	.o(wire_n101i_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n101i.width_data = 32,
		n101i.width_sel = 5;
	oper_mux   n101l
	( 
	.data({{10{1'b0}}, wire_n10iO_dataout, {5{1'b0}}, wire_n1O1O_dataout, wire_n00ii_dataout, n0O00l, wire_n0iil_dataout, 1'b0, wire_n0iOl_dataout, n0O0iO, wire_n0l0O_dataout, 1'b0, wire_n0lll_dataout, n0O0Oi, wire_n0O0i_dataout, 1'b0, wire_n0O0O_dataout, wire_n0Oll_dataout, 1'b0}),
	.o(wire_n101l_o),
	.sel({nii1i, ni0Ol, ni0Oi, ((n0lOOi46 ^ n0lOOi45) & ni0lO), ni0ll}));
	defparam
		n101l.width_data = 32,
		n101l.width_sel = 5;
	oper_mux   n101O
	( 
	.data({{10{1'b0}}, ((n0lOOl44 ^ n0lOOl43) & wire_n10li_dataout), wire_n1i1i_dataout, wire_n1iii_dataout, ((n0lOOO42 ^ n0lOOO41) & wire_n1ill_dataout), wire_n1iOO_dataout, wire_n1l0l_dataout, wire_n1O0i_dataout, ((n0O11i40 ^ n0O11i39) & wire_n00il_dataout), {3{1'b1}}, wire_n0iOO_dataout, (~ n0O0iO), (~ n0O0li), (~ n0O0ll), wire_n0llO_dataout, {3{1'b1}}, wire_n0Oii_dataout, wire_n0OlO_dataout, 1'b0}),
	.o(wire_n101O_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n101O.width_data = 32,
		n101O.width_sel = 5;
	oper_mux   n11Ol
	( 
	.data({{10{ni00i}}, wire_n100O_dataout, wire_n10OO_dataout, wire_n1i0O_dataout, wire_n1ili_dataout, wire_n1iOl_dataout, wire_n1l1O_dataout, wire_n1O1i_dataout, wire_n000l_dataout, wire_n0i0i_dataout, wire_n0i0O_dataout, wire_n0ili_dataout, wire_n0ilO_dataout, wire_n0l1l_dataout, wire_n0l0i_dataout, wire_n0lil_dataout, wire_n0lli_dataout, wire_n0lOO_dataout, wire_n0O1l_dataout, {4{ni00i}}}),
	.o(wire_n11Ol_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n11Ol.width_data = 32,
		n11Ol.width_sel = 5;
	oper_mux   n11OO
	( 
	.data({{10{ni01l}}, wire_n10ii_dataout, wire_n10Ol_dataout, wire_n1i0l_dataout, wire_n1iiO_dataout, wire_n1iOi_dataout, wire_n1l1l_dataout, wire_n1lOO_dataout, wire_n000i_dataout, wire_n0i1O_dataout, wire_n0i0l_dataout, wire_n0iiO_dataout, wire_n0ill_dataout, wire_n0l1i_dataout, wire_n0l1O_dataout, wire_n0lii_dataout, wire_n0liO_dataout, wire_n0lOl_dataout, wire_n0O1i_dataout, {4{ni01l}}}),
	.o(wire_n11OO_o),
	.sel({nii1i, ni0Ol, ni0Oi, ni0lO, ni0ll}));
	defparam
		n11OO.width_data = 32,
		n11OO.width_sel = 5;
	oper_mux   ni1iil
	( 
	.data({{3{1'b0}}, n0iO1l, wire_ni1O1i_dataout, n0iOil, wire_ni010O_dataout, n0iOOl, wire_ni000i_dataout, 1'b0, wire_ni0i1O_dataout, n0l1ll, wire_ni0l1i_dataout, n0l0ii, n0l0Ol, 1'b0}),
	.o(wire_ni1iil_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1iil.width_data = 16,
		ni1iil.width_sel = 4;
	oper_mux   ni1iiO
	( 
	.data({{2{niilOO}}, wire_ni1l1i_dataout, wire_ni1lil_dataout, wire_ni1lOO_dataout, {11{niilOO}}}),
	.o(wire_ni1iiO_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1iiO.width_data = 16,
		ni1iiO.width_sel = 4;
	oper_mux   ni1ili
	( 
	.data({{2{niiO1i}}, wire_ni1l1l_dataout, wire_ni1liO_dataout, wire_ni1O1l_dataout, wire_ni1OOl_dataout, wire_ni011l_dataout, wire_ni01Oi_dataout, wire_ni001i_dataout, wire_ni00ll_dataout, wire_ni00Ol_dataout, wire_ni0ili_dataout, wire_ni0iOi_dataout, wire_ni0lil_dataout, wire_ni0Oli_dataout, niiO1i}),
	.o(wire_ni1ili_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1ili.width_data = 16,
		ni1ili.width_sel = 4;
	oper_mux   ni1ill
	( 
	.data({{2{niiO1l}}, wire_ni1l1O_dataout, wire_ni1lli_dataout, wire_ni1O1O_dataout, wire_ni1OOO_dataout, wire_ni011O_dataout, wire_ni01Ol_dataout, wire_ni001l_dataout, wire_ni00lO_dataout, wire_ni00OO_dataout, wire_ni0ill_dataout, wire_ni0iOl_dataout, wire_ni0liO_dataout, wire_ni0Oll_dataout, niiO1l}),
	.o(wire_ni1ill_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1ill.width_data = 16,
		ni1ill.width_sel = 4;
	oper_mux   ni1ilO
	( 
	.data({{2{1'b0}}, wire_ni1l0i_dataout, 1'b1, wire_ni1O0i_dataout, 1'b1, wire_ni010i_dataout, 1'b1, wire_ni001O_dataout, 1'b1, wire_ni0i1i_dataout, 1'b1, wire_ni0iOO_dataout, wire_ni0lli_dataout, wire_ni0OlO_dataout, wire_nii00i_dataout}),
	.o(wire_ni1ilO_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1ilO.width_data = 16,
		ni1ilO.width_sel = 4;
	oper_mux   ni1iOi
	( 
	.data({{2{1'b0}}, wire_ni1l0l_dataout, {2{1'b0}}, (~ n0iOil), wire_ni010l_dataout, {2{1'b0}}, (~ n0l10l), wire_ni0i1l_dataout, {2{1'b0}}, wire_ni0lll_dataout, wire_ni0OOi_dataout, wire_nii00l_dataout}),
	.o(wire_ni1iOi_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1iOi.width_data = 16,
		ni1iOi.width_sel = 4;
	oper_mux   ni1iOl
	( 
	.data({{2{1'b0}}, wire_ni1l0O_dataout, wire_ni1lll_dataout, wire_ni1O0l_dataout, n0iOil, wire_ni010O_dataout, n0iOOl, wire_ni000i_dataout, {4{1'b1}}, wire_ni0llO_dataout, wire_ni0OOl_dataout, wire_nii00O_dataout}),
	.o(wire_ni1iOl_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1iOl.width_data = 16,
		ni1iOl.width_sel = 4;
	oper_mux   ni1iOO
	( 
	.data({{2{1'b0}}, wire_ni1lii_dataout, wire_ni1lll_dataout, wire_ni1O0l_dataout, {4{1'b1}}, n0l10l, wire_ni0i1O_dataout, n0l1ll, wire_ni0l1i_dataout, wire_ni0lOi_dataout, wire_ni0OOO_dataout, wire_nii0ii_dataout}),
	.o(wire_ni1iOO_o),
	.sel({nil00O, nil00l, nil00i, nil01O}));
	defparam
		ni1iOO.width_data = 16,
		ni1iOO.width_sel = 4;
	oper_mux   nii0iO
	( 
	.data({{4{1'b1}}, 1'b0, 1'b1, {7{1'b0}}, wire_niOi1l_dataout, {2{1'b1}}}),
	.o(wire_nii0iO_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		nii0iO.width_data = 16,
		nii0iO.width_sel = 4;
	oper_mux   nii0li
	( 
	.data({{3{1'b1}}, 1'b0, {2{1'b1}}, {7{1'b0}}, wire_niOi1O_dataout, {2{1'b1}}}),
	.o(wire_nii0li_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		nii0li.width_data = 16,
		nii0li.width_sel = 4;
	oper_mux   nii0lO
	( 
	.data({{5{1'b1}}, 1'b0, {7{1'b1}}, wire_niOi0l_dataout, {2{1'b1}}}),
	.o(wire_nii0lO_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		nii0lO.width_data = 16,
		nii0lO.width_sel = 4;
	oper_mux   nii0OO
	( 
	.data({{7{1'b1}}, {2{1'b0}}, 1'b1, 1'b0, 1'b1, 1'b0, wire_niOiii_dataout, {2{1'b1}}}),
	.o(wire_nii0OO_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		nii0OO.width_data = 16,
		nii0OO.width_sel = 4;
	oper_mux   niii0i
	( 
	.data({{3{n0OlOi}}, {3{1'b0}}, n0OlOi, {6{1'b0}}, wire_niOill_dataout, {2{n0OlOi}}}),
	.o(wire_niii0i_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii0i.width_data = 16,
		niii0i.width_sel = 4;
	oper_mux   niii0l
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, wire_niOilO_dataout, {2{n0OlOi}}}),
	.o(wire_niii0l_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii0l.width_data = 16,
		niii0l.width_sel = 4;
	oper_mux   niii0O
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, {3{1'b0}}, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, wire_niOiOi_dataout, {2{n0OlOi}}}),
	.o(wire_niii0O_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii0O.width_data = 16,
		niii0O.width_sel = 4;
	oper_mux   niii1i
	( 
	.data({{8{1'b1}}, 1'b0, {2{1'b1}}, {2{1'b0}}, wire_niOiil_dataout, {2{1'b1}}}),
	.o(wire_niii1i_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii1i.width_data = 16,
		niii1i.width_sel = 4;
	oper_mux   niii1l
	( 
	.data({{9{1'b1}}, {4{1'b0}}, wire_niOiiO_dataout, {2{1'b1}}}),
	.o(wire_niii1l_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii1l.width_data = 16,
		niii1l.width_sel = 4;
	oper_mux   niii1O
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, {6{1'b0}}, wire_niOili_dataout, {2{n0OlOi}}}),
	.o(wire_niii1O_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niii1O.width_data = 16,
		niii1O.width_sel = 4;
	oper_mux   niiiii
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, wire_niOiOl_dataout, {2{n0OlOi}}}),
	.o(wire_niiiii_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niiiii.width_data = 16,
		niiiii.width_sel = 4;
	oper_mux   niiiil
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, {3{1'b0}}, n0OlOi, 1'b0, n0OlOi, wire_niOiOO_dataout, {2{n0OlOi}}}),
	.o(wire_niiiil_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niiiil.width_data = 16,
		niiiil.width_sel = 4;
	oper_mux   niiiiO
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, {2{1'b0}}, wire_niOl1i_dataout, {2{n0OlOi}}}),
	.o(wire_niiiiO_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niiiiO.width_data = 16,
		niiiiO.width_sel = 4;
	oper_mux   niiili
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, {4{1'b0}}, wire_niOl1l_dataout, {2{n0OlOi}}}),
	.o(wire_niiili_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niiili.width_data = 16,
		niiili.width_sel = 4;
	oper_mux   niiill
	( 
	.data({{3{n0OlOi}}, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, n0OlOi, 1'b0, {2{n0OlOi}}}),
	.o(wire_niiill_o),
	.sel({nil01l, nil01i, nil1OO, nil1Ol}));
	defparam
		niiill.width_data = 16,
		niiill.width_sel = 4;
	oper_mux   nl010i
	( 
	.data({wire_nl01li_dataout, {4{1'b1}}, wire_nl0i0l_dataout, (~ n0liOl), wire_nl0l1O_dataout, wire_nl0llO_dataout, wire_nli01O_dataout, wire_nliiOl_dataout, {2{1'b1}}, wire_nliOiO_dataout, wire_nll11O_dataout, (wire_nl_dataout & nl1Oll)}),
	.o(wire_nl010i_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl010i.width_data = 16,
		nl010i.width_sel = 4;
	oper_mux   nl010l
	( 
	.data({wire_nl01ll_dataout, wire_nl001l_dataout, wire_nl00il_dataout, wire_nl00lO_dataout, wire_nl0i1i_dataout, wire_nl0i0O_dataout, (~ n0liOl), wire_nl0l1O_dataout, wire_nl0lOi_dataout, wire_nli00i_dataout, wire_nliiOO_dataout, (~ n0llOO), 1'b0, wire_nliOli_dataout, wire_nll10i_dataout, 1'b0}),
	.o(wire_nl010l_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl010l.width_data = 16,
		nl010l.width_sel = 4;
	oper_mux   nl010O
	( 
	.data({wire_nl01lO_dataout, wire_nl001l_dataout, wire_nl00il_dataout, wire_nl00lO_dataout, wire_nl0i1i_dataout, wire_nl0i0O_dataout, (~ n0liOl), wire_nl0l1O_dataout, wire_nl0lOl_dataout, wire_nli00l_dataout, {3{1'b1}}, wire_nliOll_dataout, wire_nll10l_dataout, 1'b0}),
	.o(wire_nl010O_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl010O.width_data = 16,
		nl010O.width_sel = 4;
	oper_mux   nl011i
	( 
	.data({nll0il, wire_nl01Ol_dataout, wire_nl000l_dataout, wire_nl00iO_dataout, wire_nl00Oi_dataout, wire_nl0i1l_dataout, {10{nll0il}}}),
	.o(wire_nl011i_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl011i.width_data = 16,
		nl011i.width_sel = 4;
	oper_mux   nl011l
	( 
	.data({wire_nl01il_dataout, wire_nl001i_dataout, wire_nl00ii_dataout, wire_nl00ll_dataout, wire_nl00OO_dataout, wire_nl0i0i_dataout, wire_nl0lil_dataout, wire_nl0l1l_dataout, wire_nl0lll_dataout, wire_nli01l_dataout, wire_nliiOi_dataout, wire_nliOil_dataout, {4{nll0ii}}}),
	.o(wire_nl011l_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl011l.width_data = 16,
		nl011l.width_sel = 4;
	oper_mux   nl011O
	( 
	.data({wire_nl01iO_dataout, wire_nl01OO_dataout, wire_nl000O_dataout, wire_nl00li_dataout, wire_nl00Ol_dataout, wire_nl0i1O_dataout, wire_nl0lii_dataout, wire_nl0l1i_dataout, wire_nl0lli_dataout, wire_nli01i_dataout, wire_nliilO_dataout, wire_nliOii_dataout, {4{nll00O}}}),
	.o(wire_nl011O_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl011O.width_data = 16,
		nl011O.width_sel = 4;
	oper_mux   nl01ii
	( 
	.data({wire_nl01Oi_dataout, wire_nl001l_dataout, wire_nl00il_dataout, wire_nl00lO_dataout, wire_nl0i1i_dataout, wire_nl0i0O_dataout, 1'b1, wire_nl0l0i_dataout, wire_nl0lOO_dataout, wire_nli00O_dataout, (~ n0llil), (~ n0llOO), 1'b0, wire_nliOlO_dataout, wire_nll10O_dataout, 1'b0}),
	.o(wire_nl01ii_o),
	.sel({nlll0i, nlll1O, nlll1l, nlll1i}));
	defparam
		nl01ii.width_data = 16,
		nl01ii.width_sel = 4;
	oper_selector   n11ii
	( 
	.data({1'b0, wire_n1lOi_dataout, wire_n001l_dataout}),
	.o(wire_n11ii_o),
	.sel({n0lOll, wire_n11li_o[15:14]}));
	defparam
		n11ii.width_data = 3,
		n11ii.width_sel = 3;
	oper_selector   n11il
	( 
	.data({1'b0, wire_n1lOl_dataout, wire_n001O_dataout}),
	.o(wire_n11il_o),
	.sel({n0lOll, wire_n11li_o[15:14]}));
	defparam
		n11il.width_data = 3,
		n11il.width_sel = 3;
	oper_selector   n11ll
	( 
	.data({ni00l, wire_n10Oi_dataout, wire_n1i0i_dataout, wire_n1iil_dataout, wire_n1ilO_dataout, wire_n1l1i_dataout}),
	.o(wire_n11ll_o),
	.sel({n0lOlO, wire_n11li_o[20:16]}));
	defparam
		n11ll.width_data = 6,
		n11ll.width_sel = 6;
	oper_selector   ni1i0l
	( 
	.data({1'b0, 1'b1, wire_ni0OiO_dataout}),
	.o(wire_ni1i0l_o),
	.sel({n0iO1i, wire_ni1iii_o[2:1]}));
	defparam
		ni1i0l.width_data = 3,
		ni1i0l.width_sel = 3;
	assign
		bistdone = ((wire_nl1l_dataout | prbs_done) | (~ (n0Ol0O10 ^ n0Ol0O9))),
		bisterr = ((wire_nl1i_dataout | prbs_err) | (~ (n0Olil8 ^ n0Olil7))),
		cur_state = {wire_n1OO_dataout, wire_n1Ol_dataout, wire_n1Oi_dataout, wire_n1lO_dataout, wire_n1ll_dataout},
		err_ctl = {wire_niOO_dataout, wire_niOl_dataout},
		err_data = {wire_niOi_dataout, wire_nilO_dataout, wire_nill_dataout, wire_nili_dataout, wire_niiO_dataout, wire_niil_dataout, wire_niii_dataout, wire_ni0O_dataout, wire_ni0l_dataout, wire_ni0i_dataout, wire_ni1O_dataout, wire_ni1l_dataout, wire_ni1i_dataout, wire_n0OO_dataout, wire_n0Ol_dataout, wire_n0Oi_dataout},
		n0iO0i = ((~ n0iO0l) | (~ n0l1Ol)),
		n0iO0l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iO0O = ((~ n0iOii) | (~ n0l01l)),
		n0iO1i = (((((((((((((wire_ni1iii_o[15] | wire_ni1iii_o[14]) | wire_ni1iii_o[13]) | wire_ni1iii_o[12]) | wire_ni1iii_o[11]) | wire_ni1iii_o[10]) | wire_ni1iii_o[9]) | wire_ni1iii_o[8]) | wire_ni1iii_o[7]) | wire_ni1iii_o[6]) | wire_ni1iii_o[5]) | wire_ni1iii_o[4]) | wire_ni1iii_o[3]) | wire_ni1iii_o[0]),
		n0iO1l = ((~ n0iO1O) | (~ n0l1Ol)),
		n0iO1O = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOii = (((((((((((((((wire_nlOO_dataout & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & wire_nlil_dataout) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOil = ((~ n0iOiO) | (~ n0l1Ol)),
		n0iOiO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOli = ((~ n0iOll) | (~ n0l1Ol)),
		n0iOll = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOlO = ((~ n0iOOi) | (~ n0l01l)),
		n0iOOi = (((((((((((((((wire_nlOO_dataout & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & (~ wire_nlll_dataout)) & wire_nlli_dataout) & wire_nliO_dataout) & wire_nlil_dataout) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0iOOl = ((~ n0iOOO) | (~ n0l1Ol)),
		n0iOOO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & rxd[7]),
		n0l00i = (((((((nil1lO & nil1ll) & nil1li) & nil1iO) & nil1il) & nil1ii) & nil10O) & nil10l),
		n0l00l = (n0OlOi & n0l00O),
		n0l00O = (((((((niiOll & niiOli) & niiOiO) & niiOil) & niiOii) & niiO0O) & niiO0l) & niiO0i),
		n0l01i = ((~ n0l01O) | (~ n0l01l)),
		n0l01l = (wire_nlii_dataout & rxc[0]),
		n0l01O = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0l0ii = ((~ n0l0il) | (~ ((~ wire_nlii_dataout) & (~ rxc[0])))),
		n0l0il = ((((((((((((((((~ (rxd[0] ^ wire_niOi1l_dataout)) & (~ (rxd[1] ^ wire_niOi1O_dataout))) & (~ (rxd[2] ^ wire_niOi0i_dataout))) & (~ (rxd[3] ^ wire_niOi0l_dataout))) & (~ (rxd[4] ^ wire_niOi0O_dataout))) & (~ (rxd[5] ^ wire_niOiii_dataout))) & (~ (rxd[6] ^ wire_niOiil_dataout))) & (~ (rxd[7] ^ wire_niOiiO_dataout))) & (~ (wire_nlil_dataout ^ wire_niOili_dataout))) & (~ (wire_nliO_dataout ^ wire_niOill_dataout))) & (~ (wire_nlli_dataout ^ wire_niOilO_dataout))) & (~ (wire_nlll_dataout ^ wire_niOiOi_dataout))) & (~ (wire_nllO_dataout ^ wire_niOiOl_dataout))) & (~ (wire_nlOi_dataout ^ wire_niOiOO_dataout))) & (~ (wire_nlOl_dataout ^ wire_niOl1i_dataout))) & (~ (wire_nlOO_dataout ^ wire_niOl1l_dataout))),
		n0l0iO = ((~ n0OlOi) & (rxc[0] & n0l0li)),
		n0l0li = (((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0l0ll = (n0OlOi & ((wire_nlii_dataout & n0l0Oi) & (rxc[0] & n0l0lO))),
		n0l0lO = ((((((((~ rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]),
		n0l0Oi = (((((((wire_nlOO_dataout & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & (~ wire_nlli_dataout)) & wire_nliO_dataout) & wire_nlil_dataout),
		n0l0Ol = (((~ n0OlOi) & n0li1i) | (n0OlOi & n0l0OO)),
		n0l0OO = ((((((((nil1Oi & (~ nil1lO)) & (~ nil1ll)) & (~ nil1li)) & (~ nil1iO)) & (~ nil1il)) & (~ nil1ii)) & (~ nil10O)) & (~ nil10l)),
		n0l10i = (((((((((((((((wire_nlOO_dataout & wire_nlOl_dataout) & (~ wire_nlOi_dataout)) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]),
		n0l10l = ((~ n0l10O) | (~ n0l1Ol)),
		n0l10O = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & (~ rxd[7])),
		n0l11i = ((~ n0l11l) | (~ n0l1Ol)),
		n0l11l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]),
		n0l11O = ((~ n0l10i) | (~ n0l01l)),
		n0l1ii = ((~ n0l1il) | (~ n0l1Ol)),
		n0l1il = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0l1iO = ((~ n0l1li) | (~ n0l01l)),
		n0l1li = ((((((((((((((((~ wire_nlOO_dataout) & wire_nlOl_dataout) & wire_nlOi_dataout) & wire_nllO_dataout) & wire_nlll_dataout) & wire_nlli_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0l1ll = ((~ n0l1lO) | (~ n0l1Ol)),
		n0l1lO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & (~ rxd[7])),
		n0l1Oi = ((~ n0l1OO) | (~ n0l1Ol)),
		n0l1Ol = ((~ wire_nlii_dataout) & rxc[0]),
		n0l1OO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0li0i = ((~ rxc[0]) | (~ n0li0l)),
		n0li0l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0li0O = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0li1i = ((((((((nil1Oi & (~ nil1lO)) & (~ nil1ll)) & nil1li) & (~ nil1iO)) & (~ nil1il)) & (~ nil1ii)) & (~ nil10O)) & nil10l),
		n0li1l = (wire_nO_dataout & rxd[10]),
		n0liii = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0liil = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & rxd[7]) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0liiO = ((~ n0lili) | (~ (wire_nlii_dataout & (~ rxc[0])))),
		n0lili = ((((((((((((((((~ wire_nliO_dataout) & rxd[0]) & (~ rxd[1])) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0lill = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nlll_dataout)) & (~ wire_nliO_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0lilO = ((((((~ nll0Ol) & nll0Oi) & (~ nll0lO)) & (~ nll0ll)) & nll0li) & nll0iO),
		n0liOi = (((((nll0Ol & (~ nll0Oi)) & (~ nll0lO)) & nll0ll) & nll0li) & nll0iO),
		n0liOl = ((((((((((((((((~ wire_nlOl_dataout) & (~ wire_nllO_dataout)) & (~ wire_nlli_dataout)) & rxd[5]) & rxd[7]) & (~ ((~ n0OlOi) ^ rxd[0]))) & (~ ((~ n0OlOi) ^ rxd[1]))) & (~ (n0OlOi ^ rxd[2]))) & (~ ((~ n0OlOi) ^ rxd[3]))) & (~ (n0OlOi ^ rxd[4]))) & (~ (n0OlOi ^ rxd[6]))) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0liOO = ((((((((((((((((~ wire_nlll_dataout) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & rxd[5]) & rxd[6]) & rxd[7]) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0ll0i = ((((~ nlli0O) & (~ nlli0l)) & nlli0i) & (~ nlli1O)),
		n0ll0l = ((((~ nlli0O) & nlli0l) & nlli0i) & nlli1O),
		n0ll0O = (((nlli0O & nlli0l) & nlli0i) & nlli1O),
		n0ll1i = (((~ nlli1l) & nlli1i) & nll0OO),
		n0ll1l = ((nlli1l & nlli1i) & nll0OO),
		n0ll1O = ((((((((((((((((~ wire_nllO_dataout) & (~ wire_nlli_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0llii = (((((~ nlli0O) & (~ nlli0l)) & nlli0i) & nlli1O) | (((nlli0O & (~ nlli0l)) & nlli0i) & nlli1O)),
		n0llil = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlil_dataout)) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))),
		n0lliO = ((((((((nlliOO & (~ nlliOl)) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & nlliiO) & nlliil) & nlliii),
		n0llli = (((((((((~ nlliOO) & (~ nlliOl)) & nlliOi) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & (~ nlliil)) & nlliii),
		n0llll = (((((((((~ nlliOO) & nlliOl) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & nlliil) & nlliii),
		n0lllO = ((((((((nlliOO & (~ nlliOl)) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & nlliiO) & nlliil) & (~ nlliii)),
		n0llOi = (((((((((~ nlliOO) & (~ nlliOl)) & nlliOi) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & (~ nlliil)) & (~ nlliii)),
		n0llOl = (((((((((~ nlliOO) & nlliOl) & (~ nlliOi)) & (~ nllilO)) & (~ nllill)) & (~ nllili)) & (~ nlliiO)) & nlliil) & (~ nlliii)),
		n0llOO = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & (~ rxd[4])) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))),
		n0lO0i = (rcxpat_chnl_sel[0] & rcxpat_chnl_sel[1]),
		n0lO0l = (n0lOii & n0lO0O),
		n0lO0O = (((((((rxd[0] & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0lO1i = ((~ rcxpat_chnl_sel[0]) & rcxpat_chnl_sel[1]),
		n0lO1l = (rcxpat_chnl_sel[0] & (~ rcxpat_chnl_sel[1])),
		n0lO1O = (n0lO0O & n0lO0i),
		n0lOii = (n0lO1l | n0lO1i),
		n0lOil = (rxc[0] & (n0lOli & n0lOiO)),
		n0lOiO = ((~ rcxpat_chnl_sel[0]) & (~ rcxpat_chnl_sel[1])),
		n0lOli = (((((((rxd[0] & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0lOll = (((((((((((((((((((((((((((((wire_n11li_o[31] | wire_n11li_o[30]) | wire_n11li_o[29]) | wire_n11li_o[28]) | wire_n11li_o[27]) | wire_n11li_o[26]) | wire_n11li_o[25]) | wire_n11li_o[24]) | wire_n11li_o[23]) | wire_n11li_o[22]) | wire_n11li_o[21]) | wire_n11li_o[20]) | wire_n11li_o[19]) | wire_n11li_o[18]) | wire_n11li_o[17]) | wire_n11li_o[16]) | wire_n11li_o[13]) | wire_n11li_o[12]) | wire_n11li_o[11]) | wire_n11li_o[10]) | wire_n11li_o[9]) | wire_n11li_o[8]) | wire_n11li_o[7]) | wire_n11li_o[6]) | wire_n11li_o[5]) | wire_n11li_o[4]) | wire_n11li_o[3]) | wire_n11li_o[2]) | wire_n11li_o[1]) | wire_n11li_o[0]),
		n0lOlO = ((((((((((((((((((((((((((wire_n11li_o[31] | wire_n11li_o[30]) | wire_n11li_o[29]) | wire_n11li_o[28]) | wire_n11li_o[27]) | wire_n11li_o[26]) | wire_n11li_o[25]) | wire_n11li_o[24]) | wire_n11li_o[23]) | wire_n11li_o[22]) | wire_n11li_o[21]) | wire_n11li_o[15]) | wire_n11li_o[14]) | wire_n11li_o[13]) | wire_n11li_o[12]) | wire_n11li_o[11]) | wire_n11li_o[10]) | wire_n11li_o[9]) | wire_n11li_o[8]) | wire_n11li_o[7]) | wire_n11li_o[6]) | wire_n11li_o[5]) | wire_n11li_o[4]) | wire_n11li_o[3]) | wire_n11li_o[2]) | wire_n11li_o[1]) | wire_n11li_o[0]),
		n0O00i = ((((ni0li & ni0iO) & ni0il) & ni0ii) & (~ ni00O)),
		n0O00l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]),
		n0O00O = ((((((((((((((((~ wire_nlli_dataout) & (~ rxd[0])) & rxd[1]) & rxd[2]) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nliO_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0O01i = ((((((((((((((((~ wire_nliO_dataout) & (~ rxd[0])) & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & rxd[5]) & rxd[6]) & rxd[7]) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOi_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))) & (~ (n0OlOi ^ wire_nlOO_dataout))),
		n0O01l = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & (~ rxd[1])) & (~ rxd[2])) & rxd[3]) & rxd[4]) & (~ rxd[5])) & rxd[6]) & (~ rxd[7])),
		n0O01O = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOi_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & rxd[0]) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & (~ rxd[7])) & (~ (n0OlOi ^ wire_nlil_dataout))) & (~ (n0OlOi ^ wire_nlll_dataout))) & (~ (n0OlOi ^ wire_nllO_dataout))) & (~ (n0OlOi ^ wire_nlOl_dataout))),
		n0O0ii = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nllO_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nlli_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & (~ rxd[0])) & (~ rxd[1])) & rxd[2]) & (~ rxd[3])) & rxd[4]) & (~ rxd[5])) & (~ rxd[6])) & (~ rxd[7])),
		n0O0il = ((((((((((((((((~ wire_nlOO_dataout) & (~ wire_nlOl_dataout)) & (~ wire_nlOi_dataout)) & (~ wire_nlll_dataout)) & (~ wire_nliO_dataout)) & (~ wire_nlil_dataout)) & rxd[0]) & rxd[1]) & (~ rxd[2])) & (~ rxd[3])) & rxd[4]) & rxd[5]) & (~ rxd[6])) & rxd[7]) & (~ (n0OlOi ^ wire_nlli_dataout))) & (~ (n0OlOi ^ wire_nll